/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.initbill;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.business.service.repay.RepayServiceHelper;
import kd.tmc.cfm.common.enums.InitStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BondLimitHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.cfm.common.helper.RepaymentbillHelper;
import kd.tmc.cfm.common.operate.RepaymentBillOperate;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBillDisEndInitService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(InitBillDisEndInitService.class);
    private static final String[] DRAW_PROPS = new String[]{"id", "creditlimit", "billno", "repayplan_entry.id", "interest_entry.id", "interest_entry.interest_subentry.id", "e_creditlimit"};
    private static final String[] LOAN_PROPS = new String[]{"billno", "id"};
    private static final String[] PAY_INIT_PROPS = new String[]{"id", "billno", "entrys.id"};
    private static final String[] EXPEND_PROPS = new String[]{"id", "billno", "loanbilllist.id"};
    private static final String[] REPAY_PROPS = new String[]{"loans", "loantype", "loans.e_loanbill", "billno", "datasource"};
    private static final String LoanFields = "id,loancontractbill,creditlimit,billno,currency";
    private static final String bondFields = "id,investor_entry.e_creditlimit";

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billstatus");
        sic.add("loanentry");
        sic.add("gmsubentry");
        sic.add("gmsubentry.gcreditguarantee");
        sic.add("loanentry.repayamount");
        sic.add("loanentry.drawamount");
        sic.add("loanentry.loanbillno");
        sic.add("loanentry.occupybondlimit");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        DynamicObject[] contractDelBills;
        ArrayList<Long> initPkList = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject initBill : dataEntities) {
            initPkList.add((Long)initBill.getPkValue());
            initBill.set("initstatus", (Object)InitStatusEnum.INITING.getValue());
            initBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        DynamicObjectCollection contractBills = QueryServiceHelper.query((String)"cfm_loancontractbill", (String)String.join((CharSequence)",", LOAN_PROPS), (QFilter[])new QFilter[]{new QFilter("initid", "in", initPkList)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)contractBills)) {
            return;
        }
        ArrayList<Long> contractPkList = new ArrayList<Long>(contractBills.size());
        for (DynamicObject contractBill : contractBills) {
            contractPkList.add(contractBill.getLong("id"));
        }
        String loanBillEntity = EmptyUtil.isNoEmpty((Object[])dataEntities) && "cfm_initbill_bond".equals(dataEntities[0].getDataEntityType().getName()) ? "cfm_loanbill_bond" : "cfm_loanbill";
        Object[] loanBills = TmcDataServiceHelper.load((String)loanBillEntity, (String)String.join((CharSequence)",", DRAW_PROPS), (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", contractPkList)});
        DynamicObject[] repaymentBills = null;
        DynamicObjectCollection interestBills = null;
        if (!EmptyUtil.isEmpty((Object[])loanBills)) {
            ArrayList<Long> loanPkList = new ArrayList<Long>(loanBills.length);
            for (Object loanBill : loanBills) {
                loanPkList.add((Long)loanBill.getPkValue());
            }
            repaymentBills = TmcDataServiceHelper.load((String)"cfm_repaymentbill", (String)String.join((CharSequence)",", REPAY_PROPS), (QFilter[])new QFilter[]{new QFilter("loans.e_loanbill", "in", loanPkList)});
            interestBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)String.join((CharSequence)",", PAY_INIT_PROPS), (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", loanPkList)});
        }
        DynamicObjectCollection extendBills = QueryServiceHelper.query((String)"cfm_contractextendbill", (String)String.join((CharSequence)",", EXPEND_PROPS), (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", contractPkList)});
        OperateOption create = OperateOption.create();
        create.setVariableValue("byInit", "true");
        if (!EmptyUtil.isEmpty(interestBills)) {
            HashSet<Long> interestPks = new HashSet<Long>(interestBills.size());
            for (DynamicObject interestBill : interestBills) {
                interestPks.add(interestBill.getLong("id"));
            }
            DynamicObject[] interestDelBills = TmcDataServiceHelper.load((Object[])interestPks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_interestbill"));
            if ("ifm_initbill".equals(dataEntities[0].getDynamicObjectType().getName())) {
                QFilter filter = new QFilter("entry.intbillid", "in", interestPks);
                DynamicObject[] batchIntBills = TmcDataServiceHelper.load((String)"ifm_intbill_batch_loan", (String)"id", (QFilter[])filter.toArray());
                TmcOperateServiceHelper.execOperate((String)"deleteinit", (String)"ifm_intbill_batch_loan", (DynamicObject[])batchIntBills, (OperateOption)create);
            }
            TmcOperateServiceHelper.execOperate((String)"deleteinit", (String)"cfm_interestbill", (DynamicObject[])interestDelBills, (OperateOption)create);
        }
        if (!EmptyUtil.isEmpty(repaymentBills)) {
            for (DynamicObject repaymentBill : repaymentBills) {
                this.cancelReturnCreditLimit(repaymentBill);
            }
            HashSet<Long> repaymentPks = new HashSet<Long>(repaymentBills.length);
            for (DynamicObject repaymentBill : repaymentBills) {
                repaymentPks.add((Long)repaymentBill.getPkValue());
            }
            RepaymentbillHelper.cancelReturnGuaranteeUse((DynamicObject[])repaymentBills);
            DynamicObject[] repaymentDelBills = TmcDataServiceHelper.load((Object[])repaymentPks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_repaymentbill"));
            logger.info("---delete repaymentDelBills--------------" + repaymentDelBills.length);
            RepaymentBillOperate.deleteinit((DynamicObject[])repaymentDelBills, (OperateOption)create);
        }
        if (!EmptyUtil.isEmpty((Object[])loanBills)) {
            DynamicObject[] loanDelBills;
            for (Object loanBill : loanBills) {
                this.cancelCreditLimit((DynamicObject)loanBill);
            }
            HashSet<Long> loanPks = new HashSet<Long>(loanBills.length);
            for (Object loanBill : loanBills) {
                loanPks.add((Long)loanBill.getPkValue());
            }
            if ("cfm_initbill_bond".equals(dataEntities[0].getDynamicObjectType().getName())) {
                for (DynamicObject loanDelBill : loanDelBills = TmcDataServiceHelper.load((Object[])loanPks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_loanbill_bond"))) {
                    BondLimitHelper.changeLimitOnInitBillBondReverseInit((DynamicObject)loanDelBill);
                }
            } else {
                loanDelBills = TmcDataServiceHelper.load((Object[])loanPks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_loanbill"));
            }
            logger.info("---delete loanDelBills--------------" + loanDelBills.length);
            TmcOperateServiceHelper.execOperate((String)"deleteinit", (String)"cfm_loanbill", (DynamicObject[])loanDelBills, (OperateOption)create);
        }
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)extendBills)) {
            HashSet<Long> extendPks = new HashSet<Long>(extendBills.size());
            for (DynamicObject extendBill : extendBills) {
                extendPks.add(extendBill.getLong("id"));
            }
            DynamicObject[] extendDelBills = TmcDataServiceHelper.load((Object[])extendPks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_contractextendbill"));
            logger.info("---delete extendDelBills--------------" + extendDelBills.length);
            TmcOperateServiceHelper.execOperate((String)"deleteinit", (String)"cfm_contractextendbill", (DynamicObject[])extendDelBills, (OperateOption)create);
        }
        for (DynamicObject contractDelBill : contractDelBills = TmcDataServiceHelper.load((Object[])contractPkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_loancontractbill"))) {
            CreditLimitHelper.creditBizUnAudit((DynamicObject)contractDelBill);
        }
        logger.info("---delete contractDelBills--------------" + contractDelBills.length);
        TmcOperateServiceHelper.execOperate((String)"deleteinit", (String)"cfm_loancontractbill", (DynamicObject[])contractDelBills, (OperateOption)create);
    }

    private void cancelReturnCreditLimit(DynamicObject repay) {
        DynamicObjectCollection loanEntrys = repay.getDynamicObjectCollection("loans");
        boolean isBond = LoanTypeEnum.isBond((String)repay.getString("loantype"));
        for (DynamicObject loanEntry : loanEntrys) {
            Long loanBillId = loanEntry.getDynamicObject("e_loanbill").getLong("id");
            String entityName = isBond ? "cfm_loanbill_bond" : "cfm_loanbill";
            DynamicObject loanBill = TmcDataServiceHelper.loadSingle((Object)loanBillId, (String)entityName, (String)(isBond ? bondFields : LoanFields));
            if (isBond) {
                if (!CreditLimitHelper.isEntryCredit((DynamicObject)loanBill, (String)"investor_entry", (String)"e_creditlimit")) continue;
                RepayServiceHelper.batchCancelReturnCreditLimit((DynamicObject)repay);
                continue;
            }
            if (EmptyUtil.isNoEmpty((Object)loanBill.get("creditlimit"))) {
                CreditLimitServiceHelper.cancelReturnCreditLimit((DynamicObject)repay, (DynamicObject)loanBill, (boolean)false, null, (Long)repay.getLong("id"));
                continue;
            }
            if (!CreditLimitHelper.isEntryCredit((DynamicObject)this.queryLoanContractBill(loanBill), (String)"banksyndicate_entry", (String)"e_creditlimit")) continue;
            RepayServiceHelper.batchCancelReturnCreditLimit((DynamicObject)repay);
        }
    }

    private DynamicObject queryLoanContractBill(DynamicObject loanBill) {
        DynamicObject[] loanConArr = TmcDataServiceHelper.load((String)"cfm_loancontractbill", (String)String.join((CharSequence)",", "e_shareamount", "e_creditlimit"), (QFilter[])new QFilter[]{new QFilter("id", "=", loanBill.getDynamicObject("loancontractbill").getPkValue())});
        return loanConArr[0];
    }

    private void cancelCreditLimit(DynamicObject loanBill) {
        DynamicObjectCollection investEntrys;
        long investLimit;
        if (EmptyUtil.isNoEmpty((DynamicObject)loanBill.getDynamicObject("creditlimit"))) {
            CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)loanBill, null, (boolean)false);
        }
        if ("cfm_loanbill_bond".equals(loanBill.getDynamicObjectType().getName()) && (investLimit = (investEntrys = loanBill.getDynamicObjectCollection("investor_entry")).stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_creditlimit"))).count()) > 0L) {
            CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)loanBill, null, (boolean)false);
        }
    }
}

