/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.loanbill;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.DrawWayEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.enums.SettleCenterStatusEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.repository.LoanContractBillRepository;
import kd.tmc.cfm.common.repository.bean.ContractBillAmountSumDTO;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(20);
        sic.add("contractbillno");
        sic.add("drawtype");
        sic.add("ratedeadline");
        sic.add("ratesign");
        sic.add("ratefloatpoint");
        sic.add("rateadjuststyle");
        sic.add("rateadjustdate");
        sic.add("rateadjustcycle");
        sic.add("rateadjustcycletype");
        sic.add("renewalinterestrate");
        sic.add("amount");
        sic.add("drawamount");
        sic.add("notdrawamount");
        sic.add("interesttype");
        sic.add("referencerate");
        sic.add("clientorg");
        sic.add("repaymentway");
        sic.add("stageplan");
        sic.add("ratetype");
        sic.add("renewalinteresttype");
        sic.add("renewalexpiredate");
        sic.add("expiredate");
        sic.add("bizdate");
        sic.add("datasource");
        sic.add("loantype");
        sic.add("loaneracctbank");
        sic.add("accountbank");
        sic.add("productfactory");
        sic.add("creditortype");
        sic.add("ratehistory_entry");
        sic.add("createtime");
        sic.add("isinit");
        sic.add("loancontractbill");
        sic.add("interestsettledplan");
        sic.add("startintdate");
        sic.add("loantype");
        sic.add("startloanrate");
        sic.add("loanrate");
        sic.add("exdrawamount");
        sic.add("sourcebillid");
        sic.add("drawway");
        sic.add("settleintmode");
        sic.add("currency");
        sic.add("iscycleloan");
        sic.add("underwriter_entry");
        sic.add("interest_entry.seq");
        sic.add("interest_entry.interestseq");
        sic.add("interest_entry.interesdate");
        sic.add("underwriter_entry.e_underwritertype");
        sic.add("underwriter_entry.e_isbookrunner");
        sic.add("underwriter_entry.e_underwriteratio");
        sic.add("underwriter_entry.e_underwriteamount");
        sic.add("underwriter_entry.e_underwriter");
        sic.add("eassrcid");
        sic.add("banksyndicate_entry.e_shareamount");
        sic.add("issofrrate");
        sic.add("iscallcompint");
        sic.add("intcalmethod");
        sic.add("workcalendar");
        sic.add("rateresetadjustrule");
        sic.add("drawapplybill");
        sic.add("payedintamount");
        sic.add("settleintmode");
        sic.add("convertdrawamt");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        if ("true".equals(this.getOption().getVariableValue("byInit", "false"))) {
            return;
        }
        List<ExtendedDataEntity> dataEntityList = this.validateBillHead(dataEntitys);
        dataEntityList = this.validateDrawOnceDuplicate(dataEntityList);
        dataEntityList = this.amountValidator(dataEntityList);
    }

    private List<ExtendedDataEntity> validateDrawOnceDuplicate(List<ExtendedDataEntity> dataEntitys) {
        if (EmptyUtil.isEmpty(dataEntitys)) {
            return dataEntitys;
        }
        String entityName = dataEntitys.get(0).getDataEntity().getDataEntityType().getName();
        Set onceDrawContrIds = dataEntitys.stream().filter(d -> DrawWayEnum.ONCE.getValue().equals(d.getDataEntity().getString("drawway"))).map(d -> d.getDataEntity().getLong("sourcebillid")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(onceDrawContrIds)) {
            return dataEntitys;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntitys.size());
        QFilter loanBillContractFilter = new QFilter("sourcebillid", "in", onceDrawContrIds);
        QFilter loanExistFilter = new QFilter("drawway", "=", (Object)DrawWayEnum.ONCE.getValue()).and(loanBillContractFilter);
        DynamicObjectCollection allExistLoans = QueryServiceHelper.query((String)"ifm_loanbill", (String)"id,sourcebillid,drawtype,settlestatus, datasource", (QFilter[])new QFilter[]{loanExistFilter});
        HashMap<Long, Set> contractIdLoanMap = new HashMap<Long, Set>(onceDrawContrIds.size());
        ArrayList<Long> loanBillContrIds = new ArrayList<Long>(allExistLoans.size());
        for (DynamicObject loan : allExistLoans) {
            Long contractId = loan.getLong("sourcebillid");
            loanBillContrIds.add(contractId);
            Set loanSet = contractIdLoanMap.computeIfAbsent(contractId, k -> new HashSet(5));
            loanSet.add(loan);
        }
        QFilter cycleLoanQF = new QFilter("iscycleloan", "=", (Object)Boolean.TRUE);
        cycleLoanQF.and("id", "in", loanBillContrIds);
        DynamicObjectCollection cycleLoanContract = QueryServiceHelper.query((String)"ifm_loancontractbill", (String)"id", (QFilter[])cycleLoanQF.toArray());
        HashSet<Long> cycleLoanContrIds = new HashSet<Long>(cycleLoanContract.size());
        for (DynamicObject contrDO : cycleLoanContract) {
            cycleLoanContrIds.add(contrDO.getLong("id"));
        }
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject loanBill = dataEntity.getDataEntity();
            Long contractId = loanBill.getLong("sourcebillid");
            Long currentLoanId = loanBill.getLong("id");
            Set existLoans = (Set)contractIdLoanMap.get(contractId);
            if (EmptyUtil.isEmpty((Collection)existLoans)) {
                dataEntityList.add(dataEntity);
                continue;
            }
            boolean isBreak = false;
            for (DynamicObject existLoan : existLoans) {
                AbstractBizResource bizResource;
                if (Long.valueOf(existLoan.getLong("id")).equals(currentLoanId) || DrawTypeEnum.isCloseout((String)existLoan.getString("drawtype")) && cycleLoanContrIds.contains(contractId)) continue;
                if ("ifm_loanbill".equals(entityName)) {
                    if (DataSourceEnum.isIfm((String)existLoan.getString("datasource")) || SettleCenterStatusEnum.ACCEPT.getValue().equals(existLoan.getString("settlestatus"))) {
                        bizResource = new BizResourceFactory().getBizResource(DataSourceEnum.IFM.getValue());
                        this.addErrorMessage(dataEntity, bizResource.getCbOnlyOnceLoan());
                        isBreak = true;
                        break;
                    }
                    bizResource = new BizResourceFactory().getBizResource(DataSourceEnum.CFM.getValue());
                    this.addErrorMessage(dataEntity, bizResource.getCbOnlyOnceLoan());
                    isBreak = true;
                    break;
                }
                bizResource = new BizResourceFactory().getBizResource(DataSourceEnum.CFM.getValue());
                this.addErrorMessage(dataEntity, bizResource.getCbOnlyOnceLoan());
                isBreak = true;
                break;
            }
            if (isBreak) continue;
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private boolean validateDate(ExtendedDataEntity dataEntity) {
        DynamicObject loanBill = dataEntity.getDataEntity();
        DynamicObject contractBill = loanBill.getDynamicObject("loancontractbill");
        Date loanDate = loanBill.getDate("bizdate");
        if (EmptyUtil.isNoEmpty((DynamicObject)contractBill) && EmptyUtil.isNoEmpty((Object)loanDate)) {
            Date contractStartDate = contractBill.getDate("startdate");
            Date contractEndDate = contractBill.getDate("enddate");
            Date transContractDate = DateUtils.getDataFormat((Date)contractStartDate, (boolean)true);
            if (loanDate.before(transContractDate) && !LoanBillHelper.isBond((DynamicObject)loanBill)) {
                this.addErrorMessage(dataEntity, this.getBizResource(loanBill).getLoanDateBeforeStartDate());
                return false;
            }
            Date renewalExpiredate = contractBill.getDate("renewalexpiredate");
            if (EmptyUtil.isNoEmpty((Object)renewalExpiredate)) {
                contractEndDate = renewalExpiredate;
            }
            if (EmptyUtil.isNoEmpty((Object)contractEndDate) && loanDate.after(contractEndDate)) {
                this.addErrorMessage(dataEntity, this.getBizResource(loanBill).getLoanDateAfterEndDate());
                return false;
            }
        }
        return true;
    }

    private boolean validateRepaymentWay(ExtendedDataEntity dataEntity) {
        ArrayList repayWays;
        ArrayList intPlanWays;
        DynamicObject loanBill = dataEntity.getDataEntity();
        DynamicObject productFactory = loanBill.getDynamicObject("productfactory");
        String repaymentWay = loanBill.getString("repaymentway");
        if ((EmptyUtil.isEmpty((DynamicObject)productFactory) || productFactory.getBoolean("iscallint")) && (intPlanWays = Lists.newArrayList((Object[])new String[]{RepaymentWayEnum.bqhbdqhx.getValue(), RepaymentWayEnum.dqhbdqhx.getValue(), RepaymentWayEnum.zdyhk.getValue()})).contains(repaymentWay)) {
            boolean isNot0Rate;
            DynamicObject settleIntPlan = loanBill.getDynamicObject("interestsettledplan");
            String settleMode = loanBill.getString("settleintmode");
            String interestType = loanBill.getString("interesttype");
            boolean bl = isNot0Rate = BigDecimal.ZERO.compareTo(loanBill.getBigDecimal("startloanrate")) != 0 || BigDecimal.ZERO.compareTo(loanBill.getBigDecimal("loanrate")) != 0;
            if ((InterestTypeEnum.isFloat((String)interestType) || !InterestTypeEnum.isFloat((String)interestType) && isNot0Rate) && SettleIntModeEnum.gdpljx.getValue().equals(settleMode) && EmptyUtil.isEmpty((DynamicObject)settleIntPlan) && !this.isLoanBondSaveOp(loanBill)) {
                this.addErrorMessage(dataEntity, this.getBizResource(loanBill).getInterestSettledPlanNotNull());
                return false;
            }
        }
        if ((repayWays = Lists.newArrayList((Object[])new String[]{RepaymentWayEnum.dqhblsbq.getValue(), RepaymentWayEnum.dqhbdqhx.getValue(), RepaymentWayEnum.debx.getValue()})).contains(repaymentWay) && EmptyUtil.isEmpty((DynamicObject)loanBill.getDynamicObject("stageplan"))) {
            this.addErrorMessage(dataEntity, this.getBizResource(loanBill).getStagePlanNotNull());
            return false;
        }
        return true;
    }

    private boolean isLoanBondSaveOp(DynamicObject loanBill) {
        return StringUtils.equals((CharSequence)this.getOperateKey(), (CharSequence)"save") && LoanBillHelper.isBond((DynamicObject)loanBill);
    }

    private boolean validateAmt(ExtendedDataEntity dataEntity, DynamicObject contractBill) {
        DynamicObject loanBill = dataEntity.getDataEntity();
        if (!this.isLoanBondSaveOp(loanBill) && EmptyUtil.isEmpty((BigDecimal)loanBill.getBigDecimal("drawamount"))) {
            AbstractBizResource bizResource = this.getBizResource(loanBill);
            String zeroAmtMsg = bizResource.getLbDrawamountZeroChecksum();
            DynamicObjectCollection drawPlans = contractBill.getDynamicObjectCollection("drawdownplan_entry");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)drawPlans)) {
                Optional<DynamicObject> firstPlan = drawPlans.stream().filter(v -> "0".equals(v.getString("e_drawstate"))).findFirst();
                zeroAmtMsg = !firstPlan.isPresent() ? bizResource.getNoDrawPlanAndAmountNull() : zeroAmtMsg;
            }
            this.addErrorMessage(dataEntity, zeroAmtMsg);
            return false;
        }
        return true;
    }

    private List<ExtendedDataEntity> amountValidator(List<ExtendedDataEntity> dataEntitys) {
        if (EmptyUtil.isEmpty(dataEntitys)) {
            return dataEntitys;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntitys.size());
        Map<Long, List<ExtendedDataEntity>> contractMap = dataEntitys.stream().collect(Collectors.groupingBy(d -> d.getDataEntity().getLong("loancontractbill.id")));
        Map canDrawAmountMap = LoanContractBillRepository.getContractBillDrawAmountSum(new ArrayList<Long>(contractMap.keySet()));
        for (Map.Entry<Long, List<ExtendedDataEntity>> entry : contractMap.entrySet()) {
            List<ExtendedDataEntity> loanBillList = entry.getValue();
            ContractBillAmountSumDTO sumDTO = (ContractBillAmountSumDTO)canDrawAmountMap.get(entry.getKey());
            if (sumDTO == null) continue;
            BigDecimal canDrawAmount = sumDTO.getUnDrawAmt();
            for (ExtendedDataEntity dataEntity : loanBillList) {
                DynamicObject loanBill = dataEntity.getDataEntity();
                if ((canDrawAmount = canDrawAmount.subtract(loanBill.getBigDecimal("convertdrawamt"))).compareTo(BigDecimal.ZERO) < 0) {
                    AbstractBizResource bizResource = new BizResourceFactory().getBizResource(loanBill.getString("datasource"));
                    this.addErrorMessage(dataEntity, bizResource.getLbLessThanNotDrawAmountCheck());
                    continue;
                }
                dataEntityList.add(dataEntity);
            }
        }
        return dataEntityList;
    }

    private boolean validateFloatRate(ExtendedDataEntity dataEntity) {
        DynamicObject loanBill = dataEntity.getDataEntity();
        DynamicObject productFactory = loanBill.getDynamicObject("productfactory");
        if (EmptyUtil.isNoEmpty((DynamicObject)productFactory) && !productFactory.getBoolean("iscallint")) {
            return true;
        }
        if (!InterestTypeEnum.isFloat((String)loanBill.getString("interesttype"))) {
            return true;
        }
        AbstractBizResource bizResource = this.getBizResource(loanBill);
        if (EmptyUtil.isEmpty((DynamicObject)loanBill.getDynamicObject("referencerate"))) {
            this.addErrorMessage(dataEntity, bizResource.getReferenceRateNotNull());
            return false;
        }
        if (EmptyUtil.isEmpty((String)loanBill.getString("rateadjuststyle"))) {
            this.addErrorMessage(dataEntity, bizResource.getRateAdjustStyleNotNull());
            return false;
        }
        if (EmptyUtil.isNoEmpty((BigDecimal)loanBill.getBigDecimal("ratefloatpoint")) && EmptyUtil.isEmpty((String)loanBill.getString("ratesign"))) {
            this.addErrorMessage(dataEntity, bizResource.getRatesignNotNull());
            return false;
        }
        if (RateAdjustStyleEnum.isCycle((String)loanBill.getString("rateadjuststyle"))) {
            Date rateAdjustDate = loanBill.getDate("rateadjustdate");
            if (EmptyUtil.isEmpty((Object)rateAdjustDate)) {
                this.addErrorMessage(dataEntity, bizResource.getRateadjustDateNotNull());
                return false;
            }
            Date endDate = loanBill.getDate("expiredate");
            if (rateAdjustDate.compareTo(endDate) >= 0) {
                this.addErrorMessage(dataEntity, bizResource.getLoanRateadjustDateRange());
                return false;
            }
            if (LoanBillHelper.isSofr((DynamicObject)loanBill) && rateAdjustDate.compareTo(loanBill.getDate("startintdate")) > 0) {
                this.addErrorMessage(dataEntity, bizResource.getSofrLoanRateadjustDateRange());
                return false;
            }
            if (EmptyUtil.isEmpty((BigDecimal)loanBill.getBigDecimal("rateadjustcycle")) || EmptyUtil.isEmpty((String)loanBill.getString("rateadjustcycletype"))) {
                this.addErrorMessage(dataEntity, bizResource.getRateAdjustCycleNotNull());
                return false;
            }
        }
        return true;
    }

    private boolean validateUnderwriter(ExtendedDataEntity dataEntity) {
        DynamicObject loanBill = dataEntity.getDataEntity();
        if (!LoanBillHelper.isBond((DynamicObject)loanBill)) {
            return true;
        }
        DynamicObjectCollection underwriterEntrys = loanBill.getDynamicObjectCollection("underwriter_entry");
        if (underwriterEntrys.isEmpty()) {
            return true;
        }
        long isbookrunnerCount = underwriterEntrys.stream().filter(v -> v.getBoolean("e_isbookrunner")).count();
        if (isbookrunnerCount > 1L) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7c3f\u8bb0\u7ba1\u7406\u4eba\u53ea\u80fd\u6709\u4e00\u4e2a\u3002", (String)"LoanBillSaveValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
            return false;
        }
        BigDecimal contractAmount = loanBill.getBigDecimal("amount");
        BigDecimal uwAmtSum = BigDecimal.ZERO;
        BigDecimal uwRatioSum = BigDecimal.ZERO;
        for (DynamicObject underwriterEntry : underwriterEntrys) {
            DynamicObject underwriter = underwriterEntry.getDynamicObject("e_underwriter");
            if (EmptyUtil.isEmpty((DynamicObject)underwriter)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u627f\u9500\u5546\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoanBillSaveValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
                return false;
            }
            BigDecimal uwRatio = underwriterEntry.getBigDecimal("e_underwriteratio");
            BigDecimal uwAmount = underwriterEntry.getBigDecimal("e_underwriteamount");
            if (BigDecimal.ZERO.compareTo(uwAmount) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u627f\u9500\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"LoanBillSaveValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
                return false;
            }
            if (BigDecimal.ZERO.compareTo(uwRatio) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u627f\u9500\u6bd4\u4f8b\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"LoanBillSaveValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]));
                return false;
            }
            uwAmtSum = uwAmtSum.add(uwAmount);
            uwRatioSum = uwRatioSum.add(uwRatio);
        }
        if (BigDecimal.valueOf(100L).compareTo(uwRatioSum) < 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u627f\u9500\u603b\u6bd4\u4f8b\u4e0d\u80fd\u5927\u4e8e100%\u3002", (String)"LoanBillSaveValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]));
            return false;
        }
        if (contractAmount.compareTo(uwAmtSum) < 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u627f\u9500\u603b\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5408\u540c\u91d1\u989d\u3002", (String)"LoanBillSaveValidator_5", (String)"tmc-cfm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateIsDrawByPlan(ExtendedDataEntity dataEntity, DynamicObject contractBill) {
        if ("true".equals(this.getOption().getVariableValue("byDrawApply", "false"))) {
            return true;
        }
        DynamicObjectCollection drawPlans = contractBill.getDynamicObjectCollection("drawdownplan_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)drawPlans)) {
            return true;
        }
        DynamicObject loanBill = dataEntity.getDataEntity();
        QFilter qFilter = new QFilter("sourcebillid", "=", contractBill.getPkValue()).and("id", "!=", loanBill.getPkValue());
        QFilter confirmFilter = new QFilter("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        DynamicObject loanBillObj = QueryServiceHelper.queryOne((String)"cfm_loanbill", (String)"billno", (QFilter[])new QFilter[]{qFilter, confirmFilter});
        if (EmptyUtil.isNoEmpty((DynamicObject)loanBillObj)) {
            String loanName = CfmBillCommonHelper.getLoanNameByDataSource((String)loanBill.getString("datasource"));
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ContractAutoDrawValidator_3.loadKDString(loanName, loanBillObj.getString("billno")));
            return false;
        }
        QFilter applyFilter = new QFilter("loancontractbill", "=", contractBill.getPkValue());
        if (EmptyUtil.isNoEmpty((DynamicObject)loanBill.getDynamicObject("drawapplybill"))) {
            applyFilter.and("id", "!=", (Object)loanBill.getDynamicObject("drawapplybill").getLong("id"));
        }
        QFilter businessFilter = new QFilter("businessstatus", "in", Arrays.asList(ApplyBusinessStatusEnum.APPLY.getValue(), ApplyBusinessStatusEnum.HANDING.getValue(), ApplyBusinessStatusEnum.NOTHAND.getValue()));
        DynamicObjectCollection drawApplyBills = QueryServiceHelper.query((String)"cfm_draw_apply", (String)"billno", (QFilter[])new QFilter[]{applyFilter, businessFilter});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)drawApplyBills)) {
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ContractAutoDrawValidator_4.loadKDString(((DynamicObject)drawApplyBills.get(0)).getString("billno")));
            return false;
        }
        return true;
    }

    private List<ExtendedDataEntity> validateBillHead(ExtendedDataEntity[] dataEntities) {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.length);
        Set contractIds = Arrays.stream(dataEntities).map(d -> d.getDataEntity().getLong("sourcebillid")).collect(Collectors.toSet());
        Map contactMap = LoanContractBillRepository.loadContractBillByIds(contractIds, (String)"drawdownplan_entry, drawdownplan_entry.e_drawstate");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject loanBill = dataEntity.getDataEntity();
            Long contractId = loanBill.getLong("sourcebillid");
            DynamicObject contractBill = (DynamicObject)contactMap.get(contractId);
            if (!this.validateAmt(dataEntity, contractBill) || !this.validateFloatRate(dataEntity) || !this.validateUnderwriter(dataEntity) || !this.validateRepaymentWay(dataEntity) || !this.validateDate(dataEntity) || !this.validateIsDrawByPlan(dataEntity, contractBill)) continue;
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    protected AbstractBizResource getBizResource(DynamicObject loanBill) {
        return new BizResourceFactory().getBizResource(loanBill.getString("datasource"));
    }
}

