/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.DepositApplyStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositDealDeleteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("srcdepositid");
        selector.add("apply");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.writeBack(dataEntities);
        this.writeBackApply(dataEntities);
    }

    private void writeBack(DynamicObject[] dataEntities) {
        Object[] srcDepositIds = Arrays.stream(dataEntities).map(v -> v.getLong("srcdepositid")).toArray();
        if (EmptyUtil.isEmpty((Object[])srcDepositIds)) {
            return;
        }
        DynamicObject[] srcDeposits = TmcDataServiceHelper.load((Object[])srcDepositIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_deposit"));
        Map<Long, DynamicObject> srcDepositMap = Arrays.stream(srcDeposits).collect(Collectors.toMap(v -> v.getLong("id"), o -> o));
        for (DynamicObject depositBill : dataEntities) {
            Long srcDepositId = depositBill.getLong("srcdepositid");
            DynamicObject srcDepositBill = srcDepositMap.get(srcDepositId);
            if (EmptyUtil.isEmpty((DynamicObject)srcDepositBill)) continue;
            srcDepositBill.set("isresubmit", (Object)false);
            Long sourcebillid = srcDepositBill.getLong("sourcebillid");
            if (!EmptyUtil.isNoEmpty((Long)sourcebillid)) continue;
            TmcBotpHelper.deleteRation((String)"cim_deposit", (Long)sourcebillid, (Long)depositBill.getLong("id"));
        }
        SaveServiceHelper.update((DynamicObject[])srcDeposits);
    }

    private void writeBackApply(DynamicObject[] dataEntities) {
        DynamicObject[] applyBills;
        List applyIdList = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((DynamicObject)r.getDynamicObject("apply"))).map(r -> r.getLong("apply.id")).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(applyIdList)) {
            return;
        }
        List depIdList = Arrays.stream(dataEntities).map(r -> r.getLong("id")).collect(Collectors.toList());
        QFilter applyIdFilter = new QFilter("apply", "in", applyIdList);
        QFilter notCurrDepFilter = new QFilter("id", "not in", depIdList);
        DynamicObjectCollection otherDepositBills = QueryServiceHelper.query((String)"cim_deposit", (String)"id,apply,billstatus", (QFilter[])new QFilter[]{applyIdFilter, notCurrDepFilter});
        Map<Long, List<DynamicObject>> applyGroupMap = otherDepositBills.stream().collect(Collectors.groupingBy(r -> r.getLong("apply")));
        HashMap<Long, Boolean> apply2StatMap = new HashMap<Long, Boolean>(applyGroupMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : applyGroupMap.entrySet()) {
            List<DynamicObject> otherDepList = entry.getValue();
            Boolean isAudit = Boolean.TRUE;
            for (DynamicObject otherBill : otherDepList) {
                if (BillStatusEnum.isAudit((String)otherBill.getString("billstatus"))) continue;
                isAudit = Boolean.FALSE;
                break;
            }
            apply2StatMap.put(entry.getKey(), isAudit);
        }
        for (DynamicObject applyBill : applyBills = TmcDataServiceHelper.load((String)"cim_deposit_apply", (String)"id,applystatus", (QFilter[])new QFilter[]{new QFilter("id", "in", applyIdList)})) {
            String applyState = DepositApplyStatusEnum.UNHANDLE.getValue();
            Boolean isDbAudit = (Boolean)apply2StatMap.get(applyBill.getLong("id"));
            if (EmptyUtil.isNoEmpty((Object)isDbAudit)) {
                applyState = isDbAudit != false ? DepositApplyStatusEnum.PARTHANDLED.getValue() : DepositApplyStatusEnum.HANDING.getValue();
            }
            applyBill.set("applystatus", (Object)applyState);
        }
        SaveServiceHelper.update((DynamicObject[])applyBills);
    }
}

