/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.helper;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.creditm.business.helper.CreditlimitHelper;
import kd.tmc.creditm.common.enums.CreditmApplyTypeEnum;
import kd.tmc.creditm.common.helper.CreditFrameworkHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditlimitApplyHelper {
    public static DynamicObject getCreditLimitApplyBill(long limitId, long applyId) {
        QFilter filter = new QFilter("creditlimit", "=", (Object)limitId).and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        if (EmptyUtil.isNoEmpty((Long)applyId)) {
            filter.and("id", "!=", (Object)applyId);
        }
        DynamicObject applyBill = QueryServiceHelper.queryOne((String)"creditm_apply", (String)"billno", (QFilter[])new QFilter[]{filter});
        return applyBill;
    }

    public static void saveHistoryVersion(DynamicObject applyBill, DynamicObject limit) {
        DynamicObjectCollection srcBills = limit.getDynamicObjectCollection("sourcebillids");
        limit.set("sourcebillids", null);
        BillChangeHistoryHelper.addChangeHistory((Long)((Long)applyBill.getPkValue()), (String)"creditm_apply", (String)applyBill.getString("billno"), (String)applyBill.getString("comment"), (String)"SX", (DynamicObject)limit);
        limit.set("sourcebillids", (Object)srcBills);
    }

    public static void creditmApplyChange(DynamicObject applyBill, DynamicObject limit, String applyType) {
        if (!CreditmApplyTypeEnum.isChange((String)applyType)) {
            return;
        }
        BigDecimal totalAmt = limit.getBigDecimal("totalamt");
        limit.set("contractno", (Object)applyBill.getString("contractno"));
        limit.set("totalamt", (Object)applyBill.getString("totalamt"));
        limit.set("credittype", (Object)applyBill.getDynamicObject("credittype"));
        limit.set("startdate", (Object)applyBill.getDate("startdate"));
        limit.set("enddate", (Object)applyBill.getDate("enddate"));
        limit.set("guartype", (Object)applyBill.getString("guartype"));
        limit.set("isgrouplimit", (Object)applyBill.getBoolean("isgrouplimit"));
        limit.set("orgsharetype", (Object)applyBill.getString("orgsharetype"));
        CreditlimitApplyHelper.entryOrgChange(applyBill, limit, true);
        CreditlimitApplyHelper.entryOrgChange(applyBill, limit, false);
        CreditlimitApplyHelper.entryMultChange(applyBill, limit);
        DynamicObject frameWork = limit.getDynamicObject("framework");
        if (EmptyUtil.isEmpty((DynamicObject)frameWork)) {
            return;
        }
        CreditFrameworkHelper.creditWriteBackFrame((Long)frameWork.getLong("id"), (Long)limit.getDynamicObject("org").getLong("id"), (Long)limit.getDynamicObject("credittype").getLong("id"), (BigDecimal)applyBill.getBigDecimal("totalamt").subtract(totalAmt));
    }

    private static void entryMultChange(DynamicObject applyBill, DynamicObject limit) {
        DynamicObjectCollection limitEntrys = limit.getDynamicObjectCollection("entry_mult");
        DynamicObjectCollection applyEntrys = applyBill.getDynamicObjectCollection("entry_mult");
        limitEntrys.clear();
        for (DynamicObject applyEntry : applyEntrys) {
            DynamicObject entry = limitEntrys.addNew();
            CreditlimitHelper.setMultEntryVal((DynamicObject)applyEntry, (DynamicObject)entry, (String)"m_org");
            CreditlimitHelper.setMultEntryVal((DynamicObject)applyEntry, (DynamicObject)entry, (String)"m_credittype");
            entry.set("m_totalamt", (Object)applyEntry.getBigDecimal("m_totalamt"));
        }
    }

    public static void entryOrgChange(DynamicObject applyBill, DynamicObject limit, boolean isOrg) {
        DynamicObjectCollection limitEntrys = limit.getDynamicObjectCollection(isOrg ? "entry_org" : "entry_type");
        DynamicObjectCollection applyEntrys = applyBill.getDynamicObjectCollection(isOrg ? "entry_org" : "entry_type");
        limitEntrys.clear();
        for (DynamicObject applyEntry : applyEntrys) {
            DynamicObject entry = limitEntrys.addNew();
            CreditlimitHelper.setMultEntryVal((DynamicObject)applyEntry, (DynamicObject)entry, (String)(isOrg ? "o_org" : "t_credittype"));
            entry.set("id", (Object)applyEntry.getLong("id"));
            entry.set("pid", (Object)applyEntry.getLong("pid"));
            String field = isOrg ? "o_totalamt" : "t_totalamt";
            entry.set(field, (Object)applyEntry.getBigDecimal(field));
            BigDecimal amount = applyEntry.getBigDecimal(field);
            field = isOrg ? "o_singleamt" : "t_singleamt";
            entry.set(field, (Object)applyEntry.getBigDecimal(field));
            amount = amount.add(applyEntry.getBigDecimal(field));
            field = isOrg ? "o_avaramt" : "t_avaramt";
            entry.set(field, (Object)amount);
        }
    }

    public static void updateLimits(List<DynamicObject> limits) {
        if (EmptyUtil.isEmpty(limits)) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])limits.toArray(new DynamicObject[0]));
        Object[] limitIds = limits.stream().map(o -> o.getLong("id")).toArray();
        TmcOperateServiceHelper.execOperate((String)"credituseamtupdate", (String)"cfm_creditlimit", (Object[])limitIds, (OperateOption)OperateOption.create());
    }
}

