/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.release;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class SuretyReleaseAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("suretybill");
        selector.add("amount");
        selector.add("releasedate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendData : dataEntity) {
            BigDecimal finAmount;
            DynamicObject releaseBill = extendData.getDataEntity();
            DynamicObject suretyBill = QueryServiceHelper.queryOne((String)"fbd_suretybill", (String)"endinstdate,intdate,releaseamount,amount", (QFilter[])new QFilter[]{new QFilter("id", "=", releaseBill.getDynamicObject("suretybill").getPkValue())});
            BigDecimal releaseAmount = suretyBill.getBigDecimal("releaseamount").add(releaseBill.getBigDecimal("amount"));
            if (releaseAmount.compareTo(finAmount = suretyBill.getBigDecimal("amount")) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u51fa\u91d1\u989d\u8d85\u8fc7\u4e86\u4fdd\u8bc1\u91d1\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SuretyReleaseAuditValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            Date releaseDate = releaseBill.getDate("releasedate");
            Optional.ofNullable(suretyBill.getDate("endinstdate")).ifPresent(endInstDate -> {
                if (releaseDate.compareTo((Date)endInstDate) <= 0) {
                    this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b58\u51fa\u65e5\u671f\u9700\u5927\u4e8e\u6216\u7b49\u4e8e\u4e0a\u6b21\u6536\u76ca\u65e5\u3002", (String)"SuretyReleaseSubmitValidator_8", (String)"tmc-fbd-business", (Object[])new Object[0]));
                }
            });
        }
    }
}

