/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.suretyappend;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.SuretyBizStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyAppendUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("billno");
        selector.add("appendamount");
        selector.add("suretybill");
        selector.add("appendintdate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendDataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedData : extendDataEntity) {
            DynamicObject suretyAppendBill = extendedData.getDataEntity();
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)suretyAppendBill.getDataEntityType().getName(), (Long[])new Long[]{suretyAppendBill.getLong("id")});
            if (null != targetBills && targetBills.size() > 0) {
                this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"SuretyAppendUnAuditValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            DynamicObject suretyBill = suretyAppendBill.getDynamicObject("suretybill");
            suretyBill = QueryServiceHelper.queryOne((String)"fbd_suretybill", (String)String.join((CharSequence)",", "bizstatus", "surplusamount", "billno", "endinstdate"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)suretyBill.getLong("id"))});
            BigDecimal appendAmount = suretyAppendBill.getBigDecimal("appendamount");
            if (SuretyBizStatusEnum.SURETY_END.getValue().equals(suretyBill.getString("bizstatus")) || SuretyBizStatusEnum.SURETY_PART.getValue().equals(suretyBill.getString("bizstatus")) && appendAmount.compareTo(suretyBill.getBigDecimal("surplusamount")) > 0) {
                this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u636e%s\u5df2\u5b58\u51fa\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"SuretyAppendUnAuditValidator_1", (String)"tmc-fbd-business", (Object[])new Object[]{suretyBill.getString("billno")}));
            }
            Date appendIntDate = suretyAppendBill.getDate("appendintdate");
            Date endInstDate = suretyBill.getDate("endinstdate");
            if (!EmptyUtil.isNoEmpty((Object)endInstDate) || appendIntDate.compareTo(endInstDate) > 0) continue;
            this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u636e%s\u8ffd\u52a0\u540e\u5df2\u83b7\u53d6\u6536\u76ca\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"SuretyAppendUnAuditValidator_2", (String)"tmc-fbd-business", (Object[])new Object[]{suretyBill.getString("billno")}));
        }
    }
}

