/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.common.enums.DebtBillTypeEnum;
import kd.tmc.fbd.common.enums.SuretyStatusEnum;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.RateSignEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class SuretyBillHelper {
    public static BigDecimal getDateYearRate(DynamicObject bizBill, Date date) {
        Map rateDataMap;
        DynamicObject refIndex = bizBill.getDynamicObject("referencerate");
        if (EmptyUtil.isNoEmpty((DynamicObject)refIndex) && EmptyUtil.isNoEmpty((Object)date) && EmptyUtil.isNoEmpty((Object)(rateDataMap = MarketDataServiceHelper.referRate((String)refIndex.getString("number"), (Date)date, (Date)date))) && rateDataMap.size() != 0) {
            String rateSign = bizBill.getString("ratesign");
            BigDecimal rateFloatPoint = bizBill.getBigDecimal("ratefloatpoint");
            BigDecimal rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 20, RoundingMode.HALF_UP);
            if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
                rateFloat = rateFloat.negate();
            }
            return ((BigDecimal)rateDataMap.values().stream().findFirst().get()).add(rateFloat);
        }
        return BigDecimal.ZERO;
    }

    public static Map<Long, Pair<String, Boolean>> getAndSetDebtBillStatus(long id, String entityName) {
        DynamicObject suretyOrReleaseBill = TmcDataServiceHelper.loadSingle((Object)id, (String)entityName);
        DynamicObjectCollection entrys = suretyOrReleaseBill.getDynamicObjectCollection("entry");
        HashMap<Long, Pair<String, Boolean>> idStatusResult = new HashMap<Long, Pair<String, Boolean>>(entrys.size());
        Map debtBillMaps = entrys.stream().collect(Collectors.groupingBy(o -> o.getString("debttype"), Collectors.toList()));
        for (Map.Entry mapEntry : debtBillMaps.entrySet()) {
            DynamicObject[] debtDBBills;
            String debtType = mapEntry.getKey();
            List debtBillEntry = mapEntry.getValue();
            Map<Long, DynamicObject> entryIdStatusMap = debtBillEntry.stream().collect(Collectors.toMap(o -> o.getLong("debtbillid"), o -> o, (key1, key2) -> key1));
            Object[] pkIds = debtBillEntry.stream().map(o -> o.getLong("debtbillid")).toArray();
            ProductTypeEnum enumByFormId = ProductTypeEnum.getEnumByFormId((String)debtType);
            for (DynamicObject debtBill : debtDBBills = TmcDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)enumByFormId.getEntity()))) {
                DynamicObject nowDebtBillEntry;
                String oldDebtBizStatus;
                String newDebtBizStatus = SuretyBillHelper.getActDebtBizStatus(debtBill, debtType);
                if (!newDebtBizStatus.equals(oldDebtBizStatus = (nowDebtBillEntry = entryIdStatusMap.get(debtBill.getLong("id"))).getString("suretystatus"))) {
                    idStatusResult.put(debtBill.getLong("id"), (Pair<String, Boolean>)Pair.of((Object)newDebtBizStatus, (Object)false));
                    continue;
                }
                idStatusResult.put(debtBill.getLong("id"), (Pair<String, Boolean>)Pair.of((Object)newDebtBizStatus, (Object)true));
            }
        }
        return idStatusResult;
    }

    public static String getActDebtBizStatus(DynamicObject bizBill, String entityName) {
        String suretyStatus = SuretyStatusEnum.GUARANTING.getValue();
        if (DebtBillTypeEnum.LC_LETTERCREDIT.getValue().equals(entityName) && "done_close".equals(bizBill.getString("creditstatus"))) {
            suretyStatus = SuretyStatusEnum.SETTLED.getValue();
        } else if (DebtBillTypeEnum.CDM_PAYABLEBILL.getValue().equals(entityName)) {
            String draftStatus = bizBill.getString("draftbillstatus");
            if ("payoffed".equals(draftStatus) || "sendback".equals(draftStatus)) {
                suretyStatus = SuretyStatusEnum.SETTLED.getValue();
            }
        } else if (DebtBillTypeEnum.GM_LETTEROFGUARANTEE.getValue().equals(entityName) && "cancelled".equals(bizBill.getString("bizstatus"))) {
            suretyStatus = SuretyStatusEnum.SETTLED.getValue();
        }
        return suretyStatus;
    }

    public static Date getEndIntDate(DynamicObject productFactory, Date bizDate) {
        Date endIntDate = EmptyUtil.isEmpty((DynamicObject)productFactory) || IntHTRuleEnum.isNoTail((String)productFactory.getString("intheadtailrule")) ? DateUtils.getLastDay((Date)bizDate, (int)1) : bizDate;
        return endIntDate;
    }

    public static List<DynamicObject> getWriteBackDebit(String type, DynamicObject dynamicObject, boolean isAudit) {
        DynamicObject org = dynamicObject.getDynamicObject("org");
        DynamicObject currency = dynamicObject.getDynamicObject("currency");
        DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection("entry");
        Set debitIdSet = entryCol.stream().filter(f -> DebtBillTypeEnum.LC_LETTERCREDIT.getValue().equals(f.getString("debttype"))).map(o -> o.getLong("debtbillid")).collect(Collectors.toSet());
        DynamicObject[] debtBills = TmcDataServiceHelper.load((String)"lc_lettercredit", (String)String.join((CharSequence)",", "id", "billno", "promisrate", "suretycur", "totalsuretymoney", "amount", "currency", "amountscaleupper", "suretymoney", "isinit", "creditno"), (QFilter[])new QFilter("id", "in", debitIdSet).toArray());
        Map<Long, Long> debitCurrencyIdMap = Arrays.stream(debtBills).filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("suretycur"))).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getDynamicObject("suretycur").getLong("id")));
        QFilter appFilter = new QFilter("entry.debtbillid", "in", debitIdSet);
        appFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        appFilter.and(new QFilter("entry.debttype", "=", (Object)DebtBillTypeEnum.LC_LETTERCREDIT.getValue()));
        DynamicObjectCollection appendSuretyCol = QueryServiceHelper.query((String)"fbd_surety_append", (String)String.join((CharSequence)",", "entry.debtbillid", "entry.appendamt", "entry.debtcurrency", "currency", "org"), (QFilter[])new QFilter[]{appFilter});
        HashMap<Long, BigDecimal> appendDebitMap = new HashMap<Long, BigDecimal>(appendSuretyCol.size());
        for (DynamicObject appendSurety : appendSuretyCol) {
            BigDecimal appendAmt = appendSurety.getBigDecimal("entry.appendamt");
            if (EmptyUtil.isEmpty((BigDecimal)appendAmt)) continue;
            Object temp = (BigDecimal)appendDebitMap.get(appendSurety.getLong("entry.debtbillid"));
            temp = temp == null ? Constants.ZERO : temp;
            Long debitCurrencyId = debitCurrencyIdMap.get(appendSurety.getLong("entry.debtbillid"));
            BigDecimal exchangeRate = SuretyBillHelper.getExchangeRate(debitCurrencyId, appendSurety.getLong("currency"), appendSurety.getLong("org"));
            appendDebitMap.put(appendSurety.getLong("entry.debtbillid"), ((BigDecimal)temp).add(appendAmt.multiply(exchangeRate)));
        }
        QFilter reaFilter = new QFilter("entry.debtbillid", "in", debitIdSet);
        reaFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        reaFilter.and(new QFilter("entry.debttype", "=", (Object)DebtBillTypeEnum.LC_LETTERCREDIT.getValue()));
        DynamicObjectCollection reaSuretyCol = QueryServiceHelper.query((String)"fbd_suretyreleasebill", (String)String.join((CharSequence)",", "entry.debtbillid", "amount", "entry.debtcurrency", "currency", "org"), (QFilter[])new QFilter[]{reaFilter});
        HashMap<Long, BigDecimal> releaseDebitMap = new HashMap<Long, BigDecimal>(appendSuretyCol.size());
        for (Object reaSurety : reaSuretyCol) {
            BigDecimal temp = (BigDecimal)releaseDebitMap.get(reaSurety.getLong("entry.debtbillid"));
            temp = temp == null ? Constants.ZERO : temp;
            Long debitCurrencyId = debitCurrencyIdMap.get(reaSurety.getLong("entry.debtbillid"));
            BigDecimal exchangeRate = SuretyBillHelper.getExchangeRate(debitCurrencyId, reaSurety.getLong("currency"), reaSurety.getLong("org"));
            releaseDebitMap.put(reaSurety.getLong("entry.debtbillid"), temp.subtract(exchangeRate.multiply(reaSurety.getBigDecimal("amount"))));
        }
        HashMap<Long, BigDecimal> curAppendDebitMap = new HashMap<Long, BigDecimal>(entryCol.size());
        for (DynamicObject entry : entryCol) {
            if (!DebtBillTypeEnum.LC_LETTERCREDIT.getValue().equals(entry.getString("debttype"))) continue;
            BigDecimal appOrRelAmt = Constants.ZERO;
            BigDecimal temp = null;
            if ("append".equals(type)) {
                appOrRelAmt = entry.getBigDecimal("appendamt");
                if (EmptyUtil.isEmpty((BigDecimal)appOrRelAmt)) continue;
                appOrRelAmt = isAudit ? appOrRelAmt : Constants.ZERO.subtract(appOrRelAmt);
                temp = (BigDecimal)appendDebitMap.get(entry.getLong("debtbillid"));
            } else if ("release".equals(type)) {
                appOrRelAmt = dynamicObject.getBigDecimal("amount");
                temp = (BigDecimal)releaseDebitMap.get(entry.getLong("debtbillid"));
                appOrRelAmt = isAudit ? Constants.ZERO.subtract(appOrRelAmt) : appOrRelAmt;
            }
            temp = temp == null ? Constants.ZERO : temp;
            Long debitCurrencyId = debitCurrencyIdMap.get(entry.getLong("debtbillid"));
            BigDecimal exchangeRate = SuretyBillHelper.getExchangeRate(debitCurrencyId, currency.getLong("id"), org.getLong("id"));
            temp = temp.add(appOrRelAmt.multiply(exchangeRate));
            if ("append".equals(type)) {
                curAppendDebitMap.put(entry.getLong("debtbillid"), appOrRelAmt.multiply(exchangeRate));
                appendDebitMap.put(entry.getLong("debtbillid"), temp);
                continue;
            }
            if (!"release".equals(type)) continue;
            releaseDebitMap.put(entry.getLong("debtbillid"), temp);
        }
        Set initCreditNoSet = Arrays.stream(debtBills).filter(f -> f.getBoolean("isinit")).map(o -> o.getString("creditno")).collect(Collectors.toSet());
        QFilter initFilter = new QFilter("creditno", "in", initCreditNoSet);
        initFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        DynamicObjectCollection letterCreditInitCol = QueryServiceHelper.query((String)"lc_lettercredit_init", (String)"creditno,totalsuretymoney", (QFilter[])initFilter.toArray());
        Map<String, BigDecimal> creditNoMap = letterCreditInitCol.stream().collect(Collectors.toMap(k -> k.getString("creditno"), v -> v.getBigDecimal("totalsuretymoney")));
        ArrayList<DynamicObject> debtBillEntities = new ArrayList<DynamicObject>(debtBills.length);
        for (DynamicObject debitBill : debtBills) {
            BigDecimal releaseAmt;
            BigDecimal appendAmt = (BigDecimal)appendDebitMap.get(debitBill.getLong("id"));
            BigDecimal bigDecimal = appendAmt = appendAmt == null ? Constants.ZERO : appendAmt;
            if ("append".equals(type)) {
                BigDecimal curAppendAmt = (BigDecimal)curAppendDebitMap.get(debitBill.getLong("id"));
                curAppendAmt = curAppendAmt == null ? Constants.ZERO : curAppendAmt;
                BigDecimal exchangeRate = SuretyBillHelper.getExchangeRate(debitBill.getDynamicObject("currency").getLong("id"), debitBill.getDynamicObject("suretycur").getLong("id"), org.getLong("id"));
                debitBill.set("promisrate", (Object)debitBill.getBigDecimal("promisrate").add(curAppendAmt.multiply(Constants.ONE_HUNDRED).multiply(exchangeRate).divide(SuretyBillHelper.getAmount(debitBill), 10, RoundingMode.HALF_UP)));
            }
            BigDecimal bigDecimal2 = releaseAmt = (releaseAmt = (BigDecimal)releaseDebitMap.get(debitBill.getLong("id"))) == null ? Constants.ZERO : releaseAmt;
            if (debitBill.getBoolean("isinit") && creditNoMap.get(debitBill.getString("creditno")) != null) {
                debitBill.set("totalsuretymoney", (Object)creditNoMap.get(debitBill.getString("creditno")).add(appendAmt).add(releaseAmt));
            } else {
                debitBill.set("totalsuretymoney", (Object)debitBill.getBigDecimal("suretymoney").add(appendAmt).add(releaseAmt));
            }
            debtBillEntities.add(debitBill);
        }
        return debtBillEntities;
    }

    private static BigDecimal getAmount(DynamicObject letterCredit) {
        BigDecimal amount = letterCredit.getBigDecimal("amount");
        BigDecimal amountUpper = letterCredit.getBigDecimal("amountscaleupper");
        return amount.multiply(BigDecimal.ONE.add(amountUpper.divide(Constants.ONE_HUNDRED, 10, RoundingMode.HALF_UP)));
    }

    private static BigDecimal getExchangeRate(Long debitCurrencyId, Long currencyId, Long orgId) {
        BigDecimal exchangeRate = Constants.ONE;
        if (EmptyUtil.isNoEmpty((Long)debitCurrencyId) && !debitCurrencyId.equals(currencyId)) {
            exchangeRate = TmcBusinessBaseHelper.getExchangeRateNew((long)currencyId, (long)debitCurrencyId, (long)orgId, (Date)DateUtils.getCurrentDate());
            exchangeRate = exchangeRate == null ? Constants.ONE : exchangeRate;
        }
        return exchangeRate;
    }
}

