/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.common.enums.RevenueWayEnum;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.RoundRuleEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.IntCalRequest;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.factory.IntCallFactory;
import kd.tmc.fbp.service.inst.interest.IIntCallStragety;
import kd.tmc.fbp.service.inst.plan.RevenuePlanCallStragety;
import org.apache.commons.lang3.tuple.Pair;

public class SuretyIntCalcHelper {
    private static final String[] SURETY_APPEND_PROP = new String[]{"appendintdate", "appendamount", "amount"};

    public static IntBillInfo callInt(Long suretyBillId, Date beginDate, Date endDate) {
        DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((Object)suretyBillId, (String)"fbd_suretybill");
        if (EmptyUtil.isEmpty((Object)beginDate)) {
            beginDate = SuretyIntCalcHelper.getBeginIntDate(suretyBill);
        }
        if (EmptyUtil.isEmpty((Object)endDate)) {
            endDate = SuretyIntCalcHelper.getEndIntDate(suretyBill);
        }
        BigDecimal principle = SuretyIntCalcHelper.getIntCallPrinciple(suretyBill);
        List<PlanCallResult> repayPlanList = SuretyIntCalcHelper.getAllRepayPlanList(suretyBill, false);
        SuretyIntCalcHelper.addAllAppendToRepayPlanList(repayPlanList, suretyBill);
        return SuretyIntCalcHelper.callInt(suretyBill, repayPlanList, beginDate, endDate, principle, 0, RepaymentWayEnum.zdyhk);
    }

    public static IntBillInfo callInt(Long suretyBillId, Date beginDate, Date endDate, boolean isPayInt) {
        DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((Object)suretyBillId, (String)"fbd_suretybill");
        if (EmptyUtil.isEmpty((Object)beginDate)) {
            beginDate = SuretyIntCalcHelper.getBeginIntDate(suretyBill);
        }
        if (EmptyUtil.isEmpty((Object)endDate)) {
            endDate = SuretyIntCalcHelper.getEndIntDate(suretyBill);
        }
        BigDecimal principle = SuretyIntCalcHelper.getIntCallPrinciple(suretyBill);
        List<PlanCallResult> repayPlanList = SuretyIntCalcHelper.getAllRepayPlanList(suretyBill, isPayInt);
        SuretyIntCalcHelper.addAllAppendToRepayPlanList(repayPlanList, suretyBill);
        return SuretyIntCalcHelper.callInt(suretyBill, repayPlanList, beginDate, endDate, principle, 0, RepaymentWayEnum.zdyhk);
    }

    public static IntBillInfo callInt(Long suretyBillId, Date endDate, BigDecimal repayAmt) {
        DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((Object)suretyBillId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fbd_suretybill"));
        Date beginDate = SuretyIntCalcHelper.getBeginIntDate(suretyBill);
        return SuretyIntCalcHelper.callInt(suretyBill, null, beginDate, endDate, repayAmt, 0, RepaymentWayEnum.zdyhk);
    }

    public static IntBillInfo callInt(DynamicObject suretyBill, Date endDate, BigDecimal repayAmt) {
        Date beginDate = SuretyIntCalcHelper.getBeginIntDate(suretyBill);
        Date expireDate = SuretyIntCalcHelper.getEndIntDate(suretyBill);
        if (EmptyUtil.isEmpty((Object)expireDate) || endDate.compareTo(expireDate) < 0) {
            suretyBill.getDynamicObjectCollection("rateadjust_entry").clear();
            DynamicObject rate = suretyBill.getDynamicObjectCollection("rateadjust_entry").addNew();
            rate.set("ra_effectdate", (Object)beginDate);
            rate.set("ra_yearrate", (Object)suretyBill.getBigDecimal("demandrate"));
        }
        return SuretyIntCalcHelper.callInt(suretyBill, null, beginDate, endDate, repayAmt, 0, RepaymentWayEnum.zdyhk);
    }

    public static Pair<BigDecimal, List<IntBillInfo>> callIntPlan(DynamicObject suretyBill) {
        Date beginDate = SuretyIntCalcHelper.getBeginIntDate(suretyBill);
        Date endDate = SuretyIntCalcHelper.getEndIntDate(suretyBill);
        List<PlanCallResult> intPlanList = SuretyIntCalcHelper.callIntPlan(suretyBill, endDate);
        BigDecimal principle = SuretyIntCalcHelper.getIntCallPrinciple(suretyBill);
        List<PlanCallResult> repayPlanList = SuretyIntCalcHelper.getAllRepayPlanList(suretyBill, false);
        return SuretyIntCalcHelper.genIntPlan(suretyBill, repayPlanList, intPlanList, principle, beginDate);
    }

    private static List<PlanCallResult> getAllRepayPlanList(DynamicObject suretyBill, boolean isPayInt) {
        ArrayList<PlanCallResult> repayPlanList = new ArrayList<PlanCallResult>(10);
        QFilter filter = new QFilter("suretybill", "=", suretyBill.getPkValue());
        filter = filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObjectCollection repayBills = QueryServiceHelper.query((String)"fbd_suretyreleasebill", (String)"isrevenue,releasedate,amount", (QFilter[])filter.toArray());
        for (DynamicObject repayBill : repayBills) {
            PlanCallResult info = new PlanCallResult();
            if (isPayInt) {
                info.setPayInt(repayBill.getBoolean("isrevenue"));
            }
            info.setBizDate(repayBill.getDate("releasedate"));
            info.setPrinciple(repayBill.getBigDecimal("amount"));
            repayPlanList.add(info);
        }
        return repayPlanList;
    }

    private static void addAllAppendToRepayPlanList(List<PlanCallResult> repayPlanList, DynamicObject suretyBill) {
        DynamicObject[] appendBills;
        QFilter filter = new QFilter("suretybill", "=", suretyBill.getPkValue());
        filter = filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        for (DynamicObject appendBill : appendBills = TmcDataServiceHelper.load((String)"fbd_surety_append", (String)String.join((CharSequence)",", SURETY_APPEND_PROP), (QFilter[])filter.toArray())) {
            PlanCallResult info = new PlanCallResult();
            info.setBizDate(appendBill.getDate("appendintdate"));
            info.setPrinciple(appendBill.getBigDecimal("appendamount").negate());
            repayPlanList.add(info);
        }
    }

    private static DynamicObjectCollection getSuretyAppendBills(DynamicObject suretyBill) {
        QFilter filter = new QFilter("suretybill", "=", suretyBill.getPkValue());
        filter = filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        return QueryServiceHelper.query((String)"fbd_surety_append", (String)"appendintdate,appendamount,amount", (QFilter[])filter.toArray());
    }

    private static Pair<BigDecimal, List<IntBillInfo>> genIntPlan(DynamicObject suretyBill, List<PlanCallResult> repayPlanList, List<PlanCallResult> intPlanList, BigDecimal principle, Date startDate) {
        BigDecimal totalAmt = BigDecimal.ZERO;
        int intPlanSize = intPlanList.size();
        ArrayList<IntBillInfo> list = new ArrayList<IntBillInfo>(intPlanSize);
        if (intPlanList.isEmpty()) {
            return Pair.of((Object)totalAmt, list);
        }
        DynamicObjectCollection suretyAppendBills = SuretyIntCalcHelper.getSuretyAppendBills(suretyBill);
        TreeMap<Date, List<DynamicObject>> dateListMap = new TreeMap<Date, List<DynamicObject>>(suretyAppendBills.stream().collect(Collectors.groupingBy(a -> a.getDate("appendintdate"))));
        Set<RateInfo> rateList = SuretyIntCalcHelper.getRateList(suretyBill);
        for (int index = 0; index < intPlanSize; ++index) {
            DynamicObject productFactory;
            ArrayList<PlanCallResult> repayPlans = new ArrayList<PlanCallResult>(repayPlanList);
            PlanCallResult intPlan = intPlanList.get(index);
            SuretyIntCalcHelper.addAppendToRepayPlan(dateListMap, intPlan, startDate, repayPlans);
            IntBillInfo intBill = SuretyIntCalcHelper.callInt(suretyBill, repayPlans, rateList, startDate, intPlan.getBizDate(), principle, index + 1, RepaymentWayEnum.zdyhk);
            if (EmptyUtil.isNoEmpty((Object)intBill)) {
                totalAmt = totalAmt.add(intBill.getAmount());
                if (EmptyUtil.isNoEmpty((BigDecimal)intBill.getAmount())) {
                    list.add(intBill);
                }
            }
            if (intPlan.getBizDate().after(startDate)) {
                startDate = intPlan.getBizDate();
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)(productFactory = suretyBill.getDynamicObject("productfactory"))) || !"cash".equals(productFactory.getString("profittype"))) continue;
            IntHTRuleEnum htRule = IntHTRuleEnum.valueOf((String)productFactory.getString("intheadtailrule"));
            if (IntHTRuleEnum.headtail == htRule) {
                startDate = DateUtils.getNextDay((Date)startDate, (int)1);
                continue;
            }
            if (IntHTRuleEnum.noheadnotail != htRule) continue;
            startDate = DateUtils.getLastDay((Date)startDate, (int)1);
        }
        return Pair.of((Object)totalAmt, list);
    }

    private static void addAppendToRepayPlan(TreeMap<Date, List<DynamicObject>> dateListMap, PlanCallResult intPlan, Date startDate, List<PlanCallResult> repayPlans) {
        if (startDate.compareTo(intPlan.getBizDate()) > 0) {
            return;
        }
        for (List<DynamicObject> appendBills : dateListMap.headMap(intPlan.getBizDate()).values()) {
            for (DynamicObject appendBill : appendBills) {
                PlanCallResult info = new PlanCallResult();
                info.setBizDate(appendBill.getDate("appendintdate"));
                info.setPrinciple(appendBill.getBigDecimal("appendamount").negate());
                repayPlans.add(info);
            }
        }
    }

    private static BigDecimal getInitAmount(TreeMap<Date, List<DynamicObject>> dateListMap, BigDecimal principle, Date startDate) {
        NavigableMap<Date, List<DynamicObject>> dateListSortedMap = dateListMap.tailMap(startDate, true);
        BigDecimal allAppAount = BigDecimal.ZERO;
        ArrayList values = new ArrayList(16);
        for (List value : dateListSortedMap.values()) {
            values.addAll(value);
        }
        List appendAmountList = values.stream().map(r -> r.getBigDecimal("appendamount")).collect(Collectors.toList());
        for (BigDecimal appAmount : appendAmountList) {
            allAppAount = allAppAount.add(appAmount);
        }
        return principle.subtract(allAppAount);
    }

    private static BigDecimal getIntCallPrinciple(DynamicObject suretyBill) {
        DynamicObjectCollection suretyAppendBills = SuretyIntCalcHelper.getSuretyAppendBills(suretyBill);
        BigDecimal appendAmount = BigDecimal.ZERO;
        for (DynamicObject suretyAppendBill : suretyAppendBills) {
            appendAmount = appendAmount.add(suretyAppendBill.getBigDecimal("appendamount"));
        }
        return suretyBill.getBigDecimal("amount").subtract(appendAmount);
    }

    private static List<PlanCallResult> callIntPlan(DynamicObject suretyBill, Date endDate) {
        Set<RateInfo> rateList = SuretyIntCalcHelper.getRateList(suretyBill);
        BigDecimal surplusAmount = suretyBill.getBigDecimal("surplusamount");
        BigDecimal balance = EmptyUtil.isNoEmpty((BigDecimal)surplusAmount) ? surplusAmount : suretyBill.getBigDecimal("amount");
        ArrayList repayPlanList = new ArrayList(10);
        IntCalRequest request = new IntCalRequest();
        request.setRepayList(repayPlanList);
        Date beginDate = SuretyIntCalcHelper.getBeginIntDate(suretyBill);
        request.setBizBill(SuretyIntCalcHelper.getBizBill(suretyBill, balance, beginDate, endDate, 0, RepaymentWayEnum.zdyhk));
        request.setRateList(rateList);
        return new RevenuePlanCallStragety().callPlan(request);
    }

    private static IntBillInfo callInt(DynamicObject suretyBill, List<PlanCallResult> repayList, Date beginDate, Date endDate, BigDecimal principle, int period, RepaymentWayEnum repayWay) {
        Set<RateInfo> rateList = SuretyIntCalcHelper.getRateList(suretyBill);
        Date expireDate = suretyBill.getDate("expiredate");
        Date callDate = EmptyUtil.isNoEmpty((Object)expireDate) && endDate.after(expireDate) ? expireDate : endDate;
        return SuretyIntCalcHelper.callInt(suretyBill, repayList, rateList, beginDate, callDate, principle, period, repayWay);
    }

    private static IntBillInfo callInt(DynamicObject suretyBill, List<PlanCallResult> repayPlanList, Set<RateInfo> rateList, Date beginDate, Date endDate, BigDecimal principle, int period, RepaymentWayEnum repayWay) {
        IntCalRequest request = new IntCalRequest();
        request.setRepayList(repayPlanList);
        BizBillInfo bizBill = SuretyIntCalcHelper.getBizBill(suretyBill, principle, beginDate, endDate, period, repayWay);
        request.setBizBill(bizBill);
        request.setRateList(rateList);
        SuretyIntCalcHelper.verifyInput(request);
        IIntCallStragety stragety = IntCallFactory.getInstance((RepaymentWayEnum)RepaymentWayEnum.zdyhk);
        return stragety.callInt(request);
    }

    private static void verifyInput(IntCalRequest request) {
        boolean hasEffectiveRate = false;
        for (RateInfo rate : request.getRateList()) {
            if (rate.getEffectiveDate().compareTo(request.getBizBill().getBeginDate()) > 0) continue;
            hasEffectiveRate = true;
            break;
        }
        if (!hasEffectiveRate) {
            throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{ResManager.loadKDString((String)"\u6536\u76ca\u8ba1\u7b97\u5f00\u59cb\u65e5\u5fc5\u987b\u8981\u6709\u53ef\u7528\u5229\u7387\u3002", (String)"SuretyIntCalcHelper_0", (String)"tmc-fbd-common", (Object[])new Object[0])});
        }
    }

    private static Set<RateInfo> getRateList(DynamicObject suretyBill) {
        HashSet<RateInfo> rateList = new HashSet<RateInfo>(16);
        DynamicObjectCollection rates = suretyBill.getDynamicObjectCollection("rateadjust_entry");
        for (DynamicObject rate : rates) {
            RateInfo info = new RateInfo();
            info.setEffectiveDate(rate.getDate("ra_effectdate"));
            info.setRate(rate.getBigDecimal("ra_yearrate"));
            rateList.add(info);
        }
        return rateList;
    }

    private static BizBillInfo getBizBill(DynamicObject suretyBill, BigDecimal loanAmt, Date beginDate, Date endDate, int period, RepaymentWayEnum repayWay) {
        BizBillInfo bizBill = new BizBillInfo();
        bizBill.setLoanAmount(loanAmt);
        bizBill.setBeginDate(beginDate);
        bizBill.setEndDate(endDate);
        if (EmptyUtil.isNoEmpty((DynamicObject)suretyBill.getDynamicObject("revenueplan"))) {
            bizBill.setIntSchemeId(suretyBill.getDynamicObject("revenueplan").getLong("id"));
        }
        bizBill.setRepayWay(repayWay);
        BasisEnum basisEnum = BasisEnum.getEnum((String)suretyBill.getString("basis"));
        bizBill.setBasis(basisEnum == null ? BasisEnum.Actual_365 : basisEnum);
        if (EmptyUtil.isNoEmpty((DynamicObject)suretyBill.getDynamicObject("currency"))) {
            bizBill.setCurrencyId(suretyBill.getDynamicObject("currency").getLong("id"));
        }
        bizBill.setPeriod(period);
        if (RevenueWayEnum.STAGE.getValue().equals(suretyBill.getString("revenueway"))) {
            bizBill.setSettleIntMode(SettleIntModeEnum.gdpljx);
        } else {
            bizBill.setSettleIntMode(SettleIntModeEnum.lsbq);
        }
        DynamicObject productFactory = suretyBill.getDynamicObject("productfactory");
        if (EmptyUtil.isNoEmpty((DynamicObject)productFactory) && "cash".equals(productFactory.getString("profittype"))) {
            bizBill.setHtRule(IntHTRuleEnum.valueOf((String)productFactory.getString("intheadtailrule")));
            bizBill.setRound(RoundRuleEnum.valueOf((String)productFactory.getString("introundrule")));
            bizBill.setIntCalMethod(IntCalMethodEnum.valueOf((String)productFactory.getString("intcalmethod")));
        } else {
            bizBill.setHtRule(IntHTRuleEnum.headnotail);
            bizBill.setRound(RoundRuleEnum.rounded);
            bizBill.setIntCalMethod(IntCalMethodEnum.totalcallint);
        }
        return bizBill;
    }

    public static void addDetail(DynamicObjectCollection intDetails, List<IntBillDetailInfo> details) {
        intDetails.clear();
        int seq = 1;
        for (IntBillDetailInfo detail : details) {
            DynamicObject intDetail = intDetails.addNew();
            intDetail.set("seq", (Object)seq++);
            intDetail.set("inststartdate", (Object)detail.getBeginDate());
            intDetail.set("instenddate", (Object)detail.getEndDate());
            intDetail.set("instdays", (Object)detail.getDays());
            intDetail.set("instprincipalamt", (Object)detail.getPrinciple());
            intDetail.set("rate", (Object)detail.getRate());
            intDetail.set("ratetrandays", (Object)detail.getBasisDay());
            intDetail.set("instamt", (Object)detail.getAmount());
        }
    }

    public static Date getBeginIntDate(DynamicObject suretyBill) {
        Date beginDate = suretyBill.getDate("endinstdate");
        beginDate = EmptyUtil.isNoEmpty((Object)beginDate) ? DateUtils.getNextDay((Date)beginDate, (int)1) : suretyBill.getDate("intdate");
        return beginDate;
    }

    private static Date getEndIntDate(DynamicObject suretyBill) {
        Date endDate = suretyBill.getDate("expiredate");
        if (EmptyUtil.isEmpty((Object)endDate)) {
            endDate = TermHelper.getDateByBaseDate4ymd((String)"1y", (Date)DateUtils.getCurrentDate());
        }
        return endDate;
    }

    public static Date getEndIntDate(DynamicObject suretyBill, Date endDate) {
        BigDecimal notRepayAmount = suretyBill.getBigDecimal("surplusamount");
        Date lastRepayDate = suretyBill.getDate("lastreleasedate");
        if (EmptyUtil.isNoEmpty((Object)lastRepayDate) && EmptyUtil.isNoEmpty((Object)endDate) && EmptyUtil.isEmpty((BigDecimal)notRepayAmount) && endDate.compareTo(lastRepayDate) >= 0) {
            return lastRepayDate;
        }
        return endDate;
    }
}

