/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.suretypreint;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.fbd.common.helper.IntBillBatchHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.preint.AbstractTmcIntBillBatchEdit;
import kd.tmc.fbp.formplugin.list.preint.TmcIntBillListParam;

public class SuretyBillPreIntBatchEdit
extends AbstractTmcIntBillBatchEdit
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"entry", (CharSequence)entryGrid.getKey())) {
            int index = evt.getRow();
            if (index < 0) {
                return;
            }
            this.loanIntEntry(index);
        }
    }

    private void loanIntEntry(int index) {
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", index);
        this.getModel().setValue("intnum", (Object)entry.getString("intdetailnum"));
        this.getModel().setValue("loannum", (Object)entry.getString("loanbillno"));
        this.loanIntDetailInfo(entry);
    }

    public void afterBindData(EventObject e) {
        this.loanIntEntry(0);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "deleteentryloans": {
                String errMsg = this.checkLoansEntry();
                if (EmptyUtil.isNoEmpty((String)errMsg)) {
                    args.setCancel(true);
                    this.getView().showTipNotification(errMsg);
                    return;
                }
                this.dealInterest();
                break;
            }
        }
    }

    protected TmcIntBillListParam getIntBillListParam() {
        TmcIntBillListParam param = new TmcIntBillListParam();
        param.setNavAddNewFormId("fbd_surety_preint_navadd").setTrackDownEntityName("fbd_surety_preint").setTrackUpEntityName("fbd_suretybill");
        return param;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("submit".equals(operateKey)) {
            this.getView().updateView();
        } else if ("deleteentryloans".equals(operateKey)) {
            this.getView().invokeOperation("save");
        }
        this.loanIntEntry(0);
    }

    private void dealInterest() {
        DynamicObjectCollection cl = this.getModel().getEntryEntity("entry");
        int[] indexArr = ((EntryGrid)this.getControl("entry")).getSelectRows();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "TRUE");
        for (int i = 0; i < indexArr.length; ++i) {
            boolean exists;
            DynamicObject interestBill = (DynamicObject)cl.get(indexArr[i]);
            if (!interestBill.containsProperty("intbillid") || !EmptyUtil.isNoEmpty((Long)interestBill.getLong("intbillid")) || !(exists = QueryServiceHelper.exists((String)"fbd_surety_preint", (Object)interestBill.getLong("intbillid")))) continue;
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"fbd_surety_preint", (Object[])new Object[]{interestBill.getLong("intbillid")}, (OperateOption)operateOption, (boolean)true);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"fbd_surety_preint", (Object[])new Object[]{interestBill.getLong("intbillid")}, (OperateOption)operateOption, (boolean)true);
        }
    }

    private String checkLoansEntry() {
        DynamicObjectCollection cl = this.getModel().getEntryEntity("entry");
        int[] indexs = ((EntryGrid)this.getControl("entry")).getSelectRows();
        if (cl.size() == indexs.length) {
            return ResManager.loadKDString((String)"\u81f3\u5c11\u6709\u4e00\u6761\u5206\u5f55\u3002", (String)"SuretyBillSettleIntBatchEdit_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        switch (fieldName = evt.getFieldName()) {
            case "interestamt": {
                this.showIntDetailForm(evt.getRowIndex());
                break;
            }
            case "intdetailnum": {
                IntBillBatchHelper.showIntRevBillForm((Object)this.getModel().getValue("intbillid", evt.getRowIndex()), (String)"fbd_surety_preint", (IFormView)this.getView());
                break;
            }
            case "loanbillno": {
                IntBillBatchHelper.showIntRevBillForm((Object)this.getModel().getValue("loanbillid", evt.getRowIndex()), (String)"fbd_suretybill", (IFormView)this.getView());
            }
        }
    }

    protected void loadIntDetail() {
        this.getModel().deleteEntryData("entry");
        List<Map<String, Object>> intDetail = this.genIntDetails();
        TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), intDetail);
    }

    protected void addNewEntry(String calcIntResultStr) {
        Map calcIntResult = (Map)JSON.parseObject((String)calcIntResultStr, (TypeReference)new TypeReference<Map<String, IntBillInfo>>(){}, (Feature[])new Feature[0]);
        ArrayList intDetails = new ArrayList(calcIntResult.size());
        calcIntResult.forEach((entryJson, intBill) -> {
            Object[] suretyBill = DynamicObjectSerializeUtil.deserialize((String)entryJson, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fbd_suretybill"));
            this.fillIntDetail((DynamicObject)suretyBill[0], (IntBillInfo)intBill, intDetails);
        });
        TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), intDetails, (boolean)false);
    }

    protected String getEntityName() {
        return "fbd_surety_preint_batch";
    }

    public List<Map<String, Object>> genIntDetails() {
        JSONObject navParam = (JSONObject)this.getView().getFormShowParameter().getCustomParams().get("navparam");
        Map calcIntResult = (Map)JSON.parseObject((String)((String)navParam.get((Object)"calcIntResult")), (TypeReference)new TypeReference<Map<String, IntBillInfo>>(){}, (Feature[])new Feature[0]);
        ArrayList<Map<String, Object>> intDetails = new ArrayList<Map<String, Object>>(calcIntResult.size());
        calcIntResult.forEach((entryJson, intBill) -> {
            Object[] suretyBill = DynamicObjectSerializeUtil.deserialize((String)entryJson, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fbd_suretybill"));
            this.fillIntDetail((DynamicObject)suretyBill[0], (IntBillInfo)intBill, (List<Map<String, Object>>)intDetails);
        });
        return intDetails;
    }

    protected void fillIntDetail(DynamicObject suretyBill, IntBillInfo intBill, List<Map<String, Object>> dataMap) {
        if (EmptyUtil.isEmpty((Object)intBill) || EmptyUtil.isEmpty((BigDecimal)intBill.getAmount())) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("company", suretyBill.getDynamicObject("org"));
        data.put("currency", suretyBill.getDynamicObject("currency"));
        data.put("finorginfo", suretyBill.getDynamicObject("finorginfo"));
        data.put("finorgother", suretyBill.getString("finorgother"));
        data.put("investorgtype", suretyBill.getString("investorgtype"));
        data.put("loanbillno", suretyBill.getString("billno"));
        data.put("loanbillid", suretyBill.getLong("id"));
        data.put("startdate", intBill.getBeginDate());
        data.put("enddate", intBill.getEndDate());
        data.put("intdays", TermHelper.getDiffDays((Date)intBill.getBeginDate(), (Date)intBill.getEndDate()) + 1);
        data.put("interestamt", intBill.getAmount());
        data.put("actualinstamt", intBill.getAmount());
        data.put("isreverse", Boolean.FALSE);
        data.put("intdetail_tag", SerializationUtils.toJsonString((Object)intBill));
        dataMap.add(data);
    }

    private void showIntDetailForm(int index) {
        FormShowParameter parameter = new FormShowParameter();
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", index);
        String callIntStr = entry.getString("intdetail_tag");
        parameter.getCustomParams().put("intdetail_tag", callIntStr);
        parameter.getCustomParams().put("currency", entry.getDynamicObject("currency").getPkValue());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId("fbd_intbill_detail");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void loanIntDetailInfo(DynamicObject entry) {
        Object currency = entry.getDynamicObject("currency").getPkValue();
        String callIntStr = entry.getString("intdetail_tag");
        if (EmptyUtil.isEmpty((String)callIntStr)) {
            return;
        }
        IntBillInfo intBillInfo = (IntBillInfo)SerializationUtils.fromJsonString((String)callIntStr, IntBillInfo.class);
        List details = intBillInfo.getDetails();
        details.sort(new Comparator<IntBillDetailInfo>(){

            @Override
            public int compare(IntBillDetailInfo arg0, IntBillDetailInfo arg1) {
                return arg0.getBeginDate().compareTo(arg1.getBeginDate());
            }
        });
        ArrayList dataMap = new ArrayList(details.size());
        for (IntBillDetailInfo intDetail : details) {
            if (EmptyUtil.isEmpty((BigDecimal)intDetail.getPrinciple())) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put("intstartdate", intDetail.getBeginDate());
            data.put("intenddate", intDetail.getEndDate());
            data.put("intentrydays", intDetail.getDays());
            data.put("intprinciple", intDetail.getPrinciple());
            data.put("intrate", intDetail.getRate());
            data.put("intdate", intDetail.getBeginDate());
            data.put("intcurrency", currency);
            data.put("entryinterestamt", intDetail.getAmount());
            data.put("basis", intDetail.getBasisDay());
            data.put("intcategory", intDetail.getIntType().getValue());
            dataMap.add(data);
        }
        TmcViewInputHelper.batchFillWithoutPropChg((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"intentry", dataMap, (boolean)true);
        this.getModel().setDataChanged(false);
    }
}

