/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.suretystlint;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.fbd.common.enums.RevenueWayEnum;
import kd.tmc.fbd.common.helper.SuretyIntCalcHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.SuretyBizStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.preint.AbstractTmcIntBillNavAddNewPlugin;
import kd.tmc.fbp.formplugin.list.preint.TmcNavAddNewBillParam;
import org.apache.commons.lang3.StringUtils;

public class SuretyBillSettleIntNavAddNewPlugin
extends AbstractTmcIntBillNavAddNewPlugin
implements BeforeF7SelectListener {
    private static final String PROP_FBASEDATAID = "fbasedataid";
    private static final String PROP_ENDINTDATE = "bizdate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit company = (BasedataEdit)this.getControl("company");
        company.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"next"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initLoanBillInfo();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String suretyBillNo;
        String[] billNos;
        QFilter existFilter;
        DynamicObjectCollection settleInts;
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equals("next") && EmptyUtil.isNoEmpty((DynamicObjectCollection)(settleInts = QueryServiceHelper.query((String)"fbd_surety_settleint", (String)"billno", (QFilter[])(existFilter = new QFilter("loanbillno", "in", (Object)(billNos = StringUtils.split((String)(suretyBillNo = (String)this.getModel().getValue(this.getNavAddNewBillParam().getBillPropName())), (String)";"))).and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())).toArray())))) {
            List billNo = settleInts.stream().map(d -> d.getString("billno")).collect(Collectors.toList());
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u672a\u5b8c\u6210\u7684\u6536\u76ca\u5355\u3010%s\u3011\u3002", (String)"SuretyBillSettleIntNavAddNewPlugin_1", (String)"tmc-fbd-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", billNo)}));
            args.setCancel(true);
            return;
        }
        super.beforeDoOperation(args);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "company": 
            case "currency": {
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{this.getNavAddNewBillParam().getBillPropName()});
                break;
            }
        }
    }

    protected List<Object> beforeCalcInterest(TmcNavAddNewBillParam navAddNewBillParam) {
        List suretyBillIds;
        String showBillPropName = navAddNewBillParam.getBillPropName();
        String selectBillIds = this.getPageCache().get(showBillPropName);
        if (EmptyUtil.isEmpty((String)selectBillIds)) {
            QFilter qFilter = this.buildSelectBillFilter();
            suretyBillIds = QueryServiceHelper.queryPrimaryKeys((String)navAddNewBillParam.getBillEntityName(), (QFilter[])qFilter.toArray(), (String)"", (int)-1);
        } else {
            suretyBillIds = (List)SerializationUtils.fromJsonString((String)selectBillIds, List.class);
        }
        return suretyBillIds;
    }

    protected Map<Object, IntBillInfo> calcInterest(TmcNavAddNewBillParam navAddNewBillParam, List<Object> suretyBillIds) {
        DynamicObject[] suretyBillList;
        HashMap<Object, IntBillInfo> interestMap = new HashMap<Object, IntBillInfo>(16);
        for (DynamicObject suretyBill : suretyBillList = TmcDataServiceHelper.load((Object[])suretyBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)navAddNewBillParam.getBillEntityName()))) {
            Date beginDate = SuretyIntCalcHelper.getBeginIntDate((DynamicObject)suretyBill);
            Date endDate = (Date)this.getModel().getValue(PROP_ENDINTDATE);
            IntBillInfo intBillInfo = SuretyIntCalcHelper.callInt((Long)suretyBill.getLong("id"), (Date)beginDate, (Date)endDate, (boolean)true);
            if (intBillInfo == null || !EmptyUtil.isNoEmpty((BigDecimal)intBillInfo.getAmount())) continue;
            interestMap.put(DynamicObjectSerializeUtil.serialize((Object[])new Object[]{suretyBill}, (DynamicObjectType)suretyBill.getDynamicObjectType()), intBillInfo);
        }
        return interestMap;
    }

    protected TmcNavAddNewBillParam getNavAddNewBillParam() {
        TmcNavAddNewBillParam param = new TmcNavAddNewBillParam();
        param.setBillPropName("loanbill").setBillEntityName("fbd_suretybill");
        return param;
    }

    protected Map<String, Object> getNavFilterMap() {
        HashMap<String, Object> valMap = new HashMap<String, Object>(16);
        valMap.put("company", this.getModel().getValue("company"));
        valMap.put("currency", this.getModel().getValue("currency"));
        valMap.put(PROP_ENDINTDATE, this.getModel().getValue(PROP_ENDINTDATE));
        valMap.put("calcIntResult", this.getPageCache().get("calcIntResult"));
        return valMap;
    }

    protected QFilter buildSelectBillFilter() {
        List<String> bizStatus = Arrays.asList(SuretyBizStatusEnum.SURETY_DONE.getValue(), SuretyBizStatusEnum.SURETY_PART.getValue());
        QFilter qFilter = new QFilter("bizstatus", "in", bizStatus);
        qFilter.and("revenueway", "!=", (Object)RevenueWayEnum.NOREVENUE.getValue());
        DynamicObjectCollection company = (DynamicObjectCollection)this.getModel().getValue("company");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)company)) {
            Set companyIds = company.stream().map(v -> v.getDynamicObject(PROP_FBASEDATAID).getPkValue()).collect(Collectors.toSet());
            qFilter.and("org", "in", companyIds);
        } else {
            qFilter.and("org", "in", this.getAuthOrgIds());
        }
        DynamicObjectCollection currency = (DynamicObjectCollection)this.getModel().getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currency)) {
            Set ids = currency.stream().map(c -> c.getDynamicObject(PROP_FBASEDATAID).getLong("id")).collect(Collectors.toSet());
            qFilter.and("currency", "in", ids);
        }
        Date endIntDate = (Date)this.getModel().getValue(PROP_ENDINTDATE);
        Date lastDay = DateUtils.getLastDay((Date)endIntDate, (int)1);
        QFilter beforePreIntDate = QFilter.isNotNull((String)"endpreinstdate").and("endpreinstdate", "<", (Object)lastDay);
        QFilter afterIntDate = QFilter.isNull((String)"endpreinstdate").and("intdate", "<=", (Object)lastDay);
        qFilter.and(beforePreIntDate.or(afterIntDate));
        Object loanIds = this.getView().getFormShowParameter().getCustomParams().get("loanIds");
        if (EmptyUtil.isNoEmpty(loanIds)) {
            qFilter.and("id", "not in", loanIds);
        }
        return qFilter;
    }

    private List<Long> getAuthOrgIds() {
        String appId = this.getView().getFormShowParameter().getAppId();
        String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)entity, (String)"47150e89000000ac");
        return comIdList;
    }

    public String getNonIntDataTip() {
        return ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u6536\u76ca\u7684\u6570\u636e\u3002", (String)"SuretyBillSettleIntNavAddNewPlugin_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]);
    }

    private void initLoanBillInfo() {
        String billPropName;
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        Object billObj = customParam.get(billPropName = this.getNavAddNewBillParam().getBillPropName());
        if (EmptyUtil.isNoEmpty(billObj)) {
            Object[] suretyBills = DynamicObjectSerializeUtil.deserialize((String)((String)billObj), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fbd_suretybill"));
            List suretyBillList = Arrays.stream(suretyBills).map(v -> (DynamicObject)v).collect(Collectors.toList());
            List billIds = suretyBillList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            this.getPageCache().put(billPropName, SerializationUtils.toJsonString(billIds));
            String billno = suretyBillList.stream().map(v -> v.getString("billno")).collect(Collectors.joining(";"));
            this.getModel().setValue(billPropName, (Object)billno);
            this.getView().setEnable(Boolean.FALSE, new String[]{billPropName});
            this.getView().updateView(billPropName);
            List<DynamicObject> currencys = suretyBillList.stream().map(row -> row.getDynamicObject("currency")).collect(Collectors.toList());
            DynamicObjectCollection currencyColls = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"currency", (DynamicObject[])currencys.toArray(new DynamicObject[0]));
            this.getModel().setValue("currency", (Object)currencyColls);
            this.getView().setEnable(Boolean.FALSE, new String[]{"currency"});
            this.getView().updateView("currency");
            List<DynamicObject> orgs = suretyBillList.stream().map(row -> row.getDynamicObject("org")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(orgs)) {
                DynamicObjectCollection companyColls = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"company", (DynamicObject[])orgs.toArray(new DynamicObject[0]));
                this.getModel().setValue("company", (Object)companyColls);
                this.getView().setEnable(Boolean.FALSE, new String[]{"company"});
                this.getView().updateView("company");
            }
        }
    }
}

