/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.validate.guaranteeuse;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class GuaranteeUseSaveOrSubmitValidator
extends AbstractTmcBizOppValidator {
    public static final String GUARANTEE_VARIETIES = "guaranteevarieties";
    public static final String CREDIT_GUARANTEE = "creditguarantee";
    private static String[] G_USE_PROPS = new String[]{"gcomment", "gcontract", "gamount", "gcontract.amount", "gcontract.currency", "gratio", "gsrcbillid", "gsrcbilltype", "gexchrate", "gstatus", "gcreditortype", "gcreditor", "gcreditortext"};
    private static List<String> validGuaranteeEntityList = new ArrayList<String>(12);
    private static List<String> loanBillEntityList;
    private static Map<String, String> guaranteeWayMap;

    protected String getBizProp(String entity, String prop) {
        return GuaranteeUseHelper.getBizPropName((String)entity, (String)prop);
    }

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("guaranteeway");
        selector.add("guarantee");
        selector.add("biztype");
        selector.add("entry_gcontract");
        selector.add("entry_gcontract.gsrcbilltype");
        selector.add("entry_gcontract.gsrcbillid");
        return selector;
    }

    /*
     * WARNING - void declaration
     */
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        ExtendedDataEntity[] bizBillsFromDb;
        String operateKey = this.getOperateKey();
        if (this.getOption().getVariables().containsKey("_ignore_validate_gc")) {
            return;
        }
        Map<Object, Object> entryFromDbMap = Collections.emptyMap();
        boolean isImport = this.getOption().getVariables().containsKey("importtag_of_datasource");
        boolean fromEdit = isImport || this.getOption().getVariables().containsKey("op_from_edit_form") || Arrays.asList("ifm_bizdealbill", "fl_contract_apply", "cfm_contract_apply").contains(extendedDataEntities[0].getDataEntity().getDataEntityType().getName());
        HashMap<Long, ExtendedDataEntity> bizBillFromDbMap = new HashMap<Long, ExtendedDataEntity>(extendedDataEntities.length);
        HashSet<Long> gContractIdSet = new HashSet<Long>(extendedDataEntities.length);
        if (!fromEdit) {
            entryFromDbMap = this.getGuaranteeUseFromDb((DynamicObject[])Arrays.stream(extendedDataEntities).map(o -> o.getDataEntity()).toArray(DynamicObject[]::new));
            bizBillsFromDb = BusinessDataServiceHelper.load((Object[])Arrays.stream(extendedDataEntities).map(v -> v.getDataEntity().getPkValue()).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)extendedDataEntities[0].getDataEntity().getDataEntityType().getName()));
            for (ExtendedDataEntity bizBillDb : bizBillsFromDb) {
                bizBillFromDbMap.put(bizBillDb.getLong("id"), bizBillDb);
            }
            for (List list : entryFromDbMap.values()) {
                gContractIdSet.addAll(list.stream().map(a -> a.getDynamicObject("gcontract").getLong("id")).collect(Collectors.toSet()));
            }
        } else {
            void var10_15;
            bizBillsFromDb = extendedDataEntities;
            int n = bizBillsFromDb.length;
            boolean bl = false;
            while (var10_15 < n) {
                ExtendedDataEntity dataEntity = bizBillsFromDb[var10_15];
                DynamicObjectCollection gcUseList = dataEntity.getDataEntity().getDynamicObjectCollection("entry_gcontract");
                gContractIdSet.addAll(gcUseList.stream().map(a -> a.getDynamicObject("gcontract").getLong("id")).collect(Collectors.toSet()));
                ++var10_15;
            }
        }
        Map<Long, Boolean> creditGuaranteeMap = this.getCreditGuarantee(gContractIdSet);
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            String[] split;
            String guartype;
            DynamicObject bizBill = dataEntity.getDataEntity();
            if (!fromEdit && QueryServiceHelper.exists((String)bizBill.getDataEntityType().getName(), (Object)bizBill.getPkValue())) {
                bizBill = (DynamicObject)bizBillFromDbMap.get(bizBill.getLong("id"));
            }
            this.validate(dataEntity, bizBill, entryFromDbMap, creditGuaranteeMap);
            if (!"submit".equals(operateKey)) continue;
            IDataEntityType dataEntityType = dataEntity.getDataEntity().getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            String prop = "";
            if (properties.containsKey((Object)"guartype")) {
                prop = "guartype";
            }
            if (properties.containsKey((Object)"guarantee")) {
                prop = "guarantee";
            }
            if (properties.containsKey((Object)"guaranteeway")) {
                prop = "guaranteeway";
            }
            if (EmptyUtil.isEmpty((String)prop)) {
                if (!properties.containsKey((Object)"loancontractbill")) continue;
                DynamicObject loanContractBill = (DynamicObject)dataEntity.getValue("loancontractbill");
                guartype = loanContractBill.getString("guarantee");
            } else {
                guartype = (String)dataEntity.getValue(prop);
            }
            if (!EmptyUtil.isNoEmpty((String)guartype)) continue;
            int i = guartype.indexOf(",");
            if (i == 0) {
                guartype = guartype.substring(1, guartype.length() - 1);
            }
            if (!guartype.contains("none") && !guartype.contains("7") || (split = guartype.split(",")).length <= 1) continue;
            this.addErrorMsg(dataEntity, ResManager.loadKDString((String)"\u65e0\u62c5\u4fdd\u53ca\u5176\u4ed6\u62c5\u4fdd\u65b9\u5f0f\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u3002", (String)"GuaranteeUseSaveOrSubmitValidator_13", (String)"tmc-fbp-business", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - void declaration
     */
    public Map<Long, String> validate(DynamicObject[] bizBills, boolean fromEdit) {
        DynamicObject[] bizBillsFromDb;
        Map<Object, Object> entryFromDbMap = Collections.emptyMap();
        HashMap<Long, DynamicObject> bizBillFromDbMap = new HashMap<Long, DynamicObject>(bizBills.length);
        HashSet<Long> gContractIdSet = new HashSet<Long>(bizBills.length);
        if (!fromEdit) {
            entryFromDbMap = this.getGuaranteeUseFromDb(bizBills);
            bizBillsFromDb = BusinessDataServiceHelper.load((Object[])Arrays.stream(bizBills).map(v -> v.getPkValue()).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)bizBills[0].getDataEntityType().getName()));
            for (DynamicObject bizBillDb : bizBillsFromDb) {
                bizBillFromDbMap.put(bizBillDb.getLong("id"), bizBillDb);
            }
            for (List list : entryFromDbMap.values()) {
                gContractIdSet.addAll(list.stream().map(a -> a.getDynamicObject("gcontract").getLong("id")).collect(Collectors.toSet()));
            }
        } else {
            void var8_13;
            bizBillsFromDb = bizBills;
            int n = bizBillsFromDb.length;
            boolean bl = false;
            while (var8_13 < n) {
                DynamicObject bizBill = bizBillsFromDb[var8_13];
                DynamicObjectCollection gcUseList = bizBill.getDynamicObjectCollection("entry_gcontract");
                gContractIdSet.addAll(gcUseList.stream().map(a -> a.getDynamicObject("gcontract").getLong("id")).collect(Collectors.toSet()));
                ++var8_13;
            }
        }
        Map<Long, Boolean> creditGuaranteeMap = this.getCreditGuarantee(gContractIdSet);
        HashMap<Long, String> errorMsgMap = new HashMap<Long, String>(bizBills.length);
        for (DynamicObject bizBill : bizBills) {
            String errorMsg;
            if (!fromEdit) {
                bizBill = (DynamicObject)bizBillFromDbMap.get(bizBill.getLong("id"));
            }
            if ((errorMsg = this.validate(null, bizBill, entryFromDbMap, creditGuaranteeMap)) == null || errorMsg.length() <= 0) continue;
            errorMsgMap.put(bizBill.getLong("id"), errorMsg);
        }
        return errorMsgMap;
    }

    public String validate(ExtendedDataEntity dataEntity, DynamicObject bizBill, Map<Long, List<DynamicObject>> entryFromDbMap, Map<Long, Boolean> creditGuaranteeMap) {
        Long billId = bizBill.getLong("id");
        Object gcUseEntryList = EmptyUtil.isNoEmpty(entryFromDbMap.get(billId)) ? entryFromDbMap.get(billId) : bizBill.getDynamicObjectCollection("entry_gcontract");
        StringBuilder errorMsg = this.validate_guaranteeWayAndEntryCount(dataEntity, bizBill, (List<DynamicObject>)(gcUseEntryList = gcUseEntryList.stream().filter(o -> BigDecimal.ZERO.compareTo(o.getBigDecimal("gratio")) != 0).collect(Collectors.toList())), creditGuaranteeMap);
        if (errorMsg.length() > 0) {
            return errorMsg.toString();
        }
        errorMsg = this.validate_gm_letterofguaapply(dataEntity, bizBill, (List<DynamicObject>)gcUseEntryList, creditGuaranteeMap);
        if (errorMsg.length() > 0) {
            return errorMsg.toString();
        }
        if (EmptyUtil.isEmpty((Collection)gcUseEntryList)) {
            return "";
        }
        String entityName = bizBill.getDataEntityType().getName();
        BigDecimal bizAmount = bizBill.getBigDecimal(this.getBizProp(entityName, "bizamount"));
        HashMap<Long, BigDecimal> syncDrawAmountMap = new HashMap<Long, BigDecimal>();
        if (dataEntity != null && dataEntity.getDataEntity().containsProperty("synccreditlimit") && !EmptyUtil.isEmpty((DynamicObject)dataEntity.getDataEntity().getDynamicObject("synccreditlimit"))) {
            BigDecimal syncDrawAmount = bizBill.getBigDecimal("syncdrawamount");
            DynamicObject syncCreditLimit = dataEntity.getDataEntity().getDynamicObject("synccreditlimit");
            DynamicObjectCollection gcUseBills = GuaranteeUseHelper.getGuaranteeUseBills((Long)syncCreditLimit.getLong("id"));
            for (DynamicObject gcUseBill : gcUseBills) {
                syncDrawAmountMap.put(gcUseBill.getLong("gcontract"), syncDrawAmount);
            }
        }
        Map bizAmountMap = GuaranteeUseHelper.getBankSyncMap((String)entityName, (DynamicObject)bizBill);
        HashSet<String> entryGcIds = new HashSet<String>(16);
        HashSet<String> duplicateNos = new HashSet<String>(16);
        for (int i = 0; i < gcUseEntryList.size(); ++i) {
            BigDecimal gExChRate;
            DynamicObject gc = (DynamicObject)gcUseEntryList.get(i);
            boolean isRelieve = gc.containsProperty("gstatus") && "C".equals(gc.getString("gstatus"));
            DynamicObject gContract = gc.getDynamicObject("gcontract");
            boolean passEmptyCheck = true;
            if (EmptyUtil.isEmpty((DynamicObject)gContract)) {
                errorMsg.append(this.addErrorMsg(dataEntity, ResManager.loadResFormat((String)"\u7b2c%s\u884c\uff0c\u62c5\u4fdd\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GuaranteeUseSaveOrSubmitValidator_01", (String)"tmc-fbp-business", (Object[])new Object[]{i + 1})));
                passEmptyCheck = false;
            }
            BigDecimal gAmount = gc.getBigDecimal("gamount");
            BigDecimal gRatio = gc.getBigDecimal("gratio");
            if (EmptyUtil.isEmpty((BigDecimal)gAmount) && !isRelieve && EmptyUtil.isNoEmpty((DynamicObject)gContract) && !creditGuaranteeMap.get(gContract.getLong("id")).booleanValue()) {
                errorMsg.append(this.addErrorMsg(dataEntity, ResManager.loadResFormat((String)"\u7b2c%s\u884c\uff0c\u62c5\u4fdd\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GuaranteeUseSaveOrSubmitValidator_02", (String)"tmc-fbp-business", (Object[])new Object[]{i + 1})));
                passEmptyCheck = false;
            }
            if (EmptyUtil.isEmpty((BigDecimal)gRatio) && !isRelieve) {
                errorMsg.append(this.addErrorMsg(dataEntity, ResManager.loadResFormat((String)"\u7b2c%s\u884c\uff0c\u62c5\u4fdd\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GuaranteeUseSaveOrSubmitValidator_03", (String)"tmc-fbp-business", (Object[])new Object[]{i + 1})));
                passEmptyCheck = false;
            }
            if (EmptyUtil.isEmpty((BigDecimal)(gExChRate = gc.getBigDecimal("gexchrate")))) {
                errorMsg.append(this.addErrorMsg(dataEntity, ResManager.loadResFormat((String)"\u7b2c%s\u884c\uff0c\u6298\u7b97\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GuaranteeUseSaveOrSubmitValidator_00", (String)"tmc-fbp-business", (Object[])new Object[]{i + 1})));
            }
            if (passEmptyCheck) {
                Long gcContractId = gContract.getLong("id");
                if (!"ifm_bizdealbill".equals(entityName)) {
                    BigDecimal validBizAmount = bizAmount;
                    if (GuaranteeUseHelper.getMultiCreditorFlag((String)entityName) && creditGuaranteeMap.getOrDefault(gcContractId, false).booleanValue() && bizAmountMap.containsKey(gc.getString("gcreditortype") + gc.getLong("gcreditor"))) {
                        validBizAmount = (BigDecimal)bizAmountMap.get(gc.getString("gcreditortype") + gc.getLong("gcreditor"));
                    } else if (!EmptyUtil.isEmpty(syncDrawAmountMap) && !EmptyUtil.isEmpty((BigDecimal)((BigDecimal)syncDrawAmountMap.get(gcContractId)))) {
                        validBizAmount = (BigDecimal)syncDrawAmountMap.get(gcContractId);
                    }
                    if (EmptyUtil.isNoEmpty((BigDecimal)gAmount) && EmptyUtil.isNoEmpty((BigDecimal)validBizAmount) && gRatio.setScale(0, RoundingMode.HALF_UP).compareTo(gAmount.divide(validBizAmount, RoundingMode.HALF_UP).multiply(Constants.ONE_HUNDRED).setScale(0, RoundingMode.HALF_UP)) != 0) {
                        errorMsg.append(this.addErrorMsg(dataEntity, String.format(ResManager.loadResFormat((String)"\u7b2c%1$s\u884c\uff0c\u62c5\u4fdd\u5408\u540c%2$s\u6240\u5728\u5206\u5f55\u884c\u4e2d\u62c5\u4fdd\u91d1\u989d\u9664\u4ee5\u5355\u636e\u4e1a\u52a1\u91d1\u989d\u6240\u5f97\u4e0e\u62c5\u4fdd\u6bd4\u4f8b\u4e0d\u5339\u914d\u3002", (String)"GuaranteeUseSaveOrSubmitValidator_04", (String)"tmc-fbp-business", (Object[])new Object[0]), i + 1, gContract.getString("guaranteeno"))));
                    }
                }
                if (!creditGuaranteeMap.getOrDefault(gcContractId, false).booleanValue()) {
                    if (!BillStatusEnum.AUDIT.getValue().equals(gContract.getString("billstatus"))) {
                        errorMsg.append(this.addErrorMsg(dataEntity, String.format(ResManager.loadResFormat((String)"\u7b2c%1$s\u884c\uff0c\u62c5\u4fdd\u5408\u540c%2$s\u975e\u5ba1\u6838\u72b6\u6001\u3002", (String)"GuaranteeUseSaveOrSubmitValidator_07", (String)"tmc-fbp-business", (Object[])new Object[0]), i + 1, gContract.getString("guaranteeno"))));
                    }
                    if ("closed".equals(gContract.getString("bizstatus"))) {
                        errorMsg.append(this.addErrorMsg(dataEntity, String.format(ResManager.loadResFormat((String)"\u7b2c%1$s\u884c\uff0c\u62c5\u4fdd\u5408\u540c%2$s\u4e1a\u52a1\u72b6\u6001\u5df2\u662f\u5173\u95ed\u72b6\u6001\u3002", (String)"GuaranteeUseSaveOrSubmitValidator_08", (String)"tmc-fbp-business", (Object[])new Object[0]), i + 1, gContract.getString("guaranteeno"))));
                    }
                }
            }
            if (gContract != null) {
                String gContractId = String.valueOf(gContract.getLong("id"));
                if (entryGcIds.contains(gContractId)) {
                    duplicateNos.add(gContract.getString("guaranteeno"));
                }
                if (GuaranteeUseHelper.getMultiCreditorFlag((String)entityName) && bizAmountMap.containsKey(gc.getString("gcreditortype") + gc.getLong("gcreditor"))) {
                    gContractId = gContractId + gc.getString("gcreditortype") + gc.getLong("gcreditor");
                }
                entryGcIds.add(gContractId);
            }
            if (!EmptyUtil.isNoEmpty(duplicateNos)) continue;
            errorMsg.append(this.addErrorMsg(dataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u4fe1\u606f\u4e2d\u62c5\u4fdd\u5408\u540c%s\u5b58\u5728\u91cd\u590d\u3002", (String)"GuaranteeUseSaveOrSubmitValidator_05", (String)"tmc-fbp-business", (Object[])new Object[]{String.join((CharSequence)",", duplicateNos)})));
        }
        return errorMsg.toString();
    }

    private Map<Long, Boolean> getCreditGuarantee(Set<Long> gContractIdSet) {
        DynamicObject[] guaranteeVarArr = BusinessDataServiceHelper.load((String)"gm_guaranteecontract", (String)"id,guarantee,guarantee.creditguarantee", (QFilter[])new QFilter[]{new QFilter("id", "in", gContractIdSet)});
        return Arrays.stream(guaranteeVarArr).collect(Collectors.toMap(k -> k.getLong("id"), e -> e.getBoolean("guarantee.creditguarantee")));
    }

    private boolean canSkipMustInputEntry(DynamicObject bizBill) {
        if (!loanBillEntityList.contains(bizBill.getDataEntityType().getName())) {
            return false;
        }
        if (bizBill.getDataEntityType().getProperties().containsKey((Object)"eassrcid") && EmptyUtil.isNoEmpty((String)bizBill.getString("eassrcid"))) {
            return true;
        }
        Long cid = bizBill.getDynamicObject("loancontractbill").getLong("id");
        DynamicObject contract = QueryServiceHelper.queryOne((String)"cfm_loancontractbill", (String)"eassrcid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cid)});
        return contract != null && EmptyUtil.isNoEmpty((String)contract.getString("eassrcid"));
    }

    private StringBuilder validate_guaranteeWayAndEntryCount(ExtendedDataEntity dataEntity, DynamicObject bizBill, List<DynamicObject> gcUseEntryList, Map<Long, Boolean> creditMap) {
        String guaranteeWay_pledge;
        String guaranteeWay_mortgage;
        String guaranteeWay_ensure;
        String guaranteeWayColumn;
        StringBuilder errorMsg = new StringBuilder();
        if (validGuaranteeEntityList.contains(bizBill.getDataEntityType().getName()) && (!"ifm_bizdealbill".equals(bizBill.getDataEntityType().getName()) || Arrays.asList("fin_apply", "loan_apply").contains(bizBill.getString("applitype"))) || this.validLoancontractSyncDraw(bizBill)) {
            guaranteeWayColumn = "cfm_loanbill_bond".equals(bizBill.getDataEntityType().getName()) ? "guaranteeway" : "guarantee";
            guaranteeWay_ensure = "2";
            guaranteeWay_mortgage = "4";
            guaranteeWay_pledge = "5";
        } else if ("gm_letterofguarantee".equals(bizBill.getDataEntityType().getName())) {
            guaranteeWayColumn = "guaranteeway";
            guaranteeWay_ensure = "ensure";
            guaranteeWay_mortgage = "mortgage";
            guaranteeWay_pledge = "pledge";
        } else {
            return errorMsg;
        }
        String guarantee = this.getGuaranteeWay(bizBill, guaranteeWayColumn);
        Set gcUseEntrySet = gcUseEntryList.stream().filter(f -> (Boolean)creditMap.get(f.getDynamicObject("gcontract").getLong("id")) == false).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty((String)guarantee) && (guarantee.indexOf(guaranteeWay_ensure) != -1 || guarantee.indexOf(guaranteeWay_mortgage) != -1 || guarantee.indexOf(guaranteeWay_pledge) != -1)) {
            if (EmptyUtil.isEmpty(gcUseEntryList) && this.isRelateDebt(bizBill) && !this.canSkipMustInputEntry(bizBill)) {
                errorMsg.append(this.addErrorMsg(dataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f\u4e3a\u4fdd\u8bc1\u3001\u62b5\u62bc\u3001\u8d28\u62bc\u65f6\uff0c\u8bf7\u5148\u586b\u5199\u62c5\u4fdd\u4fe1\u606f\u3002", (String)"GuaranteeUseSaveOrSubmitValidator_10", (String)"tmc-fbp-business", (Object[])new Object[0])));
                return errorMsg;
            }
        } else if (EmptyUtil.isNoEmpty(gcUseEntrySet)) {
            errorMsg.append(this.addErrorMsg(dataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f\u4e0d\u5305\u542b\u4fdd\u8bc1\u3001\u62b5\u62bc\u3001\u8d28\u62bc\u65f6\uff0c\u201c\u62c5\u4fdd\u4fe1\u606f\u201d\u4e0d\u5141\u8bb8\u5b58\u5728\u975e\u989d\u5ea6\u62c5\u4fdd\u4fe1\u606f\u3002", (String)"GuaranteeUseSaveOrSubmitValidator_11", (String)"tmc-fbp-business", (Object[])new Object[0])));
            return errorMsg;
        }
        for (DynamicObject gcUseEntry : gcUseEntrySet) {
            String gGuaranteeWay;
            DynamicObject gContract = gcUseEntry.getDynamicObject("gcontract");
            if (ObjectUtils.isEmpty((Object)gContract) || this.isMatch(guarantee, gGuaranteeWay = gContract.getString("guaranteeway"))) continue;
            errorMsg.append(this.addErrorMsg(dataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u5408\u540c\u3010%s\u3011\u7684\u62c5\u4fdd\u65b9\u5f0f\u4e0e\u5355\u636e\u4e0d\u5339\u914d\u3002", (String)"GuaranteeUseSaveOrSubmitValidator_12", (String)"tmc-fbp-business", (Object[])new Object[]{gContract.getString("billno")})));
        }
        return errorMsg;
    }

    public String getGuaranteeWay(DynamicObject bizBill, String guaranteeWayColumn) {
        if (loanBillEntityList.contains(bizBill.getDataEntityType().getName())) {
            return bizBill.getDynamicObject("loancontractbill").getString(guaranteeWayColumn);
        }
        return bizBill.getString(guaranteeWayColumn);
    }

    private boolean isRelateDebt(DynamicObject bizBill) {
        return TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.GM.getId(), (long)bizBill.getDynamicObject(EntityMetadataCache.getDataEntityType((String)bizBill.getDataEntityType().getName()).getMainOrg()).getLong("id"), (String)"isrelatedebt");
    }

    private boolean isMatch(String billGuaranteeWay, String gGuaranteeWay) {
        for (Map.Entry<String, String> entry : guaranteeWayMap.entrySet()) {
            if (!billGuaranteeWay.contains(entry.getKey()) && !billGuaranteeWay.contains(entry.getValue()) || !gGuaranteeWay.contains(entry.getKey()) && !gGuaranteeWay.contains(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private StringBuilder validate_gm_letterofguaapply(ExtendedDataEntity dataEntity, DynamicObject bizBill, List<DynamicObject> gcUseEntryList, Map<Long, Boolean> creditMap) {
        StringBuilder errorMsg = new StringBuilder();
        if (!"gm_letterofguaapply".equals(bizBill.getDataEntityType().getName())) {
            return errorMsg;
        }
        Set gcUseEntrySet = gcUseEntryList.stream().filter(f -> (Boolean)creditMap.get(f.getDynamicObject("gcontract").getLong("id")) == false).collect(Collectors.toSet());
        String guaranteeWay = bizBill.getString("guaranteeway");
        String bizType = bizBill.getString("biztype");
        if ("change".equals(bizType)) {
            if (EmptyUtil.isNoEmpty((String)guaranteeWay) && (guaranteeWay.indexOf("ensure") != -1 || guaranteeWay.indexOf("mortgage") != -1 || guaranteeWay.indexOf("pledge") != -1)) {
                if (EmptyUtil.isEmpty(gcUseEntryList) && this.isRelateDebt(bizBill)) {
                    errorMsg.append(this.addErrorMsg(dataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f\u4e3a\u4fdd\u8bc1\u3001\u62b5\u62bc\u3001\u8d28\u62bc\u65f6\uff0c\u8bf7\u5148\u586b\u5199\u62c5\u4fdd\u4fe1\u606f\u3002", (String)"GuaranteeUseSaveOrSubmitValidator_10", (String)"tmc-fbp-business", (Object[])new Object[0])));
                }
            } else if (EmptyUtil.isNoEmpty(gcUseEntrySet)) {
                errorMsg.append(this.addErrorMsg(dataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f\u4e0d\u5305\u542b\u4fdd\u8bc1\u3001\u62b5\u62bc\u3001\u8d28\u62bc\u65f6\uff0c\u201c\u62c5\u4fdd\u4fe1\u606f\u201d\u4e0d\u5141\u8bb8\u5b58\u5728\u975e\u989d\u5ea6\u62c5\u4fdd\u4fe1\u606f\u3002", (String)"GuaranteeUseSaveOrSubmitValidator_11", (String)"tmc-fbp-business", (Object[])new Object[0])));
            }
        }
        for (DynamicObject gcUseEntry : gcUseEntrySet) {
            DynamicObject gContract = gcUseEntry.getDynamicObject("gcontract");
            String gGuaranteeWay = gContract.getString("guaranteeway");
            if (this.isMatch(guaranteeWay, gGuaranteeWay)) continue;
            errorMsg.append(this.addErrorMsg(dataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u5408\u540c\u3010%s\u3011\u7684\u62c5\u4fdd\u65b9\u5f0f\u4e0e\u5355\u636e\u4e0d\u5339\u914d\u3002", (String)"GuaranteeUseSaveOrSubmitValidator_12", (String)"tmc-fbp-business", (Object[])new Object[]{gContract.getString("billno")})));
        }
        return errorMsg;
    }

    private Map<Long, List<DynamicObject>> getGuaranteeUseFromDb(DynamicObject[] bizBills) {
        Map<Long, List<DynamicObject>> entryFromDbMap = Collections.emptyMap();
        ArrayList<Long> srcIdSet = new ArrayList<Long>(bizBills.length);
        for (DynamicObject bizBill : bizBills) {
            Long billId = bizBill.getLong("id");
            if (!EmptyUtil.isNoEmpty((Long)billId)) continue;
            srcIdSet.add(billId);
        }
        if (EmptyUtil.isEmpty(srcIdSet)) {
            return entryFromDbMap;
        }
        QFilter idFilter = new QFilter("gsrcbillid", "in", srcIdSet);
        Object[] gcUseBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", G_USE_PROPS), (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((Object[])gcUseBills)) {
            return entryFromDbMap;
        }
        entryFromDbMap = new HashMap<Long, List<DynamicObject>>(16);
        for (Object gcUse : gcUseBills) {
            Long srcBizBillId = gcUse.getLong("gsrcbillid");
            List<DynamicObject> gcUseList = entryFromDbMap.get(srcBizBillId);
            if (gcUseList == null) {
                gcUseList = new ArrayList<DynamicObject>();
                entryFromDbMap.put(srcBizBillId, gcUseList);
            }
            gcUseList.add((DynamicObject)gcUse);
        }
        return entryFromDbMap;
    }

    public String addErrorMsg(ExtendedDataEntity dataEntity, String content) {
        if (dataEntity != null) {
            this.addErrorMessage(dataEntity, content);
        }
        return content;
    }

    private boolean validLoancontractSyncDraw(DynamicObject bizBill) {
        String dataEntityName = bizBill.getDataEntityType().getName();
        return ("cfm_loancontractbill".equals(dataEntityName) || "cfm_loancontract_bo".equals(dataEntityName) || "cim_invest_contract".equals(dataEntityName) || "fl_leasecontractbill".equals(dataEntityName)) && bizBill.containsProperty("issyncdraw") && bizBill.getBoolean("issyncdraw");
    }

    static {
        validGuaranteeEntityList.add("ifm_bizdealbill");
        validGuaranteeEntityList.add("cfm_contract_apply");
        validGuaranteeEntityList.add("lc_lettercredit");
        validGuaranteeEntityList.add("cfm_loanbill_bond");
        validGuaranteeEntityList.add("cdm_payablebill_ap_manual");
        validGuaranteeEntityList.add("cdm_payablebill");
        validGuaranteeEntityList.add("cfm_loanbill");
        validGuaranteeEntityList.add("cim_invest_loanbill");
        validGuaranteeEntityList.add("ifm_loanbill");
        validGuaranteeEntityList.add("fl_receiptbill");
        validGuaranteeEntityList.add("fl_contract_apply");
        loanBillEntityList = new ArrayList<String>(2);
        loanBillEntityList.add("cfm_loanbill");
        loanBillEntityList.add("cim_invest_loanbill");
        loanBillEntityList.add("ifm_loanbill");
        loanBillEntityList.add("fl_receiptbill");
        guaranteeWayMap = new HashMap<String, String>(8);
        guaranteeWayMap.put("2", "ensure");
        guaranteeWayMap.put("3", "ensuamt");
        guaranteeWayMap.put("4", "mortgage");
        guaranteeWayMap.put("5", "pledge");
    }
}

