/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.security.utils;

import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Enumeration;
import kd.bos.context.RequestContext;
import kd.tmc.fbp.service.ebservice.security.utils.XOREncrypter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class P12CertReader {
    private KeyStore keyStore;
    private String certPwd;
    private String alias;
    private String p12String;
    private static final String KEY_STORE_TYPE = "PKCS12";

    public P12CertReader(String p12String, String certPwd, String alias) {
        this.p12String = p12String;
        this.certPwd = certPwd;
        this.alias = alias;
    }

    public PrivateKey getPrivateKey() throws Exception {
        return (PrivateKey)this.keyStore.getKey(this.getAlias(), this.certPwd.toCharArray());
    }

    public PublicKey getPublicKey() throws Exception {
        return this.getCertificate().getPublicKey();
    }

    public String getAlias() throws Exception {
        if (null != this.alias && !"".equals(this.alias)) {
            return this.alias;
        }
        Enumeration<String> aliases = this.keyStore.aliases();
        if (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            return alias;
        }
        return null;
    }

    public void initKeyStore() throws Exception {
        if (null == Security.getProvider("BC")) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        this.keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
        String key = RequestContext.get().getTenantId() + RequestContext.get().getAccountId();
        this.keyStore.load(new ByteArrayInputStream(XOREncrypter.decode((String)key, (String)this.p12String)), this.certPwd.toCharArray());
    }

    public Certificate getCertificate() throws Exception {
        return this.keyStore.getCertificate(this.getAlias());
    }
}

