/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common.guaranteeuse;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.GuaUseStatusEnum;
import kd.tmc.fbp.common.enums.GuaranteeWayEnum;
import kd.tmc.fbp.common.helper.GuaranteeEntryHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class GuaranteeUseBizEntryPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public static final String CONFIRM_GUARANTEE_AMOUNT = "confirm_guarantee_amount";
    public static final String AFTER_CONFIRM = "afterConfirm";
    public static final String ENTRY_GUARANTEE_CONTRACT = "entry_gcontract";
    protected final String[] GUARANTEE_USE_PROPS = new String[]{"gcomment", "gcontract", "gamount", "gcontract.amount", "gcontract.currency", "gratio", "gexchrate", "gsrcbillid", "gsrcbilltype", "gdebtbalance", "gsrcbillbizamount", "gcreditortype", "gcreditor", "gcreditortext"};
    private static Map<String, String> guaranteeWayMap = new HashMap<String, String>(8);
    private static final List<String> charGuaranteeDropDownList;
    private static final List<String> numberGuaranteeDropDownList;

    public void registerListener(EventObject e) {
        BasedataEdit gContract;
        super.registerListener(e);
        EntryGrid gContractGrid = (EntryGrid)this.getControl(ENTRY_GUARANTEE_CONTRACT);
        if (gContractGrid != null) {
            gContractGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((gContract = (BasedataEdit)this.getView().getControl("gcontract")) != null) {
            gContract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (!key.equals("gcontract")) {
            return;
        }
        QFilter gQF = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        if (!this.addQFilter_debtor(evt, gQF)) {
            return;
        }
        if (!this.addQFilter_guaranteeWay(evt, gQF)) {
            return;
        }
        DynamicObjectCollection gcs = this.getModel().getEntryEntity(ENTRY_GUARANTEE_CONTRACT);
        int currIdx = this.getModel().getEntryCurrentRowIndex(ENTRY_GUARANTEE_CONTRACT);
        DynamicObject gCon = (DynamicObject)this.getModel().getValue("gcontract", currIdx);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)gcs)) {
            ArrayList<Long> gcIds = new ArrayList<Long>(gcs.size());
            for (DynamicObject gc : gcs) {
                DynamicObject contract = gc.getDynamicObject("gcontract");
                if (contract == null || gCon != null && gCon.getLong("id") == contract.getLong("id")) continue;
                gcIds.add(contract.getLong("id"));
            }
            if (EmptyUtil.isNoEmpty(gcIds)) {
                gQF.and(new QFilter("id", "not in", gcIds));
            }
        }
        String entityName = TmcBusinessBaseHelper.getBillFormId((String)this.getModel().getDataEntity().getDataEntityType().getName());
        gQF.and(new QFilter("guaranteevarieties.creditguarantee", "=", (Object)"cfm_creditlimit".equals(entityName)));
        ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
        if (gCon != null) {
            showParam.setSelectedRow(gCon.getPkValue());
        }
        showParam.getListFilterParameter().getQFilters().add(gQF);
    }

    private boolean addQFilter_guaranteeWay(BeforeF7SelectEvent evt, QFilter gQF) {
        String gWayPropName = this.getGuaranteeWayProp();
        String gWays = null;
        if (gWayPropName.indexOf(46) > 0) {
            String[] gWayProps = gWayPropName.split("\\.");
            String gWayParent = gWayProps[0];
            String gWayProp = gWayProps[1];
            DynamicObject gWayPDO = (DynamicObject)this.getModel().getValue(gWayParent);
            if (gWayPDO != null) {
                gWays = gWayPDO.getString(gWayProp);
            }
        } else {
            gWays = (String)this.getModel().getValue(gWayPropName);
        }
        if (gWays == null || EmptyUtil.isEmpty((String)gWays.replaceAll(",", ""))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u62c5\u4fdd\u65b9\u5f0f\u3002", (String)"GuaranteeUseBizEntryPlugin_1", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return false;
        }
        String[] gWaysArr = gWays.split(",");
        gWaysArr = this.convertGuaranteeWay(gWaysArr);
        QFilter gWayQF = new QFilter("1", "=", (Object)2);
        for (String qw : gWaysArr) {
            if (!EmptyUtil.isNoEmpty((String)qw)) continue;
            gWayQF.or(new QFilter("guaranteeway", "like", (Object)("%" + qw + "%")));
        }
        gQF.and(gWayQF);
        return true;
    }

    private boolean addQFilter_creditor(BeforeF7SelectEvent evt, QFilter gQF) {
        String creditorPropName = this.getBizPropName("creditor");
        if (creditorPropName == null) {
            return true;
        }
        if (("cfm_loancontract_bl_l".equals(((FormView)this.getView()).getFormId()) || "cfm_loancontract_ic_l".equals(((FormView)this.getView()).getFormId())) && CreditorTypeEnum.OTHER.getValue().equals(this.getModel().getValue("creditortype"))) {
            String textCreditor = (String)this.getModel().getValue("textcreditor");
            if (EmptyUtil.isEmpty((String)textCreditor)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%s\u201d\u3002", (String)"GuaranteeUseBizEntryPlugin_13", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), this.getModel().getProperty(creditorPropName).getDisplayName().getLocaleValue()));
                evt.setCancel(true);
                return false;
            }
            gQF.and("creditortext", "=", (Object)textCreditor);
        } else {
            DynamicObject creditor = (DynamicObject)this.getModel().getValue(creditorPropName);
            String creditorIdPropName = this.getBizPropName("creditorid");
            Long creditorId = creditorIdPropName != null ? (Long)this.getModel().getValue(creditorIdPropName) : 0L;
            if (EmptyUtil.isEmpty((DynamicObject)creditor) && EmptyUtil.isEmpty((Long)creditorId)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%s\u201d\u3002", (String)"GuaranteeUseBizEntryPlugin_13", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), this.getModel().getProperty(creditorPropName).getDisplayName().getLocaleValue()));
                evt.setCancel(true);
                return false;
            }
            if (StringUtils.equals((CharSequence)((FormView)this.getView()).getFormId(), (CharSequence)"cfm_contract_apply") && StringUtils.equals((CharSequence)"settlecenter", (CharSequence)((String)this.getModel().getValue("creditortype")))) {
                gQF.and("creditor", "=", (Object)creditorId);
            } else {
                Object finOrgId = EmptyUtil.isNoEmpty((DynamicObject)creditor) ? creditor.getPkValue() : creditorId;
                QFilter finOrgFilter = new QFilter("id", "=", finOrgId);
                DynamicObject finOrg = QueryServiceHelper.queryOne((String)"bd_finorginfo", (String)String.join((CharSequence)",", "finorgtype.type", "id", "bank_cate"), (QFilter[])finOrgFilter.toArray());
                if (EmptyUtil.isNoEmpty((DynamicObject)finOrg) && "0".equals(finOrg.get("finorgtype.type"))) {
                    finOrgFilter = new QFilter("bank_cate.id", "=", (Object)finOrg.getLong("bank_cate"));
                    DynamicObjectCollection finOrgList = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id", (QFilter[])finOrgFilter.toArray());
                    Set finOrgIdSet = finOrgList.stream().map(f -> f.getLong("id")).collect(Collectors.toSet());
                    gQF.and("creditor", "in", finOrgIdSet);
                } else {
                    gQF.and("creditor", "=", finOrgId);
                }
            }
        }
        return true;
    }

    private boolean addQFilter_debtor(BeforeF7SelectEvent evt, QFilter gQF) {
        if ("cfm_creditlimit".equals(TmcBusinessBaseHelper.getBillFormId((String)((FormView)this.getView()).getFormId()))) {
            return true;
        }
        String debtorPropName = this.getGuaranteeOrgProp();
        if (("cim_invest_contract".equals(((FormView)this.getView()).getFormId()) || "ifm_loancontractbill".equals(((FormView)this.getView()).getFormId())) && CreditorTypeEnum.OTHER.getValue().equals(this.getModel().getValue("debtortype"))) {
            String textDebtor = (String)this.getModel().getValue("textdebtor");
            if (EmptyUtil.isEmpty((String)textDebtor)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%s\u201d\u3002", (String)"GuaranteeUseBizEntryPlugin_13", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), this.getModel().getProperty(debtorPropName).getDisplayName().getLocaleValue()));
                evt.setCancel(true);
                return false;
            }
            gQF.and("entry_guaranteedorg.b_guaranteedorgtext", "=", (Object)textDebtor);
        } else {
            DynamicObject debtor = (DynamicObject)this.getModel().getValue(debtorPropName);
            String debtorIdPropName = this.getBizPropName("debtorid");
            Long debtorId = debtorIdPropName != null ? (Long)this.getModel().getValue(debtorIdPropName) : 0L;
            if (EmptyUtil.isEmpty((DynamicObject)debtor) && EmptyUtil.isEmpty((Long)debtorId)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%s\u201d\u3002", (String)"GuaranteeUseBizEntryPlugin_13", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), this.getModel().getProperty(debtorPropName).getDisplayName().getLocaleValue()));
                evt.setCancel(true);
                return false;
            }
            gQF.and("entry_guaranteedorg.b_guaranteedorg", "in", debtor != null ? debtor.getPkValue() : debtorId);
        }
        return true;
    }

    protected String[] convertGuaranteeWay(String[] gWaysArr) {
        ArrayList<String> gWays = new ArrayList<String>(gWaysArr.length);
        for (String w : gWaysArr) {
            String gw = guaranteeWayMap.get(w);
            if (gw != null) {
                gWays.add(gw);
                continue;
            }
            gWays.add(w);
        }
        return gWays.toArray(new String[0]);
    }

    protected String getBizPropName(String prop) {
        if ("bizamount".equals(prop)) {
            if ("ifm_bizdealbill_fin".equals(((FormView)this.getView()).getFormId())) {
                return "amount";
            }
            if ("ifm_bizdealbill_loan".equals(((FormView)this.getView()).getFormId())) {
                return "drawamount";
            }
        }
        String entityName = this.getModel().getDataEntityType().getName();
        return GuaranteeUseHelper.getBizPropName((String)entityName, (String)prop);
    }

    protected String getGuaranteeOrgProp() {
        return this.getBizPropName("debtor");
    }

    protected String getGuaranteeWayProp() {
        return this.getBizPropName("bizguaranteeway");
    }

    protected String getBizAmountProp() {
        return this.getBizPropName("bizamount");
    }

    protected String getBizCurrencyProp() {
        return this.getBizPropName("bizcurrency");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (propertyName) {
            case "gcontract": {
                String gContractBillNo;
                if (EmptyUtil.isNoEmpty((Object)oldValue) && EmptyUtil.isNoEmpty((String)(gContractBillNo = this.filterOriginalGContract(Collections.singletonList(((DynamicObject)oldValue).getLong("id")))))) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u539f\u62c5\u4fdd\u5408\u540c\u3010%s\u3011\u4e0d\u80fd\u4fee\u6539\u3002", (String)"GuaranteeUseBizEntryPlugin_15", (String)"tmc-fbp-formplugin", (Object[])new Object[]{gContractBillNo}));
                    this.getModel().setValue("gcontract", oldValue, rowIndex);
                    break;
                }
                this.gContractChgEvt(rowIndex, newValue);
                break;
            }
            case "gamount": {
                this.gRatioChgEvt(rowIndex, newValue);
                break;
            }
            case "gratio": {
                this.gAmountChgEvt(rowIndex, newValue);
                break;
            }
            case "gstatus": {
                if (!GuaUseStatusEnum.RELIEVED.getValue().equals(newValue)) break;
                this.getModel().setValue("gratio", (Object)BigDecimal.ZERO, rowIndex);
                break;
            }
            case "guaranteeway": 
            case "guarantee": 
            case "guartype": {
                String formId = ((FormView)this.getView()).getFormId();
                if (numberGuaranteeDropDownList.contains(formId)) {
                    this.dealNoGuaranteeOnNumber(newValue, oldValue, propertyName);
                    break;
                }
                if (!charGuaranteeDropDownList.contains(formId)) break;
                this.dealNoGuaranteeOnChar(newValue, oldValue, propertyName);
                break;
            }
        }
        this.bizPropChanged(e);
    }

    private void gRatioChgEvt(int rowIndex, Object newValue) {
        int i;
        if (EmptyUtil.isEmpty((Object)newValue)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gratio", (Object)0, (int)rowIndex);
            return;
        }
        DynamicObject curGmContract = (DynamicObject)this.getModel().getValue("gcontract", rowIndex);
        if (EmptyUtil.isEmpty((DynamicObject)curGmContract)) {
            return;
        }
        BigDecimal bizAmount = (BigDecimal)this.getModel().getValue(this.getBizAmountProp());
        String entityName = this.getModel().getDataEntityType().getName();
        DynamicObjectCollection gcs = this.getModel().getEntryEntity(ENTRY_GUARANTEE_CONTRACT);
        List gcsList = gcs.stream().collect(Collectors.toList());
        if (GuaranteeUseHelper.getMultiCreditorFlag((String)entityName)) {
            String curCreditorType = (String)this.getModel().getValue("gcreditortype", rowIndex);
            Long curCreditor = (Long)this.getModel().getValue("gcreditor", rowIndex);
            if (EmptyUtil.isNoEmpty((String)curCreditorType) && curCreditor != null) {
                Map bizAmountMap = GuaranteeUseHelper.getBankSyncMap((String)this.getModel().getDataEntityType().getName(), (IDataModel)this.getModel());
                bizAmount = bizAmountMap.containsKey(curCreditorType + curCreditor) ? (BigDecimal)bizAmountMap.get(curCreditorType + curCreditor) : bizAmount;
                gcsList = new ArrayList(gcs.size());
                for (DynamicObject gc : gcs) {
                    String creditorType = gc.getString("gcreditortype");
                    Long creditor = gc.getLong("gcreditor");
                    if (!EmptyUtil.isNoEmpty((String)creditorType) || creditor == null || !curCreditorType.equals(creditorType) || !curCreditor.equals(creditor)) continue;
                    gcsList.add(gc);
                }
            }
        }
        if (bizAmount.compareTo(BigDecimal.ZERO) == 0) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gratio", (Object)0, (int)rowIndex);
            return;
        }
        BigDecimal sumAmount = gcsList.stream().map(g -> g.getBigDecimal("gamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumRatio = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> gRatioMap = new HashMap<Long, BigDecimal>(gcsList.size());
        boolean extTailDiff = Arrays.asList("cfm_loancontractbill", "ifm_loancontractbill").contains(entityName) && (Boolean)this.getModel().getValue("issyncdraw") != false && EmptyUtil.isNoEmpty((Object)this.getModel().getProperty("synccreditlimit")) && EmptyUtil.isNoEmpty((Object)this.getModel().getValue("synccreditlimit"));
        for (i = 0; i < gcsList.size(); ++i) {
            BigDecimal gRatio;
            BigDecimal changeBizAmount;
            DynamicObject gContract = ((DynamicObject)gcsList.get(i)).getDynamicObject("gcontract");
            if (EmptyUtil.isEmpty((DynamicObject)gContract)) continue;
            boolean gCreditGuarantee = ((DynamicObject)gcsList.get(i)).getBoolean("gcreditguarantee");
            BigDecimal bigDecimal = changeBizAmount = extTailDiff && !gCreditGuarantee ? (BigDecimal)this.getModel().getValue(this.getBizAmountProp()) : bizAmount;
            if (sumAmount.compareTo(bizAmount) == 0 && i == gcsList.size() - 1) {
                gRatio = Constants.ONE_HUNDRED.subtract(sumRatio);
            } else {
                gRatio = Constants.ONE_HUNDRED.multiply(((DynamicObject)gcsList.get(i)).getBigDecimal("gamount")).divide(changeBizAmount, 10, RoundingMode.HALF_UP);
                sumRatio = sumRatio.add(gRatio);
            }
            gRatioMap.put(gContract.getLong("id"), gRatio);
        }
        bizAmount = extTailDiff && (Boolean)this.getModel().getValue("gcreditguarantee", rowIndex) == false ? (BigDecimal)this.getModel().getValue(this.getBizAmountProp()) : bizAmount;
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gratio", (Object)Constants.ONE_HUNDRED.multiply((BigDecimal)newValue).divide(bizAmount, 10, RoundingMode.HALF_UP), (int)rowIndex);
        if (sumAmount.compareTo(bizAmount) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c5\u4fdd\u91d1\u989d\u4e4b\u548c\u5927\u4e8e\u4e1a\u52a1\u91d1\u989d\u3002", (String)"GuaranteeUseBizEntryPlugin_14", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
        } else if (sumAmount.compareTo(bizAmount) == 0) {
            for (i = 0; i < gcs.size(); ++i) {
                DynamicObject gc = (DynamicObject)gcs.get(i);
                DynamicObject gContract = gc.getDynamicObject("gcontract");
                if (EmptyUtil.isEmpty((DynamicObject)gContract)) continue;
                if (GuaranteeUseHelper.getMultiCreditorFlag((String)entityName)) {
                    String curCreditorType = (String)this.getModel().getValue("gcreditortype", rowIndex);
                    Long curCreditor = (Long)this.getModel().getValue("gcreditor", rowIndex);
                    String creditorType = gc.getString("gcreditortype");
                    Long creditor = gc.getLong("gcreditor");
                    if (!EmptyUtil.isNoEmpty((String)curCreditorType) || curCreditor == null || !EmptyUtil.isNoEmpty((String)creditorType) || creditor == null || !curCreditorType.equals(creditorType) || !curCreditor.equals(creditor)) continue;
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gratio", gRatioMap.get(gContract.getLong("id")), (int)i);
                    continue;
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gratio", gRatioMap.get(gContract.getLong("id")), (int)i);
            }
        }
    }

    private int getBaseCurrencyScale() {
        String bizCcyProp = this.getBizCurrencyProp();
        DynamicObject baseCurrencyDo = (DynamicObject)this.getModel().getValue(bizCcyProp);
        return EmptyUtil.isNoEmpty((DynamicObject)baseCurrencyDo) ? baseCurrencyDo.getInt("amtprecision") : 6;
    }

    private void dealNoGuaranteeOnChar(Object newValue, Object oldValue, String propertyName) {
        if (GuaranteeWayEnum.isAllValueSelect((String)((String)newValue), (String)((String)oldValue))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propertyName, (Object)GuaranteeWayEnum.genAllGuaranteeWayValues());
        }
    }

    private void dealNoGuaranteeOnNumber(Object newValue, Object oldValue, String propertyName) {
        if (GuaranteeWayEnum.isAllNumValueSelect((String)((String)newValue), (String)((String)oldValue))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propertyName, (Object)GuaranteeWayEnum.genAllGuaranteeWayNumValues());
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        if ("gratio".equals(source.getKey()) && e.getValue() == null && this.getModel().getProperty("gstatus") != null && "A".equals(this.getModel().getValue("gstatus"))) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u62c5\u4fdd\u6bd4\u4f8b(%)\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GuaranteeUseBizEntryPlugin_16", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            this.getView().updateView("gratio", e.getRowIndex());
        } else if ("gstatus".equals(source.getKey())) {
            DynamicObject gContractF7 = (DynamicObject)this.getModel().getValue("gcontract", e.getRowIndex());
            if (gContractF7 == null) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u62c5\u4fdd\u5408\u540c\u7f16\u53f7\u201d\u3002", (String)"GuaranteeUseBizEntryPlugin_11", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                this.getView().updateView("gstatus", e.getRowIndex());
                return;
            }
            DynamicObject sourceBill = null;
            if ("gm_letterofguaapply".equals(this.getModel().getDataEntity().getDynamicObjectType().getName())) {
                sourceBill = (DynamicObject)this.getModel().getValue("letterofguarantee");
            } else if ("cfm_contract_apply".equals(this.getModel().getDataEntity().getDynamicObjectType().getName())) {
                sourceBill = (DynamicObject)this.getModel().getValue("loancontractbill");
            }
            if (sourceBill == null) {
                return;
            }
            QFilter filter = new QFilter("gsrcbillid", "=", sourceBill.getPkValue()).and("gcontract", "=", gContractF7.getPkValue());
            Object[] gcBills = BusinessDataServiceHelper.load((String)"gm_guaranteeuse", (String)"gcontract", (QFilter[])new QFilter[]{filter});
            if (EmptyUtil.isEmpty((Object[])gcBills)) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u7684\u62c5\u4fdd\u7684\u201c\u62c5\u4fdd\u72b6\u6001\u201d\u4e0d\u80fd\u4fee\u6539\u3002", (String)"GuaranteeUseBizEntryPlugin_9", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                this.getView().updateView("gstatus", e.getRowIndex());
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if ("yes".equals(this.getView().getPageCache().get("isDeleteGuaranteeEntry"))) {
            return;
        }
        EntryProp entryProp = e.getEntryProp();
        if (ENTRY_GUARANTEE_CONTRACT.equals(entryProp.getName())) {
            ArrayList<Long> selectedGuaranteeIds = new ArrayList<Long>(8);
            for (int rowIndex : e.getRowIndexs()) {
                DynamicObject gContractF7 = (DynamicObject)this.getModel().getValue("gcontract", rowIndex);
                if (gContractF7 == null) continue;
                selectedGuaranteeIds.add(gContractF7.getLong("id"));
            }
            String gContractBillNos = this.filterOriginalGContract(selectedGuaranteeIds);
            if (EmptyUtil.isNoEmpty((String)gContractBillNos)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u539f\u62c5\u4fdd\u4fe1\u606f\u3010%s\u3011\u4e0d\u80fd\u5220\u9664\u3002", (String)"GuaranteeUseBizEntryPlugin_7", (String)"tmc-fbp-formplugin", (Object[])new Object[]{gContractBillNos}));
                e.setCancel(true);
            }
        }
    }

    private String filterOriginalGContract(List<Long> guaranteeContractIds) {
        DynamicObject sourceBill = null;
        if ("gm_letterofguaapply".equals(this.getModel().getDataEntity().getDynamicObjectType().getName())) {
            sourceBill = (DynamicObject)this.getModel().getValue("letterofguarantee");
        } else if ("ifm_contract_apply".equals(this.getModel().getDataEntity().getDynamicObjectType().getName()) || "cim_contract_apply".equals(this.getModel().getDataEntity().getDynamicObjectType().getName())) {
            sourceBill = (DynamicObject)this.getModel().getValue("loancontractbill");
        } else if ("lc_bizapply".equals(this.getModel().getDataEntity().getDynamicObjectType().getName())) {
            sourceBill = (DynamicObject)this.getModel().getValue("lettercredit");
        }
        if (sourceBill == null) {
            return null;
        }
        QFilter idFilter = new QFilter("gsrcbillid", "=", sourceBill.getPkValue());
        Object[] gcBills = BusinessDataServiceHelper.load((String)"gm_guaranteeuse", (String)"gcontract", (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((Object[])gcBills)) {
            return null;
        }
        List selectedOldGContracts = Arrays.stream(gcBills).filter(o -> guaranteeContractIds.contains(o.getDynamicObject("gcontract").getLong("id"))).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(selectedOldGContracts)) {
            StringBuilder gContractBillNos = new StringBuilder();
            for (int i = 0; i < selectedOldGContracts.size(); ++i) {
                DynamicObject selectedOldGContract = (DynamicObject)selectedOldGContracts.get(i);
                gContractBillNos.append(selectedOldGContract.getDynamicObject("gcontract").getString("billno"));
                if (i == selectedOldGContracts.size() - 1) continue;
                gContractBillNos.append(",");
            }
            return gContractBillNos.toString();
        }
        return null;
    }

    protected void bizPropChanged(PropertyChangedArgs e) {
        block16: {
            int i;
            String bizAmountProp;
            String bizOrgProp;
            String propertyName;
            block15: {
                propertyName = e.getProperty().getName();
                Object newValue = e.getChangeSet()[0].getNewValue();
                String bizCcyProp = this.getBizCurrencyProp();
                bizOrgProp = this.getGuaranteeOrgProp();
                bizAmountProp = this.getBizAmountProp();
                if (!propertyName.equals(bizCcyProp)) break block15;
                DynamicObject bizCcy = (DynamicObject)newValue;
                if (EmptyUtil.isEmpty((DynamicObject)bizCcy)) {
                    return;
                }
                DynamicObjectCollection gcs = this.getModel().getEntryEntity(ENTRY_GUARANTEE_CONTRACT);
                if (EmptyUtil.isEmpty((DynamicObjectCollection)gcs)) {
                    return;
                }
                for (int i2 = 0; i2 < gcs.size(); ++i2) {
                    Long bizCcyId;
                    DynamicObject gcCcy = (DynamicObject)this.getModel().getValue("gcontractcurrency", i2);
                    if (EmptyUtil.isEmpty((DynamicObject)gcCcy)) continue;
                    Long gcCcyId = (Long)gcCcy.getPkValue();
                    if (gcCcyId.equals(bizCcyId = (Long)bizCcy.getPkValue())) {
                        this.getModel().setValue("gexchrate", (Object)BigDecimal.ONE, i2);
                        continue;
                    }
                    DynamicObject org = (DynamicObject)this.getModel().getValue(bizOrgProp);
                    Long debtorId = EmptyUtil.isNoEmpty((DynamicObject)org) ? Long.valueOf(org.getLong("id")) : (Long)this.getModel().getValue("debtor");
                    BigDecimal rate = TmcBusinessBaseHelper.getExchangeRate((long)bizCcyId, (long)gcCcyId, (long)debtorId, (Date)DateUtils.getCurrentDate());
                    this.getModel().setValue("gexchrate", (Object)rate, i2);
                }
                break block16;
            }
            if (propertyName.equals(bizOrgProp) || propertyName.equals(this.getBizPropName("creditor")) || propertyName.equals(this.getBizPropName("textcreditor"))) {
                this.getModel().deleteEntryData(ENTRY_GUARANTEE_CONTRACT);
                return;
            }
            if (!propertyName.equals(bizAmountProp) && (!"cfm_loancontract_bl_l".equals(((FormView)this.getView()).getFormId()) || !((Boolean)this.getModel().getValue("issyncdraw")).booleanValue() || !"productfactory".equals(propertyName))) break block16;
            BigDecimal bizAmount = (BigDecimal)this.getModel().getValue(bizAmountProp);
            DynamicObjectCollection gcs = this.getModel().getEntryEntity(ENTRY_GUARANTEE_CONTRACT);
            if (EmptyUtil.isEmpty((DynamicObjectCollection)gcs)) {
                return;
            }
            String entityName = this.getModel().getDataEntityType().getName();
            List gcsList = gcs.stream().collect(Collectors.toList());
            if (GuaranteeUseHelper.getMultiCreditorFlag((String)entityName)) {
                String curCreditorType = (String)this.getModel().getValue("creditortype");
                Long curCreditor = (Long)this.getModel().getValue("creditor");
                if (EmptyUtil.isNoEmpty((String)curCreditorType) && curCreditor != null) {
                    gcsList = new ArrayList(gcs.size());
                    for (DynamicObject gc : gcs) {
                        String creditorType = gc.getString("gcreditortype");
                        Long creditor = gc.getLong("gcreditor");
                        if (!EmptyUtil.isNoEmpty((String)creditorType) || creditor == null || !curCreditorType.equals(creditorType) || !curCreditor.equals(creditor)) continue;
                        gcsList.add(gc);
                    }
                }
            }
            if (EmptyUtil.isEmpty(gcsList)) {
                return;
            }
            int scale = this.getBaseCurrencyScale();
            BigDecimal sumRatio = gcsList.stream().map(g -> g.getBigDecimal("gratio")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumAmount = BigDecimal.ZERO;
            HashMap<Long, BigDecimal> gAmountMap = new HashMap<Long, BigDecimal>(gcsList.size());
            for (i = 0; i < gcsList.size(); ++i) {
                BigDecimal gAmount;
                DynamicObject gContractDo = ((DynamicObject)gcsList.get(i)).getDynamicObject("gcontract");
                if (EmptyUtil.isEmpty((DynamicObject)gContractDo)) continue;
                if (Constants.ONE_HUNDRED.compareTo(sumRatio) == 0 && i == gcsList.size() - 1) {
                    gAmount = bizAmount.subtract(sumAmount);
                } else {
                    BigDecimal gRatio = ((DynamicObject)gcsList.get(i)).getBigDecimal("gratio");
                    gAmount = bizAmount.multiply(gRatio).divide(Constants.ONE_HUNDRED, scale, RoundingMode.HALF_UP);
                    sumAmount = sumAmount.add(gAmount);
                }
                gAmountMap.put(gContractDo.getLong("id"), gAmount);
            }
            for (i = 0; i < gcs.size(); ++i) {
                DynamicObject gc = (DynamicObject)gcs.get(i);
                DynamicObject gContractDo = gc.getDynamicObject("gcontract");
                if (EmptyUtil.isEmpty((DynamicObject)gContractDo)) continue;
                if (GuaranteeUseHelper.getMultiCreditorFlag((String)entityName)) {
                    String curCreditorType = (String)this.getModel().getValue("creditortype");
                    Long curCreditor = (Long)this.getModel().getValue("creditor");
                    String creditorType = gc.getString("gcreditortype");
                    Long creditor = gc.getLong("gcreditor");
                    if (!EmptyUtil.isNoEmpty((String)curCreditorType) || curCreditor == null || !EmptyUtil.isNoEmpty((String)creditorType) || creditor == null || !curCreditorType.equals(creditorType) || !curCreditor.equals(creditor)) continue;
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", gAmountMap.get(gContractDo.getLong("id")), (int)i);
                    continue;
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", gAmountMap.get(gContractDo.getLong("id")), (int)i);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object pk = this.getModel().getDataEntity().getPkValue();
        if (EmptyUtil.isEmpty((Object)pk)) {
            return;
        }
        if (TmcDataServiceHelper.exists((Object)pk, (String)this.getModel().getDataEntityType().getName())) {
            if (this.showGContract()) {
                this.loadGContract();
            } else {
                this.assembleGuaranteeEntry();
            }
        }
    }

    private void assembleGuaranteeEntry() {
        boolean isContainGStatus = this.getModel().getProperty("gstatus") != null;
        for (int index = 0; index < this.getModel().getEntryEntity(ENTRY_GUARANTEE_CONTRACT).size(); ++index) {
            DynamicObject row = this.getModel().getEntryRowEntity(ENTRY_GUARANTEE_CONTRACT, index);
            this.setCreditGuarantee(row.getDynamicObject("gcontract"), index);
            this.getModel().setValue("gcontractamount", row.get("gcontract.amount"), index);
            this.getModel().setValue("gcontractcurrency", row.get("gcontract.currency"), index);
            if (!isContainGStatus) continue;
            this.getModel().setValue("gstatus", (Object)(row.getBigDecimal("gratio").compareTo(BigDecimal.ZERO) == 0 ? "C" : "A"), index);
        }
    }

    protected boolean showGContract() {
        return !this.getView().getFormShowParameter().getCustomParams().containsKey("openHistoryId");
    }

    private void gContractChgEvt(int rowIndex, Object newValue) {
        if (EmptyUtil.isNoEmpty((Object)newValue)) {
            BigDecimal rate;
            boolean diffCurrency;
            DynamicObject gContractF7 = (DynamicObject)this.getModel().getValue("gcontract", rowIndex);
            this.getModel().setValue("gcontractamount", (Object)gContractF7.getBigDecimal("amount"), rowIndex);
            this.getModel().setValue("gcontractcurrency", (Object)gContractF7.getDynamicObject("currency"), rowIndex);
            this.setCreditGuarantee(gContractF7, rowIndex);
            String entityName = this.getModel().getDataEntityType().getName();
            if (GuaranteeUseHelper.getMultiCreditorFlag((String)entityName) && ((Boolean)this.getModel().getValue("gcreditguarantee", rowIndex)).booleanValue()) {
                return;
            }
            DynamicObject gCcy = gContractF7.getDynamicObject("currency");
            DynamicObject bizCCy = (DynamicObject)this.getModel().getValue(this.getBizCurrencyProp());
            boolean bl = diffCurrency = bizCCy != null && !gCcy.getPkValue().equals(bizCCy.getPkValue());
            if (diffCurrency) {
                String gOrgPropName = this.getGuaranteeOrgProp();
                DynamicObject company = (DynamicObject)this.getModel().getValue(gOrgPropName);
                Long debtorId = EmptyUtil.isNoEmpty((DynamicObject)company) ? Long.valueOf(company.getLong("id")) : (Long)this.getModel().getValue("debtor");
                rate = TmcBusinessBaseHelper.getExchangeRate((long)bizCCy.getLong("id"), (long)gCcy.getLong("id"), (long)debtorId, (Date)DateUtils.getCurrentDate());
            } else {
                rate = BigDecimal.ONE;
            }
            this.getView().setEnable(Boolean.valueOf(diffCurrency), rowIndex, new String[]{"gexchrate"});
            this.getModel().setValue("gexchrate", (Object)rate, rowIndex);
            BigDecimal bizAmount = (BigDecimal)this.getModel().getValue(this.getBizAmountProp());
            if (GuaranteeUseHelper.getMultiCreditorFlag((String)entityName)) {
                String curCreditorType = (String)this.getModel().getValue("creditortype");
                Long curCreditor = (Long)this.getModel().getValue("creditor");
                this.getModel().setValue("gcreditortype", (Object)curCreditorType, rowIndex);
                this.getModel().setValue("gcreditor", (Object)curCreditor, rowIndex);
                this.getModel().setValue("gcreditortext", this.getModel().getValue("textcreditor"), rowIndex);
                Map bizAmountMap = GuaranteeUseHelper.getBankSyncMap((String)this.getModel().getDataEntityType().getName(), (IDataModel)this.getModel());
                if (bizAmountMap.containsKey(curCreditorType + curCreditor) && ((Boolean)this.getModel().getValue("gcreditguarantee")).booleanValue()) {
                    bizAmount = (BigDecimal)bizAmountMap.get(curCreditorType + curCreditor);
                }
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", (Object)bizAmount, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gratio", (Object)Constants.ONE_HUNDRED, (int)rowIndex);
        }
    }

    private void gAmountChgEvt(int rowIndex, Object newValue) {
        int i;
        if (EmptyUtil.isEmpty((Object)newValue)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", (Object)0, (int)rowIndex);
            return;
        }
        DynamicObject curGmContract = (DynamicObject)this.getModel().getValue("gcontract", rowIndex);
        if (EmptyUtil.isEmpty((DynamicObject)curGmContract)) {
            return;
        }
        BigDecimal bizAmount = (BigDecimal)this.getModel().getValue(this.getBizAmountProp());
        String entityName = this.getModel().getDataEntityType().getName();
        DynamicObjectCollection gcs = this.getModel().getEntryEntity(ENTRY_GUARANTEE_CONTRACT);
        List gcsList = gcs.stream().collect(Collectors.toList());
        if (GuaranteeUseHelper.getMultiCreditorFlag((String)entityName)) {
            String curCreditorType = (String)this.getModel().getValue("gcreditortype", rowIndex);
            Long curCreditor = (Long)this.getModel().getValue("gcreditor", rowIndex);
            if (EmptyUtil.isNoEmpty((String)curCreditorType) && curCreditor != null) {
                Map bizAmountMap = GuaranteeUseHelper.getBankSyncMap((String)this.getModel().getDataEntityType().getName(), (IDataModel)this.getModel());
                bizAmount = bizAmountMap.containsKey(curCreditorType + curCreditor) ? (BigDecimal)bizAmountMap.get(curCreditorType + curCreditor) : bizAmount;
                gcsList = new ArrayList(gcs.size());
                for (DynamicObject gc : gcs) {
                    String creditorType = gc.getString("gcreditortype");
                    Long creditor = gc.getLong("gcreditor");
                    if (!EmptyUtil.isNoEmpty((String)creditorType) || creditor == null || !curCreditorType.equals(creditorType) || !curCreditor.equals(creditor)) continue;
                    gcsList.add(gc);
                }
            }
        }
        if (bizAmount.compareTo(BigDecimal.ZERO) == 0) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", (Object)0, (int)rowIndex);
            return;
        }
        int scale = this.getBaseCurrencyScale();
        BigDecimal sumRatio = gcsList.stream().map(g -> g.getBigDecimal("gratio")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumAmount = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> gAmountMap = new HashMap<Long, BigDecimal>(gcsList.size());
        boolean extTailDiff = Arrays.asList("cfm_loancontractbill", "ifm_loancontractbill").contains(entityName) && (Boolean)this.getModel().getValue("issyncdraw") != false && EmptyUtil.isNoEmpty((Object)this.getModel().getProperty("synccreditlimit")) && EmptyUtil.isNoEmpty((Object)this.getModel().getValue("synccreditlimit"));
        for (i = 0; i < gcsList.size(); ++i) {
            BigDecimal gAmount;
            BigDecimal changeBizAmount;
            DynamicObject gContract = ((DynamicObject)gcsList.get(i)).getDynamicObject("gcontract");
            if (EmptyUtil.isEmpty((DynamicObject)gContract)) continue;
            boolean gCreditGuarantee = ((DynamicObject)gcsList.get(i)).getBoolean("gcreditguarantee");
            BigDecimal bigDecimal = changeBizAmount = extTailDiff && !gCreditGuarantee ? (BigDecimal)this.getModel().getValue(this.getBizAmountProp()) : bizAmount;
            if (Constants.ONE_HUNDRED.compareTo(sumRatio) == 0 && i == gcsList.size() - 1 && !extTailDiff) {
                gAmount = changeBizAmount.subtract(sumAmount);
            } else {
                BigDecimal gRatio = ((DynamicObject)gcsList.get(i)).getBigDecimal("gratio");
                gAmount = changeBizAmount.multiply(gRatio).divide(Constants.ONE_HUNDRED, scale, RoundingMode.HALF_UP);
                sumAmount = sumAmount.add(gAmount);
            }
            gAmountMap.put(gContract.getLong("id"), gAmount);
        }
        bizAmount = extTailDiff && (Boolean)this.getModel().getValue("gcreditguarantee", rowIndex) == false ? (BigDecimal)this.getModel().getValue(this.getBizAmountProp()) : bizAmount;
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", (Object)bizAmount.multiply((BigDecimal)newValue).divide(Constants.ONE_HUNDRED, scale, RoundingMode.HALF_UP), (int)rowIndex);
        if (sumRatio.compareTo(Constants.ONE_HUNDRED) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c5\u4fdd\u6bd4\u4f8b\u4e4b\u548c\u8d85\u8fc7100%\u3002", (String)"GuaranteeUseBizEntryPlugin_12", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
        } else if (sumRatio.compareTo(Constants.ONE_HUNDRED) == 0) {
            for (i = 0; i < gcs.size(); ++i) {
                DynamicObject gc = (DynamicObject)gcs.get(i);
                DynamicObject gContract = gc.getDynamicObject("gcontract");
                if (EmptyUtil.isEmpty((DynamicObject)gContract)) continue;
                if (GuaranteeUseHelper.getMultiCreditorFlag((String)entityName)) {
                    String curCreditorType = (String)this.getModel().getValue("gcreditortype", rowIndex);
                    Long curCreditor = (Long)this.getModel().getValue("gcreditor", rowIndex);
                    String creditorType = gc.getString("gcreditortype");
                    Long creditor = gc.getLong("gcreditor");
                    if (!EmptyUtil.isNoEmpty((String)curCreditorType) || curCreditor == null || !EmptyUtil.isNoEmpty((String)creditorType) || creditor == null || !curCreditorType.equals(creditorType) || !curCreditor.equals(creditor)) continue;
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", gAmountMap.get(gContract.getLong("id")), (int)i);
                    continue;
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", gAmountMap.get(gContract.getLong("id")), (int)i);
            }
        }
    }

    protected void loadGContract() {
        String entityName = this.getModel().getDataEntityType().getName();
        Long id = this.getGsrcbillid();
        QFilter idFilter = new QFilter("gsrcbillid", "=", (Object)id);
        DynamicObjectCollection gcBills = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", this.GUARANTEE_USE_PROPS), (QFilter[])new QFilter[]{idFilter}, (String)"id");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)gcBills)) {
            return;
        }
        ArrayList gcEntryList = new ArrayList(gcBills.size());
        boolean isContainGStatus = this.getModel().getProperty("gstatus") != null;
        DynamicObjectCollection gContractEntry = this.getModel().getEntryEntity(ENTRY_GUARANTEE_CONTRACT);
        HashSet gContractIds = EmptyUtil.isEmpty((DynamicObjectCollection)gContractEntry) ? new HashSet(8) : gContractEntry.stream().filter(a -> EmptyUtil.isNoEmpty((DynamicObject)a.getDynamicObject("gcontract"))).map(g -> g.getDynamicObject("gcontract").getLong("id")).collect(Collectors.toSet());
        for (int i = 0; i < gcBills.size(); ++i) {
            DynamicObject gcBIll = (DynamicObject)gcBills.get(i);
            HashMap<String, Object> gcEntry = new HashMap<String, Object>(16);
            if ("false".equals(this.getView().getPageCache().get("isDeleteEntry")) && gContractIds.contains(gcBIll.getLong("gcontract"))) continue;
            gcEntry.put("gcontract", gcBIll.get("gcontract"));
            gcEntry.put("gamount", gcBIll.get("gamount"));
            gcEntry.put("gratio", gcBIll.get("gratio"));
            gcEntry.put("gcontractamount", gcBIll.get("gcontract.amount"));
            gcEntry.put("gcontractcurrency", gcBIll.get("gcontract.currency"));
            gcEntry.put("gexchrate", gcBIll.get("gexchrate"));
            gcEntry.put("gcomment", gcBIll.get("gcomment"));
            gcEntry.put("gsrcbillid", gcBIll.get("gsrcbillid"));
            gcEntry.put("gsrcbilltype", gcBIll.get("gsrcbilltype"));
            if (GuaranteeUseHelper.getMultiCreditorFlag((String)entityName)) {
                gcEntry.put("gcreditortype", gcBIll.getString("gcreditortype"));
                gcEntry.put("gcreditor", gcBIll.getLong("gcreditor"));
                gcEntry.put("gcreditortext", gcBIll.getString("gcreditortext"));
            }
            if (isContainGStatus) {
                if (gcBIll.getBigDecimal("gratio").compareTo(BigDecimal.ZERO) == 0) {
                    gcEntry.put("gstatus", GuaUseStatusEnum.RELIEVED.getValue());
                } else if (gcBIll.getBigDecimal("gdebtbalance").compareTo(BigDecimal.ZERO) == 0 || Arrays.asList("cfm_loancontractbill", "cfm_loancontract_bo", "cim_invest_contract", "fl_leasecontractbill").contains(entityName) && "D".equals(this.getModel().getValue("contractstatus"))) {
                    gcEntry.put("gstatus", GuaUseStatusEnum.SETTLED.getValue());
                } else {
                    gcEntry.put("gstatus", GuaUseStatusEnum.GUARANTEEING.getValue());
                }
            }
            gcEntryList.add(gcEntry);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        boolean dataChanged = this.getModel().getDataChanged();
        model.beginInit();
        TmcViewInputHelper.batchFillEntity((String)ENTRY_GUARANTEE_CONTRACT, (AbstractFormDataModel)model, gcEntryList, (!"false".equals(this.getView().getPageCache().get("isDeleteEntry")) ? 1 : 0) != 0);
        GuaranteeEntryHelper.setCreditGuarantee((IDataModel)this.getModel());
        model.endInit();
        this.getView().updateView(ENTRY_GUARANTEE_CONTRACT);
        this.getModel().setDataChanged(dataChanged);
    }

    protected Long getGsrcbillid() {
        return (Long)this.getModel().getValue("id");
    }

    private void setCreditGuarantee(DynamicObject gContract, int rowIdx) {
        DynamicObject guarantee;
        if (gContract != null && (guarantee = gContract.getDynamicObject("guaranteevarieties")) != null) {
            DynamicObject guaranteeVar = TmcDataServiceHelper.loadSingleFromCache((Object)guarantee.getPkValue(), (String)"gm_guaranteevarieties", (String)"id,creditguarantee");
            this.getModel().setValue("gcreditguarantee", (Object)guaranteeVar.getBoolean("creditguarantee"), rowIdx);
        }
    }

    protected boolean checkDependentFields() {
        String gway = this.getGuaranteeWayProp();
        if (gway.indexOf(46) > 0) {
            gway = gway.split("\\.")[0];
        }
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{this.getBizAmountProp(), this.getBizCurrencyProp(), gway});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (Boolean.TRUE.toString().equals(op.getOption().getVariables().get("is_showing_confirm_view"))) {
            return;
        }
        switch (opKey = op.getOperateKey()) {
            case "addguaentry": {
                if (this.checkDependentFields()) break;
                args.setCancel(true);
                break;
            }
            case "save": {
                op.getOption().setVariableValue("formId", ((FormView)this.getView()).getFormId());
                op.getOption().setVariableValue("op_from_edit_form", this.getView().getModel().getDataEntityType().getName());
                break;
            }
            case "submit": {
                op.getOption().setVariableValue("formId", ((FormView)this.getView()).getFormId());
                op.getOption().setVariableValue("op_from_edit_form", this.getView().getModel().getDataEntityType().getName());
                this.verifyGuaranteeContractAmt(args, op);
                break;
            }
            case "unsubmit": 
            case "unaudit": {
                op.getOption().setVariableValue("formId", ((FormView)this.getView()).getFormId());
                break;
            }
        }
    }

    private void verifyGuaranteeContractAmt(BeforeDoOperationEventArgs args, FormOperate op) {
        if (!op.getOption().getVariables().containsKey(AFTER_CONFIRM) && !"lc_bizapply".equals(op.getOption().getVariables().get("formId"))) {
            String debtorIdPropName;
            DynamicObject bizOrgDO = (DynamicObject)this.getModel().getValue(this.getGuaranteeOrgProp());
            Long bizOrgId = EmptyUtil.isNoEmpty((DynamicObject)bizOrgDO) ? Long.valueOf(bizOrgDO.getLong("id")) : Long.valueOf((debtorIdPropName = this.getBizPropName("debtorid")) != null ? (Long)this.getModel().getValue(debtorIdPropName) : 0L);
            DynamicObjectCollection entryList = this.getModel().getEntryEntity(ENTRY_GUARANTEE_CONTRACT);
            ArrayList<String> seq = new ArrayList<String>(entryList.size());
            for (int i = 0; i < entryList.size(); ++i) {
                DynamicObject gcEntry = (DynamicObject)entryList.get(i);
                DynamicObject gc = gcEntry.getDynamicObject("gcontract");
                if (gc == null) continue;
                BigDecimal gAmount = gcEntry.getBigDecimal("gamount");
                BigDecimal exRate = gcEntry.getBigDecimal("gexchrate");
                if (EmptyUtil.isEmpty((BigDecimal)gAmount)) continue;
                BigDecimal availAmt = GuaranteeUseHelper.getGContractAvailableDutyAmt((Long)gc.getLong("id"), (Long)bizOrgId);
                BigDecimal amount = this.queryTargetBillUseAmount(gc);
                BigDecimal bigDecimal = availAmt = availAmt != null ? availAmt.add(amount) : BigDecimal.ZERO.add(amount);
                if (availAmt.compareTo(gAmount.multiply(exRate)) >= 0) continue;
                seq.add(i + 1 + "");
            }
            if (!seq.isEmpty()) {
                this.getView().showConfirm(String.format(ResManager.loadResFormat((String)"\u62c5\u4fdd\u4fe1\u606f\u7b2c%s\u884c\u5206\u5f55\u4e2d\u7684\u62c5\u4fdd\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u88ab\u62c5\u4fdd\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"GuaranteeUseBizEntryPlugin_6", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", seq)), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_GUARANTEE_AMOUNT, (IFormPlugin)this));
                HashMap opVariableMap = new HashMap(op.getOption().getVariables().size());
                for (Map.Entry e : op.getOption().getVariables().entrySet()) {
                    opVariableMap.put(e.getKey(), e.getValue());
                }
                this.getView().getPageCache().put("opVariableJson", new JSONObject(opVariableMap).toString());
                args.setCancel(true);
            }
        }
    }

    private BigDecimal queryTargetBillUseAmount(DynamicObject guaranteeContract) {
        Object[] sourceBillUse;
        DynamicObject letterOfGuaranteeF7;
        if ("gm_letterofguaapply".equals(this.getModel().getDataEntity().getDynamicObjectType().getName()) && (letterOfGuaranteeF7 = (DynamicObject)this.getModel().getValue("letterofguarantee")) != null && EmptyUtil.isNoEmpty((Object[])(sourceBillUse = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gdebtbalance", "gexchrate"), (QFilter[])new QFilter[]{new QFilter("gsrcbillid", "=", letterOfGuaranteeF7.getPkValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("gcontract", "=", guaranteeContract.getPkValue())})))) {
            return sourceBillUse[0].getBigDecimal("gdebtbalance").multiply(sourceBillUse[0].getBigDecimal("gexchrate"));
        }
        return BigDecimal.ZERO;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRM_GUARANTEE_AMOUNT.equals(callBackId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue(AFTER_CONFIRM, "1");
            String opVariableJson = this.getView().getPageCache().get("opVariableJson");
            Map opVariableMap = (Map)JSON.parse((String)opVariableJson);
            for (Map.Entry e : opVariableMap.entrySet()) {
                option.setVariableValue((String)e.getKey(), (String)e.getValue());
            }
            option.setVariableValue("stop_beforeDoOperation", Boolean.TRUE.toString());
            this.getView().getPageCache().remove("opVariableJson");
            this.getView().invokeOperation("submit", option);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        DynamicObject gContract;
        int rowIdx = evt.getRowIndex();
        String fieldName = evt.getFieldName();
        if ("gcontract".equals(fieldName) && (gContract = (DynamicObject)this.getModel().getValue("gcontract", rowIdx)) != null) {
            BillShowParameter param = new BillShowParameter();
            param.setFormId("gm_guaranteecontract");
            param.setPkId(gContract.getPkValue());
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setBillStatus(BillOperationStatus.VIEW);
            param.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    static {
        guaranteeWayMap.put("2", "ensure");
        guaranteeWayMap.put("3", "ensuamt");
        guaranteeWayMap.put("4", "mortgage");
        guaranteeWayMap.put("5", "pledge");
        numberGuaranteeDropDownList = new ArrayList<String>(11);
        numberGuaranteeDropDownList.add("cfm_loancontract_bl_l");
        numberGuaranteeDropDownList.add("cfm_loancontract_ic_l");
        numberGuaranteeDropDownList.add("cfm_loanbill_bond");
        numberGuaranteeDropDownList.add("cim_invest_contract");
        numberGuaranteeDropDownList.add("cfm_loan_apply");
        numberGuaranteeDropDownList.add("ifm_loancontractbill");
        numberGuaranteeDropDownList.add("lc_lettercredit");
        numberGuaranteeDropDownList.add("lc_lettercredit_change");
        numberGuaranteeDropDownList.add("lc_bizapply");
        charGuaranteeDropDownList = new ArrayList<String>(3);
        charGuaranteeDropDownList.add("gm_letterofguaapply");
        charGuaranteeDropDownList.add("gm_letterofguarantee");
        charGuaranteeDropDownList.add("cfm_creditlimit");
        charGuaranteeDropDownList.add("creditm_limit_framework");
    }
}

