/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BalanceHelper {
    private static final Log logger = LogFactory.getLog(BalanceHelper.class);
    private static final String KEY_OVERRIDE = "isoverride";

    public static void handDoSaveBalanceOperation(int i, List<Date> bizDates, boolean isBatch, boolean isOverride, ModelAgent modelAgent, List<DynamicObject> saveBalanceList, List<DynamicObject> updateBalanceList) {
        DynamicObject balance;
        DynamicObject accountBank = (DynamicObject)modelAgent.getValue("accountbank");
        if (isBatch) {
            isOverride = (Integer)modelAgent.getValue(KEY_OVERRIDE) == 1;
        }
        Date bizdate = (Date)modelAgent.getValue("bizdate");
        DynamicObject currency = (DynamicObject)modelAgent.getValue("currency");
        if (isOverride) {
            balance = BalanceHelper.checkIfExist(modelAgent);
            if (EmptyUtil.isEmpty((DynamicObject)balance)) {
                logger.error("\u8986\u76d6\u4f59\u989d\u5f02\u5e38\uff0c\u83b7\u53d6\u7684\u4f59\u989d\u4fe1\u606f\u3010\u8d26\u6237 {}\uff0c\u4f59\u989d\u65e5\u671f {}\u3011\u4e3a\u7a7a\u3002", (Object)accountBank.getString("name"), modelAgent.getValue("bizdate"));
                throw new KDBizException(ResManager.loadKDString((String)"\u4f59\u989d\u8986\u76d6\u5f02\u5e38\uff0c\u83b7\u53d6\u7684\u4f59\u989d\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"BalanceHelper_1", (String)"tmc-fbp-common", (Object[])new Object[0]));
            }
            balance.set("isupdate", (Object)"1");
        } else {
            balance = BusinessDataServiceHelper.newDynamicObject((String)"bei_bankbalance");
            balance.set("accountbank", (Object)accountBank);
            balance.set("company", (Object)accountBank.getDynamicObject("company"));
            balance.set("bizdate", modelAgent.getValue("bizdate"));
            balance.set("currency", modelAgent.getValue("currency"));
            balance.set("bank", (Object)accountBank.getDynamicObject("bank"));
        }
        balance.set("billno", (Object)"HAND-".concat(String.valueOf(System.currentTimeMillis())));
        Date lastEndDate = BalanceHelper.dealEndDate(i, bizDates, bizdate, accountBank.getLong("id"), currency.getLong("id"), updateBalanceList);
        logger.info("\u4f59\u989d\u8ba1\u7b97\u7ed3\u675f\u65e5\u671f===lastEndDate:{}", (Object)lastEndDate);
        balance.set("enddate", (Object)lastEndDate);
        balance.set("amount", modelAgent.getValue("amount"));
        balance.set("valibalance", modelAgent.getValue("valibalance"));
        balance.set("lstbalance", modelAgent.getValue("lstbalance"));
        balance.set("freezebalance", modelAgent.getValue("freezebalance"));
        balance.set("datasource", (Object)"hand");
        balance.set("creator", (Object)RequestContext.get().getCurrUserId());
        balance.set("modifier", (Object)RequestContext.get().getCurrUserId());
        balance.set("createtime", (Object)DateUtils.getCurrentTime());
        balance.set("modifytime", (Object)DateUtils.getCurrentTime());
        saveBalanceList.add(balance);
    }

    public static void handDoBatchSaveBalanceOperation(DynamicObjectCollection entryEntities, List<DynamicObject> saveBalanceList, List<DynamicObject> updateBalanceList) {
        Map<String, List> groupedAndSorted = entryEntities.stream().collect(Collectors.groupingBy(balance -> balance.getDynamicObject("accountbank").getLong("id") + "#" + balance.getDynamicObject("currency").getLong("id"), Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(Comparator.comparing(t -> t.getDate("bizdate"))).collect(Collectors.toList()))));
        for (List balance2 : groupedAndSorted.values()) {
            List<Date> bizDates = balance2.stream().map(s -> s.getDate("bizdate")).collect(Collectors.toList());
            for (int i = 0; i < balance2.size(); ++i) {
                BalanceHelper.handDoSaveBalanceOperation(i, bizDates, true, false, new ModelAgent(balance2.get(i)), saveBalanceList, updateBalanceList);
            }
        }
    }

    public static Date dealEndDate(int i, List<Date> bizDates, Date bizdate, Object accountBankId, Object currencyId, List<DynamicObject> updateBalanceList) {
        int size = bizDates.size();
        if (i == 0) {
            Date minDate = bizdate;
            QFilter minFilter = new QFilter("accountbank", "=", accountBankId);
            minFilter.and("currency", "=", currencyId);
            minFilter.and("bizdate", "<", (Object)minDate);
            minFilter.and("enddate", ">", (Object)minDate);
            DynamicObject minLastBalance = TmcDataServiceHelper.loadSingle((String)"bei_bankbalance", (String)"id,bizdate,enddate", (QFilter[])minFilter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObject)minLastBalance)) {
                minLastBalance.set("enddate", (Object)minDate);
                updateBalanceList.add(minLastBalance);
            }
            if (size > 1) {
                return bizDates.get(i + 1);
            }
            logger.info("\u4f59\u989d\u8ba1\u7b97\u7ed3\u675f\u65e5\u671f===i:{} minFilter:{}", (Object)i, (Object)minFilter);
        }
        if (i == size - 1) {
            Date maxDate = bizdate;
            QFilter maxFilter = new QFilter("accountbank", "=", accountBankId);
            maxFilter.and("currency", "=", currencyId);
            maxFilter.and("bizdate", ">", (Object)maxDate);
            DynamicObject maxNextBalance = TmcDataServiceHelper.loadSingle((String)"bei_bankbalance", (String)"id,bizdate,enddate", (QFilter[])maxFilter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObject)maxNextBalance)) {
                return maxNextBalance.getDate("bizdate");
            }
            logger.info("\u4f59\u989d\u8ba1\u7b97\u7ed3\u675f\u65e5\u671f===i:{} maxFilter:{}", (Object)i, (Object)maxFilter);
        }
        if (size > 1 && i != size - 1) {
            Date lastBizDate = bizDates.get(i - 1);
            logger.info("\u4f59\u989d\u8ba1\u7b97\u7ed3\u675f\u65e5\u671f===lastBizDate:{} bizdate:{}", (Object)lastBizDate, (Object)bizdate);
            if (DateUtils.getDiffDays((Date)lastBizDate, (Date)bizdate) != 2) {
                QFilter lastFilter = new QFilter("accountbank", "=", accountBankId);
                lastFilter.and("currency", "=", currencyId);
                lastFilter.and("bizdate", ">", (Object)lastBizDate);
                lastFilter.and("bizdate", "<", (Object)bizdate);
                DynamicObject lastBalance = TmcDataServiceHelper.loadSingle((String)"bei_bankbalance", (String)"id,bizdate,enddate", (QFilter[])lastFilter.toArray());
                if (EmptyUtil.isNoEmpty((DynamicObject)lastBalance)) {
                    lastBalance.set("enddate", (Object)bizdate);
                    updateBalanceList.add(lastBalance);
                }
                logger.info("\u4f59\u989d\u8ba1\u7b97\u7ed3\u675f\u65e5\u671f===i:{} lastFilter:{}", (Object)i, (Object)lastFilter);
            }
            Date nextBizDate = bizDates.get(i + 1);
            logger.info("\u4f59\u989d\u8ba1\u7b97\u7ed3\u675f\u65e5\u671f===bizdate:{} nextBizDate:{}", (Object)bizdate, (Object)nextBizDate);
            if (DateUtils.getDiffDays((Date)bizdate, (Date)nextBizDate) != 2) {
                QFilter nextFilter = new QFilter("accountbank", "=", accountBankId);
                nextFilter.and("currency", "=", currencyId);
                nextFilter.and("bizdate", ">", (Object)bizdate);
                nextFilter.and("bizdate", "<", (Object)nextBizDate);
                DynamicObject nextBalance = TmcDataServiceHelper.loadSingle((String)"bei_bankbalance", (String)"id,bizdate,enddate", (QFilter[])nextFilter.toArray());
                if (EmptyUtil.isNoEmpty((DynamicObject)nextBalance)) {
                    nextBalance.set("enddate", (Object)nextBizDate);
                    updateBalanceList.add(nextBalance);
                    return nextBalance.getDate("bizdate");
                }
                logger.info("\u4f59\u989d\u8ba1\u7b97\u7ed3\u675f\u65e5\u671f===i:{} nextFilter:{}", (Object)i, (Object)nextFilter);
            }
            return nextBizDate;
        }
        return DateUtils.stringToDate((String)"9999-12-31", (String)"yyyy-MM-dd");
    }

    public static DynamicObject checkIfExist(ModelAgent modelAgent) {
        DynamicObject accountBank = (DynamicObject)modelAgent.getValue("accountbank");
        DynamicObject currency = (DynamicObject)modelAgent.getValue("currency");
        String acctBankNum = accountBank.getString("bankaccountnumber");
        String currencyNum = currency.getString("number");
        QFilter qFilter = new QFilter("accountbank.bankaccountnumber", "=", (Object)acctBankNum);
        qFilter.and(new QFilter("currency.number", "=", (Object)currencyNum));
        qFilter.and(new QFilter("bizdate", "=", modelAgent.getValue("bizdate")));
        return BusinessDataServiceHelper.loadSingle((String)"bei_bankbalance", (QFilter[])qFilter.toArray());
    }

    public static void deleteBalance(List<DynamicObject> balancesList, List<DynamicObject> updateBalanceList) {
        Map<String, List> groupedAndSorted = balancesList.stream().collect(Collectors.groupingBy(balance -> balance.getDynamicObject("accountbank").getLong("id") + "#" + balance.getDynamicObject("currency").getLong("id"), Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(Comparator.comparing(t -> ((DynamicObject)t).getDate("bizdate")).reversed()).collect(Collectors.toList()))));
        for (Map.Entry<String, List> entry : groupedAndSorted.entrySet()) {
            String entryKey = entry.getKey();
            String[] split = entryKey.split("#");
            Long accountId = Long.parseLong(split[0]);
            Long currencyId = Long.parseLong(split[1]);
            List balances = entry.getValue();
            List ids = balances.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
            for (int i = 0; i < balances.size(); ++i) {
                Date nextBizDate;
                DynamicObject balance2 = (DynamicObject)balances.get(i);
                Date bizDate = balance2.getDate("bizdate");
                if (i != 0 && DateUtils.getDiffDays((Date)bizDate, (Date)(nextBizDate = ((DynamicObject)balances.get(i - 1)).getDate("bizdate"))) == 2) continue;
                QFilter lastFilter = new QFilter("accountbank", "=", (Object)accountId);
                lastFilter.and("currency", "=", (Object)currencyId);
                lastFilter.and("bizdate", "<", (Object)bizDate);
                lastFilter.and("id", "not in", ids);
                Object[] nextBalances = TmcDataServiceHelper.load((String)"bei_bankbalance", (String)"id,bizdate,enddate", (QFilter[])lastFilter.toArray(), (String)"bizdate desc", (int)1);
                logger.info("\u4f59\u989d\u8ba1\u7b97\u7ed3\u675f\u65e5\u671fdelete===i:{} lastFilter:{}", (Object)i, (Object)lastFilter);
                if (!EmptyUtil.isNoEmpty((Object[])nextBalances)) continue;
                Date endDate = balance2.getDate("enddate");
                nextBalances[0].set("enddate", (Object)endDate);
                updateBalanceList.add((DynamicObject)nextBalances[0]);
            }
        }
    }
}

