/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.GuaUseStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseBean;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseReturnBean;
import kd.tmc.fbp.common.util.EmptyUtil;

public class GuaranteeUseHelper {
    public static final String IS_DELETE_GUARANTEE_ENTRY = "isDeleteGuaranteeEntry";
    public static final String YES = "yes";
    public static final String NO = "no";
    protected static final String[] GUARANTEE_USE_PROPS = new String[]{"gcomment", "gcontract", "gamount", "gcontract.amount", "gcontract.currency", "gcontract.guaranteevarieties", "gratio", "gexchrate", "gsrcbillid", "gsrcbilltype", "gdebtbalance", "gsrcbillbizamount"};
    private static String[] gcProps = new String[]{"gcomment", "gcontract", "gamount", "gcontract.amount", "gcontract.currency", "gratio", "gsrcbillid", "gsrcbilltype", "gsrcbillbizamount", "gexchrate", "gdebtamount", "gdebtbalance", "gcreditortype", "gcreditor", "gcreditortext", "return_entry", "return_entry.e_returnamount", "return_entry.e_returnbillid", "return_entry.e_returnbilltype"};
    private static final Map<String, Map<String, String>> entityBizPropMap = new HashMap<String, Map<String, String>>(16);

    public static String getBizPropName(String entity, String prop) {
        Map<String, String> bizPropMap = entityBizPropMap.get(entity);
        if (bizPropMap == null) {
            return null;
        }
        return bizPropMap.get(prop);
    }

    public static void saveGuaranteeUse(List<GuaranteeUseBean> gUseBeanList) {
        ArrayList<DynamicObject> gUseDOList = new ArrayList<DynamicObject>(gUseBeanList.size());
        ArrayList<Long> srcBillIds = new ArrayList<Long>(gUseBeanList.size());
        List gContractIds = gUseBeanList.stream().map(v -> v.getgContractId()).collect(Collectors.toList());
        QFilter idFilter = new QFilter("id", "in", gContractIds);
        DynamicObject[] gContracts = TmcDataServiceHelper.load((String)"gm_guaranteecontract", (String)"id,currency", (QFilter[])new QFilter[]{idFilter});
        Map<Object, DynamicObject> gContractMap = Arrays.stream(gContracts).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v.getDynamicObject("currency")));
        for (int i = 0; i < gUseBeanList.size(); ++i) {
            GuaranteeUseBean gUse = gUseBeanList.get(i);
            DynamicObject newDO = TmcDataServiceHelper.newDynamicObject((String)"gm_guaranteeuse");
            newDO.set("gcontract", (Object)gUse.getgContractId());
            DynamicObject currency = gContractMap.get(gUse.getgContractId());
            newDO.set("gcurrency", (Object)currency);
            newDO.set("gratio", (Object)gUse.getgRatio());
            newDO.set("gcomment", (Object)gUse.getComment());
            newDO.set("gamount", (Object)gUse.getgAmount());
            newDO.set("gexchrate", (Object)gUse.getExchrate());
            newDO.set("gsrcbillbizamount", (Object)gUse.getBizAmount());
            newDO.set("gdebtamount", (Object)gUse.getgAmount());
            newDO.set("gdebtbalance", (Object)gUse.getgAmount());
            newDO.set("gdebtorg", (Object)gUse.getDebtOrgId());
            newDO.set("gdebtorgtext", (Object)gUse.getDebtOrgText());
            newDO.set("gdebtcurrency", (Object)gUse.getDebtCurrencyId());
            newDO.set("gdebtstartdate", (Object)gUse.getDebtStartDate());
            newDO.set("gdebtenddate", (Object)gUse.getDebtEndDate());
            newDO.set("gcparty", (Object)gUse.getCparty());
            newDO.set("gsrcbillid", (Object)gUse.getSrcBillId());
            newDO.set("gsrcbillno", (Object)gUse.getSrcBillNo());
            newDO.set("gsrcbilltype", (Object)gUse.getSrcBillType());
            newDO.set("gcreditortype", (Object)gUse.getgCreditorType());
            newDO.set("gcreditor", (Object)gUse.getgCreditor());
            newDO.set("gcreditortext", (Object)gUse.getgCreditorText());
            gUseDOList.add(newDO);
            srcBillIds.add(gUse.getSrcBillId());
        }
        if (EmptyUtil.isNoEmpty(srcBillIds)) {
            DeleteServiceHelper.delete((String)"gm_guaranteeuse", (QFilter[])new QFilter[]{new QFilter("gsrcbillid", "in", srcBillIds)});
        }
        if (EmptyUtil.isNoEmpty(gUseDOList)) {
            SaveServiceHelper.save((DynamicObject[])gUseDOList.toArray(new DynamicObject[0]));
        }
    }

    public static void saveGuaranteeUse(DynamicObject[] dataEntities, String ... formId) {
        String entityName = dataEntities[0].getDataEntityType().getName();
        String cPartyPropName = GuaranteeUseHelper.getBizPropName(entityName, "bizcparty");
        String orgPropName = GuaranteeUseHelper.getBizPropName(entityName, "debtor");
        String ccyPropName = GuaranteeUseHelper.getBizPropName(entityName, "bizcurrency");
        String startDatePropName = GuaranteeUseHelper.getBizPropName(entityName, "bizstartdate");
        String endDatePropName = GuaranteeUseHelper.getBizPropName(entityName, "bizenddate");
        String bizAmountPropName = GuaranteeUseHelper.getBizPropName(entityName, "bizamount");
        ArrayList<GuaranteeUseBean> gUseList = new ArrayList<GuaranteeUseBean>(dataEntities.length);
        ArrayList<Long> deleteBizIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject srcBill : dataEntities) {
            Date endDate;
            Long srcBillId = srcBill.getLong("id");
            DynamicObjectCollection gContractDC = srcBill.getDynamicObjectCollection("entry_gcontract");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)gContractDC)) {
                deleteBizIds.add(srcBillId);
                continue;
            }
            String srcBillType = EmptyUtil.isEmpty((Object[])formId) ? srcBill.getDataEntityType().getName() : formId[0];
            String billNo = srcBill.getString("billno");
            DynamicObject bizOrg = srcBill.getDynamicObject(orgPropName);
            DynamicObject bizCurrency = srcBill.getDynamicObject(ccyPropName);
            Long debtOrgId = bizOrg == null ? 0L : bizOrg.getLong("id");
            String debtOrgName = bizOrg == null ? "" : bizOrg.getString("name");
            Long debtCcyId = bizCurrency == null ? 0L : bizCurrency.getLong("id");
            Date startDate = srcBill.getDate(startDatePropName);
            if ("cdm_payablebill_ap_manual".equals(srcBillType)) {
                DynamicObjectCollection entryEntityCol = srcBill.getDynamicObjectCollection("entryentity");
                if (entryEntityCol == null || entryEntityCol.size() < 1) {
                    endDate = new Date();
                } else {
                    Collections.sort(entryEntityCol, (arg0, arg1) -> arg1.getDate(endDatePropName).compareTo(arg0.getDate(endDatePropName)));
                    endDate = ((DynamicObject)entryEntityCol.get(0)).getDate(endDatePropName);
                }
            } else {
                endDate = srcBill.getDate(endDatePropName);
            }
            BigDecimal bizAmount = srcBill.getBigDecimal(bizAmountPropName);
            Map<String, BigDecimal> bizAmountMap = GuaranteeUseHelper.getBankSyncMap(entityName, srcBill);
            Object cParty = null;
            if (EmptyUtil.isNoEmpty((String)cPartyPropName)) {
                if ("cdm_payablebill_ap_manual".equals(srcBillType)) {
                    DynamicObject acceptFinOrg = srcBill.getDynamicObject("accepterfinorg");
                    if (EmptyUtil.isNoEmpty((DynamicObject)acceptFinOrg)) {
                        cParty = acceptFinOrg.getDynamicObject("bebank");
                    }
                } else {
                    cParty = srcBill.get(cPartyPropName);
                }
                if (cParty instanceof DynamicObject) {
                    cParty = ((DynamicObject)cParty).getString("name");
                }
            }
            for (DynamicObject gc : gContractDC) {
                if (EmptyUtil.isEmpty((DynamicObject)gc.getDynamicObject("gcontract"))) continue;
                GuaranteeUseBean gUse = new GuaranteeUseBean();
                gUse.setSrcBillId(srcBillId);
                gUse.setSrcBillType(srcBillType);
                gUse.setSrcBillNo(billNo);
                Long gcContractId = gc.getDynamicObject("gcontract").getLong("id");
                gUse.setgContractId(gcContractId);
                gUse.setBizAmount(GuaranteeUseHelper.getMultiCreditorFlag(entityName) && bizAmountMap.containsKey(gc.getString("gcreditortype") + gc.getString("gcreditor")) ? bizAmountMap.get(gc.getString("gcreditortype") + gc.getLong("gcreditor")) : bizAmount);
                gUse.setComment(gc.getString("gcomment"));
                gUse.setgAmount(gc.getBigDecimal("gamount"));
                gUse.setgRatio(gc.getBigDecimal("gratio"));
                gUse.setExchrate(gc.getBigDecimal("gexchrate"));
                gUse.setDebtOrgId(debtOrgId);
                gUse.setDebtOrgText(debtOrgName);
                gUse.setDebtCurrencyId(debtCcyId);
                gUse.setCparty((String)cParty);
                gUse.setDebtStartDate(startDate);
                gUse.setDebtEndDate(endDate);
                if (GuaranteeUseHelper.getMultiCreditorFlag(entityName)) {
                    gUse.setgCreditorType(gc.getString("gcreditortype"));
                    gUse.setgCreditor(Long.valueOf(gc.getLong("gcreditor")));
                    gUse.setgCreditorText(gc.getString("gcreditortext"));
                }
                gUseList.add(gUse);
            }
        }
        if (EmptyUtil.isNoEmpty(deleteBizIds)) {
            GuaranteeUseHelper.deleteGuaranteeUse(deleteBizIds);
        }
        if (EmptyUtil.isNoEmpty(gUseList)) {
            GuaranteeUseHelper.saveGuaranteeUse(gUseList);
        }
    }

    public static boolean getMultiCreditorFlag(String entityName) {
        return "cfm_loancontractbill".equals(entityName) || "cfm_contract_apply".equals(entityName) || "ifm_loancontractbill".equals(entityName) || "cfm_loanbill".equals(entityName) || "cfm_loancontract_bo".equals(entityName) || "cfm_loanbill_bond".equals(entityName) || "ifm_loanbill".equals(entityName);
    }

    public static Map<String, Object> getBankSyncMap(String entityName, IDataModel iDataModel, int rowIdx) {
        HashMap<String, Object> bankSyncMap = new HashMap<String, Object>(4);
        if ("cfm_loancontractbill".equals(entityName) || "ifm_loancontractbill".equals(entityName) || "cfm_loanbill".equals(entityName) || "ifm_loanbill".equals(entityName)) {
            DynamicObject productFactory;
            String creditorType = (String)iDataModel.getValue("creditortype");
            Long creditor = (Long)iDataModel.getValue("creditor");
            if (EmptyUtil.isNoEmpty((String)creditorType) && creditor != null) {
                boolean isContractOccupy = true;
                if (Arrays.asList("cfm_loancontractbill", "ifm_loancontractbill").contains(entityName) && ((Boolean)iDataModel.getValue("issyncdraw")).booleanValue() && EmptyUtil.isNoEmpty((Object)iDataModel.getProperty("synccreditlimit")) && EmptyUtil.isNoEmpty((Object)iDataModel.getValue("synccreditlimit"))) {
                    productFactory = (DynamicObject)iDataModel.getValue("productfactory");
                    isContractOccupy = EmptyUtil.isNoEmpty((DynamicObject)productFactory) && productFactory.getBoolean("isloancommit");
                }
                bankSyncMap.put("gsrcbizamount", iDataModel.getValue(!isContractOccupy ? "syncdrawamount" : GuaranteeUseHelper.getBizPropName(entityName, "bizamount")));
                bankSyncMap.put("gcreditortype", creditorType);
                bankSyncMap.put("gcreditor", creditor);
                bankSyncMap.put("gcreditortext", iDataModel.getValue("textcreditor"));
            }
            if ("sl".equals(iDataModel.getValue("loantype"))) {
                boolean isLoanAmount = false;
                if ("cfm_loancontractbill".equals(entityName)) {
                    productFactory = (DynamicObject)iDataModel.getValue("productfactory");
                    boolean isContractOccupy = EmptyUtil.isNoEmpty((DynamicObject)productFactory) && productFactory.getBoolean("isloancommit");
                    isLoanAmount = (Boolean)iDataModel.getValue("issyncdraw") != false && !isContractOccupy;
                }
                bankSyncMap.put("gsrcbizamount", iDataModel.getValue(isLoanAmount ? "e_loanamount" : "e_shareamount", rowIdx));
                bankSyncMap.put("gcreditortype", iDataModel.getValue("e_bankrole", rowIdx));
                DynamicObject bankDo = (DynamicObject)iDataModel.getValue("e_bank", rowIdx);
                if (EmptyUtil.isNoEmpty((DynamicObject)bankDo)) {
                    bankSyncMap.put("gcreditor", bankDo.getLong("id"));
                    bankSyncMap.put("gcreditortext", bankDo.getString("name"));
                }
            }
        } else if ("cfm_loancontract_bo".equals(entityName) && ((Boolean)iDataModel.getValue("issyncdraw")).booleanValue() || "cfm_loanbill_bond".equals(entityName)) {
            bankSyncMap.put("gcreditortype", iDataModel.getValue("e_investortype", rowIdx));
            bankSyncMap.put("gcreditor", iDataModel.getValue("e_investorid", rowIdx));
            bankSyncMap.put("gcreditortext", iDataModel.getValue("e_investorname", rowIdx));
            bankSyncMap.put("gsrcbizamount", iDataModel.getValue("e_investamount", rowIdx));
        }
        return bankSyncMap;
    }

    public static Map<String, BigDecimal> getBankSyncMap(String entityName, IDataModel iDataModel) {
        HashMap<String, BigDecimal> bizAmountMap;
        block7: {
            block6: {
                bizAmountMap = new HashMap<String, BigDecimal>(16);
                if (!"cfm_loancontractbill".equals(entityName) && !"ifm_loancontractbill".equals(entityName) && !"cfm_contract_apply".equals(entityName) && !"cfm_loanbill".equals(entityName) && !"ifm_loanbill".equals(entityName)) break block6;
                String creditorType = (String)iDataModel.getValue("creditortype");
                Long creditor = (Long)iDataModel.getValue("creditor");
                if (EmptyUtil.isNoEmpty((String)creditorType) && creditor != null) {
                    boolean isContractOccupy = true;
                    if (Arrays.asList("cfm_loancontractbill", "ifm_loancontractbill").contains(entityName) && ((Boolean)iDataModel.getValue("issyncdraw")).booleanValue() && EmptyUtil.isNoEmpty((Object)iDataModel.getProperty("synccreditlimit")) && EmptyUtil.isNoEmpty((Object)iDataModel.getValue("synccreditlimit"))) {
                        DynamicObject productFactory = (DynamicObject)iDataModel.getValue("productfactory");
                        isContractOccupy = EmptyUtil.isNoEmpty((DynamicObject)productFactory) && productFactory.getBoolean("isloancommit");
                    }
                    bizAmountMap.put(creditorType + creditor, (BigDecimal)iDataModel.getValue(!isContractOccupy ? "syncdrawamount" : GuaranteeUseHelper.getBizPropName(entityName, "bizamount")));
                }
                if (!"sl".equals(iDataModel.getValue("loantype"))) break block7;
                DynamicObject productFactory = (DynamicObject)iDataModel.getValue("productfactory");
                boolean isContractOccupy = EmptyUtil.isNoEmpty((DynamicObject)productFactory) && productFactory.getBoolean("isloancommit");
                boolean isLoanAmount = false;
                if ("cfm_loancontractbill".equals(entityName)) {
                    isLoanAmount = (Boolean)iDataModel.getValue("issyncdraw") != false && !isContractOccupy;
                }
                for (DynamicObject bankSyncEntry : iDataModel.getEntryEntity("banksyndicate_entry")) {
                    String srcBankRole = bankSyncEntry.getString("e_bankrole");
                    DynamicObject bankDo = bankSyncEntry.getDynamicObject("e_bank");
                    DynamicObject creditLimitDo = bankSyncEntry.getDynamicObject(GuaranteeUseHelper.getBizPropName(entityName, "entry_creditlimit"));
                    if (EmptyUtil.isEmpty((String)srcBankRole) || EmptyUtil.isEmpty((DynamicObject)bankDo) || "cfm_loancontractbill".equals(entityName) && !isContractOccupy && EmptyUtil.isEmpty((DynamicObject)creditLimitDo)) continue;
                    Long srcBankId = bankDo.getLong("id");
                    bizAmountMap.put(srcBankRole + srcBankId, bankSyncEntry.getBigDecimal(isLoanAmount ? "e_loanamount" : "e_shareamount"));
                }
                break block7;
            }
            if ("cfm_loancontract_bo".equals(entityName) && ((Boolean)iDataModel.getValue("issyncdraw")).booleanValue() || "cfm_loanbill_bond".equals(entityName)) {
                for (DynamicObject investorEntry : iDataModel.getEntryEntity("investor_entry")) {
                    String srcBankRole = investorEntry.getString("e_investortype");
                    Long srcBankId = investorEntry.getLong("e_investorid");
                    DynamicObject creditLimitDo = investorEntry.getDynamicObject(GuaranteeUseHelper.getBizPropName(entityName, "head_creditlimit"));
                    if (EmptyUtil.isEmpty((String)srcBankRole) || srcBankId == null || EmptyUtil.isEmpty((DynamicObject)creditLimitDo)) continue;
                    bizAmountMap.put(srcBankRole + srcBankId, investorEntry.getBigDecimal("e_investamount"));
                }
            }
        }
        return bizAmountMap;
    }

    public static Map<String, BigDecimal> getBankSyncMap(String entityName, DynamicObject bizBill) {
        HashMap<String, BigDecimal> bizAmountMap;
        block7: {
            block6: {
                bizAmountMap = new HashMap<String, BigDecimal>(16);
                if (!"cfm_loancontractbill".equals(entityName) && !"ifm_loancontractbill".equals(entityName) && !"cfm_contract_apply".equals(entityName) && !"cfm_loanbill".equals(entityName) && !"ifm_loanbill".equals(entityName)) break block6;
                String creditorType = bizBill.getString("creditortype");
                Long creditor = bizBill.getLong("creditor");
                if (EmptyUtil.isNoEmpty((String)creditorType) && creditor != null) {
                    boolean isContractOccupy = true;
                    if (Arrays.asList("cfm_loancontractbill", "ifm_loancontractbill").contains(entityName) && bizBill.getBoolean("issyncdraw") && bizBill.containsProperty("synccreditlimit") && EmptyUtil.isNoEmpty((DynamicObject)bizBill.getDynamicObject("synccreditlimit"))) {
                        DynamicObject productFactory = bizBill.getDynamicObject("productfactory");
                        isContractOccupy = EmptyUtil.isNoEmpty((DynamicObject)productFactory) && productFactory.getBoolean("isloancommit");
                    }
                    bizAmountMap.put(creditorType + creditor, bizBill.getBigDecimal(!isContractOccupy ? "syncdrawamount" : GuaranteeUseHelper.getBizPropName(entityName, "bizamount")));
                }
                if (!"sl".equals(bizBill.getString("loantype"))) break block7;
                DynamicObject productFactory = bizBill.getDynamicObject("productfactory");
                boolean isContractOccupy = EmptyUtil.isNoEmpty((DynamicObject)productFactory) && productFactory.getBoolean("isloancommit");
                boolean isLoanAmount = false;
                if ("cfm_loancontractbill".equals(entityName)) {
                    isLoanAmount = bizBill.getBoolean("issyncdraw") && !isContractOccupy;
                }
                for (DynamicObject bankSyncEntry : bizBill.getDynamicObjectCollection("banksyndicate_entry")) {
                    String srcBankRole = bankSyncEntry.getString("e_bankrole");
                    DynamicObject bankDo = bankSyncEntry.getDynamicObject("e_bank");
                    DynamicObject creditLimitDo = bankSyncEntry.getDynamicObject(GuaranteeUseHelper.getBizPropName(entityName, "entry_creditlimit"));
                    if (EmptyUtil.isEmpty((String)srcBankRole) || EmptyUtil.isEmpty((DynamicObject)bankDo) || "cfm_loancontractbill".equals(entityName) && !isContractOccupy && EmptyUtil.isEmpty((DynamicObject)creditLimitDo)) continue;
                    Long srcBankId = bankDo.getLong("id");
                    bizAmountMap.put(srcBankRole + srcBankId, bankSyncEntry.getBigDecimal(isLoanAmount ? "e_loanamount" : "e_shareamount"));
                }
                break block7;
            }
            if ("cfm_loancontract_bo".equals(entityName) && bizBill.getBoolean("issyncdraw") || "cfm_loanbill_bond".equals(entityName)) {
                for (DynamicObject investorEntry : bizBill.getDynamicObjectCollection("investor_entry")) {
                    String srcBankRole = investorEntry.getString("e_investortype");
                    Long srcBankId = investorEntry.getLong("e_investorid");
                    DynamicObject creditLimitDo = investorEntry.getDynamicObject(GuaranteeUseHelper.getBizPropName(entityName, "head_creditlimit"));
                    if (EmptyUtil.isEmpty((String)srcBankRole) || srcBankId == null || EmptyUtil.isEmpty((DynamicObject)creditLimitDo)) continue;
                    bizAmountMap.put(srcBankRole + srcBankId, investorEntry.getBigDecimal("e_investamount"));
                }
            }
        }
        return bizAmountMap;
    }

    public static DynamicObjectCollection getGuaranteeUseBills(Set<Long> creditLimitIds) {
        DynamicObjectCollection gcUseBill = new DynamicObjectCollection();
        for (Long creditLimitId : creditLimitIds) {
            DynamicObjectCollection guaranteeUseBills = GuaranteeUseHelper.getGuaranteeUseBills(creditLimitId);
            for (DynamicObject gcUse : guaranteeUseBills) {
                gcUse.set("gsrcbillid", (Object)creditLimitId);
                gcUseBill.add((Object)gcUse);
            }
        }
        return gcUseBill;
    }

    public static DynamicObjectCollection getGuaranteeUseBills(Long creditLimitId) {
        DynamicObjectCollection guaranteeUseBills = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", GUARANTEE_USE_PROPS), (QFilter[])new QFilter[]{new QFilter("gsrcbillid", "=", (Object)creditLimitId), new QFilter("gsrcbilltype", "in", Arrays.asList("cfm_creditlimit", "creditm_limit_framework"))}, (String)"id");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)guaranteeUseBills)) {
            return guaranteeUseBills;
        }
        DynamicObject creditLimit = QueryServiceHelper.queryOne((String)"cfm_creditlimit", (String)"framework", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)creditLimitId)});
        if (EmptyUtil.isEmpty((DynamicObject)creditLimit) || EmptyUtil.isEmpty((Long)creditLimit.getLong("framework"))) {
            return guaranteeUseBills;
        }
        return GuaranteeUseHelper.getGuaranteeUseBills(creditLimit.getLong("framework"));
    }

    public static void confirmGuaranteeUse(DynamicObject[] bizDOs) {
        ArrayList<Long> bizIdSet = new ArrayList<Long>(bizDOs.length);
        for (DynamicObject lgDO : bizDOs) {
            bizIdSet.add(lgDO.getLong("id"));
        }
        GuaranteeUseHelper.confirmGuaranteeUse(bizIdSet);
    }

    public static void confirmGuaranteeUse(List<Long> bizIds) {
        QFilter idFilter = new QFilter("gsrcbillid", "in", bizIds);
        Object[] gcUseBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)"gcontract, billstatus", (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((Object[])gcUseBills)) {
            return;
        }
        for (Object gcUseBill : gcUseBills) {
            gcUseBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])gcUseBills);
        GuaranteeUseHelper.updateGuaranteeContract((DynamicObject[])gcUseBills);
    }

    public static void cancelGuaranteeUse(DynamicObject[] bizDOs) {
        ArrayList<Long> bizIdSet = new ArrayList<Long>(bizDOs.length);
        for (DynamicObject bizDO : bizDOs) {
            Long bizId = bizDO.getLong("id");
            bizIdSet.add(bizId);
        }
        if (EmptyUtil.isEmpty(bizIdSet)) {
            return;
        }
        GuaranteeUseHelper.cancelGuaranteeUse(bizIdSet);
    }

    public static void cancelGuaranteeUse(List<Long> bizIdSet) {
        QFilter idFilter = new QFilter("gsrcbillid", "in", bizIdSet);
        Object[] gcUseBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)"gcontract, billstatus", (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((Object[])gcUseBills)) {
            return;
        }
        for (Object gcUseBill : gcUseBills) {
            gcUseBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])gcUseBills);
        GuaranteeUseHelper.updateGuaranteeContract((DynamicObject[])gcUseBills);
    }

    private static void updateGuaranteeContract(DynamicObject[] gcUseBills) {
        HashSet<Long> gcContractIds = new HashSet<Long>(16);
        for (DynamicObject gcUseBill : gcUseBills) {
            DynamicObject gContractF7DO = gcUseBill.getDynamicObject("gcontract");
            gcContractIds.add(gContractF7DO.getLong("id"));
        }
        GuaranteeUseHelper.updateGuaranteeContract(gcContractIds);
    }

    private static void updateGuaranteeContract(Set<Long> contractIds) {
        List useBills;
        Long contractId;
        QFilter idFilter = new QFilter("id", "in", contractIds);
        DynamicObject[] gContracts = TmcDataServiceHelper.load((String)"gm_guaranteecontract", (String)"bizstatus,dutyamount", (QFilter[])new QFilter[]{idFilter});
        QFilter gcUseFilter = new QFilter("gcontract.id", "in", contractIds);
        gcUseFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObject[] gcUseBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gcontract", "gdebtbalance", "gexchrate"), (QFilter[])new QFilter[]{gcUseFilter});
        HashMap<Long, List> contractIdToUseBills = new HashMap<Long, List>(16);
        for (DynamicObject gcUseBill : gcUseBills) {
            contractId = gcUseBill.getDynamicObject("gcontract").getLong("id");
            useBills = contractIdToUseBills.computeIfAbsent(contractId, k -> new ArrayList(10));
            useBills.add(gcUseBill);
        }
        for (DynamicObject contract : gContracts) {
            contractId = contract.getLong("id");
            useBills = (List)contractIdToUseBills.get(contractId);
            if ("closed".equals(contract.getString("bizstatus")) || "changing".equals(contract.getString("bizstatus"))) continue;
            if (!EmptyUtil.isEmpty((Collection)useBills) && !"doing".equals(contract.getString("bizstatus"))) {
                contract.set("bizstatus", (Object)"doing");
            }
            if (!EmptyUtil.isEmpty((Collection)useBills)) continue;
            contract.set("bizstatus", (Object)"registed");
        }
        SaveServiceHelper.save((DynamicObject[])gContracts);
    }

    public static void deleteGuaranteeUse(DynamicObject[] dataEntities) {
        ArrayList<Long> pkList = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject lgDO : dataEntities) {
            pkList.add(lgDO.getLong("id"));
        }
        GuaranteeUseHelper.deleteGuaranteeUse(pkList);
    }

    public static void deleteGuaranteeUse(List<Long> bizIdSet) {
        if (EmptyUtil.isEmpty(bizIdSet)) {
            return;
        }
        QFilter idFilter = new QFilter("gsrcbillid", "in", bizIdSet);
        DeleteServiceHelper.delete((String)"gm_guaranteeuse", (QFilter[])new QFilter[]{idFilter});
    }

    public static void returnGuaranteeUse(List<GuaranteeUseReturnBean> returns) {
        if (EmptyUtil.isEmpty(returns)) {
            return;
        }
        ArrayList<Long> srcIdSet = new ArrayList<Long>(returns.size());
        for (GuaranteeUseReturnBean ret : returns) {
            srcIdSet.add(ret.getBizBillId());
        }
        QFilter idFilter = new QFilter("gsrcbillid", "in", srcIdSet);
        Object[] gcUseBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", gcProps), (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((Object[])gcUseBills)) {
            return;
        }
        HashMap idToDOMap = new HashMap(16);
        for (Object gcUse : gcUseBills) {
            List<Object> gcUseList;
            Long srcBizBillId = gcUse.getLong("gsrcbillid");
            String creditorType = gcUse.getString("gcreditortype");
            Long creditor = gcUse.getLong("gcreditor");
            if (EmptyUtil.isNoEmpty((String)creditorType) && EmptyUtil.isNoEmpty((Long)creditor)) {
                gcUseList = (List)idToDOMap.get(srcBizBillId + creditorType + creditor);
                if (gcUseList == null) {
                    gcUseList = new ArrayList(16);
                    idToDOMap.put(srcBizBillId + creditorType + creditor, gcUseList);
                }
                gcUseList.add(gcUse);
                continue;
            }
            gcUseList = (ArrayList<Object>)idToDOMap.get(srcBizBillId.toString());
            if (gcUseList == null) {
                gcUseList = new ArrayList<Object>(16);
                idToDOMap.put(srcBizBillId.toString(), gcUseList);
            }
            gcUseList.add(gcUse);
        }
        for (GuaranteeUseReturnBean ret : returns) {
            Long bizBillId = ret.getBizBillId();
            String creditorId = ret.getCreditorId();
            String billType = ret.getReturnBillType();
            Long returnBillId = ret.getReturnBillId();
            List gcUseList = (List)idToDOMap.get(EmptyUtil.isEmpty((String)creditorId) ? bizBillId.toString() : bizBillId + creditorId);
            if (gcUseList == null) continue;
            for (DynamicObject gcUse : gcUseList) {
                DynamicObjectCollection returnDC = gcUse.getDynamicObjectCollection("return_entry");
                Iterator retEntryIt = returnDC.iterator();
                while (retEntryIt.hasNext()) {
                    if (!returnBillId.equals(((DynamicObject)retEntryIt.next()).getLong("e_returnbillid"))) continue;
                    retEntryIt.remove();
                }
                DynamicObject newRet = returnDC.addNew();
                newRet.set("e_returnamount", (Object)ret.getReturnAmount());
                newRet.set("e_returnbillid", (Object)returnBillId);
                newRet.set("e_returnbilltype", (Object)billType);
                BigDecimal totalRet = BigDecimal.ZERO;
                for (DynamicObject retEntry : returnDC) {
                    totalRet = totalRet.add(retEntry.getBigDecimal("e_returnamount"));
                }
                BigDecimal bizAmount = gcUse.getBigDecimal("gsrcbillbizamount");
                BigDecimal balanceDebt = bizAmount.subtract(totalRet);
                gcUse.set("gdebtbalance", (Object)((balanceDebt = balanceDebt.multiply(gcUse.getBigDecimal("gratio")).divide(Constants.ONE_HUNDRED)).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : balanceDebt));
            }
        }
        SaveServiceHelper.save((DynamicObject[])gcUseBills);
    }

    public static void cancelReturnGuaranteeUse(List<GuaranteeUseReturnBean> returns) {
        HashSet<Long> returnBillIdSet = new HashSet<Long>(returns.size());
        for (GuaranteeUseReturnBean ret : returns) {
            returnBillIdSet.add(ret.getReturnBillId());
        }
        QFilter returnFilter = new QFilter("return_entry.e_returnbillid", "in", returnBillIdSet);
        Object[] gcUseBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", gcProps), (QFilter[])new QFilter[]{returnFilter});
        if (EmptyUtil.isEmpty((Object[])gcUseBills)) {
            return;
        }
        for (Object gcUse : gcUseBills) {
            DynamicObjectCollection returnDC = gcUse.getDynamicObjectCollection("return_entry");
            Iterator iterator = returnDC.iterator();
            while (iterator.hasNext()) {
                if (!returnBillIdSet.contains(((DynamicObject)iterator.next()).getLong("e_returnbillid"))) continue;
                iterator.remove();
            }
            BigDecimal totalRet = BigDecimal.ZERO;
            for (DynamicObject retEntry : returnDC) {
                totalRet = totalRet.add(retEntry.getBigDecimal("e_returnamount"));
            }
            BigDecimal bizAmount = gcUse.getBigDecimal("gsrcbillbizamount");
            BigDecimal ratio = gcUse.getBigDecimal("gratio");
            BigDecimal balanceDebt = bizAmount.subtract(totalRet);
            gcUse.set("gdebtbalance", (Object)((balanceDebt = balanceDebt.multiply(ratio).divide(Constants.ONE_HUNDRED)).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : balanceDebt));
        }
        SaveServiceHelper.save((DynamicObject[])gcUseBills);
    }

    public static BigDecimal getGContractAvailableDutyAmt(Long gContractId, Long debtOrgId) {
        ArrayList<Long> gcContractIds = new ArrayList<Long>(1);
        gcContractIds.add(gContractId);
        ArrayList<Long> debtOrgIds = new ArrayList<Long>(1);
        debtOrgIds.add(debtOrgId);
        Map<Long, BigDecimal> resultMap = GuaranteeUseHelper.getGContractAvailableDutyAmt(gcContractIds, debtOrgIds);
        return resultMap.get(gContractId);
    }

    public static Map<Long, BigDecimal> getGContractAvailableDutyAmt(List<Long> contractIds, List<Long> debtOrgIds) {
        HashMap<Long, BigDecimal> resultMap = new HashMap<Long, BigDecimal>(16);
        DynamicObjectCollection gContracts = QueryServiceHelper.query((String)"gm_guaranteecontract", (String)"id,entry_guaranteedorg.b_guaranteedorg,entry_guaranteedorg.b_gamount", (QFilter[])new QFilter[]{new QFilter("id", "in", contractIds).and(new QFilter("entry_guaranteedorg.b_guaranteedorg", "in", debtOrgIds))});
        for (DynamicObject gc : gContracts) {
            Long gcId = gc.getLong("id");
            BigDecimal gContractAmount = gc.getBigDecimal("entry_guaranteedorg.b_gamount");
            QFilter gcFilter = new QFilter("gcontract.id", "=", (Object)gc.getLong("id"));
            gcFilter.and(new QFilter("gdebtorg", "=", (Object)gc.getLong("entry_guaranteedorg.b_guaranteedorg")));
            gcFilter.and(new QFilter("billstatus", "=", (Object)"C"));
            gcFilter.and(new QFilter("gsrcbilltype", "!=", (Object)"cfm_creditlimit"));
            Object[] gcUseBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gdebtbalance", "gexchrate", "gsrcbilltype", "gsrcbillid", "gdebtenddate"), (QFilter[])new QFilter[]{gcFilter});
            gcUseBills = GuaranteeUseHelper.removeExpireData((DynamicObject[])gcUseBills);
            if (EmptyUtil.isEmpty((Object[])gcUseBills)) {
                resultMap.put(gcId, gContractAmount);
                continue;
            }
            BigDecimal totalBalance = BigDecimal.ZERO;
            for (Object gcUse : gcUseBills) {
                BigDecimal balance = gcUse.getBigDecimal("gdebtbalance");
                balance = balance.multiply(gcUse.getBigDecimal("gexchrate"));
                totalBalance = totalBalance.add(balance);
            }
            resultMap.put(gcId, gContractAmount.subtract(totalBalance));
        }
        return resultMap;
    }

    public static DynamicObject[] removeExpireData(DynamicObject[] gContracts) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
        Set billIdSet = Arrays.stream(gContracts).filter(g -> "cdm_payablebill".equals(g.getString("gsrcbilltype"))).map(c -> c.getLong("gsrcbillid")).collect(Collectors.toSet());
        Map<Object, Object> payableBillMap = new HashMap(8);
        if (EmptyUtil.isNoEmpty(billIdSet)) {
            QFilter qFilter = new QFilter("id", "in", billIdSet);
            DynamicObjectCollection payableBill = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id,draftbillstatus", (QFilter[])qFilter.toArray());
            payableBillMap = payableBill.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("draftbillstatus")));
        }
        for (DynamicObject gc : gContracts) {
            String draftBillStatus = (String)payableBillMap.get(gc.getLong("gsrcbillid"));
            if (EmptyUtil.isNotEmpty((CharSequence)draftBillStatus) && "splited".equals(draftBillStatus)) continue;
            if (EmptyUtil.isNotEmpty((CharSequence)draftBillStatus) && "payoffed".equals(draftBillStatus)) {
                gc.set("gdebtbalance", (Object)Constants.ZERO);
            }
            list.add(gc);
        }
        return list.toArray(new DynamicObject[list.size()]);
    }

    public static void returnGuaranteeUse(long bizBillId, Long returnBillId, String returnBillType, BigDecimal returnAmount) {
        ArrayList<GuaranteeUseReturnBean> returnList = new ArrayList<GuaranteeUseReturnBean>(1);
        GuaranteeUseReturnBean returnContractBean = new GuaranteeUseReturnBean();
        returnContractBean.setBizBillId(Long.valueOf(bizBillId));
        returnContractBean.setReturnBillId(returnBillId);
        returnContractBean.setReturnBillType(returnBillType);
        returnContractBean.setReturnAmount(returnAmount);
        returnList.add(returnContractBean);
        GuaranteeUseHelper.returnGuaranteeUse(returnList);
    }

    public static void cancelReturnGuaranteeUse(Long returnBillId, String returnBillType) {
        ArrayList<GuaranteeUseReturnBean> cancelReturnList = new ArrayList<GuaranteeUseReturnBean>(1);
        GuaranteeUseReturnBean cancelReturnBean = new GuaranteeUseReturnBean();
        cancelReturnBean.setReturnBillId(returnBillId);
        cancelReturnBean.setReturnBillType(returnBillType);
        cancelReturnList.add(cancelReturnBean);
        GuaranteeUseHelper.cancelReturnGuaranteeUse(cancelReturnList);
    }

    public static void genContractUseInfo(DynamicObject bill) {
        QFilter idFilter = new QFilter("gsrcbillid", "=", bill.getPkValue());
        DynamicObjectCollection dynamicObjects = bill.getDynamicObjectCollection("entry_gcontract");
        Object[] gcBills = BusinessDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", GUARANTEE_USE_PROPS), (QFilter[])new QFilter[]{idFilter}, (String)"id");
        if (EmptyUtil.isEmpty((Object[])gcBills)) {
            return;
        }
        for (Object gcBIll : gcBills) {
            DynamicObject dynamicObject = dynamicObjects.addNew();
            DynamicObject currency = TmcDataServiceHelper.loadSingleFromCache((Object)gcBIll.getDynamicObject("gcontract.currency").getPkValue(), (String)"bd_currency", (String)"numberm,name,amtprecision,priceprecision,sign,isshowsign");
            dynamicObject.set("gcontract", (Object)gcBIll.getDynamicObject("gcontract"));
            dynamicObject.set("gamount", gcBIll.get("gamount"));
            dynamicObject.set("gratio", gcBIll.get("gratio"));
            dynamicObject.set("gcontractamount", gcBIll.get("gcontract.amount"));
            dynamicObject.set("gcontractcurrency", (Object)currency);
            dynamicObject.set("gexchrate", gcBIll.get("gexchrate"));
            dynamicObject.set("gcomment", gcBIll.get("gcomment"));
            dynamicObject.set("gsrcbillid", gcBIll.get("gsrcbillid"));
            dynamicObject.set("gsrcbilltype", gcBIll.get("gsrcbilltype"));
            dynamicObject.set("gcreditguarantee", (Object)GuaranteeUseHelper.getCreditGuarantee((DynamicObject)gcBIll));
            dynamicObject.set("gstatus", GuaranteeUseHelper.getGStatus((DynamicObject)gcBIll));
        }
    }

    private static Object getGStatus(DynamicObject gcBIll) {
        if (gcBIll.getBigDecimal("gratio").compareTo(BigDecimal.ZERO) == 0) {
            return GuaUseStatusEnum.RELIEVED.getValue();
        }
        if (gcBIll.getBigDecimal("gdebtbalance").compareTo(BigDecimal.ZERO) == 0) {
            return GuaUseStatusEnum.SETTLED.getValue();
        }
        return GuaUseStatusEnum.GUARANTEEING.getValue();
    }

    public static boolean getCreditGuarantee(DynamicObject gcBIll) {
        DynamicObject guaranteeVarieties = gcBIll.getDynamicObject("gcontract.guaranteevarieties");
        DynamicObject guaranteeVariety = TmcDataServiceHelper.loadSingleFromCache((String)"gm_guaranteevarieties", (String)"creditguarantee", (QFilter[])new QFilter[]{new QFilter("id", "=", guaranteeVarieties.getPkValue())});
        if (guaranteeVariety != null) {
            return guaranteeVariety.getBoolean("creditguarantee");
        }
        return false;
    }

    public static void setGContractInfo(DynamicObject bizBill, Long gSrcBillId) {
        QFilter idFilter = new QFilter("gsrcbillid", "=", (Object)gSrcBillId);
        Object[] guaranteeUseBills = BusinessDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gcomment", "gcontract", "gamount", "gcontract.amount", "gcontract.currency", "gratio", "gexchrate"), (QFilter[])new QFilter[]{idFilter}, (String)"id");
        if (EmptyUtil.isNoEmpty((Object[])guaranteeUseBills)) {
            for (Object guaranteeUse : guaranteeUseBills) {
                DynamicObject newRow = bizBill.getDynamicObjectCollection("entry_gcontract").addNew();
                DynamicObject guaranteeVariety = guaranteeUse.getDynamicObject("gcontract.guaranteevarieties");
                newRow.set("gcreditguarantee", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)guaranteeVariety.getPkValue(), (String)guaranteeVariety.getDynamicObjectType().getName()).getBoolean("creditguarantee"));
                newRow.set("gcontract", guaranteeUse.get("gcontract"));
                newRow.set("gratio", guaranteeUse.get("gratio"));
                newRow.set("gamount", guaranteeUse.get("gamount"));
                newRow.set("gcontractamount", guaranteeUse.get("gcontract.amount"));
                newRow.set("gcontractcurrency", guaranteeUse.get("gcontract.currency"));
                newRow.set("gexchrate", guaranteeUse.get("gexchrate"));
                newRow.set("gcomment", guaranteeUse.get("gcomment"));
            }
        }
    }

    public static void copyGContractInfo(DynamicObject targetBill, DynamicObject sourceBill) {
        for (DynamicObject sourceRow : sourceBill.getDynamicObjectCollection("entry_gcontract")) {
            DynamicObject targetRow = targetBill.getDynamicObjectCollection("entry_gcontract").addNew();
            targetRow.set("gcontract", sourceRow.get("gcontract"));
            targetRow.set("gratio", sourceRow.get("gratio"));
            targetRow.set("gamount", sourceRow.get("gamount"));
            targetRow.set("gexchrate", sourceRow.get("gexchrate"));
            targetRow.set("gcomment", sourceRow.get("gcomment"));
        }
    }

    static {
        HashMap<String, String> lgBizPropMap = new HashMap<String, String>(16);
        lgBizPropMap.put("bizamount", "amount");
        lgBizPropMap.put("bizcurrency", "currency");
        lgBizPropMap.put("debtor", "applyorg");
        lgBizPropMap.put("bizcparty", "finorginfo");
        lgBizPropMap.put("bizguaranteeway", "guaranteeway");
        lgBizPropMap.put("bizstartdate", "startdate");
        lgBizPropMap.put("bizenddate", "expiredate");
        lgBizPropMap.put("head_creditlimit", "creditlimit");
        entityBizPropMap.put("gm_letterofguarantee", lgBizPropMap);
        entityBizPropMap.put("gm_letterofguaapply", lgBizPropMap);
        HashMap<String, String> cfmContBizPropMap = new HashMap<String, String>(16);
        cfmContBizPropMap.put("bizamount", "amount");
        cfmContBizPropMap.put("bizcurrency", "currency");
        cfmContBizPropMap.put("debtor", "org");
        cfmContBizPropMap.put("debtorid", "debtor");
        cfmContBizPropMap.put("creditor", "creditorg");
        cfmContBizPropMap.put("creditorid", "creditor");
        cfmContBizPropMap.put("textcreditor", "textcreditor");
        cfmContBizPropMap.put("bizcparty", "textcreditor");
        cfmContBizPropMap.put("bizguaranteeway", "guarantee");
        cfmContBizPropMap.put("bizstartdate", "startdate");
        cfmContBizPropMap.put("bizenddate", "enddate");
        cfmContBizPropMap.put("head_creditlimit", "creditlimit");
        cfmContBizPropMap.put("entry_creditlimit", "e_creditlimit");
        entityBizPropMap.put("cfm_loancontractbill", cfmContBizPropMap);
        entityBizPropMap.put("fl_leasecontractbill", cfmContBizPropMap);
        entityBizPropMap.put("fl_leasecontractbill_init", cfmContBizPropMap);
        entityBizPropMap.put("cim_invest_contract", cfmContBizPropMap);
        entityBizPropMap.put("cfm_contract_apply", cfmContBizPropMap);
        entityBizPropMap.put("cim_contract_apply", cfmContBizPropMap);
        entityBizPropMap.put("fl_contract_apply", cfmContBizPropMap);
        HashMap<String, String> cimContBizPropMap = new HashMap<String, String>(16);
        cimContBizPropMap.put("bizamount", "amount");
        cimContBizPropMap.put("bizcurrency", "currency");
        cimContBizPropMap.put("debtor", "org");
        cimContBizPropMap.put("debtorid", "debtor");
        cimContBizPropMap.put("creditor", "settlecenter");
        cimContBizPropMap.put("textcreditor", "textcreditor");
        cimContBizPropMap.put("bizcparty", "textcreditor");
        cimContBizPropMap.put("bizguaranteeway", "guarantee");
        cimContBizPropMap.put("bizstartdate", "startdate");
        cimContBizPropMap.put("bizenddate", "enddate");
        cimContBizPropMap.put("head_creditlimit", "creditlimit");
        entityBizPropMap.put("ifm_loancontractbill", cimContBizPropMap);
        entityBizPropMap.put("ifm_contract_apply", cimContBizPropMap);
        HashMap<String, String> cfmLoanBizPropMap = new HashMap<String, String>(16);
        cfmLoanBizPropMap.put("bizamount", "drawamount");
        cfmLoanBizPropMap.put("bizcurrency", "currency");
        cfmLoanBizPropMap.put("debtor", "org");
        cfmLoanBizPropMap.put("bizcparty", "textcreditor");
        cfmLoanBizPropMap.put("bizguaranteeway", "loancontractbill.guarantee");
        cfmLoanBizPropMap.put("bizstartdate", "bizdate");
        cfmLoanBizPropMap.put("bizenddate", "expiredate");
        cfmLoanBizPropMap.put("head_creditlimit", "creditlimit");
        cfmLoanBizPropMap.put("entry_creditlimit", "e_bankcreditlimit");
        entityBizPropMap.put("cfm_loanbill", cfmLoanBizPropMap);
        entityBizPropMap.put("ifm_loanbill", cfmLoanBizPropMap);
        entityBizPropMap.put("fl_receiptbill", cfmLoanBizPropMap);
        HashMap<String, String> cfmLoanBizBondPropMap = new HashMap<String, String>(16);
        cfmLoanBizBondPropMap.put("bizamount", "drawamount");
        cfmLoanBizBondPropMap.put("bizcurrency", "currency");
        cfmLoanBizBondPropMap.put("debtor", "org");
        cfmLoanBizBondPropMap.put("bizcparty", null);
        cfmLoanBizBondPropMap.put("bizguaranteeway", "guaranteeway");
        cfmLoanBizBondPropMap.put("bizstartdate", "bizdate");
        cfmLoanBizBondPropMap.put("bizenddate", "expiredate");
        cfmLoanBizBondPropMap.put("head_creditlimit", "e_creditlimit");
        entityBizPropMap.put("cfm_loanbill_bond", cfmLoanBizBondPropMap);
        HashMap<String, String> cfmInvestLoanBizPropMap = new HashMap<String, String>(16);
        cfmInvestLoanBizPropMap.put("bizamount", "drawamount");
        cfmInvestLoanBizPropMap.put("bizcurrency", "currency");
        cfmInvestLoanBizPropMap.put("debtor", "org");
        cfmInvestLoanBizPropMap.put("bizcparty", "textcreditor");
        cfmInvestLoanBizPropMap.put("bizguaranteeway", "loancontractbill.guarantee");
        cfmInvestLoanBizPropMap.put("bizstartdate", "bizdate");
        cfmInvestLoanBizPropMap.put("bizenddate", "expiredate");
        cfmInvestLoanBizPropMap.put("head_creditlimit", "creditlimit");
        entityBizPropMap.put("cim_invest_loanbill", cfmInvestLoanBizPropMap);
        HashMap<String, String> creditmBizPropMap = new HashMap<String, String>(16);
        creditmBizPropMap.put("bizamount", "totalamt");
        creditmBizPropMap.put("bizcurrency", "currency");
        creditmBizPropMap.put("debtor", "org");
        creditmBizPropMap.put("bizcparty", "bank");
        creditmBizPropMap.put("bizguaranteeway", "guartype");
        creditmBizPropMap.put("bizstartdate", "startdate");
        creditmBizPropMap.put("bizenddate", "enddate");
        entityBizPropMap.put("cfm_creditlimit", creditmBizPropMap);
        entityBizPropMap.put("creditm_limit_framework", creditmBizPropMap);
        HashMap<String, String> letterCreditBizPropMap = new HashMap<String, String>(16);
        letterCreditBizPropMap.put("bizamount", "amount");
        letterCreditBizPropMap.put("bizcurrency", "currency");
        letterCreditBizPropMap.put("debtor", "org");
        letterCreditBizPropMap.put("bizcparty", "bank");
        letterCreditBizPropMap.put("bizguaranteeway", "guarantee");
        letterCreditBizPropMap.put("bizstartdate", "bizdate");
        letterCreditBizPropMap.put("bizenddate", "dealbilltermend");
        letterCreditBizPropMap.put("head_creditlimit", "creditlimit");
        entityBizPropMap.put("lc_lettercredit", letterCreditBizPropMap);
        entityBizPropMap.put("lc_lettercredit_init", letterCreditBizPropMap);
        entityBizPropMap.put("lc_bizapply", letterCreditBizPropMap);
        HashMap<String, String> payableBillBizPropMap = new HashMap<String, String>(16);
        payableBillBizPropMap.put("bizamount", "amount");
        payableBillBizPropMap.put("bizcurrency", "currency");
        payableBillBizPropMap.put("debtor", "drawercompany");
        payableBillBizPropMap.put("bizcparty", "receivername");
        payableBillBizPropMap.put("bizguaranteeway", "guarantee");
        payableBillBizPropMap.put("bizstartdate", "issuedate");
        payableBillBizPropMap.put("bizenddate", "draftbillexpiredate");
        payableBillBizPropMap.put("head_creditlimit", "creditlimit");
        entityBizPropMap.put("cdm_payablebill", payableBillBizPropMap);
        HashMap<String, String> loanApplyBizPropMap = new HashMap<String, String>(16);
        loanApplyBizPropMap.put("bizamount", "amount");
        loanApplyBizPropMap.put("bizcurrency", "currency");
        loanApplyBizPropMap.put("debtor", "company");
        loanApplyBizPropMap.put("bizcparty", "textcreditor");
        loanApplyBizPropMap.put("bizguaranteeway", "guarantee");
        loanApplyBizPropMap.put("bizstartdate", "startdate");
        loanApplyBizPropMap.put("bizenddate", "enddate");
        loanApplyBizPropMap.put("head_creditlimit", "creditlimit");
        entityBizPropMap.put("cfm_loan_apply", loanApplyBizPropMap);
        entityBizPropMap.put("fl_financelease_apply", loanApplyBizPropMap);
        HashMap<String, String> bizDealBizPropMap = new HashMap<String, String>(16);
        bizDealBizPropMap.put("bizamount", "amount");
        bizDealBizPropMap.put("bizcurrency", "currency");
        bizDealBizPropMap.put("debtor", "org");
        bizDealBizPropMap.put("bizcparty", "creditor");
        bizDealBizPropMap.put("bizguaranteeway", "guarantee");
        bizDealBizPropMap.put("bizstartdate", "startdate");
        bizDealBizPropMap.put("bizenddate", "enddate");
        entityBizPropMap.put("ifm_bizdealbill", bizDealBizPropMap);
        HashMap<String, String> payableBillApPropMap = new HashMap<String, String>(16);
        payableBillApPropMap.put("bizamount", "amounttotal");
        payableBillApPropMap.put("bizcurrency", "currency");
        payableBillApPropMap.put("debtor", "company");
        payableBillApPropMap.put("bizcparty", "receiverbank");
        payableBillApPropMap.put("bizguaranteeway", "guarantee");
        payableBillApPropMap.put("bizstartdate", "bizdate");
        payableBillApPropMap.put("bizenddate", "draftbillexpiredate");
        payableBillApPropMap.put("head_creditlimit", "creditlimit");
        entityBizPropMap.put("cdm_payablebill_ap_manual", payableBillApPropMap);
        HashMap<String, String> loanContractBondMap = new HashMap<String, String>();
        loanContractBondMap.put("bizguaranteeway", "guarantee");
        loanContractBondMap.put("bizamount", "syncdrawamount");
        loanContractBondMap.put("bizcurrency", "syncdrawcurrency");
        loanContractBondMap.put("debtor", "org");
        loanContractBondMap.put("bizstartdate", "syncbizdate");
        loanContractBondMap.put("bizenddate", "expiredate");
        loanContractBondMap.put("head_creditlimit", "e_creditlimit_inv");
        entityBizPropMap.put("cfm_loancontract_bo", loanContractBondMap);
        HashMap<String, String> initBillMap = new HashMap<String, String>();
        initBillMap.put("bizguaranteeway", "guarantee");
        initBillMap.put("bizcurrency", "currency");
        initBillMap.put("debtor", "org");
        entityBizPropMap.put("cfm_initbill_b", initBillMap);
        entityBizPropMap.put("cfm_initbill", initBillMap);
        entityBizPropMap.put("ifm_initbill", initBillMap);
        entityBizPropMap.put("cfm_initbill_bond", initBillMap);
        entityBizPropMap.put("cim_invest_initbill", initBillMap);
    }
}

