/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.tmc.fca.extpoint.IBalanceService;
import kd.tmc.fbp.common.bean.BizBalanceModelBean;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.CasBusinessHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.model.BalanceModelService;
import kd.tmc.fca.common.enums.FcaDownWayEnum;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.enums.FcaUpWayEnum;
import kd.tmc.fca.common.enums.SettleMentTypeEnum;
import kd.tmc.fca.common.util.String2DecUtil;
import kd.tmc.service.servicehlper.BankServiceHelper;

public class AmtCalcHelper {
    private static final Log logger = LogFactory.getLog(AmtCalcHelper.class);

    public static BigDecimal getAM2Total(DynamicObject bankAcct, Object currencyId, boolean isPay) {
        BigDecimal[] amounts = AmtCalcHelper.getAM2(bankAcct, currencyId, isPay);
        return amounts[1].add(amounts[2]).subtract(amounts[3]).subtract(amounts[4]);
    }

    public static BigDecimal[] getAM2(DynamicObject bankAcct, Object currencyId, boolean isPay) {
        DynamicObject bankStrategy = AmtCalcHelper.getAcctStratg(bankAcct, Long.valueOf(currencyId.toString()));
        BigDecimal balance = AmtCalcHelper.getCurrBalance(bankAcct);
        BigDecimal b = AmtCalcHelper.getB_OverdrawBalance(bankStrategy);
        BigDecimal c = AmtCalcHelper.getC_PayingAmt_1(bankAcct, currencyId, isPay);
        BigDecimal d = AmtCalcHelper.getD_MinRemainedAmt(bankStrategy);
        BigDecimal am2 = balance.add(b).add(c.negate()).add(d.negate());
        logger.info("AmtCalcHelper-getAM2: am2:" + am2 + " balance:" + balance + " b:" + b + " c:" + c + " d:" + d);
        return Arrays.asList(am2, balance, b, c, d).toArray(new BigDecimal[0]);
    }

    public static BigDecimal[] getAM2Bank(DynamicObject bankAcct, Object currencyId, boolean isPay, long orgId) {
        DynamicObject bankStratg = AmtCalcHelper.getAcctStratg(bankAcct, Long.valueOf(currencyId.toString()));
        String amountValWay = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.FCA.getId(), (long)orgId, (String)"amountvalway");
        BigDecimal balance = BigDecimal.ZERO;
        if ("AccCurrBalance".equals(amountValWay)) {
            balance = AmtCalcHelper.getA_CurrBalance(bankAcct, currencyId);
        } else if ("AccValidBalance".equals(amountValWay)) {
            balance = AmtCalcHelper.getA_ValidBalance(bankAcct, currencyId);
        }
        BigDecimal b = AmtCalcHelper.getB_OverdrawBalance(bankStratg);
        BigDecimal c = AmtCalcHelper.getC_PayingAmt_1(bankAcct, currencyId, isPay);
        BigDecimal d = AmtCalcHelper.getD_MinRemainedAmt(bankStratg);
        BigDecimal am2 = balance.add(b).add(c.negate()).add(d.negate());
        logger.info("AmtCalcHelper-getAM2: am2:" + am2 + " balance:" + balance + " b:" + b + " c:" + c + " d:" + d);
        return Arrays.asList(am2, balance, b, c, d).toArray(new BigDecimal[0]);
    }

    private static BigDecimal getCurrBalance(DynamicObject bankAcct) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"ifm_accountbalance", (String)"amount", (QFilter[])new QFilter("accountbank", "=", bankAcct.getPkValue()).toArray(), (String)"bizdate desc", (int)1);
        return load.length > 0 ? load[0].getBigDecimal("amount") : BigDecimal.ZERO;
    }

    public static BigDecimal getBillTransUpRefTransAmt(DynamicObject bankAcct, Object currencyId, DynamicObject strategy, long orgId) {
        logger.info("AmtCalcHelper-getBillTransUpRefTransAmt: start------");
        PluginProxy pluginProxy = PluginProxy.create(IBalanceService.class, (String)"FCA_BALANCE_AMOUNT");
        List balanceList = pluginProxy.callReplace(proxy -> {
            Long strategyId = null;
            Long accountId = bankAcct.getLong("id");
            if (strategy != null) {
                strategyId = strategy.getLong("id");
            }
            Long currency = (Long)currencyId;
            return proxy.getBalanceAmount("UP", strategyId, accountId, currency);
        });
        if (balanceList != null && !balanceList.isEmpty()) {
            return (BigDecimal)balanceList.get(0);
        }
        BigDecimal amt = BigDecimal.ZERO;
        boolean isTransUp = strategy.getBoolean("istransup");
        if (!isTransUp) {
            return amt;
        }
        DynamicObject bankStrategy = AmtCalcHelper.getAcctStratg(bankAcct, Long.valueOf(currencyId.toString()));
        boolean isOpenBei = bankAcct.getBoolean("issetbankinterface");
        BigDecimal minRemainedAmt = AmtCalcHelper.getD_MinRemainedAmt(bankStrategy);
        BigDecimal balance = AmtCalcHelper.getBalanceModelAmount("fca_transupbill", bankAcct, (Long)currencyId, orgId, 0L);
        if (balance == null) {
            balance = AmtCalcHelper.getCurrentAmount(bankAcct, (Long)currencyId, orgId);
            if (balance == null) {
                balance = BigDecimal.ZERO;
            }
            balance = balance.subtract(minRemainedAmt);
        }
        logger.info("AmtCalcHelper-getBillTransUpRefTransAmt:isOpenBei:{}, minRemainedAmt:{}, balance:{}", new Object[]{isOpenBei, minRemainedAmt, balance});
        BigDecimal minTransUpAmt = strategy.getBigDecimal("minupamt");
        String intAmtStr = strategy.getString("transupint");
        BigDecimal intAmt = String2DecUtil.string2Dec((String)intAmtStr);
        boolean isInt = !intAmt.equals(BigDecimal.ZERO);
        String upWay = strategy.getString("upway");
        if (FcaUpWayEnum.ISFULLAMT.getValue().equals(upWay)) {
            BigDecimal bigDecimal = amt = isInt ? AmtCalcHelper.toDownInt(balance, intAmt) : balance;
            if (amt.compareTo(minTransUpAmt) < 0) {
                amt = BigDecimal.ZERO;
            }
            logger.info("AmtCalcHelper-getBillTransUpRefTransAmt:isfullamt isInt:{} amt:{}", (Object)isInt, (Object)amt);
            return amt;
        }
        if (FcaUpWayEnum.ISUPQUOTA.getValue().equals(upWay)) {
            BigDecimal upQuotAmt = strategy.getBigDecimal("upquotaamt");
            if (balance.compareTo(upQuotAmt) >= 0) {
                amt = upQuotAmt;
            }
            logger.info("AmtCalcHelper-getBillTransUpRefTransAmt:isupquota:{}", (Object)amt);
            return amt;
        }
        if (FcaUpWayEnum.ISSCALE.getValue().equals(upWay)) {
            BigDecimal scale;
            DynamicObject currency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "=", currencyId)});
            int currencyScale = 10;
            if (currency != null) {
                currencyScale = currency.getInt("amtprecision");
            }
            BigDecimal bigDecimal = amt = (amt = balance.multiply(scale = strategy.getBigDecimal("transupscale")).divide(new BigDecimal(100)).setScale(currencyScale, 4)).compareTo(minTransUpAmt) >= 0 ? amt : BigDecimal.ZERO;
            if (amt.compareTo(BigDecimal.ZERO) > 0) {
                amt = isInt ? AmtCalcHelper.toDownInt(amt, intAmt) : amt;
            }
            logger.info("AmtCalcHelper-getBillTransUpRefTransAmt:isscale: isInt:{}, amt:{}", (Object)isInt, (Object)amt);
            return amt;
        }
        if (FcaUpWayEnum.ISSAFETY.getValue().equals(upWay)) {
            BigDecimal safeAmt = strategy.getBigDecimal("safetyamt");
            if (minRemainedAmt.compareTo(safeAmt) >= 0) {
                BigDecimal bigDecimal = amt = isInt ? AmtCalcHelper.toDownInt(balance, intAmt) : balance;
                if (amt.compareTo(minTransUpAmt) < 0) {
                    amt = BigDecimal.ZERO;
                }
                logger.info("AmtCalcHelper-getBillTransUpRefTransAmt: issafety 1.1 isInt:{},1.1 amt:", (Object)isInt, (Object)amt);
                return amt;
            }
            BigDecimal bigDecimal = amt = isInt ? AmtCalcHelper.toDownInt(balance.add(minRemainedAmt).subtract(safeAmt), intAmt) : balance.add(minRemainedAmt).subtract(safeAmt);
            if (amt.compareTo(minTransUpAmt) < 0) {
                amt = BigDecimal.ZERO;
            }
            logger.info("AmtCalcHelper-getBillTransUpRefTransAmt:  issafety 2.1 isInt:{} 2.1 amt:{}", (Object)amt);
            return amt;
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getBillTransDownRefTransAmt(DynamicObject bankAcct, Object currencyId, DynamicObject strategy) {
        BigDecimal balance;
        logger.info("AmtCalcHelper-getBillTransDownRefTransAmt: start------");
        PluginProxy pluginProxy = PluginProxy.create(IBalanceService.class, (String)"FCA_BALANCE_AMOUNT");
        List balanceList = pluginProxy.callReplace(proxy -> {
            Long strategyId = null;
            Long accountId = bankAcct.getLong("id");
            if (strategy != null) {
                strategyId = strategy.getLong("id");
            }
            Long currency = (Long)currencyId;
            return proxy.getBalanceAmount("DOWN", strategyId, accountId, currency);
        });
        if (balanceList != null && !balanceList.isEmpty()) {
            return (BigDecimal)balanceList.get(0);
        }
        BigDecimal amt = BigDecimal.ZERO;
        boolean isTransDown = strategy.getBoolean("istransdown");
        if (!isTransDown) {
            return amt;
        }
        DynamicObject bankStrategy = AmtCalcHelper.getAcctStratg(bankAcct, Long.valueOf(currencyId.toString()));
        boolean isOpenBei = bankAcct.getBoolean("issetbankinterface");
        DynamicObject company = bankAcct.getDynamicObject("company");
        Long orgId = null;
        if (company != null) {
            orgId = company.getLong("id");
        }
        if ((balance = AmtCalcHelper.getCurrentAmount(bankAcct, (Long)currencyId, orgId)) == null) {
            balance = BigDecimal.ZERO;
        }
        BigDecimal minRemainedAmt = AmtCalcHelper.getD_MinRemainedAmt(bankStrategy);
        String downWay = strategy.getString("downway");
        logger.info("AmtCalcHelper-getBillTransUpRefTransAmt:isOpenBei:{}, minRemainedAmt:{}, downWay:{}", new Object[]{isOpenBei, minRemainedAmt, downWay});
        if (FcaDownWayEnum.ISPOLISH.getValue().equals(downWay)) {
            boolean isInt;
            BigDecimal fixedBalance = strategy.getBigDecimal("solidbal");
            BigDecimal minTransDownAmt = strategy.getBigDecimal("mindownamt");
            String intAmtStr = strategy.getString("transdownint");
            BigDecimal intAmt = String2DecUtil.string2Dec((String)intAmtStr);
            boolean bl = isInt = !intAmt.equals(BigDecimal.ZERO);
            if (fixedBalance.compareTo(minRemainedAmt) >= 0) {
                if (balance.compareTo(fixedBalance) >= 0) {
                    logger.info("AmtCalcHelper-getBillTransDownRefTransAmt:ispolish 1.1");
                    return BigDecimal.ZERO;
                }
                BigDecimal bigDecimal = amt = isInt ? AmtCalcHelper.toUpInt(fixedBalance.subtract(balance), intAmt) : fixedBalance.subtract(balance);
                if (amt.compareTo(minTransDownAmt) < 0) {
                    amt = isInt ? AmtCalcHelper.toUpInt(minTransDownAmt, intAmt) : minTransDownAmt;
                }
                logger.info("AmtCalcHelper-getBillTransDownRefTransAmt:ispolish 1.2 amt:{}, isInt:{}", (Object)amt, (Object)isInt);
                return amt;
            }
            if (balance.compareTo(minRemainedAmt) >= 0) {
                logger.info("AmtCalcHelper-getBillTransDownRefTransAmt:ispolish 2.1");
                return BigDecimal.ZERO;
            }
            BigDecimal bigDecimal = amt = isInt ? AmtCalcHelper.toUpInt(minRemainedAmt.subtract(balance), intAmt) : minRemainedAmt.subtract(balance);
            if (amt.compareTo(minTransDownAmt) < 0) {
                amt = isInt ? AmtCalcHelper.toUpInt(minTransDownAmt, intAmt) : minTransDownAmt;
            }
            logger.info("AmtCalcHelper-getBillTransDownRefTransAmt-time:  ispolish 2.2 amt:{},isInt:{}", (Object)amt, (Object)isInt);
            return amt;
        }
        if (FcaDownWayEnum.ISDOWNQUOTA.getValue().equals(downWay)) {
            amt = strategy.getBigDecimal("downquotaamt");
            logger.info("AmtCalcHelper-getBillTransDownRefTransAmt:isdownquota amt:{}", (Object)amt);
            return amt;
        }
        return BigDecimal.ZERO;
    }

    private static BigDecimal toDownInt(BigDecimal baseAmt, BigDecimal intAmt) {
        return baseAmt.divide(intAmt, 0, RoundingMode.DOWN).multiply(intAmt);
    }

    private static BigDecimal toUpInt(BigDecimal baseAmt, BigDecimal intAmt) {
        return baseAmt.divide(intAmt, 0, RoundingMode.UP).multiply(intAmt);
    }

    public static BigDecimal getA_CurrBalance(DynamicObject bankAcct, Object currencyId) {
        Long currTime = new Date().getTime();
        logger.info("AmtCalcHelper-getA_CurrBalance-time: " + currTime + "  start");
        boolean isOpenBei = bankAcct.getBoolean("issetbankinterface");
        String finorgtype = bankAcct.getString("finorgtype");
        BigDecimal balance = isOpenBei || "1".equals(finorgtype) ? AmtCalcHelper.getA1_CurrBalance(bankAcct, currencyId) : AmtCalcHelper.getA2_CurrBalance(bankAcct, currencyId);
        balance = balance == null ? new BigDecimal(0) : balance;
        logger.info("AmtCalcHelper-getA_CurrBalance-time: " + currTime + "  start isOpenBei:" + isOpenBei + " balance:" + balance + " bankAcctid:" + bankAcct.getPkValue());
        return balance;
    }

    public static BigDecimal getA_ValidBalance(DynamicObject bankAcct, Object currencyId) {
        Long currTime = new Date().getTime();
        logger.info("AmtCalcHelper-getA_CurrBalance-time: " + currTime + "  start");
        boolean isOpenBei = bankAcct.getBoolean("issetbankinterface");
        String finorgtype = bankAcct.getString("finorgtype");
        BigDecimal balance = isOpenBei || "1".equals(finorgtype) ? AmtCalcHelper.getA1_ValidBalance(bankAcct, currencyId) : AmtCalcHelper.getA2_CurrBalance(bankAcct, currencyId);
        balance = balance == null ? new BigDecimal(0) : balance;
        logger.info("AmtCalcHelper-getA_CurrBalance-time: " + currTime + "  start isOpenBei:" + isOpenBei + " balance:" + balance + " bankAcctid:" + bankAcct.getPkValue());
        return balance;
    }

    public static BigDecimal getPayBillPayAmt(long bankacctId, long currencyId, Date startTime, Date endTime) {
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.PAYED.getValue());
        QFilter startTimeFilter = new QFilter("paydate", ">=", (Object)startTime);
        QFilter endTimeFilter = new QFilter("paydate", "<=", (Object)endTime);
        QFilter draftBillFilter = new QFilter("settletype.settlementtype", "not in", (Object)new String[]{SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.BANK.getValue(), SettleMentTypeEnum.CHECK.getValue()});
        QFilter[] filters = new QFilter[]{new QFilter("payeracctbank", "=", (Object)bankacctId), new QFilter("currency", "=", (Object)currencyId), statusFilter, startTimeFilter, endTimeFilter, draftBillFilter};
        DataSet payBillSet = QueryServiceHelper.queryDataSet((String)"paymentbill", (String)"cas_paybill", (String)"payeracctbank.id,currency.id,actpayamt", (QFilter[])filters, null);
        DataSet ds = payBillSet.groupBy(new String[0]).sum("actpayamt").finish();
        if (ds.hasNext()) {
            Row row = ds.next();
            return row.getBigDecimal("actpayamt");
        }
        return Constants.ZERO;
    }

    private static BigDecimal getA1_CurrBalance(DynamicObject bankAcct, Object currencyId) {
        BigDecimal balance = BankServiceHelper.getCurBalance((Long)((Long)bankAcct.getPkValue()), (Long)((Long)currencyId));
        balance = balance == null ? new BigDecimal(0) : balance;
        return balance;
    }

    private static BigDecimal getA1_ValidBalance(DynamicObject bankAcct, Object currencyId) {
        BigDecimal balance = BankServiceHelper.getValidBalance((Long)((Long)bankAcct.getPkValue()), (Long)((Long)currencyId));
        balance = balance == null ? new BigDecimal(0) : balance;
        return balance;
    }

    private static BigDecimal getA2_CurrBalance(DynamicObject bankAcct, Object currencyId) {
        Long time = new Date().getTime();
        Long bankAcctId = (Long)bankAcct.getPkValue();
        logger.info("getA2_CurrBalance  parameter-->: " + time + "  " + bankAcct.get("company_id") + "   " + bankAcctId + "   " + currencyId);
        BigDecimal balance = (BigDecimal)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"accountAmountService", (String)"getAmountByAccount", (Object[])new Object[]{bankAcctId, currencyId, DateUtils.getCurrentDate()});
        logger.info("getA2_CurrBalance  parameter-->: result " + time + "  " + balance);
        balance = balance == null ? new BigDecimal(0) : balance;
        return balance;
    }

    public static BigDecimal getB_OverdrawBalance(DynamicObject strategy) {
        return strategy == null ? new BigDecimal(0) : strategy.getBigDecimal("overamt");
    }

    public static BigDecimal getC_PayingAmt(DynamicObject bankAcct, Object currencyId, boolean isPay) {
        BigDecimal c1Amount = AmtCalcHelper.getC1_PayingAmt(bankAcct, currencyId, isPay);
        BigDecimal c1AgentAmount = AmtCalcHelper.getC1_AgentPayingAmt(bankAcct, currencyId, isPay);
        BigDecimal c2Amount = AmtCalcHelper.getC2_PayingAmt(bankAcct, (Long)currencyId, isPay);
        logger.info("getC_PayingAmt  parameter-->: bankAcct:" + bankAcct.getPkValue() + "  currencyId: " + currencyId + "   isPay:" + isPay + " c1Amount:" + c1Amount + " c1AgentAmount:" + c1AgentAmount + " c2Amount:" + c2Amount);
        return c1Amount.add(c1AgentAmount).add(c2Amount);
    }

    public static BigDecimal getC_PayingAmt_1(DynamicObject bankAcct, Object currencyId, boolean isPay) {
        BigDecimal c1Amount = AmtCalcHelper.getC1_PayingAmt_1(bankAcct, currencyId, isPay);
        BigDecimal c1AgentAmount = AmtCalcHelper.getC1_AgentPayingAmt(bankAcct, currencyId, isPay);
        BigDecimal c2Amount = AmtCalcHelper.getC2_PayingAmt(bankAcct, (Long)currencyId, isPay);
        logger.info("getC_PayingAmt  parameter-->: bankAcct:" + bankAcct.getPkValue() + "  currencyId: " + currencyId + "   isPay:" + isPay + " c1Amount:" + c1Amount + " c1AgentAmount:" + c1AgentAmount + " c2Amount:" + c2Amount);
        return c1Amount.add(c1AgentAmount).add(c2Amount);
    }

    public static BigDecimal getC1_PayingAmt(DynamicObject bankAcct, Object currencyId, boolean isPay) {
        return CasBusinessHelper.getPayBillOnWayAmt((long)((Long)bankAcct.getPkValue()), (long)((Long)currencyId), (boolean)isPay);
    }

    public static BigDecimal getC1_PayingAmt_1(DynamicObject bankAcct, Object currencyId, boolean isPay) {
        return AmtCalcHelper.getPayBillOnWayAmt((Long)bankAcct.getPkValue(), (Long)currencyId, isPay);
    }

    public static BigDecimal getPayBillOnWayAmt(long bankacctId, long currencyId, boolean isPay) {
        QFilter status = new QFilter("billstatus", "=", (Object)BillStatusEnum.BEING.getValue());
        if (!isPay) {
            status.or(new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()));
            status.or(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        }
        QFilter currencyFilter = new QFilter("isdiffcur", "=", (Object)"1").and(new QFilter("dpcurrency", "=", (Object)currencyId)).or(new QFilter("isdiffcur", "=", (Object)"0").and(new QFilter("currency", "=", (Object)currencyId)));
        QFilter draftBillFilter = new QFilter("settletype.settlementtype", "not in", (Object)new String[]{SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.BANK.getValue(), SettleMentTypeEnum.CHECK.getValue()});
        QFilter[] filters = new QFilter[]{new QFilter("payeracctbank", "=", (Object)bankacctId), currencyFilter, status, new QFilter("iswaitsche", "=", (Object)"0"), draftBillFilter};
        DynamicObject[] payBils = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"isdiffcur,dpamt,actpayamt", (QFilter[])filters);
        BigDecimal amount = BigDecimal.ZERO;
        for (DynamicObject payBill : payBils) {
            boolean isdiffcur = payBill.getBoolean("isdiffcur");
            amount = isdiffcur ? amount.add(payBill.getBigDecimal("dpamt")) : amount.add(payBill.getBigDecimal("actpayamt"));
        }
        return amount;
    }

    public static BigDecimal getC1_AgentPayingAmt(DynamicObject bankAcct, Object currencyId, boolean isPay) {
        return CasBusinessHelper.getAgentPayBillOnWayAmt((long)((Long)bankAcct.getPkValue()), (long)((Long)currencyId), (boolean)isPay);
    }

    public static BigDecimal getC2_PayingAmt(DynamicObject bankAcct, long currencyId, boolean isPay) {
        BigDecimal upAmount = Constants.ZERO;
        QFilter status = new QFilter("billstatus", "=", (Object)BillStatusEnum.PAYING.getValue());
        if (!isPay) {
            status.or(new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()));
            status.or(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            status.or(new QFilter("billstatus", "=", (Object)BillStatusEnum.PAYING.getValue()));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(status);
        filters.add(new QFilter("entrys.subacct", "=", bankAcct.getPkValue()));
        filters.add(new QFilter("entrys.state", "=", (Object)FcaTransDetailStatusEnum.NORMAL.getValue()));
        filters.add(new QFilter("entrys.paystatus", "in", (Object)new String[]{FcaTransPayStatusEnum.INIT.getValue(), FcaTransPayStatusEnum.BEIPROC.getValue(), FcaTransPayStatusEnum.PAYPROC.getValue(), FcaTransPayStatusEnum.NOCONFIRM.getValue()}));
        filters.add(new QFilter("currency", "=", (Object)currencyId));
        DataSet payBillSet = QueryServiceHelper.queryDataSet((String)"paymentbill", (String)"fca_transupbill", (String)"entrys.transamt", (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        DataSet ds = payBillSet.groupBy(new String[0]).sum("entrys.transamt").finish();
        if (ds.hasNext()) {
            Row row = ds.next();
            upAmount = row.getBigDecimal("entrys.transamt");
        }
        ds.close();
        BigDecimal downAmount = Constants.ZERO;
        filters = new ArrayList();
        filters.add(status);
        filters.add(new QFilter("accountbank", "=", bankAcct.getPkValue()));
        filters.add(new QFilter("entrys.state", "=", (Object)FcaTransDetailStatusEnum.NORMAL.getValue()));
        filters.add(new QFilter("entrys.paystatus", "in", (Object)new String[]{FcaTransPayStatusEnum.INIT.getValue(), FcaTransPayStatusEnum.BEIPROC.getValue(), FcaTransPayStatusEnum.PAYPROC.getValue(), FcaTransPayStatusEnum.NOCONFIRM.getValue()}));
        filters.add(new QFilter("currency", "=", (Object)currencyId));
        payBillSet = QueryServiceHelper.queryDataSet((String)"paymentbill", (String)"fca_transdownbill", (String)"entrys.transamt", (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        ds = payBillSet.groupBy(new String[0]).sum("entrys.transamt").finish();
        if (ds.hasNext()) {
            Row row = ds.next();
            downAmount = row.getBigDecimal("entrys.transamt");
        }
        ds.close();
        return upAmount.add(downAmount);
    }

    public static BigDecimal getD_MinRemainedAmt(DynamicObject strategy) {
        return strategy == null ? new BigDecimal(0) : strategy.getBigDecimal("miniacctlimit");
    }

    public static DynamicObject getAcctStratg(DynamicObject bankAcct, Long currencyId) {
        if (bankAcct == null) {
            return null;
        }
        DynamicObject stratg = bankAcct.getDynamicObject("strategy");
        if (stratg == null) {
            bankAcct = BusinessDataServiceHelper.loadSingle((Object)bankAcct.getPkValue(), (String)"bd_accountbanks");
            stratg = bankAcct.getDynamicObject("strategy");
        }
        if (stratg == null) {
            return null;
        }
        if ((stratg = BusinessDataServiceHelper.loadSingle((Object)stratg.getPkValue(), (String)"am_strategy")).get("currency") == null) {
            return null;
        }
        Long curCurrencyId = (Long)stratg.getDynamicObject("currency").getPkValue();
        if (curCurrencyId == null) {
            return null;
        }
        if (currencyId.longValue() == curCurrencyId.longValue()) {
            return stratg;
        }
        return null;
    }

    public static BigDecimal getBalanceModelAmount(String entityKey, DynamicObject bankAcct, Long currencyId, Long orgId, Long billId, BigDecimal currentAmount) {
        if (bankAcct == null || currencyId == null || orgId == null) {
            return null;
        }
        BigDecimal balanceAmount = AmtCalcHelper.getBalanceModelAmount(entityKey, bankAcct, currencyId, orgId, billId);
        if (balanceAmount != null) {
            return balanceAmount;
        }
        if (currentAmount == null) {
            String balanceType = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.FCS.getId(), (long)orgId, (String)"balancevalue");
            BalanceModelService balanceModelService = new BalanceModelService();
            BizBalanceModelBean bizBalanceModelBean = balanceModelService.getRunningBalance(balanceType, bankAcct.getLong("id"), currencyId.longValue());
            currentAmount = bizBalanceModelBean.getAmount();
        }
        return currentAmount;
    }

    public static BigDecimal getBalanceModelAmount(String entityKey, DynamicObject bankAcct, Long currencyId, Long orgId, Long billId) {
        if (bankAcct == null || currencyId == null || orgId == null) {
            return null;
        }
        DynamicObject bankStrategy = AmtCalcHelper.getAcctStratg(bankAcct, currencyId);
        if (bankStrategy != null) {
            DynamicObjectCollection entry = bankStrategy.getDynamicObjectCollection("entry");
            Long modelId = null;
            Optional<Long> submitOptional = entry.stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getString("overcheckopprop")) && e.get("e_billstrategy") != null && e.getDynamicObject("e_billstrategy").getDynamicObject("balancemodel") != null && e.getDynamicObject("e_billstrategy").getDynamicObject("bizbill") != null && e.getString("overcheckopprop").contains("submit") && entityKey.equals(e.getDynamicObject("e_billstrategy").getDynamicObject("bizbill").getString("number")) && e.getDynamicObject("e_billstrategy").getBoolean("enable")).map(e -> e.getDynamicObject("e_billstrategy").getDynamicObject("balancemodel").getLong("id")).findFirst();
            if (!submitOptional.isPresent()) {
                Optional<Long> optional = entry.stream().filter(e -> e.get("e_billstrategy") != null && e.getDynamicObject("e_billstrategy").getDynamicObject("balancemodel") != null && e.getDynamicObject("e_billstrategy").getDynamicObject("bizbill") != null && entityKey.equals(e.getDynamicObject("e_billstrategy").getDynamicObject("bizbill").getString("number")) && e.getDynamicObject("e_billstrategy").getBoolean("enable")).map(e -> e.getDynamicObject("e_billstrategy").getDynamicObject("balancemodel").getLong("id")).findFirst();
                if (optional.isPresent()) {
                    modelId = optional.get();
                }
            } else {
                modelId = submitOptional.get();
            }
            if (modelId != null) {
                BalanceModelService balanceModelService = new BalanceModelService();
                return balanceModelService.getBalanceModelAmount(modelId, bankAcct.getLong("id"), currencyId.longValue(), billId);
            }
        }
        return null;
    }

    public static BigDecimal getCurrentAmount(DynamicObject bankAcct, Long currencyId, Long orgId) {
        if (bankAcct == null || currencyId == null || orgId == null) {
            return BigDecimal.ZERO;
        }
        String balanceType = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.FCS.getId(), (long)orgId, (String)"balancevalue");
        BalanceModelService balanceModelService = new BalanceModelService();
        BizBalanceModelBean bizBalanceModelBean = balanceModelService.getRunningBalance(balanceType, bankAcct.getLong("id"), currencyId.longValue());
        return bizBalanceModelBean.getAmount();
    }
}

