/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.transbill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fca.business.validate.transbill.AbsTransBillValidator;

public class TransBillDeleteValidator
extends AbsTransBillValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("matchamount");
        selector.add("entrys.isinneracccashbill");
        selector.add("entrys.iscashbill");
        selector.add("entrys.isifmbill");
        selector.add("billstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List pkIds = Arrays.stream(dataEntity).map(d -> d.getDataEntity().getPkValue()).collect(Collectors.toList());
        String entityType = dataEntity[0].getDataEntity().getDataEntityType().getName();
        String targetBillType = "bei_banktransupbill";
        if ("fca_transdownbill".equals(entityType)) {
            targetBillType = "bei_banktransdownbill";
        }
        DynamicObjectCollection bankBill = QueryServiceHelper.query((String)targetBillType, (String)"id, sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", pkIds), new QFilter("sourcetype", "=", (Object)entityType), new QFilter("isbitback", "<>", (Object)"1")});
        Map<Object, Object> bankMap = bankBill.stream().collect(Collectors.toMap(a -> a.get("sourcebillid"), a -> a.get("id"), (e1, e2) -> e1));
        block0: for (ExtendedDataEntity data : dataEntity) {
            DynamicObjectCollection entries;
            BigDecimal matchAmount;
            DynamicObject obj = data.getDataEntity();
            Object billStatus = obj.get("billstatus");
            if (!"true".equals(this.getOption().getVariableValue("byAutoTrans", "false")) && !BillStatusEnum.SAVE.getValue().equals(billStatus)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u5355\u636e\u624d\u80fd\u5220\u9664\u3002", (String)"TransBillDeleteValidator_0", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            if (bankMap.containsKey(obj.getPkValue())) {
                if ("fca_transdownbill".equals(entityType)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u94f6\u884c\u4e0b\u62e8\u5355\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"TransBillDeleteValidator_5", (String)"tmc-fca-business", (Object[])new Object[0]));
                } else {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u94f6\u884c\u4e0a\u5212\u5355\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"TransBillDeleteValidator_6", (String)"tmc-fca-business", (Object[])new Object[0]));
                }
            }
            if ((matchAmount = obj.getBigDecimal("matchamount")).floatValue() > 0.0f) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u5173\u8054\u4ea4\u6613\u660e\u7ec6\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"TransBillDeleteValidator_1", (String)"tmc-fca-business", (Object[])new Object[0]));
            }
            if ((entries = obj.getDynamicObjectCollection("entrys")) == null || entries.size() <= 0) continue;
            boolean checkFlag = Boolean.FALSE;
            for (DynamicObject entry : entries) {
                if (entry.getBoolean("isinneracccashbill")) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u5185\u90e8\u6237\u56de\u5355\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"TransBillDeleteValidator_2", (String)"tmc-fca-business", (Object[])new Object[0]));
                    checkFlag = Boolean.TRUE;
                }
                if (entry.getBoolean("iscashbill")) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u5b50\u8d26\u6237\u56de\u5355\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"TransBillDeleteValidator_3", (String)"tmc-fca-business", (Object[])new Object[0]));
                    checkFlag = Boolean.TRUE;
                }
                if (entry.getBoolean("isifmbill")) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u5185\u90e8\u91d1\u878d\u5355\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"TransBillDeleteValidator_4", (String)"tmc-fca-business", (Object[])new Object[0]));
                    checkFlag = Boolean.TRUE;
                }
                if (!checkFlag) continue;
                continue block0;
            }
        }
    }
}

