/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.repeat;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.log.PayLogger;
import kd.tmc.fbp.common.log.bean.RepeatCtrlLog;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.RepeatCheckResultEnum;
import kd.tmc.fcs.common.helper.PayAccessHelper;
import kd.tmc.fcs.mservice.repeat.ctrl.CtrlDataBuilder;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PayAccessRepeatCtrlServiceImpl {
    private static Log logger = LogFactory.getLog(PayAccessRepeatCtrlServiceImpl.class);
    private static final PayLogger payLogger = PayLogger.create(PayAccessRepeatCtrlServiceImpl.class);
    private RepeatCtrlLog repeatLog;
    private static final ThreadLocal<List<String>> arrayListThreadLocal = ThreadLocal.withInitial(ArrayList::new);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> checkRepeat(DynamicObject[] destBills, String opKey, boolean isWorkFlow) throws InterruptedException {
        ArrayList<String> objects;
        logger.info("\u8c03\u7528\u9632\u91cd\u63a7\u5236\u5b9e\u73b0\u65b9\u6cd5");
        boolean isAsyncValid = PayAccessHelper.isAsyncValid();
        boolean isBlackList = PayAccessHelper.isInBlackList((String)destBills[0].getDynamicObjectType().getName());
        ArrayList<RepeatCtrlLog> logList = new ArrayList<RepeatCtrlLog>(destBills.length);
        try {
            this.checkRepeatCtrl(destBills, opKey, isWorkFlow, logList);
            logger.info("\u8c03\u7528\u9632\u91cd\u63a7\u5236\u7ed3\u675f");
            boolean bl = isAsyncValid = !isAsyncValid && isBlackList;
            if (isAsyncValid) {
                logger.info("\u8c03\u7528\u9632\u91cd\u63a7\u5236\u5f02\u6b65\u6d88\u606f\u63d0\u793a\u65b9\u6cd5");
                this.showRepeatResult(destBills);
            }
            objects = new ArrayList<String>((Collection)arrayListThreadLocal.get());
        }
        finally {
            if (logList.size() > 0) {
                payLogger.logBatch(logList);
            }
            arrayListThreadLocal.remove();
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRepeatCtrl(DynamicObject[] bills, String opKey, boolean isWorkFlow, List<RepeatCtrlLog> logList) throws InterruptedException {
        Pair pair = PayAccessHelper.getPayAccessRecordByDestBills((DynamicObject[])bills);
        Map payRecordIdList = (Map)pair.getLeft();
        if (payRecordIdList.size() <= 0) {
            return;
        }
        String destEntityNumber = bills[0].getDataEntityType().getName();
        boolean isAsyncValid = PayAccessHelper.isAsyncValid();
        boolean isBlackList = PayAccessHelper.isInBlackList((String)destEntityNumber);
        Map request = MutexServiceHelper.batchRequestWithLostTime((List)((List)pair.getRight()), (String)destEntityNumber, (String)"repeatctrl");
        arrayListThreadLocal.get().addAll(request.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList()));
        logger.info("\u7533\u8bf7\u5230\u5206\u5e03\u5f0f\u9501:" + JSON.toJSONString(arrayListThreadLocal.get()));
        List requestFailIds = request.entrySet().stream().filter(s -> (Boolean)s.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(requestFailIds)) {
            if (isWorkFlow) {
                List requestFailIds2;
                do {
                    logger.info("\u91cd\u8bd5\u9632\u91cd\u83b7\u53d6\u4e0d\u5230\u9501ID\uff1a" + JSON.toJSONString(requestFailIds));
                    if (arrayListThreadLocal.get().size() > 0) {
                        MutexServiceHelper.batchRelease(arrayListThreadLocal.get(), (String)destEntityNumber, (String)"repeatctrl");
                        logger.info("\u91cd\u8bd5\u91ca\u653e\u5206\u5e03\u5f0f\u9501:" + JSON.toJSONString(arrayListThreadLocal.get()));
                    }
                    Thread.sleep(3000L);
                    request = MutexServiceHelper.batchRequestWithLostTime((List)((List)pair.getRight()), (String)destEntityNumber, (String)"repeatctrl");
                    arrayListThreadLocal.get().addAll(request.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList()));
                    logger.info("\u91cd\u8bd5\u7533\u8bf7\u5230\u5206\u5e03\u5f0f\u9501:" + JSON.toJSONString(arrayListThreadLocal.get()));
                } while (!EmptyUtil.isEmpty(requestFailIds2 = request.entrySet().stream().filter(s -> (Boolean)s.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList())));
            } else {
                if (arrayListThreadLocal.get().size() > 0) {
                    MutexServiceHelper.batchRelease(arrayListThreadLocal.get(), (String)destEntityNumber, (String)"repeatctrl");
                    logger.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501:" + JSON.toJSONString(arrayListThreadLocal.get()));
                }
                String failIds = JSON.toJSONString(requestFailIds);
                logger.info("\u9632\u91cd\u83b7\u53d6\u4e0d\u5230\u9501ID\uff1a" + failIds);
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u9632\u91cd\u4e92\u65a5\u9501\uff0c\u8bf7\u7a0d\u540e\u5904\u7406\uff0c\u9501ID\uff1a%s", (String)"PayAccessRepeatCtrlServiceImpl_1", (String)"tmc-fcs-mservice", (Object[])new Object[]{failIds}));
            }
        }
        for (DynamicObject bill : bills) {
            long time = System.nanoTime();
            try {
                this.repeatLog = this.createRepeatLog(bill);
                List payRecordList = (List)payRecordIdList.get(bill.getLong("id"));
                if (payRecordList != null && payRecordList.size() > 0) {
                    String srcEntityNumber = ((DynamicObject)payRecordList.get(0)).getString("srcentity");
                    QFilter qFilter = new QFilter("ctrlentity", "=", (Object)destEntityNumber);
                    boolean isCustom = "custom".equals(((DynamicObject)payRecordList.get(0)).getString("newway"));
                    if (isCustom) {
                        qFilter.and("customsign", "=", (Object)srcEntityNumber);
                    } else {
                        qFilter.and("srcentity", "=", (Object)srcEntityNumber);
                    }
                    qFilter.and("enable", "=", (Object)"1");
                    DynamicObject repeatSet = TmcDataServiceHelper.loadSingleFromCache((String)"fcs_checkctrl", (QFilter[])new QFilter[]{qFilter});
                    if (!EmptyUtil.isNoEmpty((DynamicObject)repeatSet)) continue;
                    logger.info("\u67e5\u5230\u9632\u91cd\u8bbe\u7f6e\uff1a" + repeatSet.getString("number"));
                    String srcBillPkId = ((DynamicObject)payRecordList.get(0)).getString("srcbillpkid");
                    this.setRepeatSetLog(this.repeatLog, repeatSet, srcEntityNumber, destEntityNumber, srcBillPkId, bill.getLong("id"));
                    Set opRepeatSet = Arrays.stream(repeatSet.getString("repeatop").replaceFirst(",", "").split(",")).collect(Collectors.toSet());
                    Set opCtrlSet = Arrays.stream(repeatSet.getString("ctrlamtop").replaceFirst(",", "").split(",")).collect(Collectors.toSet());
                    List<Object> repeatPayRecrods = new ArrayList();
                    if (repeatSet.getBoolean("isrepeat") && opRepeatSet.contains(opKey)) {
                        logger.info("\u8c03\u7528\u91cd\u63a8\u6821\u9a8c\u903b\u8f91");
                        boolean isRepeatByRecord = repeatSet.getBoolean("isbyrecord");
                        QFilter filter = this.getCtrlEntityFilter(repeatSet);
                        repeatPayRecrods = !isRepeatByRecord ? this.checkRepeatCtrlBySingleField(bill, payRecordList, repeatSet, filter) : this.checkRepeatCtrlByPayRecord(bill, payRecordList, repeatSet, filter);
                    }
                    Boolean isMatchCtrlRule = Boolean.TRUE;
                    if (repeatSet.getBoolean("isctrlamt") && opCtrlSet.contains(opKey)) {
                        logger.info("\u8c03\u7528\u8d85\u989d\u6821\u9a8c\u903b\u8f91");
                        boolean isLoad = repeatSet.getBoolean("isload");
                        if (isLoad) {
                            isMatchCtrlRule = new CtrlDataBuilder(bill, repeatSet).isMatchCtrlRule();
                        }
                    }
                    if (isAsyncValid) {
                        List<Long> recordId = payRecordList.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
                        this.updateRecordSuccess(recordId);
                    }
                    String message = "";
                    Set<Long> repeatRecordIds = new HashSet<Long>();
                    Set<Long> ctrlAmtRecordIds = new HashSet<Long>();
                    if (EmptyUtil.isNoEmpty(repeatPayRecrods)) {
                        message = repeatSet.getString("repeatmessage");
                        this.repeatLog.setCheckresult(RepeatCheckResultEnum.REPEAT.getValue());
                        repeatRecordIds = repeatPayRecrods.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
                    }
                    if (!isMatchCtrlRule.booleanValue()) {
                        message = message + (EmptyUtil.isNoEmpty((String)message) ? "\uff1b" : "") + repeatSet.getString("ctrlmessage");
                        this.repeatLog.setCheckresult(RepeatCheckResultEnum.EXCESS.getValue());
                        ctrlAmtRecordIds = payRecordList.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
                    }
                    if (!EmptyUtil.isNoEmpty(repeatRecordIds) && !EmptyUtil.isNoEmpty(ctrlAmtRecordIds)) continue;
                    if (isAsyncValid) {
                        HashSet<Long> finalRepeatRecordIds = repeatRecordIds;
                        HashSet<Long> finalCtrlAmtRecordIds = ctrlAmtRecordIds;
                        String finalMessage = message;
                        ThreadPools.executeOnceIncludeRequestContext((String)"saveException", () -> this.saveException(finalRepeatRecordIds, finalCtrlAmtRecordIds, finalMessage));
                        throw new KDBizException(TmcErrorCode.COMMON, new Object[]{message});
                    }
                    if (isBlackList) {
                        this.saveException(repeatRecordIds, ctrlAmtRecordIds, message);
                        continue;
                    }
                    HashSet<Long> finalRepeatRecordIds1 = repeatRecordIds;
                    HashSet<Long> finalCtrlAmtRecordIds1 = ctrlAmtRecordIds;
                    String finalMessage1 = message;
                    ThreadPools.executeOnceIncludeRequestContext((String)"saveException", () -> this.saveException(finalRepeatRecordIds1, finalCtrlAmtRecordIds1, finalMessage1));
                    continue;
                }
                String message = ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u5230\u94fe\u8def\u4fe1\u606f\u3002", (String)"PayAccessRepeatCtrlServiceImpl_0", (String)"tmc-fcs-mservice", (Object[])new Object[0]);
                logger.info(message);
            }
            catch (Exception e) {
                String exceptionStr = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                this.repeatLog.setException(exceptionStr);
                if (!(e instanceof KDBizException)) continue;
                if (arrayListThreadLocal.get().size() > 0) {
                    MutexServiceHelper.batchRelease(arrayListThreadLocal.get(), (String)destEntityNumber, (String)"repeatctrl");
                    logger.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501:" + JSON.toJSONString(arrayListThreadLocal.get()));
                }
                throw e;
            }
            finally {
                long costMs = (System.nanoTime() - time) / 1000L / 1000L;
                this.repeatLog.setCostTime(Long.valueOf(costMs));
                if (EmptyUtil.isNoEmpty((Long)this.repeatLog.getRepeatset())) {
                    logList.add(this.repeatLog);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRecordSuccess(List<Long> recordId) {
        try (MessagePublisher pub = null;){
            pub = MQFactory.get().createSimplePublisher("tmc", "fcs.checkrepeat");
            HashMap<String, String> msgParamMap = new HashMap<String, String>();
            msgParamMap.put("type", "update_payaccess_record");
            msgParamMap.put("data", SerializationUtils.toJsonString(recordId));
            pub.publish(msgParamMap);
        }
    }

    private RepeatCtrlLog createRepeatLog(DynamicObject destBill) {
        RepeatCtrlLog ctrlLog = new RepeatCtrlLog();
        ctrlLog.setDestBillId(Long.valueOf(destBill.getLong("id")));
        ctrlLog.setLogType("repeatctrl");
        ctrlLog.setTime(System.currentTimeMillis());
        ctrlLog.setTraceId(String.valueOf(RequestContext.get().getTraceId()));
        return ctrlLog;
    }

    private void setRepeatSetLog(RepeatCtrlLog ctrlLog, DynamicObject repeatSet, String srcEntityNumber, String destEntityNumber, Object srcBillPkId, Long destBillPkId) {
        if (ctrlLog.getDestBillId().compareTo(destBillPkId) == 0) {
            ctrlLog.setRepeatset(Long.valueOf(repeatSet.getLong("id")));
            ctrlLog.setSourceBillType(srcEntityNumber);
            ctrlLog.setDestBillType(destEntityNumber);
            if (EmptyUtil.isNoEmpty((Object)srcBillPkId)) {
                ctrlLog.setSourceBillId(srcBillPkId.toString());
            }
        }
    }

    private QFilter getFilterByDataType(String srcSingleField, Set<Object> srcId, String dataType) {
        QFilter filter = "String".equals(dataType) ? new QFilter(srcSingleField, "in", srcId.stream().map(Object::toString).collect(Collectors.toList())) : new QFilter(srcSingleField, "in", srcId.stream().map(s -> Long.parseLong(s.toString())).collect(Collectors.toList()));
        return filter;
    }

    private QFilter getCtrlEntityFilter(DynamicObject repeatSet) {
        String filter_tag = repeatSet.getString("filter_tag");
        FilterCondition filter = (FilterCondition)SerializationUtils.fromJsonString((String)filter_tag, FilterCondition.class);
        String ctrlentity = repeatSet.getDynamicObject("ctrlentity").getString("number");
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)ctrlentity);
        FilterBuilder fb = new FilterBuilder(dataType, filter, true);
        fb.buildFilter(true);
        return fb.getQFilter();
    }

    private List<DynamicObject> checkRepeatCtrlBySingleField(DynamicObject bill, List<DynamicObject> payRecordList, DynamicObject repeatSet, QFilter filter) {
        logger.info("\u76ee\u6807\u5355\u6709\u5b58\u6e90\u5355\u552f\u4e00\u503c\u5b57\u6bb5\u6821\u9a8c\u903b\u8f91");
        String srcBillIdField = repeatSet.getString("srcbillidfield");
        String ctrlEntity = repeatSet.getDynamicObject("ctrlentity").getString("number");
        MainEntityType MainType = EntityMetadataCache.getDataEntityType((String)ctrlEntity);
        String dataType = ((IDataEntityProperty)MainType.getAllFields().get(srcBillIdField)).getPropertyType().getSimpleName();
        IDataEntityProperty property = MainType.findProperty(srcBillIdField);
        if (!(property.getParent() instanceof EntryType)) {
            Long billId = bill.getLong("id");
            HashSet<Object> srcBillId = new HashSet<Object>(4);
            srcBillId.add(bill.get(srcBillIdField));
            QFilter qFilter = filter != null ? filter : QFilter.of((String)"1 = 1", (Object[])new Object[0]);
            qFilter.and(this.getFilterByDataType(srcBillIdField, srcBillId, dataType));
            DynamicObjectCollection bills = QueryServiceHelper.query((String)ctrlEntity, (String)(srcBillIdField + ",id"), (QFilter[])qFilter.toArray());
            logger.info("\u67e5\u8be2\u5230\u7684\u5355\u636e\uff1a" + SerializationUtils.toJsonString((Object)bills));
            boolean isRepeat = bills.stream().anyMatch(v -> !billId.equals(v.getLong("id")) && !"0".equals(v.getString(srcBillIdField)) && EmptyUtil.isNoEmpty((String)v.getString(srcBillIdField)));
            logger.info("\u662f\u5426\u91cd\u590d\uff1a" + isRepeat);
            if (isRepeat) {
                return payRecordList;
            }
        } else {
            String entryName = property.getParent().getName();
            String destEntryId = entryName + ".id";
            String srcEntryIdField = entryName + "." + srcBillIdField;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryName);
            Map<Long, Object> entryMap = entrys.stream().collect(Collectors.toMap(r -> r.getLong("id"), r -> r.get(srcBillIdField)));
            HashSet<Object> srcBillIds = new HashSet<Object>(entryMap.values());
            QFilter qFilter = filter != null ? filter : QFilter.of((String)"1 = 1", (Object[])new Object[0]);
            qFilter.and(this.getFilterByDataType(srcEntryIdField, srcBillIds, dataType));
            DynamicObjectCollection bills = QueryServiceHelper.query((String)ctrlEntity, (String)(destEntryId + "," + srcEntryIdField), (QFilter[])qFilter.toArray());
            logger.info("\u67e5\u8be2\u5230\u7684\u5355\u636e\uff1a" + SerializationUtils.toJsonString((Object)bills));
            List findData = bills.stream().filter(v -> !entryMap.containsKey(v.getLong(destEntryId)) && !"0".equals(v.getString(srcEntryIdField)) && EmptyUtil.isNoEmpty((String)v.getString(srcEntryIdField))).collect(Collectors.toList());
            boolean isRepeat = findData.size() > 0;
            logger.info("\u662f\u5426\u91cd\u590d\uff1a" + isRepeat);
            if (isRepeat) {
                List<DynamicObject> repeatPayRecrods = payRecordList.stream().filter(r -> entryMap.containsKey(r.getLong("destbillid"))).collect(Collectors.toList());
                if (repeatPayRecrods.size() > 0) {
                    return repeatPayRecrods;
                }
                return payRecordList;
            }
        }
        return new ArrayList<DynamicObject>(10);
    }

    private List<DynamicObject> checkRepeatCtrlByPayRecord(DynamicObject destBill, List<DynamicObject> payRecordList, DynamicObject repeatSet, QFilter filter) {
        logger.info("\u901a\u8fc7\u652f\u4ed8\u94fe\u8def\u5224\u91cd\u903b\u8f91");
        DynamicObject payRecord1 = payRecordList.get(0);
        String destIdProp = payRecord1.getString("destidprop");
        String ctrlEntity = repeatSet.getDynamicObject("ctrlentity").getString("number");
        ArrayList<DynamicObject> repeatPayRecrods = new ArrayList<DynamicObject>();
        if ("head".equals(destIdProp)) {
            Long thisBillId = payRecord1.getLong("destbillid");
            String srcBillId = payRecord1.getString("srcbillid");
            Map payRecordsBySrcBillId = TmcDataServiceHelper.loadFromCache((String)"fcs_payaccess_record", (String)"id,destbillid", (QFilter[])new QFilter[]{new QFilter("srcbillid", "=", (Object)srcBillId)});
            ArrayList destIdList = new ArrayList();
            payRecordsBySrcBillId.forEach((key, record) -> {
                Long id = record.getLong("destbillid");
                if (!id.equals(thisBillId)) {
                    destIdList.add(id);
                }
            });
            if (EmptyUtil.isEmpty(destIdList)) {
                return repeatPayRecrods;
            }
            QFilter qFilter = new QFilter("id", "in", destIdList);
            if (EmptyUtil.isNoEmpty((Object)filter)) {
                qFilter.and(filter);
            }
            boolean isRepeat = TmcDataServiceHelper.exists((String)ctrlEntity, (QFilter[])qFilter.toArray());
            logger.info("\u662f\u5426\u91cd\u590d\uff1a" + isRepeat);
            if (isRepeat) {
                repeatPayRecrods.add(payRecord1);
            }
        } else if ("entry".equals(destIdProp)) {
            String destEntryId = payRecord1.getString("destentryprop") + ".id";
            for (DynamicObject payRecord : payRecordList) {
                Long thisEntryId = payRecord.getLong("destbillid");
                String srcBillId = payRecord.getString("srcbillid");
                Map payRecordsBySrcBillId = TmcDataServiceHelper.loadFromCache((String)"fcs_payaccess_record", (String)"id,destbillid", (QFilter[])new QFilter[]{new QFilter("srcbillid", "=", (Object)srcBillId)});
                ArrayList destIdList = new ArrayList();
                payRecordsBySrcBillId.forEach((key, record) -> {
                    Long id = record.getLong("destbillid");
                    if (!id.equals(thisEntryId)) {
                        destIdList.add(id);
                    }
                });
                if (EmptyUtil.isEmpty(destIdList)) continue;
                QFilter qFilter = new QFilter(destEntryId, "in", destIdList);
                if (EmptyUtil.isNoEmpty((Object)filter)) {
                    qFilter.and(filter);
                }
                boolean isRepeat = TmcDataServiceHelper.exists((String)ctrlEntity, (QFilter[])qFilter.toArray());
                logger.info("\u662f\u5426\u91cd\u590d\uff1a" + isRepeat);
                if (!isRepeat) continue;
                repeatPayRecrods.add(payRecord);
            }
        }
        return repeatPayRecrods;
    }

    private void saveException(Set<Long> repeatRecordIds, Set<Long> ctrlAmtRecordIds, String message) {
        DynamicObject[] payRecrods;
        HashSet<Long> ids = new HashSet<Long>();
        ids.addAll(repeatRecordIds);
        ids.addAll(ctrlAmtRecordIds);
        for (DynamicObject one : payRecrods = TmcDataServiceHelper.load((String)"fcs_payaccess_record", (String)"isrepeatresult,isexcessresult,errormessage,success", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
            String initMessage;
            if (repeatRecordIds.contains(one.getLong("id"))) {
                one.set("isrepeatresult", (Object)"1");
            }
            if (ctrlAmtRecordIds.contains(one.getLong("id"))) {
                one.set("isexcessresult", (Object)"1");
            }
            if (EmptyUtil.isEmpty((String)(initMessage = one.getString("errormessage")))) {
                one.set("errormessage", (Object)message);
                continue;
            }
            String errormessage = message + "; " + initMessage;
            one.set("errormessage", (Object)errormessage.substring(0, Math.min(255, errormessage.length())));
        }
        SaveServiceHelper.save((DynamicObject[])payRecrods);
    }

    private void showRepeatResult(DynamicObject[] destBill) {
        Set ids = Arrays.stream(destBill).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        QFilter filter = new QFilter("destbillpkid", "in", ids);
        Map records = TmcDataServiceHelper.loadFromCache((String)"fcs_payaccess_record", (String)"fulllinkid,errormessage", (QFilter[])filter.toArray());
        Set fullLinkIds = records.values().stream().map(v -> v.getString("fulllinkid")).collect(Collectors.toSet());
        List<Long> fullLinkLongIds = Arrays.asList((Long[])ConvertUtils.convert((String[])String.join((CharSequence)",", fullLinkIds).split(","), Long.class));
        filter = new QFilter("destbillid", "in", fullLinkLongIds);
        QFilter filterR = new QFilter("isrepeatresult", "=", (Object)true);
        filterR = filterR.or(new QFilter("isexcessresult", "=", (Object)true));
        filter.and(filterR);
        Map fullLinkRecords = TmcDataServiceHelper.loadFromCache((String)"fcs_payaccess_record", (String)"id,fulllinkid,errormessage,success", (QFilter[])filter.toArray());
        if (fullLinkRecords.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (DynamicObject record : fullLinkRecords.values()) {
                String message = record.getString("errormessage");
                if (builder.length() > 0) {
                    builder.append("/n").append(message);
                    continue;
                }
                builder.append(message);
            }
            List<Long> recordList = fullLinkRecords.values().stream().map(s -> s.getLong("id")).collect(Collectors.toList());
            this.updateRecordSuccess(recordList);
            if (arrayListThreadLocal.get() != null && arrayListThreadLocal.get().size() > 0) {
                String destEntityNumber = destBill[0].getDataEntityType().getName();
                MutexServiceHelper.batchRelease(arrayListThreadLocal.get(), (String)destEntityNumber, (String)"repeatctrl");
                logger.info("\u5f02\u6b65\u91ca\u653e\u5206\u5e03\u5f0f\u9501:" + JSON.toJSONString(arrayListThreadLocal.get()));
            }
            throw new KDBizException(TmcErrorCode.COMMON, new Object[]{builder.toString()});
        }
    }
}

