/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.suspect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.log.PayLogger;
import kd.tmc.fbp.common.log.bean.SuspectRepeatDetail;
import kd.tmc.fbp.common.log.bean.SuspectRepeatLog;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.helper.ConditionFactory;
import kd.tmc.fcs.mservice.repeat.PayAccessRepeatCtrlServiceImpl;
import org.apache.commons.lang3.tuple.Pair;

public class SuspectRepeatServiceImpl {
    private static final Log logger = LogFactory.getLog(SuspectRepeatServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspectRepeatGen(String targetEntity, List<Long> billIds, String operationKey, String checkEntityParam) {
        block22: {
            ArrayList<SuspectRepeatLog> logList = new ArrayList<SuspectRepeatLog>(16);
            logger.info("\u5f53\u524d\u7591\u4f3c\u91cd\u590d\u751f\u6210\u64cd\u4f5c\uff1a" + operationKey);
            try {
                Map suspectSets;
                ArrayList<DynamicObject> suspectList = new ArrayList<DynamicObject>(16);
                QFilter qFilter = new QFilter("destentity.number", "=", (Object)targetEntity);
                qFilter.and("enable", "=", (Object)"1");
                if (EmptyUtil.isNoEmpty((String)checkEntityParam)) {
                    qFilter.and("checkentity.number", "=", (Object)checkEntityParam);
                }
                if ((suspectSets = TmcDataServiceHelper.loadFromCache((String)"fcs_suspectset", (String)"number,checkop,checksignfield,messagefield,failmessage,ctrltype,checkentity,matchentity,matchentity.matchrecord_tag,matchentity.destfilterrecord_tag,matchentity.checkfilterrecord_tag", (QFilter[])qFilter.toArray())).isEmpty()) break block22;
                SuspectRepeatLog log = null;
                try {
                    Set<Long> recordInfoIds = this.getRecordInfo(billIds);
                    for (DynamicObject suspectSet : suspectSets.values()) {
                        Set checkOP = Arrays.stream(suspectSet.getString("checkop").replaceFirst(",", "").split(",")).collect(Collectors.toSet());
                        if (operationKey != null && !checkOP.contains(operationKey)) continue;
                        this.deleteSupectData(billIds, suspectSet.getPkValue());
                        log = this.createRepeatLog(suspectSet);
                        long time = System.nanoTime();
                        logger.info("\u7591\u4f3c\u9632\u91cd\u8bbe\u7f6e\uff1a" + suspectSet.getString("number"));
                        DynamicObject checkEntity = suspectSet.getDynamicObject("checkentity");
                        String checkEntityNumber = checkEntity.getString("number");
                        DynamicObjectCollection matchLists = suspectSet.getDynamicObjectCollection("matchentity");
                        for (DynamicObject matchRule : matchLists) {
                            this.dealOneMatchRule(suspectSet, targetEntity, checkEntityNumber, matchRule, billIds, recordInfoIds, log, suspectList);
                        }
                        this.setSuspectRepeatLogCostTime(log, time);
                        logList.add(log);
                    }
                    logger.info("\u5224\u65adsuspectList\u662f\u5426\u4e3a\u7a7a\uff1a\u5f00\u59cb");
                    if (EmptyUtil.isNoEmpty(suspectList)) {
                        try (TXHandle ignored = TX.requiresNew();){
                            SaveServiceHelper.save((DynamicObject[])suspectList.toArray(new DynamicObject[0]));
                        }
                    }
                    logger.info("\u5224\u65adsuspectList\u662f\u5426\u4e3a\u7a7a\uff1a\u7ed3\u675f");
                }
                catch (Exception e) {
                    String exceptionStr = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    if (log != null) {
                        log.setException(exceptionStr);
                        logList.add(log);
                    }
                }
            }
            finally {
                PayLogger Logger2 = PayLogger.create(PayAccessRepeatCtrlServiceImpl.class);
                Logger2.logBatch(logList);
            }
        }
    }

    protected void dealOneMatchRule(DynamicObject suspectSet, String targetEntityNumber, String checkEntityNumber, DynamicObject matchRule, List<Long> billIds, Set<Long> hasComfirmBillIds, SuspectRepeatLog log, List<DynamicObject> suspectList) {
        String targetFilterRecord = matchRule.getString("destfilterrecord_tag");
        Set<Long> fitTargetIds = this.getFitBillIds(targetFilterRecord, targetEntityNumber, billIds);
        if (EmptyUtil.isNoEmpty(fitTargetIds)) {
            if (fitTargetIds.size() == 1) {
                this.oneDataCheck(fitTargetIds, matchRule, suspectSet, targetEntityNumber, checkEntityNumber, hasComfirmBillIds, log, suspectList);
            } else {
                this.manyDataCheck(fitTargetIds, matchRule, suspectSet, targetEntityNumber, checkEntityNumber, hasComfirmBillIds, log, suspectList);
            }
        }
    }

    private void oneDataCheck(Set<Long> fitTargetIds, DynamicObject matchRule, DynamicObject suspectSet, String targetEntityNumber, String checkEntityNumber, Set<Long> hasComfirmBillIds, SuspectRepeatLog log, List<DynamicObject> suspectList) {
        Long fitTargetId = (Long)fitTargetIds.toArray()[0];
        String record = matchRule.getString("matchrecord_tag");
        List recordLists = SerializationUtils.fromJsonStringToList((String)record, Map.class);
        List<String> targetQueryList = recordLists.stream().map(s -> (String)s.get("destkey")).collect(Collectors.toList());
        DataSet targetDataSet = this.queryTargetDataSet(fitTargetIds, targetEntityNumber, targetQueryList);
        if (targetDataSet == null || targetDataSet.copy().isEmpty()) {
            return;
        }
        List<String> checkQueryList = recordLists.stream().map(s -> (String)s.get("checkkey")).collect(Collectors.toList());
        String checkFilterRecord = matchRule.getString("checkfilterrecord_tag");
        Map<String, Object> checkMap = this.getQfilterByEntity(checkFilterRecord, checkEntityNumber);
        String datefield = (String)checkMap.get("datefield");
        DataSet repeatDataSet = this.queryRepeatDataSet(matchRule, checkMap, checkEntityNumber, checkQueryList, targetEntityNumber, targetDataSet, targetQueryList, fitTargetId);
        long beginTime = System.currentTimeMillis();
        logger.info("\u5355\u7b14\u5224\u65ad\u662f\u5426\u4e3a\u7a7a\u524d\u65f6\u95f4\uff1a" + beginTime);
        if (repeatDataSet != null && repeatDataSet.hasNext()) {
            String targetBillno = ((Row)targetDataSet.iterator().next()).getString("targetBillno");
            repeatDataSet = repeatDataSet.addFields(new String[]{String.valueOf(fitTargetId), "'" + targetBillno + "'"}, new String[]{"targetId", "targetBillno"});
            logger.info("\u5355\u7b14\u5224\u65ad\u662f\u5426\u4e3a\u7a7a\u540e\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - beginTime));
            HashSet<Long> writeBackId = new HashSet<Long>(16);
            beginTime = System.currentTimeMillis();
            logger.info("\u5355\u7b14repeat\u4fdd\u5b58\u5f00\u59cb\uff1a" + beginTime);
            this.recordRepeatDataSet(writeBackId, hasComfirmBillIds, suspectList, recordLists, repeatDataSet, log, suspectSet, targetEntityNumber, checkEntityNumber, datefield, "checkkey");
            logger.info("\u5355\u7b14repeat\u4fdd\u5b58\u7ed3\u675f" + (System.currentTimeMillis() - beginTime));
            this.writeBackTargetBillMessage(suspectSet, writeBackId, targetEntityNumber, "0");
        }
        logger.info("endTime\uff1a" + (System.currentTimeMillis() - beginTime));
    }

    private DataSet queryRepeatDataSet(DynamicObject matchList, Map<String, Object> checkMap, String checkEntityNumber, List<String> checkQueryList, String targetEntityNumber, DataSet targetDataSet, List<String> targetQueryList, Long fitTargetId) {
        String checkFilterRecord = matchList.getString("checkfilterrecord_tag");
        QFilter checkFilter = (QFilter)checkMap.get("qfilter");
        ArrayList<String> queryList = new ArrayList<String>(checkQueryList.size());
        queryList.addAll(checkQueryList);
        String datefield = (String)checkMap.get("datefield");
        if (datefield != null && !checkQueryList.contains(datefield)) {
            queryList.add(datefield);
        }
        logger.info("checkFilter\u4e1a\u52a1\u5355\u67e5\u8be2\u6761\u4ef6\u5904\u7406\u524d\uff1a" + checkFilter);
        if (targetEntityNumber.equals(checkEntityNumber)) {
            checkFilter.and("id", "!=", (Object)fitTargetId);
        }
        HashMap<String, QFilter> record = new HashMap<String, QFilter>(16);
        for (Row row : targetDataSet.copy()) {
            QFilter tempFilter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
            for (int i = 0; i < targetQueryList.size(); ++i) {
                Object o = row.get(targetQueryList.get(i));
                tempFilter.and(checkQueryList.get(i), "=", o);
            }
            record.put("record", record.getOrDefault("record", null) == null ? tempFilter : ((QFilter)record.get("record")).or(tempFilter));
        }
        checkFilter.and((QFilter)record.get("record"));
        logger.info("checkFilter\u4e1a\u52a1\u5355\u67e5\u8be2\u6761\u4ef6\u5904\u7406\u540e\uff1a" + checkFilter);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)checkEntityNumber);
        String queryFiled = ",id as checkId,billno as checkBillno,creator as checkCreator";
        if (mainType instanceof BasedataEntityType) {
            queryFiled = ",id as checkId,id as checkBillno,creator as checkCreator";
        }
        DataSet checkDataSet = QueryServiceHelper.queryDataSet((String)"checkDataSet", (String)checkEntityNumber, (String)(TmcBusinessBaseHelper.listToString(queryList) + queryFiled), (QFilter[])checkFilter.toArray(), null);
        if (!"".equals(checkMap.get("expression"))) {
            logger.info("\u9ad8\u7ea7\u8fc7\u6ee4\uff1a" + checkMap.get("expression"));
            ArrayList<Long> checkIdLists = new ArrayList<Long>(16);
            for (Row rows : checkDataSet.copy()) {
                checkIdLists.add(rows.getLong("checkId"));
            }
            Set<Long> fitCheckIds = this.getFitBillIds(checkFilterRecord, checkEntityNumber, checkIdLists);
            if (EmptyUtil.isEmpty(fitCheckIds)) {
                return null;
            }
            checkDataSet.filter("id in (" + TmcBusinessBaseHelper.idListToString(new ArrayList<Long>(fitCheckIds)) + ")");
        }
        return checkDataSet;
    }

    private void manyDataCheck(Set<Long> fitTargetIds, DynamicObject matchRule, DynamicObject suspectSet, String targetEntityNumber, String checkEntityNumber, Set<Long> hasComfirmBillIds, SuspectRepeatLog log, List<DynamicObject> suspectList) {
        String record = matchRule.getString("matchrecord_tag");
        List recordLists = SerializationUtils.fromJsonStringToList((String)record, Map.class);
        List<String> targetQueryList = recordLists.stream().map(s -> (String)s.get("destkey")).collect(Collectors.toList());
        DataSet targetDataSet = this.queryTargetDataSet(fitTargetIds, targetEntityNumber, targetQueryList);
        if (targetDataSet == null || targetDataSet.copy().isEmpty()) {
            return;
        }
        List<String> checkQueryList = recordLists.stream().map(s -> (String)s.get("checkkey")).collect(Collectors.toList());
        String checkFilterRecord = matchRule.getString("checkfilterrecord_tag");
        Map<String, Object> checkMap = this.getQfilterByEntity(checkFilterRecord, checkEntityNumber);
        String datefield = (String)checkMap.get("datefield");
        DataSet checkDataSet = this.queryCheckDataSet(matchRule, checkMap, checkEntityNumber, checkQueryList);
        if (checkDataSet != null && checkDataSet.hasNext()) {
            long beginTime = System.currentTimeMillis();
            logger.info("Join\u524d\u65f6\u95f4\uff1a" + beginTime);
            DataSet repeatDataSet = this.dealJoinDataSet(targetDataSet, checkDataSet, targetQueryList, checkQueryList, datefield);
            logger.info("Join\u540e\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - beginTime));
            if (targetEntityNumber.equals(checkEntityNumber)) {
                repeatDataSet = repeatDataSet.filter("targetId != checkId");
            }
            beginTime = System.currentTimeMillis();
            logger.info("\u5224\u65ad\u662f\u5426\u4e3a\u7a7a\u524d\u65f6\u95f4\uff1a" + beginTime);
            if (repeatDataSet != null && repeatDataSet.hasNext()) {
                logger.info("\u5224\u65ad\u662f\u5426\u4e3a\u7a7a\u540e\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - beginTime));
                HashSet<Long> writeBackId = new HashSet<Long>(16);
                beginTime = System.currentTimeMillis();
                logger.info("repeat\u4fdd\u5b58\u5f00\u59cb\uff1a" + beginTime);
                this.recordRepeatDataSet(writeBackId, hasComfirmBillIds, suspectList, recordLists, repeatDataSet, log, suspectSet, targetEntityNumber, checkEntityNumber, datefield, "destkey");
                logger.info("repeat\u4fdd\u5b58\u7ed3\u675f" + (System.currentTimeMillis() - beginTime));
                this.writeBackTargetBillMessage(suspectSet, writeBackId, targetEntityNumber, "0");
            }
            logger.info("endTime\uff1a" + (System.currentTimeMillis() - beginTime));
        }
    }

    private void deleteSupectData(List<Long> billIds, Object pkValue) {
        QFilter repeatFilter = new QFilter("billid", "in", billIds);
        repeatFilter.and("suspectset", "=", pkValue);
        DeleteServiceHelper.delete((String)"fcs_suspectbill", (QFilter[])repeatFilter.toArray());
    }

    private DataSet queryTargetDataSet(Set<Long> fitTargetIds, String targetEntity, List<String> targetQueryList) {
        QFilter targetFilter = new QFilter("id", "in", fitTargetIds);
        logger.info("targetFilter\u76ee\u6807\u5355\u67e5\u8be2\u6761\u4ef6\uff1a" + targetFilter);
        return QueryServiceHelper.queryDataSet((String)"targetDataSet", (String)targetEntity, (String)(TmcBusinessBaseHelper.listToString(targetQueryList) + ",id as targetId,billno as targetBillno,creator as checkCreator"), (QFilter[])targetFilter.toArray(), null);
    }

    private DataSet queryCheckDataSet(DynamicObject matchList, Map<String, Object> checkMap, String checkEntityNumber, List<String> checkQueryList) {
        String checkFilterRecord = matchList.getString("checkfilterrecord_tag");
        QFilter checkFilter = (QFilter)checkMap.get("qfilter");
        ArrayList<String> queryList = new ArrayList<String>(checkQueryList.size());
        queryList.addAll(checkQueryList);
        String datefield = (String)checkMap.get("datefield");
        if (datefield != null && !checkQueryList.contains(datefield)) {
            queryList.add(datefield);
        }
        logger.info("checkFilter\u4e1a\u52a1\u5355\u67e5\u8be2\u6761\u4ef6\uff1a" + checkFilter);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)checkEntityNumber);
        String queryFiled = ",id as checkId,billno as checkBillno";
        if (mainType instanceof BasedataEntityType) {
            queryFiled = ",id as checkId,id as checkBillno";
        }
        DataSet checkDataSet = QueryServiceHelper.queryDataSet((String)"checkDataSet", (String)checkEntityNumber, (String)(TmcBusinessBaseHelper.listToString(queryList) + queryFiled), (QFilter[])checkFilter.toArray(), null);
        if (!"".equals(checkMap.get("expression"))) {
            logger.info("\u9ad8\u7ea7\u8fc7\u6ee4\uff1a" + checkMap.get("expression"));
            ArrayList<Long> checkIdLists = new ArrayList<Long>(16);
            for (Row rows : checkDataSet.copy()) {
                checkIdLists.add(rows.getLong("checkId"));
            }
            Set<Long> fitCheckIds = this.getFitBillIds(checkFilterRecord, checkEntityNumber, checkIdLists);
            if (EmptyUtil.isEmpty(fitCheckIds)) {
                return null;
            }
            checkDataSet.filter("id in (" + TmcBusinessBaseHelper.idListToString(new ArrayList<Long>(fitCheckIds)) + ")");
        }
        return checkDataSet;
    }

    private DataSet dealJoinDataSet(DataSet targetDataSet, DataSet checkDataSet, List<String> targetQueryList, List<String> checkQueryList, String datefield) {
        JoinDataSet joinDataSet = targetDataSet.join(checkDataSet);
        for (int i = 0; i < targetQueryList.size(); ++i) {
            logger.info(targetQueryList.get(i) + "============" + checkQueryList.get(i));
            joinDataSet.on(targetQueryList.get(i), checkQueryList.get(i));
        }
        ArrayList<String> selectTargetList = new ArrayList<String>(16);
        selectTargetList.addAll(targetQueryList);
        selectTargetList.add("targetId");
        selectTargetList.add("targetBillno");
        selectTargetList.add("checkCreator");
        ArrayList<String> selectCheckList = new ArrayList<String>(16);
        selectCheckList.add("checkId");
        selectCheckList.add("checkBillno");
        if (datefield != null) {
            selectCheckList.add(datefield);
        }
        return joinDataSet.select(selectTargetList.toArray(new String[0]), selectCheckList.toArray(new String[0])).finish();
    }

    private void recordRepeatDataSet(Set<Long> writeBackId, Set<Long> recordInfoIds, List<DynamicObject> suspectList, List<Map<String, Object>> recordLists, DataSet repeatDataSet, SuspectRepeatLog log, DynamicObject suspectSet, String targetEntity, String checkEntityName, String datefield, String queruKey) {
        Map<String, String> targetFileldName = recordLists.stream().collect(Collectors.toMap(s -> (String)s.get(queruKey), s -> StringUtils.isEmpty((CharSequence)((String)s.get("shortname"))) ? (String)s.get("destname") : (String)s.get("shortname")));
        Map<String, String> checkFileldName = recordLists.stream().collect(Collectors.toMap(s -> (String)s.get(queruKey), s -> StringUtils.isEmpty((CharSequence)((String)s.get("shortname"))) ? (String)s.get("checkname") : (String)s.get("shortname")));
        HashMap<String, DynamicObject> recordMap = new HashMap<String, DynamicObject>(16);
        long beginTime = System.currentTimeMillis();
        logger.info("\u5faa\u73af\u5904\u7406\u5f00\u59cb\u65f6\u95f4\uff1a" + beginTime);
        for (Row row : repeatDataSet) {
            DynamicObject suspectBill;
            Long targetId = row.getLong("targetId");
            String checkCreator = row.getString("checkCreator");
            String targetBillno = row.getString("targetBillno");
            writeBackId.add(targetId);
            String destDescribe = this.dealDetailInfo(row, targetFileldName);
            String suspectDescribe = this.dealDetailInfo(row, checkFileldName);
            String mapKey = targetId + "_" + destDescribe;
            DynamicObject mapValue = recordMap.getOrDefault(mapKey, null);
            if (mapValue != null) {
                suspectBill = mapValue;
            } else {
                suspectBill = TmcDataServiceHelper.newDynamicObject((String)"fcs_suspectbill");
                suspectBill.set("billid", (Object)targetId);
                suspectBill.set("billno", (Object)targetBillno);
                suspectBill.set("billentity", (Object)targetEntity);
                suspectBill.set("destdescribe", (Object)destDescribe);
                suspectBill.set("suspectset", suspectSet.getPkValue());
                suspectBill.set("ctrltype", (Object)suspectSet.getString("ctrltype"));
                suspectBill.set("creator", (Object)checkCreator);
                if (recordInfoIds.contains(targetId)) {
                    suspectBill.set("confirm", (Object)true);
                    suspectBill.set("uprecordconfirm", (Object)true);
                }
                this.setSuspectRepeatLogInfo(log, suspectSet, targetEntity, targetId, targetBillno);
            }
            DynamicObjectCollection suspectEntry = suspectBill.getDynamicObjectCollection("suspectentry");
            DynamicObject entry = suspectEntry.addNew();
            entry.set("suspectbillentity", (Object)checkEntityName);
            entry.set("suspectbillid", (Object)row.getLong("checkId"));
            entry.set("suspectbillno", row.get("checkBillno"));
            entry.set("suspectdescribe", (Object)suspectDescribe);
            if (datefield != null) {
                entry.set("suspectdate", (Object)row.getDate(datefield));
            }
            recordMap.put(mapKey, suspectBill);
        }
        logger.info("\u5faa\u73af\u5904\u7406\u7ed3\u675f\u65f6\u95f4" + (System.currentTimeMillis() - beginTime));
        logger.info("\u91cd\u590d\u6570\u636e\u91cf\uff1a" + recordMap.size());
        suspectList.addAll(recordMap.values());
    }

    private Set<Long> getRecordInfo(List<Long> billIds) {
        QFilter recordFilter = new QFilter("destbillpkid", "in", billIds);
        Map records = BusinessDataServiceHelper.loadFromCache((String)"fcs_payaccess_record", (QFilter[])recordFilter.toArray());
        Set<Object> srcbillpkids = new HashSet(16);
        ArrayList collectList = new ArrayList(10);
        if (!records.isEmpty()) {
            records.values().forEach(r -> collectList.add(Pair.of((Object)r.getLong("srcbillpkid"), (Object)r.getLong("destbillpkid"))));
            srcbillpkids = records.values().stream().map(o -> o.getLong("srcbillpkid")).collect(Collectors.toSet());
        }
        HashSet<Long> confirmIds = new HashSet<Long>(16);
        if (srcbillpkids.size() > 0) {
            Long srcBillId;
            QFilter qFilter = new QFilter("billid", "in", srcbillpkids);
            qFilter.and("confirm", "=", (Object)true);
            qFilter.and("ctrltype", "=", (Object)"landing");
            DynamicObjectCollection query = QueryServiceHelper.query((String)"fcs_suspectbill", (String)"id,billid", (QFilter[])qFilter.toArray());
            Object[] bills = (DynamicObject[])query.toArray((Object[])new DynamicObject[0]);
            if (EmptyUtil.isNoEmpty((Object[])bills)) {
                for (Object bill : bills) {
                    srcBillId = bill.getLong("billid");
                    collectList.forEach(c -> {
                        if (((Long)c.getLeft()).equals(srcBillId)) {
                            confirmIds.add((Long)c.getRight());
                        }
                    });
                }
            }
            QFilter qFilter2 = new QFilter("suspectentry.suspectbillid", "in", srcbillpkids);
            qFilter2.and("confirm", "=", (Object)true);
            qFilter2.and("ctrltype", "=", (Object)"landing");
            DynamicObjectCollection fcsSuspectbills = QueryServiceHelper.query((String)"fcs_suspectbill", (String)"id,billid,suspectentry.suspectbillid suspectbillid", (QFilter[])qFilter2.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)fcsSuspectbills)) {
                for (Object bill : fcsSuspectbills) {
                    srcBillId = bill.getLong("suspectbillid");
                    collectList.forEach(c -> {
                        if (((Long)c.getLeft()).equals(srcBillId)) {
                            confirmIds.add((Long)c.getRight());
                        }
                    });
                }
            }
        }
        return confirmIds;
    }

    private String dealDetailInfo(Row row, Map<String, String> fileldName) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> map : fileldName.entrySet()) {
            Object value = row.get(map.getKey());
            builder.append(map.getValue());
            builder.append("\uff1a");
            builder.append(value);
            builder.append(";");
            builder.append("\r\n");
        }
        return builder.toString();
    }

    private Map<String, Object> getQfilterByEntity(String record, String entityName) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        QFilter qFilter = null;
        String expression = "";
        if (EmptyUtil.isNoEmpty((String)record)) {
            CRCondition targetCondition = (CRCondition)SerializationUtils.fromJsonString((String)record, CRCondition.class);
            FilterCondition filterCondition = targetCondition.getFilterCondition();
            List filterRow = filterCondition.getFilterRow();
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityName);
            List filterNameList = filterRow.stream().map(SimpleFilterRow::getFieldName).collect(Collectors.toList());
            for (String filterName : filterNameList) {
                DynamicProperty property = mainType.getProperty(filterName);
                if (!(property instanceof DateTimeProp)) continue;
                returnMap.put("datefield", filterName);
                break;
            }
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            filterBuilder.buildFilter();
            qFilter = filterBuilder.getQFilter();
            expression = targetCondition.getExpression();
        }
        returnMap.put("qfilter", qFilter != null ? qFilter : QFilter.of((String)"1 = 1", (Object[])new Object[0]));
        returnMap.put("expression", expression);
        return returnMap;
    }

    private Set<Long> getFitBillIds(String filter, String entity, List<Long> billIds) {
        Set<Long> fitTargetIds;
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            logger.info("\u5904\u7406\u524didSize()\uff1a" + billIds.size());
            CRCondition targetCondition = (CRCondition)SerializationUtils.fromJsonString((String)filter, CRCondition.class);
            ConditionFactory factory = new ConditionFactory();
            factory.init(targetCondition, entity);
            fitTargetIds = factory.runCondition(new HashSet<Long>(billIds));
            logger.info("\u5904\u7406\u540eidSize()\uff1a" + fitTargetIds.size());
        } else {
            fitTargetIds = new HashSet<Long>(billIds);
        }
        return fitTargetIds;
    }

    private void writeBackTargetBillMessage(DynamicObject suspectSet, Set<Long> writeBackId, String targetEntity, String checkStatus) {
        String tableGroup;
        String checkSignField = suspectSet.getString("checksignfield");
        String messageField = suspectSet.getString("messagefield");
        String failMessage = suspectSet.getString("failmessage");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetEntity);
        String mainTable = mainType.getAlias();
        Map fields = mainType.getFields();
        String dbRouteKey = mainType.getDBRouteKey();
        if (EmptyUtil.isNoEmpty((String)checkSignField)) {
            tableGroup = ((IDataEntityProperty)fields.get(checkSignField)).getTableGroup();
            checkSignField = ((IDataEntityProperty)fields.get(checkSignField)).getAlias();
            this.updateSourceBillField(dbRouteKey, mainTable, tableGroup, checkSignField, checkStatus, writeBackId);
        }
        if (EmptyUtil.isNoEmpty((String)messageField)) {
            tableGroup = ((IDataEntityProperty)fields.get(messageField)).getTableGroup();
            messageField = ((IDataEntityProperty)fields.get(messageField)).getAlias();
            this.updateSourceBillField(dbRouteKey, mainTable, tableGroup, messageField, failMessage, writeBackId);
        }
    }

    private void updateSourceBillField(String dbRouteKey, String mainTable, String tableGroup, String field, String value, Set<Long> writeBackId) {
        String table = tableGroup != null ? mainTable + "_" + tableGroup : mainTable;
        DBRoute dbroute = new DBRoute(dbRouteKey);
        String updateSql = "update " + table + " set " + field + " = '" + value + "' where fid in (" + TmcBusinessBaseHelper.idListToString(new ArrayList<Long>(writeBackId)) + ")";
        try (TXHandle ignored = TX.requiresNew();){
            DB.execute((DBRoute)dbroute, (String)updateSql, (Object[])new Object[0]);
        }
    }

    public void updateSuspectRepeatInfo(List<Long> billIds, Map<String, Set<Long>> confirmBillls, String confirmStatu) {
        String updateSql = null;
        if (EmptyUtil.isNoEmpty(billIds)) {
            if ("1".equals(confirmStatu)) {
                long currUserId = RequestContext.get().getCurrUserId();
                updateSql = "update t_fcs_suspectbill set fconfirm  = ?, fconfirmer = ?,fconfirmdate = ?  where fid in (" + TmcBusinessBaseHelper.idListToString(billIds) + ")";
                DB.execute((DBRoute)DBRoute.of((String)"tmc"), (String)updateSql, (Object[])new Object[]{confirmStatu, currUserId, new Date()});
            } else {
                updateSql = "update t_fcs_suspectbill set fconfirm  = ?, fconfirmer = 0,fconfirmdate = null where fid in (" + TmcBusinessBaseHelper.idListToString(billIds) + ")";
                DB.execute((DBRoute)DBRoute.of((String)"tmc"), (String)updateSql, (Object[])new Object[]{confirmStatu});
            }
        }
        for (Map.Entry<String, Set<Long>> entry : confirmBillls.entrySet()) {
            String entityNumber = entry.getKey();
            Set<Long> confirmBilllIds = entry.getValue();
            QFilter qFilter = new QFilter("destentity.number", "=", (Object)entityNumber);
            qFilter.and("enable", "=", (Object)"1");
            Map suspectSets = TmcDataServiceHelper.loadFromCache((String)"fcs_suspectset", (String)"checksignfield,messagefield,failmessage", (QFilter[])qFilter.toArray());
            DynamicObject suspectSet = suspectSets.values().stream().filter(s -> EmptyUtil.isNoEmpty((String)s.getString("checksignfield")) || EmptyUtil.isNoEmpty((String)s.getString("messagefield"))).findFirst().orElse(null);
            if (suspectSet == null) continue;
            if ("1".equals(confirmStatu)) {
                suspectSet.set("failmessage", (Object)ResManager.loadKDString((String)"\u5df2\u843d\u5730\u786e\u8ba4\uff0c\u975e\u91cd\u590d\u4e1a\u52a1\u3002", (String)"SuspectRepeatServiceImpl_1", (String)"tmc-fcs-mservice", (Object[])new Object[0]));
            }
            this.writeBackTargetBillMessage(suspectSet, confirmBilllIds, entityNumber, confirmStatu);
        }
    }

    private SuspectRepeatLog createRepeatLog(DynamicObject suspectSet) {
        SuspectRepeatLog ctrlLog = new SuspectRepeatLog();
        ctrlLog.setLogType("suspect");
        ctrlLog.setRepeatSet((Long)suspectSet.getPkValue());
        ctrlLog.setTime(System.currentTimeMillis());
        ctrlLog.setTraceId(String.valueOf(RequestContext.get().getTraceId()));
        return ctrlLog;
    }

    private void setSuspectRepeatLogCostTime(SuspectRepeatLog log, long time) {
        long costMs = (System.nanoTime() - time) / 1000L / 1000L;
        log.setCostTime(Long.valueOf(costMs));
    }

    private void setSuspectRepeatLogInfo(SuspectRepeatLog log, DynamicObject suspectSet, String targetEntity, Long targetId, String targetBillno) {
        ArrayList<SuspectRepeatDetail> detailsList = log.getDetailList();
        if (EmptyUtil.isEmpty((Collection)detailsList)) {
            detailsList = new ArrayList<SuspectRepeatDetail>(16);
            log.setDetailList(detailsList);
        }
        log.setException(suspectSet.getString("failmessage"));
        SuspectRepeatDetail detail = new SuspectRepeatDetail();
        detail.setDestBillType(targetEntity);
        detail.setDestBillId(targetId);
        detail.setDestNumber(targetBillno);
        detailsList.add(detail);
    }
}

