/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.FpmPageCacheService;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.CheckSubLimitType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.ReportVerifyCheckEffectEnum;
import kd.tmc.fpm.business.domain.enums.SumPlanSumType;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.SumPlanHeader;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.controller.IReportVerifyController;
import kd.tmc.fpm.business.mvc.controller.impl.ReportVerifyControllerImpl;
import kd.tmc.fpm.business.mvc.repository.ITemplateRepository;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.impl.TemplateRepository;
import kd.tmc.fpm.business.mvc.service.ISumPlanManageService;
import kd.tmc.fpm.business.mvc.service.dto.ReportRuleCheckDTO;
import kd.tmc.fpm.business.mvc.service.dto.ReportVerifyRuleNotifyDTO;
import kd.tmc.fpm.business.mvc.service.impl.SumPlanManageServiceImpl;
import kd.tmc.fpm.business.mvc.view.IFpmFormView;
import kd.tmc.fpm.business.mvc.view.IReportVerifyView;
import kd.tmc.fpm.business.service.sumreport.service.ISummaryConfigService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManagerV2;
import kd.tmc.fpm.business.spread.export.excel.impl.SumPlanFormsExportImpl;
import kd.tmc.fpm.business.task.ReportAsyncOpTask;
import kd.tmc.fpm.business.task.ReportImportDataClickTask;
import kd.tmc.fpm.common.enums.BillStatusEnum;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;
import kd.tmc.fpm.common.enums.SummaryConfigCheckSubLimitEnum;
import kd.tmc.fpm.common.utils.GlobalIdUtil;
import kd.tmc.fpm.formplugin.common.FpmFilterBaseList;
import kd.tmc.fpm.formplugin.helper.LinkSearchSubFormHelper;
import kd.tmc.fpm.formplugin.helper.ReportRuleCheckHelper;
import kd.tmc.fpm.utils.report.ReportPlanSumShowUtil;
import kd.tmc.fpm.utils.report.ReportPlanSumUtil;

public class ReportPlanSumList
extends FpmFilterBaseList
implements IReportVerifyView {
    private ReportPlanSumShowUtil reportPlanSumShowUtil = new ReportPlanSumShowUtil();
    private static final String CHANGEDEADLINE = "changedeadline";
    private static final String UPSEARCH = "upsearch";
    private static final String OFFSETRECORD = "offsetrecord";
    private static final String RECORDS = "records";
    private static final int RECALCULATE_AMT_MAX_BILL_NUM = 5;
    private final ITemplateRepository templateRepository = new TemplateRepository();
    private ISumPlanManageService service = new SumPlanManageServiceImpl();
    private IReportVerifyController verifyController;
    private IFpmPageCacheService cacheService;

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            switch (operateKey) {
                case "changedeadline": {
                    this.showParameter();
                    break;
                }
                case "upsearch": {
                    Object[] pkId1 = this.getPkId();
                    this.reportPlanSumShowUtil.showReport(this.getView(), pkId1);
                    break;
                }
                case "offsetrecord": {
                    Object[] pkId2 = this.getPkId();
                    this.reportPlanSumShowUtil.showRecord(this.getView(), pkId2);
                    break;
                }
                case "records": {
                    Object[] pkId3 = this.getPkId();
                    this.reportPlanSumShowUtil.showRecords(this.getView(), pkId3);
                    break;
                }
                case "submitsumplan": {
                    String numberLink = this.getPageCache().get("number_link");
                    JSONObject jsonObject = EmptyUtil.isEmpty((String)numberLink) ? new JSONObject(0) : new JSONObject((Map)JSONObject.parseObject((String)numberLink, HashMap.class));
                    this.submitSumPlan(jsonObject);
                    break;
                }
                case "exportexcel": {
                    this.exportSumPlanData();
                    break;
                }
                case "execbiasanalys": 
                case "execbiasrecord": {
                    Map billNos = operationResult.getBillNos();
                    for (String pkVal : billNos.values()) {
                        this.showExecBiasAnalysForm(Long.parseLong(pkVal));
                    }
                    break;
                }
            }
        }
        this.processSubmitIfNeed(operateKey, operationResult);
        if (("audit".equals(operateKey) || "unaudit".equals(operateKey)) && operationResult != null && !CollectionUtils.isEmpty((Collection)operationResult.getAllErrorOrValidateInfo())) {
            List errIdList = operationResult.getAllErrorOrValidateInfo().stream().map(item -> Long.valueOf(item.getPkValue().toString())).collect(Collectors.toList());
            operationResult.getSuccessPkIds().removeAll(errIdList);
            IListView view = (IListView)this.getView();
            view.refresh();
        }
        this.afterDeleteSumPlan(operateKey, operationResult);
    }

    private void processSubmitIfNeed(String operateKey, OperationResult operationResult) {
        if (!Objects.equals(operateKey, "submitsumplan")) {
            return;
        }
        if (operationResult == null) {
            return;
        }
        if (operationResult.isSuccess()) {
            return;
        }
        List successPkIds = operationResult.getSuccessPkIds();
        if (EmptyUtil.isEmpty((Collection)successPkIds)) {
            return;
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"fpm_reportplansum", (Object[])successPkIds.toArray(new Object[0]), (OperateOption)OperateOption.create());
        ValidateResultCollection validateResult = result.getValidateResult();
        validateResult.getValidateErrors().forEach(v -> operationResult.getValidateResult().addValidateError(v.getValidatorKey(), v));
        operationResult.getSuccessPkIds().removeIf(id -> !result.getSuccessPkIds().contains(id));
        IListView view = (IListView)this.getView();
        view.refresh();
    }

    private void showExecBiasAnalysForm(Object pkId) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setFormId("fpm_execbiasanalys");
        parameter.setPkId(pkId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void submitSumPlan(JSONObject jsonObject) {
        ListSelectedRowCollection collection = this.getSelectedRows();
        int sbnextnum = 0;
        Map<Long, Boolean> map = this.querySummaryConfigAllowSubmit();
        for (ListSelectedRow selectedRow : collection) {
            JSONObject js;
            Object focusRowPkId = selectedRow.getPrimaryKeyValue();
            if (!map.containsKey(focusRowPkId) || !map.getOrDefault(focusRowPkId, Boolean.TRUE).booleanValue() || Objects.isNull(js = jsonObject.getJSONObject(String.valueOf(focusRowPkId))) || (sbnextnum = js.getIntValue("unreportedplannum")) <= 0) continue;
            String notifyMessage = String.format(ResManager.loadKDString((String)"\u6c47\u603b\u5904\u7406\u5355\u3010%1$s\u3011\u5f53\u524d\u672a\u4e0a\u62a5\u5355\u636e\u6570\u91cf\u4e3a%2$s\u5f20\uff0c\u4e14\u63d0\u4ea4\u540e\u4e0b\u7ea7\u7f16\u5236\u4e3b\u4f53\u5c06\u65e0\u6cd5\u7ee7\u7eed\u62a5\u9001\u672c\u671f\u8ba1\u5212\u989d\u5ea6\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"ReportPlanSumPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), selectedRow.getBillNo(), sbnextnum);
            this.getView().showConfirm("", notifyMessage, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("submit", (IFormPlugin)this));
            break;
        }
        if (sbnextnum <= 0) {
            this.getView().invokeOperation("submit");
        }
    }

    private Map<Long, Boolean> querySummaryConfigAllowSubmit() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List summaryRecordIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).map(Long.class::cast).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(summaryRecordIds)) {
            return Collections.emptyMap();
        }
        String selectFields = String.join((CharSequence)",", "id", "reporttype", "bodysys", "billstatus");
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fpm_reportplansum", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", summaryRecordIds)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            return Collections.emptyMap();
        }
        List stageBillList = dynamicObjectCollection.stream().filter(dy -> Objects.equals(dy.getString("billstatus"), BillStatusEnum.STAGE.getCode())).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(stageBillList)) {
            return Collections.emptyMap();
        }
        Long systemId = ((DynamicObject)stageBillList.get(0)).getLong("bodysys");
        Map<Long, Long> sumRecordIdReportTypeIdMap = stageBillList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("reporttype"), (a, b) -> a));
        String reportTypeProp = String.join((CharSequence)".", "sumreporttype", "fbasedataid", "id");
        String selectFieldsSumConfig = String.join((CharSequence)",", reportTypeProp, "allowsubmit");
        QFilter qFilter = new QFilter("bodysys", "=", (Object)systemId).and(new QFilter(reportTypeProp, "in", new HashSet<Long>(sumRecordIdReportTypeIdMap.values()))).and("enable", "=", (Object)"1");
        DynamicObjectCollection dc = QueryServiceHelper.query((String)"fpm_summaryconfig", (String)selectFieldsSumConfig, (QFilter[])new QFilter[]{qFilter});
        Map<Long, Boolean> reportTypeAllowSubmitMap = dc.stream().collect(Collectors.toMap(dy -> dy.getLong(reportTypeProp), dy -> dy.getBoolean("allowsubmit"), (a, b) -> a));
        HashMap<Long, Boolean> sumRecordAllowSubmitMap = new HashMap<Long, Boolean>(selectedRows.size());
        for (Map.Entry<Long, Long> entry : sumRecordIdReportTypeIdMap.entrySet()) {
            Long reportTypeId = entry.getValue();
            Boolean allowSubmit = reportTypeAllowSubmitMap.get(reportTypeId);
            if (allowSubmit == null) {
                logger.warn("\u6c47\u603b\u7f16\u5236\uff1a{}\u5bf9\u5e94\u7684\u7f16\u62a5\u7c7b\u578b\u67e5\u4e0d\u5230\u6c47\u603b\u53c2\u6570\u3002", (Object)entry.getKey());
                allowSubmit = Boolean.TRUE;
            }
            sumRecordAllowSubmitMap.put(entry.getKey(), allowSubmit);
        }
        return sumRecordAllowSubmitMap;
    }

    private void exportSumPlanData() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List selectedIdList = selectedRows.stream().map(c -> (Long)c.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] load = TmcDataServiceHelper.load((Object[])selectedIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_reportplansum"));
        HashMap headerMap = new HashMap(1);
        HashMap<Long, SumPlanHeader> reportHeaderMap = new HashMap<Long, SumPlanHeader>(1);
        HashMap<Long, List<Long>> pageDimMemberIdMap = new HashMap<Long, List<Long>>(1);
        for (DynamicObject sumPlan : load) {
            Long reportId = sumPlan.getLong("id");
            Long systemId = (Long)sumPlan.getDynamicObject("bodysys").getPkValue();
            Long reportOrgId = (Long)sumPlan.getDynamicObject("reportorg").getPkValue();
            SumPlanHeader sumPlanHeader = this.getSumPlanHeader(sumPlan);
            FpmOperateResult result = this.service.load(reportId, systemId, sumPlanHeader, this.getCacheService(this.getView().getPageId()));
            IReportDataManagerV2 manager = (IReportDataManagerV2)result.getData();
            ReportCalcModel currCalcModel = manager.getCurrCalcModel();
            ReportTemplate reportTemplate = manager.getReportTemplate();
            List<Long> pageDimS = this.refreshPageDim(currCalcModel.getPageDimValList(), reportOrgId, reportTemplate);
            pageDimMemberIdMap.put(reportId, pageDimS);
            DynamicObjectCollection templates = sumPlan.getDynamicObjectCollection("attachtpl");
            HashMap<Long, AnalysisHeader> templateMap = new HashMap<Long, AnalysisHeader>(templates.size());
            Iterator iterator = templates.iterator();
            while (iterator.hasNext()) {
                AnalysisHeader header = new AnalysisHeader();
                DynamicObject template = (DynamicObject)iterator.next();
                DynamicObject templateDy = template.getDynamicObject("fbasedataid");
                Long templateId = templateDy.getLong("id");
                boolean isSuccess = this.getAnalysisHeader(header, reportTemplate, templateId, sumPlan);
                if (!isSuccess) continue;
                templateMap.put(templateId, header);
            }
            headerMap.put(reportId, templateMap);
            reportHeaderMap.put(reportId, sumPlanHeader);
        }
        try {
            SumPlanFormsExportImpl exportExcel = new SumPlanFormsExportImpl(new HashSet(selectedIdList), reportHeaderMap, headerMap, pageDimMemberIdMap);
            Tuple exportResult = exportExcel.export();
            if (((Boolean)exportResult.item1).booleanValue()) {
                this.getView().download((String)exportResult.item2);
            } else {
                this.getView().showErrorNotification((String)exportResult.item2);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private SumPlanHeader getSumPlanHeader(DynamicObject sumPlan) {
        Long systemId = (Long)sumPlan.getDynamicObject("bodysys").getPkValue();
        Long reportOrgId = (Long)sumPlan.getDynamicObject("reportorg").getPkValue();
        SumPlanHeader sumPlanHeader = new SumPlanHeader();
        boolean offsetOrNot = sumPlan.getBoolean("offsetornot");
        sumPlanHeader.setDataStatus(offsetOrNot ? 2 : 1);
        Long reportTypeId = (Long)sumPlan.getDynamicObject("reporttype").getPkValue();
        String originalReportIdStr = sumPlan.getString("originalreportids");
        ISummaryConfigService iSummaryConfigService = (ISummaryConfigService)FpmServiceFactory.getBizService(ISummaryConfigService.class);
        SumPlanParamConfig sumPlanParamConfig = iSummaryConfigService.getSummaryParamConfig(Long.valueOf(originalReportIdStr));
        boolean showlimit = false;
        if (!EmptyUtil.isEmpty((Object)sumPlanParamConfig)) {
            List configInfoList = sumPlanParamConfig.getConfigInfoList();
            for (SumPlanParamConfigInfo sumPlanParamConfigInfo : configInfoList) {
                CheckSubLimitType checkSubLimitType;
                if (!reportOrgId.equals(sumPlanParamConfigInfo.getOrgMemberId()) || (checkSubLimitType = sumPlanParamConfigInfo.getCheckSubLimitType()) == null || !SummaryConfigCheckSubLimitEnum.SUM_AND_CHECK_MAIN_LIMIT.getValue().equals(checkSubLimitType.getNumber())) continue;
                showlimit = true;
                break;
            }
            String planStatus = sumPlan.getString("planstatus");
            if (ReportPlanStatusEnum.EFFECTIVE.getValue().equals(planStatus)) {
                showlimit = false;
            }
        }
        sumPlanHeader.setShowApprovedAmt(Boolean.valueOf(showlimit));
        return sumPlanHeader;
    }

    public List<Long> refreshPageDim(List<ReportCalcVal> reportCalcVals, Long reportOrgId, ReportTemplate reportTemplate) {
        HashMap<String, TemplateDim> mapper = new HashMap<String, TemplateDim>(16);
        ArrayList<Long> pageDimS = new ArrayList<Long>(2);
        List pageDimList = reportTemplate.getPageDimList();
        int count = 1;
        for (int i = 0; i < pageDimList.size(); ++i) {
            TemplateDim templateDim = (TemplateDim)pageDimList.get(i);
            String pageDimSign = String.format("custompagemember%s", count++);
            mapper.put(pageDimSign, templateDim);
        }
        block1: for (ReportCalcVal reportCalcVal : reportCalcVals) {
            Long id = Long.valueOf(reportCalcVal.getValue().toString());
            Set entrys = mapper.entrySet();
            for (Map.Entry entry : entrys) {
                List ids = ((TemplateDim)entry.getValue()).getMemberScope();
                if (!ids.contains(id)) continue;
                if (ResManager.loadKDString((String)"\u7f16\u62a5\u4e3b\u4f53", (String)"ReportPlanSumList_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]).equals(reportCalcVal.getDimensionName())) {
                    pageDimS.add(reportOrgId);
                    continue block1;
                }
                pageDimS.add(id);
                continue block1;
            }
        }
        return pageDimS;
    }

    private Object[] getPkId() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] primaryKeys = selectedRows.getBillListSelectedRowCollection().getPrimaryKeyValues();
        if (primaryKeys.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u8054\u67e5\u3002", (String)"ReportPlanSumList_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return null;
        }
        return primaryKeys;
    }

    private void showParameter() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] primaryKeys = selectedRows.getBillListSelectedRowCollection().getPrimaryKeyValues();
        DynamicObject[] load = TmcDataServiceHelper.load((Object[])primaryKeys, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_reportplansum"));
        String number = load[0].getString("reportperiod.number");
        if (!Arrays.stream(load).allMatch(e -> number.equals(e.getString("reportperiod.number")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u540c\u4e00\u4e2a\u7f16\u62a5\u7c7b\u578b\u4ee5\u53ca\u540c\u4e00\u4e2a\u7f16\u62a5\u671f\u95f4\u4e0b\u7684\u8d44\u91d1\u8ba1\u5212\u5355\u636e\uff0c\u8fdb\u884c\u6279\u91cf\u53d8\u66f4\u5904\u7406\u3002", (String)"ReportPlanSumList_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setAppId("fpm");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("fpm_modifydeclaretime");
        showParameter.setCustomParam("modify_declare_time", (Object)primaryKeys);
        showParameter.setCustomParam("theForm", (Object)"fpm_reportplansum");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closecallback_decalre_time"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "closecallback_decalre_time": {
                Object returnData = event.getReturnData();
                if (null == returnData) break;
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                Object[] primaryKeys = selectedRows.getBillListSelectedRowCollection().getPrimaryKeyValues();
                DynamicObject[] load = TmcDataServiceHelper.load((Object[])primaryKeys, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_reportplansum"));
                Set collect = Arrays.stream((Object[])Arrays.stream(load).map(e -> e.getString("originalreportids").split(",")).findFirst().get()).map(e -> Long.valueOf(e)).collect(Collectors.toSet());
                DynamicObject[] dy = TmcDataServiceHelper.load((Object[])collect.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_report"));
                Arrays.stream(dy).forEach(o -> o.set("declaredeadline", returnData));
                TmcDataServiceHelper.save((DynamicObject[])dy);
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"ReportPlanSumList_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "dataverify": {
                this.dataVerify(event);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (Objects.equals(callBackId, "submit") && MessageBoxResult.Yes.equals((Object)result)) {
            this.getView().invokeOperation("submit");
        }
        if (Objects.equals(callBackId, "audit") && MessageBoxResult.Yes.equals((Object)result)) {
            this.getView().getPageCache().put("confirmAudit", "1");
            this.getView().invokeOperation("audit");
        }
        if (Objects.equals(callBackId, "beforedeletesumplan") && Objects.equals(result, MessageBoxResult.Yes)) {
            this.getView().invokeOperation("deletesumplan");
        }
        if (Objects.equals(callBackId, "recalculate_amt_confirm_1_callback") && Objects.equals(result, MessageBoxResult.Yes)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("recalculate_amt_confirm_2_callback", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5e94\u8c28\u614e\uff01\u8bf7\u786e\u8ba4\u989d\u5ea6\u91cd\u7b97\u65f6\u95f4\u6bb5\u5185\uff08\u9884\u4f30\u81f3\u5c11\u534a\u5c0f\u65f6\uff09\uff0c\u672c\u7ea7\u53ca\u6240\u6709\u4e0b\u7ea7\u7ec4\u7ec7\u5f53\u671f\u7684\u5355\u636e\u5747\u4e0d\u4f1a\u53d1\u751f\u8ba1\u5212\u8c03\u6574\u5ba1\u6838\u3001\u9884\u5360\u53ca\u5b9e\u9645\u6570\u63a7\u5236\u5199\u5165\u7b49\u64cd\u4f5c\uff01", (String)"ReportPlanSumList_13", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
            return;
        }
        if (Objects.equals(callBackId, "recalculate_amt_confirm_2_callback") && Objects.equals(result, MessageBoxResult.Yes)) {
            this.getView().invokeOperation("recalculateamt");
            return;
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
    }

    protected String getAuthEntityName() {
        return "fpm_reportplansum";
    }

    protected String getBodySystemProp() {
        return "bodysys";
    }

    protected String getReportOrgProp() {
        return "reportorg";
    }

    protected boolean authSystemManager() {
        return true;
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("reportorg", "in", (Object)this.getAuthMemberOrgIds()));
        if (this.getPageCache().get("tipFlag") != null && "true".equals(this.getPageCache().get("tipFlag"))) {
            qFilters.add(new QFilter("1", "!=", (Object)1));
        }
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        LinkSearchSubFormHelper.removeListFilterContainerFilters((ListShowParameter)formShowParameter, (SetFilterEvent)e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Boolean isFormLinkSearchChild = (Boolean)this.getView().getFormShowParameter().getCustomParam("param_from_link_search_child");
        if (Objects.nonNull(isFormLinkSearchChild) && isFormLinkSearchChild.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtercontainerap", "submit", "audit", "baritemap"});
            SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
            splitContainer.hidePanel(SplitDirection.left, true);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new SumPlanListDataProvider((IListView)this.getView()));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        BillList list = (BillList)this.getControl("billlistap");
        Object focusRowPkId = list.getFocusRowPkId();
        List<String> reportBillIds = new ArrayList<String>(2);
        String numberLink = this.getPageCache().get("number_link");
        if ("subplannum".equals(fieldName)) {
            JSONObject jsonObject;
            JSONObject js;
            args.setCancel(true);
            reportBillIds = EmptyUtil.isEmpty((String)numberLink) ? this.findSubPlanIds(reportBillIds, focusRowPkId) : (EmptyUtil.isEmpty((Object)(js = (jsonObject = new JSONObject((Map)JSONObject.parseObject((String)numberLink, HashMap.class))).getJSONObject(String.valueOf(focusRowPkId)))) ? this.findSubPlanIds(reportBillIds, focusRowPkId) : (List)js.get((Object)fieldName));
            if (EmptyUtil.isNoEmpty(reportBillIds)) {
                List reportIds = reportBillIds.stream().map(Long::parseLong).collect(Collectors.toList());
                this.reportPlanSumShowUtil.showHyperList(this.getView(), reportIds);
            }
        } else if ("subsumplannum".equals(fieldName)) {
            JSONObject jsonObject;
            JSONObject js;
            args.setCancel(true);
            reportBillIds = EmptyUtil.isEmpty((String)numberLink) ? this.finsSubSumPlanIds(focusRowPkId, reportBillIds) : (EmptyUtil.isEmpty((Object)(js = (jsonObject = new JSONObject((Map)JSONObject.parseObject((String)numberLink, HashMap.class))).getJSONObject(String.valueOf(focusRowPkId)))) ? this.finsSubSumPlanIds(focusRowPkId, reportBillIds) : (List)js.get((Object)fieldName));
            if (EmptyUtil.isNoEmpty(reportBillIds)) {
                Set reportSumIds = reportBillIds.stream().map(Long::parseLong).collect(Collectors.toSet());
                this.reportPlanSumShowUtil.showReportPlan(this.getView(), reportSumIds);
            }
        } else if ("billno".equals(fieldName) && !this.checkIfSumPlanParamConfigExist(focusRowPkId)) {
            args.setCancel(true);
        }
    }

    private boolean checkIfSumPlanParamConfigExist(Object focusRowPkId) {
        DynamicObject sumPlan = QueryServiceHelper.queryOne((String)"fpm_reportplansum", (String)"bodysys.id,bodysys.name,reporttype.id,originalreportids", (QFilter[])new QFilter("id", "=", focusRowPkId).toArray());
        SumPlanParamConfig sumPlanParamConfig = this.getSumPlanParamConfig(sumPlan);
        if (EmptyUtil.isEmpty((Object)sumPlanParamConfig)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4f53\u7cfb\u4e2d\u6ca1\u6709\u53ef\u7528\u7684\u6c47\u603b\u53c2\u6570\u914d\u7f6e\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportPlanList_15", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), sumPlan.getString("bodysys.name")));
            return false;
        }
        return true;
    }

    private List<String> finsSubSumPlanIds(Object focusRowPkId, List<String> reportBillIds) {
        DynamicObject sumPlan = QueryServiceHelper.queryOne((String)"fpm_reportplansum", (String)"bodysys.id,reporttype.id,reportorg.id,reportperiod.id,originalreportids", (QFilter[])new QFilter("id", "=", focusRowPkId).toArray());
        SumPlanParamConfig sumPlanParamConfig = this.getSumPlanParamConfig(sumPlan);
        if (!EmptyUtil.isEmpty((Object)sumPlanParamConfig)) {
            Long reportOrgId = sumPlan.getLong("reportorg.id");
            List configInfoList = sumPlanParamConfig.getConfigInfoList();
            HashSet<Long> orgSubSumPlan = new HashSet<Long>(2);
            for (SumPlanParamConfigInfo sumPlanParamConfigInfo : configInfoList) {
                if (!reportOrgId.equals(sumPlanParamConfigInfo.getOrgMemberId())) continue;
                List paramConfigInfos = sumPlanParamConfigInfo.getAllChildren();
                for (SumPlanParamConfigInfo paramConfigInfo : paramConfigInfos) {
                    if (!paramConfigInfo.isSumAuditNode()) continue;
                    orgSubSumPlan.add(paramConfigInfo.getOrgMemberId());
                }
            }
            QFilter sumQFilter = new QFilter("reportorg", "in", orgSubSumPlan);
            sumQFilter.and("reportperiod", "=", (Object)sumPlan.getLong("reportperiod.id"));
            sumQFilter.and("bodysys", "=", (Object)sumPlan.getLong("bodysys.id"));
            List subSumPlans = QueryServiceHelper.queryPrimaryKeys((String)"fpm_reportplansum", (QFilter[])new QFilter[]{sumQFilter}, null, (int)-1);
            reportBillIds = subSumPlans.stream().map(Object::toString).collect(Collectors.toList());
        }
        return reportBillIds;
    }

    private List<String> findSubPlanIds(List<String> reportPlanBillIds, Object focusRowPkId) {
        DynamicObject sumPlan = QueryServiceHelper.queryOne((String)"fpm_reportplansum", (String)"bodysys.id,reporttype.id,reportorg.id,reportperiod.id,originalreportids", (QFilter[])new QFilter("id", "=", focusRowPkId).toArray());
        SumPlanParamConfig sumPlanParamConfig = this.getSumPlanParamConfig(sumPlan);
        if (!EmptyUtil.isEmpty((Object)sumPlanParamConfig)) {
            Long reportOrgId = sumPlan.getLong("reportorg.id");
            List configInfoList = sumPlanParamConfig.getConfigInfoList();
            HashSet<Long> orgSubPlan = new HashSet<Long>(2);
            for (SumPlanParamConfigInfo sumPlanParamConfigInfo : configInfoList) {
                if (!reportOrgId.equals(sumPlanParamConfigInfo.getOrgMemberId())) continue;
                List paramConfigInfos = sumPlanParamConfigInfo.getAllChildren();
                for (SumPlanParamConfigInfo paramConfigInfo : paramConfigInfos) {
                    if (paramConfigInfo.isSumAuditNode()) continue;
                    orgSubPlan.add(paramConfigInfo.getOrgMemberId());
                }
            }
            List reportIds = this.reportPlanSumShowUtil.getReportId(sumPlan, orgSubPlan);
            reportPlanBillIds = reportIds.stream().map(Object::toString).collect(Collectors.toList());
        }
        return reportPlanBillIds;
    }

    private SumPlanParamConfig getSumPlanParamConfig(DynamicObject sumPlan) {
        String originalReportIdStr = sumPlan.getString("originalreportids");
        ISummaryConfigService iSummaryConfigService = (ISummaryConfigService)FpmServiceFactory.getBizService(ISummaryConfigService.class);
        return iSummaryConfigService.getSummaryParamConfig(Long.valueOf(originalReportIdStr));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        block9 : switch (operateKey = source.getOperateKey()) {
            case "exportexcel": {
                this.beforeExportSumPlanData(args);
                break;
            }
            case "submitsumplan": {
                String skipRuleVerify = source.getOption().getVariableValue("skipRuleVerify", "false");
                if (Boolean.parseBoolean(skipRuleVerify)) break;
                List<ReportRuleCheckDTO> dataVerifySubmitRuleFilter = this.initRuleCheckDTO();
                for (ReportRuleCheckDTO checkDTO : dataVerifySubmitRuleFilter) {
                    this.getReportVerifyController().ruleCheck(checkDTO, args);
                    if (!args.isCancel()) continue;
                    break block9;
                }
                break;
            }
            case "execbiasanalys": {
                if (this.getSelectedRows().size() <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9009\u62e9\u4e00\u7b14\u8bb0\u5f55\u53d1\u8d77\u6267\u884c\u504f\u5dee\u5206\u6790\u3002", (String)"ReportPlanList_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "beforedeletesumplan": {
                this.beforeDeleteSumPlan(args);
                break;
            }
            case "beforerecalculateamt": 
            case "recalculateamt": 
            case "recalculateamttask": {
                this.beforeRecalculateAmt(args);
                break;
            }
        }
    }

    private List<ReportRuleCheckDTO> initRuleCheckDTO() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List selectedIdList = selectedRows.stream().map(c -> (Long)c.getPrimaryKeyValue()).collect(Collectors.toList());
        String selectFields = "id,originalreportids,reportorg.id,reportorg.name,reportperiod.id,reportperiod.name,reporttype.id";
        DynamicObjectCollection planSumList = QueryServiceHelper.query((String)"fpm_reportplansum", (String)selectFields, (QFilter[])new QFilter("id", "in", selectedIdList).toArray());
        IReportVerifyController verifyController = this.getReportVerifyController();
        boolean batchCommit = selectedIdList.size() > 1;
        return ReportRuleCheckHelper.initRuleCheckDTOForSumPlan((Collection)planSumList, (IReportVerifyController)verifyController, null, (boolean)batchCommit, (boolean)Boolean.FALSE);
    }

    private void beforeExportSumPlanData(BeforeDoOperationEventArgs args) {
        Set summarytypes;
        ListSelectedRowCollection selectedRows;
        List selectedIdList;
        DynamicObjectCollection reports;
        Set periodIds;
        String errMsg = null;
        if (args.getListSelectedData().size() > 300) {
            errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u4ec5\u652f\u6301\u5bfc\u51fa\u5c0f\u4e8e300\u6761\u7684\u7f16\u5236\u6570\u636e\u3002", (String)"ReportPlanSumList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        }
        if ((periodIds = (reports = QueryServiceHelper.query((String)"fpm_reportplansum", (String)"reportperiod.id,summarytype", (QFilter[])new QFilter("id", "in", selectedIdList = (selectedRows = this.getSelectedRows()).stream().map(c -> (Long)c.getPrimaryKeyValue()).collect(Collectors.toList())).toArray())).stream().map(r -> r.getLong("reportperiod.id")).collect(Collectors.toSet())).size() > 1) {
            errMsg = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4ec5\u652f\u6301\u6279\u91cf\u5bfc\u51fa\u540c\u4e00\u4e2a\u7f16\u62a5\u671f\u95f4\u7684\u6c47\u603b\u7f16\u5236\u8868\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u9700\u8981\u5bfc\u51fa\u7684\u8d44\u91d1\u6c47\u603b\u7f16\u5236\u8868\u8303\u56f4\u3002", (String)"ReportPlanSumList_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        }
        if ((summarytypes = reports.stream().map(r -> r.getString("summarytype")).collect(Collectors.toSet())).size() > 1 || summarytypes.contains(SumPlanSumType.CHANGEPLAN.getNumber())) {
            errMsg = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6c47\u603b\u7c7b\u578b=\u8ba1\u5212\u7f16\u5236\u6c47\u603b\u7684\u5355\u636e\u8fdb\u884c\u6279\u91cf\u5bfc\u51fa\uff0c\u8bf7\u786e\u8ba4\u5355\u636e\u8303\u56f4\u3002", (String)"ReportPlanSumList_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        }
        if (EmptyUtil.isNoEmpty((String)errMsg)) {
            args.setCancel(true);
            this.getView().showErrorNotification(errMsg);
        }
    }

    protected IReportVerifyController getReportVerifyController() {
        if (null == this.verifyController) {
            this.verifyController = new ReportVerifyControllerImpl((IReportVerifyView)this);
        }
        return this.verifyController;
    }

    private boolean getAnalysisHeader(AnalysisHeader header, ReportTemplate reportTemplate, Long analysisTemplateId, DynamicObject sumPlan) {
        if (!ReportPlanSumUtil.checkRequiredField((DynamicObject)sumPlan)) {
            return false;
        }
        ReportPlanSumUtil.fillHeader((AnalysisHeader)header, (DynamicObject)sumPlan);
        ReportTemplate analysisTemplate = this.templateRepository.loadTemplateBak(analysisTemplateId);
        Set filterMemberSet = ReportPlanSumUtil.getFilterConditions((ReportTemplate)analysisTemplate, (DynamicObject)sumPlan);
        ReportPlanSumUtil.fillMembers((Set)filterMemberSet, (AnalysisHeader)header, (ReportTemplate)reportTemplate, (ReportTemplate)analysisTemplate, (DynamicObject)sumPlan);
        DynamicObject org = sumPlan.getDynamicObject("reportorg");
        if (CollectionUtils.isEmpty((Collection)header.getOrg())) {
            header.setOrg(Collections.singletonList(org.getLong("id")));
        }
        int subjectSize = ReportPlanSumUtil.getSubjectSize((AnalysisHeader)header, (DynamicObject)sumPlan);
        return header.getOrg().size() * subjectSize <= ReportPlanSumUtil.MAX_QUERY_ROW_COUNT;
    }

    public void showVerifyResultDialog(Map<String, String> customShowParameter) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("fpm_reportrulechecknotify");
        parameter.getCustomParams().putAll(customShowParameter);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dataverify"));
        this.getView().showForm(parameter);
    }

    public void showErrMessage(List<String> list) {
    }

    public void showSuccessMessage(String s) {
    }

    protected IFpmPageCacheService getCacheService(String pageId) {
        if (this.cacheService == null) {
            this.cacheService = new FpmPageCacheService(pageId);
        }
        return this.cacheService;
    }

    private void beforeDeleteSumPlan(BeforeDoOperationEventArgs args) {
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("beforedeletesumplan", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u672c\u6b21\u64cd\u4f5c\u5c06\u4f1a\u8054\u52a8\u5220\u9664\u540c\u4e00\u7f16\u62a5\u4e3b\u4f53\u4e0b\u7684\u4e3b\u5b50\u8868\u5173\u8054\u5355\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6267\u884c\u5220\u9664\u3002", (String)"ReportPlanSumList_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
        args.setCancel(true);
    }

    private void beforeRecalculateAmt(BeforeDoOperationEventArgs args) {
        Object[] primaryKeys;
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (Objects.equals(operateKey, "beforerecalculateamt")) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("recalculate_amt_confirm_1_callback", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5e94\u8c28\u614e\uff0c\u8bf7\u5728\u4e0b\u73ed\u540e\u6216\u975e\u4e1a\u52a1\u529e\u7406\u9ad8\u5cf0\u671f\u8fdb\u884c\uff01\u6b64\u5916\uff0c\u9274\u4e8e\u8be5\u64cd\u4f5c\u5c06\u4f1a\u91cd\u7b97\u5bf9\u5e94\u8ba1\u5212\u8868\u5185\u7684\u5173\u8054\u6570\u636e\uff0c\u8bf7\u5148\u786e\u4fdd\u6240\u4f9d\u8d56\u7684\u672b\u7ea7\u6570\u636e\u6b63\u786e\u3002", (String)"ReportPlanSumList_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
            args.setCancel(true);
            return;
        }
        if (Objects.equals(operateKey, "recalculateamt")) {
            primaryKeys = this.getSelectedRows().getPrimaryKeyValues();
            if (primaryKeys.length > 5) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6279\u91cf\u6267\u884c\u6570\u636e\u4fee\u590d\u65f6\uff0c\u7cfb\u7edf\u9650\u5236\u9700\u8981\u4e3a\u540c\u4e00\u6c47\u603b\u5c42\u7ea7\u4e0b\u7684\u76f8\u540c\u7f16\u62a5\u671f\u95f4\u7684\u5355\u636e\uff0c\u4e14\u6570\u91cf\u4e0d\u8d85\u8fc7%1$s\u5355\uff0c\u8bf7\u786e\u8ba4\u6240\u9009\u6c47\u603b\u5355\u636e\u8303\u56f4\u3002", (String)"ReportPlanSumList_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), 5));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection load = QueryServiceHelper.query((String)"fpm_reportplansum", (String)"id,reportorg.id,reportperiod.id,planstatus,originalreportids", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeys)});
            Set reportPeriodIdSet = load.stream().map(dy -> dy.getLong("reportperiod.id")).collect(Collectors.toSet());
            if (reportPeriodIdSet.size() > 1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6279\u91cf\u6267\u884c\u6570\u636e\u4fee\u590d\u65f6\uff0c\u7cfb\u7edf\u9650\u5236\u9700\u8981\u4e3a\u540c\u4e00\u6c47\u603b\u5c42\u7ea7\u4e0b\u7684\u76f8\u540c\u7f16\u62a5\u671f\u95f4\u7684\u5355\u636e\uff0c\u4e14\u6570\u91cf\u4e0d\u8d85\u8fc7%1$s\u5355\uff0c\u8bf7\u786e\u8ba4\u6240\u9009\u6c47\u603b\u5355\u636e\u8303\u56f4\u3002", (String)"ReportPlanSumList_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), 5));
                args.setCancel(true);
                return;
            }
            boolean noneMatchEnableReport = load.stream().noneMatch(dy -> ReportStatus.ENABLE == ReportStatus.getByVal((String)dy.getString("planstatus")));
            if (noneMatchEnableReport) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u5df2\u751f\u6548\u7684\u8ba1\u5212\u8868\u6267\u884c\u6570\u636e\u4fee\u590d\u3002", (String)"ReportPlanSumList_10", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long enableSumReportId = load.stream().filter(dy -> ReportStatus.ENABLE == ReportStatus.getByVal((String)dy.getString("planstatus"))).map(dy -> dy.getString("originalreportids")).map(Long::parseLong).findAny().get();
            ISummaryConfigService iSummaryConfigService = (ISummaryConfigService)FpmServiceFactory.getBizService(ISummaryConfigService.class);
            SumPlanParamConfig sumPlanParamConfig = iSummaryConfigService.getSummaryParamConfig(enableSumReportId);
            Map<Long, Integer> org2LevelMap = sumPlanParamConfig.getConfigInfoList().stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, SumPlanParamConfigInfo::getLevel));
            Set orgLevelSet = load.stream().map(dy -> dy.getLong("reportorg.id")).map(org2LevelMap::get).collect(Collectors.toSet());
            if (orgLevelSet.size() > 1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6279\u91cf\u6267\u884c\u6570\u636e\u4fee\u590d\u65f6\uff0c\u7cfb\u7edf\u9650\u5236\u9700\u8981\u4e3a\u540c\u4e00\u6c47\u603b\u5c42\u7ea7\u4e0b\u7684\u76f8\u540c\u7f16\u62a5\u671f\u95f4\u7684\u5355\u636e\uff0c\u4e14\u6570\u91cf\u4e0d\u8d85\u8fc7%1$s\u5355\uff0c\u8bf7\u786e\u8ba4\u6240\u9009\u6c47\u603b\u5355\u636e\u8303\u56f4\u3002", (String)"ReportPlanSumList_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), 5));
                args.setCancel(true);
                return;
            }
            this.getView().invokeOperation("recalculateamttask");
        }
        if (Objects.equals(operateKey, "recalculateamttask")) {
            primaryKeys = this.getSelectedRows().getPrimaryKeyValues();
            args.setCancel(true);
            this.asyncRecalculateAmt(Arrays.stream(primaryKeys).map(pk -> (Long)pk).collect(Collectors.toList()));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5f00\u59cb\u6267\u884c\u8ba1\u5212\u989d\u5ea6\u91cd\u7b97\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u3002", (String)"ReportPlanSumList_14", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
    }

    private void asyncRecalculateAmt(List<Long> ids) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setTaskClassname(ReportAsyncOpTask.class.getName());
        jobInfo.setName(ResManager.loadKDString((String)"\u989d\u5ea6\u91cd\u7b97\u4efb\u52a1", (String)"ReportPlanSumList_11", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobInfo.setCanStop(Boolean.FALSE);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u989d\u5ea6\u91cd\u7b97\u4efb\u52a1", (String)"ReportPlanSumList_12", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobInfo.setId(GlobalIdUtil.genStringId());
        HashMap<String, Object> params = new HashMap<String, Object>(8, 1.0f);
        params.put("ids", ids);
        params.put("entityNumber", "fpm_reportplansum");
        params.put("opKey", "recalculateamttask");
        params.put("pageId", this.getView().getPageId());
        params.put("appId", this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo();
        jobFormInfo.setJobInfo(jobInfo);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(false);
        jobFormInfo.setClickClassName(ReportImportDataClickTask.class.getName());
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private void afterDeleteSumPlan(String operateKey, OperationResult operationResult) {
        if (!Objects.equals("deletesumplan", operateKey) || Objects.isNull(operationResult) || CollectionUtils.isEmpty((Collection)operationResult.getSuccessPkIds())) {
            return;
        }
        IListView view = (IListView)this.getView();
        view.clearSelection();
        view.refresh();
    }

    private boolean dataVerify(ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        if (CollectionUtils.isEmpty((Map)returnData)) {
            return true;
        }
        String dataVerifyResult = returnData.get("dataVerifyResult").toString();
        List notifyDTOList = JSONArray.parseArray((String)dataVerifyResult, ReportVerifyRuleNotifyDTO.class);
        if (EmptyUtil.isEmpty((Collection)notifyDTOList)) {
            return true;
        }
        boolean isBatchCommit = notifyDTOList.stream().anyMatch(ReportVerifyRuleNotifyDTO::getBatchCommit);
        if (isBatchCommit) {
            return true;
        }
        boolean anyMatch = notifyDTOList.stream().anyMatch(item -> ReportVerifyCheckEffectEnum.DISABLE.getCode().equals(item.getCheckEffect().getCode()));
        if (!anyMatch) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("skipRuleVerify", "true");
            this.getView().invokeOperation("submitsumplan", operateOption);
        }
        return false;
    }

    static class ReportInfo {
        private Long reportId;
        private Long reportOrgId;
        private Long reportPeriodId;
        private ReportPlanType reportPlanType;
        private String reportPlanStatus;

        ReportInfo() {
        }

        public Long getReportId() {
            return this.reportId;
        }

        public void setReportId(Long reportId) {
            this.reportId = reportId;
        }

        public Long getReportOrgId() {
            return this.reportOrgId;
        }

        public void setReportOrgId(Long reportOrgId) {
            this.reportOrgId = reportOrgId;
        }

        public Long getReportPeriodId() {
            return this.reportPeriodId;
        }

        public void setReportPeriodId(Long reportPeriodId) {
            this.reportPeriodId = reportPeriodId;
        }

        public ReportPlanType getReportPlanType() {
            return this.reportPlanType;
        }

        public void setReportPlanType(ReportPlanType reportPlanType) {
            this.reportPlanType = reportPlanType;
        }

        public String getReportPlanStatus() {
            return this.reportPlanStatus;
        }

        public void setReportPlanStatus(String reportPlanStatus) {
            this.reportPlanStatus = reportPlanStatus;
        }
    }

    static class SumPlanCounter {
        private DynamicObject sumPlanDy;
        private final Long sumRecordId;
        private final Long sumReportOrgId;
        private final Long reportPeriodId;
        private final Long reportTypeId;
        private final Set<Long> downLevelReportPlanOrgIds;
        private final Set<Long> downLevelReportSumPlanOrgIds;
        private final Set<String> downLevelReportPlanIds;
        private final Set<String> downLevelSumReportPlanIds;
        private int reportedReportPlanCount;
        private int unreportedReportPlanCount;

        public SumPlanCounter(DynamicObject sumPlanDy) {
            this.sumPlanDy = sumPlanDy;
            this.sumRecordId = sumPlanDy.getLong("id");
            this.sumReportOrgId = sumPlanDy.getLong(String.join((CharSequence)".", "reportorg", "id"));
            this.reportPeriodId = sumPlanDy.getLong(String.join((CharSequence)".", "reportperiod", "id"));
            this.reportTypeId = sumPlanDy.getLong(String.join((CharSequence)".", "reporttype", "id"));
            this.downLevelReportPlanOrgIds = new HashSet<Long>(16);
            this.downLevelReportSumPlanOrgIds = new HashSet<Long>(16);
            this.downLevelReportPlanIds = new HashSet<String>(16);
            this.downLevelSumReportPlanIds = new HashSet<String>(16);
        }

        public Long getSumRecordId() {
            return this.sumRecordId;
        }

        public Long getSumReportOrgId() {
            return this.sumReportOrgId;
        }

        public Long getReportPeriodId() {
            return this.reportPeriodId;
        }

        public Long getReportTypeId() {
            return this.reportTypeId;
        }

        public Set<Long> getDownLevelReportPlanOrgIds() {
            return this.downLevelReportPlanOrgIds;
        }

        public Set<Long> getDownLevelReportSumPlanOrgIds() {
            return this.downLevelReportSumPlanOrgIds;
        }

        public void count(ReportInfo reportInfo) {
            if (Objects.equals(reportInfo.getReportOrgId(), this.sumReportOrgId)) {
                return;
            }
            Long reportId = reportInfo.getReportId();
            if (EmptyUtil.isEmpty((Long)reportId)) {
                return;
            }
            if (reportInfo.reportPlanType == ReportPlanType.REPORTPLAN) {
                this.downLevelReportPlanIds.add(reportId.toString());
            } else {
                this.downLevelSumReportPlanIds.add(reportId.toString());
            }
            if (ReportPlanStatusEnum.isReportOrEffective((String)reportInfo.getReportPlanStatus())) {
                ++this.reportedReportPlanCount;
            }
            this.unreportedReportPlanCount = this.downLevelReportPlanIds.size() + this.downLevelSumReportPlanIds.size() - this.reportedReportPlanCount;
        }

        public int getDownLevelReportPlanCount() {
            return this.downLevelReportPlanIds.size();
        }

        public int getDownLevelSumReportPlanCount() {
            return this.downLevelSumReportPlanIds.size();
        }

        public int getReportedReportPlanCount() {
            return this.reportedReportPlanCount;
        }

        public int getUnreportedReportPlanCount() {
            return this.unreportedReportPlanCount;
        }

        public Set<String> getDownLevelReportPlanIds() {
            return this.downLevelReportPlanIds;
        }

        public Set<String> getDownLevelSumReportPlanIds() {
            return this.downLevelSumReportPlanIds;
        }

        public Set<Long> getAllSubReportOrgIds() {
            HashSet<Long> reportOrgIds = new HashSet<Long>(this.downLevelReportPlanOrgIds);
            reportOrgIds.addAll(this.downLevelReportSumPlanOrgIds);
            return reportOrgIds;
        }

        public void addDownLevelReportOrgId(SumPlanParamConfig sumPlanParamConfig) {
            List configInfoList = sumPlanParamConfig.getConfigInfoList();
            for (SumPlanParamConfigInfo sumPlanParamConfigInfo : configInfoList) {
                List allChildren;
                Long orgMemberId = sumPlanParamConfigInfo.getOrgMemberId();
                if (!Objects.equals(this.sumReportOrgId, orgMemberId) || EmptyUtil.isEmpty((Collection)(allChildren = sumPlanParamConfigInfo.getAllChildren()))) continue;
                for (SumPlanParamConfigInfo child : allChildren) {
                    if (child.isSumAuditNode()) {
                        this.downLevelReportSumPlanOrgIds.add(child.getOrgMemberId());
                        continue;
                    }
                    this.downLevelReportPlanOrgIds.add(child.getOrgMemberId());
                }
            }
        }
    }

    static class SumPlanListDataProvider
    extends ListDataProvider {
        private final IListView listView;

        public SumPlanListDataProvider(IListView listView) {
            this.listView = listView;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection dc = super.getData(start, limit);
            this.listView.getPageCache().put("number_link", null);
            if (EmptyUtil.isEmpty((DynamicObjectCollection)dc)) {
                return dc;
            }
            Map<Long, SumPlanParamConfig> sumPlanParamConfigMap = this.initSumPlanConfigMap((DynamicObject)dc.get(0));
            List<SumPlanCounter> sumPlanCounterList = this.getSumPlanCounterList(dc, sumPlanParamConfigMap);
            if (EmptyUtil.isEmpty(sumPlanCounterList)) {
                return dc;
            }
            this.addCountInfo(sumPlanCounterList);
            return dc;
        }

        private void addCountInfo(List<SumPlanCounter> sumPlanCounterList) {
            this.initCount(sumPlanCounterList);
            JSONObject jsonObject = new JSONObject();
            for (SumPlanCounter sumPlanCounter : sumPlanCounterList) {
                DynamicObject sumPlanDy = sumPlanCounter.sumPlanDy;
                sumPlanDy.set("subplannum", (Object)sumPlanCounter.getDownLevelReportPlanCount());
                sumPlanDy.set("subsumplannum", (Object)sumPlanCounter.getDownLevelSumReportPlanCount());
                sumPlanDy.set("reportedplannum", (Object)sumPlanCounter.getReportedReportPlanCount());
                sumPlanDy.set("unreportedplannum", (Object)sumPlanCounter.getUnreportedReportPlanCount());
                JSONObject js = new JSONObject();
                js.put("subplannum", sumPlanCounter.getDownLevelReportPlanIds());
                js.put("subsumplannum", sumPlanCounter.getDownLevelSumReportPlanIds());
                js.put("unreportedplannum", (Object)sumPlanCounter.getUnreportedReportPlanCount());
                jsonObject.put(sumPlanDy.getString("id"), (Object)js);
            }
            this.listView.getPageCache().put("number_link", JSONObject.toJSONString((Object)jsonObject));
        }

        private void initCount(List<SumPlanCounter> sumPlanCounterList) {
            HashSet<Long> allReportOrgIds = new HashSet<Long>(16);
            HashSet<Long> allSumReportOrgIds = new HashSet<Long>(16);
            HashSet<Long> allReportPeriodIds = new HashSet<Long>(16);
            HashMap<Long, BitMap> sumPlanCountMap = new HashMap<Long, BitMap>(sumPlanCounterList.size());
            for (SumPlanCounter sumPlanCounter : sumPlanCounterList) {
                Set<Long> allSubReportOrgIds = sumPlanCounter.getAllSubReportOrgIds();
                allReportOrgIds.addAll(sumPlanCounter.getDownLevelReportPlanOrgIds());
                allSumReportOrgIds.addAll(sumPlanCounter.getDownLevelReportSumPlanOrgIds());
                allReportPeriodIds.add(sumPlanCounter.getReportPeriodId());
                BitMap sumPlanCounterBitMap = sumPlanCountMap.computeIfAbsent(sumPlanCounter.getReportPeriodId(), k -> new BitMap(64));
                sumPlanCounterBitMap.addValue(allSubReportOrgIds, (Object)sumPlanCounter);
            }
            Consumer<ReportInfo> reportInfoConsumer = reportInfo -> {
                BitMap sumPlanCounterBitMap = (BitMap)sumPlanCountMap.get(reportInfo.getReportPeriodId());
                if (sumPlanCounterBitMap == null) {
                    return;
                }
                List counterBitMapList = sumPlanCounterBitMap.findList(Collections.singleton(reportInfo.getReportOrgId()));
                if (EmptyUtil.isEmpty((Collection)counterBitMapList)) {
                    return;
                }
                counterBitMapList.forEach(sumPlanCounter -> sumPlanCounter.count((ReportInfo)reportInfo));
            };
            this.queryReportPlan(allReportOrgIds, allReportPeriodIds, reportInfoConsumer);
            this.querySumRecord(allSumReportOrgIds, allReportPeriodIds, reportInfoConsumer);
        }

        private void querySumRecord(Set<Long> allSumReportOrgIds, Set<Long> allReportPeriodIds, Consumer<ReportInfo> reportInfoConsumer) {
            String reportOrgIdProp = String.join((CharSequence)".", "reportorg", "id");
            String reportPeriodIdProp = String.join((CharSequence)".", "reportperiod", "id");
            QFilter qFilter = new QFilter(reportOrgIdProp, "in", allSumReportOrgIds).and(reportPeriodIdProp, "in", allReportPeriodIds);
            String selectFields = String.join((CharSequence)",", reportOrgIdProp, reportPeriodIdProp, "id", "planstatus");
            DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_reportplansum", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
            if (EmptyUtil.isEmpty((DynamicObjectCollection)query)) {
                return;
            }
            for (DynamicObject dy : query) {
                ReportInfo reportInfo = new ReportInfo();
                reportInfo.setReportId(dy.getLong("id"));
                reportInfo.setReportOrgId(dy.getLong(reportOrgIdProp));
                reportInfo.setReportPeriodId(dy.getLong(reportPeriodIdProp));
                reportInfo.setReportPlanType(ReportPlanType.SUMPLAN);
                reportInfo.setReportPlanStatus(dy.getString("planstatus"));
                reportInfoConsumer.accept(reportInfo);
            }
        }

        private void queryReportPlan(Set<Long> allReportOrgIds, Set<Long> allReportPeriodIds, Consumer<ReportInfo> reportInfoConsumer) {
            String reportOrgIdProp = String.join((CharSequence)".", "reportorg", "id");
            String reportPeriodIdProp = String.join((CharSequence)".", "reportperiod", "id");
            QFilter qFilter = new QFilter(reportOrgIdProp, "in", allReportOrgIds).and(reportPeriodIdProp, "in", allReportPeriodIds).and(new QFilter("reportplantype", "=", (Object)ReportPlanType.REPORTPLAN.getNumber()));
            String selectFields = String.join((CharSequence)",", reportOrgIdProp, reportPeriodIdProp, "id", "planstatus");
            DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
            if (EmptyUtil.isEmpty((DynamicObjectCollection)query)) {
                return;
            }
            for (DynamicObject dy : query) {
                ReportInfo reportInfo = new ReportInfo();
                reportInfo.setReportId(dy.getLong("id"));
                reportInfo.setReportOrgId(dy.getLong(reportOrgIdProp));
                reportInfo.setReportPeriodId(dy.getLong(reportPeriodIdProp));
                reportInfo.setReportPlanType(ReportPlanType.REPORTPLAN);
                reportInfo.setReportPlanStatus(dy.getString("planstatus"));
                reportInfoConsumer.accept(reportInfo);
            }
        }

        private List<SumPlanCounter> getSumPlanCounterList(DynamicObjectCollection dc, Map<Long, SumPlanParamConfig> sumPlanParamConfigMap) {
            ArrayList<SumPlanCounter> sumPlanCounterList = new ArrayList<SumPlanCounter>(dc.size());
            for (DynamicObject sumPlan : dc) {
                if (!Objects.equals(BillStatus.STAGE.getNumber(), sumPlan.getString("billstatus"))) continue;
                SumPlanCounter sumPlanCounter = new SumPlanCounter(sumPlan);
                SumPlanParamConfig sumPlanParamConfig = sumPlanParamConfigMap.get(sumPlanCounter.getReportTypeId());
                if (sumPlanParamConfig == null) {
                    IFpmFormView.logger.info("\u7f16\u62a5\u7c7b\u578bid\uff1a{}", (Object)sumPlanCounter.getReportTypeId());
                    throw new KDBizException("SumPlanParamConfig is null,reportTypeId:" + sumPlanCounter.getReportTypeId());
                }
                sumPlanCounter.addDownLevelReportOrgId(sumPlanParamConfig);
                sumPlanCounterList.add(sumPlanCounter);
            }
            return sumPlanCounterList;
        }

        private Map<Long, SumPlanParamConfig> initSumPlanConfigMap(DynamicObject dy) {
            long systemId = dy.getLong(String.join((CharSequence)".", "bodysys", "id"));
            List sumPlanParamConfigList = new SumPlanRepository().loadSumConfigBySystem(Long.valueOf(systemId));
            HashMap<Long, SumPlanParamConfig> sumPlanParamConfigMap = new HashMap<Long, SumPlanParamConfig>(sumPlanParamConfigList.size());
            for (SumPlanParamConfig sumPlanParamConfig : sumPlanParamConfigList) {
                List reportPeriodTypeIdS = sumPlanParamConfig.getReportPeriodTypeIdS();
                reportPeriodTypeIdS.forEach(reportTypeId -> sumPlanParamConfigMap.putIfAbsent((Long)reportTypeId, sumPlanParamConfig));
            }
            return sumPlanParamConfigMap;
        }
    }
}

