/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.SearchEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.filter.SearchListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.FpmPageCacheService;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.cache.data.CacheCellMeta;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.AnalysisReportType;
import kd.tmc.fpm.business.domain.enums.BillState;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;
import kd.tmc.fpm.business.mvc.controller.IAnalysisReportManageController;
import kd.tmc.fpm.business.mvc.controller.impl.AnalysisReportManageController;
import kd.tmc.fpm.business.mvc.view.IAnalysisReportManageView;
import kd.tmc.fpm.business.spread.command.generator.InitialToolbarAndRightKeyItemGenerator;
import kd.tmc.fpm.business.spread.command.generator.SynthesisReportGenerator;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManagerV2;
import kd.tmc.fpm.business.spread.export.excel.impl.SynthesisReportFormsExportImpl;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.TemplateUsesEnum;
import kd.tmc.fpm.common.helper.FpmPageCacheHelper;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.common.property.SynthesisReportProp;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.spread.plugin.AbstractSpreadPlugin;
import kd.tmc.fpm.spread.widget.ContextMenuItemsEnum;
import kd.tmc.fpm.spread.widget.SpreadSelector;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.core.Sheet;
import kd.tmc.fpm.utils.system.DefaultModelHelper;
import org.apache.commons.compress.utils.Sets;
import org.apache.commons.lang3.StringUtils;

public class SynthesisQueryReportPlugin
extends AbstractSpreadPlugin
implements IAnalysisReportManageView,
SearchListener {
    private IAnalysisReportManageController controller;
    private CellDataSource cellDS;
    private static final Map<String, String> DIMENSION_CONTROL_MAP = new /* Unavailable Anonymous Inner Class!! */;

    public void rebuildSpreadJs(String json) {
        this.getSpreadCommandInvoker().rebuildSpread(json);
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        FpmPageCacheHelper.removeCache((IFormView)this.getView(), (String)"maxcol");
        FpmPageCacheHelper.removeCache((IFormView)this.getView(), (String)"maxrow");
        FpmPageCacheHelper.removeCache((IFormView)this.getView(), (String)"CACHE_CUSTOMER_CONTROL_DIMENSION_MAP");
        FpmPageCacheHelper.removeCache((IFormView)this.getView(), (String)"cache:detailreport:perrow:maindimval:map");
        this.getOrCreateReportController().release();
    }

    public void search(SearchEvent searchEvent) {
        AnalysisHeader header;
        ReportQueryParam reportQueryParam = searchEvent.getRepotParam();
        if (!this.getAnalysisHeader(reportQueryParam, header = new AnalysisHeader())) {
            return;
        }
        this.getOrCreateReportController().loadAnalysisReport(AnalysisReportType.SYNTHESIS, header);
        this.getModel().setValue("exratetable", (Object)header.getExchangeRateTableId());
        this.getModel().setValue("exchangeratedate", (Object)header.getExchangeRateDate());
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap", "exportexcel"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"print"});
    }

    public void initialize() {
        super.initialize();
        SynthesisReportProp.F7_SIGN_LIST.forEach(key -> ((BasedataEdit)this.getControl((String)key)).addBeforeF7SelectListener(this.getBeforeF7SelectListener()));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.presetHeader();
        this.presetDimensionVisible();
        this.presetCustomDimensionVisible();
        this.presetStatusDownBox(false);
        this.changeBillStatusDownBox(false);
        this.changeVisibleOfInnerState();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportFilter custFilterCont = (ReportFilter)this.getControl("reportfilterap");
        custFilterCont.addSearchListener((SearchListener)this);
        this.registerCustomerControl();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (opKey = afterDoOperationEventArgs.getOperateKey()) {
            case "exportexcel": {
                AnalysisHeader header = new AnalysisHeader();
                boolean success = this.getAnalysisHeader(null, header);
                if (!success) {
                    return;
                }
                SynthesisReportFormsExportImpl exportExcel = new SynthesisReportFormsExportImpl(header);
                Tuple exportResult = exportExcel.export();
                if (((Boolean)exportResult.item1).booleanValue()) {
                    this.getView().download((String)exportResult.item2);
                    break;
                }
                this.showErrMessage(Collections.singletonList(exportResult.item2));
                break;
            }
            case "refresh": {
                ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
                control.search();
                break;
            }
            case "print": {
                this.getSpreadCommandInvoker().print();
                break;
            }
            case "showemptyrow": {
                this.controlEmptyRow(true, this.getSpreadCommandInvoker(), this.getEmptyValRows());
                break;
            }
            case "hideemptyrow": {
                this.controlEmptyRow(false, this.getSpreadCommandInvoker(), this.getEmptyValRows());
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ArrayList<ContextMenuItemsEnum> extraItems = new ArrayList<ContextMenuItemsEnum>(4);
        extraItems.add(ContextMenuItemsEnum.LINK_SEARCH_ANALYSE_REPORT);
        extraItems.add(ContextMenuItemsEnum.LINKSEARCHEXECRECORD);
        ArrayList<ContextMenuItemsEnum> hideItems = new ArrayList<ContextMenuItemsEnum>(4);
        hideItems.add(ContextMenuItemsEnum.PASTEALL);
        hideItems.add(ContextMenuItemsEnum.CLEARCONTENTS);
        new InitialToolbarAndRightKeyItemGenerator(extraItems, hideItems).generatorChain(this.getSpreadCommandInvoker()).execCommand();
        Long systemId = DefaultModelHelper.getAnalysisReportDefaultSystemId((String)this.getView().getFormShowParameter().getAppId(), (String)"fpm_synthesisquery");
        if (EmptyUtil.isNoEmpty((Long)systemId)) {
            this.initBodySystem(systemId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData changedata = e.getChangeSet()[0];
        Object newValue = changedata.getNewValue();
        switch (propName) {
            case "bodysystem": {
                if (newValue == null) {
                    return;
                }
                this.getModel().setValue("reporttype", null);
                this.getModel().setValue("reporttypesingle", null);
                this.getModel().setValue("period", null);
                this.getModel().setValue("analysistemplate", null);
                this.getModel().setValue("billstatus", null);
                this.getModel().setValue("planstatus", null);
                this.getModel().setValue("org", null);
                this.getModel().setValue("subjects", null);
                this.getModel().setValue("currency", null);
                this.getModel().setValue("company", null);
                this.getModel().setValue("containdetailreporttype", (Object)false);
                this.getModel().setValue("metricmember", null);
                this.getModel().setValue("custommember1", null);
                this.getModel().setValue("custommember2", null);
                this.getModel().setValue("custommember3", null);
                DynamicObject bodySystem = (DynamicObject)newValue;
                this.initBodySystem(bodySystem.getPkValue());
                DefaultModelHelper.save((Long)((Long)bodySystem.getPkValue()));
                break;
            }
            case "reporttype": {
                if (newValue == null) {
                    return;
                }
                DynamicObjectCollection reportTypeList = (DynamicObjectCollection)newValue;
                this.fillMultiPeriodMember(reportTypeList);
                break;
            }
            case "reporttypesingle": {
                if (newValue == null) {
                    return;
                }
                DynamicObject reportType = (DynamicObject)newValue;
                this.fillPeriodMember(reportType);
                break;
            }
            case "analysistemplate": {
                this.presetHeader();
                this.presetDimensionVisible();
                this.presetCustomDimensionVisible();
                this.presetMetricMemberAndDimFilter();
                this.presetStatusDownBox(true);
                this.changeVisibleOfInnerState();
                this.presetPeriod(null);
                break;
            }
            case "planstatus": {
                this.changeVisibleOfInnerState();
                this.changeBillStatusDownBox(true);
                break;
            }
            case "amountunit": {
                ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
                control.addSearchListener((SearchListener)this);
                control.search();
                break;
            }
            case "metricmember": {
                this.tipSelectedInvalidMetricIfNeed((DynamicObjectCollection)newValue);
                break;
            }
        }
    }

    private void presetHeader() {
        DynamicObject template = (DynamicObject)this.getModel().getValue("analysistemplate");
        if (Objects.isNull(template)) {
            return;
        }
        DynamicObjectCollection dimSetting = template.getDynamicObjectCollection("dimsettingentry");
        Optional<DynamicObject> pagePeriodExist = dimSetting.stream().filter(dO -> DimLocation.PAGE.getNumber().equals(dO.getString("type")) && DimensionType.PERIOD.getNumber().equals(dO.getString("dimbd.number"))).findFirst();
        Optional<DynamicObject> pageCurrencyExist = dimSetting.stream().filter(dO -> DimLocation.PAGE.getNumber().equals(dO.getString("type")) && DimensionType.CURRENCY.getNumber().equals(dO.getString("dimbd.number"))).findFirst();
        Optional<DynamicObject> pageOrgExist = dimSetting.stream().filter(dO -> DimLocation.PAGE.getNumber().equals(dO.getString("type")) && DimensionType.ORG.getNumber().equals(dO.getString("dimbd.number"))).findFirst();
        BasedataEdit ctrlCurrency = (BasedataEdit)this.getControl("reportcurrency");
        BasedataEdit ctrlOrg = (BasedataEdit)this.getControl("org");
        BasedataEdit ctrlReportTypeSingle = (BasedataEdit)this.getControl("reporttypesingle");
        BasedataEdit ctrlReportType = (BasedataEdit)this.getControl("reporttype");
        ctrlOrg.setMustInput(!pageOrgExist.isPresent());
        if (this.isFix(template)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"reportcurrency"});
            ctrlCurrency.setMustInput(true);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"reporttypesingle"});
            ctrlReportTypeSingle.setMustInput(false);
            this.getModel().setValue("reporttypesingle", null);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"reporttype"});
            ctrlReportType.setMustInput(true);
            this.getView().setVisible(Boolean.valueOf(!pageCurrencyExist.isPresent()), new String[]{"distinctcurrency"});
            this.getView().setVisible(Boolean.valueOf(!pagePeriodExist.isPresent()), new String[]{"containdetailreporttype"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"reportcurrency"});
            this.getModel().setValue("reportcurrency", null);
            ctrlCurrency.setMustInput(false);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"reporttypesingle"});
            ctrlReportTypeSingle.setMustInput(true);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"reporttype"});
            ctrlReportType.setMustInput(false);
            this.getModel().setValue("reporttype", null);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"distinctcurrency"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"containdetailreporttype"});
        }
    }

    public void refreshBook(Book book) {
        if (null == book) {
            String err = ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u5b9a\u5236\u6a21\u677f\u6570\u636e\uff0c\u65e0\u6cd5\u9884\u89c8\u3002", (String)"TemplateManageBasePlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.showErrMessage(Collections.singletonList(err));
            return;
        }
        int maxRow = (Integer)Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxrow", Integer.class)).orElse(0);
        int maxCol = (Integer)Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxcol", Integer.class)).orElse(0);
        Integer currentMaxRow = book.getSheet().getRows().stream().max(Integer::compareTo).orElse(0);
        Integer currentMaxCol = book.getSheet().getCols().stream().max(Integer::compareTo).orElse(0);
        List maxRows = Sheet.generateIntegerNumByScope((Integer)Math.max(maxRow, currentMaxRow));
        List maxCols = Sheet.generateIntegerNumByScope((Integer)Math.max(maxCol, currentMaxCol));
        new SynthesisReportGenerator(maxRows, maxCols).generatorChain(this.getSpreadCommandInvoker(), book).execCommand();
        Map<Integer, List<Cell>> rowCellMap = book.getSheet().getCellList().stream().filter(o -> o.getCellDimType() == CellDimTypeEnum.DATADIMS).collect(Collectors.groupingBy(Cell::getRow));
        List rows = rowCellMap.entrySet().stream().filter(o -> ((List)o.getValue()).stream().noneMatch(cell -> EmptyUtil.isNoEmpty((Object)cell.getValue()))).map(Map.Entry::getKey).collect(Collectors.toList());
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"emptyRows", rows);
        ArrayList<ContextMenuItemsEnum> extraMenuItems = new ArrayList<ContextMenuItemsEnum>(2);
        DynamicObject template = (DynamicObject)this.getModel().getValue("analysistemplate");
        if (!this.isFix(template)) {
            Map detailReportPerRowMainDimValMap = ReportHelper.createDetailReportPerRowMainDimValMap((Book)book);
            FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"cache:detailreport:perrow:maindimval:map", (Object)detailReportPerRowMainDimValMap);
        } else {
            extraMenuItems.add(ContextMenuItemsEnum.LINK_SEARCH_ANALYSE_REPORT);
        }
        extraMenuItems.add(ContextMenuItemsEnum.LINKSEARCHEXECRECORD);
        ArrayList<ContextMenuItemsEnum> hideItems = new ArrayList<ContextMenuItemsEnum>(4);
        hideItems.add(ContextMenuItemsEnum.PASTEALL);
        hideItems.add(ContextMenuItemsEnum.CLEARCONTENTS);
        new InitialToolbarAndRightKeyItemGenerator(null, hideItems).generatorChain(this.getSpreadCommandInvoker()).execCommand();
        new InitialToolbarAndRightKeyItemGenerator(extraMenuItems, hideItems).generatorChain(this.getSpreadCommandInvoker()).execCommand();
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxrow", (Object)currentMaxRow);
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxcol", (Object)currentMaxCol);
    }

    public void refreshAnalysisBook(Book book) {
    }

    public void showErrMessage(List<String> errMessageList) {
        if (!CollectionUtils.isEmpty(errMessageList)) {
            if (errMessageList.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u591a\u6761\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4\u3002", (String)"ReportPlanPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errMessageList.stream().reduce((a, b) -> a + '\n' + b).orElseGet(() -> ""), MessageTypes.Default);
            } else if (errMessageList.size() == 1) {
                this.getView().showErrorNotification(errMessageList.get(0));
            }
        }
    }

    public void showSuccessMessage(String successMessage) {
        if (null != successMessage) {
            this.getView().showSuccessNotification(successMessage);
        }
    }

    public BeforeF7SelectListener getBeforeF7SelectListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void registerCustomerControl() {
        Map customControlDimensionMap = (Map)FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"CACHE_CUSTOMER_CONTROL_DIMENSION_MAP", Map.class);
        if (customControlDimensionMap == null) {
            return;
        }
        DynamicObject bodySystem = (DynamicObject)this.getModel().getValue("bodysystem");
        for (Map.Entry entry : customControlDimensionMap.entrySet()) {
            String controlName = (String)entry.getKey();
            Dimension dimension = (Dimension)entry.getValue();
            BasedataEdit baseDataEdit = (BasedataEdit)this.getControl(controlName);
            baseDataEdit.setCaption(new LocaleString(dimension.getName()));
            baseDataEdit.addBeforeF7SelectListener(item -> {
                ListShowParameter showParameter = (ListShowParameter)item.getFormShowParameter();
                QFilter qFilter = new QFilter("dimension", "=", (Object)dimension.getId()).and("dimtype", "=", (Object)dimension.getBaseDataType()).and("bodysystem", "=", bodySystem.getPkValue()).and("enable", "=", (Object)"1");
                showParameter.getListFilterParameter().setFilter(qFilter);
            });
        }
    }

    private QFilter getReportTypeQFilter(DynamicObject reportType) {
        QFilter filter = new QFilter("reporttype", "=", reportType.getPkValue());
        if (PeriodType.MONTH_WEEK.getNumber().equals(reportType.getString("orgreportcycle"))) {
            filter.and("periodtype", "in", (Object)new Object[]{PeriodType.MONTH_WEEK.getNumber(), PeriodType.YEAR_WEEK.getNumber()});
        } else {
            filter.and("periodtype", "in", (Object)new Object[]{reportType.getString("orgreportcycle")});
        }
        return filter;
    }

    private boolean checkBeforeBuildF7Filter(String key) {
        DynamicObject analysisTplDO;
        DynamicObject system = (DynamicObject)this.getModel().getValue("bodysystem");
        if (system == null && !"bodysystem".equals(key)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u8ba1\u5212\u4f53\u7cfb", (String)"SynthesisQueryReportPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if ("period".equals(key)) {
            DynamicObject template = (DynamicObject)this.getModel().getValue("analysistemplate");
            if (template == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7edf\u8ba1\u5206\u6790\u6a21\u677f", (String)"SynthesisQueryReportPlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!this.isFix(template)) {
                Object reportType = this.getModel().getValue("reporttypesingle");
                if (reportType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7f16\u62a5\u7c7b\u578b", (String)"SynthesisQueryReportPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    return false;
                }
            } else {
                DynamicObjectCollection reportType = (DynamicObjectCollection)this.getModel().getValue("reporttype");
                if (EmptyUtil.isEmpty((DynamicObjectCollection)reportType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7f16\u62a5\u7c7b\u578b", (String)"SynthesisQueryReportPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        }
        if ("metricmember".equals(key) && (analysisTplDO = (DynamicObject)this.getModel().getValue("analysistemplate")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7edf\u8ba1\u5206\u6790\u6a21\u677f", (String)"SynthesisQueryReportPlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void initBodySystem(Object pkValue) {
        DynamicObject bodySystem = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"fpm_bodysysmanage");
        if (bodySystem == null) {
            return;
        }
        this.getModel().setValue("bodysystem", (Object)bodySystem);
        this.presetAnalysisTemplate(bodySystem);
        this.presetDimensionVisible();
        this.presetReportCurrency(bodySystem);
        this.presetCustomDimensionVisible();
        this.presetMetricMemberAndDimFilter();
        this.presetStatusDownBox(true);
        this.changeBillStatusDownBox(true);
        this.changeVisibleOfInnerState();
        this.presetPeriod(bodySystem);
    }

    private void presetAnalysisTemplate(DynamicObject bodySystem) {
        QFilter qFilter = new QFilter("model", "=", bodySystem.getPkValue());
        qFilter.and("templateuses", "=", (Object)TemplateUsesEnum.STATISTIC.getValue());
        qFilter.and("dfquerytpl", "=", (Object)"1");
        qFilter.and("releasestatus", "=", (Object)Character.valueOf('1'));
        qFilter.and("enable", "=", (Object)Character.valueOf('1'));
        DynamicObject dynamicObject = TmcDataServiceHelper.loadSingle((String)"fpm_template", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject == null) {
            return;
        }
        this.getModel().setValue("analysistemplate", dynamicObject.getPkValue());
    }

    private void presetPeriod(DynamicObject bodySystem) {
        DynamicObject template;
        if (bodySystem == null) {
            DynamicObject plainSystem = (DynamicObject)this.getModel().getValue("bodysystem");
            if (plainSystem == null) {
                return;
            }
            bodySystem = BusinessDataServiceHelper.loadSingle((Object)plainSystem.getPkValue(), (String)"fpm_bodysysmanage");
        }
        if (Objects.isNull(template = (DynamicObject)this.getModel().getValue("analysistemplate"))) {
            return;
        }
        Optional<DynamicObject> reportType = bodySystem.getDynamicObjectCollection("applyrereportentry").stream().filter(item -> "enable".equals(item.getString("rereporttypestatus"))).map(item -> item.getDynamicObject("rerporttype")).findFirst();
        if (reportType.isPresent()) {
            DynamicObject reportTypeObj = reportType.get();
            if (this.isFix(template)) {
                this.getModel().setValue("reporttype", (Object)new Object[]{reportTypeObj.getPkValue()});
                this.getModel().setValue("reporttypesingle", null);
            } else {
                this.getModel().setValue("reporttype", null);
                this.getModel().setValue("reporttypesingle", reportTypeObj.getPkValue());
            }
            this.fillPeriodMember(reportTypeObj);
        }
    }

    private void fillPeriodMember(DynamicObject reportTypeObj) {
        this.getView().setEnable(Boolean.valueOf(EmptyUtil.isNoEmpty((Object)reportTypeObj.get("orgreporttype"))), new String[]{"containdetailreporttype"});
        this.getModel().setValue("containdetailreporttype", (Object)Boolean.FALSE);
        TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"period"});
        DynamicObject plainSystem = (DynamicObject)this.getModel().getValue("bodysystem");
        if (plainSystem == null) {
            return;
        }
        Date current = new Date();
        QFilter filter = new QFilter("bodysystem", "=", plainSystem.getPkValue());
        filter.and("startdate", "<=", (Object)current);
        filter.and("enddate", ">=", (Object)current);
        filter.and(this.getReportTypeQFilter(reportTypeObj));
        DynamicObjectCollection periodMembers = QueryServiceHelper.query((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"longnumber desc");
        if (periodMembers != null && periodMembers.size() > 0) {
            this.getModel().setValue("period", (Object)new Long[]{((DynamicObject)periodMembers.get(0)).getLong("id")});
        }
    }

    private void fillMultiPeriodMember(DynamicObjectCollection reportTypeList) {
        Optional<DynamicObject> findFirst = reportTypeList.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(reportType -> EmptyUtil.isNotEmpty((CharSequence)reportType.getString("orgreporttype"))).findFirst();
        this.getView().setEnable(Boolean.valueOf(findFirst.isPresent()), new String[]{"containdetailreporttype"});
        this.getModel().setValue("containdetailreporttype", (Object)Boolean.FALSE);
        TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"period"});
        DynamicObject plainSystem = (DynamicObject)this.getModel().getValue("bodysystem");
        if (plainSystem == null) {
            return;
        }
        Date current = new Date();
        QFilter filter = new QFilter("bodysystem", "=", plainSystem.getPkValue());
        filter.and("startdate", "<=", (Object)current);
        filter.and("enddate", ">=", (Object)current);
        if (reportTypeList.size() == 0) {
            return;
        }
        QFilter reportTypeQFilter = null;
        for (DynamicObject reportType2 : reportTypeList) {
            if (reportTypeQFilter == null) {
                reportTypeQFilter = this.getReportTypeQFilter(reportType2.getDynamicObject("fbasedataid"));
                continue;
            }
            reportTypeQFilter.or(this.getReportTypeQFilter(reportType2.getDynamicObject("fbasedataid")));
        }
        filter.and(reportTypeQFilter);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_member", (QFilter[])new QFilter[]{filter}, null, (int)-1);
        if (EmptyUtil.isNoEmpty((Object)ids)) {
            this.getModel().setValue("period", (Object)ids.toArray());
        }
    }

    private void presetDimensionVisible() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"company"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"settlementmethod"});
        DynamicObject template = (DynamicObject)this.getModel().getValue("analysistemplate");
        if (Objects.isNull(template)) {
            return;
        }
        DynamicObjectCollection dimSetting = template.getDynamicObjectCollection("dimsettingentry");
        Optional<DynamicObject> visibleCompany = dimSetting.stream().filter(dO -> DimensionType.COMPANY.getNumber().equals(dO.getString("dimbd.number")) && !dO.getBoolean("ishide") && dO.getBoolean("dimfilterdim")).findFirst();
        Optional<DynamicObject> visibleSettlement = dimSetting.stream().filter(dO -> DimensionType.SETTLEMENT_TYPE.getNumber().equals(dO.getString("dimbd.number")) && !dO.getBoolean("ishide") && dO.getBoolean("dimfilterdim")).findFirst();
        this.getView().setVisible(Boolean.valueOf(visibleCompany.isPresent()), new String[]{"company"});
        this.getView().setVisible(Boolean.valueOf(visibleSettlement.isPresent()), new String[]{"settlementmethod"});
    }

    private void presetReportCurrency(DynamicObject bodySystem) {
        QFilter qFilter = new QFilter("sourceid", "=", bodySystem.getDynamicObject("currency").getPkValue());
        qFilter.and(new QFilter("bodysystem", "=", bodySystem.getPkValue()));
        qFilter.and(new QFilter("dimtype", "=", (Object)DimensionType.CURRENCY.getNumber()));
        DynamicObject targetCurrency = QueryServiceHelper.queryOne((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{qFilter});
        this.getModel().setValue("reportcurrency", Optional.ofNullable(targetCurrency).map(o -> o.getLong("id")).orElse(null));
    }

    private void presetMetricMemberAndDimFilter() {
        DynamicObject analysisTplDO = (DynamicObject)this.getModel().getValue("analysistemplate");
        if (analysisTplDO == null) {
            this.getModel().setValue("metricmember", null);
            return;
        }
        Object[] metricIds = analysisTplDO.getDynamicObjectCollection("metricentry").stream().filter(dynamicObject -> dynamicObject.getBoolean("dffilter")).map(dynamicObject -> dynamicObject.getDynamicObject("newmetrictype")).map(DataEntityBase::getPkValue).toArray();
        this.getModel().setValue("metricmember", (Object)metricIds);
        DynamicObjectCollection dimSetting = analysisTplDO.getDynamicObjectCollection("dimsettingentry");
        for (DynamicObject dimDO : dimSetting) {
            String number = dimDO.getString("dimbd.number");
            if (!dimDO.getBoolean("dimfilterdim") || !DIMENSION_CONTROL_MAP.containsKey(number)) continue;
            Object[] objects = dimDO.getDynamicObjectCollection("defaultfilter").stream().map(item -> item.getDynamicObject("fbasedataid")).map(item -> (Long)item.getPkValue()).toArray();
            this.getModel().setValue(DIMENSION_CONTROL_MAP.get(number), (Object)objects);
        }
    }

    private IAnalysisReportManageController getOrCreateReportController() {
        if (null == this.controller) {
            this.controller = new AnalysisReportManageController((IAnalysisReportManageView)this);
        }
        return this.controller;
    }

    private boolean getAnalysisHeader(ReportQueryParam reportQueryParam, AnalysisHeader header) {
        Map<String, Object> filterItemMap;
        if (Objects.isNull(reportQueryParam)) {
            reportQueryParam = ReportCacheManager.getInstance().getCache().getReportQueryParam(this.getView().getPageId());
        }
        if (!this.checkBeforeSearch(filterItemMap = reportQueryParam.getFilter().getFilterItems().stream().filter(o -> o.getValue() != null).collect(Collectors.toMap(FilterItemInfo::getPropName, FilterItemInfo::getValue, (a, b) -> a)))) {
            return false;
        }
        this.warpHeader(filterItemMap, header);
        return true;
    }

    private void warpHeader(Map<String, Object> filterItemMap, AnalysisHeader header) {
        DynamicObject bodySystem = (DynamicObject)filterItemMap.get("bodysystem");
        DynamicObject analysisTemplate = (DynamicObject)filterItemMap.get("analysistemplate");
        DynamicObjectCollection reportType = (DynamicObjectCollection)filterItemMap.get("reporttype");
        DynamicObject reportTypeSingle = (DynamicObject)filterItemMap.get("reporttypesingle");
        DynamicObjectCollection periods = (DynamicObjectCollection)filterItemMap.get("period");
        DynamicObject reportCurrency = (DynamicObject)filterItemMap.get("reportcurrency");
        DynamicObjectCollection organisations = (DynamicObjectCollection)filterItemMap.get("org");
        DynamicObjectCollection companies = (DynamicObjectCollection)filterItemMap.get("company");
        DynamicObjectCollection settlements = (DynamicObjectCollection)filterItemMap.get("settlementmethod");
        DynamicObjectCollection subjects = (DynamicObjectCollection)filterItemMap.get("subjects");
        DynamicObjectCollection currency = (DynamicObjectCollection)filterItemMap.get("currency");
        DynamicObjectCollection metricMember = (DynamicObjectCollection)filterItemMap.get("metricmember");
        String internalOffsetState = (String)filterItemMap.get("internaloffsetstate");
        boolean isContainDetailReport = (Boolean)filterItemMap.get("containdetailreporttype");
        boolean distinctCurrency = (Boolean)filterItemMap.get("distinctcurrency");
        String amountUnit = (String)this.getModel().getValue("amountunit");
        String planStatus = (String)filterItemMap.get("planstatus");
        String billStatus = (String)filterItemMap.get("billstatus");
        header.setBodySystemId(Long.valueOf(bodySystem.getLong("id")));
        header.setAnalysisTemplateId(Long.valueOf(analysisTemplate.getLong("id")));
        if (this.isFix(analysisTemplate)) {
            List reportTypeIdList = reportType.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setReportTypeIdList(reportTypeIdList);
        } else {
            header.getReportTypeIdList().add(reportTypeSingle.getLong("id"));
        }
        List periodIds = periods.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        header.setPeriodId(periodIds);
        header.setContainDetailReportType(isContainDetailReport);
        if (Objects.nonNull(organisations)) {
            List orgIds = organisations.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setOrg(orgIds);
        }
        if (Objects.nonNull(subjects)) {
            List subjectsIds = subjects.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setSubjects(subjectsIds);
        }
        if (Objects.nonNull(currency)) {
            List currencyIds = currency.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setCurrency(currencyIds);
        }
        if (Objects.nonNull(companies)) {
            List companyIds = companies.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setCompany(companyIds);
        }
        if (Objects.nonNull(settlements)) {
            List settlementIds = settlements.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setSettlementMethod(settlementIds);
        }
        if (Objects.nonNull(reportCurrency) && this.isFix(analysisTemplate)) {
            header.setReportCurrency(Long.valueOf(reportCurrency.getLong("id")));
        }
        List metricIds = metricMember.stream().map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toList());
        header.setMetricIds(metricIds);
        header.setDisplaycurrency(distinctCurrency);
        header.setAmountUnit(AmountUnit.getByNumber((String)amountUnit));
        header.setCustomDimension(this.handleCustomHeader(filterItemMap));
        header.setInternalOffsetState(internalOffsetState);
        header.setBillStateList(Arrays.stream(billStatus.split(",")).filter(StringUtils::isNotEmpty).map(c -> (BillState)ITypeEnum.getByNumber((String)c, BillState.class)).collect(Collectors.toList()));
        header.setReportStatusList(Arrays.stream(planStatus.split(",")).filter(StringUtils::isNotEmpty).map(ReportStatus::getByVal).collect(Collectors.toList()));
    }

    private boolean checkBeforeSearch(Map<String, Object> filterItemMap) {
        DynamicObjectCollection currencyList;
        DynamicObjectCollection dimSetting;
        Optional<DynamicObject> pageOrgExist;
        DynamicObject template = (DynamicObject)this.getModel().getValue("analysistemplate");
        if (Objects.isNull(template)) {
            String templateFiled = (String)SynthesisReportProp.MUST_INPUT_SIGN_MAP.get("analysistemplate");
            String err = String.format(ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u3010%s\u3011\u4e0d\u80fd\u4e3a\u7a7a", (String)"SynthesisQueryReportPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), templateFiled);
            this.showErrMessage(Collections.singletonList(err));
            return false;
        }
        if (!this.isFix(template)) {
            SynthesisReportProp.MUST_INPUT_SIGN_MAP.remove("reportcurrency");
            SynthesisReportProp.MUST_INPUT_SIGN_MAP.remove("reporttype");
            if (!SynthesisReportProp.MUST_INPUT_SIGN_MAP.containsKey("reporttypesingle")) {
                SynthesisReportProp.MUST_INPUT_SIGN_MAP.put("reporttypesingle", ResManager.loadKDString((String)"\u7f16\u62a5\u7c7b\u578b", (String)"SynthesisReportProp_2", (String)"tmc-fpm-common", (Object[])new Object[0]));
            }
        } else {
            SynthesisReportProp.MUST_INPUT_SIGN_MAP.remove("reporttypesingle");
            if (!SynthesisReportProp.MUST_INPUT_SIGN_MAP.containsKey("reportcurrency")) {
                SynthesisReportProp.MUST_INPUT_SIGN_MAP.put("reportcurrency", ResManager.loadKDString((String)"\u62a5\u544a\u5e01\u79cd", (String)"SynthesisReportProp_5", (String)"tmc-fpm-common", (Object[])new Object[0]));
            }
            if (!SynthesisReportProp.MUST_INPUT_SIGN_MAP.containsKey("reporttype")) {
                SynthesisReportProp.MUST_INPUT_SIGN_MAP.put("reporttype", ResManager.loadKDString((String)"\u7f16\u62a5\u7c7b\u578b", (String)"SynthesisReportProp_2", (String)"tmc-fpm-common", (Object[])new Object[0]));
            }
        }
        if ((pageOrgExist = (dimSetting = template.getDynamicObjectCollection("dimsettingentry")).stream().filter(dO -> DimLocation.PAGE.getNumber().equals(dO.getString("type")) && DimensionType.ORG.getNumber().equals(dO.getString("dimbd.number"))).findFirst()).isPresent()) {
            SynthesisReportProp.MUST_INPUT_SIGN_MAP.remove("org");
        } else if (!SynthesisReportProp.MUST_INPUT_SIGN_MAP.containsKey("org")) {
            SynthesisReportProp.MUST_INPUT_SIGN_MAP.put("org", ResManager.loadKDString((String)"\u7f16\u62a5\u4e3b\u4f53", (String)"SynthesisReportProp_4", (String)"tmc-fpm-common", (Object[])new Object[0]));
        }
        ArrayList errMsg = new ArrayList(10);
        for (Map.Entry entry : SynthesisReportProp.MUST_INPUT_SIGN_MAP.entrySet()) {
            Object obj = filterItemMap.get(entry.getKey());
            if (obj != null) continue;
            errMsg.add(entry.getValue());
        }
        if (errMsg.size() != 0) {
            String err = String.format(ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u3010%s\u3011\u4e0d\u80fd\u4e3a\u7a7a", (String)"SynthesisQueryReportPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", errMsg));
            this.showErrMessage(Collections.singletonList(err));
            return false;
        }
        Optional<DynamicObject> pageCurrencyExist = dimSetting.stream().filter(dO -> DimLocation.PAGE.getNumber().equals(dO.getString("type")) && DimensionType.CURRENCY.getNumber().equals(dO.getString("dimbd.number"))).findFirst();
        if (!this.isFix(template) && pageCurrencyExist.isPresent() && ((currencyList = (DynamicObjectCollection)filterItemMap.get("currency")) == null || currencyList.size() > 1)) {
            String err = String.format(ResManager.loadKDString((String)"\u6309\u660e\u7ec6\u6a21\u677f\u67e5\u8be2\uff0c\u5e01\u79cd\u4f5c\u4e3a\u9875\u9762\u8fc7\u6ee4\u6761\u4ef6\u65f6\u4ec5\u652f\u6301\u5355\u9009\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"SynthesisQueryReportPlugin_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", errMsg));
            this.showErrMessage(Collections.singletonList(err));
            return false;
        }
        DynamicObjectCollection subjects = (DynamicObjectCollection)filterItemMap.get("subjects");
        DynamicObject bodySystem = (DynamicObject)filterItemMap.get("bodysystem");
        DynamicObjectCollection organisations = (DynamicObjectCollection)filterItemMap.get("org");
        int orgCount = organisations == null ? 1 : organisations.size();
        int subjectCount = 1;
        if (subjects == null || subjects.size() < 1) {
            QFilter tQFilter = new QFilter("bodysysmanage", "=", bodySystem.getPkValue());
            tQFilter.and("dimtype", "=", (Object)DimensionType.SUBJECTS.getNumber());
            DynamicObjectCollection tSubjectIds = QueryServiceHelper.query((String)"fpm_membersubject", (String)"id", (QFilter[])new QFilter[]{tQFilter});
            if (Objects.nonNull(tSubjectIds)) {
                subjectCount = tSubjectIds.size();
            }
        } else {
            subjectCount = subjects.size();
        }
        if (orgCount * subjectCount > 10000) {
            String err = ResManager.loadKDString((String)"\u6240\u9700\u67e5\u8be2\u6570\u636e\u91cf\u884c\u6570\uff08\u7f16\u62a5\u4e3b\u4f53\u6210\u5458\u6570*\u8ba1\u5212\u79d1\u76ee\u6210\u5458\u6570\uff09\u4e0d\u53ef\u5927\u4e8e%s\u884c\uff1b\u8bf7\u68c0\u67e5\u201c\u7f16\u62a5\u4e3b\u4f53\u201d\u6216\u201c\u8ba1\u5212\u79d1\u76ee\u201d\u8fc7\u6ee4\u6761\u4ef6\uff0c\u51cf\u5c11\u9700\u67e5\u8be2\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u3002", (String)"SynthesisQueryReportPlugin_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.showErrMessage(Collections.singletonList(String.format(err, 10000)));
            return false;
        }
        return this.checkPeriodCount(filterItemMap, template);
    }

    private boolean checkPeriodCount(Map<String, Object> filterItemMap, DynamicObject template) {
        Map<Long, Long> periodCountMap = ((DynamicObjectCollection)filterItemMap.get("period")).stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("reporttype.id"), Collectors.counting()));
        Map<Object, Object> reportTypeMap = new HashMap<Long, DynamicObject>(4);
        if (this.isFix(template)) {
            reportTypeMap = ((DynamicObjectCollection)filterItemMap.get("reporttype")).stream().collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        } else {
            DynamicObject reportType = (DynamicObject)filterItemMap.get("reporttypesingle");
            reportTypeMap.put(reportType.getLong("id"), reportType);
        }
        for (Map.Entry<Long, Long> entry : periodCountMap.entrySet()) {
            Long reportTypeId = entry.getKey();
            Long count = entry.getValue();
            DynamicObject reportType = (DynamicObject)reportTypeMap.get(reportTypeId);
            PeriodType periodType = PeriodType.getByNumber((String)reportType.getString("orgreportcycle"));
            if (periodType == null) continue;
            switch (periodType) {
                case YEAR: 
                case HALF_YEAR: 
                case QUARTER: 
                case MONTH: {
                    if (count <= 12L) break;
                    this.showPeriodCheckErrMessage(reportType, 12);
                    return false;
                }
                case TEN_DAY: {
                    if (count <= 9L) break;
                    this.showPeriodCheckErrMessage(reportType, 9);
                    return false;
                }
                case MONTH_WEEK: 
                case YEAR_WEEK: {
                    if (count <= 15L) break;
                    this.showPeriodCheckErrMessage(reportType, 15);
                    return false;
                }
                case DAY: {
                    if (count <= 30L) break;
                    this.showPeriodCheckErrMessage(reportType, 30);
                    return false;
                }
            }
        }
        return true;
    }

    private void showPeriodCheckErrMessage(DynamicObject reportType, int count) {
        String err = ResManager.loadKDString((String)"\u671f\u95f4\u6210\u5458\u9009\u62e9\u5df2\u8d85\u51fa\u3010%1$s\u3011\u7684\u6700\u5927\u7684\u671f\u95f4\u6c47\u603b\u6570\u91cf\uff08%2$s\u671f\uff09\uff0c\u8bf7\u786e\u8ba4\u9700\u6c47\u603b\u7edf\u8ba1\u7684\u7f16\u62a5\u671f\u95f4\u8303\u56f4\u3002", (String)"SynthesisQueryReportPlugin_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        this.showErrMessage(Collections.singletonList(String.format(err, reportType.getString("name"), count)));
    }

    private HashMap<String, List<Long>> handleCustomHeader(Map<String, Object> filterItemMap) {
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>(SynthesisReportProp.CUSTOMER_SIGN_LIST.size());
        for (String keySign : SynthesisReportProp.CUSTOMER_SIGN_LIST) {
            DynamicObjectCollection custom = (DynamicObjectCollection)filterItemMap.get(keySign);
            if (CollectionUtils.isEmpty((Collection)custom)) continue;
            DynamicObject dimension = (DynamicObject)((DynamicObject)custom.get(0)).get("dimension");
            List memberIds = custom.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            result.put(dimension.getString("number"), memberIds);
        }
        return result;
    }

    private void presetCustomDimensionVisible() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"custommember1", "custommember2", "custommember3"});
        DynamicObject template = (DynamicObject)this.getModel().getValue("analysistemplate");
        if (Objects.isNull(template)) {
            return;
        }
        DynamicObjectCollection dimSetting = template.getDynamicObjectCollection("dimsettingentry");
        this.getView().setVisible(Boolean.TRUE, new String[]{"custommember1", "custommember2", "custommember3"});
        DynamicObject bodySystem = (DynamicObject)this.getModel().getValue("bodysystem");
        if (bodySystem == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"custommember1", "custommember2", "custommember3"});
            return;
        }
        String selectProp = "id,number,basedata,memberfrom,relbasedata";
        DynamicObject[] customDimension = BusinessDataServiceHelper.load((String)"fpm_dimension", (String)selectProp, (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", bodySystem.getPkValue()), new QFilter("basedata", "=", (Object)DimsionEnums.CUSTOM.getNumber())});
        if (customDimension.length <= 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"custommember1", "custommember2", "custommember3"});
            return;
        }
        HashMap<String, Dimension> customControlDimensionMap = new HashMap<String, Dimension>(3);
        int index = 1;
        for (DynamicObject dynamicObject : customDimension) {
            String number = dynamicObject.getString("number");
            Optional<DynamicObject> find = dimSetting.stream().filter(dO -> number.equals(dO.getString("dimbd.number")) && !dO.getBoolean("ishide") && dO.getBoolean("dimfilterdim")).findFirst();
            if (!find.isPresent()) continue;
            String customName = "custommember" + index;
            Dimension dimension = new Dimension();
            dimension.setBaseDataType(dynamicObject.getString("basedata"));
            dimension.setName(dynamicObject.getString("name"));
            dimension.setId(Long.valueOf(dynamicObject.getLong("id")));
            BasedataEdit baseDataEdit = (BasedataEdit)this.getControl(customName);
            baseDataEdit.setCaption(new LocaleString(dimension.getName()));
            customControlDimensionMap.put(customName, dimension);
            Object[] objects = find.get().getDynamicObjectCollection("defaultfilter").stream().map(item -> item.getDynamicObject("fbasedataid")).map(item -> (Long)item.getPkValue()).toArray();
            this.getModel().setValue(customName, (Object)objects);
            ++index;
        }
        for (int i = index; i < 4; ++i) {
            String customName = "custommember" + i;
            this.getView().setVisible(Boolean.FALSE, new String[]{customName});
            this.getModel().setValue(customName, null);
        }
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"CACHE_CUSTOMER_CONTROL_DIMENSION_MAP", customControlDimensionMap);
    }

    private List<Integer> getEmptyValRows() {
        return FpmPageCacheHelper.getCacheDatas((IFormView)this.getView(), (String)"emptyRows", Integer.class);
    }

    private void changeBillStatusDownBox(boolean needCleanStatus) {
        Object value = this.getModel().getValue("planstatus");
        MulComboEdit billStatus = (MulComboEdit)this.getControl("billstatus");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        Object template = this.getModel().getValue("analysistemplate");
        if (Objects.isNull(template)) {
            return;
        }
        String billStatusInTemplate = ((DynamicObject)template).getString("queryablebs");
        if (needCleanStatus) {
            this.getModel().setValue("billstatus", (Object)BillState.AUDITED.getNumber());
        }
        if (value == null || StringUtils.isEmpty((CharSequence)billStatusInTemplate)) {
            return;
        }
        String strVal = (String)value;
        if (StringUtils.isEmpty((CharSequence)strVal)) {
            return;
        }
        Set statusSet = Arrays.stream(strVal.split(",")).map(ReportStatus::getByVal).collect(Collectors.toSet());
        boolean hasDisableOrBack = statusSet.stream().anyMatch(item -> ReportStatus.DISABLE == item || ReportStatus.BEBACK == item);
        if (hasDisableOrBack) {
            comboItemList.add(new ComboItem(new LocaleString(BillState.STAGE.getName()), BillState.STAGE.getNumber()));
            comboItemList.add(new ComboItem(new LocaleString(BillState.COMMITTED.getName()), BillState.COMMITTED.getNumber()));
        }
        comboItemList.add(new ComboItem(new LocaleString(BillState.AUDITED.getName()), BillState.AUDITED.getNumber()));
        billStatus.setComboItems(comboItemList);
    }

    private void presetStatusDownBox(boolean needResetValue) {
        Object template = this.getModel().getValue("analysistemplate");
        ComboEdit planStatus = (ComboEdit)this.getControl("planstatus");
        ComboEdit billStatus = (ComboEdit)this.getControl("billstatus");
        String defaultPlanStatus = null;
        String defaultBillStatus = null;
        ArrayList<ComboItem> billStatusComboItemList = new ArrayList<ComboItem>();
        ArrayList<ComboItem> planStatusComboItemList = new ArrayList<ComboItem>();
        if (Objects.isNull(template)) {
            planStatus.setComboItems(billStatusComboItemList);
            billStatus.setComboItems(planStatusComboItemList);
            return;
        }
        String planStatusInTemplate = ((DynamicObject)template).getString("queryablerpts");
        String billStatusInTemplate = ((DynamicObject)template).getString("queryablebs");
        if (StringUtils.isEmpty((CharSequence)planStatusInTemplate) || StringUtils.isEmpty((CharSequence)billStatusInTemplate)) {
            planStatus.setComboItems(billStatusComboItemList);
            billStatus.setComboItems(planStatusComboItemList);
            return;
        }
        for (String p : planStatusInTemplate.split(",")) {
            ReportStatus reportStatus;
            if (!StringUtils.isNotEmpty((CharSequence)p) || (reportStatus = ReportStatus.getByVal((String)p)) == null) continue;
            planStatusComboItemList.add(new ComboItem(new LocaleString(reportStatus.getName()), reportStatus.getVal()));
            if (reportStatus != ReportStatus.ENABLE) continue;
            defaultPlanStatus = p;
        }
        for (String p : billStatusInTemplate.split(",")) {
            BillState billState;
            if (!StringUtils.isNotEmpty((CharSequence)p) || (billState = (BillState)ITypeEnum.getByNumber((String)p, BillState.class)) == null) continue;
            billStatusComboItemList.add(new ComboItem(new LocaleString(billState.getName()), billState.getNumber()));
            if (billState != BillState.AUDITED) continue;
            defaultBillStatus = p;
        }
        planStatus.setComboItems(planStatusComboItemList);
        billStatus.setComboItems(billStatusComboItemList);
        if (needResetValue) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"planstatus", defaultPlanStatus == null ? ((ComboItem)planStatusComboItemList.get(0)).getValue() : defaultPlanStatus);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"billstatus", defaultBillStatus == null ? ((ComboItem)billStatusComboItemList.get(0)).getValue() : defaultBillStatus);
        }
    }

    private void changeVisibleOfInnerState() {
        DynamicObject template = (DynamicObject)this.getModel().getValue("analysistemplate");
        if (Objects.isNull(template)) {
            return;
        }
        String regex = "^[,B]+$";
        String planStatus = (String)this.getModel().getValue("planstatus");
        if (this.isFix(template) && StringUtils.isNotEmpty((CharSequence)planStatus) && planStatus.matches(regex)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"internaloffsetstate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"internaloffsetstate"});
        }
    }

    protected String getSpreadKey() {
        return "spreadap";
    }

    public IPageCache getCache() {
        return this.getView().getPageCache();
    }

    public void initAnalysisTpl(ReportTemplate template) {
    }

    private boolean isFix(DynamicObject analysisTemplate) {
        return "FIX".equals(analysisTemplate.getString("templatetype"));
    }

    private void tipSelectedInvalidMetricIfNeed(DynamicObjectCollection selectedMetricMemberDyColl) {
        List metricMemberIds = selectedMetricMemberDyColl.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toList());
        boolean nonExistBaseMetricTypeIfAnalyseMetricNeed = TemplateInfoHelper.nonExistBaseMetricTypeIfAnalyseMetricNeed(metricMemberIds);
        if (nonExistBaseMetricTypeIfAnalyseMetricNeed) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u6307\u6807\u4e2d\u82e5\u542b\u8ba1\u7b97\u7c7b\u7684\u6307\u6807\u6210\u5458\uff0c\u9700\u8981\u5c06\u5bf9\u5e94\u7684\u8ba1\u7b97\u56e0\u5b50\u57fa\u7840\u5ea6\u91cf\u4e5f\u9009\u62e9\u4e0a\u3002", (String)"SynthesisQueryReportPlugin_10", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
    }

    public String getPageId() {
        return this.getView().getPageId();
    }

    public void linkSearchExecRecord(SpreadEvent spreadEvent) {
        List<Map<Long, ReportCalcVal>> selectedColDimList;
        List<Map<Long, ReportCalcVal>> selectedRowDimList;
        if (!this.checkSelectedDataBeforeLinkSearch()) {
            return;
        }
        ReportShowParameter formShowParameter = new ReportShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("fpm_linkexecrecord");
        Map<String, Object> filterItemMap = this.loadFilterItemMapCache();
        Long systemId = ((DynamicObject)filterItemMap.get("bodysystem")).getLong("id");
        formShowParameter.setCustomParam("bodysystem", (Object)systemId);
        DynamicObject analysisTemplate = (DynamicObject)filterItemMap.get("analysistemplate");
        boolean isFix = this.isFix(analysisTemplate);
        if (isFix) {
            selectedRowDimList = this.getFixTemplateSelectedDim4LinkSearch(this.getCellDS().getMeta(), true, (FormShowParameter)formShowParameter);
            selectedColDimList = this.getFixTemplateSelectedDim4LinkSearch(this.getCellDS().getMeta(), false, (FormShowParameter)formShowParameter);
        } else {
            selectedRowDimList = this.getDetailTempSelectedDim4LinkSearch(this.getCellDS().getMeta(), true);
            selectedColDimList = this.getDetailTempSelectedDim4LinkSearch(this.getCellDS().getMeta(), false);
        }
        formShowParameter.setCustomParam("org", new ArrayList<Long>(this.getSelectedDimValSet(DimensionType.ORG, selectedRowDimList, selectedColDimList)));
        Set<Long> periodIdSet = this.getSelectedDimValSet(DimensionType.PERIOD, selectedRowDimList, selectedColDimList);
        formShowParameter.setCustomParam("period", new ArrayList<Long>(periodIdSet));
        DynamicObjectCollection periodDyColl = (DynamicObjectCollection)filterItemMap.get("period");
        Long reportTypeId = this.getSelectedReportTypeId(isFix, periodDyColl, periodIdSet);
        formShowParameter.setCustomParam("reporttype", (Object)reportTypeId);
        formShowParameter.setCustomParam("amountunit", (Object)this.getModel().getDataEntity().getString("amountunit"));
        formShowParameter.setCustomParam("planqueryscope", (Object)(this.isFix(analysisTemplate) ? TemplateType.FIXED.getNumber() : TemplateType.DETAIL.getNumber()));
        formShowParameter.setCustomParam("pageDimMemberIds", this.getPageDimMemberIds(filterItemMap));
        formShowParameter.setCustomParam("selectedRowDimList", selectedRowDimList);
        formShowParameter.setCustomParam("selectedColDimList", selectedColDimList);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private CellDataSource getCellDS() {
        this.cellDS = this.cellDS == null ? new CellDataSource((IFpmPageCacheService)new FpmPageCacheService(this.getPageId())) : this.cellDS;
        return this.cellDS;
    }

    public Map<String, Object> loadFilterItemMapCache() {
        ReportQueryParam reportQueryParam = ReportCacheManager.getInstance().getCache().getReportQueryParam(this.getView().getPageId());
        return reportQueryParam.getFilter().getFilterItems().stream().filter(o -> o.getValue() != null).collect(Collectors.toMap(FilterItemInfo::getPropName, FilterItemInfo::getValue, (a, b) -> a));
    }

    private boolean checkSelectedDataBeforeLinkSearch() {
        Map detailReportPerRowMainDimValMap;
        Optional dataStartRowOpt;
        boolean isDetail;
        IntPredicate selectedRemarkColPredicate;
        IntPredicate selectedSummaryColPredicate;
        List colDimAllMemberList;
        SpreadSelector spreadSelector = this.getSpreadSelector();
        int selectedStartRow = spreadSelector.getStartRow();
        String tips = ResManager.loadKDString((String)"\u8054\u67e5\u5931\u8d25\uff0c\u4e00\u6b21\u6700\u591a\u53ef\u652f\u6301\u9009\u62e910\u4e2a\u5355\u5143\u683c\u6570\u503c\u8fdb\u884c\u8054\u67e5\u6267\u884c\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u67e5\u8be2\u8303\u56f4\u3002", (String)"ReportLinkExecRecordPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        if (!this.validateSelectedDataCellSize(tips, 10)) {
            return false;
        }
        tips = ResManager.loadKDString((String)"\u8054\u67e5\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u201c\u8ba1\u5212\u989d\u5ea6\u3001\u9884\u5360\u7528\u989d\u5ea6\u3001\u5df2\u6267\u884c\u989d\u5ea6\u201d\u57fa\u7840\u5ea6\u91cf\u4e0b\u975e\u5c0f\u8ba1\u7684\u6570\u503c\u64cd\u4f5c\u8054\u67e5\u6267\u884c\u8bb0\u5f55\u3002", (String)"ReportLinkExecRecordPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        CacheCellMeta cacheCellMeta = this.getCellDS().getMeta();
        if (Objects.isNull(cacheCellMeta)) {
            this.getView().showTipNotification(tips);
            return false;
        }
        Map<String, Object> filterItemMap = this.loadFilterItemMapCache();
        boolean noneCover = this.isCoverBaseMetrics(filterItemMap, cacheCellMeta, colDimAllMemberList = cacheCellMeta.getColDimTree().getRoot().getAllChildren());
        if (noneCover) {
            this.getView().showTipNotification(tips);
            return false;
        }
        ReportCalcTree rowDimTree = this.getCellDS().getMeta().getRowDimTree();
        List rowDimAllMemberList = Objects.nonNull(rowDimTree) ? rowDimTree.getRoot().getAllChildren() : new ArrayList(0);
        IntPredicate selectedSummaryRowPredicate = ReportHelper.getSummaryRowPredicate(rowDimAllMemberList);
        if (!this.validateSelectedDataCell(tips, selectedSummaryRowPredicate, (selectedSummaryColPredicate = ReportHelper.getSummaryColPredicate((List)colDimAllMemberList)).or(selectedRemarkColPredicate = ReportHelper.getRemarkColPredicate((List)colDimAllMemberList)))) {
            return false;
        }
        DynamicObject analysisTemplate = (DynamicObject)filterItemMap.get("analysistemplate");
        boolean bl = isDetail = !this.isFix(analysisTemplate);
        if (isDetail && (dataStartRowOpt = (detailReportPerRowMainDimValMap = (Map)FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"cache:detailreport:perrow:maindimval:map", Map.class)).keySet().stream().min(Integer::compareTo)).isPresent() && selectedStartRow < (Integer)dataStartRowOpt.get()) {
            this.getView().showTipNotification(tips);
            return false;
        }
        if (!this.validateSelectedMultiplyReportType(filterItemMap, cacheCellMeta)) {
            tips = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u540c\u65f6\u9009\u62e9\u591a\u4e2a\u4e0d\u540c\u671f\u95f4\u7c7b\u578b\u7684\u6570\u636e\u8fdb\u884c\u8054\u67e5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u67e5\u8be2\u8303\u56f4\u3002", (String)"FPM-E-262512", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            return false;
        }
        return true;
    }

    private boolean isCoverBaseMetrics(Map<String, Object> filterItemMap, CacheCellMeta cacheCellMeta, List<ReportCalcValTreeNode> colDimAllMemberList) {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        int selectedStartCol = spreadSelector.getStartCol();
        int selectedEndCol = spreadSelector.getEndCol();
        int selectedStartRow = spreadSelector.getStartRow();
        int selectedEndRow = spreadSelector.getEndRow();
        HashSet metricTypeSet = Sets.newHashSet((Object[])new String[]{TemplateMetricType.PLANAMT.getCode(), TemplateMetricType.LOCKAMT.getCode(), TemplateMetricType.ACTMAT.getCode()});
        Set metricIdSet = ((DynamicObjectCollection)filterItemMap.get("metricmember")).stream().filter(dy -> metricTypeSet.contains(dy.getString("metricpresettype"))).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        HashSet metricColSet = new HashSet(2, 1.0f);
        colDimAllMemberList.stream().map(ReportCalcValTreeNode::getCalcVal).filter(calcVal -> EmptyUtil.isNoEmpty((Object)calcVal.getValue())).filter(calcVal -> metricIdSet.contains(calcVal.getValue())).forEach(calcVal -> IntStream.rangeClosed(calcVal.getStartCol(), calcVal.getEndCol()).forEach(metricColSet::add));
        boolean noneCover = selectedStartRow < cacheCellMeta.getRowOffSet() || selectedEndRow > cacheCellMeta.getMaxRow();
        noneCover = noneCover || IntStream.rangeClosed(selectedStartCol, selectedEndCol).anyMatch(col -> !metricColSet.contains(col));
        return noneCover;
    }

    private boolean validateSelectedDataCell(String msg, IntPredicate rowPredicate, IntPredicate colPredicate) {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        for (int i = spreadSelector.getStartRow(); i <= spreadSelector.getEndRow(); ++i) {
            for (int j = spreadSelector.getStartCol(); j <= spreadSelector.getEndCol(); ++j) {
                if (!rowPredicate.test(i) && !colPredicate.test(j)) continue;
                this.getView().showTipNotification(msg);
                return false;
            }
        }
        return true;
    }

    private boolean validateSelectedDataCellSize(String tipSupplier, int maxSelectedSize) {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        int selectedCellSize = (spreadSelector.getEndRow() - spreadSelector.getStartRow() + 1) * (spreadSelector.getEndCol() - spreadSelector.getStartCol() + 1);
        if (selectedCellSize > maxSelectedSize) {
            this.getView().showTipNotification(tipSupplier);
            return false;
        }
        return true;
    }

    private boolean validateSelectedMultiplyReportType(Map<String, Object> filterItemMap, CacheCellMeta cacheCellMeta) {
        DynamicObjectCollection periodDyColl = (DynamicObjectCollection)filterItemMap.get("period");
        Set reportTypeIdSet = periodDyColl.stream().map(dy -> dy.getLong("reporttype.id")).collect(Collectors.toSet());
        if (reportTypeIdSet.size() <= 1) {
            return true;
        }
        Long periodDimId = periodDyColl.stream().map(dy -> dy.getLong("dimension.id")).findAny().get();
        DynamicObject analysisTemplate = (DynamicObject)filterItemMap.get("analysistemplate");
        DynamicObjectCollection dimSettingEntry = analysisTemplate.getDynamicObjectCollection("dimsettingentry");
        DynamicObject periodDimSettingDy = dimSettingEntry.stream().filter(dy -> Objects.equals(dy.getLong("dim"), periodDimId)).findAny().get();
        String periodDimLocation = periodDimSettingDy.getString("type");
        if (Objects.equals(periodDimLocation, DimLocation.PAGE.getNumber()) || Objects.equals(periodDimLocation, "filter")) {
            return false;
        }
        Map<Long, Long> periodId2ReportTypeMap = periodDyColl.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("reporttype.id"), (a, b) -> a));
        List<Map<Long, ReportCalcVal>> selectedDimList = Objects.equals(periodDimLocation, DimLocation.ROW.getNumber()) ? this.getFixTemplateSelectedDim4LinkSearch(cacheCellMeta, true, this.getView().getFormShowParameter()) : this.getFixTemplateSelectedDim4LinkSearch(cacheCellMeta, false, this.getView().getFormShowParameter());
        Set selectedReportTypeIdSet = selectedDimList.stream().map(Map::values).flatMap(Collection::stream).filter(Objects::nonNull).filter(calcVal -> Objects.equals(calcVal.getDimensionId(), periodDimId)).map(ReportCalcVal::getValue).filter(periodId2ReportTypeMap::containsKey).map(periodId2ReportTypeMap::get).collect(Collectors.toSet());
        return selectedReportTypeIdSet.size() <= 1;
    }

    private Map<Long, String> loadPageDimId2TypeMap() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject analysisTemplate = dataEntity.getDynamicObject("analysistemplate");
        DynamicObjectCollection dimSettingEntry = analysisTemplate.getDynamicObjectCollection("dimsettingentry");
        return dimSettingEntry.stream().filter(setting -> Objects.equals(setting.getString("dimbdtype"), "fpm_dimension")).filter(setting -> Objects.equals(setting.getString("type"), DimLocation.PAGE.getNumber()) || Objects.equals(setting.getString("type"), "filter")).filter(setting -> !setting.getBoolean("ishide")).collect(Collectors.toMap(key -> key.getLong("dim"), val -> val.getString("dimbd.number"), (a, b) -> a));
    }

    private DimLocation getDimLocation(DimensionType dimensionType) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject analysisTemplate = dataEntity.getDynamicObject("analysistemplate");
        DynamicObjectCollection dimSettingEntry = analysisTemplate.getDynamicObjectCollection("dimsettingentry");
        Optional<String> locationOpt = dimSettingEntry.stream().filter(setting -> Objects.equals(setting.getString("dimbdtype"), "fpm_dimension")).filter(setting -> !setting.getBoolean("ishide")).filter(setting -> Objects.equals(setting.getString("dimbd.number"), dimensionType.getNumber())).map(setting -> setting.getString("type")).findAny();
        if (!locationOpt.isPresent() || Objects.equals(locationOpt.get(), "filter")) {
            return DimLocation.PAGE;
        }
        return DimLocation.getByNumber((String)locationOpt.get());
    }

    private Long getDimIdByTemplate(DimensionType dimensionType) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject analysisTemplate = dataEntity.getDynamicObject("analysistemplate");
        DynamicObjectCollection dimSettingEntry = analysisTemplate.getDynamicObjectCollection("dimsettingentry");
        Optional<Long> dimIdOpt = dimSettingEntry.stream().filter(setting -> Objects.equals(setting.getString("dimbdtype"), "fpm_dimension")).filter(setting -> Objects.equals(setting.getString("dimbd.number"), dimensionType.getNumber())).map(setting -> setting.getLong("dim")).findAny();
        return dimIdOpt.orElseGet(() -> null);
    }

    private List<Map<Long, ReportCalcVal>> getFixTemplateSelectedDim4LinkSearch(CacheCellMeta meta, boolean isRowDim, FormShowParameter formShowParameter) {
        int b2;
        SpreadSelector spreadSelector = this.getSpreadSelector();
        LinkedList<Map<Long, ReportCalcVal>> selectedDimNodeList = new LinkedList<Map<Long, ReportCalcVal>>();
        HashMap<Long, Integer> selectedDimIdxMap = new HashMap<Long, Integer>(4);
        HashMap<Long, Boolean> dimIncludeSumMap = new HashMap<Long, Boolean>(4);
        boolean containDetailReportType = false;
        LinkedList queue = new LinkedList();
        int b1 = isRowDim ? spreadSelector.getStartRow() : spreadSelector.getStartCol();
        int n = b2 = isRowDim ? spreadSelector.getEndRow() : spreadSelector.getEndCol();
        if (isRowDim) {
            queue.addAll(meta.getRowDimTree().getRoot().getChildren());
        } else {
            queue.addAll(meta.getColDimTree().getRoot().getChildren());
        }
        while (!queue.isEmpty()) {
            int size = queue.size();
            Map<Object, Object> dimMemberMap = new HashMap(4);
            boolean includeSum = false;
            ReportCalcValTreeNode parentNode = ((ReportCalcValTreeNode)queue.peek()).getParent();
            for (int i = 0; i < size; ++i) {
                int a2;
                ReportCalcValTreeNode curr = (ReportCalcValTreeNode)queue.poll();
                int a1 = isRowDim ? curr.getCalcVal().getStartRow() : curr.getCalcVal().getStartCol();
                int n2 = a2 = isRowDim ? curr.getCalcVal().getEndRow() : curr.getCalcVal().getEndCol();
                if (b2 < a1 || b1 > a2 || curr.getCalcVal().isReferenceCell()) continue;
                if (!CollectionUtils.isEmpty((Collection)curr.getChildren())) {
                    queue.addAll(curr.getChildren());
                }
                if (Objects.isNull(curr.getCalcVal().getValue()) && curr.getCalcVal().isSummary()) {
                    includeSum = true;
                    continue;
                }
                if (!Objects.nonNull(curr.getCalcVal().getValue())) continue;
                dimMemberMap.putIfAbsent((Long)curr.getCalcVal().getValue(), curr.getCalcVal());
            }
            if (CollectionUtils.isEmpty(dimMemberMap) && includeSum) {
                dimMemberMap = parentNode.getChildren().stream().filter(node -> !node.getCalcVal().isReferenceCell()).filter(node -> Objects.nonNull(node.getCalcVal().getValue())).collect(Collectors.toMap(key -> (Long)key.getCalcVal().getValue(), ReportCalcValTreeNode::getCalcVal));
            }
            if (CollectionUtils.isEmpty(dimMemberMap)) continue;
            Long dimensionId = ((ReportCalcVal)dimMemberMap.values().stream().findAny().get()).getDimensionId();
            if (Objects.nonNull(selectedDimIdxMap.get(dimensionId))) {
                containDetailReportType = true;
            } else {
                selectedDimNodeList.add(dimMemberMap);
                selectedDimIdxMap.forEach((k, v) -> selectedDimIdxMap.put((Long)k, (Integer)selectedDimIdxMap.get(k) + 1));
                selectedDimIdxMap.put(dimensionId, 0);
            }
            dimIncludeSumMap.put(dimensionId, includeSum);
        }
        Map existDimIncludeSumMap = (Map)formShowParameter.getCustomParam("dimIncludeSumMap");
        if (Objects.isNull(existDimIncludeSumMap)) {
            formShowParameter.setCustomParam("dimIncludeSumMap", dimIncludeSumMap);
        } else {
            existDimIncludeSumMap.putAll(dimIncludeSumMap);
            formShowParameter.setCustomParam("dimIncludeSumMap", (Object)existDimIncludeSumMap);
        }
        if (!isRowDim) {
            formShowParameter.setCustomParam("containdetailreporttype", (Object)containDetailReportType);
        }
        return selectedDimNodeList;
    }

    private List<Map<Long, ReportCalcVal>> getDetailTempSelectedDim4LinkSearch(CacheCellMeta meta, boolean isRowDim) {
        if (isRowDim) {
            return new LinkedList<Map<Long, ReportCalcVal>>();
        }
        SpreadSelector spreadSelector = this.getSpreadSelector();
        LinkedList<Map<Long, ReportCalcVal>> selectedDimNodeList = new LinkedList<Map<Long, ReportCalcVal>>();
        List colDimAllMemberList = meta.getColDimTree().getRoot().getAllChildren();
        Map<String, Object> filterItemMap = this.loadFilterItemMapCache();
        DynamicObject analysisTemplate = (DynamicObject)filterItemMap.get("analysistemplate");
        DynamicObjectCollection dimSettingEntry = analysisTemplate.getDynamicObjectCollection("dimsettingentry");
        Set dimIdSet = dimSettingEntry.stream().filter(setting -> Objects.equals(setting.getString("dimbdtype"), "fpm_dimension")).map(setting -> setting.getLong("dim")).collect(Collectors.toSet());
        Map detailReportPerRowMainDimValMap = (Map)FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"cache:detailreport:perrow:maindimval:map", Map.class);
        int dimValIdx = 0;
        for (ReportCalcValTreeNode calcValTreeNode : colDimAllMemberList) {
            if (Objects.isNull(calcValTreeNode.getCalcVal()) || Objects.isNull(calcValTreeNode.getCalcVal().getDimensionId()) || !dimIdSet.contains(calcValTreeNode.getCalcVal().getDimensionId())) continue;
            HashMap<Long, ReportCalcVal> dimMemberMap = new HashMap<Long, ReportCalcVal>(4);
            for (int i = spreadSelector.getStartRow(); i <= spreadSelector.getEndRow(); ++i) {
                if (!detailReportPerRowMainDimValMap.containsKey(i) || ((List)detailReportPerRowMainDimValMap.get(i)).isEmpty()) continue;
                Long dimVal = (Long)((List)detailReportPerRowMainDimValMap.get(i)).get(dimValIdx);
                ReportCalcVal reportCalcVal = new ReportCalcVal();
                reportCalcVal.setDimensionId(calcValTreeNode.getCalcVal().getDimensionId());
                reportCalcVal.setValue((Object)dimVal);
                dimMemberMap.put(dimVal, reportCalcVal);
            }
            ++dimValIdx;
            selectedDimNodeList.add(dimMemberMap);
        }
        return selectedDimNodeList;
    }

    private List<Long> getPageDimMemberIds(Map<String, Object> filterItemMap) {
        ArrayList<Long> pageDimMemberIds = new ArrayList<Long>(10);
        Map<Long, String> pageDimId2TypeMap = this.loadPageDimId2TypeMap();
        Map customControlDimensionMap = (Map)FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"CACHE_CUSTOMER_CONTROL_DIMENSION_MAP", Map.class);
        pageDimId2TypeMap.forEach((dimId, dimType) -> {
            DynamicObjectCollection pageDimMemberDyColl;
            String prop = null;
            if (DIMENSION_CONTROL_MAP.containsKey(dimType)) {
                prop = DIMENSION_CONTROL_MAP.get(dimType);
            } else {
                for (Map.Entry customControlEntry : customControlDimensionMap.entrySet()) {
                    Dimension customDim = (Dimension)customControlEntry.getValue();
                    if (!Objects.equals(dimId, customDim.getId())) continue;
                    prop = (String)customControlEntry.getKey();
                    break;
                }
            }
            if (Objects.nonNull(prop) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(pageDimMemberDyColl = (DynamicObjectCollection)filterItemMap.get(prop)))) {
                pageDimMemberDyColl.stream().map(dy -> dy.getLong("id")).forEach(pageDimMemberIds::add);
            }
        });
        return pageDimMemberIds;
    }

    private Set<Long> getSelectedDimValSet(DimensionType dimensionType, List<Map<Long, ReportCalcVal>> selectedRowDimList, List<Map<Long, ReportCalcVal>> selectedColDimList) {
        DynamicObject reportTypeDy;
        boolean isDetail;
        if (dimensionType.isCustomDim()) {
            return new HashSet<Long>(0);
        }
        Map<String, Object> filterItemMap = this.loadFilterItemMapCache();
        DimLocation dimLocation = this.getDimLocation(dimensionType);
        Long systemId = ((DynamicObject)filterItemMap.get("bodysystem")).getLong("id");
        if (dimLocation == DimLocation.PAGE) {
            DynamicObjectCollection dimMemberDyColl = (DynamicObjectCollection)filterItemMap.get(DIMENSION_CONTROL_MAP.get(dimensionType.getNumber()));
            if (EmptyUtil.isEmpty((DynamicObjectCollection)dimMemberDyColl) && dimensionType == DimensionType.ORG) {
                return this.loadDefaultOrgIds(systemId);
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)dimMemberDyColl)) {
                QFilter qFilter = new QFilter("bodysystem", "=", (Object)systemId).and("dimtype", "=", (Object)dimensionType.getNumber()).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
                List allMemberIds = QueryServiceHelper.queryPrimaryKeys((String)"fpm_member", (QFilter[])qFilter.toArray(), null, (int)-1);
                return allMemberIds.stream().map(o -> (Long)o).collect(Collectors.toSet());
            }
            return dimMemberDyColl.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        }
        Long dimId = this.getDimIdByTemplate(dimensionType);
        List<Map<Long, ReportCalcVal>> selectedDimList = dimLocation == DimLocation.ROW ? selectedRowDimList : selectedColDimList;
        Set<Long> selectedDimValSet = selectedDimList.stream().map(Map::values).flatMap(Collection::stream).filter(Objects::nonNull).filter(calcVal -> Objects.equals(calcVal.getDimensionId(), dimId)).map(ReportCalcVal::getValue).map(o -> (Long)o).collect(Collectors.toSet());
        DynamicObject analysisTemplate = (DynamicObject)filterItemMap.get("analysistemplate");
        boolean bl = isDetail = !this.isFix(analysisTemplate);
        if (dimensionType == DimensionType.PERIOD && isDetail && EmptyUtil.isNoEmpty((String)(reportTypeDy = (DynamicObject)filterItemMap.get("reporttypesingle")).getString("orgreporttype"))) {
            QFilter qFilter = new QFilter("bodysystem", "=", (Object)systemId).and("dimension", "=", (Object)dimId).and("dimtype", "=", (Object)DimensionType.PERIOD.getNumber());
            DynamicObjectCollection allMemberDyColl = QueryServiceHelper.query((String)"fpm_member", (String)String.join((CharSequence)",", "id", "parent.id", "enable"), (QFilter[])qFilter.toArray());
            Map dimMemberMap = allMemberDyColl.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (a, b) -> a));
            HashSet<Long> parentIdSet = new HashSet<Long>(selectedDimValSet.size());
            for (Long memberId : selectedDimValSet) {
                DynamicObject dimMember = (DynamicObject)dimMemberMap.get(memberId);
                Long parentId = dimMember.getLong("parent.id");
                if (EmptyUtil.isNoEmpty((Long)parentId) && dimMemberMap.containsKey(parentId)) {
                    parentIdSet.add(parentId);
                    continue;
                }
                parentIdSet.add(memberId);
            }
            return parentIdSet;
        }
        return selectedDimValSet;
    }

    private Set<Long> loadDefaultOrgIds(Long systemId) {
        QFilter qFilter = new QFilter("bodysystem", "=", (Object)systemId).and("dimtype", "=", (Object)DimensionType.ORG.getNumber());
        DynamicObjectCollection allMemberDyColl = QueryServiceHelper.query((String)"fpm_member", (String)String.join((CharSequence)",", "id", "parent.id", "enable"), (QFilter[])qFilter.toArray());
        Map dimMemberMap = allMemberDyColl.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (a, b) -> a));
        List authOrgList = ModelHelper.getOrgAuthScope((String)"fpm", (String)"fpm_synthesisquery");
        Set memberScope = authOrgList.stream().filter(dimMemberMap::containsKey).map(dimMemberMap::get).filter(dy -> Objects.equals(dy.getString("enable"), BaseEnableEnum.ENABLE.getValue())).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        HashSet<Long> parentIdSet = new HashSet<Long>(memberScope.size());
        for (Long memberId : memberScope) {
            DynamicObject dimMember = (DynamicObject)dimMemberMap.get(memberId);
            Long parentId = dimMember.getLong("parent.id");
            DynamicObject currentExist = dimMember;
            while (EmptyUtil.isNoEmpty((Long)parentId) && dimMemberMap.containsKey(parentId)) {
                DynamicObject parent = (DynamicObject)dimMemberMap.get(parentId);
                if (memberScope.contains(parentId)) {
                    currentExist = parent;
                }
                parentId = parent.getLong("parent.id");
            }
            Long topIdFormMemberScope = currentExist.getLong("id");
            parentIdSet.add(topIdFormMemberScope);
        }
        return parentIdSet;
    }

    private Long getSelectedReportTypeId(boolean isFixTemplate, DynamicObjectCollection periodDyCollInFilterItem, Set<Long> selectedPeriodIdSet) {
        Map<Long, Long> periodId2ReportTypeMap = periodDyCollInFilterItem.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("reporttype.id"), (a, b) -> a));
        if (isFixTemplate) {
            return selectedPeriodIdSet.stream().map(periodId2ReportTypeMap::get).findAny().get();
        }
        return periodId2ReportTypeMap.values().stream().findAny().get();
    }

    public void linkSearchAnalyseReport(SpreadEvent spreadEvent) {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        int selectedStartCol = spreadSelector.getStartCol();
        int selectedEndCol = spreadSelector.getEndCol();
        int selectedStartRow = spreadSelector.getStartRow();
        int selectedEndRow = spreadSelector.getEndRow();
        Map<Integer, Set<Integer>> currentColRows = this.getCurrentColRows(spreadSelector);
        if (currentColRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u6570\u636e\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5355\u5143\u683c\u3002", (String)"ReportPlanSumPlugin_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> filterItemMap = this.loadFilterItemMapCache();
        CacheCellMeta cacheCellMeta = this.getCellDS().getMeta();
        if (cacheCellMeta == null) {
            return;
        }
        List colDimAllMemberList = cacheCellMeta.getColDimTree().getRoot().getAllChildren();
        ReportCalcTree rowDimTree = this.getCellDS().getMeta().getRowDimTree();
        List rowDimAllMemberList = Objects.nonNull(rowDimTree) ? rowDimTree.getRoot().getAllChildren() : new ArrayList(0);
        IntPredicate selectedSummaryRowPredicate = ReportHelper.getSummaryRowPredicate(rowDimAllMemberList);
        IntPredicate selectedSummaryColPredicate = ReportHelper.getSummaryColPredicate((List)colDimAllMemberList);
        IntPredicate selectedRemarkColPredicate = ReportHelper.getRemarkColPredicate((List)colDimAllMemberList);
        boolean onlySelectSummary = false;
        block0: for (int i2 = spreadSelector.getStartRow(); i2 <= spreadSelector.getEndRow(); ++i2) {
            for (int j = spreadSelector.getStartCol(); j <= spreadSelector.getEndCol(); ++j) {
                if (!selectedSummaryRowPredicate.test(i2) && !selectedSummaryColPredicate.or(selectedRemarkColPredicate).test(j)) {
                    onlySelectSummary = false;
                    continue block0;
                }
                onlySelectSummary = true;
            }
        }
        if (onlySelectSummary) {
            String tips = ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u542b\u201c\u8ba1\u5212\u989d\u5ea6\u3001\u9884\u5360\u7528\u989d\u5ea6\u3001\u5df2\u6267\u884c\u989d\u5ea6\u201d\u57fa\u7840\u5ea6\u91cf\u5728\u5185\u7684\u975e\u5c0f\u8ba1\u7684\u6570\u503c\u64cd\u4f5c\u591a\u7ef4\u67e5\u8be2\u5206\u6790\u3002", (String)"ReportLinkExecRecordPlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            return;
        }
        HashSet metricTypeSet = Sets.newHashSet((Object[])new String[]{TemplateMetricType.PLANAMT.getCode(), TemplateMetricType.LOCKAMT.getCode(), TemplateMetricType.ACTMAT.getCode()});
        Set metricIdSet = ((DynamicObjectCollection)filterItemMap.get("metricmember")).stream().filter(dy -> metricTypeSet.contains(dy.getString("metricpresettype"))).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        HashSet metricColSet = new HashSet(2, 1.0f);
        colDimAllMemberList.stream().map(ReportCalcValTreeNode::getCalcVal).filter(calcVal -> EmptyUtil.isNoEmpty((Object)calcVal.getValue())).filter(i -> !selectedSummaryColPredicate.or(selectedRemarkColPredicate).test(i.getCol())).filter(calcVal -> metricIdSet.contains(calcVal.getValue())).forEach(calcVal -> IntStream.rangeClosed(calcVal.getStartCol(), calcVal.getEndCol()).forEach(metricColSet::add));
        boolean noneDateCell = selectedStartRow < cacheCellMeta.getRowOffSet() || selectedEndRow > cacheCellMeta.getMaxRow();
        boolean noneCover = IntStream.rangeClosed(selectedStartCol, selectedEndCol).noneMatch(metricColSet::contains);
        if (noneDateCell || noneCover) {
            String tips = ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u542b\u201c\u8ba1\u5212\u989d\u5ea6\u3001\u9884\u5360\u7528\u989d\u5ea6\u3001\u5df2\u6267\u884c\u989d\u5ea6\u201d\u57fa\u7840\u5ea6\u91cf\u5728\u5185\u7684\u975e\u5c0f\u8ba1\u7684\u6570\u503c\u64cd\u4f5c\u591a\u7ef4\u67e5\u8be2\u5206\u6790\u3002", (String)"ReportLinkExecRecordPlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            return;
        }
        if (selectedEndRow - selectedStartRow > 0) {
            String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u884c\u7684\u8fde\u7eed\u5355\u5143\u683c\u8fdb\u884c\u67e5\u8be2\u5206\u6790\u3002", (String)"ReportLinkExecRecordPlugin_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            return;
        }
        if (!this.validateSelectedMultiplyReportType(filterItemMap, cacheCellMeta)) {
            String tips = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u540c\u65f6\u9009\u62e9\u591a\u4e2a\u4e0d\u540c\u671f\u95f4\u7c7b\u578b\u7684\u6570\u636e\u8fdb\u884c\u8054\u67e5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u67e5\u8be2\u8303\u56f4\u3002", (String)"FPM-E-262512", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            return;
        }
        ReportShowParameter formShowParameter = new ReportShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("fpm_linkanalysereport");
        List<Map<Long, ReportCalcVal>> selectedRowDimList = this.getFixTemplateSelectedDim4LinkSearch(this.getCellDS().getMeta(), true, (FormShowParameter)formShowParameter);
        List<Map<Long, ReportCalcVal>> selectedColDimList = this.getFixTemplateSelectedDim4LinkSearch(this.getCellDS().getMeta(), false, (FormShowParameter)formShowParameter);
        formShowParameter.setCustomParam("selectedRowDimList", selectedRowDimList);
        formShowParameter.setCustomParam("selectedColDimList", selectedColDimList);
        Map<Long, List<Long>> filterDimMemberIds = this.getFilterDimMemberIds();
        formShowParameter.setCustomParam("filterDimMemberIds", filterDimMemberIds);
        this.handleCaptionAndOrgParam((FormShowParameter)formShowParameter, selectedRowDimList, selectedColDimList, filterDimMemberIds);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        formShowParameter.setCustomParam("bodysystem", dataEntity.getDynamicObject("bodysystem").getPkValue());
        Set<Long> periodIdSet = this.getSelectedDimValSet(DimensionType.PERIOD, selectedRowDimList, selectedColDimList);
        DynamicObjectCollection periodDyColl = (DynamicObjectCollection)filterItemMap.get("period");
        Long reportTypeId = this.getSelectedReportTypeId(true, periodDyColl, periodIdSet);
        formShowParameter.setCustomParam("reporttype", (Object)reportTypeId);
        formShowParameter.setCustomParam("period", periodIdSet);
        formShowParameter.setCustomParam("amountunit", this.getModel().getValue("amountunit"));
        DynamicObject exRateTableDy = (DynamicObject)this.getView().getModel().getValue("exratetable");
        Optional.ofNullable(exRateTableDy).ifPresent(arg_0 -> SynthesisQueryReportPlugin.lambda$linkSearchAnalyseReport$96((FormShowParameter)formShowParameter, exRateTableDy, arg_0));
        Date exchangeRateDate = (Date)this.getView().getModel().getValue("exchangeratedate");
        Optional.ofNullable(exchangeRateDate).ifPresent(arg_0 -> SynthesisQueryReportPlugin.lambda$linkSearchAnalyseReport$97((FormShowParameter)formShowParameter, exchangeRateDate, arg_0));
        boolean containDetailReportType = (Boolean)filterItemMap.get("containdetailreporttype");
        formShowParameter.setCustomParam("containdetailreporttype", (Object)containDetailReportType);
        DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("reportcurrency");
        formShowParameter.setCustomParam("reportcurrency", currencyObj.getPkValue());
        boolean displayCurrency = (Boolean)this.getModel().getValue("distinctcurrency");
        formShowParameter.setCustomParam("distinctcurrency", (Object)displayCurrency);
        DynamicObjectCollection metricMember = (DynamicObjectCollection)this.getModel().getValue("metricmember");
        List metricIds = metricMember.stream().map(i -> i.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        formShowParameter.setCustomParam("metric", (Object)metricIds.toArray());
        formShowParameter.setCustomParam("parenttype", (Object)AnalysisReportType.SYNTHESIS.getNumber());
        String innerOffsetStatus = (String)this.getModel().getValue("internaloffsetstate");
        formShowParameter.setCustomParam("internaloffsetstate", (Object)innerOffsetStatus);
        String planStatus = (String)this.getModel().getValue("planstatus");
        formShowParameter.setCustomParam("planstatus", (Object)planStatus);
        String billStatus = (String)this.getModel().getValue("billstatus");
        formShowParameter.setCustomParam("billstatus", (Object)billStatus);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void handleCaptionAndOrgParam(FormShowParameter formShowParameter, List<Map<Long, ReportCalcVal>> selectedRowDimList, List<Map<Long, ReportCalcVal>> selectedColDimList, Map<Long, List<Long>> filterDimMemberIds) {
        String orgName = "";
        DynamicObjectCollection reportOrgColl = (DynamicObjectCollection)this.getModel().getValue("org");
        if (CollectionUtils.isEmpty((Collection)reportOrgColl)) {
            String jsonKey = String.format("%s_analysereportdatamanager_cache", AnalysisReportType.SYNTHESIS.getNumber());
            String parentManagerJson = this.getView().getPageCache().get(jsonKey);
            ReportDataManagerV2 manager = (ReportDataManagerV2)FpmSerializeUtil.deserialize((String)parentManagerJson, ReportDataManagerV2.class);
            FundPlanSystem system = manager.getSystem();
            List orgIds = ModelHelper.getOrgAuthScopeWithCheckManager((String)"fpm", (String)"fpm_synthesisquery");
            HashSet orgIdSet = new HashSet(orgIds);
            Dimension orgDim = system.getMainDimensionByDimType(DimensionType.ORG);
            List authOrgList = orgDim.getAllDimMemberList().stream().filter(i -> orgIdSet.contains(i.getId())).sorted(Comparator.comparing(DimMember::getSortCode)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(authOrgList)) {
                DimMember topLevelOrg = (DimMember)orgDim.getMemberList().get(0);
                orgName = topLevelOrg.getName();
                List<Long> orgMemberValList = Collections.singletonList(topLevelOrg.getId());
                String caption = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5206\u6790-%1$s", (String)"ReportPlanSummaryPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), orgName);
                formShowParameter.setCaption(caption);
                formShowParameter.setCustomParam("org", orgMemberValList);
                return;
            }
            Integer minLevel = authOrgList.stream().map(DimMember::getLevel).min(Comparator.comparing(i -> i)).orElse(0);
            Map<Integer, List<DimMember>> authOrgMap = authOrgList.stream().collect(Collectors.groupingBy(DimMember::getLevel));
            List<Object> dimMembers = authOrgMap.get(minLevel);
            dimMembers = dimMembers.stream().sorted(Comparator.comparing(DimMember::getSortCode)).collect(Collectors.toList());
            DimMember member = (DimMember)dimMembers.get(0);
            orgName = member.getName();
            List orgMemberValList = dimMembers.stream().map(DimMember::getId).collect(Collectors.toList());
            String caption = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5206\u6790-%1$s", (String)"ReportPlanSummaryPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), orgName);
            formShowParameter.setCaption(caption);
            formShowParameter.setCustomParam("org", orgMemberValList);
            return;
        }
        Map reportOrgMap = reportOrgColl.stream().map(i -> i.getDynamicObject("fbasedataid")).collect(Collectors.toMap(k -> k.getLong("id"), Function.identity(), (a, b) -> a));
        Long dimId = ((DynamicObject)reportOrgColl.get(0)).getDynamicObject("fbasedataid").getLong("dimension.id");
        List<Object> orgMemberValList = selectedRowDimList.stream().map(Map::values).flatMap(Collection::stream).filter(obj -> dimId.compareTo(obj.getDimensionId()) == 0).map(obj -> (Long)obj.getValue()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(orgMemberValList)) {
            DynamicObject targetOrg = (DynamicObject)reportOrgMap.get(orgMemberValList.get(0));
            orgName = targetOrg.getString("name");
            String caption = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5206\u6790-%1$s", (String)"ReportPlanSummaryPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), orgName);
            formShowParameter.setCaption(caption);
            formShowParameter.setCustomParam("org", orgMemberValList);
            return;
        }
        orgMemberValList = selectedColDimList.stream().map(Map::values).flatMap(Collection::stream).filter(obj -> dimId.compareTo(obj.getDimensionId()) == 0).map(obj -> (Long)obj.getValue()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orgMemberValList)) {
            orgMemberValList = filterDimMemberIds.get(dimId);
        }
        HashSet orgSet = new HashSet(orgMemberValList);
        Integer minLevel = reportOrgColl.stream().filter(i -> orgSet.contains(i.getDynamicObject("fbasedataid").getLong("id"))).map(i -> i.getDynamicObject("fbasedataid").getInt("level")).min(Comparator.comparing(i -> i)).orElse(0);
        Map<Integer, List<DynamicObject>> selectLevelMemberMap = reportOrgColl.stream().map(i -> i.getDynamicObject("fbasedataid")).filter(i -> orgSet.contains(i.getLong("id"))).sorted(Comparator.comparing(i -> i.getString("sortcode"))).collect(Collectors.groupingBy(i -> i.getInt("level")));
        List<DynamicObject> minLevelOrgList = selectLevelMemberMap.get(minLevel);
        DynamicObject targetOrg = minLevelOrgList.get(0);
        orgName = targetOrg.getString("name");
        String caption = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5206\u6790-%1$s", (String)"ReportPlanSummaryPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), orgName);
        formShowParameter.setCaption(caption);
        formShowParameter.setCustomParam("org", orgMemberValList);
    }

    private Map<Long, List<Long>> getFilterDimMemberIds() {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(8);
        Map<Long, List<Long>> orgMap = this.getMultiBaseMemberId("org");
        result.putAll(orgMap);
        Map<Long, List<Long>> subjectMap = this.getMultiBaseMemberId("subjects");
        result.putAll(subjectMap);
        Map<Long, List<Long>> currencyMap = this.getMultiBaseMemberId("currency");
        result.putAll(currencyMap);
        Map<Long, List<Long>> companyMap = this.getMultiBaseMemberId("company");
        result.putAll(companyMap);
        Map<Long, List<Long>> settleMap = this.getMultiBaseMemberId("settlementmethod");
        result.putAll(settleMap);
        Map<Long, List<Long>> customOneMap = this.getMultiBaseMemberId("custommember1");
        Map<Long, List<Long>> customTwoMap = this.getMultiBaseMemberId("custommember2");
        Map<Long, List<Long>> customThreeMap = this.getMultiBaseMemberId("custommember3");
        result.putAll(customOneMap);
        result.putAll(customTwoMap);
        result.putAll(customThreeMap);
        return result;
    }

    private Map<Long, List<Long>> getMultiBaseMemberId(String colName) {
        DynamicObjectCollection memberColl = (DynamicObjectCollection)this.getModel().getValue(colName);
        if (CollectionUtils.isEmpty((Collection)memberColl)) {
            return new HashMap<Long, List<Long>>(1);
        }
        return memberColl.stream().map(i -> i.getDynamicObject("fbasedataid")).collect(Collectors.groupingBy(i -> i.getLong("dimension.id"), Collectors.mapping(i -> i.getLong("id"), Collectors.toList())));
    }

    private Map<Integer, Set<Integer>> getCurrentColRows(SpreadSelector spreadSelector) {
        int startRow = spreadSelector.getStartRow();
        int endRow = spreadSelector.getEndRow();
        int startCol = spreadSelector.getStartCol();
        int endCol = spreadSelector.getEndCol();
        HashMap<Integer, Set<Integer>> colRows = new HashMap<Integer, Set<Integer>>(4);
        for (int i = startCol; i <= endCol; ++i) {
            Set rows = colRows.computeIfAbsent(i, key -> new HashSet(8));
            for (int j = startRow; j <= endRow; ++j) {
                rows.add(j);
            }
        }
        return colRows;
    }

    private static /* synthetic */ void lambda$linkSearchAnalyseReport$97(FormShowParameter formShowParameter, Date exchangeRateDate, Date date) {
        formShowParameter.setCustomParam("exchangeratedate", (Object)exchangeRateDate);
    }

    private static /* synthetic */ void lambda$linkSearchAnalyseReport$96(FormShowParameter formShowParameter, DynamicObject exRateTableDy, DynamicObject dy) {
        formShowParameter.setCustomParam("exratetable", exRateTableDy.getPkValue());
    }

    static /* synthetic */ boolean access$000(SynthesisQueryReportPlugin x0, String x1) {
        return x0.checkBeforeBuildF7Filter(x1);
    }

    static /* synthetic */ IDataModel access$100(SynthesisQueryReportPlugin x0) {
        return x0.getModel();
    }

    static /* synthetic */ IDataModel access$200(SynthesisQueryReportPlugin x0) {
        return x0.getModel();
    }

    static /* synthetic */ IDataModel access$300(SynthesisQueryReportPlugin x0) {
        return x0.getModel();
    }

    static /* synthetic */ boolean access$400(SynthesisQueryReportPlugin x0, DynamicObject x1) {
        return x0.isFix(x1);
    }

    static /* synthetic */ IDataModel access$500(SynthesisQueryReportPlugin x0) {
        return x0.getModel();
    }

    static /* synthetic */ QFilter access$600(SynthesisQueryReportPlugin x0, DynamicObject x1) {
        return x0.getReportTypeQFilter(x1);
    }

    static /* synthetic */ IDataModel access$700(SynthesisQueryReportPlugin x0) {
        return x0.getModel();
    }
}

