/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.cache.data;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.cache.data.CacheBlock;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CacheCellMeta;
import kd.tmc.fpm.business.cache.serialize.CacheBlockSerializer;
import kd.tmc.fpm.business.cache.serialize.DirtySetSerializer;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.spread.widget.core.Cell;

public class CellDataSource {
    private static final Log logger = LogFactory.getLog(CellDataSource.class);
    private IFpmPageCacheService cache;
    private List<CacheBlock> cacheList;
    private BitSet dirtySet;
    private CacheCellMeta meta;
    private boolean isInit;
    private static final int MAX_BLOCK_CNT = 5;

    public CellDataSource(IFpmPageCacheService cache) {
        this.cache = cache;
        this.cacheList = new ArrayList<CacheBlock>(16);
    }

    public List<Long> getDeletedDataIdList() {
        String deleteListStr = this.cache.get("deleteList");
        List<Long> prevIdList = deleteListStr == null || deleteListStr.trim().length() == 0 ? new ArrayList<Long>() : JSON.parseArray((String)deleteListStr, Long.class);
        return prevIdList;
    }

    public void addDeletedDataIdList(List<Long> idList) {
        List<Long> prevIdList = this.getDeletedDataIdList();
        prevIdList.addAll(idList);
        this.cache.put("deleteList", JSON.toJSONString(prevIdList));
    }

    public void saveMeta(List<Cell> cellList, List<String> cachePropList, ReportCalcModel calcModel) {
        this.meta = this.buildMeta(cellList, cachePropList, calcModel);
        this.cacheMeta();
    }

    public void saveAll(List<Cell> cellList, List<String> cachePropList, ReportCalcModel calcModel) {
        this.saveAll(cellList, cachePropList, calcModel, Boolean.TRUE);
    }

    public void saveAll(List<Cell> cellList, List<String> cachePropList, ReportCalcModel calcModel, boolean isFillDirtySet) {
        cellList = new ArrayList<Cell>(cellList);
        ArrayList<CacheCell> dirtyCellList = new ArrayList<CacheCell>();
        cellList.sort(Comparator.comparingInt(Cell::getRow).thenComparingInt(Cell::getCol));
        this.meta = this.buildMeta(cellList, cachePropList, calcModel);
        this.cacheMeta();
        int blockCnt = this.meta.getBlockCnt();
        this.cacheList = new ArrayList<CacheBlock>(blockCnt);
        int dataIndex = 0;
        int zeroCnt = 0;
        for (int i = 0; i < blockCnt; ++i) {
            CacheBlock block = new CacheBlock();
            this.cacheList.add(block);
            int blockSize = i == blockCnt - 1 ? this.meta.getDataCnt() - dataIndex : this.meta.getDataCnt() / blockCnt;
            block.setCellList(new ArrayList(blockSize));
            block.setStart(dataIndex);
            while (block.getCellList().size() < blockSize) {
                Cell cell = cellList.get(dataIndex - zeroCnt);
                int index = this.getDataIndex(cell.getRow(), cell.getCol());
                if (dataIndex < index) {
                    block.getCellList().add(null);
                    ++zeroCnt;
                } else {
                    CacheCell cacheCell = this.buildCacheCell(cell);
                    block.getCellList().add(cacheCell);
                    if (cell.isInitDirty()) {
                        cacheCell.setRow(cell.getRow());
                        cacheCell.setCol(cell.getCol());
                        dirtyCellList.add(cacheCell);
                    }
                }
                ++dataIndex;
            }
            block.setEnd(dataIndex - 1);
        }
        this.cacheData(this.cacheList);
        this.dirtySet = new BitSet(this.meta.getDataCnt());
        if (isFillDirtySet) {
            this.fillDirtySet(dirtyCellList.toArray(new CacheCell[0]));
        }
        this.cacheDirtySet();
    }

    public List<CacheCell> getAllCell() {
        int blockCnt = this.getMeta().getBlockCnt();
        for (int i = 0; i < blockCnt; ++i) {
            this.getCacheBlock(i);
        }
        LinkedList<CacheCell> cellList = new LinkedList<CacheCell>();
        for (CacheBlock block : this.cacheList) {
            int dataIdx = block.getStart();
            for (CacheCell cell : block.getCellList()) {
                int[] rowCol = this.getRowColInfo(dataIdx++);
                cell.setRow(rowCol[0]);
                cell.setCol(rowCol[1]);
            }
            cellList.addAll(block.getCellList());
        }
        return cellList;
    }

    public void clearDirtySet() {
        BitSet dirtySet = this.getDirtySet();
        dirtySet.clear();
        this.cacheDirtySet();
    }

    public void clearAllDirtySet() {
        this.clearDirtySet();
        this.cacheDistDirtySet();
    }

    public CacheCell getCell(int row, int col) {
        this.checkInit();
        CacheBlock cacheBlock = this.getCacheBlock(row, col);
        int start = cacheBlock.getStart();
        int dataIndex = this.getDataIndex(row, col);
        int range = dataIndex - start;
        if (range >= cacheBlock.getCellList().size() || range < 0) {
            return null;
        }
        CacheCell cell = (CacheCell)cacheBlock.getCellList().get(dataIndex - start);
        cell.setRow(row);
        cell.setCol(col);
        return cell;
    }

    public boolean checkBounds(int row, int col) {
        CacheCellMeta meta = this.getMeta();
        if (col < meta.getColOffSet() || col > meta.getMaxCol()) {
            return false;
        }
        return row >= meta.getRowOffSet() && row <= meta.getMaxRow();
    }

    public void updateCellAndClearDirty(List<CacheCell> cellList) {
        this.checkInit();
        this.cacheCells(cellList);
        this.clearDirtySet();
    }

    public void updateCell(List<CacheCell> cellList) {
        this.checkInit();
        this.fillDirtySet(cellList.toArray(new CacheCell[0]));
        this.cacheCells(cellList);
        this.cacheDirtySet();
    }

    private void cacheCells(List<CacheCell> cellList) {
        HashSet<CacheBlock> blockSet = new HashSet<CacheBlock>(this.meta.getBlockCnt());
        Map rowNonEmptyValMap = this.meta.getRowNonEmptyValMap();
        for (CacheCell cell : cellList) {
            int row = cell.getRow();
            int col = cell.getCol();
            int dataIndex = this.getDataIndex(row, col);
            CacheBlock block = this.getCacheBlock(row, col);
            block.getCellList().set(dataIndex - block.getStart(), cell);
            blockSet.add(block);
            Set cols = rowNonEmptyValMap.computeIfAbsent(row, c -> new HashSet(this.meta.getColLen() - this.meta.getColOffSet()));
            if (EmptyUtil.isEmpty((Object)cell.getValue())) {
                cols.remove(col);
                continue;
            }
            cols.add(col);
        }
        this.cacheData(new ArrayList<CacheBlock>(blockSet));
        this.cacheMeta();
    }

    private void cacheMeta() {
        this.cache.put(this.getMetaKey(), FpmSerializeUtil.serialize((Object)this.meta));
    }

    private void cacheData(List<CacheBlock> cacheList) {
        CacheBlockSerializer serializer = new CacheBlockSerializer(this.meta);
        for (CacheBlock block : cacheList) {
            int blockIdx = this.cacheList.indexOf(block);
            this.cache.put(this.getBlockCacheKey(blockIdx), serializer.serialize(block));
        }
    }

    private void cacheDirtySet() {
        this.cache.put(this.getDirtySetKey(), new DirtySetSerializer().serialize(this.dirtySet));
    }

    private void cacheDistDirtySet() {
        String value = this.dirtySet.isEmpty() ? "" : new DirtySetSerializer().serialize(this.dirtySet);
        this.cache.putDistValue(this.getDirtySetKey(), value);
    }

    private CacheCell buildCacheCell(Cell cell) {
        List propList = this.meta.getPropList();
        CacheCell cacheCell = new CacheCell();
        for (String prop : propList) {
            try {
                Object val = CacheCell.getCellValue((Cell)cell, (String)prop);
                CacheCell.setCellValue((CacheCell)cacheCell, (String)prop, (Object)val);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Property not found: " + prop, e);
            }
        }
        return cacheCell;
    }

    private CacheCellMeta buildMeta(List<Cell> cellList, List<String> cachePropList, ReportCalcModel calcModel) {
        CacheCellMeta meta = new CacheCellMeta();
        meta.setPropList(cachePropList);
        int maxCol = -1;
        int maxRow = -1;
        int minCol = Integer.MAX_VALUE;
        int minRow = Integer.MAX_VALUE;
        HashMap<Integer, HashSet<Integer>> rowNonEmptyValMap = new HashMap<Integer, HashSet<Integer>>(16);
        for (Cell cell : cellList) {
            int row = cell.getRow();
            int col = cell.getCol();
            maxCol = Math.max(maxCol, col);
            maxRow = Math.max(maxRow, row);
            minCol = Math.min(minCol, col);
            minRow = Math.min(minRow, row);
            CellDimTypeEnum cellDimType = cell.getCellDimType();
            if (cellDimType != CellDimTypeEnum.DATADIMS) continue;
            HashSet<Integer> cols = (HashSet<Integer>)rowNonEmptyValMap.get(cell.getRow());
            if (cols == null) {
                cols = new HashSet<Integer>(meta.getColLen() - meta.getColOffSet());
            }
            if (EmptyUtil.isNoEmpty((Object)cell.getValue())) {
                cols.add(cell.getCol());
            }
            rowNonEmptyValMap.put(cell.getRow(), cols);
        }
        meta.setRowNonEmptyValMap(rowNonEmptyValMap);
        if (maxCol < 0 || maxRow < 0 || minCol < 0 || minRow < 0) {
            throw new IllegalArgumentException("Cell's col param or row param illegal.");
        }
        meta.setMaxCol(maxCol);
        meta.setMaxRow(maxRow);
        meta.setColOffSet(minCol);
        meta.setRowOffSet(minRow);
        meta.setColLen(maxCol - minCol + 1);
        meta.setRowLen(maxRow - minRow + 1);
        int dataSize = meta.getDataCnt();
        int blockCnt = this.calcBlockCnt(dataSize);
        meta.setTotalCnt(dataSize);
        meta.setBlockCnt(blockCnt);
        if (calcModel != null) {
            meta.setColDimTree(calcModel.getColTree());
            meta.setRowDimTree(calcModel.getRowTree());
            meta.setPageCalcValList(calcModel.getPageDimValList());
            ReportCalcTree rowTree = calcModel.getRowTree();
            if (EmptyUtil.isNoEmpty((Object)rowTree) && EmptyUtil.isNoEmpty((Object)rowTree.getRoot())) {
                HashSet hideRowSet = new HashSet();
                rowTree.getRoot().getAllChildren().forEach(item -> {
                    ReportCalcVal calcVal = item.getCalcVal();
                    if (EmptyUtil.isNoEmpty((Object)calcVal) && calcVal.isHide()) {
                        for (int row = calcVal.getRow(); row <= calcVal.getEndRow(); ++row) {
                            hideRowSet.add(row);
                        }
                    }
                });
                meta.setHideRowSet(hideRowSet);
            }
        }
        return meta;
    }

    private void fillDirtySet(CacheCell ... cells) {
        if (cells == null) {
            return;
        }
        BitSet dirtySet = this.getDirtySet();
        for (CacheCell cell : cells) {
            int row = cell.getRow();
            int col = cell.getCol();
            int idx = this.getDataIndex(row, col);
            dirtySet.set(idx);
        }
    }

    private BitSet getDirtySet() {
        if (this.dirtySet == null) {
            String dirtySetStr = this.cache.get(this.getDirtySetKey());
            if (dirtySetStr == null) {
                throw new IllegalStateException("dirty set cache dismiss");
            }
            DirtySetSerializer dirtySetSerializer = new DirtySetSerializer();
            this.dirtySet = dirtySetSerializer.deserialize(dirtySetStr);
            this.dirtySet = this.dirtySet == null ? new BitSet() : this.dirtySet;
        }
        return this.dirtySet;
    }

    public boolean hasDirty() {
        return this.getDirtySet().size() > 0;
    }

    private CacheBlock getCacheBlock(int row, int col) {
        int blockIdx = this.getBlockIndex(row, col);
        return this.getCacheBlock(blockIdx);
    }

    private CacheBlock getCacheBlock(int blockIdx) {
        CacheBlock cacheBlock;
        int size = this.cacheList.size();
        if (blockIdx > size - 1) {
            for (int i = 0; i < blockIdx - (size - 1); ++i) {
                this.cacheList.add(null);
            }
        }
        if ((cacheBlock = this.cacheList.get(blockIdx)) == null) {
            String cacheStr = this.cache.get(this.getBlockCacheKey(blockIdx));
            if (cacheStr == null || cacheStr.length() == 0) {
                throw new IllegalStateException("cache block not found, block index: " + blockIdx);
            }
            CacheBlockSerializer serializer = new CacheBlockSerializer(this.meta);
            cacheBlock = serializer.deserialize(cacheStr);
            this.cacheList.set(blockIdx, cacheBlock);
        }
        return cacheBlock;
    }

    private void checkInit() {
        if (this.isInit) {
            return;
        }
        String metaStr = this.cache.get(this.getMetaKey());
        if (metaStr == null || metaStr.length() == 0) {
            throw new IllegalStateException("Cell data not init.");
        }
        this.meta = (CacheCellMeta)FpmSerializeUtil.deserialize((String)metaStr, CacheCellMeta.class);
        this.isInit = true;
    }

    private String getBlockCacheKey(int block) {
        return "Block" + block;
    }

    private int getDataIndex(int row, int col) {
        int actRow = row - this.meta.getRowOffSet();
        int actCol = col - this.meta.getColOffSet();
        return actCol + actRow * this.meta.getColLen();
    }

    private int[] getRowColInfo(int dataIndex) {
        return new int[]{dataIndex / this.meta.getColLen() + this.meta.getRowOffSet(), dataIndex % this.meta.getColLen() + this.meta.getColOffSet()};
    }

    private int getBlockIndex(int row, int col) {
        int dataIndex = this.getDataIndex(row, col);
        int blockIndex = Math.min(dataIndex / (this.meta.getTotalCnt() / this.meta.getBlockCnt()), this.meta.getBlockCnt() - 1);
        return blockIndex;
    }

    private int calcBlockCnt(int dataSize) {
        return dataSize < 5 ? dataSize : 5;
    }

    private String getMetaKey() {
        return "CellMeta";
    }

    private String getDirtySetKey() {
        return "DirtySet";
    }

    public CacheCellMeta getMeta() {
        if (this.meta == null) {
            this.meta = (CacheCellMeta)FpmSerializeUtil.deserialize((String)this.cache.get(this.getMetaKey()), CacheCellMeta.class);
        }
        return this.meta;
    }

    public boolean isDirty(CacheCell cell) {
        BitSet dirtySet = this.getDirtySet();
        int dataIndex = this.getDataIndex(cell.getRow(), cell.getCol());
        return dirtySet.get(dataIndex);
    }

    public DimensionInfoBean getDimensionInfo(int col, int row) {
        DimensionInfoBean dimensionInfoBean = null;
        DimensionInfoBean pageDimInfoBean = new DimensionInfoBean();
        CacheCellMeta currMeta = this.getMeta();
        for (ReportCalcVal reportCalcVal : currMeta.getPageCalcValList()) {
            pageDimInfoBean.getDimensionIdList().add(reportCalcVal.getDimensionId());
            pageDimInfoBean.getMemberIdList().add(reportCalcVal.getValue());
        }
        ReportCalcTree colDimTree = currMeta.getColDimTree();
        ReportCalcTree rowDimTree = currMeta.getRowDimTree();
        if (colDimTree != null && rowDimTree != null) {
            DimensionInfoBean colDimList = colDimTree.getDimInfoByLocation(col, currMeta.getColOffSet());
            DimensionInfoBean rowDimList = rowDimTree.getDimInfoByLocation(row, currMeta.getRowOffSet());
            dimensionInfoBean = DimensionInfoBean.concat((DimensionInfoBean[])new DimensionInfoBean[]{colDimList, rowDimList, pageDimInfoBean});
        } else if (colDimTree != null) {
            DimensionInfoBean colDimList = new DimensionInfoBean();
            List leafList = colDimTree.getLeafList();
            Iterator iterator = leafList.iterator();
            while (iterator.hasNext()) {
                ReportCalcValTreeNode node;
                ReportCalcVal currLeafCalcVal = node.getCalcVal();
                if (node.getParent() != null && node.getParent() != colDimTree.getRoot() && (currLeafCalcVal.getCol() > col || currLeafCalcVal.getEndCol() < col)) continue;
                for (node = (ReportCalcValTreeNode)iterator.next(); node != null && node != colDimTree.getRoot(); node = node.getParent()) {
                    if (node.isSkipVal()) continue;
                    ReportCalcVal calcVal = node.getCalcVal();
                    Long dimensionId = calcVal.getDimensionId();
                    CacheCell cell = this.getCell(row, calcVal.getCol());
                    Object value = cell.getValue();
                    boolean isDim = true;
                    if (!dimensionId.equals(calcVal.getValue())) {
                        if (calcVal.getCol() <= col && calcVal.getEndCol() >= col) {
                            value = calcVal.getValue();
                        } else {
                            isDim = false;
                        }
                    }
                    if (!Objects.isNull(value) && value.toString().equals("0")) {
                        value = null;
                    }
                    boolean bl = isDim = calcVal.isVirtualCell() ? false : isDim;
                    if (!isDim) continue;
                    colDimList.getDimensionIdList().add(dimensionId);
                    colDimList.getMemberIdList().add(value);
                }
            }
            dimensionInfoBean = DimensionInfoBean.concat((DimensionInfoBean[])new DimensionInfoBean[]{colDimList, pageDimInfoBean});
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u4fe1\u606f\u5f02\u5e38", (String)"CellDataSource_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        return dimensionInfoBean;
    }

    public List<Integer> getAllEmptyValRows() {
        CacheCellMeta meta = this.getMeta();
        if (meta == null) {
            return null;
        }
        Map rowNonEmptyValMap = meta.getRowNonEmptyValMap();
        if (EmptyUtil.isEmpty((Object)rowNonEmptyValMap)) {
            return null;
        }
        Set hideRowSet = meta.getHideRowSet();
        List<Integer> rows = rowNonEmptyValMap.entrySet().stream().filter(item -> CollectionUtils.isEmpty((Collection)hideRowSet) || !hideRowSet.contains(item.getKey())).filter(o -> EmptyUtil.isEmpty((Collection)((Collection)o.getValue())) || ((Set)o.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toList());
        return rows;
    }
}

