/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.query;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.DataMetricMergeCache;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.QueryServiceParamConsumer;
import kd.tmc.fpm.business.dataproc.query.ReportDataQParam;
import kd.tmc.fpm.business.dataproc.query.ReportDataQResult;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.dataproc.query.ShrekReportDataQueryDTO;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.BillState;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.report.RelationDimensionShrekDimMap;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.helper.CustomDimThreadLocalHelper;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.converter.ReportPoConverter;
import kd.tmc.fpm.business.mvc.converter.ShrekModelConverter;
import kd.tmc.fpm.business.mvc.repository.IDetailPlanFieldsRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DetailPlanFieldsRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.TemplateRepository;
import kd.tmc.fpm.business.service.dimension.ICustomDimSeqService;
import kd.tmc.fpm.business.service.dimension.impl.CustomDimSeqServiceImpl;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.DataSetUtil;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.business.utils.DimensionMappingHelper;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.helper.FpmHelper;
import kd.tmc.fpm.olap.model.ShrekDimension;
import kd.tmc.fpm.olap.model.ShrekMember;
import kd.tmc.fpm.olap.model.ShrekReportData;
import kd.tmc.fpm.olap.service.helper.ShrekQueryServiceHelper;
import org.apache.commons.collections4.MapUtils;

public class ReportDataQueryService
implements IReportDataQueryService {
    public static final Map<String, String> MAINDIM_ENTRY_MAPPING_MAP = new HashMap<String, String>();
    public static final Map<String, String> DETAILDIM_ENTRY_MAPPING_MAP = new HashMap<String, String>();
    public static final Map<String, String> TYPE_MAPPING_MAP = new HashMap<String, String>();
    private IDetailPlanFieldsRepository detailPlanFieldsRepository = new DetailPlanFieldsRepository();
    private static Log logger;

    @Override
    public List<ReportDataQueryResult> queryReportData(ReportDataQueryObject queryObject) {
        DataSet resultDataSet;
        Boolean mainTable;
        List billStateList;
        List reportStatusList;
        TemplateType templateType;
        ReportStatus reportStatus;
        Boolean effectFlag;
        List reportPeriodIds;
        Long reportPeriodId;
        List reportOrgIds;
        Long reportOrgId;
        ReportPlanType reportPlanType;
        Long orgTemplateId;
        Long templateId;
        List versionList;
        List reportIdS;
        List idList;
        Long id;
        List dimList = queryObject.getDimIdList();
        List dimValList = queryObject.getDimValList();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (!CollectionUtils.isEmpty((Collection)dimList) && !CollectionUtils.isEmpty((Collection)dimValList)) {
            Map<Long, Integer> customDimSeqMap = this.getCustomDimSeqMap(dimList);
            Set<Long> systemIdSet = dimList.stream().map(Dimension::getSystemId).collect(Collectors.toSet());
            HashMap systemIdDetailMappingMap = new HashMap(systemIdSet.size());
            systemIdSet.forEach(systemId -> systemIdDetailMappingMap.put(systemId, DimensionMappingHelper.getReportPlanDetailMappingWithEntry(systemId)));
            for (int i = 0; i < dimList.size(); ++i) {
                Dimension templateDim = (Dimension)dimList.get(i);
                DimensionType dimType = templateDim.getDimType();
                if (DimensionType.DETAILDIM != dimType) {
                    String propName;
                    if (DimensionType.CUSTOM != dimType && EmptyUtil.isNoEmpty((String)(propName = TYPE_MAPPING_MAP.get(dimType.getNumber())))) {
                        qFilterList.add(new QFilter(propName, "in", dimValList.get(i)));
                    }
                    this.handleCustomDimQFilter(templateDim.getId(), (List)dimValList.get(i), qFilterList, dimType, customDimSeqMap);
                    continue;
                }
                DetailDimType detailDimType = templateDim.getDetailDimType();
                Long systemId2 = templateDim.getSystemId();
                Map reportPlanDetailMappingWithEntry = (Map)systemIdDetailMappingMap.get(systemId2);
                String propName = (String)reportPlanDetailMappingWithEntry.get(detailDimType.getNumber());
                qFilterList.add(new QFilter(propName, "in", dimValList.get(i)));
                if (!EmptyUtil.isNoEmpty((String)propName)) continue;
                qFilterList.add(new QFilter(propName, "in", dimValList.get(i)));
            }
        }
        if (null != (id = queryObject.getId())) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "maindimentry", "id"), "=", (Object)id));
        }
        if (EmptyUtil.isNoEmpty((Object)(idList = queryObject.getIdList()))) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "maindimentry", "id"), "in", (Object)idList));
        }
        if (!CollectionUtils.isEmpty((Collection)(reportIdS = queryObject.getReportIdS()))) {
            qFilterList.add(new QFilter("id", "in", (Object)reportIdS));
        }
        if (!CollectionUtils.isEmpty((Collection)(versionList = queryObject.getVersionList()))) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "maindimentry", "version"), "in", (Object)versionList));
        }
        if ((templateId = queryObject.getTemplateId()) != null) {
            qFilterList.add(new QFilter("templatebak.id", "=", (Object)templateId));
        }
        if ((orgTemplateId = queryObject.getOrgTemplateId()) != null) {
            qFilterList.add(new QFilter("template.id", "=", (Object)orgTemplateId));
        }
        if (!EmptyUtil.isEmpty((Object)(reportPlanType = queryObject.getReportPlanType()))) {
            qFilterList.add(new QFilter("reportplantype", "=", (Object)reportPlanType.getNumber()));
        }
        if ((reportOrgId = queryObject.getReportOrgId()) != null) {
            qFilterList.add(new QFilter("reportorg.id", "=", (Object)reportOrgId));
        }
        if (!CollectionUtils.isEmpty((Collection)(reportOrgIds = queryObject.getReportOrgIds()))) {
            qFilterList.add(new QFilter("reportorg.id", "in", (Object)reportOrgIds));
        }
        if ((reportPeriodId = queryObject.getReportPeriodId()) != null) {
            qFilterList.add(new QFilter("reportperiod.id", "=", (Object)reportPeriodId));
        }
        if (!CollectionUtils.isEmpty((Collection)(reportPeriodIds = queryObject.getReportPeriodIds()))) {
            qFilterList.add(new QFilter("reportperiod.id", "in", (Object)reportPeriodIds));
        }
        if ((effectFlag = queryObject.getEffectFlag()) != null) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "maindimentry", "effectflag"), "=", (Object)(effectFlag != false ? "1" : "0")));
        }
        if (EmptyUtil.isNoEmpty((Object)(reportStatus = queryObject.getReportStatus()))) {
            qFilterList.add(new QFilter("planstatus", "=", (Object)reportStatus.getVal()));
        }
        if (EmptyUtil.isNoEmpty((Object)(templateType = queryObject.getTemplateType()))) {
            qFilterList.add(new QFilter("template.templatetype", "=", (Object)templateType.getNumber()));
        }
        if (EmptyUtil.isNoEmpty((Object)(reportStatusList = queryObject.getReportStatuss()))) {
            qFilterList.add(new QFilter("planstatus", "in", reportStatusList.stream().map(ReportStatus::getVal).collect(Collectors.toSet())));
        }
        if (EmptyUtil.isNoEmpty((Object)(billStateList = queryObject.getBillStateList()))) {
            qFilterList.add(new QFilter("billstatus", "in", billStateList.stream().map(BillState::getNumber).collect(Collectors.toSet())));
        }
        if ((mainTable = queryObject.getMainTable()) != null) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "maindimentry", "maintable"), "=", (Object)(mainTable != false ? "1" : "0")));
        }
        DynamicObjectCollection simpleInfoArr = QueryServiceHelper.query((String)"fpm_report", (String)String.join((CharSequence)",", "id", "template.id", "bodysys.id"), (QFilter[])qFilterList.toArray(new QFilter[0]));
        Map<Long, Long> reportIdAndTemplateMap = simpleInfoArr.stream().collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getLong("template.id"), (item1, item2) -> item1));
        Map<Long, Long> reportIdAndBodySysMap = simpleInfoArr.stream().collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getLong("bodysys.id"), (item1, item2) -> item1));
        List reportTemplates = new TemplateRepository().loadTemplate(new ArrayList<Long>(reportIdAndTemplateMap.values()));
        Map<Long, ReportTemplate> templateMap = reportTemplates.stream().collect(Collectors.toMap(ReportTemplate::getId, d -> d));
        Map<Long, List<Dimension>> planDetailMap = this.detailPlanFieldsRepository.getDetailDimensionGroupBySystemId(new HashSet<Long>(reportIdAndBodySysMap.values()));
        Map entryPropMap = FpmHelper.getEntryPropertyS((String)"fpm_report", Arrays.asList("maindimentry", "auxentry", "detailentry", "sourceidentry"));
        Set entryPropertySet = (Set)entryPropMap.get("maindimentry");
        String idProp = "maindimentry.id";
        String mainEntryBodySysProp = String.join((CharSequence)".", "maindimentry", "system");
        entryPropertySet.add(idProp);
        entryPropertySet.add("id");
        entryPropertySet.add("planstatus");
        entryPropertySet.add("maindimentry.sourceid_tag");
        DataSet mainEntryDataSet = queryObject.getIdTopSize() <= 0 ? QueryServiceHelper.queryDataSet((String)"report.queryMainData", (String)"fpm_report", (String)String.join((CharSequence)",", entryPropertySet), (QFilter[])qFilterList.toArray(new QFilter[0]), (String)"") : QueryServiceHelper.queryDataSet((String)"report.queryMainData", (String)"fpm_report", (String)String.join((CharSequence)",", entryPropertySet), (QFilter[])qFilterList.toArray(new QFilter[0]), (String)"", (int)queryObject.getIdTopSize());
        DataSet copyData = mainEntryDataSet.copy();
        HashMap<Long, ReportTemplate> entryIdAndTemplateMap = new HashMap<Long, ReportTemplate>(16);
        HashMap<Long, List<Dimension>> entryIdAndDetailPlanMap = new HashMap<Long, List<Dimension>>(16);
        DataSet mainEntryIdDS = copyData.select(new String[]{idProp, "id", mainEntryBodySysProp});
        while (mainEntryIdDS.hasNext()) {
            Row next = mainEntryIdDS.next();
            Long reportId = next.getLong("id");
            Long currTemplateId = reportIdAndTemplateMap.get(reportId);
            entryIdAndTemplateMap.put(next.getLong(idProp), templateMap.get(currTemplateId));
            entryIdAndDetailPlanMap.put(next.getLong(idProp), planDetailMap.get(next.getLong(mainEntryBodySysProp)));
        }
        Set auxEntryPropertySet = (Set)entryPropMap.get("auxentry");
        String mainDataEntryId = String.join((CharSequence)".", "auxentry", "aux_reportdataid");
        DataSet auxEntryDataSet = QueryServiceHelper.queryDataSet((String)"report.queryAuxData", (String)"fpm_report", (String)String.join((CharSequence)",", auxEntryPropertySet), (QFilter[])new QFilter[]{new QFilter(mainDataEntryId, "in", entryIdAndTemplateMap.keySet())}, (String)"");
        ArrayList allFileds = new ArrayList(entryPropertySet);
        allFileds.addAll(auxEntryPropertySet);
        DataSet reportDataDataSet = resultDataSet = mainEntryDataSet.leftJoin(auxEntryDataSet).on(idProp, mainDataEntryId).select(allFileds.toArray(new String[0])).finish();
        if (!"openApi".equals(queryObject.getResource()) || queryObject.isQueryDetail().booleanValue()) {
            Set detailEntryPropertySet = (Set)entryPropMap.get("detailentry");
            String mainEntryId = String.join((CharSequence)".", "detailentry", "maindimdataid");
            DataSet detailEntryDataSet = QueryServiceHelper.queryDataSet((String)"report.queryDetailData", (String)"fpm_report", (String)String.join((CharSequence)",", detailEntryPropertySet), (QFilter[])new QFilter[]{new QFilter(mainEntryId, "in", entryIdAndTemplateMap.keySet())}, (String)"");
            HashSet allFiledList = new HashSet(entryPropertySet);
            allFiledList.addAll(auxEntryPropertySet);
            allFiledList.addAll(detailEntryPropertySet);
            reportDataDataSet = resultDataSet.join(detailEntryDataSet).on(idProp, mainEntryId).select(allFiledList.toArray(new String[0])).finish();
        }
        List<ReportDataQueryResult> convertResult = this.convert(reportDataDataSet, entryIdAndTemplateMap, entryIdAndDetailPlanMap, queryObject);
        this.fillIntoSourceIdEntry(entryIdAndTemplateMap.keySet(), convertResult, (Set)entryPropMap.get("sourceidentry"));
        DataSetUtil.closeDataSet((DataSet[])new DataSet[]{reportDataDataSet});
        return convertResult;
    }

    @Override
    public List<ReportDataQueryResult> queryReportDataByApi(ReportDataQueryObject queryObject) {
        DataSet resultDataSet;
        Map entryPropMap = FpmHelper.getEntryPropertyS((String)"fpm_report", Arrays.asList("maindimentry", "auxentry", "detailentry"));
        Set entryPropertySet = (Set)entryPropMap.get("maindimentry");
        DataSet mainEntryDataSet = this.queryMainEntryData(queryObject, entryPropertySet);
        HashMap<Long, ReportTemplate> entryIdAndTemplateMap = new HashMap<Long, ReportTemplate>(16);
        HashMap<Long, List<Dimension>> entryIdAndDetailPlanMap = new HashMap<Long, List<Dimension>>(16);
        HashSet<Long> reportIds = new HashSet<Long>(10);
        Set<Long> mainDataIds = this.getMainDataIds(mainEntryDataSet, entryIdAndTemplateMap, entryIdAndDetailPlanMap, reportIds);
        DataSet reportDataDataSet = resultDataSet = this.queryAuxEntryData(entryPropMap, entryPropertySet, mainEntryDataSet, reportIds, mainDataIds);
        if (!"openApi".equals(queryObject.getResource()) || queryObject.isQueryDetail().booleanValue()) {
            reportDataDataSet = this.queryDetailEntryData(entryPropMap, entryPropertySet, reportIds, mainDataIds, resultDataSet);
        }
        List<ReportDataQueryResult> convertResult = this.convert(reportDataDataSet, entryIdAndTemplateMap, entryIdAndDetailPlanMap, queryObject);
        this.fillIntoSourceIdEntry(mainDataIds, reportIds, convertResult);
        DataSetUtil.closeDataSet((DataSet[])new DataSet[]{reportDataDataSet, mainEntryDataSet, resultDataSet});
        return convertResult;
    }

    private List<QFilter> listMainEntryFilter(ReportDataQueryObject queryObject) {
        Boolean mainTable;
        List billStateList;
        List reportStatusList;
        TemplateType templateType;
        ReportStatus reportStatus;
        Boolean effectFlag;
        List reportPeriodIds;
        Long reportPeriodId;
        List reportOrgIds;
        Long reportOrgId;
        ReportPlanType reportPlanType;
        Long orgTemplateId;
        Long templateId;
        List versionList;
        List reportIdS;
        List idList;
        Long id;
        List dimList = queryObject.getDimIdList();
        List dimValList = queryObject.getDimValList();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (!EmptyUtil.isEmpty((Collection)dimList) && !EmptyUtil.isEmpty((Collection)dimValList)) {
            this.addMainDimFilter(dimList, dimValList, qFilterList);
        }
        if (null != (id = queryObject.getId())) {
            qFilterList.add(new QFilter("maindimentry.id", "=", (Object)id));
        }
        if (EmptyUtil.isNoEmpty((Object)(idList = queryObject.getIdList()))) {
            qFilterList.add(new QFilter("maindimentry.id", "in", (Object)idList));
        }
        if (!EmptyUtil.isEmpty((Collection)(reportIdS = queryObject.getReportIdS()))) {
            qFilterList.add(new QFilter("id", "in", (Object)reportIdS));
        }
        if (!EmptyUtil.isEmpty((Collection)(versionList = queryObject.getVersionList()))) {
            qFilterList.add(new QFilter("maindimentry.version", "in", (Object)versionList));
        }
        if ((templateId = queryObject.getTemplateId()) != null) {
            qFilterList.add(new QFilter("templatebak.id", "=", (Object)templateId));
        }
        if ((orgTemplateId = queryObject.getOrgTemplateId()) != null) {
            qFilterList.add(new QFilter("template.id", "=", (Object)orgTemplateId));
        }
        if (!EmptyUtil.isEmpty((Object)(reportPlanType = queryObject.getReportPlanType()))) {
            qFilterList.add(new QFilter("reportplantype", "=", (Object)reportPlanType.getNumber()));
        }
        if ((reportOrgId = queryObject.getReportOrgId()) != null) {
            qFilterList.add(new QFilter("reportorg.id", "=", (Object)reportOrgId));
        }
        if (!EmptyUtil.isEmpty((Collection)(reportOrgIds = queryObject.getReportOrgIds()))) {
            qFilterList.add(new QFilter("reportorg.id", "in", (Object)reportOrgIds));
        }
        if ((reportPeriodId = queryObject.getReportPeriodId()) != null) {
            qFilterList.add(new QFilter("reportperiod.id", "=", (Object)reportPeriodId));
        }
        if (!EmptyUtil.isEmpty((Collection)(reportPeriodIds = queryObject.getReportPeriodIds()))) {
            qFilterList.add(new QFilter("reportperiod.id", "in", (Object)reportPeriodIds));
        }
        if ((effectFlag = queryObject.getEffectFlag()) != null) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "maindimentry", "effectflag"), "=", (Object)(effectFlag != false ? "1" : "0")));
        }
        if (EmptyUtil.isNoEmpty((Object)(reportStatus = queryObject.getReportStatus()))) {
            qFilterList.add(new QFilter("planstatus", "=", (Object)reportStatus.getVal()));
        }
        if (EmptyUtil.isNoEmpty((Object)(templateType = queryObject.getTemplateType()))) {
            qFilterList.add(new QFilter("template.templatetype", "=", (Object)templateType.getNumber()));
        }
        if (EmptyUtil.isNoEmpty((Object)(reportStatusList = queryObject.getReportStatuss()))) {
            qFilterList.add(new QFilter("planstatus", "in", reportStatusList.stream().map(ReportStatus::getVal).collect(Collectors.toSet())));
        }
        if (EmptyUtil.isNoEmpty((Object)(billStateList = queryObject.getBillStateList()))) {
            qFilterList.add(new QFilter("billstatus", "in", billStateList.stream().map(BillState::getNumber).collect(Collectors.toSet())));
        }
        if ((mainTable = queryObject.getMainTable()) != null) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "maindimentry", "maintable"), "=", (Object)(mainTable != false ? "1" : "0")));
        }
        return qFilterList;
    }

    private void addMainDimFilter(List<Dimension> dimList, List<List<Object>> dimValList, List<QFilter> qFilterList) {
        if (CollectionUtils.isEmpty(dimList) || CollectionUtils.isEmpty(dimValList)) {
            return;
        }
        Map<Long, Integer> customDimSeqMap = this.getCustomDimSeqMap(dimList);
        for (int i = 0; i < dimList.size(); ++i) {
            String propName;
            Dimension templateDim = dimList.get(i);
            DimensionType dimType = templateDim.getDimType();
            if (DimensionType.DETAILDIM == dimType) continue;
            if (DimensionType.CUSTOM != dimType && EmptyUtil.isNoEmpty((String)(propName = TYPE_MAPPING_MAP.get(dimType.getNumber())))) {
                qFilterList.add(new QFilter(propName, "in", dimValList.get(i)));
            }
            this.handleCustomDimQFilter(templateDim.getId(), dimValList.get(i), qFilterList, dimType, customDimSeqMap);
        }
    }

    private List<QFilter> listDetailEntryFilter(List<Dimension> dimList, List<List<Object>> dimValList) {
        LinkedList<QFilter> qFilterList = new LinkedList<QFilter>();
        if (CollectionUtils.isEmpty(dimList) || CollectionUtils.isEmpty(dimValList)) {
            return qFilterList;
        }
        Set<Long> systemIdSet = dimList.stream().map(Dimension::getSystemId).collect(Collectors.toSet());
        HashMap systemIdDetailMappingMap = new HashMap(systemIdSet.size());
        systemIdSet.forEach(systemId -> systemIdDetailMappingMap.put(systemId, DimensionMappingHelper.getReportPlanDetailMappingWithEntry(systemId)));
        for (int i = 0; i < dimList.size(); ++i) {
            Dimension templateDim = dimList.get(i);
            DimensionType dimType = templateDim.getDimType();
            if (DimensionType.DETAILDIM != dimType) continue;
            DetailDimType detailDimType = templateDim.getDetailDimType();
            Long systemId2 = templateDim.getSystemId();
            Map reportPlanDetailMappingWithEntry = (Map)systemIdDetailMappingMap.get(systemId2);
            String propName = (String)reportPlanDetailMappingWithEntry.get(detailDimType.getNumber());
            if (!EmptyUtil.isNoEmpty((String)propName)) continue;
            qFilterList.add(new QFilter(propName, "in", DimensionInfoHelper.transferDetailFieldDBValList(templateDim, dimValList.get(i))));
        }
        return qFilterList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet queryAuxEntryData(Map<String, Set<String>> entryPropMap, Set<String> entryPropertySet, DataSet mainEntryDataSet, Set<Long> reportIds, Set<Long> mainDataIds) {
        DataSet dataSet;
        Set<String> auxEntryPropertySet = entryPropMap.get("auxentry");
        QFilter qFilter = new QFilter("auxentry.aux_reportdataid", "in", mainDataIds).and("id", "in", reportIds);
        DataSet auxEntryDataSet = QueryServiceHelper.queryDataSet((String)"report.queryAuxData", (String)"fpm_report", (String)String.join((CharSequence)",", auxEntryPropertySet), (QFilter[])qFilter.toArray(), (String)"");
        try {
            entryPropertySet.addAll(auxEntryPropertySet);
            dataSet = mainEntryDataSet.leftJoin(auxEntryDataSet).on("maindimentry.id", "auxentry.aux_reportdataid").select(entryPropertySet.toArray(new String[0])).finish();
        }
        catch (Throwable throwable) {
            DataSetUtil.closeDataSet((DataSet[])new DataSet[]{auxEntryDataSet});
            throw throwable;
        }
        DataSetUtil.closeDataSet((DataSet[])new DataSet[]{auxEntryDataSet});
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet queryDetailEntryData(Map<String, Set<String>> entryPropMap, Set<String> entryPropertySet, Set<Long> reportIds, Set<Long> mainDataIds, DataSet resultDataSet) {
        DataSet dataSet;
        Set<String> detailEntryPropertySet = entryPropMap.get("detailentry");
        QFilter qFilter = new QFilter("detailentry.maindimdataid", "in", mainDataIds).and("id", "in", reportIds);
        DataSet detailEntryDataSet = QueryServiceHelper.queryDataSet((String)"report.queryDetailData", (String)"fpm_report", (String)String.join((CharSequence)",", detailEntryPropertySet), (QFilter[])qFilter.toArray(), (String)"");
        try {
            entryPropertySet.addAll(detailEntryPropertySet);
            dataSet = resultDataSet.join(detailEntryDataSet).on("maindimentry.id", "detailentry.maindimdataid").select(entryPropertySet.toArray(new String[0])).finish();
        }
        catch (Throwable throwable) {
            DataSetUtil.closeDataSet((DataSet[])new DataSet[]{detailEntryDataSet});
            throw throwable;
        }
        DataSetUtil.closeDataSet((DataSet[])new DataSet[]{detailEntryDataSet});
        return dataSet;
    }

    private List<ReportDataQueryResult> queryReportDataForAllSystemContainsCustomDim(ReportDataQueryObject queryObject) {
        List dimValList = queryObject.getDimValList();
        List dimIdList = queryObject.getDimIdList();
        Map dimensionIndexMap = IntStream.range(0, dimIdList.size()).boxed().collect(Collectors.toMap(i -> ((Dimension)dimIdList.get((int)i)).getId(), Function.identity()));
        Map<Long, List<Dimension>> systemDimensionMap = dimIdList.stream().collect(Collectors.groupingBy(Dimension::getSystemId));
        if (systemDimensionMap.size() <= 1) {
            return this.queryReportData(queryObject);
        }
        ArrayList<ReportDataQueryResult> reportDataQueryResults = new ArrayList<ReportDataQueryResult>(1024);
        for (Map.Entry<Long, List<Dimension>> entry : systemDimensionMap.entrySet()) {
            List<Dimension> systemDimensionList = entry.getValue();
            ArrayList systemDimValList = new ArrayList(systemDimensionList.size());
            systemDimensionList.forEach(dimension -> systemDimValList.add(new ArrayList((Collection)dimValList.get((Integer)dimensionIndexMap.get(dimension.getId())))));
            ReportDataQueryObject copy = queryObject.copy(t -> {
                t.setDimIdList(systemDimensionList);
                t.setDimValList(systemDimValList);
            });
            List dimensionIds = systemDimensionList.stream().map(Dimension::getId).collect(Collectors.toList());
            List<ReportDataQueryResult> resultList = this.queryReportData(copy);
            reportDataQueryResults.addAll(this.queryReportData(copy));
            logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u67e5\u8be2\u7ef4\u5ea6\uff1a{}\uff0c{}\uff0c\u67e5\u8be2\u5230\u7684\u7f16\u5236\u6570\u636e\u6570\u91cf\uff1a{}", new Object[]{entry.getKey(), dimensionIds, systemDimValList, resultList.size()});
        }
        return reportDataQueryResults;
    }

    private DataSet queryMainEntryData(ReportDataQueryObject queryObject, Set<String> mainEntryPropertySet) {
        DataSet mainEntryDataByFilterDetailEntry;
        mainEntryPropertySet.add("maindimentry.id");
        mainEntryPropertySet.add("id");
        mainEntryPropertySet.add("planstatus");
        mainEntryPropertySet.add("maindimentry.sourceid_tag");
        mainEntryPropertySet.add("template.id");
        mainEntryPropertySet.add("bodysys.id");
        List<QFilter> mainEntryFilterList = this.listMainEntryFilter(queryObject);
        List<QFilter> detailEntryFilterList = this.listDetailEntryFilter(queryObject.getDimIdList(), queryObject.getDimValList());
        DataSet mainEntryDataSet = QueryServiceHelper.queryDataSet((String)"report.queryMainEntryData", (String)"fpm_report", (String)String.join((CharSequence)",", mainEntryPropertySet), (QFilter[])mainEntryFilterList.toArray(new QFilter[0]), (String)"");
        if (CollectionUtils.isEmpty(detailEntryFilterList)) {
            if (queryObject.getIdTopSize() <= 0) {
                return mainEntryDataSet;
            }
            DataSet filterResultDataSet = mainEntryDataSet.top(queryObject.getIdTopSize());
            DataSetUtil.closeDataSet((DataSet[])new DataSet[]{mainEntryDataSet});
            return filterResultDataSet;
        }
        HashSet<Long> mainDataIds = new HashSet<Long>(16);
        HashSet<Long> reportIds = new HashSet<Long>(16);
        String idProp = "maindimentry.id";
        try (DataSet mainData = mainEntryDataSet.copy().select(new String[]{"id", idProp}).distinct();){
            for (Row row : mainData) {
                Long reportId = row.getLong("id");
                mainDataIds.add(row.getLong(idProp));
                reportIds.add(reportId);
            }
        }
        detailEntryFilterList.add(new QFilter("id", "in", reportIds));
        detailEntryFilterList.add(new QFilter("detailentry.maindimdataid", "in", mainDataIds));
        DataSet detailEntryDataSet = QueryServiceHelper.queryDataSet((String)"report.queryDetailEntryData", (String)"fpm_report", (String)"detailentry.maindimdataid", (QFilter[])detailEntryFilterList.toArray(new QFilter[0]), (String)"");
        Object object = null;
        try {
            mainEntryDataByFilterDetailEntry = mainEntryDataSet.join(detailEntryDataSet).on("maindimentry.id", "detailentry.maindimdataid").select(mainEntryPropertySet.toArray(new String[0])).finish();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (detailEntryDataSet != null) {
                if (object != null) {
                    try {
                        detailEntryDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    detailEntryDataSet.close();
                }
            }
        }
        if (queryObject.getIdTopSize() <= 0) {
            DataSetUtil.closeDataSet((DataSet[])new DataSet[]{mainEntryDataSet});
            return mainEntryDataByFilterDetailEntry;
        }
        DataSet filterResultDataSet = mainEntryDataByFilterDetailEntry.top(queryObject.getIdTopSize());
        DataSetUtil.closeDataSet((DataSet[])new DataSet[]{mainEntryDataSet, mainEntryDataByFilterDetailEntry});
        return filterResultDataSet;
    }

    private Set<Long> getMainDataIds(DataSet mainEntryDataSet, Map<Long, ReportTemplate> entryIdAndTemplateMap, Map<Long, List<Dimension>> entryIdAndDetailPlanMap, Set<Long> reportIds) {
        HashSet<Long> mainDataIds = new HashSet<Long>(8);
        String idProp = "maindimentry.id";
        HashMap<Long, Long> reportIdAndTemplateMap = new HashMap<Long, Long>(8);
        HashMap<Long, Long> reportIdAndBodySysMap = new HashMap<Long, Long>(8);
        DataSet mainData = mainEntryDataSet.copy().select(new String[]{"id", idProp, "template.id", "bodysys.id"}).distinct();
        for (Row row : mainData) {
            Long reportId = row.getLong("id");
            reportIdAndTemplateMap.put(reportId, row.getLong("template.id"));
            reportIdAndBodySysMap.put(reportId, row.getLong("bodysys.id"));
            mainDataIds.add(row.getLong(idProp));
            reportIds.add(reportId);
        }
        List reportTemplates = new TemplateRepository().loadTemplate(new ArrayList(reportIdAndTemplateMap.values()));
        Map<Long, ReportTemplate> templateMap = reportTemplates.stream().collect(Collectors.toMap(ReportTemplate::getId, d -> d));
        Map<Long, List<Dimension>> planDetailMap = new DetailPlanFieldsRepository().getDetailDimensionGroupBySystemId(new HashSet<Long>(reportIdAndBodySysMap.values()));
        DataSet copyData = mainEntryDataSet.copy();
        DataSet mainEntryIdDS = copyData.select(new String[]{idProp, "id", "maindimentry.system"});
        for (Row row : mainEntryIdDS) {
            Long currTemplateId = (Long)reportIdAndTemplateMap.get(row.getLong("id"));
            entryIdAndTemplateMap.put(row.getLong(idProp), templateMap.get(currTemplateId));
            entryIdAndDetailPlanMap.put(row.getLong(idProp), planDetailMap.get(row.getLong("maindimentry.system")));
        }
        DataSetUtil.closeDataSet((DataSet[])new DataSet[]{mainData, copyData, mainEntryIdDS});
        return mainDataIds;
    }

    @Override
    public List<ReportDataQueryResult> queryReportDataForAllSystem(ReportDataQueryObject queryObject) {
        List dimIdList = queryObject.getDimIdList();
        Optional<Dimension> any = dimIdList.stream().filter(dimension -> dimension.getDimType().isCustomDim()).findAny();
        if (any.isPresent()) {
            return this.queryReportDataForAllSystemContainsCustomDim(queryObject);
        }
        Map dimensionIndexMap = IntStream.range(0, dimIdList.size()).boxed().collect(Collectors.toMap(i -> ((Dimension)dimIdList.get((int)i)).getId(), Function.identity()));
        Map<Long, List<Dimension>> systemDimensionListMap = dimIdList.stream().collect(Collectors.groupingBy(Dimension::getSystemId));
        List dimValList = queryObject.getDimValList();
        ArrayList<ReportDataQueryResult> resultListAll = new ArrayList<ReportDataQueryResult>(2048);
        for (Map.Entry<Long, List<Dimension>> entry : systemDimensionListMap.entrySet()) {
            List<Dimension> value = entry.getValue();
            if (EmptyUtil.isEmpty(value)) continue;
            ArrayList<Dimension> systemDimIdList = new ArrayList<Dimension>(8);
            ArrayList systemDimValList = new ArrayList(8);
            for (Dimension dimension2 : value) {
                systemDimIdList.add(dimension2);
                systemDimValList.add(new ArrayList((Collection)dimValList.get((Integer)dimensionIndexMap.get(dimension2.getId()))));
            }
            ReportDataQueryObject copy = queryObject.copy(t -> {
                t.setDimIdList(systemDimIdList);
                t.setDimValList(systemDimValList);
            });
            List<ReportDataQueryResult> resultList = this.queryReportData(copy);
            logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u67e5\u8be2\u5230\u7684\u8bb0\u5f55\u6761\u6570\uff1a{}\uff0c\u67e5\u8be2\u6761\u4ef6: {}", new Object[]{entry.getKey(), resultList.size(), copy.searchCondition()});
            resultListAll.addAll(resultList);
        }
        return resultListAll;
    }

    @Override
    public List<ReportData> queryReportDataForAllSystem(QueryServiceParamConsumer<ReportDataQueryObject> consumer) {
        ReportDataQueryObject reportDataQueryObject = new ReportDataQueryObject();
        consumer.accept((Object)reportDataQueryObject);
        List<ReportDataQueryResult> reportDataQueryResults = this.queryReportDataForAllSystem(reportDataQueryObject);
        return ReportHelper.convert(reportDataQueryResults);
    }

    private void fillIntoSourceIdEntry(Set<Long> reportDataId, List<ReportDataQueryResult> convertResult, Set<String> sourceIdEntryPropSet) {
        if (CollectionUtils.isEmpty(convertResult)) {
            return;
        }
        String sourceIdEntryId = String.join((CharSequence)".", "sourceidentry", "rdi_reportdataid");
        String sourceId = String.join((CharSequence)".", "sourceidentry", "sourcedocid");
        DynamicObjectCollection sourceEntryResult = QueryServiceHelper.query((String)"fpm_report", (String)String.join((CharSequence)",", sourceIdEntryPropSet), (QFilter[])new QFilter[]{new QFilter(sourceIdEntryId, "in", reportDataId)});
        if (CollectionUtils.isEmpty((Collection)sourceEntryResult)) {
            return;
        }
        Map<Object, List<DynamicObject>> sourceIdMap = sourceEntryResult.stream().collect(Collectors.groupingBy(k -> k.get(sourceIdEntryId)));
        for (ReportDataQueryResult queryResult : convertResult) {
            List<DynamicObject> sourceIdList = sourceIdMap.get(queryResult.getId());
            if (CollectionUtils.isEmpty(sourceIdList)) continue;
            List idList = sourceIdList.stream().map(item -> item.getLong(sourceId)).collect(Collectors.toList());
            queryResult.setSourceIdList(idList);
        }
    }

    private void fillIntoSourceIdEntry(Set<Long> reportDataId, Set<Long> reportIds, List<ReportDataQueryResult> convertResult) {
        if (EmptyUtil.isEmpty(convertResult)) {
            return;
        }
        QFilter qFilter = new QFilter("sourceidentry.rdi_reportdataid", "in", reportDataId).and("id", "in", reportIds);
        String selectProps = String.join((CharSequence)",", "sourceidentry.rdi_reportdataid", "sourceidentry.sourcedocid");
        DynamicObjectCollection sourceEntryResult = QueryServiceHelper.query((String)"fpm_report", (String)selectProps, (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)sourceEntryResult)) {
            return;
        }
        Map sourceIdMap = sourceEntryResult.stream().collect(Collectors.groupingBy(k -> k.get("sourceidentry.rdi_reportdataid"), Collectors.mapping(d -> d.getLong("sourceidentry.sourcedocid"), Collectors.toList())));
        convertResult.forEach(d -> d.setSourceIdList((List)sourceIdMap.get(d.getId())));
    }

    @Override
    public List<ReportDataQueryResult> queryMaxVersionReportData(ReportDataQueryObject queryObject) {
        List<ReportDataQueryResult> resultList = this.queryReportData(queryObject);
        HashSet result = new HashSet(10);
        Set reportPeriodIdS = resultList.stream().map(ReportDataQueryResult::getReportPeriodId).collect(Collectors.toSet());
        DynamicObjectCollection reportPeriodColl = QueryServiceHelper.query((String)"fpm_member", (String)"id,startdate,enddate", (QFilter[])new QFilter[]{new QFilter("id", "in", reportPeriodIdS)});
        Map reportPeriodMap = reportPeriodColl.stream().collect(Collectors.toMap(item -> item.getLong("id"), Function.identity(), (k1, k2) -> k1));
        Map<List, Map<List, List<ReportDataQueryResult>>> resultListMap = resultList.stream().collect(Collectors.groupingBy(ReportDataQueryResult::getDimIdList, Collectors.groupingBy(ReportDataQueryResult::getDimValList)));
        for (ReportDataQueryResult reportDataQueryResult : resultList) {
            List dimIdList = reportDataQueryResult.getDimIdList();
            List dimValList = reportDataQueryResult.getDimValList();
            Map<List, List<ReportDataQueryResult>> listListMap = resultListMap.get(dimIdList);
            List<ReportDataQueryResult> currDimResultList = listListMap.get(dimValList);
            result.add(currDimResultList.stream().sorted((o1, o2) -> {
                DynamicObject currPeriod = (DynamicObject)reportPeriodMap.get(o1.getReportPeriodId());
                Date o1StartDate = currPeriod.getDate("startdate");
                currPeriod = (DynamicObject)reportPeriodMap.get(o2.getReportPeriodId());
                Date o2StartDate = currPeriod.getDate("startdate");
                return o2StartDate.compareTo(o1StartDate);
            }).findFirst().get());
        }
        return new ArrayList<ReportDataQueryResult>(result);
    }

    @Override
    public List<ReportDataQueryResult> queryReportDataByShrek(ShrekReportDataQueryDTO queryDTO) {
        if (!this.check(queryDTO)) {
            return Collections.emptyList();
        }
        FundPlanSystem system = queryDTO.getSystem();
        RelationDimensionShrekDimMap dimensionShrekDimMap = RelationDimensionShrekDimMap.getInstance((FundPlanSystem)system);
        List<ShrekDimension> shrekQueryFilter = this.getShrekQueryFilter(queryDTO, dimensionShrekDimMap);
        if (EmptyUtil.isEmpty(shrekQueryFilter)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5c06\u7ef4\u5ea6\u67e5\u8be2\u6761\u4ef6\u8f6c\u6362\u6210\u591a\u7ef4\u67e5\u8be2\u6761\u4ef6\u540e\u67e5\u8be2\u6761\u4ef6\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u7ef4\u5ea6\u6216\u7ef4\u5ea6\u6210\u5458\u672a\u5b8c\u5168\u540c\u6b65\u3002", (String)"ReportDataQueryService_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        logger.info(String.format("MultiDimension Query Filter:[%s]", shrekQueryFilter));
        List shrekReportData = ShrekQueryServiceHelper.queryDataSet((String)dimensionShrekDimMap.getCubName(), shrekQueryFilter, (boolean)queryDTO.isDynamicCalculate());
        DataMetricMergeCache dataMetricMergeCache = new DataMetricMergeCache(shrekReportData.size());
        for (ShrekReportData rowData : shrekReportData) {
            this.getReportDataQueryResult(dimensionShrekDimMap, rowData, (DataMetricMergeCache<Long, ReportDataQueryResult>)dataMetricMergeCache);
        }
        return dataMetricMergeCache.getAllData();
    }

    private boolean check(ShrekReportDataQueryDTO queryDTO) {
        List dimList = queryDTO.getDimIdList();
        List dimValIdList = queryDTO.getDimValIdList();
        if (CollectionUtils.isEmpty((Collection)dimList) || CollectionUtils.isEmpty((Collection)dimValIdList)) {
            logger.info("\u67e5\u8be2\u7684\u7ef4\u5ea6\u4e3a\u7a7a...");
            return false;
        }
        if (Objects.isNull(queryDTO.getSystem())) {
            logger.info("\u4f20\u5165\u7684\u4f53\u7cfb\u4e3a\u7a7a...");
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u4f53\u7cfb\u4e3a\u7a7a", (String)"ReportDataQueryService_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        return true;
    }

    private List<ShrekDimension> getShrekQueryFilter(ShrekReportDataQueryDTO queryDTO, RelationDimensionShrekDimMap dimensionShrekDimMap) {
        Long reportPeriodId;
        Boolean effectFlag;
        if (!this.check(queryDTO)) {
            return Collections.emptyList();
        }
        String cubeName = dimensionShrekDimMap.getCubName();
        List dimList = queryDTO.getDimIdList();
        Map<Long, List<DimMember>> dimMemberIdGroupMap = queryDTO.getDimValIdList().stream().flatMap(Collection::stream).map(Long.class::cast).map(arg_0 -> ((RelationDimensionShrekDimMap)dimensionShrekDimMap).getDimMember(arg_0)).filter(Objects::nonNull).collect(Collectors.groupingBy(DimMember::getDimensionId));
        Map copyDimensionMap = dimensionShrekDimMap.copyDimensionMap();
        ArrayList<ShrekDimension> shrekQueryFilter = new ArrayList<ShrekDimension>(dimList.size());
        Set queryAllDimensionIds = queryDTO.getQueryAllDimensionIds();
        for (Dimension dimension : dimList) {
            DimensionType dimType = dimension.getDimType();
            if (dimType.isDetailDim()) continue;
            List dimMembers = dimMemberIdGroupMap.getOrDefault(dimension.getId(), Collections.emptyList()).stream().filter(dimType.getMemberTypeByDimensionType()::isInstance).map(DimMember::copy).collect(Collectors.toList());
            Dimension copyDimension = dimension.copy();
            copyDimension.setMemberList(dimMembers);
            shrekQueryFilter.add(this.convertAndAddNoneMemberIfNeed(cubeName, copyDimension, queryAllDimensionIds));
            copyDimensionMap.remove(dimension.getId());
        }
        if (EmptyUtil.isNoEmpty((Object)copyDimensionMap)) {
            for (Map.Entry entry : copyDimensionMap.entrySet()) {
                Dimension hideDimension = (Dimension)entry.getValue();
                if (hideDimension.getDimType().isVirtualDim()) continue;
                if (!queryDTO.isQueryAllDimData()) {
                    shrekQueryFilter.add(this.convertRootMember(cubeName, hideDimension));
                    continue;
                }
                shrekQueryFilter.add(this.convertNone(cubeName, hideDimension));
            }
        }
        if ((effectFlag = queryDTO.getEffectFlag()) != null) {
            shrekQueryFilter.add(ReportDataQueryService.createShrekFilter("effectflag", effectFlag != false ? "1" : "0"));
        } else if (EmptyUtil.isNoEmpty((Object)queryDTO.getEffectFlags())) {
            shrekQueryFilter.add(ReportDataQueryService.createShrekFilter("effectflag", queryDTO.getEffectFlags()));
        }
        Boolean bl = queryDTO.getMainTable();
        if (bl != null) {
            shrekQueryFilter.add(ReportDataQueryService.createShrekFilter("maintable", bl != false ? "1" : "0"));
        }
        if (EmptyUtil.isNoEmpty((Object)queryDTO.getAmountUnitList())) {
            shrekQueryFilter.add(ReportDataQueryService.createShrekFilter("amountunit", queryDTO.getAmountUnitList()));
        }
        if (EmptyUtil.isNoEmpty((Long)(reportPeriodId = queryDTO.getReportPeriodId()))) {
            shrekQueryFilter.add(ReportDataQueryService.createShrekFilter("ReportPeriodDim", dimensionShrekDimMap.getMultiDimMemberKey(reportPeriodId)));
        } else if (EmptyUtil.isNoEmpty((Object)queryDTO.getReportPeriodList())) {
            shrekQueryFilter.add(ReportDataQueryService.createShrekFilter("ReportPeriodDim", queryDTO.getReportPeriodList(), dimensionShrekDimMap));
        }
        return shrekQueryFilter;
    }

    private ShrekDimension convertAndAddNoneMemberIfNeed(String cubeName, Dimension copyDimension, Set<Long> queryAllDimensionIds) {
        ShrekDimension convert = ShrekModelConverter.convert((String)cubeName, (Dimension)copyDimension);
        if (copyDimension.getDimType().isSystemDim()) {
            return convert;
        }
        if (EmptyUtil.isEmpty(queryAllDimensionIds)) {
            return convert;
        }
        if (!queryAllDimensionIds.contains(copyDimension.getId())) {
            return convert;
        }
        ShrekMember noneMember = new ShrekMember();
        noneMember.setNumber(copyDimension.getNumber().replace(" ", "") + "None");
        noneMember.setCubeNumber(cubeName);
        noneMember.setDimNumber(convert.getNumber());
        convert.getDimMembers().add(noneMember);
        return convert;
    }

    private ShrekDimension convertNone(String cubeName, Dimension copyDimension) {
        ShrekDimension convert = ShrekModelConverter.convert((String)cubeName, (Dimension)copyDimension);
        ShrekMember noneMember = new ShrekMember();
        noneMember.setNumber(copyDimension.getNumber().replace(" ", "") + "None");
        noneMember.setCubeNumber(cubeName);
        noneMember.setDimNumber(convert.getNumber());
        convert.getDimMembers().add(noneMember);
        return convert;
    }

    private ShrekDimension convertRootMember(String cubeName, Dimension hideDimension) {
        ShrekDimension shrekDimension = new ShrekDimension();
        shrekDimension.setNumber(hideDimension.getNumber());
        shrekDimension.setCubeNumber(cubeName);
        ShrekMember rootMember = new ShrekMember();
        rootMember.setNumber(hideDimension.getNumber().replace(" ", "") + "Root");
        rootMember.setCubeNumber(cubeName);
        rootMember.setDimNumber(hideDimension.getNumber());
        shrekDimension.setDimMembers(Collections.singletonList(rootMember));
        return shrekDimension;
    }

    private void getReportDataQueryResult(RelationDimensionShrekDimMap dimensionShrekDimMap, ShrekReportData rowData, DataMetricMergeCache<Long, ReportDataQueryResult> dataMetricMergeCache) {
        ReportDataQueryResult reportDataQResult;
        String metricCode = rowData.getMetricCode();
        if ("offsetMetric".equals(metricCode)) {
            return;
        }
        ReportDataQueryResult reportDataQueryResult = new ReportDataQueryResult();
        reportDataQueryResult.setValue((Object)rowData.getMetricValue());
        reportDataQueryResult.setSystemId(dimensionShrekDimMap.getSystemId());
        List multiDimensions = rowData.getDimensions();
        List members = rowData.getMembers();
        ArrayList<TemplateDim> templateDimList = new ArrayList<TemplateDim>(multiDimensions.size());
        ArrayList<Long> memberIds = new ArrayList<Long>(multiDimensions.size());
        Dimension periodDim = dimensionShrekDimMap.getSystem().getMainDimensionByDimType(DimensionType.PERIOD);
        DimensionInfoBean dimensionInfoBean = new DimensionInfoBean();
        for (int i = 0; i < multiDimensions.size(); ++i) {
            String multiDimension = (String)multiDimensions.get(i);
            String memberShrekKey = (String)members.get(i);
            if (RelationDimensionShrekDimMap.isMultiCustomAddReportVersionDim((String)multiDimension)) {
                reportDataQueryResult.setVersion(Integer.valueOf(Integer.parseInt(memberShrekKey)));
                continue;
            }
            if (RelationDimensionShrekDimMap.isMultiCustomAddReportMainTableDim((String)multiDimension)) {
                reportDataQueryResult.setMainTable(Objects.equals("1", memberShrekKey));
                continue;
            }
            if (RelationDimensionShrekDimMap.isMultiCustomAddReportAmountUnitDim((String)multiDimension)) {
                reportDataQueryResult.setAmountUnit(AmountUnit.getByNumber((String)memberShrekKey));
                continue;
            }
            if (RelationDimensionShrekDimMap.isMultiCustomAddReportPeriodDim((String)multiDimension)) {
                reportDataQueryResult.setReportPeriodId(dimensionShrekDimMap.getRelationDimMemberId(periodDim.getId(), memberShrekKey));
                continue;
            }
            TemplateDim templateDimension = dimensionShrekDimMap.getRelationTemplateDimension(multiDimension);
            if (Objects.isNull(templateDimension)) continue;
            Long relationDimMemberId = dimensionShrekDimMap.getRelationDimMemberId(templateDimension.getDimensionId(), memberShrekKey);
            if (templateDimension.getDimType().isMetric()) {
                MetricMember metricDimMember = (MetricMember)dimensionShrekDimMap.getRelationDimMember(templateDimension.getDimensionId(), memberShrekKey);
                if (Objects.isNull(metricDimMember)) {
                    return;
                }
                MetricValueUtils.setMetricValue((TemplateMetricType)metricDimMember.getTemplateMetricType(), (ReportDataQueryResult)reportDataQueryResult, (BigDecimal)rowData.getMetricValue());
                reportDataQueryResult.putMetricVal(metricDimMember.getId(), (Object)rowData.getMetricValue());
                continue;
            }
            templateDimList.add(templateDimension);
            memberIds.add(relationDimMemberId);
            dimensionInfoBean.addDimensionInfo(templateDimension.getDimensionId(), (Object)relationDimMemberId);
        }
        reportDataQueryResult.setDimList(templateDimList);
        reportDataQueryResult.setDimIdList(templateDimList.stream().map(TemplateDim::getDimensionId).collect(Collectors.toList()));
        reportDataQueryResult.setDimValList(memberIds);
        if (Objects.isNull(reportDataQueryResult.getVersion())) {
            reportDataQueryResult.setVersion(Integer.valueOf(1));
        }
        if (Objects.isNull(reportDataQResult = (ReportDataQueryResult)dataMetricMergeCache.get(dimensionInfoBean, (Object)reportDataQueryResult.getReportPeriodId()))) {
            dataMetricMergeCache.addCache(dimensionInfoBean, (Object)reportDataQueryResult, () -> ((ReportDataQueryResult)reportDataQueryResult).getReportPeriodId());
            return;
        }
        reportDataQResult.merge(reportDataQueryResult);
    }

    private static ShrekDimension createShrekFilter(String dim, String mem) {
        ShrekDimension dimension = new ShrekDimension();
        dimension.setNumber(dim);
        ShrekMember shrekMember = new ShrekMember();
        shrekMember.setNumber(mem);
        dimension.setDimMembers((List)Lists.newArrayList((Object[])new ShrekMember[]{shrekMember}));
        return dimension;
    }

    private static ShrekDimension createShrekFilter(String dim, List<Long> memberIdList, RelationDimensionShrekDimMap dimensionShrekDimMap) {
        ShrekDimension dimension = new ShrekDimension();
        dimension.setNumber(dim);
        ArrayList<ShrekMember> dimMembers = new ArrayList<ShrekMember>(memberIdList.size());
        for (Long memberId : memberIdList) {
            String multiDimMemberKey = dimensionShrekDimMap.getMultiDimMemberKey(memberId);
            ShrekMember shrekMember = new ShrekMember();
            shrekMember.setNumber(multiDimMemberKey);
            dimMembers.add(shrekMember);
        }
        dimension.setDimMembers(dimMembers);
        return dimension;
    }

    private static ShrekDimension createShrekFilter(String dim, List<String> valueList) {
        ShrekDimension dimension = new ShrekDimension();
        dimension.setNumber(dim);
        ArrayList<ShrekMember> dimMembers = new ArrayList<ShrekMember>(valueList.size());
        for (String value : valueList) {
            ShrekMember shrekMember = new ShrekMember();
            shrekMember.setNumber(value);
            dimMembers.add(shrekMember);
        }
        dimension.setDimMembers(dimMembers);
        return dimension;
    }

    @Override
    public FpmOperateResult<List<ReportDataQResult>> queryReportData(ReportDataQParam qParam) {
        ReportDataQueryObject queryObject = new ReportDataQueryObject();
        queryObject.setDimValList(qParam.getDimValList());
        queryObject.setReportOrgIds(qParam.getReportOrgIds());
        queryObject.setReportPeriodId(qParam.getReportPeriodId());
        queryObject.setCurrencyIds(qParam.getCurrencyIds());
        queryObject.setSubjectIds(qParam.getSubjectIds());
        queryObject.setQueryDetail(qParam.isQueryDetail());
        queryObject.setResource("openApi");
        queryObject.setQueryDetail(Optional.ofNullable(qParam.isQueryDetail()).orElse(Boolean.FALSE));
        DimensionRepository dimRep = new DimensionRepository();
        FundPlanSystem system = dimRep.loadSystem(qParam.getSystemId());
        List systemDimList = system.getDimList();
        List dimIdList = qParam.getDimIdList();
        if (EmptyUtil.isNoEmpty((Object)dimIdList)) {
            ArrayList<Dimension> dimensionList = new ArrayList<Dimension>(dimIdList.size());
            for (ReportDataQParam.DimBaseInfo dimension : dimIdList) {
                Optional<Dimension> first = systemDimList.stream().filter(item -> item.getDimType() == dimension.getDimType() && item.getId().equals(dimension.getId())).findFirst();
                if (!first.isPresent()) {
                    return FpmOperateResult.error((String)ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f\u5f02\u5e38\uff0c\u4f53\u7cfb\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6", (String)"ReportDataQueryService_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
                }
                dimensionList.add(first.get());
            }
            queryObject.setDimIdList(dimensionList);
        }
        List<ReportDataQueryResult> reportDataQueryResults = this.queryReportDataByApi(queryObject);
        ArrayList<ReportDataQResult> resultList = new ArrayList<ReportDataQResult>(reportDataQueryResults.size());
        for (ReportDataQueryResult reportDataQueryResult : reportDataQueryResults) {
            ReportDataQResult reportDataQResult = new ReportDataQResult();
            reportDataQResult.setId(reportDataQueryResult.getId());
            reportDataQResult.setReportId(reportDataQueryResult.getReportId());
            reportDataQResult.setDimIdList(reportDataQueryResult.getDimIdList());
            reportDataQResult.setDimValList(reportDataQueryResult.getDimValList());
            reportDataQResult.setApplyPlanAmt(reportDataQueryResult.getApplyPlanAmt());
            reportDataQResult.setPlanAmt(reportDataQueryResult.getPlanAmt());
            reportDataQResult.setLockAmt(reportDataQueryResult.getLockAmt());
            reportDataQResult.setActAmt(reportDataQueryResult.getActAmt());
            reportDataQResult.setMainTable(reportDataQueryResult.isMainTable());
            reportDataQResult.setAmountUnit(reportDataQueryResult.getAmountUnit());
            resultList.add(reportDataQResult);
        }
        return FpmOperateResult.success(resultList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReportDataQueryResult> convert(DataSet reportDataDataSet, Map<Long, ReportTemplate> entryIdAndTemplateMap, Map<Long, List<Dimension>> entryIdAndDetailPlanMap, ReportDataQueryObject queryObject) {
        ArrayList<Object> resultList = new ArrayList<ReportDataQueryResult>(16);
        Map<String, Long> dimMap = new HashMap<String, Long>(2);
        HashMap<Long, Map<Long, String>> reportDataAuxMap = new HashMap<Long, Map<Long, String>>();
        HashMap<Long, ReportDataQueryResult> reportDataQueryResultMap = new HashMap<Long, ReportDataQueryResult>(2);
        int count = 1;
        Set<Long> systemIdSet = entryIdAndTemplateMap.values().stream().map(ReportTemplate::getSystemId).collect(Collectors.toSet());
        HashMap systemIdDetailMappingMap = new HashMap(systemIdSet.size());
        systemIdSet.forEach(systemId -> systemIdDetailMappingMap.put(systemId, DimensionMappingHelper.getReportPlanDetailMappingWithEntry(systemId)));
        try {
            while (reportDataDataSet.hasNext()) {
                Row rowData;
                Long entryId;
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("reportDataDataSet-forI,%s", count++));
                }
                if ((entryId = (rowData = reportDataDataSet.next()).getLong(String.join((CharSequence)".", "maindimentry", "id"))) == null || entryId <= 0L) continue;
                ReportDataQueryResult reportDataQuery = (ReportDataQueryResult)reportDataQueryResultMap.get(entryId);
                if (EmptyUtil.isNoEmpty((Object)reportDataQuery)) {
                    Map<Long, String> auxiliaryValMap = this.getAuxiliaryValMap(reportDataAuxMap, rowData);
                    reportDataQuery.setAuxiliaryValMap(auxiliaryValMap);
                    continue;
                }
                ReportTemplate reportTemplate = entryIdAndTemplateMap.get(entryId);
                List<Dimension> list = entryIdAndDetailPlanMap.get(entryId);
                ReportDataQueryResult reportDataQueryResult = new ReportDataQueryResult();
                reportDataQueryResult.setReportStatus(ReportStatus.getByVal((String)rowData.getString("planstatus")));
                reportDataQueryResult.setApplyPlanAmt(rowData.getBigDecimal("maindimentry.orgplanamt"));
                reportDataQueryResult.setPlanAmt(rowData.getBigDecimal("maindimentry.planamt"));
                reportDataQueryResult.setOffsetAmt(rowData.getBigDecimal("maindimentry.offsetamt"));
                reportDataQueryResult.setActAmt(rowData.getBigDecimal("maindimentry.realamt"));
                reportDataQueryResult.setLockAmt(rowData.getBigDecimal("maindimentry.lockamt"));
                reportDataQueryResult.setHoldActAmt(rowData.getBigDecimal("maindimentry.holdrealamt"));
                reportDataQueryResult.setHoldLockAmt(rowData.getBigDecimal("maindimentry.holdlockamt"));
                reportDataQueryResult.setReportPlanAmt(rowData.getBigDecimal("maindimentry.reportplanamt"));
                reportDataQueryResult.setOriginalPlanAmt(rowData.getBigDecimal("maindimentry.orgplanamt"));
                reportDataQueryResult.setPlanReferenceAmt(rowData.getBigDecimal("maindimentry.planreferenceamt"));
                reportDataQueryResult.setVersion(rowData.getInteger("maindimentry.version"));
                reportDataQueryResult.setReportId(rowData.getLong("id"));
                reportDataQueryResult.setReportPeriodId(rowData.getLong("maindimentry.entryreportperiod"));
                reportDataQueryResult.setMainTable(rowData.getBoolean("maindimentry.maintable").booleanValue());
                reportDataQueryResult.setRow(rowData.getInteger("maindimentry.origindatarow").intValue());
                reportDataQueryResult.setCol(rowData.getInteger("maindimentry.origindatacol").intValue());
                reportDataQueryResult.setId(rowData.getLong("maindimentry.id"));
                reportDataQueryResult.setReportPlanAmt(rowData.getBigDecimal("maindimentry.reportplanamt"));
                reportDataQueryResult.setSystemId(rowData.getLong("maindimentry.system"));
                reportDataQueryResult.setSmartGelFlag(rowData.getBoolean("maindimentry.smartgelflag").booleanValue());
                ArrayList<TemplateDim> dimList = new ArrayList<TemplateDim>(16);
                ArrayList<Object> dimValList = new ArrayList<Object>(16);
                TemplateUseType templateUse = reportTemplate.getTemplateUse();
                if (queryObject.isNeedDimIfValueIsNotEmpty()) {
                    reportTemplate.setTemplateUse(TemplateUseType.SUMMARY);
                }
                if (reportTemplate.getTemplateUse() == TemplateUseType.SUMMARY && dimMap.isEmpty()) {
                    DynamicObjectCollection dimColl = QueryServiceHelper.query((String)"fpm_dimension", (String)"id,number,basedata", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", (Object)reportTemplate.getSystemId())});
                    dimMap = dimColl.stream().collect(Collectors.toMap(item -> item.getString("number"), item -> item.getLong("id")));
                    Map<String, Long> customNumberIdMap = dimColl.stream().filter(dy -> Objects.equals(dy.getString("basedata"), DimensionType.CUSTOM.getNumber())).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLong("id")));
                    CustomDimThreadLocalHelper.set(customNumberIdMap);
                }
                this.dealDimMemberDataOfMainDim(rowData, dimList, dimValList, dimMap, reportTemplate, reportDataQueryResult);
                if (queryObject.isNeedDimIfValueIsNotEmpty()) {
                    reportTemplate.setTemplateUse(templateUse);
                }
                if (!("openApi".equals(queryObject.getResource()) && !queryObject.isQueryDetail().booleanValue() || CollectionUtils.isEmpty(list))) {
                    Map reportPlanDetailMappingWithEntry = (Map)systemIdDetailMappingMap.get(reportTemplate.getSystemId());
                    this.dealDimMemberDataOfDetailDim(rowData, dimList, dimValList, reportTemplate, list, reportPlanDetailMappingWithEntry);
                }
                reportDataQueryResult.setDimValList(dimValList);
                String amountUnitStr = rowData.getString(String.join((CharSequence)".", "maindimentry", "amountunit"));
                if (!StringUtils.isEmpty((Object)amountUnitStr)) {
                    reportDataQueryResult.setAmountUnit(AmountUnit.getByNumber((String)amountUnitStr));
                }
                Map<Long, String> auxiliaryValMap = this.getAuxiliaryValMap(reportDataAuxMap, rowData);
                reportDataQueryResult.setAuxiliaryValMap(auxiliaryValMap);
                reportDataQueryResult.setDimList(dimList);
                reportDataQueryResult.setDimIdList(dimList.stream().map(TemplateDim::getDimensionId).collect(Collectors.toList()));
                MetricValueUtils.fillMetricValMap((ReportDataQueryResult)reportDataQueryResult, (ReportTemplate)reportTemplate, (List)queryObject.getMetricMemberScope());
                resultList.add(reportDataQueryResult);
                reportDataQueryResultMap.put(rowData.getLong(String.join((CharSequence)".", "maindimentry", "id")), reportDataQueryResult);
            }
            if (queryObject.isSplit() && !CollectionUtils.isEmpty((Collection)queryObject.getMetricMemberScope())) {
                DynamicObjectCollection metricDOS = QueryServiceHelper.query((String)"fpm_member", (String)"id,metricpresettype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)queryObject.getMetricMemberScope())});
                Map<Object, String> metricMap = metricDOS.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getString("metricpresettype"), (k1, k2) -> k1));
                ArrayList<ReportDataQueryResult> newQueryResult = new ArrayList<ReportDataQueryResult>();
                for (ReportDataQueryResult reportDataQueryResult : resultList) {
                    Map auxiliaryValMap;
                    ReportTemplate reportTemplate = entryIdAndTemplateMap.get(reportDataQueryResult.getId());
                    TemplateDim metricTplDim = reportTemplate.getMetricTplDim();
                    if ((EmptyUtil.isEmpty((Object)metricTplDim) || MapUtils.isNotEmpty((Map)reportDataQueryResult.getAuxiliaryValMap())) && MapUtils.isNotEmpty((Map)(auxiliaryValMap = reportDataQueryResult.getAuxiliaryValMap()))) {
                        for (Map.Entry auxiliaryValEntry : auxiliaryValMap.entrySet()) {
                            ReportDataQueryResult currResult = new ReportDataQueryResult(reportDataQueryResult);
                            newQueryResult.add(currResult);
                            currResult.setValue(auxiliaryValEntry.getValue());
                            currResult.getDimList().add(metricTplDim);
                            currResult.getDimValList().add(auxiliaryValEntry.getKey());
                            currResult.getDimIdList().add(metricTplDim.getDimensionId());
                        }
                    }
                    for (Map.Entry<Object, String> entry : metricMap.entrySet()) {
                        ReportDataQueryResult currResult = new ReportDataQueryResult(reportDataQueryResult);
                        newQueryResult.add(currResult);
                        TemplateMetricType type = (TemplateMetricType)ITypeEnum.getByNumber((String)entry.getValue(), TemplateMetricType.class);
                        currResult.setValue(ReportDataQueryService.getMetricValue(type, currResult));
                        currResult.getDimList().add(metricTplDim);
                        currResult.getDimValList().add(entry.getKey());
                        currResult.getDimIdList().add(metricTplDim.getDimensionId());
                    }
                }
                resultList = newQueryResult;
            }
        }
        finally {
            CustomDimThreadLocalHelper.clean();
        }
        return resultList;
    }

    private static Object getMetricValue(TemplateMetricType type, ReportDataQueryResult result) {
        if (type == null) {
            return BigDecimal.ZERO;
        }
        switch (type) {
            case PLANAMT: {
                return result.getPlanAmt();
            }
            case ORIGINALPLANAMT: {
                return result.getOriginalPlanAmt();
            }
            case REPORTPLANAMT: {
                return result.getReportPlanAmt();
            }
            case ACTMAT: {
                return result.getActAmt();
            }
            case LOCKAMT: {
                return result.getLockAmt();
            }
        }
        return BigDecimal.ZERO;
    }

    private Map<Long, String> getAuxiliaryValMap(Map<Long, Map<Long, String>> reportDataAuxMap, Row rowData) {
        Map<Long, String> auxiliaryValMap = reportDataAuxMap.get(rowData.getLong(String.join((CharSequence)".", "maindimentry", "id")));
        if (auxiliaryValMap == null) {
            auxiliaryValMap = new HashMap<Long, String>(1);
        }
        this.dealDimMemberDataOfAuxDim(rowData, auxiliaryValMap);
        reportDataAuxMap.put(rowData.getLong(String.join((CharSequence)".", "maindimentry", "id")), auxiliaryValMap);
        return auxiliaryValMap;
    }

    private void dealDimMemberDataOfAuxDim(Row rowData, Map<Long, String> auxiliaryValMap) {
        Object auxBdtype = rowData.get(String.join((CharSequence)".", "auxentry", "aux_bdtype"));
        Object auxContent = rowData.get(String.join((CharSequence)".", "auxentry", "aux_content"));
        if (EmptyUtil.isNoEmpty((Object)auxBdtype) || EmptyUtil.isNoEmpty((Object)auxContent)) {
            auxiliaryValMap.put((Long)auxBdtype, (String)auxContent);
        }
    }

    private void dealDimMemberDataOfMainDim(Row rowData, List<TemplateDim> dimList, List<Object> dimValList, Map<String, Long> dimMap, ReportTemplate reportTemplate, ReportDataQueryResult reportDataQueryResult) {
        List<TemplateDim> allTemplateDim = reportTemplate.getAllTemplateDim();
        Map<String, List<TemplateDim>> templateMainDimMap = allTemplateDim.stream().filter(item -> item.getDimType() != DimensionType.DETAILDIM).collect(Collectors.groupingBy(o -> o.getDimType().getNumber()));
        ReportPoConverter.dealDimMemberDataOfMainDim(rowData, dimList, dimMap, templateMainDimMap, dimValList, reportTemplate);
        boolean isAuxiliaryInfo = ReportHelper.isAuxiliaryInfo(dimList, allTemplateDim);
        reportDataQueryResult.setAuxiliaryInfo(isAuxiliaryInfo);
    }

    private void dealDimMemberDataOfDetailDim(Row rowData, List<TemplateDim> dimList, List<Object> dimValList, ReportTemplate reportTemplate, List<Dimension> detailDimList, Map<String, String> reportPlanDetailMappingWithEntry) {
        for (Map.Entry<String, String> detailDimEntry : reportPlanDetailMappingWithEntry.entrySet()) {
            TemplateDim templateDim;
            String key = detailDimEntry.getKey();
            String widgetSign = detailDimEntry.getValue();
            Object value = rowData.get(widgetSign);
            List<TemplateDim> allTemplateDim = reportTemplate.getAllTemplateDim();
            List dims = allTemplateDim.stream().filter(Objects::nonNull).filter(o -> o.getDimType() == DimensionType.DETAILDIM && o.getDetailDimType().getNumber().equals(key)).collect(Collectors.toList());
            TemplateDim templateDim2 = templateDim = dims.size() == 0 ? null : (TemplateDim)dims.get(0);
            if (templateDim == null) continue;
            Dimension dimension = detailDimList.stream().filter(item -> item.getId().equals(templateDim.getDimensionId())).findFirst().get();
            MemberType memberType = dimension.getMemberType();
            value = this.detailColumnHandleDefaultValue(key, value, memberType);
            dimList.add(templateDim);
            dimValList.add(value);
        }
    }

    private Object detailColumnHandleDefaultValue(String key, Object value, MemberType memberType) {
        if (DetailDimType.isExtraCode((String)key)) {
            if (value != null && !StringUtils.isEmpty((Object)value.toString())) {
                if (MemberType.DATE == memberType) {
                    value = new Date(Long.parseLong(value.toString()));
                } else if (MemberType.BASE_DATA == memberType) {
                    value = Long.valueOf(value.toString());
                }
            }
            if (MemberType.AMOUNT == memberType && StringUtils.isEmpty((Object)value)) {
                value = BigDecimal.ZERO;
            }
        }
        return value;
    }

    @Override
    public List<ReportData> queryReportData(QueryServiceParamConsumer<ReportDataQueryObject> consumer) {
        ReportDataQueryObject reportDataQueryObject = new ReportDataQueryObject();
        consumer.accept((Object)reportDataQueryObject);
        List<ReportDataQueryResult> reportDataQueryResults = this.queryReportData(reportDataQueryObject);
        return ReportHelper.convert(reportDataQueryResults);
    }

    private Map<Long, Integer> getCustomDimSeqMap(List<Dimension> dimList) {
        List customDimIds = dimList.stream().filter(dim -> DimensionType.CUSTOM == dim.getDimType()).map(Dimension::getId).collect(Collectors.toList());
        ICustomDimSeqService iCustomDimSeqService = (ICustomDimSeqService)FpmServiceFactory.getBizService(ICustomDimSeqService.class);
        return iCustomDimSeqService.loadCustomDimSeqMapByIds(customDimIds);
    }

    private void handleCustomDimQFilter(Long dimId, List<Object> dimValList, List<QFilter> qFilterList, DimensionType dimType, Map<Long, Integer> customDimSeqMap) {
        if (DimensionType.CUSTOM != dimType) {
            return;
        }
        Integer seq = customDimSeqMap.get(dimId);
        String customProperty = (String)CustomDimSeqServiceImpl.seq2ReportCustomPropertyMap.get(seq);
        qFilterList.add(new QFilter("maindimentry." + customProperty, "in", dimValList));
    }

    static {
        MAINDIM_ENTRY_MAPPING_MAP.put(DimensionType.ORG.getNumber(), String.join((CharSequence)".", "maindimentry", "orgmem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimensionType.CURRENCY.getNumber(), String.join((CharSequence)".", "maindimentry", "currencymem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimensionType.PERIOD.getNumber(), String.join((CharSequence)".", "maindimentry", "periodmem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimensionType.SUBJECTS.getNumber(), String.join((CharSequence)".", "maindimentry", "subjectmem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimensionType.COMPANY.getNumber(), String.join((CharSequence)".", "maindimentry", "companymem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimensionType.SETTLEMENT_TYPE.getNumber(), String.join((CharSequence)".", "maindimentry", "settletypemem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimensionType.CUSTOM.getNumber(), String.join((CharSequence)",", String.join((CharSequence)".", "maindimentry", "extmem1"), String.join((CharSequence)".", "maindimentry", "extmem2"), String.join((CharSequence)".", "maindimentry", "extmem3")));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.CONNTERPARTY_TYPE.getNumber(), String.join((CharSequence)".", "detailentry", "opusertype"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.COUNTERPARTY_NAME.getNumber(), String.join((CharSequence)".", "detailentry", "opusername"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.BANK_CATE.getNumber(), String.join((CharSequence)".", "detailentry", "bankcate"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.CONTRACT_NO.getNumber(), String.join((CharSequence)".", "detailentry", "contractno"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.CONTRACT_NAME.getNumber(), String.join((CharSequence)".", "detailentry", "contractname"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.PLAN_DATE.getNumber(), String.join((CharSequence)".", "detailentry", "plandate"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.BANK_ACCOUNT.getNumber(), String.join((CharSequence)".", "detailentry", "bankaccount"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.BUSINESS_PARTNER.getNumber(), String.join((CharSequence)".", "detailentry", "businesspartner"));
        TYPE_MAPPING_MAP.putAll(MAINDIM_ENTRY_MAPPING_MAP);
        TYPE_MAPPING_MAP.putAll(DETAILDIM_ENTRY_MAPPING_MAP);
        logger = LogFactory.getLog(ReportDataQueryService.class);
    }
}

