/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.save.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IInOutCollectSaveService;
import kd.tmc.fpm.business.dataproc.save.domain.DataSaveResult;
import kd.tmc.fpm.business.domain.enums.ApplyStatus;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.inoutpool.InoutCollect;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.repository.IInoutCollectRepository;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.utils.GlobalIdUtil;

public class InOutCollectSaveServiceImpl
implements IInOutCollectSaveService {
    private final IInoutCollectRepository iInoutCollectRepository = (IInoutCollectRepository)FpmServiceFactory.getBizService(IInoutCollectRepository.class);
    private static final String DEL_COLLECT_RELATE_REPORT_SQL = "delete t_fpm_collectrelatereport where fid = ? and fentryid = ? and frelateplanreportid = ?";
    private static final String UPDATE_IN_OUT_COLLECT_SQL = "update t_fpm_inoutcollect set fapplystatus = ?, fmodifierid = ?, fmodifytime = ? where fid = ?";
    private static final String INSERT_COLLECT_RELATE_REPORT_SQL = "INSERT INTO t_fpm_collectrelatereport (fid, fentryid, fseq, fbatchno, frelateplanreport, frelateplanreportid, fbodysysid, freporttypeid, freportorgid, freportperiodid, freferplandate, freferplanamount) VALUES(?, ?, 0, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    @Override
    public void saveOrUpdateReportRelation(List<Long> ids, DataSaveResult dataSaveResult) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List inoutCollectList = this.iInoutCollectRepository.load(ids);
        Map inOutBillIdAndReportDataIdMap = dataSaveResult.getSourceIdAndIdMap();
        List deleteReportDataList = dataSaveResult.getDeleteMainDataList();
        List saveReportDataList = dataSaveResult.getSaveMainDataList();
        LinkedList<Object[]> delCollectRelateReportSqlParamList = new LinkedList<Object[]>();
        LinkedList<Object[]> addCollectRelateReportSqlParamList = new LinkedList<Object[]>();
        LinkedList<Object[]> updateInoutCollectSqlParamList = new LinkedList<Object[]>();
        Long currUserId = RequestContext.get().getCurrUserId();
        Date currDate = new Date();
        for (InoutCollect currInOutData : inoutCollectList) {
            Long billId = currInOutData.getId();
            List inoutReportRelationList = currInOutData.getInoutReportRelationList();
            inoutReportRelationList = Objects.isNull(inoutReportRelationList) ? new ArrayList(0) : inoutReportRelationList;
            HashSet reportDataIdSet = new HashSet((Collection)inOutBillIdAndReportDataIdMap.get(billId));
            Set<Long> reportIdSet = deleteReportDataList.stream().filter(dy -> reportDataIdSet.contains(dy.getPkValue())).map(dy -> (DynamicObject)dy.getParent()).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            boolean deleteFlag = this.removeReportRelationIfNeed(inoutReportRelationList, reportIdSet, billId, delCollectRelateReportSqlParamList);
            Map<Long, DynamicObject> reportIdToReportDataMap = saveReportDataList.stream().filter(dy -> reportDataIdSet.contains(dy.getPkValue())).collect(Collectors.toMap(dy -> {
                DynamicObject reportDy = (DynamicObject)dy.getParent();
                return reportDy.getLong("id");
            }, Function.identity(), (a, b) -> b));
            boolean insertFlag = this.addReportRelationIfNeed(inoutReportRelationList, reportIdToReportDataMap, currInOutData, addCollectRelateReportSqlParamList, delCollectRelateReportSqlParamList);
            if (!deleteFlag && !insertFlag) continue;
            ApplyStatus applyStatus = CollectionUtils.isEmpty((Collection)inoutReportRelationList) ? ApplyStatus.NOT_APPLY : currInOutData.getApplyStatus();
            currInOutData.setApplyStatus(applyStatus);
            updateInoutCollectSqlParamList.add(new Object[]{applyStatus.getNumber(), currUserId, currDate, currInOutData.getId()});
        }
        if (EmptyUtil.isNoEmpty(updateInoutCollectSqlParamList)) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)UPDATE_IN_OUT_COLLECT_SQL, updateInoutCollectSqlParamList);
        }
        if (EmptyUtil.isNoEmpty(delCollectRelateReportSqlParamList)) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)DEL_COLLECT_RELATE_REPORT_SQL, delCollectRelateReportSqlParamList);
        }
        if (EmptyUtil.isNoEmpty(addCollectRelateReportSqlParamList)) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)INSERT_COLLECT_RELATE_REPORT_SQL, addCollectRelateReportSqlParamList);
        }
    }

    @Override
    public void saveOrUpdateReportRelation(Report report, Map<Long, List<ReportData>> bizBillAndRDMap) {
        LinkedList<Object[]> delCollectRelateReportSqlParamList = new LinkedList<Object[]>();
        LinkedList<Object[]> addCollectRelateReportSqlParamList = new LinkedList<Object[]>();
        HashMap<Long, ApplyStatus> updateInoutCollApplyStsMap = new HashMap<Long, ApplyStatus>(32);
        HashSet<Long> reportIdSet = new HashSet<Long>(1);
        reportIdSet.add(report.getId());
        List needCleanColl = this.iInoutCollectRepository.loadByReportId(reportIdSet);
        Map needCleanMap = needCleanColl.stream().collect(Collectors.toMap(InoutCollect::getId, Function.identity()));
        if (!EmptyUtil.isEmpty((Collection)needCleanColl)) {
            for (InoutCollect inoutCollect : needCleanColl) {
                List inoutReportRelationList = inoutCollect.getInoutReportRelationList();
                inoutReportRelationList = Objects.isNull(inoutReportRelationList) ? new ArrayList(0) : inoutReportRelationList;
                this.removeReportRelationIfNeed(inoutReportRelationList, reportIdSet, inoutCollect.getId(), delCollectRelateReportSqlParamList);
                inoutCollect.setInoutReportRelationList(inoutReportRelationList);
                if (!EmptyUtil.isEmpty((Collection)inoutReportRelationList)) continue;
                inoutCollect.setApplyStatus(ApplyStatus.NOT_APPLY);
                updateInoutCollApplyStsMap.put(inoutCollect.getId(), inoutCollect.getApplyStatus());
            }
        }
        if (!EmptyUtil.isEmpty(bizBillAndRDMap.keySet())) {
            List inoutCollectList = this.iInoutCollectRepository.load(new ArrayList<Long>(bizBillAndRDMap.keySet()));
            Long systemId = report.getSystemId();
            long[] entryIdArr = GlobalIdUtil.genGlobalLongIds((int)inoutCollectList.size());
            int i = 0;
            for (InoutCollect currInOutData : inoutCollectList) {
                Long id2 = currInOutData.getId();
                InoutCollect inOutData = needCleanMap.getOrDefault(id2, currInOutData);
                List<ReportData> reportDataList = bizBillAndRDMap.get(id2);
                Object orgId = reportDataList.get(0).getDimValByDimType(DimensionType.ORG, null);
                Object periodId = reportDataList.get(0).getDimValByDimType(DimensionType.PERIOD, null);
                inOutData.setApplyStatus(ApplyStatus.APPLYING);
                updateInoutCollApplyStsMap.put(currInOutData.getId(), inOutData.getApplyStatus());
                List inoutReportRelationList = inOutData.getInoutReportRelationList();
                inoutReportRelationList = Objects.isNull(inoutReportRelationList) ? new ArrayList(0) : inoutReportRelationList;
                this.removeReportRelationIfNeed(inoutReportRelationList, reportIdSet, inOutData.getId(), delCollectRelateReportSqlParamList);
                InoutCollect.InoutReportRelation relationInfo = new InoutCollect.InoutReportRelation();
                relationInfo.setBodySysId(systemId);
                relationInfo.setBatchNo(inOutData.getBatchNo());
                relationInfo.setPlanReport(report.getName());
                relationInfo.setPlanReportId(report.getId());
                relationInfo.setReportTypeId(report.getReportPeriodType().getReportPeriodId());
                relationInfo.setReportOrgId((Long)orgId);
                relationInfo.setReportPeriodId((Long)periodId);
                relationInfo.setReferPlanDate(inOutData.getCurrentPlanDate());
                relationInfo.setReferPlanAmount(inOutData.getCurrentPlanAmount());
                inoutReportRelationList.add(relationInfo);
                long entryId = i < entryIdArr.length ? entryIdArr[i] : GlobalIdUtil.genGlobalLongId();
                ++i;
                Object[] addParam = new Object[]{currInOutData.getId(), entryId, relationInfo.getBatchNo(), relationInfo.getPlanReport(), relationInfo.getPlanReportId(), relationInfo.getBodySysId(), relationInfo.getReportTypeId(), relationInfo.getReportOrgId(), relationInfo.getReportPeriodId(), relationInfo.getReferPlanDate(), relationInfo.getReferPlanAmount()};
                addCollectRelateReportSqlParamList.add(addParam);
            }
        }
        if (EmptyUtil.isNoEmpty(updateInoutCollApplyStsMap)) {
            Long currUserId = RequestContext.get().getCurrUserId();
            Date currDate = new Date();
            LinkedList updateInoutCollectSqlParamList = new LinkedList();
            updateInoutCollApplyStsMap.forEach((id, applyStsEnum) -> updateInoutCollectSqlParamList.add(new Object[]{applyStsEnum.getNumber(), currUserId, currDate, id}));
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)UPDATE_IN_OUT_COLLECT_SQL, updateInoutCollectSqlParamList);
        }
        if (EmptyUtil.isNoEmpty(delCollectRelateReportSqlParamList)) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)DEL_COLLECT_RELATE_REPORT_SQL, delCollectRelateReportSqlParamList);
        }
        if (EmptyUtil.isNoEmpty(addCollectRelateReportSqlParamList)) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)INSERT_COLLECT_RELATE_REPORT_SQL, addCollectRelateReportSqlParamList);
        }
    }

    private InoutCollect.InoutReportRelation buildRelationInfo(Long reportId, DynamicObject reportDataDy, InoutCollect currInOutData) {
        DynamicObject reportDy = (DynamicObject)reportDataDy.getParent();
        InoutCollect.InoutReportRelation relationInfo = new InoutCollect.InoutReportRelation();
        relationInfo.setBodySysId(reportDataDy.getLong("system"));
        relationInfo.setBatchNo(currInOutData.getBatchNo());
        relationInfo.setPlanReport(reportDy.getString("name"));
        relationInfo.setPlanReportId(reportId);
        Long reportTypeId = reportDy.getLong("reportperiod.reporttype.id");
        relationInfo.setReportTypeId(reportTypeId);
        relationInfo.setReportOrgId(reportDataDy.getLong("orgmem"));
        relationInfo.setReportPeriodId(reportDataDy.getLong("periodmem"));
        relationInfo.setReferPlanDate(currInOutData.getCurrentPlanDate());
        relationInfo.setReferPlanAmount(currInOutData.getCurrentPlanAmount());
        return relationInfo;
    }

    private boolean removeReportRelationIfNeed(List<InoutCollect.InoutReportRelation> inoutReportRelationList, Set<Long> needRemoveReportIdSet, Long inoutBillId, List<Object[]> delCollectRelateReportSqlParamList) {
        if (EmptyUtil.isEmpty(inoutReportRelationList) || EmptyUtil.isEmpty(needRemoveReportIdSet)) {
            return false;
        }
        boolean deleteFlag = false;
        Iterator<InoutCollect.InoutReportRelation> iterator = inoutReportRelationList.iterator();
        while (iterator.hasNext()) {
            InoutCollect.InoutReportRelation relation = iterator.next();
            if (!needRemoveReportIdSet.contains(relation.getPlanReportId())) continue;
            deleteFlag = true;
            delCollectRelateReportSqlParamList.add(new Object[]{inoutBillId, relation.getId(), relation.getPlanReportId()});
            iterator.remove();
        }
        return deleteFlag;
    }

    private boolean addReportRelationIfNeed(List<InoutCollect.InoutReportRelation> inoutReportRelationList, Map<Long, DynamicObject> reportIdToReportDataMap, InoutCollect currInOutData, List<Object[]> addCollectRelateReportSqlParamList, List<Object[]> delCollectRelateReportSqlParamList) {
        if (EmptyUtil.isEmpty(reportIdToReportDataMap)) {
            return false;
        }
        boolean insertFlag = true;
        Iterator<InoutCollect.InoutReportRelation> iterator = inoutReportRelationList.iterator();
        while (iterator.hasNext()) {
            InoutCollect.InoutReportRelation relation = iterator.next();
            if (!reportIdToReportDataMap.containsKey(relation.getPlanReportId())) continue;
            delCollectRelateReportSqlParamList.add(new Object[]{currInOutData.getId(), relation.getId(), relation.getPlanReportId()});
            iterator.remove();
        }
        long[] entryIdArr = GlobalIdUtil.genGlobalLongIds((int)reportIdToReportDataMap.size());
        int i = 0;
        for (Map.Entry<Long, DynamicObject> entry : reportIdToReportDataMap.entrySet()) {
            Long reportId = entry.getKey();
            DynamicObject reportDataDy = entry.getValue();
            InoutCollect.InoutReportRelation relationInfo = this.buildRelationInfo(reportId, reportDataDy, currInOutData);
            inoutReportRelationList.add(relationInfo);
            long entryId = i < entryIdArr.length ? entryIdArr[i] : GlobalIdUtil.genGlobalLongId();
            ++i;
            Object[] addParam = new Object[]{currInOutData.getId(), entryId, relationInfo.getBatchNo(), relationInfo.getPlanReport(), relationInfo.getPlanReportId(), relationInfo.getBodySysId(), relationInfo.getReportTypeId(), relationInfo.getReportOrgId(), relationInfo.getReportPeriodId(), relationInfo.getReferPlanDate(), relationInfo.getReferPlanAmount()};
            addCollectRelateReportSqlParamList.add(addParam);
        }
        return insertFlag;
    }
}

