/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.formula;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.formula.IReportFormulaManager;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.helper.FormulaHelper;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.IDAGManager;
import kd.tmc.fpm.business.spread.formula.IDAGVisit;
import kd.tmc.fpm.business.spread.formula.impl.DAGEdge;
import kd.tmc.fpm.business.spread.formula.impl.DAGManager;
import kd.tmc.fpm.business.spread.formula.impl.DAGNode;
import kd.tmc.fpm.business.spread.formula.impl.DAGNodeVisitListener;
import kd.tmc.fpm.business.spread.formula.impl.DAGVisit;
import org.apache.commons.collections.CollectionUtils;

public class SubjectFindReportTreeNodeFormulaManager
implements IReportFormulaManager<Long> {
    private Report report;
    private FundPlanSystem system;
    private IDAGManager<Long> dagManager;
    private IDAGVisit<Long> dagVisit;
    private List<Formula> formulaList;
    private Dimension subjectDim;

    public SubjectFindReportTreeNodeFormulaManager(Report report, FundPlanSystem system) {
        this.report = report;
        this.system = system;
        this.init();
    }

    private void init() {
        this.initDim();
        this.initFormulaInfo();
        this.initDagManager();
    }

    private void initFormulaInfo() {
        List<Object> accountSettings = this.report.getTemplate().getAccountSettings();
        if (ReportPlanType.REPORTPLAN == this.report.getReportPlanType()) {
            accountSettings = accountSettings.stream().filter(Objects::nonNull).filter(item -> ReportInputType.SUMMARY == item.getInputType() || ReportInputType.FORMULA == item.getInputType()).collect(Collectors.toList());
        }
        this.formulaList = new ArrayList<Formula>(accountSettings.size());
        for (TemplateAccountSetting targetAcctSetting : accountSettings) {
            AccountMember currentMember;
            Formula formulaInfo = targetAcctSetting.buildFormulaInfo();
            if (formulaInfo == null && (formulaInfo = FormulaHelper.parseSubject((AccountMember)(currentMember = (AccountMember)this.subjectDim.getDimMemberById(targetAcctSetting.getAccountMemId(), AccountMember.class)))) == null) continue;
            this.formulaList.add(formulaInfo);
        }
    }

    private void initDagManager() {
        this.dagManager = new DAGManager();
        for (Formula formula : this.formulaList) {
            FormulaOperationVal leftVal = formula.getLeftVal();
            if (Objects.isNull(leftVal)) continue;
            List rightValList = formula.getRightValList();
            DAGNode leftNode = this.dagManager.get((Object)Long.valueOf(leftVal.getName()));
            for (FormulaOperationVal formulaOperation : rightValList) {
                if (Objects.isNull(formulaOperation.getName())) continue;
                DAGEdge rightNode = new DAGEdge(this.dagManager.get((Object)Long.valueOf(formulaOperation.getName())));
                leftNode.addEdge(rightNode);
            }
        }
        this.dagVisit = new DAGVisit(this.dagManager);
    }

    private void initDim() {
        this.subjectDim = this.system.getMainDimensionByDimType(DimensionType.SUBJECTS);
    }

    public List<Long> updateData(Long updateVal) {
        return this.findSubjectId(Collections.singletonList(updateVal));
    }

    public List<Long> updateData(List<Long> updateValList) {
        return this.findSubjectId(updateValList);
    }

    public List<Long> findEffectData(List<Long> sourceSubjects) {
        return this.findSubjectId(sourceSubjects);
    }

    public List<Long> findEffectData(Set<Long> sourceSubjects) {
        return this.findSubjectId(new ArrayList<Long>(sourceSubjects));
    }

    private List<Long> findSubjectId(List<Long> sourceSubjects) {
        if (CollectionUtils.isEmpty(sourceSubjects)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        this.dagVisit = new DAGVisit(this.dagManager);
        HashSet<Long> effectiveSubjectsIds = new HashSet<Long>(sourceSubjects.size() * 2);
        DAGNodeVisitListener listener = node -> effectiveSubjectsIds.add((Long)node.getVal());
        this.dagVisit.addNodeVisitListener(listener);
        for (Long subjectMemId : sourceSubjects) {
            DAGNode changeNode = this.dagManager.get((Object)subjectMemId);
            if (changeNode == null) continue;
            this.dagVisit.orderVisitNode(changeNode);
        }
        this.fillRelateNode(effectiveSubjectsIds, new HashSet<Long>(sourceSubjects));
        return new ArrayList<Long>(effectiveSubjectsIds);
    }

    private void fillRelateNode(Set<Long> relateNodes, Set<Long> sourceDataSet) {
        List<Long> sourceNodes = this.getOrderRelateNodeList(relateNodes);
        Map vertexMap = this.dagManager.getVertexMap();
        for (Long treeNode : sourceNodes) {
            DAGNode treeNodeDAGNode = (DAGNode)vertexMap.get(treeNode);
            if (EmptyUtil.isEmpty((Object)treeNodeDAGNode)) continue;
            this.doFillRelateNode(relateNodes, (DAGNode<Long>)treeNodeDAGNode, sourceDataSet);
        }
    }

    private List<Long> getOrderRelateNodeList(Set<Long> relateNodes) {
        List orderedList = this.dagManager.getOrderedList();
        HashMap<Object, Integer> orderMap = new HashMap<Object, Integer>(orderedList.size());
        for (int i = 0; i < orderedList.size(); ++i) {
            orderMap.putIfAbsent(((DAGNode)orderedList.get(i)).getVal(), i);
        }
        return relateNodes.stream().sorted(Comparator.comparing(treeNode -> orderMap.getOrDefault(treeNode, 0))).collect(Collectors.toList());
    }

    private void doFillRelateNode(Set<Long> relateTreeNode, DAGNode<Long> treeNodeDAGNode, Set<Long> sourceDataSet) {
        Long treeNodeDAGNodeVal = (Long)treeNodeDAGNode.getVal();
        relateTreeNode.add(treeNodeDAGNodeVal);
        sourceDataSet.add(treeNodeDAGNodeVal);
        Set edges = treeNodeDAGNode.getEdges();
        if (EmptyUtil.isEmpty((Collection)edges)) {
            return;
        }
        List treeNodeList = edges.stream().map(DAGEdge::getDestNode).map(DAGNode::getVal).filter(sourceDataSet::contains).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(treeNodeList)) {
            for (DAGEdge edge : edges) {
                DAGNode destNode = edge.getDestNode();
                if (EmptyUtil.isEmpty((Object)destNode) || EmptyUtil.isEmpty((Long)((Long)destNode.getVal()))) continue;
                relateTreeNode.add((Long)destNode.getVal());
                sourceDataSet.add((Long)destNode.getVal());
            }
            return;
        }
        for (DAGEdge edge : edges) {
            DAGNode destNode = edge.getDestNode();
            this.doFillRelateNode(relateTreeNode, (DAGNode<Long>)destNode, sourceDataSet);
        }
    }
}

