/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DetailDataType;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ImportDataTypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.WarpBean;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.ImportDataContext;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportFormHeader;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.IReportImportDataService;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;
import kd.tmc.fpm.business.utils.ImportDataHelper;
import kd.tmc.fpm.business.utils.ImportDateTimeHelper;
import kd.tmc.fpm.business.utils.POIHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;

public class ReportImportDataServiceImpl
implements IReportImportDataService {
    private static final Map<String, String> COUNTER_PARTY_TYPE_MAP = new HashMap<String, String>(4);
    private static final int ROW_OFFSET = 4;
    private static final int COL_OFFSET = 1;

    public List<ReportFormHeader> acquireHeader(Report report, FundPlanSystem system) {
        ArrayList<ReportFormHeader> headerInfo = new ArrayList<ReportFormHeader>();
        ReportTemplate template = report.getTemplate();
        headerInfo.add(new ReportFormHeader(1, 1, system.getNumber(), system.getName(), ImportDataTypeEnum.BODY_SYSTEM));
        headerInfo.add(new ReportFormHeader(2, 1, report.getNumber(), report.getName(), ImportDataTypeEnum.REPORT));
        List periodMemberLst = report.getPeriodMemberList();
        String periodTypeStr = "-";
        String periodTypeNumber = "-";
        String periodStr = "-";
        String periodNumber = "-";
        if (EmptyUtil.isNoEmpty((Object)periodMemberLst)) {
            PeriodMember periodMember = (PeriodMember)periodMemberLst.get(0);
            ReportPeriodType reportPeriodType = system.getReportTypeList().stream().filter(rpt -> Objects.equals(periodMember.getPeriodTypeId(), rpt.getReportPeriodId())).findFirst().get();
            periodStr = periodMember.getName();
            periodNumber = periodMember.getLongNumber();
            periodTypeNumber = reportPeriodType.getNumber();
            periodTypeStr = reportPeriodType.getName();
        }
        headerInfo.add(new ReportFormHeader(3, 1, periodTypeNumber, periodTypeStr, ImportDataTypeEnum.PERIOD_DIM));
        headerInfo.add(new ReportFormHeader(4, 1, periodNumber, periodStr, ImportDataTypeEnum.PERIOD_MEMBER));
        int currIdx = 4;
        Map dimensionMap = system.getDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity()));
        if (CollectionUtils.isNotEmpty(template.getPageDimList())) {
            for (int i = 0; i < template.getPageDimList().size(); ++i) {
                ReportFormHeader pageDimHeaderInfo = new ReportFormHeader(++currIdx, 1, ImportDataTypeEnum.PAGE_DIM);
                TemplateDim templateDim = template.getPageDimList().get(i);
                Dimension dimension = (Dimension)dimensionMap.get(templateDim.getDimensionId());
                pageDimHeaderInfo.setDimensionNumber(dimension.getNumber());
                headerInfo.add(pageDimHeaderInfo);
            }
        }
        String amountUnit = template.getAmountUnit().getName();
        String amountNumber = template.getAmountUnit().getNumber();
        headerInfo.add(new ReportFormHeader(++currIdx, 1, amountNumber, amountUnit, ImportDataTypeEnum.CURRENCY));
        if (template.getTemplateType() == TemplateType.DETAIL) {
            headerInfo.add(new ReportFormHeader(++currIdx, 1, ImportDataTypeEnum.DETAIL_ROW_INFO));
        }
        return headerInfo;
    }

    public int getColOffset() {
        return 1;
    }

    public int getRowOffset() {
        return 4;
    }

    public void convertToReport(ImportDataContext context) {
        if (context.getReport().getTemplate().getTemplateType() == TemplateType.DETAIL) {
            this.handleDetailModel(context);
        } else {
            this.handleFixModel(context);
        }
    }

    private void handleFixModel(ImportDataContext context) {
        Report report = context.getReport();
        ReportCalcModel reportCalcModel = context.getReportCalcModel();
        Sheet sheet = context.getSheet();
        FundPlanSystem system = context.getSystem();
        ReportCalcTree colTree = reportCalcModel.getColTree();
        List colDimList = colTree.getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        int colHeight = colDimList.stream().max(Comparator.comparing(ReportCalcVal::getRow)).map(ReportCalcVal::getRow).orElse(0);
        DimensionIndexTree indexTree = report.getIndexTree(system);
        List dataValList = reportCalcModel.getDataValList();
        List inputCalcValList = dataValList.stream().filter(r -> r.getRow() > colHeight).filter(r -> !r.isSummary()).filter(r -> !r.isReferenceCell()).filter(r -> r.isRemarkCell() || r.isDataCell()).collect(Collectors.toList());
        Map<Integer, Long> colAuxMap = colDimList.stream().filter(ReportCalcVal::isRemarkCell).collect(Collectors.toMap(ReportCalcVal::getCol, ReportCalcVal::getDimensionId));
        QueryIndexInfo queryIndexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex((List)report.getReportDataList(), (FundPlanSystem)system, ReportData::isAuxiliaryInfo);
        Map<Long, ReportData> reportDataMapping = report.getReportDataList().stream().filter(Objects::nonNull).collect(Collectors.toMap(ReportData::getId, o -> o, (a, b) -> a));
        for (ReportCalcVal reportCalcVal : inputCalcValList) {
            ReportData reportData;
            int col = reportCalcVal.getCol() - 1;
            int row = reportCalcVal.getRow() - 4;
            DimensionInfoBean dimensionInfo = reportCalcModel.getDimensionInfo(reportCalcVal.getCol(), reportCalcVal.getRow());
            Object cellValue = POIHelper.getCellValue((int)reportCalcVal.getRow(), (int)reportCalcVal.getCol(), (Sheet)sheet);
            if (!reportCalcVal.isRemarkCell()) {
                TreeNode treeNode = indexTree.find(dimensionInfo);
                if (treeNode == null) continue;
                if (CollectionUtils.isNotEmpty((Collection)treeNode.getDataList())) {
                    reportData = (ReportData)treeNode.getDataList().get(0);
                    reportData.setDirty(Boolean.valueOf(true));
                } else {
                    reportData = this.buildNewReportData(dimensionInfo, report, row, col, false);
                    treeNode.addData((Object)reportData);
                    report.getReportDataList().add(reportData);
                }
                if (!reportCalcVal.isEnable()) continue;
                reportData.setBigDecimalValueOrDefault((Object)this.convertBigDecimal(cellValue));
                continue;
            }
            Long reportDataId = (Long)queryIndexInfo.getIndexQueryMap().find(dimensionInfo);
            if (reportDataMapping.containsKey(reportDataId)) {
                reportData = reportDataMapping.get(reportDataId);
            } else {
                reportData = this.buildNewReportData(dimensionInfo, report, row, col, true);
                report.getReportDataList().add(reportData);
                queryIndexInfo.updateIndex(new WarpBean((Object)reportData.getId(), dimensionInfo, (Object)reportData));
                reportDataMapping.put(reportData.getId(), reportData);
            }
            Long dimensionId = colAuxMap.get(reportCalcVal.getCol());
            String remark = cellValue == null ? "" : cellValue.toString();
            reportData.putAuxiliaryVal(dimensionId, remark);
        }
    }

    private void handleDetailModel(ImportDataContext context) {
        Report report = context.getReport();
        ReportCalcModel reportCalcModel = context.getReportCalcModel();
        Sheet sheet = context.getSheet();
        FundPlanSystem system = context.getSystem();
        List dataValList = reportCalcModel.getDataValList().stream().filter(reportCalcVal -> reportCalcVal.getDimensionId() != null || reportCalcVal.isDataCell() || reportCalcVal.isVirtualCell()).collect(Collectors.toList());
        Map<Integer, List<ReportCalcVal>> rowRCVMap = dataValList.stream().collect(Collectors.groupingBy(ReportCalcVal::getRow));
        List<TemplateDim> allTemplateDim = report.getTemplate().getAllTemplateDim();
        Map templateDimMap = allTemplateDim.stream().collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity()));
        Optional<TemplateDim> expandOptional = allTemplateDim.stream().filter(TemplateDim::isExpand).findFirst();
        Integer minRow = reportCalcModel.getColDimValList().stream().min(Comparator.comparing(ReportCalcVal::getRow)).map(ReportCalcVal::getRow).orElse(0);
        int counterPartyTypeCol = reportCalcModel.getColDimValList().stream().filter(c -> c.getRow() == minRow.intValue()).filter(colDim -> colDim.getValueType() != null && colDim.getValueType().getReportCellType() == ReportCellType.MUTI_BASE_DATA).findFirst().map(ReportCalcVal::getCol).orElse(0);
        QueryIndexInfo queryIndexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex((List)report.getReportDataList(), (FundPlanSystem)system, p -> true);
        Map<Integer, ReportCalcVal> rcvGroupByCol = reportCalcModel.getColDimValList().stream().collect(Collectors.toMap(ReportCalcVal::getCol, v -> v, (k1, k2) -> k1));
        Set bdColSet = context.getBaseDataSet();
        for (Map.Entry<Integer, List<ReportCalcVal>> rowEntry : rowRCVMap.entrySet()) {
            Integer row = rowEntry.getKey();
            if (!context.getValidLines().contains(row)) continue;
            List<ReportCalcVal> rowRCVs = rowEntry.getValue();
            List sortedRCVs = rowRCVs.stream().filter(reportCalcVal -> !reportCalcVal.isSummary()).sorted(Comparator.comparing(ReportCalcVal::isDataCell)).collect(Collectors.toList());
            LinkedHashMap dimIdToRVCMap = new LinkedHashMap(sortedRCVs.size());
            for (ReportCalcVal rcv : sortedRCVs) {
                Long dimensionId = rcv.getDimensionId();
                if (dimensionId == null) {
                    dimensionId = rcvGroupByCol.get(rcv.getCol()).getDimensionId();
                }
                if (dimIdToRVCMap.containsKey(dimensionId)) {
                    ((List)dimIdToRVCMap.get(dimensionId)).add(rcv);
                    continue;
                }
                ArrayList<ReportCalcVal> rcvs = new ArrayList<ReportCalcVal>();
                rcvs.add(rcv);
                dimIdToRVCMap.put(dimensionId, rcvs);
            }
            HashMap<Long, Object> dimensionIdValMap = new HashMap<Long, Object>();
            for (Map.Entry dimEntry : dimIdToRVCMap.entrySet()) {
                Long dimensionId = (Long)dimEntry.getKey();
                TemplateDim templateDim = (TemplateDim)templateDimMap.get(dimensionId);
                List rcvGroup = (List)dimEntry.getValue();
                if (rcvGroup.size() > 1 && !Objects.equals(templateDim.getDimensionId(), expandOptional.map(TemplateDim::getDimensionId).orElse(null))) {
                    this.getBaseDataRcvValue(dimensionIdValMap, rcvGroup, templateDim, sheet, counterPartyTypeCol, row);
                    continue;
                }
                ReportCalcVal rcv = (ReportCalcVal)rcvGroup.get(0);
                if (rcv.isDataCell()) {
                    this.getDataRcvValue(dimensionIdValMap, rcvGroup, rowRCVs, bdColSet, expandOptional, (QueryIndexInfo<Long, ReportData>)queryIndexInfo, context);
                    continue;
                }
                this.getOtherRcvValue(dimensionIdValMap, rcv, templateDim, sheet, row);
            }
        }
    }

    private void getOtherRcvValue(Map<Long, Object> dimensionIdValMap, ReportCalcVal rcv, TemplateDim templateDim, Sheet sheet, int row) {
        Long dimensionId = templateDim.getDimensionId();
        Object cellValue = POIHelper.getCellValue((int)rcv.getRow(), (int)rcv.getCol(), (Sheet)sheet);
        Object dimVal = null;
        if (DetailDimType.CONNTERPARTY_TYPE == templateDim.getDetailDimType()) {
            if (cellValue != null && COUNTER_PARTY_TYPE_MAP.containsKey(cellValue.toString())) {
                dimVal = COUNTER_PARTY_TYPE_MAP.get(cellValue.toString());
            }
        } else if (rcv.getValueType().getReportCellType() == ReportCellType.ENUM) {
            dimVal = templateDim.getDetailDataType() == DetailDataType.ENUM ? cellValue : this.getBaseDataDimVal(sheet, row, dimensionId, templateDim, cellValue);
        } else if (rcv.getValueType().getReportCellType() == ReportCellType.DATE) {
            dimVal = cellValue == null || cellValue instanceof Date ? cellValue : ImportDateTimeHelper.handleDateValue((Object)cellValue, (int)row, (Sheet)sheet);
        } else {
            if (rcv.isVirtualCell()) {
                return;
            }
            dimVal = rcv.getValueType().getReportCellType() == ReportCellType.BASE_DATA ? this.getBaseDataDimVal(sheet, row, dimensionId, templateDim, cellValue) : cellValue;
        }
        dimensionIdValMap.put(dimensionId, dimVal);
    }

    private void getDataRcvValue(Map<Long, Object> dimensionIdValMap, List<ReportCalcVal> rcvGroup, List<ReportCalcVal> rowRCVs, Set<Long> bdColSet, Optional<TemplateDim> expandOptional, QueryIndexInfo<Long, ReportData> queryIndexInfo, ImportDataContext context) {
        FundPlanSystem system = context.getSystem();
        Report report = context.getReport();
        Sheet sheet = context.getSheet();
        ReportCalcModel reportCalcModel = context.getReportCalcModel();
        for (ReportCalcVal dataRcv : rcvGroup) {
            ReportData reportData;
            Object cellValue = POIHelper.getCellValue((int)dataRcv.getRow(), (int)dataRcv.getCol(), (Sheet)sheet);
            int ogCol = dataRcv.getCol() - 1 - this.countBDColsOfRCVs(rowRCVs, bdColSet, dataRcv.getCol());
            int ogRow = this.getOriginalRow(dataRcv.getRow(), context, expandOptional);
            DimensionInfoBean dimensionInfo = reportCalcModel.getDimensionInfo(dataRcv.getCol(), dataRcv.getRow());
            this.removeDetailDimensionInfo(system, dimensionInfo);
            List reportIdList = queryIndexInfo.getIndexQueryMap().findList(dimensionInfo);
            List reportDataList = reportIdList.stream().map(queryIndexInfo.getDataMap()::get).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(reportDataList)) {
                reportData = this.createRDForDetail(report, reportCalcModel, dataRcv, ogRow, ogCol);
                queryIndexInfo.updateIndex(new WarpBean((Object)reportData.getId(), dimensionInfo, (Object)reportData));
            } else {
                Optional<ReportData> first = reportDataList.stream().filter(Objects::nonNull).filter(rd -> rd.getRow() == ogRow && rd.getCol() == ogCol).findFirst();
                if (!first.isPresent()) {
                    reportData = this.createRDForDetail(report, reportCalcModel, dataRcv, ogRow, ogCol);
                    queryIndexInfo.updateIndex(new WarpBean((Object)reportData.getId(), dimensionInfo, (Object)reportData));
                } else {
                    reportData = first.get();
                    reportData.setDirty(Boolean.valueOf(true));
                }
            }
            for (int i = 0; i < reportData.getDimList().size(); ++i) {
                TemplateDim dim = (TemplateDim)reportData.getDimList().get(i);
                if (!dimensionIdValMap.containsKey(dim.getDimensionId())) continue;
                reportData.getDimValList().set(i, dimensionIdValMap.get(dim.getDimensionId()));
            }
            reportData.setBigDecimalValueOrDefault((Object)this.convertBigDecimal(cellValue));
            reportData.setPlanAmt(this.convertBigDecimal(cellValue));
        }
    }

    private void getBaseDataRcvValue(Map<Long, Object> dimensionIdValMap, List<ReportCalcVal> rcvGroup, TemplateDim templateDim, Sheet sheet, int counterPartyTypeCol, int row) {
        DynamicObject bd;
        Long dimensionId = templateDim.getDimensionId();
        ReportCalcVal rcvOfNumber = rcvGroup.get(0);
        String cellNumber = (String)POIHelper.getCellValue((int)rcvOfNumber.getRow(), (int)rcvOfNumber.getCol(), (Sheet)sheet);
        ReportCalcVal rcvOfName = rcvGroup.get(1);
        String cellName = (String)POIHelper.getCellValue((int)rcvOfName.getRow(), (int)rcvOfName.getCol(), (Sheet)sheet);
        if (StringUtils.isEmpty((CharSequence)cellName) && StringUtils.isEmpty((CharSequence)cellNumber)) {
            dimensionIdValMap.put(dimensionId, null);
            return;
        }
        if (DetailDimType.COUNTERPARTY_NAME == templateDim.getDetailDimType()) {
            String cellCounter = (String)POIHelper.getCellValue((int)rcvOfNumber.getRow(), (int)counterPartyTypeCol, (Sheet)sheet);
            if (StringUtils.isEmpty((CharSequence)cellCounter)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\uff0c\u7b2c%2$s\u884c\uff0c\u8bf7\u8f93\u5165\u5bf9\u624b\u65b9\u7c7b\u578b\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"ReportImportDataServiceImpl_4", (String)"tmc-fpm-business", (Object[])new Object[0]), sheet.getSheetName(), row + 1, cellCounter));
            }
            if (!COUNTER_PARTY_TYPE_MAP.containsKey(cellCounter)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\uff0c\u7b2c%2$s\u884c\uff0c\u5bf9\u624b\u65b9\u7c7b\u578b\u3010%3$s\u3011\u5728\u7cfb\u7edf\u4e2d\u65e0\u6cd5\u5339\u914d\u5230\u6709\u6548\u53ef\u9009\u9879\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"ReportImportDataServiceImpl_5", (String)"tmc-fpm-business", (Object[])new Object[0]), sheet.getSheetName(), row + 1, cellCounter));
            }
            String entity = COUNTER_PARTY_TYPE_MAP.get(cellCounter);
            bd = ImportDataHelper.loadBaseData((String)entity, (String)cellCounter, (String)cellNumber, (String)cellName, null, (int)row, (Sheet)sheet);
        } else {
            String entity = rcvOfNumber.getValueType().getValue().toString();
            bd = ImportDataHelper.loadBaseData((String)entity, (String)cellNumber, (String)cellName, null, (int)row, (Sheet)sheet);
        }
        dimensionIdValMap.put(dimensionId, bd.getPkValue());
    }

    private Object getBaseDataDimVal(Sheet sheet, Integer row, Long dimensionId, TemplateDim templateDim, Object cellValue) {
        String[] split = cellValue.toString().trim().split("\\*");
        if (split.length != 2) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\uff0c\u7b2c%2$s\u884c\uff0c%3$s\u6210\u5458\u3010%4$s\u3011\u6570\u636e\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportImportDataServiceImpl_6", (String)"tmc-fpm-business", (Object[])new Object[0]), sheet.getSheetName(), row + 1, templateDim.getDimensionName(), cellValue));
        }
        String number = split[0];
        String name = split[1];
        QFilter qFilter = new QFilter("dimension", "=", (Object)dimensionId).and("id", "in", (Object)templateDim.getMemberScope());
        if (templateDim.getDimType() == DimensionType.PERIOD) {
            qFilter.and(new QFilter("name", "=", (Object)name));
        } else {
            qFilter.and(new QFilter("number", "=", (Object)number));
        }
        DynamicObject memberDO = FpmDataServiceHelper.loadSingle((String)"fpm_member", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((DynamicObject)memberDO)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\uff0c\u7b2c%2$s\u884c\uff0c%3$s\u6210\u5458\u3010%4$s\u3011\u975e\u5f53\u524d\u8ba1\u5212\u7f16\u5236\u8868\u6210\u5458\u8303\u56f4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportImportDataServiceImpl_7", (String)"tmc-fpm-business", (Object[])new Object[0]), sheet.getSheetName(), row + 1, templateDim.getDimensionName(), cellValue));
        }
        Object dimVal = memberDO.getPkValue();
        return dimVal;
    }

    private int getOriginalRow(int rcvRow, ImportDataContext context, Optional<TemplateDim> expandOptional) {
        if (!expandOptional.isPresent()) {
            return rcvRow - context.getColHeight();
        }
        TemplateDim expandDim = expandOptional.get();
        if (expandDim.getDimType() != DimensionType.PERIOD) {
            return rcvRow - context.getColHeight() + 1;
        }
        Optional<ReportCalcValTreeNode> periodNode = context.getReportCalcModel().getColTree().getRoot().getChildren().stream().filter(node -> node.getCalcVal() != null).filter(node -> node.getCalcVal().getDimensionId().equals(expandDim.getDimensionId())).findFirst();
        List children = periodNode.get().getChildren();
        int maxDepth = 0;
        while (EmptyUtil.isNoEmpty((Object)children)) {
            ReportCalcValTreeNode anyChild = (ReportCalcValTreeNode)children.get(0);
            children = anyChild.getChildren();
            ++maxDepth;
        }
        return rcvRow - context.getColHeight() + maxDepth;
    }

    private void removeDetailDimensionInfo(FundPlanSystem system, DimensionInfoBean dimensionInfo) {
        Set mainDimensionIdSet = system.getMainDimList().stream().map(Dimension::getId).collect(Collectors.toSet());
        List memberIdList = dimensionInfo.getMemberIdList();
        List dimensionIdList = dimensionInfo.getDimensionIdList();
        for (int i = dimensionIdList.size() - 1; i >= 0; --i) {
            Long dimensionId = (Long)dimensionIdList.get(i);
            if (mainDimensionIdSet.contains(dimensionId) && memberIdList.get(i) != null) continue;
            dimensionIdList.remove(i);
            memberIdList.remove(i);
        }
    }

    private ReportData createRDForDetail(Report report, ReportCalcModel reportCalcModel, ReportCalcVal rcv, int ogRow, int ogCol) {
        DimensionInfoBean dimensionInfo = this.getDetailDimensionInfo(reportCalcModel, rcv);
        this.distinctDimensionId(dimensionInfo);
        ReportData reportData = this.buildNewReportData(dimensionInfo, report, ogRow, ogCol, false);
        report.getReportDataList().add(reportData);
        return reportData;
    }

    private DimensionInfoBean getDetailDimensionInfo(ReportCalcModel reportCalcModel, ReportCalcVal rcv) {
        DimensionInfoBean dimensionInfoBean = null;
        DimensionInfoBean pageDimInfoBean = new DimensionInfoBean();
        for (ReportCalcVal reportCalcVal : reportCalcModel.getPageDimValList()) {
            pageDimInfoBean.getDimensionIdList().add(reportCalcVal.getDimensionId());
            pageDimInfoBean.getMemberIdList().add(reportCalcVal.getValue());
        }
        if (reportCalcModel.getColTree() != null) {
            DimensionInfoBean colDimList = new DimensionInfoBean();
            List leafList = reportCalcModel.getColTree().getLeafList();
            Iterator iterator = leafList.iterator();
            while (iterator.hasNext()) {
                for (ReportCalcValTreeNode node = (ReportCalcValTreeNode)iterator.next(); node != null && node != reportCalcModel.getColTree().getRoot(); node = node.getParent()) {
                    if (node.isSkipVal()) continue;
                    ReportCalcVal calcVal = node.getCalcVal();
                    Long dimensionId = calcVal.getDimensionId();
                    ReportCalcVal cell = reportCalcModel.getReportCalcVal(calcVal.getCol(), rcv.getRow());
                    Object value = cell.getValue();
                    boolean isDim = true;
                    if (!dimensionId.equals(calcVal.getValue())) {
                        if (calcVal.getCol() <= rcv.getCol() && calcVal.getEndCol() >= rcv.getCol()) {
                            value = calcVal.getValue();
                        } else {
                            isDim = false;
                        }
                    }
                    if (!isDim) continue;
                    colDimList.getDimensionIdList().add(dimensionId);
                    colDimList.getMemberIdList().add(value);
                }
            }
            dimensionInfoBean = DimensionInfoBean.concat((DimensionInfoBean[])new DimensionInfoBean[]{colDimList, pageDimInfoBean});
        }
        return dimensionInfoBean;
    }

    private void distinctDimensionId(DimensionInfoBean dimensionInfo) {
        List dimensionIdList = dimensionInfo.getDimensionIdList();
        List memberIdList = dimensionInfo.getMemberIdList();
        int size = dimensionInfo.getDimensionIdList().size();
        HashMap map1 = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            map1.put(dimensionIdList.get(i), i);
        }
        ArrayList newMemberList = new ArrayList(size);
        ArrayList newDimensionIdList = new ArrayList(size);
        for (int i = 0; i < memberIdList.size(); ++i) {
            int idx = (Integer)map1.get(dimensionIdList.get(i));
            if (idx != i) continue;
            newMemberList.add(memberIdList.get(i));
            newDimensionIdList.add(dimensionIdList.get(i));
        }
        dimensionInfo.setDimensionIdList(newDimensionIdList);
        dimensionInfo.setMemberIdList(newMemberList);
    }

    private int countBDColsOfRCVs(List<ReportCalcVal> rowRCVs, Set<Long> bdColSet, int currCol) {
        HashSet<Long> countSet = new HashSet<Long>();
        for (int i = 0; i < currCol; ++i) {
            ReportCalcVal reportCalcVal = rowRCVs.get(i);
            if (!bdColSet.contains(reportCalcVal.getDimensionId())) continue;
            countSet.add(reportCalcVal.getDimensionId());
        }
        return countSet.size();
    }

    private BigDecimal convertBigDecimal(Object cellValue) {
        if (StringUtils.isBlank((CharSequence)cellValue.toString())) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(cellValue.toString());
    }

    private ReportData buildNewReportData(DimensionInfoBean currDimInfoBean, Report report, int row, int col, boolean isRemark) {
        ReportData reportData = new ReportData();
        reportData.setVersion(Integer.valueOf(1));
        reportData.setLinkedReportId(report.getId());
        reportData.setDirty(Boolean.valueOf(true));
        reportData.setRow(row);
        reportData.setCol(col);
        reportData.setReportId(report.getId());
        reportData.setId(Long.valueOf(DB.genGlobalLongId()));
        List allTemplateDim = report.getTemplate().getAllTemplateDim().stream().filter(item -> !item.isViDim()).collect(Collectors.toList());
        Map templateDimMap = allTemplateDim.stream().collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity()));
        ArrayList<Object> dimValList = new ArrayList<Object>(allTemplateDim.size());
        ArrayList<TemplateDim> targetTplDimList = new ArrayList<TemplateDim>(allTemplateDim.size());
        for (Long dimId : currDimInfoBean.getDimensionIdList()) {
            TemplateDim templateDim = (TemplateDim)templateDimMap.get(dimId);
            if (Objects.isNull(templateDim)) continue;
            targetTplDimList.add(templateDim);
            Object memberId = currDimInfoBean.getMemberByDimensionId(dimId);
            dimValList.add(memberId);
        }
        reportData.setDimList(targetTplDimList);
        reportData.setDimValList(dimValList);
        reportData.setReportPeriodId(((PeriodMember)report.getPeriodMemberList().get(0)).getId());
        reportData.setMainTable(report.getTemplate().isMainTable());
        reportData.setAmountUnit(report.getTemplate().getAmountUnit());
        reportData.setPlanAmt(BigDecimal.ZERO);
        reportData.setAuxiliaryInfo(isRemark);
        reportData.setBigDecimalValueOrDefault((Object)BigDecimal.ZERO);
        reportData.setPlanAmt(BigDecimal.ZERO);
        reportData.setActAmt(BigDecimal.ZERO);
        reportData.setLockAmt(BigDecimal.ZERO);
        reportData.setOffsetAmt(BigDecimal.ZERO);
        reportData.setReportPlanAmt(BigDecimal.ZERO);
        reportData.setOriginalPlanAmt(BigDecimal.ZERO);
        return reportData;
    }

    static {
        COUNTER_PARTY_TYPE_MAP.put(ResManager.loadKDString((String)"\u5ba2\u6237", (String)"ReportImportDataServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]), "bd_customer");
        COUNTER_PARTY_TYPE_MAP.put(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"ReportImportDataServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), "bd_supplier");
        COUNTER_PARTY_TYPE_MAP.put(ResManager.loadKDString((String)"\u804c\u5458", (String)"ReportImportDataServiceImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]), "bos_user");
        COUNTER_PARTY_TYPE_MAP.put(ResManager.loadKDString((String)"\u516c\u53f8", (String)"ReportImportDataServiceImpl_3", (String)"tmc-fpm-business", (Object[])new Object[0]), "bos_org");
    }
}

