/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ControlIntensityType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.control.ControlCoefficientInfo;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetail;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.ControlRelationReportDataFindHelper;
import kd.tmc.fpm.business.helper.ReportPeriodHelper;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.service.IRelateReportDataManager;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import org.apache.commons.collections4.MapUtils;

public class ReportDataControlCoefficientHelper {
    private static final Log logger = LogFactory.getLog(ReportDataControlCoefficientHelper.class);
    private ControlContext controlContext;
    private IRelateReportDataManager relateReportDataManager;
    private List<ReportData> allReportData;
    private Map<Long, List<ReportData>> reportReportDataMap;
    private Map<Long, QueryIndexInfo<Long, ReportData>> reportQueryIndexInfoMap;
    private ControlRelationReportDataFindHelper controlRelationReportDataFindHelper;
    private Map<Long, Report> reportMap;
    private IReportRepository reportRepository;
    private Map<Long, Map<Long, PeriodMember>> systemPeriodMap;
    private Map<Long, Map<Long, ControlStrategyDetail>> controlStrategyDetailCache;
    private static final BigDecimal maxValue = new BigDecimal(Long.MAX_VALUE);
    private boolean initFlag;
    private Set<Long> matchedReportIds;
    private final Map<Long, List<ControlExecuteParam>> matchedReportDataIdParamMap;

    public ReportDataControlCoefficientHelper(ControlContext controlContext) {
        this.controlContext = controlContext;
        this.reportRepository = (IReportRepository)FpmServiceFactory.getBizService(IReportRepository.class);
        this.systemPeriodMap = new HashMap<Long, Map<Long, PeriodMember>>(16);
        this.controlStrategyDetailCache = new HashMap<Long, Map<Long, ControlStrategyDetail>>(16);
        this.reportQueryIndexInfoMap = new HashMap<Long, QueryIndexInfo<Long, ReportData>>(16);
        this.controlRelationReportDataFindHelper = ControlRelationReportDataFindHelper.getInstance((ControlContext)controlContext);
        this.matchedReportIds = new HashSet<Long>(controlContext.getControlExecuteParamList().size());
        this.matchedReportDataIdParamMap = new HashMap<Long, List<ControlExecuteParam>>(controlContext.getControlExecuteParamList().size());
        this.init();
    }

    public static ReportDataControlCoefficientHelper getInstance(ControlContext controlContext) {
        return new ReportDataControlCoefficientHelper(controlContext);
    }

    private void init() {
        if (this.initFlag) {
            return;
        }
        this.initFlag = true;
        this.relateReportDataManager = this.controlContext.getRelateReportDataManager();
        this.allReportData = EmptyUtil.isEmpty((Object)this.relateReportDataManager) ? Collections.emptyList() : this.relateReportDataManager.getAllReportData();
        this.reportReportDataMap = this.allReportData.stream().collect(Collectors.groupingBy(ReportData::getReportId));
        this.reportMap = this.reportRepository.getReportForControl(this.reportReportDataMap.keySet());
        this.initMatchedReportDataIds();
        this.buildQueryIndex();
    }

    private void initMatchedReportDataIds() {
        for (ControlExecuteParam controlExecuteParam : this.controlContext.getControlExecuteParamList()) {
            if (EmptyUtil.isEmpty((Object)controlExecuteParam.getReportData())) continue;
            this.matchedReportIds.add(controlExecuteParam.getReportData().getId());
            List matchedReportDataList = controlExecuteParam.getMatchedReportDataList();
            if (EmptyUtil.isEmpty((Collection)matchedReportDataList)) continue;
            for (ReportData reportData : matchedReportDataList) {
                List controlExecuteParamList = this.matchedReportDataIdParamMap.computeIfAbsent(reportData.getId(), k -> new ArrayList(4));
                controlExecuteParamList.add(controlExecuteParam);
            }
        }
    }

    private void buildQueryIndex() {
        for (Map.Entry<Long, List<ReportData>> entry : this.reportReportDataMap.entrySet()) {
            Long reportId = entry.getKey();
            List<ReportData> reportDataList = entry.getValue();
            if (EmptyUtil.isEmpty(reportDataList)) continue;
            Long systemId = reportDataList.get(0).getSystemId();
            this.reportQueryIndexInfoMap.putIfAbsent(reportId, (QueryIndexInfo<Long, ReportData>)QueryIndexInfoMapGenerator.buildReportDataIndex(reportDataList, (FundPlanSystem)this.controlContext.getSystem(systemId), rd -> true));
        }
    }

    public Function<Long, ControlCoefficientInfo> getReportDataControlCoefficientFunction() {
        return this.getReportDataControlCoefficientFunction(this.allReportData);
    }

    public Function<Long, ControlCoefficientInfo> getReportDataControlCoefficientFunction(List<ReportData> reportDataList) {
        PlanExecuteOpType planExecuteOpType = this.controlContext.getPlanExecuteOpType();
        if (planExecuteOpType != PlanExecuteOpType.PRE_OCCUPY_WRITE) {
            logger.info("\u5f53\u524d\u64cd\u4f5c\uff1a{}\u4e0d\u662f\u6267\u884c\u6570\u5199\u5165\u548c\u53d6\u6d88\uff0c\u4e0d\u6821\u9a8c\u3002\u3002\u3002", (Object)this.controlContext.getPlanExecuteOpType());
            return reportDataId -> new ControlCoefficientInfo(reportDataId, maxValue);
        }
        HashMap reportDataControlCoefficient = new HashMap(reportDataList.size());
        return reportDataId -> {
            if (MapUtils.isEmpty((Map)reportDataControlCoefficient)) {
                this.fillControlCoefficient(reportDataList, reportDataControlCoefficient);
            }
            ControlCoefficientInfo reportDataControlCoefficientVal = reportDataControlCoefficient.getOrDefault(reportDataId, new ControlCoefficientInfo(reportDataId, maxValue));
            return reportDataControlCoefficientVal;
        };
    }

    private void fillControlCoefficient(List<ReportData> reportDataList, Map<Long, ControlCoefficientInfo> reportDataControlCoefficient) {
        logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u6240\u6709\u7f16\u5236\u6570\u636e\u7684\u63a7\u5236\u7cfb\u6570\u3002\u3002\u3002\u3002");
        for (ReportData reportData : reportDataList) {
            this.doFillControlCoefficient(reportData, reportDataControlCoefficient);
        }
    }

    private void doFillControlCoefficient(ReportData reportData, Map<Long, ControlCoefficientInfo> reportDataControlCoefficient) {
        Map<Boolean, List<ReportData>> mainTableReportDataListMap;
        List realDataList;
        ControlStrategyDetail controlStrategyDetail;
        Long reportId = reportData.getReportId();
        Report report = this.reportMap.get(reportId);
        ReportTemplate template = report.getTemplate();
        Long reportDataId = reportData.getId();
        if (template.getTemplateUse() == TemplateUseType.SUMMARY && !this.matchedReportIds.contains(reportData.getId())) {
            logger.info("\u7f16\u5236\u6570\u636eid\uff1a{}\u4e3a\u6c47\u603b\u7f16\u5236\u6570\u636e\uff0c\u4e0d\u6821\u9a8c\uff0c\u76f4\u63a5\u4f7f\u7528\u6700\u5927\u503c\uff1a{}", (Object)reportDataId, (Object)maxValue.toPlainString());
            reportDataControlCoefficient.put(reportDataId, new ControlCoefficientInfo(reportDataId, maxValue));
            return;
        }
        List controlExecuteParamList = this.matchedReportDataIdParamMap.getOrDefault(reportDataId, Collections.emptyList());
        if (EmptyUtil.isEmpty(controlExecuteParamList)) {
            logger.warn("\u7f16\u5236\u6570\u636eid\uff1a{}\u6ca1\u6709\u5bf9\u5e94\u7684\u63a7\u5236\u53c2\u6570\uff0c\u4e0d\u6821\u9a8c\uff0c\u76f4\u63a5\u4f7f\u7528\u6700\u5927\u503c\uff1a{}", (Object)reportDataId, (Object)maxValue.toPlainString());
            reportDataControlCoefficient.put(reportDataId, new ControlCoefficientInfo(reportDataId, maxValue));
            return;
        }
        if (this.controlContext.getPlanExecuteOpType().isOccupyCancel()) {
            ControlExecuteParam controlExecuteParam;
            List planExecuteRecordList;
            boolean needCheck = false;
            Iterator iterator = controlExecuteParamList.iterator();
            while (iterator.hasNext() && !(needCheck = EmptyUtil.isNoEmpty(planExecuteRecordList = (controlExecuteParam = (ControlExecuteParam)iterator.next()).getRelatePlanExecuteRecordList().stream().filter(p -> p.getExecuteOpType().isOccupyRelease()).filter(p -> !Objects.equals(p.getBillBizInfo().getEntityType(), controlExecuteParam.getBillBizInfo().getEntityType())).collect(Collectors.toList())))) {
            }
            if (!needCheck) {
                logger.warn("\u7f16\u5236\u6570\u636eid\uff1a{}\u5f53\u524d\u672a\u53d6\u6d88\u9884\u5360\uff0c\u5f53\u524d\u53c2\u6570\u4e0d\u5b58\u5728\u4e0a\u6e38\u7684\u9884\u5360\u91ca\u653e\u5173\u8054\u8bb0\u5f55\uff0c\u76f4\u63a5\u4f7f\u7528\u6700\u5927\u503c\uff1a{}", (Object)reportDataId, (Object)maxValue.toPlainString());
                reportDataControlCoefficient.put(reportDataId, new ControlCoefficientInfo(reportDataId, maxValue));
                return;
            }
        }
        List dimList = reportData.getDimList();
        List dimValList = reportData.getDimValList();
        Long reportOrgId = 0L;
        Long subjectId = 0L;
        Long periodMemberId = 0L;
        for (int i = 0; i < dimList.size(); ++i) {
            TemplateDim templateDim = (TemplateDim)dimList.get(i);
            DimensionType dimType = templateDim.getDimType();
            if (dimType == DimensionType.ORG) {
                reportOrgId = (Long)dimValList.get(i);
            }
            if (dimType == DimensionType.SUBJECTS) {
                subjectId = (Long)dimValList.get(i);
            }
            if (dimType == DimensionType.PERIOD) {
                periodMemberId = (Long)dimValList.get(i);
            }
            if (EmptyUtil.isNoEmpty((Long)reportOrgId) && EmptyUtil.isNoEmpty((Long)subjectId) && EmptyUtil.isNoEmpty((Long)periodMemberId)) break;
        }
        Long systemId = report.getSystemId();
        FundPlanSystem system = this.controlContext.getSystem(systemId);
        Map periodMemberMap = this.systemPeriodMap.computeIfAbsent(systemId, k -> this.controlContext.getSystem(k).getMainDimensionByDimType(DimensionType.PERIOD).getAllDimMemberList().stream().map(PeriodMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a)));
        Long reportPeriodId = reportData.getReportPeriodId();
        PeriodMember periodMember = (PeriodMember)periodMemberMap.get(reportPeriodId);
        PeriodMember currentPeriodMember = (PeriodMember)periodMemberMap.get(periodMemberId);
        Long reportTypeId = periodMember.getPeriodTypeId();
        ControlStrategy controlStrategy = this.controlContext.getControlStrategy(system.getId(), reportTypeId, reportOrgId);
        if (Objects.isNull(controlStrategy)) {
            this.throwErrorWhenStrategyNotExist(reportOrgId, system, currentPeriodMember);
        }
        if (Objects.isNull(controlStrategyDetail = this.getControlStrategyDetail(controlStrategy, subjectId))) {
            logger.info("\u7f16\u5236\u6570\u636eid:{},\u4f53\u7cfb\uff1a{}\uff0c\u63a7\u5236\u7b56\u7565\uff1a{}\uff0c\u8ba1\u5212\u79d1\u76ee\uff1a{}\u6ca1\u6709\u5bf9\u5e94\u7684\u660e\u7ec6\u63a7\u5236\u9879\uff0c\u4e0d\u63a7\u5236\u3002", new Object[]{reportDataId, system.getName(), controlStrategy.getName(), subjectId});
            reportDataControlCoefficient.put(reportDataId, new ControlCoefficientInfo(reportDataId, maxValue));
            return;
        }
        ControlIntensityType controlIntensity = controlStrategyDetail.getControlIntensity();
        if (EmptyUtil.isEmpty((Object)controlIntensity)) {
            logger.info("\u7f16\u5236\u6570\u636eid:{},\u4f53\u7cfb\uff1a{}\uff0c\u63a7\u5236\u7b56\u7565\uff1a{}\uff0c\u8ba1\u5212\u79d1\u76ee\uff1a{}\u6ca1\u6709\u8bbe\u7f6e\u63a7\u5236\u5f3a\u5ea6\uff0c\u4e0d\u63a7\u5236\u3002", new Object[]{reportDataId, system.getName(), controlStrategy.getName(), subjectId});
            reportDataControlCoefficient.put(reportDataId, new ControlCoefficientInfo(reportDataId, maxValue));
            return;
        }
        BigDecimal controlCoefficient = controlStrategyDetail.getControlCoefficient();
        logger.info("\u7f16\u5236\u6570\u636eid:{},\u4f53\u7cfb\uff1a{}\uff0c\u63a7\u5236\u7b56\u7565\uff1a{}\uff0c\u8ba1\u5212\u79d1\u76ee\uff1a{},\u63a7\u5236\u7cfb\u6570\uff1a{}", new Object[]{reportDataId, system.getName(), controlStrategy.getName(), subjectId, controlCoefficient.toPlainString()});
        switch (controlStrategy.getPeriodControlStrategyType()) {
            case CURRENT_CONTROL: {
                if (Objects.equals(reportPeriodId, periodMemberId)) break;
                logger.info("\u7f16\u5236\u6570\u636eid:{},\u4f53\u7cfb\uff1a{}\uff0c\u63a7\u5236\u7b56\u7565\uff1a{}\uff0c\u6309\u5f53\u671f\u63a7\uff0c\u5f53\u671f\u6570\u636e\u671f\u95f4\u6210\u5458\u4e3a\u660e\u7ec6\u671f\u95f4\uff0c\u4e0d\u63a7\u5236\u3002", new Object[]{reportDataId, system.getName(), controlStrategy.getName()});
                reportDataControlCoefficient.put(reportDataId, new ControlCoefficientInfo(reportDataId, maxValue));
                return;
            }
            case DETAIL_PERIOD_CONTROL: {
                if (!Objects.equals(reportPeriodId, periodMemberId)) break;
                reportDataControlCoefficient.put(reportDataId, new ControlCoefficientInfo(reportDataId, maxValue));
                logger.info("\u7f16\u5236\u6570\u636eid:{},\u4f53\u7cfb\uff1a{}\uff0c\u63a7\u5236\u7b56\u7565\uff1a{}\uff0c\u6309\u660e\u7ec6\u63a7\uff0c\u5f53\u671f\u671f\u95f4\u4e3a\u5927\u671f\u95f4\uff0c\u4e0d\u63a7\u5236\u3002", new Object[]{reportDataId, system.getName(), controlStrategy.getName()});
                reportDataControlCoefficient.put(reportDataId, new ControlCoefficientInfo(reportDataId, maxValue));
                return;
            }
        }
        QueryIndexInfo<Long, ReportData> dataQueryIndexInfo = this.reportQueryIndexInfoMap.get(reportId);
        if (Objects.isNull(dataQueryIndexInfo)) {
            reportDataControlCoefficient.put(reportData.getId(), new ControlCoefficientInfo(reportDataId, maxValue));
            logger.info("\u7f16\u5236\u6570\u636eid:{}\u5bf9\u5e94\u7684\u7f16\u5236\u8868QueryIndexInfo\u4e3a\u7a7a\u3002");
            return;
        }
        ArrayList<ReportData> controlReportDataList = new ArrayList<ReportData>(this.controlRelationReportDataFindHelper.getControlReportDataList(dataQueryIndexInfo, controlStrategyDetail, reportData, controlStrategy, currentPeriodMember));
        Set dataIds = controlReportDataList.stream().map(ReportData::getId).collect(Collectors.toSet());
        if (!dataIds.contains(reportData.getId())) {
            controlReportDataList.add(reportData);
        }
        if (EmptyUtil.isEmpty(realDataList = (mainTableReportDataListMap = controlReportDataList.stream().collect(Collectors.groupingBy(ReportData::isMainTable))).getOrDefault(Boolean.TRUE, Collections.emptyList()))) {
            realDataList = mainTableReportDataListMap.getOrDefault(Boolean.FALSE, Collections.emptyList());
        }
        reportDataControlCoefficient.put(reportData.getId(), new ControlCoefficientInfo(reportDataId, controlCoefficient, realDataList));
    }

    private void throwErrorWhenStrategyNotExist(Long reportOrgId, FundPlanSystem system, PeriodMember currentPeriodMember) {
        Dimension orgDimension = system.getMainDimensionByDimType(DimensionType.ORG);
        DimMember orgMember = orgDimension.getAllDimMemberList().stream().filter(dimMember -> Objects.equals(reportOrgId, dimMember.getId())).findFirst().get();
        ReportPeriodType periodType = system.getReportTypeList().stream().filter(reportPeriodType -> ReportPeriodHelper.periodTypeEqual((ReportPeriodType)reportPeriodType, (PeriodType)currentPeriodMember.getPeriodType())).findFirst().get();
        String errorMessage = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u7f16\u62a5\u4e3b\u4f53\u3010%2$s\u3011\u7f16\u62a5\u7c7b\u578b\u3010%3$s\u3011\u6ca1\u6709\u6709\u6548\u7684\u63a7\u5236\u7b56\u7565", (String)"ControlBizService_0", (String)"tmc-fpm-business", (Object[])new Object[0]), system.getName(), orgMember.getName(), periodType.getName());
        throw new KDBizException(errorMessage);
    }

    private ControlStrategyDetail getControlStrategyDetail(ControlStrategy controlStrategy, Long subjectId) {
        Map subjectControlStrategyDetailMap = this.controlStrategyDetailCache.computeIfAbsent(controlStrategy.getId(), k -> new HashMap(32));
        if (MapUtils.isEmpty((Map)subjectControlStrategyDetailMap)) {
            subjectControlStrategyDetailMap.putAll(controlStrategy.getControlStrategyDetails().stream().collect(Collectors.toMap(ControlStrategyDetail::getSubjectId, Function.identity(), (a, b) -> a)));
        }
        return (ControlStrategyDetail)subjectControlStrategyDetailMap.get(subjectId);
    }
}

