/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.controller;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.FpmPageCacheService;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.controller.impl.AbstractFpmFormOperate;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class BaseManageController {
    private static final Log logger = LogFactory.getLog(BaseManageController.class);
    private IFpmPageCacheService cacheService;
    private CellDataSource cellDs;

    protected <T> void doFormOperate(AbstractFpmFormOperate<T> formOperate) {
        try {
            FpmOperateResult result = formOperate.doOperate();
            if (result.isSuccess()) {
                formOperate.onOperateSuccess(result);
            } else if (result.isWarning()) {
                formOperate.onOperateWarn(result);
            } else if (!result.isSuccess() && !result.isWarning()) {
                formOperate.onOperateError(result);
            }
            formOperate.afterDoThings(result);
        }
        catch (KDBizException e) {
            logger.error("\u5e94\u7528\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("\u5e94\u7528\u53d1\u751f\u7cfb\u7edf\u4e2d\u65ad\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7.", (Throwable)e);
            BaseManageController.packageException(e);
        }
        finally {
            if (this.cacheService != null) {
                this.cacheService.batchCommit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> FpmOperateResult<T> doFormOperateAndReturnResult(AbstractFpmFormOperate<T> formOperate) {
        FpmOperateResult result = FpmOperateResult.success();
        try {
            result = formOperate.doOperate();
            if (result.isSuccess()) {
                formOperate.onOperateSuccess(result);
            } else if (result.isWarning()) {
                formOperate.onOperateWarn(result);
            } else if (!result.isSuccess() && !result.isWarning()) {
                formOperate.onOperateError(result);
            }
            formOperate.afterDoThings(result);
        }
        catch (KDBizException e) {
            logger.error("\u5e94\u7528\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("\u5e94\u7528\u53d1\u751f\u7cfb\u7edf\u4e2d\u65ad\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7.", (Throwable)e);
            BaseManageController.packageException(e);
        }
        finally {
            if (this.cacheService != null) {
                this.cacheService.batchCommit();
            }
        }
        return result;
    }

    protected IFpmPageCacheService getCacheService(String pageId) {
        if (this.cacheService == null) {
            this.cacheService = new FpmPageCacheService(pageId);
        }
        return this.cacheService;
    }

    protected CellDataSource getCellDataSource(String pageId) {
        if (this.cellDs == null) {
            this.cellDs = new CellDataSource(this.getCacheService(pageId));
        }
        return this.cellDs;
    }

    protected void release(String pageId) {
        this.getCacheService(pageId).removeAll();
    }

    protected void cacheBookCell(Book book, ReportCalcModel calcModel, TemplateType templateType, String pageId) {
        List<Cell> needCacheCellList = book.getSheet().getCellList().stream().filter(item -> item.getCellDimType() != CellDimTypeEnum.ROWDIMS && item.getCellDimType() != CellDimTypeEnum.COLDIMS).collect(Collectors.toList());
        CellDataSource ds = this.getCellDataSource(pageId);
        if (templateType == TemplateType.DETAIL) {
            ds.saveAll(needCacheCellList, CacheCell.getDetailReportCachePropList(), calcModel);
        } else {
            ds.saveAll(needCacheCellList, CacheCell.getFixReportCachePropList(), calcModel);
        }
    }

    protected void cacheBookCell(Book book, ReportCalcModel calcModel, TemplateType templateType, String pageId, boolean isFillDirtySet) {
        List<Cell> needCacheCellList = book.getSheet().getCellList().stream().filter(item -> item.getCellDimType() != CellDimTypeEnum.ROWDIMS && item.getCellDimType() != CellDimTypeEnum.COLDIMS).collect(Collectors.toList());
        CellDataSource ds = this.getCellDataSource(pageId);
        if (templateType == TemplateType.DETAIL) {
            ds.saveAll(needCacheCellList, CacheCell.getDetailReportCachePropList(), calcModel, isFillDirtySet);
        } else {
            ds.saveAll(needCacheCellList, CacheCell.getFixReportCachePropList(), calcModel, isFillDirtySet);
        }
    }

    protected void renderCellStyle(List<Cell> cells) {
        cells = cells.stream().filter(Objects::nonNull).filter(cell -> cell.getCellDimType() == CellDimTypeEnum.DATADIMS).collect(Collectors.toList());
        cells = cells.stream().filter(o -> o instanceof CacheCell).collect(Collectors.toList());
        for (Cell cell2 : cells) {
            CellStyleInfo styleInfo = cell2.getStyleInfo();
            Object value = cell2.getValue();
            if (EmptyUtil.isNoEmpty((Object)value)) {
                styleInfo.setFrc("#000000");
                continue;
            }
            styleInfo.setFrc("#999999");
        }
    }

    private static void packageException(Exception e) {
        String errorMsg = String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7a0b\u5e8f\u53d1\u751f\u7cfb\u7edf\u4e2d\u65ad\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff0cTraceID\uff1a%1$s\uff0c\u9519\u8bef\uff1a%2$s\u3002", (String)"BaseManageController_0", (String)"tmc-fpm-business", (Object[])new Object[0]), RequestContext.get().getTraceId(), ExceptionUtils.getMessage((Throwable)e));
        throw new KDBizException(errorMsg);
    }
}

