/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ApplyStatus;
import kd.tmc.fpm.business.domain.enums.ApprovalStatus;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.BusinessType;
import kd.tmc.fpm.business.domain.enums.DataSourceType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.InoutDirectionType;
import kd.tmc.fpm.business.domain.enums.OpUserType;
import kd.tmc.fpm.business.domain.model.inoutpool.InoutCollect;

public class InoutCollectPlainObjConverter {
    public static InoutCollect convert(List<DynamicObject> dynamicObject) {
        InoutCollect inoutCollect = new InoutCollect();
        InoutCollectPlainObjConverter.populateHead(dynamicObject.get(0), inoutCollect);
        InoutCollectPlainObjConverter.populateEntry(inoutCollect, dynamicObject);
        return inoutCollect;
    }

    private static void populateEntry(InoutCollect inoutCollect, List<DynamicObject> dynamicObject) {
        ArrayList<InoutCollect.InoutReportRelation> relationList = new ArrayList<InoutCollect.InoutReportRelation>(dynamicObject.size());
        for (DynamicObject entry : dynamicObject) {
            String batchNo = entry.getString(String.join((CharSequence)".", "entryentity", "entry_batchno"));
            long reportId = entry.getLong(String.join((CharSequence)".", "entryentity", "entry_relateplanreportid"));
            if (EmptyUtil.isEmpty((Long)reportId)) continue;
            InoutCollect.InoutReportRelation inoutReportRelation = new InoutCollect.InoutReportRelation();
            inoutReportRelation.setId(entry.getLong("entryentity.id"));
            inoutReportRelation.setBatchNo(batchNo);
            inoutReportRelation.setPlanReport(entry.getString(String.join((CharSequence)".", "entryentity", "entry_relateplanreport")));
            inoutReportRelation.setPlanReportId(reportId);
            inoutReportRelation.setBodySysId(entry.getLong(String.join((CharSequence)".", "entryentity", "entry_bodysys")));
            inoutReportRelation.setReportTypeId(entry.getLong(String.join((CharSequence)".", "entryentity", "entry_reporttype")));
            inoutReportRelation.setReportOrgId(entry.getLong(String.join((CharSequence)".", "entryentity", "entry_reportorg")));
            inoutReportRelation.setReportPeriodId(entry.getLong(String.join((CharSequence)".", "entryentity", "entry_reportperiod")));
            inoutReportRelation.setReferPlanDate(entry.getDate(String.join((CharSequence)".", "entryentity", "entry_referplandate")));
            inoutReportRelation.setReferPlanAmount(entry.getBigDecimal(String.join((CharSequence)".", "entryentity", "entry_referplanamount")));
            relationList.add(inoutReportRelation);
        }
        inoutCollect.setInoutReportRelationList(relationList);
    }

    private static void populateHead(DynamicObject dynamicObject, InoutCollect inoutCollect) {
        inoutCollect.setId(Long.valueOf(dynamicObject.getLong("id")));
        inoutCollect.setNumber(dynamicObject.getString("billno"));
        inoutCollect.setBusinessType((BusinessType)ITypeEnum.getByNumber((String)dynamicObject.getString("businesstype"), BusinessType.class));
        inoutCollect.setApplyOrgId(Long.valueOf(dynamicObject.getLong(String.join((CharSequence)".", "applyorg", "id"))));
        inoutCollect.setApplyUserId(Long.valueOf(dynamicObject.getLong(String.join((CharSequence)".", "applyuser", "id"))));
        inoutCollect.setCreateDate(dynamicObject.getDate("createdate"));
        inoutCollect.setBillStatus((BillStatus)ITypeEnum.getByNumber((String)dynamicObject.getString("billstatus"), BillStatus.class));
        inoutCollect.setApprovalStatus((ApprovalStatus)ITypeEnum.getByNumber((String)dynamicObject.getString("approvalstatus"), ApprovalStatus.class));
        inoutCollect.setApplyStatus((ApplyStatus)ITypeEnum.getByNumber((String)dynamicObject.getString("applystatus"), ApplyStatus.class));
        inoutCollect.setRemark(dynamicObject.getString("remark"));
        inoutCollect.setDataSourceType((DataSourceType)ITypeEnum.getByNumber((String)dynamicObject.getString("datasource"), DataSourceType.class));
        inoutCollect.setSourceBill(dynamicObject.getString(String.join((CharSequence)".", "sourcebill", "id")));
        inoutCollect.setSourceBillNumber(dynamicObject.getString("sourcebillnumber"));
        inoutCollect.setSourceBillId(Long.valueOf(dynamicObject.getLong("sourcebillid")));
        inoutCollect.setSourceBillEntryId(Long.valueOf(dynamicObject.getLong("sourcebillentryid")));
        inoutCollect.setAbandonStatus(dynamicObject.getBoolean("abandonstatus"));
        inoutCollect.setAbandonReason(dynamicObject.getString("abandonreason"));
        inoutCollect.setBatchNo(dynamicObject.getString("batchno"));
        inoutCollect.setFundOrgId(Long.valueOf(dynamicObject.getLong(String.join((CharSequence)".", "fundorg", "id"))));
        inoutCollect.setInoutDirectionType((InoutDirectionType)ITypeEnum.getByNumber((String)dynamicObject.getString("inoutdirection"), InoutDirectionType.class));
        inoutCollect.setFundPurposeId(Long.valueOf(dynamicObject.getLong(String.join((CharSequence)".", "fundpurpose", "id"))));
        inoutCollect.setFeeProjectId(Long.valueOf(dynamicObject.getLong(String.join((CharSequence)".", "feeproject", "id"))));
        inoutCollect.setSettleTypeId(Long.valueOf(dynamicObject.getLong(String.join((CharSequence)".", "settletype", "id"))));
        inoutCollect.setOpUserType((OpUserType)ITypeEnum.getByNumber((String)dynamicObject.getString("opusertype"), OpUserType.class));
        inoutCollect.setOpUserName(Long.valueOf(dynamicObject.getLong(String.join((CharSequence)".", "opusername", "id"))));
        inoutCollect.setCurrencyId(Long.valueOf(dynamicObject.getLong(String.join((CharSequence)".", "currency", "id"))));
        inoutCollect.setExpectDate(dynamicObject.getDate("expectdate"));
        inoutCollect.setCurrentPlanDate(dynamicObject.getDate("currentplandate"));
        inoutCollect.setExpectCashAmount(dynamicObject.getBigDecimal("expectcashamount"));
        inoutCollect.setCurrentPlanAmount(dynamicObject.getBigDecimal("currentplanamount"));
        inoutCollect.setCoreBillSumAmount(dynamicObject.getBigDecimal("corebillsumamount"));
        inoutCollect.setCoreBillRemainCashAmt(dynamicObject.getBigDecimal("corebillremaincashamt"));
        inoutCollect.setContractNo(dynamicObject.getString("contractno"));
        inoutCollect.setContractName(dynamicObject.getString("contractname"));
        inoutCollect.setProjectId(Long.valueOf(dynamicObject.getLong(String.join((CharSequence)".", "project", "id"))));
    }
}

