/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import com.google.common.base.Functions;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FixedFrequencyType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.ReportDataType;
import kd.tmc.fpm.business.domain.enums.ReportPlanChangeStatus;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportPreCloseType;
import kd.tmc.fpm.business.domain.enums.ReportPreRateDateType;
import kd.tmc.fpm.business.domain.enums.ReportPreStartType;
import kd.tmc.fpm.business.domain.enums.ReportPreSubLevel;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.SunReportSumStatus;
import kd.tmc.fpm.business.domain.enums.TemplateDimMemScopeType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportPrepare;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.CustomDimThreadLocalHelper;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.repository.IBodySystemRepository;
import kd.tmc.fpm.business.mvc.repository.IDimMemberRepository;
import kd.tmc.fpm.business.mvc.repository.dto.ReportNeedPropDTO;
import kd.tmc.fpm.business.mvc.repository.impl.BodySystemRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DetailPlanFieldsRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimMemberRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.TemplateRepository;
import kd.tmc.fpm.business.service.dimension.ICustomDimSeqService;
import kd.tmc.fpm.business.service.dimension.impl.CustomDimSeqServiceImpl;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.DimensionMappingHelper;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.ReportPlanChangeStatusEnum;
import kd.tmc.fpm.common.enums.ReportPlanTypeEnum;
import kd.tmc.fpm.common.helper.FpmHelper;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class ReportPoConverter {
    public static final Map<String, String> MAINDIM_ENTRY_MAPPING_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(DimensionType.ORG.getNumber(), "orgmem");
            this.put(DimensionType.CURRENCY.getNumber(), "currencymem");
            this.put(DimensionType.PERIOD.getNumber(), "periodmem");
            this.put(DimensionType.SUBJECTS.getNumber(), "subjectmem");
            this.put(DimensionType.COMPANY.getNumber(), "companymem");
            this.put(DimensionType.SETTLEMENT_TYPE.getNumber(), "settletypemem");
        }
    };
    public static final Map<String, String> DETAILDIM_ENTRY_MAPPING_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(DetailDimType.CONNTERPARTY_TYPE.getNumber(), "opusertype");
            this.put(DetailDimType.COUNTERPARTY_NAME.getNumber(), "opusername");
            this.put(DetailDimType.BANK_CATE.getNumber(), "bankcate");
            this.put(DetailDimType.CONTRACT_NO.getNumber(), "contractno");
            this.put(DetailDimType.CONTRACT_NAME.getNumber(), "contractname");
            this.put(DetailDimType.PLAN_DATE.getNumber(), "plandate");
            this.put(DetailDimType.BANK_ACCOUNT.getNumber(), "bankaccount");
            this.put(DetailDimType.BUSINESS_PARTNER.getNumber(), "businesspartner");
        }
    };
    public static final Map<String, String> TYPE_MAPPING_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.putAll(MAINDIM_ENTRY_MAPPING_MAP);
            this.putAll(DETAILDIM_ENTRY_MAPPING_MAP);
        }
    };
    private static IDimMemberRepository dimMemberRepository = new DimMemberRepository();
    private static IBodySystemRepository bodySystemRepository = new BodySystemRepository();

    public static ReportPrepare convertToReportPrepare(DynamicObject reportPrepare) {
        String rateDateType;
        ReportPrepare prepare = new ReportPrepare();
        prepare.setSystemId(Long.valueOf(reportPrepare.getDynamicObject("bodysysmanage").getLong("id")));
        String startDateStr = reportPrepare.getString("declarestartdate");
        int startDay = reportPrepare.getInt("declaredays");
        ReportPreStartType reportPreStartType = ReportPreStartType.valueOf((String)startDateStr);
        prepare.setStartDateType(reportPreStartType);
        prepare.setStartDateDay(Integer.valueOf(startDay));
        String closeDateStr = reportPrepare.getString("stopreportdate");
        int closeDay = reportPrepare.getInt("stopreportdays");
        ReportPreCloseType reportPreCloseType = ReportPreCloseType.valueOf((String)closeDateStr);
        prepare.setCloseDateType(reportPreCloseType);
        prepare.setCloseDateDay(Integer.valueOf(closeDay));
        prepare.setCloseTime(LocalTime.ofSecondOfDay(reportPrepare.getInt("defaultstopreptime")));
        boolean isCtrSubLevel = reportPrepare.getBoolean("isaccreportsubdefine");
        prepare.setCtrOrgLevel(isCtrSubLevel);
        if (isCtrSubLevel) {
            prepare.setReportPreSubLevel(ReportPreSubLevel.valueOf((String)reportPrepare.getString("reportsublevel")));
            prepare.setSubCloseTime(LocalTime.ofSecondOfDay(reportPrepare.getInt("contrlevelstopreptime")));
        }
        prepare.setReportPeriodId(Long.valueOf(reportPrepare.getDynamicObject("orgreporttype").getLong("id")));
        DynamicObject exchangeRateTable = reportPrepare.getDynamicObject("convexratetable");
        if (exchangeRateTable != null) {
            prepare.setExchangeRateTableId(Long.valueOf(exchangeRateTable.getLong("id")));
        }
        if (!StringUtils.isEmpty((Object)(rateDateType = reportPrepare.getString("convexratedate")))) {
            ReportPreRateDateType reportPreRateDateType = (ReportPreRateDateType)ReportPreRateDateType.valueOf(ReportPreRateDateType.class, (String)rateDateType);
            prepare.setRateDateType(reportPreRateDateType);
        }
        prepare.setId(Long.valueOf(reportPrepare.getLong("id")));
        prepare.setNumber(reportPrepare.getString("number"));
        prepare.setFixedFrequency(reportPrepare.getBoolean("fixedfrequency"));
        prepare.setFixedFrequencyStartType((FixedFrequencyType)ITypeEnum.getByNumber((String)reportPrepare.getString("fixedfrequencystarttype"), FixedFrequencyType.class));
        prepare.setFixedFrequencyStartDate(reportPrepare.getInt("fixedfrequencystartdate"));
        prepare.setFixedFrequencyEndType((FixedFrequencyType)ITypeEnum.getByNumber((String)reportPrepare.getString("fixedfrequencyendtype"), FixedFrequencyType.class));
        prepare.setFixedFrequencyEndDate(reportPrepare.getInt("fixedfrequencyenddate"));
        int reportPrepareInt = reportPrepare.getInt("fixedfrequencyendtime");
        if (reportPrepareInt >= 0) {
            prepare.setFixedFrequencyEndTime(LocalTime.ofSecondOfDay(reportPrepareInt));
        } else {
            prepare.setFixedFrequencyEndTime(LocalTime.ofSecondOfDay(86399L));
        }
        return prepare;
    }

    public static void convertToReportPo(Report report, DynamicObject reportPO) {
        HashMap<Report, DynamicObject> reportMap = new HashMap<Report, DynamicObject>(1);
        reportMap.put(report, reportPO);
        ReportPoConverter.batchConvertToReportPo(reportMap);
    }

    public static void batchConvertToReportPo(Map<Report, DynamicObject> reportMap) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(ReportPoConverter.class.getSimpleName());){
            span.addTag("batchConvertToReportPo");
            Set<Report> reports = reportMap.keySet();
            Set systemIdSet = reports.stream().map(item -> item.getSystemId()).collect(Collectors.toSet());
            DynamicObject[] systemArr = TmcDataServiceHelper.load((String)"fpm_bodysysmanage", (String)"id", (QFilter[])new QFilter("id", "in", systemIdSet).toArray());
            Map systemMap = Arrays.stream(systemArr).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
            Set templateBakIdSet = reports.stream().map(item -> item.getTemplate().getId()).collect(Collectors.toSet());
            Set templateIdSet = reports.stream().map(item -> item.getTemplate().getCopyId()).collect(Collectors.toSet());
            Set parentTemplateIdSet = reports.stream().map(item -> item.getParentTemplateId()).collect(Collectors.toSet());
            DynamicObject[] templateBakArr = TmcDataServiceHelper.load((Object[])templateBakIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_template_bak"));
            Map templateBakMap = Arrays.stream(templateBakArr).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
            HashSet templateSet = new HashSet(16);
            templateSet.addAll(templateIdSet);
            templateSet.addAll(parentTemplateIdSet);
            DynamicObject[] templateArr = TmcDataServiceHelper.load((Object[])templateSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_template"));
            Map templateMap = Arrays.stream(templateArr).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
            Set rateIdSet = reports.stream().map(item -> item.getExchangeRateTableId()).filter(Objects::nonNull).collect(Collectors.toSet());
            DynamicObject[] exchangeRateArr = TmcDataServiceHelper.load((String)"bd_exratetable", (String)"id", (QFilter[])new QFilter("id", "in", rateIdSet).toArray());
            Map exchangeRateMap = Arrays.stream(exchangeRateArr).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
            Set periodIdSet = reports.stream().map(item -> item.getPeriodMemberList()).flatMap(Collection::stream).map(item -> item.getId()).collect(Collectors.toSet());
            Set referencePeriodIdSet = reports.stream().filter(item -> item.getReferencePeriodMember() != null).map(item -> item.getReferencePeriodMember().getId()).collect(Collectors.toSet());
            Set orgIdSet = reports.stream().map(item -> item.getCompanyMemberList()).flatMap(Collection::stream).map(item -> item.getId()).collect(Collectors.toSet());
            HashSet memberIdSet = new HashSet(16);
            memberIdSet.addAll(periodIdSet);
            memberIdSet.addAll(referencePeriodIdSet);
            memberIdSet.addAll(orgIdSet);
            DynamicObject[] memberArr = TmcDataServiceHelper.load((String)"fpm_member", (String)"id,startdate", (QFilter[])new QFilter("id", "in", memberIdSet).toArray());
            Map memberMap = Arrays.stream(memberArr).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
            Set orgSourceIdSet = reports.stream().map(item -> item.getCompanyMemberList()).flatMap(Collection::stream).map(item -> item.getSourceId()).collect(Collectors.toSet());
            DynamicObject[] orgArr = TmcDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])new QFilter("id", "in", orgSourceIdSet).toArray());
            Map orgMap = Arrays.stream(orgArr).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
            for (Map.Entry<Report, DynamicObject> next : reportMap.entrySet()) {
                ReportProcessStatus processStatus;
                Long exchangeRateTableId;
                Report report = next.getKey();
                DynamicObject reportPO = next.getValue();
                DynamicObject system = (DynamicObject)systemMap.get(report.getSystemId());
                DynamicObject template = (DynamicObject)templateBakMap.get(report.getTemplate().getId());
                DynamicObjectCollection currencyMemberArr = template.getDynamicObjectCollection("currencymember");
                List<DynamicObject> currencyMemberList = currencyMemberArr.stream().map(item -> item.getDynamicObject("fbasedataid")).collect(Collectors.toList());
                DynamicObjectCollection currMemList = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)reportPO, (String)"currencyrange", (DynamicObject[])currencyMemberList.toArray(new DynamicObject[0]));
                reportPO.set("id", (Object)report.getId());
                reportPO.set("bodysys", (Object)system);
                reportPO.set("name", (Object)report.getName());
                reportPO.set("currencyrange", (Object)currMemList);
                reportPO.set("declaredeadline", (Object)report.getCloseDate());
                reportPO.set("declarestartdate", (Object)report.getStartDate());
                reportPO.set("initflag", (Object)report.getInitFlag());
                reportPO.set("attachinfo", (Object)report.getAttachId());
                if (report.getReportPlanType() != null) {
                    reportPO.set("reportplantype", (Object)report.getReportPlanType().getNumber());
                }
                if (report.getChangeStatus() != null) {
                    reportPO.set("changestatus", (Object)ReportPlanChangeStatusEnum.valueOf((String)report.getChangeStatus().name()).getValue());
                } else {
                    reportPO.set("changestatus", (Object)ReportPlanChangeStatusEnum.UNCHANGE.getValue());
                }
                ReportStatus reportStatus = report.getReportStatus();
                if (reportStatus != null) {
                    reportPO.set("planstatus", (Object)reportStatus.getVal());
                }
                if (report instanceof SumPlanReport) {
                    reportPO.set("isinneroffset", (Object)((SumPlanReport)report).isInnerOffset());
                    List sunReportSumRecordList = ((SumPlanReport)report).getSunReportSumRecordList();
                    DynamicObjectCollection sumEntryColl = reportPO.getDynamicObjectCollection("sumentry");
                    sumEntryColl.clear();
                    for (SumPlanReport.SunReportSumRecord sunReportSumRecord : sunReportSumRecordList) {
                        DynamicObject dynamicObject = sumEntryColl.addNew();
                        dynamicObject.set("sumorgreportid", (Object)sunReportSumRecord.getSunReportId());
                        dynamicObject.set("sumstatus", (Object)sunReportSumRecord.getSumStatus().getNumber());
                    }
                }
                if ((exchangeRateTableId = report.getExchangeRateTableId()) != null) {
                    DynamicObject exchangeRate = (DynamicObject)exchangeRateMap.get(exchangeRateTableId);
                    reportPO.set("exratetable", (Object)exchangeRate);
                    reportPO.set("exchangeratedate", (Object)report.getExchangeRateDate());
                }
                if ((processStatus = report.getProcessStatus()) == ReportProcessStatus.SAVE) {
                    reportPO.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
                } else if (processStatus == ReportProcessStatus.SUBMIT) {
                    reportPO.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
                } else if (processStatus == ReportProcessStatus.AUDIT) {
                    reportPO.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                }
                if (!CollectionUtils.isEmpty((Collection)report.getPeriodMemberList())) {
                    List periodMemberIdList = report.getPeriodMemberList().stream().map(i -> i.getId()).collect(Collectors.toList());
                    List<DynamicObject> periodMemberList = Arrays.stream(memberArr).filter(item -> periodMemberIdList.contains(item.getLong("id"))).collect(Collectors.toList());
                    periodMemberList = periodMemberList.stream().sorted(new Comparator<DynamicObject>(){

                        @Override
                        public int compare(DynamicObject o1, DynamicObject o2) {
                            return o1.getDate("startdate").compareTo(o2.getDate("startdate"));
                        }
                    }).collect(Collectors.toList());
                    reportPO.set("reportperiod", periodMemberList.get(0));
                    reportPO.set("rollnum", (Object)periodMemberList.size());
                    DynamicObjectCollection reportPeriodList = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)reportPO, (String)"periodlist", (DynamicObject[])periodMemberList.toArray(new DynamicObject[0]));
                    reportPO.set("periodlist", (Object)reportPeriodList);
                }
                if (report.getReferencePeriodMember() != null) {
                    reportPO.set("referenceperiod", memberMap.get(report.getReferencePeriodMember().getId()));
                }
                if (!CollectionUtils.isEmpty((Collection)report.getCompanyMemberList())) {
                    DynamicObject orgMember = (DynamicObject)memberMap.get(((OrgMember)report.getCompanyMemberList().get(0)).getId());
                    reportPO.set("reportorg", (Object)orgMember);
                    DynamicObject org = (DynamicObject)orgMap.get(((OrgMember)report.getCompanyMemberList().get(0)).getSourceId());
                    reportPO.set("company", (Object)org);
                }
                DynamicObject templateCopy = (DynamicObject)templateMap.get(report.getTemplate().getCopyId());
                reportPO.set("template", (Object)templateCopy);
                reportPO.set("templatebak", (Object)template);
                if (report.getParentTemplateId() != null) {
                    DynamicObject parentTemplate = (DynamicObject)templateMap.get(report.getParentTemplateId());
                    reportPO.set("parenttemplate", (Object)parentTemplate);
                }
                List reportDataList = report.getReportDataList();
                DynamicObjectCollection mainDimDataEntrys = reportPO.getDynamicObjectCollection("maindimentry");
                DynamicObjectCollection detailDataEntrys = reportPO.getDynamicObjectCollection("detailentry");
                DynamicObjectCollection auxEntrys = reportPO.getDynamicObjectCollection("auxentry");
                DynamicObjectCollection sourceIdSaveEntrys = reportPO.getDynamicObjectCollection("sourceidentry");
                if (!CollectionUtils.isEmpty((Collection)reportDataList)) {
                    Set idList = reportDataList.stream().map(ReportData::getId).collect(Collectors.toSet());
                    List notInDbDataList = mainDimDataEntrys.stream().filter(item -> !idList.contains(item.getLong("id"))).collect(Collectors.toList());
                    List notInDbDetailDataList = detailDataEntrys.stream().filter(item -> !idList.contains(item.getLong("maindimdataid"))).collect(Collectors.toList());
                    List notInDbAuxDataList = auxEntrys.stream().filter(item -> !idList.contains(item.getLong("aux_reportdataid"))).collect(Collectors.toList());
                    List notInDbSourceDataList = sourceIdSaveEntrys.stream().filter(item -> !idList.contains(item.getLong("rdi_reportdataid"))).collect(Collectors.toList());
                    Map dbDataMap = mainDimDataEntrys.stream().filter(item -> idList.contains(item.getLong("id"))).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
                    Map dbDetialDataMap = detailDataEntrys.stream().filter(item -> idList.contains(item.getLong("maindimdataid"))).collect(Collectors.toMap(item -> item.getLong("maindimdataid"), Function.identity()));
                    Map auxReportDataMapMap = auxEntrys.stream().collect(Collectors.groupingBy(d -> d.getLong("aux_reportdataid"), Collectors.toMap(d -> (Long)d.getDynamicObject("aux_bdtype").getPkValue(), Function.identity())));
                    mainDimDataEntrys.removeAll(notInDbDataList);
                    detailDataEntrys.removeAll(notInDbDetailDataList);
                    auxEntrys.removeAll(notInDbAuxDataList);
                    sourceIdSaveEntrys.removeAll(notInDbSourceDataList);
                    ICustomDimSeqService iCustomDimSeqService = (ICustomDimSeqService)FpmServiceFactory.getBizService(ICustomDimSeqService.class);
                    Map customDimSeqMap = iCustomDimSeqService.loadCustomDimSeqMap(report.getSystemId());
                    int count = (int)reportDataList.stream().filter(o -> o.getId() == null).count();
                    long[] newReportDataIdArr = DB.genGlobalLongIds((int)count);
                    LinkedList<Long> newReportDataIdList = new LinkedList<Long>();
                    for (long id : newReportDataIdArr) {
                        newReportDataIdList.add(id);
                    }
                    Object object = reportDataList.iterator();
                    while (object.hasNext()) {
                        DynamicObject detailEntry;
                        ReportData reportData = (ReportData)object.next();
                        if (reportData.isDirty() != null && !reportData.isDirty().booleanValue()) continue;
                        DynamicObject mainDimEntry = null;
                        Long reportDataId = reportData.getId();
                        if (reportDataId != null) {
                            mainDimEntry = (DynamicObject)dbDataMap.get(reportDataId);
                        }
                        if (mainDimEntry == null) {
                            mainDimEntry = mainDimDataEntrys.addNew();
                            mainDimEntry.set("id", (Object)(reportDataId != null ? reportDataId : newReportDataIdList.poll()));
                        }
                        if ((detailEntry = (DynamicObject)dbDetialDataMap.get(reportDataId)) == null) {
                            detailEntry = detailDataEntrys.addNew();
                        }
                        Map<Long, DynamicObject> auxMap = null;
                        if (auxReportDataMapMap.containsKey(reportDataId)) {
                            auxMap = auxReportDataMapMap.get(reportDataId);
                        }
                        ReportPoConverter.rDConvToEntry(report.getSystemId(), reportData, mainDimEntry, detailEntry, auxMap, auxEntrys, sourceIdSaveEntrys, customDimSeqMap);
                    }
                    continue;
                }
                mainDimDataEntrys.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Report convertToReport(DynamicObject reportDO, ReportTemplate reportTemplate, DynamicObject fundSystemDy) {
        try {
            String reportPlanType = reportDO.getString("reportplantype");
            List<TemplateDim> allTemplateDim = reportTemplate.getAllTemplateDim();
            Map<String, TemplateDim> templateDetailDimMap = allTemplateDim.stream().filter(item -> item.getDimType() == DimensionType.DETAILDIM).collect(Collectors.toMap(o -> o.getDetailDimType().getNumber(), Functions.identity(), (a, b) -> a));
            Map<String, List<TemplateDim>> templateMainDimMap = allTemplateDim.stream().filter(item -> item.getDimType() != DimensionType.DETAILDIM).collect(Collectors.groupingBy(o -> o.getDimType().getNumber()));
            boolean isSumPlan = ReportPlanTypeEnum.isSumPlan((String)reportPlanType);
            SumPlanReport report = isSumPlan ? new SumPlanReport() : new Report();
            report.setId(Long.valueOf(reportDO.getLong("id")));
            report.setName(reportDO.getString("name"));
            report.setNumber(reportDO.getString("billno"));
            report.setSystemId(Long.valueOf(reportDO.getLong("bodysys.id")));
            report.setTemplate(reportTemplate);
            report.setExchangeRateTableId(Long.valueOf(reportDO.getLong("exratetable.id")));
            report.setExchangeRateDate(reportDO.getDate("exchangeratedate"));
            Long attachId = Optional.ofNullable(reportDO.getDynamicObject("attachinfo")).map(o -> Long.valueOf(o.getPkValue().toString())).orElseGet(() -> null);
            report.setAttachId(attachId);
            report.setInformantErId(Long.valueOf(reportDO.getLong("informant.id")));
            report.setInformanStr(reportDO.getString("informant.name"));
            if (reportDO.containsProperty("changestatus")) {
                report.setChangeStatus(ReportPlanChangeStatus.getByVal((String)reportDO.getString("changestatus")));
            }
            if (!StringUtils.isEmpty((Object)reportPlanType)) {
                report.setReportPlanType((ReportPlanType)ITypeEnum.getByNumber((String)reportPlanType, ReportPlanType.class));
            }
            if (isSumPlan) {
                SumPlanReport sumPlanReport = report;
                sumPlanReport.setInnerOffset(reportDO.getBoolean("isinneroffset"));
                sumPlanReport.setSunReportSumRecordList(ReportPoConverter.getSunReportSumRecordList(reportDO));
            }
            DynamicObjectCollection entryEntity = fundSystemDy.getDynamicObjectCollection("applyrereportentry");
            DynamicObject entry = entryEntity.stream().filter(item -> item.getDynamicObject("rerporttype").getPkValue().equals(reportDO.getLong("reportperiod.reporttype.id"))).findFirst().get();
            ReportPeriodType reportPeriodType = ReportPoConverter.getReportPeriodType(entry);
            report.setReportPeriodType(reportPeriodType);
            report.setStartDate(reportDO.getDate("declarestartdate"));
            report.setCloseDate(reportDO.getDate("declaredeadline"));
            report.setInitFlag(Boolean.valueOf(reportDO.getBoolean("initflag")));
            report.setReportStatus(ReportStatus.getByVal((String)reportDO.getString("planstatus")));
            ReportPoConverter.setProcessStatus(reportDO, (Report)report);
            if (EmptyUtil.isNoEmpty((Long)reportDO.getLong("summaryconfigsnp"))) {
                report.setSumParamConfigSnapshotId(Long.valueOf(reportDO.getLong("summaryconfigsnp")));
            }
            report.setZeroReport(reportDO.getBoolean("zeroreport"));
            if (reportDO.get("parenttemplate") != null) {
                report.setParentTemplateId(Long.valueOf(reportDO.getLong("parenttemplate.id")));
                reportTemplate.setAmountUnit(AmountUnit.getByNumber((String)reportDO.getString("parenttemplate.amountunit")));
            }
            List<OrgMember> finalOrgMemberList = ReportPoConverter.getFinalOrgMemberList(reportDO, reportTemplate, (Report)report);
            report.setCompanyMemberList(finalOrgMemberList);
            TemplateDim companyTemplateDim = allTemplateDim.stream().filter(item -> DimensionType.ORG == item.getDimType()).findFirst().get();
            companyTemplateDim.setMemberScope(finalOrgMemberList.stream().map(DimMember::getId).collect(Collectors.toList()));
            ReportPoConverter.setPeriodMemberList(reportDO, (Report)report, entryEntity, entry, reportPeriodType);
            List periodMemList = report.getPeriodMemberList();
            List<Dimension> detailDimList = new DetailPlanFieldsRepository().queryDetailDimenBySystemId(Collections.singleton(reportDO.getLong("bodysys.id")));
            TemplateDim periodTemplateDim = allTemplateDim.stream().filter(item -> item.getDimType() == DimensionType.PERIOD).findFirst().get();
            periodTemplateDim.setMemberScope(periodMemList.stream().map(DimMember::getId).collect(Collectors.toList()));
            LinkedList<ReportData> reportDataList = new LinkedList<ReportData>();
            Map<String, Long> dimMap = ReportPoConverter.getDimMap(reportTemplate, isSumPlan);
            Map<Long, Map<Long, String>> reportDataAuxMap = ReportPoConverter.getReportDataAuxMap(reportDO);
            boolean detail = reportTemplate.getTemplateType().isDetail();
            DynamicObjectCollection sourceIdSaveEntryCol = reportDO.getDynamicObjectCollection("sourceidentry");
            Map<Long, List<DynamicObject>> sourceIdMap = sourceIdSaveEntryCol.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getLong("rdi_reportdataid")));
            DataSet[] dataSets = ReportPoConverter.getMainAndDetailEntryDataSet(report.getId());
            DataSet mainEntryDataSet = dataSets[0];
            DataSet detailEntryDataSet = dataSets[1];
            Map<String, String> reportPlanDetailMappingWithEntry = DimensionMappingHelper.getReportPlanDetailMappingWithEntry(reportTemplate.getSystemId());
            try {
                while (mainEntryDataSet.hasNext()) {
                    Row rowData = mainEntryDataSet.next();
                    Row detailData = detailEntryDataSet.next();
                    Long rDId = rowData.getLong("maindimentry.id");
                    if (rDId == null || rDId.equals(0L)) continue;
                    ReportData reportData = ReportPoConverter.getReportData((Report)report, sourceIdMap, rowData, detailData, rDId);
                    ArrayList<TemplateDim> dimList = new ArrayList<TemplateDim>(16);
                    ArrayList<Object> dimValList = new ArrayList<Object>(16);
                    ReportPoConverter.dealDimMemberDataOfMainDim(rowData, dimList, dimMap, templateMainDimMap, dimValList, reportTemplate);
                    if (!detail) {
                        reportData.setAuxiliaryInfo(ReportHelper.isAuxiliaryInfo(dimList, allTemplateDim));
                    }
                    ReportPoConverter.dealDimMemberDataOfDetailDim(detailData, dimList, dimMap, templateDetailDimMap, dimValList, reportTemplate, detailDimList, reportPlanDetailMappingWithEntry);
                    reportData.setDimValList(dimValList);
                    String amountUnitStr = rowData.getString("maindimentry.amountunit");
                    if (!StringUtils.isEmpty((Object)amountUnitStr)) {
                        reportData.setAmountUnit(AmountUnit.getByNumber((String)amountUnitStr));
                    }
                    if (reportDataAuxMap.containsKey(reportData.getId())) {
                        reportData.setAuxiliaryValMap(reportDataAuxMap.get(reportData.getId()));
                        reportData.setAuxiliaryInfo(true);
                    }
                    reportData.setDimList(dimList);
                    reportDataList.add(reportData);
                    MetricValueUtils.fillMetricValMap((ReportData)reportData, (Report)report);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{mainEntryDataSet, detailEntryDataSet});
                throw throwable;
            }
            IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{mainEntryDataSet, detailEntryDataSet});
            report.setReportDataList(reportDataList);
            Map<Object, BigDecimal> exchangeRateMap = ReportPoConverter.getExchangeRateMap(reportDO, fundSystemDy, (Report)report);
            if (exchangeRateMap.size() > 0) {
                report.setExchangeRateMap(exchangeRateMap);
            }
            SumPlanReport sumPlanReport = report;
            return sumPlanReport;
        }
        finally {
            CustomDimThreadLocalHelper.clean();
        }
    }

    private static void setPeriodMemberList(DynamicObject reportDO, Report report, DynamicObjectCollection entryEntity, DynamicObject entry, ReportPeriodType reportPeriodType) {
        DynamicObjectCollection periodObjColl = reportDO.getDynamicObjectCollection("periodlist");
        List periodObjArr = periodObjColl.stream().map(item -> item.get("fbasedataid.id")).collect(Collectors.toList());
        HashSet periodIdSet = new HashSet(QueryServiceHelper.queryPrimaryKeys((String)"fpm_member", (QFilter[])new QFilter("id", "in", periodObjArr).toArray(), null, (int)-1));
        List dimMemberOrgS = (List)dimMemberRepository.getPeriodDimMembers(Collections.singletonList(report.getSystemId())).get(report.getSystemId());
        List<Object> dimMembers = new ArrayList(dimMemberOrgS);
        if (reportPeriodType.getPeriodType() != PeriodType.YEAR) {
            dimMembers = dimMembers.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).collect(Collectors.toList());
        }
        List periodMemList = dimMembers.stream().filter(item -> periodIdSet.contains(item.getId())).map(item -> (PeriodMember)item).sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
        report.setPeriodMemberList(periodMemList);
        DynamicObject referencePeriodObj = reportDO.getDynamicObject("referenceperiod");
        if (referencePeriodObj != null) {
            List childrenS = dimMemberOrgS.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).collect(Collectors.toList());
            dimMemberOrgS.addAll(childrenS);
            PeriodMember periodMember = (PeriodMember)dimMemberOrgS.stream().filter(item -> item.getId().equals(referencePeriodObj.get("id"))).findFirst().get();
            report.setReferencePeriodMember(periodMember);
            ReportPeriodType referencePeriodType = ReportPoConverter.getReportPeriodType(entryEntity, entry, periodMember);
            report.setReferencePeriodType(referencePeriodType);
        }
    }

    private static void setProcessStatus(DynamicObject reportDO, Report report) {
        String status = reportDO.getString("billstatus");
        if (BillStatusEnum.SAVE.getValue().equals(status)) {
            report.setProcessStatus(ReportProcessStatus.SAVE);
        } else if (BillStatusEnum.SUBMIT.getValue().equals(status)) {
            report.setProcessStatus(ReportProcessStatus.SUBMIT);
        } else if (BillStatusEnum.AUDIT.getValue().equals(status)) {
            report.setProcessStatus(ReportProcessStatus.AUDIT);
        }
    }

    private static DataSet[] getMainAndDetailEntryDataSet(Long reportId) {
        Map entryPropMap = FpmHelper.getEntryPropertyS((String)"fpm_report", Arrays.asList("maindimentry", "detailentry"));
        Set entryPropertySet = (Set)entryPropMap.get("maindimentry");
        entryPropertySet.add("maindimentry.id");
        entryPropertySet.add("id");
        entryPropertySet.add(String.join((CharSequence)".", "maindimentry", "sourceid_tag"));
        DataSet mainEntryDataSet = QueryServiceHelper.queryDataSet((String)"report.queryMainData", (String)"fpm_report", (String)String.join((CharSequence)",", entryPropertySet), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId)}, (String)"maindimentry.id");
        Set detailEntryPropertySet = (Set)entryPropMap.get("detailentry");
        DataSet detailEntryDataSet = QueryServiceHelper.queryDataSet((String)"report.queryDetailData", (String)"fpm_report", (String)String.join((CharSequence)",", detailEntryPropertySet), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId)}, (String)"detailentry.maindimdataid");
        return new DataSet[]{mainEntryDataSet, detailEntryDataSet};
    }

    private static List<OrgMember> getFinalOrgMemberList(DynamicObject reportDO, ReportTemplate reportTemplate, Report report) {
        boolean isSumPlan = ReportPlanTypeEnum.isSumPlan((String)reportDO.getString("reportplantype"));
        Long reportOrgId = reportDO.getLong("reportorg.id");
        DimensionRepository dimensionRep = new DimensionRepository();
        Long orgDimId = reportDO.getLong("reportorg.dimension.id");
        Dimension orgDim = Optional.ofNullable(dimensionRep.loadDimension(orgDimId, DimensionType.ORG)).orElseGet(Dimension::new);
        List orgMemberList = orgDim.getAllDimMemberList() == null ? new ArrayList(2) : orgDim.getAllDimMemberList();
        ArrayList<OrgMember> finalOrgMemberList = new ArrayList<OrgMember>();
        if (isSumPlan) {
            ReportTemplate targetTpl = reportTemplate;
            if (reportDO.get("parenttemplate") != null) {
                Long parentTemplateId = report.getParentTemplateId();
                TemplateRepository templateRepository = new TemplateRepository();
                targetTpl = templateRepository.loadTemplate(parentTemplateId.longValue());
            }
            OrgMember sumOrgMember = (OrgMember)orgDim.getDimMemberByDimId(OrgMember.class, reportOrgId);
            TemplateDim orgTplDim = targetTpl.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.ORG).findFirst().get();
            TemplateDimMemScopeType scopeType = orgTplDim.getScopeType();
            if (TemplateDimMemScopeType.DIRECT_SUB_LEVEL == scopeType) {
                List childrenS = sumOrgMember.getChildren();
                finalOrgMemberList.add(sumOrgMember);
                finalOrgMemberList.addAll(childrenS.stream().map(item -> (OrgMember)item).collect(Collectors.toList()));
            } else if (TemplateDimMemScopeType.SUM_NODE_THIS_LEVEL == scopeType) {
                finalOrgMemberList.add(sumOrgMember);
            } else {
                finalOrgMemberList.addAll(orgMemberList.stream().filter(item -> orgTplDim.getMemberScope().contains(item.getId())).map(item -> (OrgMember)item).collect(Collectors.toList()));
            }
        } else {
            finalOrgMemberList.addAll(orgMemberList.stream().filter(item -> item.getId().equals(reportOrgId)).map(item -> (OrgMember)item).collect(Collectors.toList()));
        }
        return finalOrgMemberList;
    }

    private static ReportPeriodType getReportPeriodType(DynamicObjectCollection entryEntity, DynamicObject entry, PeriodMember periodMember) {
        ReportPeriodType referencePeriodType = new ReportPeriodType();
        DynamicObject referenceEntry = entryEntity.stream().filter(item -> item.getDynamicObject("rerporttype").getPkValue().equals(periodMember.getPeriodTypeId())).findFirst().get();
        DynamicObject reportPeriodPO = referenceEntry.getDynamicObject("rerporttype");
        referencePeriodType.setEnable("enable".equals(referenceEntry.getString("rereporttypestatus")));
        referencePeriodType.setId((Long)referenceEntry.getPkValue());
        referencePeriodType.setReportPeriodId((Long)reportPeriodPO.getPkValue());
        referencePeriodType.setName(reportPeriodPO.getString("name"));
        referencePeriodType.setNumber(reportPeriodPO.getString("number"));
        referencePeriodType.setPeriodType(PeriodType.getByNumber((String)reportPeriodPO.getString("orgreportcycle")));
        String detailType = reportPeriodPO.getString("orgreporttype");
        if (!EmptyUtil.isEmpty((String)detailType)) {
            referencePeriodType.setDetailPeriodType(PeriodType.getByNumber((String)detailType));
        } else {
            referencePeriodType.setDetailPeriodType(null);
        }
        referencePeriodType.setSum(entry.getBoolean("issumreport"));
        referencePeriodType.setSumEditable(entry.getBoolean("ismodify"));
        referencePeriodType.setRoll(entry.getBoolean("isroll"));
        referencePeriodType.setRollNum(Integer.valueOf(entry.getInt("rollnumber")));
        return referencePeriodType;
    }

    private static Map<Long, Map<Long, String>> getReportDataAuxMap(DynamicObject reportDO) {
        DynamicObjectCollection auxCollection = reportDO.getDynamicObjectCollection("auxentry");
        HashMap<Long, Map<Long, String>> reportDataAuxMap = new HashMap<Long, Map<Long, String>>();
        if (!CollectionUtils.isEmpty((Collection)auxCollection)) {
            for (DynamicObject auxDO : auxCollection) {
                long reportDataId = auxDO.getLong("aux_reportdataid");
                if (reportDataAuxMap.containsKey(reportDataId)) {
                    ((Map)reportDataAuxMap.get(reportDataId)).put(auxDO.getLong("aux_bdtype.id"), auxDO.getString("aux_content"));
                    continue;
                }
                HashMap<Long, String> auxValMap = new HashMap<Long, String>();
                auxValMap.put(auxDO.getLong("aux_bdtype.id"), auxDO.getString("aux_content"));
                reportDataAuxMap.put(reportDataId, auxValMap);
            }
        }
        return reportDataAuxMap;
    }

    private static ReportData getReportData(Report report, Map<Long, List<DynamicObject>> sourceIdMap, Row rowData, Row detailData, Long rDId) {
        ReportData reportData = new ReportData();
        reportData.setPlanReferenceAmt(rowData.getBigDecimal("maindimentry.planreferenceamt"));
        reportData.setReportPlanAmt(rowData.getBigDecimal("maindimentry.reportplanamt"));
        reportData.setOriginalPlanAmt(rowData.getBigDecimal("maindimentry.orgplanamt"));
        reportData.setReportPlanAmt(rowData.getBigDecimal("maindimentry.reportplanamt"));
        reportData.setPlanAmt(rowData.getBigDecimal("maindimentry.planamt"));
        reportData.setOffsetAmt(rowData.getBigDecimal("maindimentry.offsetamt"));
        reportData.setActAmt(rowData.getBigDecimal("maindimentry.realamt"));
        reportData.setLockAmt(rowData.getBigDecimal("maindimentry.lockamt"));
        reportData.setVersion(rowData.getInteger("maindimentry.version"));
        List<DynamicObject> sourceIdDys = sourceIdMap.get(rDId);
        if (EmptyUtil.isNoEmpty(sourceIdDys)) {
            List sourceIds = sourceIdDys.stream().filter(Objects::nonNull).map(o -> o.getLong("sourcedocid")).collect(Collectors.toList());
            reportData.setSourceIdList(sourceIds);
        }
        reportData.setReportId(rowData.getLong("id"));
        reportData.setReportPeriodId(rowData.getLong("maindimentry.entryreportperiod"));
        reportData.setMainTable(rowData.getBoolean("maindimentry.maintable").booleanValue());
        reportData.setRow(rowData.getInteger("maindimentry.origindatarow").intValue());
        reportData.setCol(rowData.getInteger("maindimentry.origindatacol").intValue());
        reportData.setId(rDId);
        reportData.setLinkedReportId(report.getId());
        reportData.setDataType(ReportDataType.DIM_MEM);
        reportData.setEditable(false);
        reportData.setSystemId(rowData.getLong("maindimentry.system"));
        reportData.setVersion(rowData.getInteger("maindimentry.version"));
        reportData.setEffectFlag(rowData.getBoolean("maindimentry.effectflag").booleanValue());
        reportData.setRemark(detailData.getString("detailentry.remark"));
        reportData.setSmartGelFlag(rowData.getBoolean(String.join((CharSequence)".", "maindimentry", "smartgelflag")).booleanValue());
        return reportData;
    }

    private static Map<Object, BigDecimal> getExchangeRateMap(DynamicObject reportDO, DynamicObject fundSystemDy, Report report) {
        DynamicObject targetCurrency = fundSystemDy.getDynamicObject("currency");
        Long targetCurrencyId = targetCurrency.getLong("id");
        Date exchangeRateDate = report.getExchangeRateDate();
        if (exchangeRateDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6b63\u786e\u7684\u6c47\u7387\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\u8ba1\u5212\u7f16\u5236\u4e2d\u7684\u6c47\u7387\u65e5\u671f\u3002", (String)"ReportPoConverter_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        ArrayList<String> errMsg = new ArrayList<String>();
        HashMap<Object, BigDecimal> exchangeRateMap = new HashMap<Object, BigDecimal>();
        DynamicObjectCollection currencyRanges = reportDO.getDynamicObjectCollection("currencyrange");
        for (DynamicObject currencyRange : currencyRanges) {
            BigDecimal exchangeRate;
            Long sourceCurrencyId = currencyRange.getLong("fbasedataid.sourceid");
            if (sourceCurrencyId.compareTo(targetCurrencyId) != 0) {
                exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)report.getExchangeRateTableId(), (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)exchangeRateDate);
                if (exchangeRate == null) {
                    DynamicObject sourceCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)sourceCurrencyId, (String)"bd_currency", (String)"name");
                    errMsg.add(String.format(ResManager.loadKDString((String)"%1$s\u548c%2$s\u5e01\u79cd\u4e4b\u95f4\u7f3a\u5c11\u8f6c\u6362\u6c47\u7387\uff0c\u8bf7\u5148\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"ReportPoConverter_1", (String)"tmc-fpm-business", (Object[])new Object[0]), sourceCurrency.getString("name"), targetCurrency.getString("name")));
                    continue;
                }
            } else {
                exchangeRate = BigDecimal.ONE;
            }
            exchangeRateMap.put(currencyRange.getLong("fbasedataid.id"), exchangeRate);
        }
        if (errMsg.size() > 0) {
            throw new KDBizException(String.join((CharSequence)"\n", errMsg));
        }
        return exchangeRateMap;
    }

    private static ReportPeriodType getReportPeriodType(DynamicObject entry) {
        ReportPeriodType reportPeriodType = new ReportPeriodType();
        DynamicObject reportPeriodPO = entry.getDynamicObject("rerporttype");
        reportPeriodType.setEnable("enable".equals(entry.getString("rereporttypestatus")));
        reportPeriodType.setId((Long)entry.getPkValue());
        reportPeriodType.setReportPeriodId((Long)reportPeriodPO.getPkValue());
        reportPeriodType.setName(reportPeriodPO.getString("name"));
        reportPeriodType.setNumber(reportPeriodPO.getString("number"));
        reportPeriodType.setPeriodType(PeriodType.getByNumber((String)reportPeriodPO.getString("orgreportcycle")));
        String detailType = reportPeriodPO.getString("orgreporttype");
        if (!EmptyUtil.isEmpty((String)detailType)) {
            reportPeriodType.setDetailPeriodType(PeriodType.getByNumber((String)detailType));
        } else {
            reportPeriodType.setDetailPeriodType(null);
        }
        reportPeriodType.setSum(entry.getBoolean("issumreport"));
        reportPeriodType.setSumEditable(entry.getBoolean("ismodify"));
        reportPeriodType.setRoll(entry.getBoolean("isroll"));
        reportPeriodType.setRollNum(Integer.valueOf(entry.getInt("rollnumber")));
        reportPeriodType.setRollIncludeDetailPeriod(entry.getBoolean("iscontaindetail"));
        return reportPeriodType;
    }

    private static List<SumPlanReport.SunReportSumRecord> getSunReportSumRecordList(DynamicObject reportDO) {
        DynamicObjectCollection sumEntryColl = reportDO.getDynamicObjectCollection("sumentry");
        ArrayList<SumPlanReport.SunReportSumRecord> sumInfoList = new ArrayList<SumPlanReport.SunReportSumRecord>(sumEntryColl.size());
        for (DynamicObject sumEntryInfo : sumEntryColl) {
            SumPlanReport.SunReportSumRecord sunReportSumRecord = new SumPlanReport.SunReportSumRecord();
            sunReportSumRecord.setSunReportId(Long.valueOf(sumEntryInfo.getLong("sumorgreportid")));
            sunReportSumRecord.setSumStatus((SunReportSumStatus)ITypeEnum.getByNumber((String)sumEntryInfo.getString("sumstatus"), SunReportSumStatus.class));
            sumInfoList.add(sunReportSumRecord);
        }
        return sumInfoList;
    }

    private static Map<String, Long> getDimMap(ReportTemplate reportTemplate, boolean isSumPlan) {
        Map<String, Long> detailPlanMap;
        DynamicObjectCollection detailPlanColl;
        DynamicObjectCollection dimColl;
        Map<String, Long> dimMap = null;
        if (isSumPlan) {
            dimColl = QueryServiceHelper.query((String)"fpm_dimension", (String)"id,basedata", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", (Object)reportTemplate.getSystemId())});
            detailPlanColl = QueryServiceHelper.query((String)"fpm_detailplanfields", (String)"id,detaildimtype", (QFilter[])new QFilter[]{new QFilter("bodysys", "=", (Object)reportTemplate.getSystemId())});
            dimMap = dimColl.stream().collect(Collectors.toMap(item -> item.getString("basedata"), item -> item.getLong("id"), (a, b) -> a));
            detailPlanMap = detailPlanColl.stream().collect(Collectors.toMap(item -> item.getString("detaildimtype"), item -> item.getLong("id"), (a, b) -> a));
            dimMap.putAll(detailPlanMap);
        }
        if (reportTemplate.getTemplateUse() == TemplateUseType.SUMMARY) {
            dimColl = QueryServiceHelper.query((String)"fpm_dimension", (String)String.join((CharSequence)",", "id", "basedata", "number"), (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", (Object)reportTemplate.getSystemId())});
            detailPlanColl = QueryServiceHelper.query((String)"fpm_detailplanfields", (String)"id,detaildimtype", (QFilter[])new QFilter[]{new QFilter("bodysys", "=", (Object)reportTemplate.getSystemId())});
            dimMap = dimColl.stream().collect(Collectors.toMap(item -> item.getString("basedata"), item -> item.getLong("id"), (a, b) -> a));
            detailPlanMap = detailPlanColl.stream().collect(Collectors.toMap(item -> item.getString("detaildimtype"), item -> item.getLong("id"), (a, b) -> a));
            dimMap.putAll(detailPlanMap);
            Map<String, Long> customNumberIdMap = dimColl.stream().filter(dy -> Objects.equals(dy.getString("basedata"), DimensionType.CUSTOM.getNumber())).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLong("id")));
            CustomDimThreadLocalHelper.set(customNumberIdMap);
        }
        return dimMap;
    }

    public static void dealDimMemberDataOfMainDim(Row rowData, List<TemplateDim> dimList, Map<String, Long> dimMap, Map<String, List<TemplateDim>> templateDimMap, List<Object> dimValList, ReportTemplate reportTemplate) {
        Set<Map.Entry<String, String>> mainDimEntrySet = ReportDataQueryService.MAINDIM_ENTRY_MAPPING_MAP.entrySet();
        for (Map.Entry<String, String> mainDimEntry : mainDimEntrySet) {
            String widgetSign;
            Object value;
            String key;
            if (ReportPoConverter.dealCustomMember(rowData, dimList, dimMap, templateDimMap, dimValList, reportTemplate, mainDimEntry, key = mainDimEntry.getKey()) || ((value = rowData.get(widgetSign = mainDimEntry.getValue())) == null || value.equals(0L)) && TemplateType.FIXED == reportTemplate.getTemplateType()) continue;
            List<TemplateDim> templateDimList = templateDimMap.get(mainDimEntry.getKey());
            TemplateDim templateDim = null;
            if (reportTemplate.getTemplateUse() == TemplateUseType.SUMMARY && CollectionUtils.isEmpty(templateDimList)) {
                DimensionType dimensionType = DimensionType.getDimsionByNumber((String)key);
                if (dimensionType != null && dimMap.containsKey(dimensionType.getNumber())) {
                    templateDim = new TemplateDim();
                    templateDim.setDimType(dimensionType);
                    DimsionEnums dimensionByNumber = DimsionEnums.getDimsionByNumber((String)dimensionType.getNumber());
                    templateDim.setDimensionName(dimensionByNumber == null ? "" : dimensionByNumber.getName());
                    templateDim.setDimensionId(dimMap.get(dimensionType.getNumber()));
                }
            } else if (!CollectionUtils.isEmpty(templateDimList)) {
                templateDim = templateDimList.get(0);
            }
            if (templateDim == null) continue;
            dimList.add(templateDim);
            dimValList.add(value);
        }
    }

    private static boolean dealCustomMember(Row rowData, List<TemplateDim> dimList, Map<String, Long> dimMap, Map<String, List<TemplateDim>> templateDimMap, List<Object> dimValList, ReportTemplate reportTemplate, Map.Entry<String, String> mainDimEntry, String key) {
        if (DimensionType.CUSTOM.getNumber().equals(key)) {
            String widgetSignStr = mainDimEntry.getValue();
            String[] widgetSigns = widgetSignStr.split(",");
            List<TemplateDim> templateDimList = templateDimMap.get(mainDimEntry.getKey());
            if (reportTemplate.getTemplateUse() == TemplateUseType.SUMMARY) {
                for (String widgetSign : widgetSigns) {
                    Object value = rowData.get(widgetSign);
                    if ((value == null || value.equals(0L)) && TemplateType.FIXED == reportTemplate.getTemplateType()) continue;
                    DimensionType dimensionType = DimensionType.getDimsionByNumber((String)key);
                    Long customDimIdByMemberId = CustomDimThreadLocalHelper.get().getCustomDimIdByMemberId((Long)value);
                    if (dimensionType == null || !EmptyUtil.isNoEmpty((Long)customDimIdByMemberId)) continue;
                    TemplateDim templateDim = new TemplateDim();
                    templateDim.setDimType(dimensionType);
                    templateDim.setDimensionId(customDimIdByMemberId);
                    dimValList.add(value);
                    dimList.add(templateDim);
                }
            } else if (!CollectionUtils.isEmpty(templateDimList)) {
                Set valueSet = Arrays.stream(widgetSigns).map(arg_0 -> ((Row)rowData).get(arg_0)).filter(Objects::nonNull).map(Long.class::cast).collect(Collectors.toSet());
                for (TemplateDim templateDim : templateDimList) {
                    if (templateDim == null) continue;
                    dimList.add(templateDim);
                    HashSet tempSet = new HashSet(valueSet);
                    tempSet.retainAll(templateDim.getMemberScope());
                    if (tempSet.size() == 1) {
                        dimValList.addAll(tempSet);
                        continue;
                    }
                    dimValList.add(0L);
                }
            }
            return true;
        }
        return false;
    }

    private static void dealDimMemberDataOfDetailDim(Row rowData, List<TemplateDim> dimList, Map<String, Long> dimMap, Map<String, TemplateDim> templateDimMap, List<Object> dimValList, ReportTemplate reportTemplate, List<Dimension> detailDimList, Map<String, String> reportPlanDetailMappingWithEntry) {
        for (Map.Entry<String, String> detailDimEntry : reportPlanDetailMappingWithEntry.entrySet()) {
            DetailDimType detailDimType;
            String key = detailDimEntry.getKey();
            String widgetSign = detailDimEntry.getValue();
            Object value = rowData.get(widgetSign);
            TemplateDim templateDim = templateDimMap.get(detailDimEntry.getKey());
            if (reportTemplate.getTemplateUse() == TemplateUseType.SUMMARY && templateDim == null && dimMap.containsKey((detailDimType = DetailDimType.getDimsionByNumber((String)key)).name())) {
                templateDim = new TemplateDim();
                templateDim.setDimType(DimensionType.DETAILDIM);
                templateDim.setDetailDim(true);
                templateDim.setDetailDimType(detailDimType);
                templateDim.setDimensionId(dimMap.get(detailDimType.name()));
            }
            if (templateDim == null) continue;
            TemplateDim finalTemplateDim = templateDim;
            Dimension dimension = detailDimList.stream().filter(item -> item.getId().equals(finalTemplateDim.getDimensionId())).findFirst().get();
            MemberType memberType = dimension.getMemberType();
            if (DetailDimType.isExtraCode((String)key)) {
                if (value != null && !StringUtils.isEmpty((Object)value.toString())) {
                    if (MemberType.DATE == memberType) {
                        value = new Date(Long.parseLong(value.toString()));
                    } else if (MemberType.BASE_DATA == memberType) {
                        value = Long.valueOf(value.toString());
                    }
                }
                if (MemberType.AMOUNT == memberType && StringUtils.isEmpty((Object)value)) {
                    value = BigDecimal.ZERO;
                }
            }
            dimList.add(templateDim);
            dimValList.add(value);
        }
    }

    private static String getEntrySignByDimType(String number) {
        return TYPE_MAPPING_MAP.get(number);
    }

    public static Report convertToSimpleReport(DynamicObject reportDO, ReportTemplate reportTemplate, ReportNeedPropDTO needPropDTO) {
        String reportPlanType = reportDO.getString("reportplantype");
        boolean isSumPlan = ReportPlanTypeEnum.isSumPlan((String)reportPlanType);
        SumPlanReport report = isSumPlan ? new SumPlanReport() : new Report();
        report.setId(Long.valueOf(reportDO.getLong("id")));
        report.setName(reportDO.getString("name"));
        report.setNumber(reportDO.getString("billno"));
        report.setSystemId(Long.valueOf(reportDO.getLong("bodysys.id")));
        report.setTemplate(reportTemplate);
        report.setExchangeRateTableId(Long.valueOf(reportDO.getLong("exratetable.id")));
        report.setExchangeRateDate(reportDO.getDate("exchangeratedate"));
        report.setInitFlag(Boolean.valueOf(reportDO.getBoolean("initflag")));
        ReportPoConverter.setProcessStatus(reportDO, (Report)report);
        String planStatus = reportDO.getString("planstatus");
        ReportStatus reportStatus = ReportStatus.getByVal((String)planStatus);
        report.setReportStatus(reportStatus);
        if (EmptyUtil.isNoEmpty((Object)reportDO.get("summaryconfigsnp"))) {
            report.setSumParamConfigSnapshotId(Long.valueOf(reportDO.getLong("summaryconfigsnp")));
        }
        report.setZeroReport(reportDO.getBoolean("zeroreport"));
        if (needPropDTO.isNeedAuditErId()) {
            report.setAuditErId(Long.valueOf(reportDO.getLong("auditor.id")));
        }
        if (needPropDTO.isNeedInformantErId()) {
            report.setInformantErId(Long.valueOf(reportDO.getLong("informant.id")));
        }
        if (reportDO.get("parenttemplate") != null) {
            report.setParentTemplateId(Long.valueOf(reportDO.getLong("parenttemplate.id")));
        }
        if (isSumPlan) {
            SumPlanReport sumPlanReport = report;
            sumPlanReport.setInnerOffset(reportDO.getBoolean("isinneroffset"));
            sumPlanReport.setSunReportSumRecordList(ReportPoConverter.getSunReportSumRecordList(reportDO));
        }
        if (needPropDTO.isNeedCompanyMember()) {
            Long reportOrgId = reportDO.getLong("reportorg.id");
            DimMember orgDimMember = (DimMember)dimMemberRepository.getOrgDimMembers(Collections.singletonList(reportOrgId)).get(reportOrgId);
            List<DimMember> memberList = Collections.singletonList(orgDimMember);
            List orgMemberList = memberList.stream().map(item -> (OrgMember)item).collect(Collectors.toList());
            report.setCompanyMemberList(orgMemberList);
            List<TemplateDim> currTemplateDimList = reportTemplate.getAllTemplateDim();
            TemplateDim companyTemplateDim = currTemplateDimList.stream().filter(item -> DimensionType.ORG == item.getDimType()).findFirst().get();
            companyTemplateDim.setMemberScope(orgMemberList.stream().map(DimMember::getId).collect(Collectors.toList()));
        }
        DynamicObject fundSystem = bodySystemRepository.loadBodySystem(reportDO.getLong("bodysys.id"));
        DynamicObjectCollection entryEntity = fundSystem.getDynamicObjectCollection("applyrereportentry");
        DynamicObject entry = entryEntity.stream().filter(item -> item.getDynamicObject("rerporttype").getPkValue().equals(reportDO.getLong("reportperiod.reporttype.id"))).findFirst().get();
        ReportPeriodType reportPeriodType = new ReportPeriodType();
        DynamicObject reportPeriodPO = entry.getDynamicObject("rerporttype");
        reportPeriodType.setEnable("enable".equals(entry.getString("rereporttypestatus")));
        reportPeriodType.setId((Long)entry.getPkValue());
        reportPeriodType.setReportPeriodId((Long)reportPeriodPO.getPkValue());
        reportPeriodType.setName(reportPeriodPO.getString("name"));
        reportPeriodType.setNumber(reportPeriodPO.getString("number"));
        reportPeriodType.setPeriodType(PeriodType.getByNumber((String)reportPeriodPO.getString("orgreportcycle")));
        String detailType = reportPeriodPO.getString("orgreporttype");
        if (!EmptyUtil.isEmpty((String)detailType)) {
            reportPeriodType.setDetailPeriodType(PeriodType.getByNumber((String)detailType));
        } else {
            reportPeriodType.setDetailPeriodType(null);
        }
        reportPeriodType.setSum(entry.getBoolean("issumreport"));
        reportPeriodType.setSumEditable(entry.getBoolean("ismodify"));
        reportPeriodType.setRoll(entry.getBoolean("isroll"));
        reportPeriodType.setRollNum(Integer.valueOf(entry.getInt("rollnumber")));
        report.setReportPeriodType(reportPeriodType);
        if (needPropDTO.isNeedPeriodMember()) {
            DynamicObjectCollection periodObjColl = reportDO.getDynamicObjectCollection("periodlist");
            Set periodObjList = periodObjColl.stream().map(item -> item.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            List<DimMember> dimMembers = ReportPoConverter.getDimMembers(report.getSystemId());
            List<Object> childMembers = new ArrayList<DimMember>(dimMembers);
            if (reportPeriodType.getPeriodType() != PeriodType.YEAR) {
                childMembers = childMembers.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).collect(Collectors.toList());
            }
            List periodMemList = childMembers.stream().filter(item -> periodObjList.contains(item.getId())).map(item -> (PeriodMember)item).sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
            report.setPeriodMemberList(periodMemList);
            List<TemplateDim> currTemplateDimList = reportTemplate.getAllTemplateDim();
            TemplateDim periodTemplateDim = currTemplateDimList.stream().filter(item -> item.getDimType() == DimensionType.PERIOD).findFirst().get();
            periodTemplateDim.setMemberScope(periodMemList.stream().map(DimMember::getId).collect(Collectors.toList()));
            DynamicObject referencePeriod = reportDO.getDynamicObject("referenceperiod");
            if (Objects.nonNull(referencePeriod)) {
                List referencePeriods = dimMembers.stream().filter(p -> Objects.equals(p.getId(), referencePeriod.getPkValue())).map(PeriodMember.class::cast).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(referencePeriods)) {
                    referencePeriods = childMembers.stream().filter(p -> Objects.equals(p.getId(), referencePeriod.getPkValue())).map(PeriodMember.class::cast).collect(Collectors.toList());
                }
                FpmAssertUtil.isNotEmpty(referencePeriods, (String)"referencePeriods is null");
                report.setReferencePeriodMember((PeriodMember)referencePeriods.get(0));
            }
        }
        return report;
    }

    public static Report convertToReportHead(DynamicObject reportDO, ReportTemplate reportTemplate, ReportNeedPropDTO needPropDTO) {
        String reportPlanType = reportDO.getString("reportplantype");
        boolean isSumPlan = ReportPlanTypeEnum.isSumPlan((String)reportPlanType);
        SumPlanReport report = isSumPlan ? new SumPlanReport() : new Report();
        report.setId(Long.valueOf(reportDO.getLong("id")));
        report.setName(reportDO.getString("name"));
        report.setNumber(reportDO.getString("billno"));
        report.setSystemId(Long.valueOf(reportDO.getLong("bodysys.id")));
        report.setTemplate(reportTemplate);
        report.setExchangeRateTableId(Long.valueOf(reportDO.getLong("exratetable.id")));
        report.setExchangeRateDate(reportDO.getDate("exchangeratedate"));
        report.setInitFlag(Boolean.valueOf(reportDO.getBoolean("initflag")));
        ReportPoConverter.setProcessStatus(reportDO, (Report)report);
        String planStatus = reportDO.getString("planstatus");
        ReportStatus reportStatus = ReportStatus.getByVal((String)planStatus);
        report.setReportStatus(reportStatus);
        if (EmptyUtil.isNoEmpty((Object)reportDO.get("summaryconfigsnp"))) {
            report.setSumParamConfigSnapshotId(Long.valueOf(reportDO.getLong("summaryconfigsnp")));
        }
        report.setZeroReport(reportDO.getBoolean("zeroreport"));
        if (needPropDTO.isNeedAuditErId()) {
            report.setAuditErId(Long.valueOf(reportDO.getLong("auditor.id")));
        }
        if (needPropDTO.isNeedInformantErId()) {
            report.setInformantErId(Long.valueOf(reportDO.getLong("informant.id")));
        }
        if (reportDO.get("parenttemplate") != null) {
            report.setParentTemplateId(Long.valueOf(reportDO.getLong("parenttemplate.id")));
        }
        if (isSumPlan) {
            SumPlanReport sumPlanReport = report;
            sumPlanReport.setInnerOffset(reportDO.getBoolean("isinneroffset"));
        }
        if (needPropDTO.isNeedCompanyMember()) {
            Long reportOrgId = reportDO.getLong("reportorg.id");
            DimMember orgDimMember = (DimMember)dimMemberRepository.getOrgDimMembers(Collections.singletonList(reportOrgId)).get(reportOrgId);
            List<DimMember> memberList = Collections.singletonList(orgDimMember);
            List orgMemberList = memberList.stream().map(item -> (OrgMember)item).collect(Collectors.toList());
            report.setCompanyMemberList(orgMemberList);
            List<TemplateDim> currTemplateDimList = reportTemplate.getAllTemplateDim();
            TemplateDim companyTemplateDim = currTemplateDimList.stream().filter(item -> DimensionType.ORG == item.getDimType()).findFirst().get();
            companyTemplateDim.setMemberScope(orgMemberList.stream().map(DimMember::getId).collect(Collectors.toList()));
        }
        DynamicObject fundSystem = bodySystemRepository.loadBodySystem(reportDO.getLong("bodysys.id"));
        DynamicObjectCollection entryEntity = fundSystem.getDynamicObjectCollection("applyrereportentry");
        DynamicObject entry = entryEntity.stream().filter(item -> item.getDynamicObject("rerporttype").getPkValue().equals(reportDO.getLong("reportperiod.reporttype.id"))).findFirst().get();
        ReportPeriodType reportPeriodType = new ReportPeriodType();
        DynamicObject reportPeriodPO = entry.getDynamicObject("rerporttype");
        reportPeriodType.setEnable("enable".equals(entry.getString("rereporttypestatus")));
        reportPeriodType.setId((Long)entry.getPkValue());
        reportPeriodType.setReportPeriodId((Long)reportPeriodPO.getPkValue());
        reportPeriodType.setName(reportPeriodPO.getString("name"));
        reportPeriodType.setNumber(reportPeriodPO.getString("number"));
        reportPeriodType.setPeriodType(PeriodType.getByNumber((String)reportPeriodPO.getString("orgreportcycle")));
        String detailType = reportPeriodPO.getString("orgreporttype");
        if (!EmptyUtil.isEmpty((String)detailType)) {
            reportPeriodType.setDetailPeriodType(PeriodType.getByNumber((String)detailType));
        } else {
            reportPeriodType.setDetailPeriodType(null);
        }
        reportPeriodType.setSum(entry.getBoolean("issumreport"));
        reportPeriodType.setSumEditable(entry.getBoolean("ismodify"));
        reportPeriodType.setRoll(entry.getBoolean("isroll"));
        reportPeriodType.setRollNum(Integer.valueOf(entry.getInt("rollnumber")));
        report.setReportPeriodType(reportPeriodType);
        if (needPropDTO.isNeedPeriodMember()) {
            DynamicObjectCollection periodObjColl = reportDO.getDynamicObjectCollection("periodlist");
            Set periodObjList = periodObjColl.stream().map(item -> item.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            List<DimMember> dimMembers = ReportPoConverter.getDimMembers(report.getSystemId());
            List<Object> childMembers = new ArrayList<DimMember>(dimMembers);
            if (reportPeriodType.getPeriodType() != PeriodType.YEAR) {
                childMembers = childMembers.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).collect(Collectors.toList());
            }
            List periodMemList = childMembers.stream().filter(item -> periodObjList.contains(item.getId())).map(item -> (PeriodMember)item).sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
            report.setPeriodMemberList(periodMemList);
            List<TemplateDim> currTemplateDimList = reportTemplate.getAllTemplateDim();
            TemplateDim periodTemplateDim = currTemplateDimList.stream().filter(item -> item.getDimType() == DimensionType.PERIOD).findFirst().get();
            periodTemplateDim.setMemberScope(periodMemList.stream().map(DimMember::getId).collect(Collectors.toList()));
            DynamicObject referencePeriod = reportDO.getDynamicObject("referenceperiod");
            if (Objects.nonNull(referencePeriod)) {
                List referencePeriods = dimMembers.stream().filter(p -> Objects.equals(p.getId(), referencePeriod.getPkValue())).map(PeriodMember.class::cast).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(referencePeriods)) {
                    referencePeriods = childMembers.stream().filter(p -> Objects.equals(p.getId(), referencePeriod.getPkValue())).map(PeriodMember.class::cast).collect(Collectors.toList());
                }
                FpmAssertUtil.isNotEmpty(referencePeriods, (String)"referencePeriods is null");
                report.setReferencePeriodMember((PeriodMember)referencePeriods.get(0));
            }
        }
        return report;
    }

    private static List<DimMember> getDimMembers(Long systemId) {
        return (List)dimMemberRepository.getPeriodDimMembers(Collections.singletonList(systemId)).get(systemId);
    }

    public static void rDConvToEntry(Long systemId, ReportData reportData, DynamicObject mainEntry, DynamicObject detailEntry, Map<Long, DynamicObject> auxMap, DynamicObjectCollection auxEntrys, DynamicObjectCollection sourceIdSaveEntrys, Map<Long, Integer> customDimSeqMap) {
        mainEntry.set("system", (Object)systemId);
        mainEntry.set("orgplanamt", (Object)reportData.getOriginalPlanAmt());
        mainEntry.set("reportplanamt", (Object)reportData.getReportPlanAmt());
        mainEntry.set("planreferenceamt", (Object)reportData.getPlanReferenceAmt());
        mainEntry.set("planamt", (Object)reportData.getPlanAmt());
        mainEntry.set("realamt", (Object)reportData.getActAmt());
        mainEntry.set("lockamt", (Object)reportData.getLockAmt());
        mainEntry.set("version", (Object)reportData.getVersion());
        mainEntry.set("origindatarow", (Object)reportData.getRow());
        mainEntry.set("origindatacol", (Object)reportData.getCol());
        mainEntry.set("effectflag", (Object)reportData.isEffectFlag());
        mainEntry.set("offsetamt", (Object)reportData.getOffsetAmt());
        mainEntry.set("entryreportperiod", (Object)reportData.getReportPeriodId());
        mainEntry.set("maintable", (Object)(reportData.isMainTable() ? "1" : "0"));
        mainEntry.set("amountunit", (Object)(reportData.getAmountUnit() == null ? "" : reportData.getAmountUnit().getNumber()));
        if (!CollectionUtils.isEmpty((Collection)reportData.getSourceIdList())) {
            mainEntry.set("smartgelflag", (Object)Boolean.TRUE);
        }
        List dimList = reportData.getDimList();
        List dimValList = reportData.getDimValList();
        Long mainDimId = (Long)mainEntry.getPkValue();
        detailEntry.set("maindimdataid", (Object)mainDimId);
        detailEntry.set("remark", (Object)reportData.getRemark());
        for (int i = 0; i < dimList.size(); ++i) {
            TemplateDim templateDim = (TemplateDim)dimList.get(i);
            Object value = dimValList.get(i);
            DimensionType dimType = templateDim.getDimType();
            if (DimensionType.METRIC.getNumber().equals(dimType.getNumber())) continue;
            if (DimensionType.DETAILDIM.getNumber().equals(dimType.getNumber())) {
                DetailDimType detailDimType = templateDim.getDetailDimType();
                if (ReportPoConverter.getEntrySignByDimType(detailDimType.getNumber()) == null) continue;
                if (DetailDimType.isExtraField((DetailDimType)detailDimType) && value instanceof Date) {
                    value = ((Date)value).getTime();
                }
                detailEntry.set(ReportPoConverter.getEntrySignByDimType(detailDimType.getNumber()), value);
                continue;
            }
            if (DimensionType.CUSTOM.getNumber().equals(dimType.getNumber())) {
                ReportPoConverter.fillCustomDimVal(mainEntry, value, templateDim, customDimSeqMap);
                continue;
            }
            String entrySignByDimType = ReportPoConverter.getEntrySignByDimType(dimType.getNumber());
            if (StringUtils.isEmpty((Object)entrySignByDimType)) continue;
            mainEntry.set(entrySignByDimType, value);
        }
        if (!CollectionUtils.isEmpty((Map)reportData.getAuxiliaryValMap())) {
            reportData.getAuxiliaryValMap().forEach((k, v) -> {
                DynamicObject auxDO = !CollectionUtils.isEmpty((Map)auxMap) && auxMap.containsKey(k) ? (DynamicObject)auxMap.get(k) : auxEntrys.addNew();
                auxDO.set("aux_reportdataid", (Object)mainDimId);
                auxDO.set("aux_bdtype", k);
                auxDO.set("aux_content", v);
            });
        }
        if (EmptyUtil.isNoEmpty((Object)reportData.getSourceIdList())) {
            Set sourceIdSet = sourceIdSaveEntrys.stream().map(o -> o.getLong("sourcedocid")).collect(Collectors.toSet());
            for (Long sourceId : reportData.getSourceIdList()) {
                if (!sourceIdSet.add(sourceId)) continue;
                DynamicObject sourceIdSaveEntry = sourceIdSaveEntrys.addNew();
                sourceIdSaveEntry.set("rdi_reportdataid", (Object)mainDimId);
                sourceIdSaveEntry.set("sourcedocid", (Object)sourceId);
            }
        }
    }

    public static List<ReportData> convertReportData(List<ReportDataQueryResult> resultList, List<TemplateDim> allTemplateDim) {
        ArrayList<ReportData> result = new ArrayList<ReportData>(resultList.size());
        resultList = resultList.stream().filter(item -> item.getDimIdList().size() <= allTemplateDim.size()).collect(Collectors.toList());
        Deque ids = CommonUtils.batchGenerateIds((int)resultList.size());
        for (ReportDataQueryResult reportDataQueryResult : resultList) {
            if (CommonUtils.getValueIfNull((BigDecimal)reportDataQueryResult.getPlanAmt()).compareTo(BigDecimal.ZERO) == 0 && CommonUtils.getValueIfNull((BigDecimal)reportDataQueryResult.getActAmt()).compareTo(BigDecimal.ZERO) == 0 && CommonUtils.getValueIfNull((BigDecimal)reportDataQueryResult.getLockAmt()).compareTo(BigDecimal.ZERO) == 0 && CommonUtils.getValueIfNull((BigDecimal)reportDataQueryResult.getApplyPlanAmt()).compareTo(BigDecimal.ZERO) == 0 && CommonUtils.getValueIfNull((BigDecimal)reportDataQueryResult.getOriginalPlanAmt()).compareTo(BigDecimal.ZERO) == 0 && CommonUtils.getValueIfNull((BigDecimal)reportDataQueryResult.getPlanReferenceAmt()).compareTo(BigDecimal.ZERO) == 0 && CommonUtils.getValueIfNull((BigDecimal)reportDataQueryResult.getOffsetAmt()).compareTo(BigDecimal.ZERO) == 0) continue;
            List currDimValList = reportDataQueryResult.getDimValList();
            ArrayList currDimList = new ArrayList(reportDataQueryResult.getDimIdList().size());
            for (Long dimId : reportDataQueryResult.getDimIdList()) {
                Optional<TemplateDim> first = allTemplateDim.stream().filter(item -> dimId.equals(item.getDimensionId())).findFirst();
                first.ifPresent(currDimList::add);
            }
            ReportData reportData = new ReportData();
            reportData.clearAmt();
            Long queryResultId = reportDataQueryResult.getId();
            reportData.setId(EmptyUtil.isEmpty((Long)queryResultId) ? (Long)ids.poll() : queryResultId);
            reportData.addActAmt(reportDataQueryResult.getActAmt());
            reportData.addPlanAmt(reportDataQueryResult.getPlanAmt());
            reportData.addLockAmt(reportDataQueryResult.getLockAmt());
            reportData.addOriginalPlanAmt(reportDataQueryResult.getOriginalPlanAmt());
            reportData.addReportPlanAmt(reportDataQueryResult.getReportPlanAmt());
            reportData.addPlanReferenceAmt(reportDataQueryResult.getPlanReferenceAmt());
            reportData.setVersion(Integer.valueOf(reportDataQueryResult.getVersion() + 1));
            reportData.setDimValList(currDimValList);
            reportData.setAmountUnit(reportDataQueryResult.getAmountUnit());
            reportData.setReportId(reportDataQueryResult.getReportId());
            reportData.setMainTable(reportDataQueryResult.isMainTable());
            reportData.setOffsetAmt(CommonUtils.getValueIfNull((BigDecimal)reportData.getOffsetAmt()).add(CommonUtils.getValueIfNull((BigDecimal)reportDataQueryResult.getOffsetAmt())));
            reportData.setRow(reportDataQueryResult.getRow());
            reportData.setCol(reportDataQueryResult.getCol());
            reportData.putAllMetricVal(reportDataQueryResult.getMetricValMap());
            reportData.setRow(reportDataQueryResult.getRow());
            reportData.setCol(reportDataQueryResult.getCol());
            reportData.setSystemId(reportDataQueryResult.getSystemId());
            reportData.setDimList(currDimList);
            reportData.setReportPeriodId(reportDataQueryResult.getReportPeriodId());
            result.add(reportData);
        }
        return result;
    }

    private static void fillCustomDimVal(DynamicObject entryDy, Object value, TemplateDim templateDim, Map<Long, Integer> customDimSeqMap) {
        Integer storeSeq = customDimSeqMap.get(templateDim.getDimensionId());
        String storeProperty = (String)CustomDimSeqServiceImpl.seq2ReportCustomPropertyMap.get(storeSeq);
        DynamicObject dynamicObject = TmcDataServiceHelper.newDynamicObject((String)"fpm_member");
        dynamicObject.set("id", value);
        entryDy.set(storeProperty, (Object)dynamicObject);
    }
}

