/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.ReportDataType;
import kd.tmc.fpm.business.domain.enums.ReportPlanChangeStatus;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.CustomDimThreadLocalHelper;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.repository.dto.ReportBatchDataMapDTO;
import kd.tmc.fpm.business.mvc.repository.dto.ReportNeedPropDTO;
import kd.tmc.fpm.business.mvc.repository.impl.DetailPlanFieldsRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.utils.DataSetUtil;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.ReportPlanTypeEnum;

public class ReportPoNewConverter {
    public static Report convertToSimpleReport(Row reportDO, ReportTemplate reportTemplate, ReportNeedPropDTO needPropDTO, ReportBatchDataMapDTO batchDataMap) {
        boolean isSumPlan = ReportPlanTypeEnum.isSumPlan((String)reportDO.getString("reportplantype"));
        Report report = ReportPoNewConverter.buildSimpleReport(reportDO, reportTemplate);
        if (needPropDTO.isNeedAuditErId()) {
            report.setAuditErId(reportDO.getLong("auditor.id"));
        }
        if (needPropDTO.isNeedInformantErId()) {
            ReportPoNewConverter.setInformantErId(reportDO, report);
        }
        ReportPoNewConverter.setParentTemplateId(reportDO, report, reportTemplate, batchDataMap);
        if (isSumPlan) {
            ReportPoNewConverter.setSunReportSumRecordList(reportDO, report, batchDataMap);
        }
        if (needPropDTO.isNeedCompanyMember()) {
            ReportPoNewConverter.setCompanyMember(reportDO, report, batchDataMap);
        }
        report.setReportPeriodType(batchDataMap.getReportPeriodType(reportDO.getLong("reportperiod")));
        if (needPropDTO.isNeedPeriodMember()) {
            ReportPoNewConverter.setPeriodMember(reportDO, report, batchDataMap);
        }
        return report;
    }

    public static Report convertToReport(Row reportDO, ReportTemplate reportTemplate, ReportNeedPropDTO needPropDTO, ReportBatchDataMapDTO batchDataMap) {
        Report report = ReportPoNewConverter.buildSimpleReport(reportDO, reportTemplate);
        String reportPlanType = reportDO.getString("reportplantype");
        if (EmptyUtil.isNoEmpty((String)reportPlanType)) {
            report.setReportPlanType((ReportPlanType)ITypeEnum.getByNumber((String)reportPlanType, ReportPlanType.class));
        }
        report.setStartDate(reportDO.getDate("declarestartdate"));
        report.setCloseDate(reportDO.getDate("declaredeadline"));
        Long attachId = reportDO.getLong("attachinfo.id");
        if (EmptyUtil.isNoEmpty((Long)attachId)) {
            report.setAttachId(attachId);
        }
        report.setChangeStatus(ReportPlanChangeStatus.getByVal((String)reportDO.getString("changestatus")));
        if (needPropDTO.isNeedInformantErId()) {
            ReportPoNewConverter.setInformantErId(reportDO, report);
        }
        ReportPoNewConverter.setParentTemplateId(reportDO, report, reportTemplate, batchDataMap);
        boolean isSumPlan = report instanceof SumPlanReport;
        if (isSumPlan) {
            ReportPoNewConverter.setSunReportSumRecordList(reportDO, report, batchDataMap);
        }
        if (needPropDTO.isNeedCompanyMember()) {
            ReportPoNewConverter.setCompanyMember(reportDO, report, batchDataMap);
        }
        report.setReportPeriodType(batchDataMap.getReportPeriodType(reportDO.getLong("reportperiod")));
        if (needPropDTO.isNeedPeriodMember()) {
            ReportPoNewConverter.setPeriodMember(reportDO, report, batchDataMap);
        }
        ReportBatchDataMapDTO.ReportDataMap reportDataMap = batchDataMap.getReportDataMap(report.getId());
        DataSet[] dataSets = reportDataMap.getDataSets();
        List<ReportData> reportDataList = ReportPoNewConverter.buildReportDataList(report, reportTemplate, dataSets, batchDataMap);
        batchDataMap.removeReportDataMap(report.getId());
        report.setReportDataList(reportDataList);
        report.setExchangeRateMap(reportDataMap.getExchangeRateMap());
        return report;
    }

    private static Report buildSimpleReport(Row reportDO, ReportTemplate reportTemplate) {
        String reportPlanType = reportDO.getString("reportplantype");
        boolean isSumPlan = ReportPlanTypeEnum.isSumPlan((String)reportPlanType);
        SumPlanReport report = isSumPlan ? new SumPlanReport() : new Report();
        report.setId(reportDO.getLong("id"));
        report.setName(reportDO.getString("name"));
        report.setNumber(reportDO.getString("billno"));
        report.setSystemId(reportDO.getLong("bodysys.id"));
        report.setTemplate(reportTemplate);
        report.setExchangeRateTableId(reportDO.getLong("exratetable.id"));
        report.setExchangeRateDate(reportDO.getDate("exchangeratedate"));
        report.setInitFlag(reportDO.getBoolean("initflag"));
        report.setProcessStatus(ReportProcessStatus.getStatusByVal((String)reportDO.getString("billstatus")));
        report.setReportStatus(ReportStatus.getByVal((String)reportDO.getString("planstatus")));
        Object configSnapshotId = reportDO.get("summaryconfigsnp");
        if (EmptyUtil.isNoEmpty((Object)configSnapshotId)) {
            report.setSumParamConfigSnapshotId((Long)configSnapshotId);
        }
        report.setZeroReport(reportDO.getBoolean("zeroreport").booleanValue());
        return report;
    }

    private static void setInformantErId(Row reportDO, Report report) {
        Long userId = reportDO.getLong("informant.id");
        report.setInformantErId(userId);
        DynamicObject user = TmcDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)"name");
        report.setInformanStr(user != null ? user.getString("name") : null);
    }

    private static void setParentTemplateId(Row reportDO, Report report, ReportTemplate reportTemplate, ReportBatchDataMapDTO batchDataMap) {
        Object parentTemplateId = reportDO.get("parenttemplate.id");
        if (EmptyUtil.isNoEmpty((Object)parentTemplateId)) {
            Long templateId = (Long)parentTemplateId;
            report.setParentTemplateId(templateId);
            DynamicObject template = batchDataMap.getTemplate(templateId);
            reportTemplate.setAmountUnit(AmountUnit.getByNumber((String)template.getString("amountunit")));
        }
    }

    private static void setSunReportSumRecordList(Row reportDO, Report report, ReportBatchDataMapDTO batchDataMap) {
        SumPlanReport sumPlanReport = (SumPlanReport)report;
        sumPlanReport.setInnerOffset(reportDO.getBoolean("isinneroffset").booleanValue());
        sumPlanReport.setSunReportSumRecordList(batchDataMap.getSumRecords(report.getId()));
    }

    private static void setCompanyMember(Row reportDO, Report report, ReportBatchDataMapDTO batchDataMap) {
        Long reportOrgId = reportDO.getLong("reportorg.id");
        List<OrgMember> orgMemberList = batchDataMap.getOrgDimMember(reportOrgId);
        report.setCompanyMemberList(orgMemberList);
        List<TemplateDim> currTemplateDimList = report.getTemplate().getAllTemplateDim();
        TemplateDim companyTemplateDim = currTemplateDimList.stream().filter(item -> DimensionType.ORG == item.getDimType()).findFirst().get();
        companyTemplateDim.setMemberScope(orgMemberList.stream().map(DimMember::getId).collect(Collectors.toList()));
    }

    private static void setPeriodMember(Row reportDO, Report report, ReportBatchDataMapDTO batchDataMap) {
        ReportTemplate reportTemplate = report.getTemplate();
        ReportPeriodType reportPeriodType = report.getReportPeriodType();
        Set<Long> periodObjList = batchDataMap.getPeriodList(report.getId());
        List<DimMember> dimMembers = batchDataMap.getSystemPeriodMemberMap(report.getSystemId());
        List<Object> childMembers = new ArrayList<DimMember>(dimMembers);
        if (reportPeriodType.getPeriodType() != PeriodType.YEAR) {
            childMembers = childMembers.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).collect(Collectors.toList());
        }
        List periodMemList = childMembers.stream().filter(item -> periodObjList.contains(item.getId())).map(item -> (PeriodMember)item).sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
        report.setPeriodMemberList(periodMemList);
        List<TemplateDim> currTemplateDimList = reportTemplate.getAllTemplateDim();
        TemplateDim periodTemplateDim = currTemplateDimList.stream().filter(item -> item.getDimType() == DimensionType.PERIOD).findFirst().get();
        periodTemplateDim.setMemberScope(periodMemList.stream().map(DimMember::getId).collect(Collectors.toList()));
        Long referencePeriod = reportDO.getLong("referenceperiod.id");
        if (EmptyUtil.isNoEmpty((Long)referencePeriod)) {
            List referencePeriods = dimMembers.stream().filter(p -> Objects.equals(p.getId(), referencePeriod)).map(PeriodMember.class::cast).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(referencePeriods)) {
                referencePeriods = childMembers.stream().filter(p -> Objects.equals(p.getId(), referencePeriod)).map(PeriodMember.class::cast).collect(Collectors.toList());
            }
            PeriodMember referencePeriodMember = (PeriodMember)referencePeriods.get(0);
            report.setReferencePeriodMember(referencePeriodMember);
            report.setReferencePeriodType(batchDataMap.getReportPeriodType(referencePeriod));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ReportData> buildReportDataList(Report report, ReportTemplate reportTemplate, DataSet[] dataSets, ReportBatchDataMapDTO batchDataMap) {
        LinkedList<ReportData> reportDataList = new LinkedList<ReportData>();
        boolean isSumPlan = report instanceof SumPlanReport;
        Map<String, Long> dimMap = ReportPoNewConverter.getDimMap(reportTemplate, isSumPlan);
        DataSet mainEntryDataSet = dataSets[0];
        DataSet detailEntryDataSet = dataSets[1];
        List<TemplateDim> allTemplateDim = reportTemplate.getAllTemplateDim();
        Map<String, List<TemplateDim>> templateMainDimMap = allTemplateDim.stream().filter(item -> item.getDimType() != DimensionType.DETAILDIM).collect(Collectors.groupingBy(o -> o.getDimType().getNumber()));
        Map<String, TemplateDim> templateDetailDimMap = allTemplateDim.stream().filter(item -> item.getDimType() == DimensionType.DETAILDIM).collect(Collectors.toMap(o -> o.getDetailDimType().getNumber(), Function.identity(), (a, b) -> a));
        Long reportId = report.getId();
        ReportBatchDataMapDTO.ReportDataMap reportDataMap = batchDataMap.getReportDataMap(reportId);
        Map<String, String> reportPlanDetailMappingWithEntry = reportDataMap.getDetailMapping();
        List<Dimension> detailDimList = reportDataMap.getDetailDimList();
        boolean detail = reportTemplate.getTemplateType().isDetail();
        Map<Long, List<Long>> sourceIdMap = reportDataMap.getReportDataSourceIdMap();
        Map<Long, Map<Long, String>> reportDataAuxMap = reportDataMap.getReportDataAuxMap();
        try {
            while (mainEntryDataSet.hasNext()) {
                Row rowData = mainEntryDataSet.next();
                Row detailData = detailEntryDataSet.next();
                Long rDId = rowData.getLong("maindimentry.id");
                if (rDId == null || rDId.equals(0L)) continue;
                ReportData reportData = ReportPoNewConverter.getReportData(reportId, sourceIdMap, rowData, detailData, rDId);
                ArrayList<TemplateDim> dimList = new ArrayList<TemplateDim>(16);
                ArrayList<Object> dimValList = new ArrayList<Object>(16);
                ReportPoNewConverter.dealDimMemberDataOfMainDim(rowData, dimList, dimMap, templateMainDimMap, dimValList, reportTemplate);
                if (!detail) {
                    reportData.setAuxiliaryInfo(ReportHelper.isAuxiliaryInfo(dimList, allTemplateDim));
                }
                ReportPoNewConverter.dealDimMemberDataOfDetailDim(detailData, dimList, dimMap, templateDetailDimMap, dimValList, reportTemplate, detailDimList, reportPlanDetailMappingWithEntry);
                reportData.setDimValList(dimValList);
                String amountUnitStr = rowData.getString("maindimentry.amountunit");
                if (!EmptyUtil.isEmpty((String)amountUnitStr)) {
                    reportData.setAmountUnit(AmountUnit.getByNumber((String)amountUnitStr));
                }
                if (reportDataAuxMap.containsKey(reportData.getId())) {
                    reportData.setAuxiliaryValMap(reportDataAuxMap.get(reportData.getId()));
                    reportData.setAuxiliaryInfo(true);
                }
                reportData.setDimList(dimList);
                reportDataList.add(reportData);
                MetricValueUtils.fillMetricValMap((ReportData)reportData, (Report)report);
            }
        }
        catch (Throwable throwable) {
            DataSetUtil.closeDataSet((DataSet[])new DataSet[]{mainEntryDataSet, detailEntryDataSet});
            throw throwable;
        }
        DataSetUtil.closeDataSet((DataSet[])new DataSet[]{mainEntryDataSet, detailEntryDataSet});
        return reportDataList;
    }

    private static Map<String, Long> getDimMap(ReportTemplate reportTemplate, boolean isSumPlan) {
        Map<String, Long> dimMap = null;
        Long systemId = reportTemplate.getSystemId();
        boolean isSummary = reportTemplate.getTemplateUse() == TemplateUseType.SUMMARY;
        Map<Object, Object> dimDataMap = Collections.emptyMap();
        if (isSumPlan || isSummary) {
            dimDataMap = DimensionRepository.loadFromCache("id,basedata,number", new QFilter[]{new QFilter("bodysystem", "=", (Object)systemId)});
            dimMap = dimDataMap.values().stream().collect(Collectors.toMap(item -> item.getString("basedata"), item -> item.getLong("id"), (a, b) -> a));
            dimMap.putAll(DetailPlanFieldsRepository.getDetailDimtypeIdMap(systemId));
        }
        if (isSummary) {
            Map<String, Long> customNumberIdMap = dimDataMap.values().stream().filter(dy -> Objects.equals(dy.getString("basedata"), DimensionType.CUSTOM.getNumber())).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLong("id")));
            CustomDimThreadLocalHelper.set(customNumberIdMap);
        }
        return dimMap;
    }

    private static ReportData getReportData(Long reportId, Map<Long, List<Long>> sourceIdMap, Row rowData, Row detailData, Long rDId) {
        ReportData reportData = new ReportData();
        reportData.setPlanReferenceAmt(rowData.getBigDecimal("maindimentry.planreferenceamt"));
        reportData.setReportPlanAmt(rowData.getBigDecimal("maindimentry.reportplanamt"));
        reportData.setOriginalPlanAmt(rowData.getBigDecimal("maindimentry.orgplanamt"));
        reportData.setReportPlanAmt(rowData.getBigDecimal("maindimentry.reportplanamt"));
        reportData.setPlanAmt(rowData.getBigDecimal("maindimentry.planamt"));
        reportData.setOffsetAmt(rowData.getBigDecimal("maindimentry.offsetamt"));
        reportData.setActAmt(rowData.getBigDecimal("maindimentry.realamt"));
        reportData.setLockAmt(rowData.getBigDecimal("maindimentry.lockamt"));
        reportData.setVersion(rowData.getInteger("maindimentry.version"));
        reportData.setSourceIdList(sourceIdMap.get(rDId));
        reportData.setReportId(rowData.getLong("id"));
        reportData.setReportPeriodId(rowData.getLong("maindimentry.entryreportperiod"));
        reportData.setMainTable(rowData.getBoolean("maindimentry.maintable").booleanValue());
        reportData.setRow(rowData.getInteger("maindimentry.origindatarow").intValue());
        reportData.setCol(rowData.getInteger("maindimentry.origindatacol").intValue());
        reportData.setId(rDId);
        reportData.setLinkedReportId(reportId);
        reportData.setDataType(ReportDataType.DIM_MEM);
        reportData.setEditable(false);
        reportData.setSystemId(rowData.getLong("maindimentry.system"));
        reportData.setVersion(rowData.getInteger("maindimentry.version"));
        reportData.setEffectFlag(rowData.getBoolean("maindimentry.effectflag").booleanValue());
        reportData.setRemark(detailData.getString("detailentry.remark"));
        reportData.setSmartGelFlag(rowData.getBoolean("maindimentry.smartgelflag").booleanValue());
        return reportData;
    }

    private static void dealDimMemberDataOfMainDim(Row rowData, List<TemplateDim> dimList, Map<String, Long> dimMap, Map<String, List<TemplateDim>> templateDimMap, List<Object> dimValList, ReportTemplate reportTemplate) {
        Set<Map.Entry<String, String>> mainDimEntrySet = ReportDataQueryService.MAINDIM_ENTRY_MAPPING_MAP.entrySet();
        for (Map.Entry<String, String> mainDimEntry : mainDimEntrySet) {
            String widgetSign;
            Object value;
            String key;
            if (ReportPoNewConverter.dealCustomMember(rowData, dimList, templateDimMap, dimValList, reportTemplate, mainDimEntry, key = mainDimEntry.getKey()) || ((value = rowData.get(widgetSign = mainDimEntry.getValue())) == null || value.equals(0L)) && reportTemplate.getTemplateType().isFixed()) continue;
            List<TemplateDim> templateDimList = templateDimMap.get(mainDimEntry.getKey());
            TemplateDim templateDim = null;
            if (reportTemplate.getTemplateUse().isSummary() && EmptyUtil.isEmpty(templateDimList)) {
                DimensionType dimensionType = DimensionType.getDimsionByNumber((String)key);
                if (dimensionType != null && dimMap.containsKey(dimensionType.getNumber())) {
                    templateDim = new TemplateDim();
                    templateDim.setDimType(dimensionType);
                    DimsionEnums dimensionByNumber = DimsionEnums.getDimsionByNumber((String)dimensionType.getNumber());
                    templateDim.setDimensionName(dimensionByNumber == null ? "" : dimensionByNumber.getName());
                    templateDim.setDimensionId(dimMap.get(dimensionType.getNumber()));
                }
            } else if (!EmptyUtil.isEmpty(templateDimList)) {
                templateDim = templateDimList.get(0);
            }
            if (templateDim == null) continue;
            dimList.add(templateDim);
            dimValList.add(value);
        }
    }

    private static boolean dealCustomMember(Row rowData, List<TemplateDim> dimList, Map<String, List<TemplateDim>> templateDimMap, List<Object> dimValList, ReportTemplate reportTemplate, Map.Entry<String, String> mainDimEntry, String key) {
        if (DimensionType.CUSTOM.getNumber().equals(key)) {
            String widgetSignStr = mainDimEntry.getValue();
            String[] widgetSigns = widgetSignStr.split(",");
            List<TemplateDim> templateDimList = templateDimMap.get(mainDimEntry.getKey());
            if (reportTemplate.getTemplateUse() == TemplateUseType.SUMMARY) {
                for (String widgetSign : widgetSigns) {
                    Object value = rowData.get(widgetSign);
                    if ((value == null || value.equals(0L)) && reportTemplate.getTemplateType().isFixed()) continue;
                    DimensionType dimensionType = DimensionType.getDimsionByNumber((String)key);
                    Long customDimIdByMemberId = CustomDimThreadLocalHelper.get().getCustomDimIdByMemberId((Long)value);
                    if (dimensionType == null || !EmptyUtil.isNoEmpty((Long)customDimIdByMemberId)) continue;
                    TemplateDim templateDim = new TemplateDim();
                    templateDim.setDimType(dimensionType);
                    templateDim.setDimensionId(customDimIdByMemberId);
                    dimValList.add(value);
                    dimList.add(templateDim);
                }
            } else if (!EmptyUtil.isEmpty(templateDimList)) {
                Set valueSet = Arrays.stream(widgetSigns).map(arg_0 -> ((Row)rowData).get(arg_0)).filter(Objects::nonNull).map(Long.class::cast).collect(Collectors.toSet());
                for (TemplateDim templateDim : templateDimList) {
                    if (templateDim == null) continue;
                    dimList.add(templateDim);
                    HashSet tempSet = new HashSet(valueSet);
                    tempSet.retainAll(templateDim.getMemberScope());
                    if (tempSet.size() == 1) {
                        dimValList.addAll(tempSet);
                        continue;
                    }
                    dimValList.add(0L);
                }
            }
            return true;
        }
        return false;
    }

    private static void dealDimMemberDataOfDetailDim(Row rowData, List<TemplateDim> dimList, Map<String, Long> dimMap, Map<String, TemplateDim> templateDimMap, List<Object> dimValList, ReportTemplate reportTemplate, List<Dimension> detailDimList, Map<String, String> reportPlanDetailMappingWithEntry) {
        for (Map.Entry<String, String> detailDimEntry : reportPlanDetailMappingWithEntry.entrySet()) {
            MemberType memberType;
            DetailDimType detailDimType;
            String key = detailDimEntry.getKey();
            String widgetSign = detailDimEntry.getValue();
            Object value = rowData.get(widgetSign);
            TemplateDim templateDim = templateDimMap.get(detailDimEntry.getKey());
            if (reportTemplate.getTemplateUse().isSummary() && templateDim == null && (detailDimType = DetailDimType.getDimsionByNumber((String)key)) != null && dimMap.containsKey(detailDimType.name())) {
                templateDim = new TemplateDim();
                templateDim.setDimType(DimensionType.DETAILDIM);
                templateDim.setDetailDim(true);
                templateDim.setDetailDimType(detailDimType);
                templateDim.setDimensionId(dimMap.get(detailDimType.name()));
            }
            if (templateDim == null) continue;
            TemplateDim finalTemplateDim = templateDim;
            Dimension dimension = detailDimList.stream().filter(item -> item.getId().equals(finalTemplateDim.getDimensionId())).findFirst().orElse(null);
            MemberType memberType2 = memberType = dimension != null ? dimension.getMemberType() : null;
            if (DetailDimType.isExtraCode((String)key)) {
                if (value != null && !EmptyUtil.isEmpty((String)value.toString())) {
                    if (MemberType.DATE == memberType) {
                        value = new Date(Long.parseLong(value.toString()));
                    } else if (MemberType.BASE_DATA == memberType) {
                        value = Long.valueOf(value.toString());
                    }
                }
                if (MemberType.AMOUNT == memberType && EmptyUtil.isEmpty((Object)value)) {
                    value = BigDecimal.ZERO;
                }
            }
            dimList.add(templateDim);
            dimValList.add(value);
        }
    }
}

