/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IDimensionCombinationQueryService;
import kd.tmc.fpm.business.dataproc.query.impl.DimensionCombinationQueryServiceImpl;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportDataScopePeriodType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.formula.ReportTreeNodeFormulaManager;
import kd.tmc.fpm.business.domain.formula.SubjectFindReportTreeNodeFormulaManager;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.generate.DimensionIndexTreeGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategyFactory;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionCombination;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionVal;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.IRelateReportDataManager;
import kd.tmc.fpm.business.mvc.service.calculate.ReportCalculateService;
import kd.tmc.fpm.business.mvc.service.calculate.ReportCalculateServiceFactory;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.dto.ReportCalculateDTO;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import org.apache.commons.collections.MapUtils;

public class RelateReportDataManager
implements IRelateReportDataManager {
    private List<ReportData> sourceReportDataList;
    private Set<Long> sourceReportDataIds;
    private Map<Long, Report> reportMap;
    private Map<Long, List<ReportData>> reportDataGroupByReport;
    private List<ReportData> relateReportDataList;
    private ControlContext controlContext;
    private IReportRepository reportRepository;
    private IDimensionRepository dimensionRepository;
    private IDimensionCombinationQueryService dimensionCombinationQueryService;
    private ReportCalculateService treeNodeScopeService;
    private Boolean calculateRollData = false;
    private static final Log logger = LogFactory.getLog(RelateReportDataManager.class);

    public RelateReportDataManager() {
    }

    public RelateReportDataManager(List<ReportData> sourceReportDataList) {
        this(sourceReportDataList, null);
    }

    public RelateReportDataManager(List<ReportData> sourceReportDataList, ControlContext controlContext) {
        this.buildManager(sourceReportDataList, controlContext);
    }

    public final void buildManager(List<ReportData> sourceReportDataList, ControlContext controlContext) {
        if (EmptyUtil.isEmpty(sourceReportDataList)) {
            throw new KDBizException("sourceReportDataList is empty");
        }
        this.sourceReportDataList = sourceReportDataList;
        this.sourceReportDataIds = sourceReportDataList.stream().map(ReportData::getId).collect(Collectors.toSet());
        this.reportRepository = new ReportRepository();
        this.controlContext = controlContext;
        this.dimensionRepository = new DimensionRepository();
        this.dimensionCombinationQueryService = new DimensionCombinationQueryServiceImpl();
        this.reportDataGroupByReport = sourceReportDataList.stream().collect(Collectors.groupingBy(ReportData::getReportId));
        this.relateReportDataList = new ArrayList<ReportData>(16);
        this.treeNodeScopeService = ReportCalculateServiceFactory.getTreeNodeScopeService();
        List<Report> reports = this.loadReport();
        this.init(reports);
    }

    private List<Report> loadReport() {
        logger.info("sourceIds:{}", this.sourceReportDataIds);
        Set<Long> reportIds = this.reportDataGroupByReport.keySet();
        List<Report> reports = this.reportRepository.loadSimpleReport(reportIds, r -> {
            r.setNeedTemplate(true);
            r.setNeedReportPeriodType(true);
            r.setNeedPeriodMember(true);
            r.setNeedCompanyMember(true);
        });
        return reports;
    }

    private void init(List<Report> reports) {
        this.reportMap = reports.stream().collect(Collectors.toMap(Report::getId, Function.identity(), (a, b) -> a));
        if (Objects.isNull(this.controlContext)) {
            this.controlContext = this.createControlContext();
        }
        HashMap<Long, Set<Long>> systemWaitSearchDimMap = new HashMap<Long, Set<Long>>(reports.size());
        HashMap<Long, Set<EvalDimensionCombination>> reportDimensionCombinationMap = new HashMap<Long, Set<EvalDimensionCombination>>(reports.size());
        for (Report report : reports) {
            Long reportId;
            List<ReportData> reportDataList;
            FundPlanSystem system = this.controlContext.getSystem(report.getSystemId());
            ReportTemplate template = report.getTemplate();
            if (template.getTemplateType() == TemplateType.DETAIL || EmptyUtil.isEmpty(reportDataList = this.reportDataGroupByReport.getOrDefault(reportId = report.getId(), Collections.emptyList()))) continue;
            this.processCurrencyMemberScopeIfNeed(report);
            List<DimensionInfoBean> sourceDimensionInfo = reportDataList.stream().map(item -> DimensionInfoHelper.getDimensionInfoBean(item, report.getTemplate())).collect(Collectors.toList());
            Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
            List<Long> subjectIds = sourceDimensionInfo.stream().map(dimensionInfoBean -> dimensionInfoBean.getMemberByDimensionId(subjectDim.getId())).map(item -> Long.parseLong(item.toString())).distinct().collect(Collectors.toList());
            SubjectFindReportTreeNodeFormulaManager subjectManager = new SubjectFindReportTreeNodeFormulaManager(report, system);
            List<Long> effectSubjectIds = subjectManager.findEffectData(subjectIds);
            Set waitSearchDimSet = systemWaitSearchDimMap.computeIfAbsent(system.getId(), k -> new HashSet(16));
            waitSearchDimSet.addAll(sourceDimensionInfo.stream().map(DimensionInfoBean::getDimensionIdList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet()));
            ReportDataScopePeriodType reportDataScopePeriodType = this.checkReportDataPeriodScopeType(system, report, reportDataList);
            Set evalDimensionCombinationSet = reportDimensionCombinationMap.computeIfAbsent(reportId, k -> new HashSet(128));
            List<DimensionInfoBean> dimensionInfoBeanList = this.buildDimensionInfoBeansBySubjectDAG(report, sourceDimensionInfo, effectSubjectIds, reportDataScopePeriodType);
            this.fillDimensionValueInfo(dimensionInfoBeanList, evalDimensionCombinationSet, system);
        }
        this.queryRelationReportData(reportDimensionCombinationMap, systemWaitSearchDimMap);
    }

    private ReportDataScopePeriodType checkReportDataPeriodScopeType(FundPlanSystem system, Report report, List<ReportData> reportDataList) {
        Set periodSet = reportDataList.stream().map(i -> i.getDimValByDimType(DimensionType.PERIOD)).collect(Collectors.toSet());
        Dimension periodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
        List allDimMemberList = periodDim.getAllDimMemberList(PeriodMember.class);
        List filterPeriodList = allDimMemberList.stream().filter(i -> periodSet.contains(i.getId())).collect(Collectors.toList());
        boolean isRoll = report.getPeriodMemberList().size() > 1;
        ReportDataScopePeriodType result = ReportDataScopePeriodType.LARGE_PERIOD;
        if (EmptyUtil.isEmpty((Object)report.getReportPeriodType().getDetailPeriodType())) {
            if (this.calculateRollData.booleanValue() && isRoll) {
                return ReportDataScopePeriodType.LARGE_PERIOD_AND_ROLL_LARGE_PERIOD;
            }
            return result;
        }
        boolean noneContainDetail = filterPeriodList.stream().noneMatch(i -> EmptyUtil.isNoEmpty((Object)i.getChildren()));
        if (noneContainDetail) {
            boolean isSubPeriod = filterPeriodList.stream().anyMatch(i -> EmptyUtil.isNoEmpty((Long)i.getParentId()) || EmptyUtil.isNoEmpty((Object)i.getParent()));
            if (isSubPeriod) {
                result = ReportDataScopePeriodType.DETAIL_PERIOD;
            }
        } else {
            result = ReportDataScopePeriodType.LARGE_AND_DETAIL_PERIOD;
        }
        if (!isRoll) {
            return result;
        }
        if (this.calculateRollData.booleanValue()) {
            if (!report.isRollContainsDetail()) {
                switch (result) {
                    case DETAIL_PERIOD: 
                    case LARGE_AND_DETAIL_PERIOD: {
                        result = ReportDataScopePeriodType.LARGE_DETAIL_AND_ROLL_LARGE_PERIOD;
                        break;
                    }
                }
                return result;
            }
            switch (result) {
                case DETAIL_PERIOD: {
                    result = ReportDataScopePeriodType.DETAIL_AND_ROLL_DETAIL_PERIOD;
                    break;
                }
                case LARGE_AND_DETAIL_PERIOD: {
                    result = ReportDataScopePeriodType.LARGE_DETAIL_AND_ROLL_LARGE_DETAIL_PERIOD;
                    break;
                }
            }
        }
        return result;
    }

    private List<DimensionInfoBean> buildDimensionInfoBeansBySubjectDAG(Report report, List<DimensionInfoBean> sourceDimensionInfo, List<Long> effectSubjectIds, ReportDataScopePeriodType reportDataScopePeriodType) {
        ReportTemplate template = report.getTemplate();
        FundPlanSystem system = this.controlContext.getSystem(report.getSystemId());
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        Dimension periodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
        List memberList = subjectDim.getAllDimMemberList();
        Map<Long, Long> beginEndPeriodMap = memberList.stream().map(AccountMember.class::cast).filter(accountMember -> Objects.nonNull(accountMember.getPeriodDirection()) && Objects.nonNull(accountMember.getAssociateAccount())).collect(Collectors.toMap(accountMember -> accountMember.getAssociateAccount().getId(), DimMember::getId, (k1, k2) -> k1));
        ArrayList reportPeriodScope = new ArrayList(1);
        switch (reportDataScopePeriodType) {
            case LARGE_PERIOD: {
                reportPeriodScope = Collections.singletonList(report.getCurrentReportPeriod());
                break;
            }
            case LARGE_PERIOD_AND_ROLL_LARGE_PERIOD: {
                reportPeriodScope = report.getPeriodMemberList();
                break;
            }
            case DETAIL_PERIOD: {
                reportPeriodScope = report.getCurrentReportPeriodDetail();
                break;
            }
            case LARGE_AND_DETAIL_PERIOD: {
                ArrayList periodMembers = Lists.newArrayList((Object[])new PeriodMember[]{report.getCurrentReportPeriod()});
                periodMembers.addAll(report.getCurrentReportPeriodDetail());
                reportPeriodScope = periodMembers;
                break;
            }
            case DETAIL_AND_ROLL_DETAIL_PERIOD: {
                reportPeriodScope = ReportHelper.getReportPeriodAndRollPeriod((Report)report);
                break;
            }
            case LARGE_DETAIL_AND_ROLL_LARGE_PERIOD: 
            case LARGE_DETAIL_AND_ROLL_LARGE_DETAIL_PERIOD: {
                reportPeriodScope = ReportHelper.getAllPeriodMember((Report)report);
                break;
            }
        }
        List sortedPeriodList = reportPeriodScope.stream().sorted(Comparator.comparing(PeriodMember::getStartDate).reversed()).collect(Collectors.toList());
        Map<Integer, List<PeriodMember>> levelMap = sortedPeriodList.stream().collect(Collectors.groupingBy(DimMember::getLevel));
        HashMap<Long, Long> nextPeriodMap = new HashMap<Long, Long>(levelMap.size());
        for (Map.Entry<Integer, List<PeriodMember>> period : levelMap.entrySet()) {
            List<PeriodMember> sameLevelSortedPeriodList = period.getValue();
            Map<Long, Long> sameLevelPreviousPeriodMap = IntStream.range(0, sameLevelSortedPeriodList.size()).boxed().collect(Collectors.toMap(i -> ((PeriodMember)sameLevelSortedPeriodList.get((int)i)).getId(), i -> i > 0 ? ((PeriodMember)sameLevelSortedPeriodList.get(i - 1)).getId() : 0L));
            if (!MapUtils.isNotEmpty(sameLevelPreviousPeriodMap)) continue;
            nextPeriodMap.putAll(sameLevelPreviousPeriodMap);
        }
        List<TemplateAccountSetting> accountSettings = template.getAccountSettings();
        Set beginMemberIds = accountSettings.stream().filter(Objects::nonNull).filter(item -> beginEndPeriodMap.containsKey(item.getAccountMemId())).filter(item -> item.getInputType() == ReportInputType.MANUAL_INPUT).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toSet());
        ArrayList<DimensionInfoBean> beginEndInfoBean = new ArrayList<DimensionInfoBean>(beginMemberIds.size());
        ArrayList<DimensionInfoBean> dimensionInfoBeans = new ArrayList<DimensionInfoBean>(sourceDimensionInfo.size() * effectSubjectIds.size());
        for (DimensionInfoBean dimInfoBean : sourceDimensionInfo) {
            for (Long effectSubjectId : effectSubjectIds) {
                DimensionInfoBean currentBean = dimInfoBean.copy();
                currentBean.replaceValueIfContains(subjectDim.getId(), (Object)effectSubjectId);
                dimensionInfoBeans.add(currentBean);
                if (!beginMemberIds.contains(effectSubjectId)) continue;
                beginEndInfoBean.add(currentBean);
            }
        }
        if (CollectionUtils.isEmpty(beginEndInfoBean)) {
            return dimensionInfoBeans;
        }
        List<DimensionInfoBean> allFormulaBean = this.buildDimensionBeanIfHadBeginEndSubject(subjectDim, periodDim, beginEndPeriodMap, nextPeriodMap, beginEndInfoBean, dimensionInfoBeans);
        return allFormulaBean;
    }

    private List<DimensionInfoBean> buildDimensionBeanIfHadBeginEndSubject(Dimension subjectDim, Dimension periodDim, Map<Long, Long> beginEndPeriodMap, Map<Long, Long> nextPeriodMap, List<DimensionInfoBean> beginEndInfoBean, List<DimensionInfoBean> dimensionInfoBeans) {
        int periodSize = nextPeriodMap.size();
        int initSize = (dimensionInfoBeans.size() + beginEndInfoBean.size()) * periodSize;
        ArrayList<DimensionInfoBean> allFormulaBean = new ArrayList<DimensionInfoBean>(initSize);
        for (DimensionInfoBean formulaDimBean : dimensionInfoBeans) {
            Long nextPeriodId;
            Object periodMemId = formulaDimBean.getMemberByDimensionId(periodDim.getId());
            if (Objects.isNull(periodMemId)) continue;
            Long periodId = (Long)periodMemId;
            while (nextPeriodMap.containsKey(periodId) && !Objects.isNull(nextPeriodId = nextPeriodMap.get(periodId))) {
                DimensionInfoBean nextPeriodBean = formulaDimBean.copy();
                nextPeriodBean.replaceValueIfContains(periodDim.getId(), (Object)nextPeriodId);
                allFormulaBean.add(nextPeriodBean);
                periodId = nextPeriodId;
            }
        }
        allFormulaBean.addAll(dimensionInfoBeans);
        for (DimensionInfoBean dimensionInfoBean : beginEndInfoBean) {
            Long nextPeriodId;
            Object subjectMemId = dimensionInfoBean.getMemberByDimensionId(subjectDim.getId());
            Object periodMemId = dimensionInfoBean.getMemberByDimensionId(periodDim.getId());
            if (Objects.isNull(periodMemId)) continue;
            Long periodId = (Long)periodMemId;
            while (nextPeriodMap.containsKey(periodId) && !Objects.isNull(nextPeriodId = nextPeriodMap.get(periodId))) {
                DimensionInfoBean startPeriodDimensionBean = dimensionInfoBean.copy();
                startPeriodDimensionBean.replaceValueIfContains(periodDim.getId(), (Object)nextPeriodId);
                allFormulaBean.add(startPeriodDimensionBean);
                DimensionInfoBean endPeriodDimensionBean = dimensionInfoBean.copy();
                endPeriodDimensionBean.replaceValueIfContains(periodDim.getId(), (Object)nextPeriodId);
                endPeriodDimensionBean.replaceValueIfContains(subjectDim.getId(), (Object)beginEndPeriodMap.get((Long)subjectMemId));
                allFormulaBean.add(endPeriodDimensionBean);
                periodId = nextPeriodId;
            }
        }
        return allFormulaBean;
    }

    private Set<EvalDimensionCombination> getFillEmptyDimValueIfNeed(Map<Long, Set<EvalDimensionCombination>> reportDimensionCombinationMap, Map<Long, Set<Long>> systemWaitSearchDimMap) {
        HashSet<EvalDimensionCombination> fillEmptyDimValue = new HashSet<EvalDimensionCombination>(64);
        HashMap<Long, Map> systemDimensionMap = new HashMap<Long, Map>(32);
        for (Map.Entry<Long, Set<EvalDimensionCombination>> entry : reportDimensionCombinationMap.entrySet()) {
            EvalDimensionCombination evalDimensionCombination;
            List evalDimensionValList;
            Long reportId = entry.getKey();
            Report report = this.reportMap.get(reportId);
            FundPlanSystem system = this.controlContext.getSystem(report.getSystemId());
            Set waitSearchDimSet = systemWaitSearchDimMap.getOrDefault(system.getId(), Collections.emptySet());
            Map dimensionMap = systemDimensionMap.computeIfAbsent(system.getId(), k -> system.getMainDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity(), (a, b) -> a)));
            Set<EvalDimensionCombination> evalDimensionCombinations = entry.getValue();
            Iterator<EvalDimensionCombination> iterator = evalDimensionCombinations.iterator();
            while (iterator.hasNext() && (evalDimensionValList = (evalDimensionCombination = iterator.next()).getEvalDimensionValList()).size() != waitSearchDimSet.size()) {
                EvalDimensionCombination copy = evalDimensionCombination.copy(null);
                Set dimensionIds = evalDimensionValList.stream().map(EvalDimensionVal::getDimensionId).collect(Collectors.toSet());
                waitSearchDimSet.stream().filter(id -> !dimensionIds.contains(id)).map(id -> new EvalDimensionVal(id, ((Dimension)dimensionMap.get(id)).getDimType(), (Object)0L)).forEach(arg_0 -> ((EvalDimensionCombination)copy).addEvalDimensionVal(arg_0));
                copy.freeze();
                fillEmptyDimValue.add(copy);
            }
        }
        return fillEmptyDimValue;
    }

    private void processCurrencyMemberScopeIfNeed(Report report) {
        ReportTemplate template = report.getTemplate();
        if (template.getTemplateUse() != TemplateUseType.SUMMARY) {
            return;
        }
        Optional<TemplateDim> first = template.getAllTemplateDim().stream().filter(td -> td.getDimType() == DimensionType.CURRENCY).findFirst();
        if (!first.isPresent()) {
            return;
        }
        TemplateDim currencyTemplateDim = first.get();
        OrgMember reportOrg = (OrgMember)report.getCompanyMemberList().get(0);
        Long sumOrgId = reportOrg.getId();
        ISumPlanRepository sumPlanRepository = (ISumPlanRepository)FpmServiceFactory.getBizService(ISumPlanRepository.class);
        List sumPlanParamConfigList = sumPlanRepository.loadSumConfigBySystem(report.getSystemId(), Collections.singletonList(report.getReportPeriodType().getReportPeriodId()), false);
        if (EmptyUtil.isEmpty((Collection)sumPlanParamConfigList)) {
            return;
        }
        logger.info("\u6c47\u603b\u7f16\u5236\u8868:{},\u6c47\u603b\u53c2\u6570\uff1a{}", (Object)report.getId(), (Object)((SumPlanParamConfig)sumPlanParamConfigList.get(0)).getNumber());
        Set currencyIds = sumPlanParamConfigList.stream().map(SumPlanParamConfig::getConfigInfoList).filter(Objects::nonNull).flatMap(Collection::stream).filter(info -> Objects.equals(sumOrgId, info.getOrgMemberId())).map(SumPlanParamConfigInfo::getCurrencyMapCase).filter(Objects::nonNull).map(SumPlanParamConfigInfo.CurrencyMapCase::getCurrencyMapCaseInfoList).filter(Objects::nonNull).flatMap(Collection::stream).map(SumPlanParamConfigInfo.CurrencyMapCaseInfo::getSubOrgReportCurrencyId).filter(Objects::nonNull).flatMap(Collection::stream).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(currencyIds)) {
            return;
        }
        logger.info("\u5e01\u79cd\u6298\u7b97\u6620\u5c04\u65b9\u6848\u7684\u5e01\u79cd\uff1a{}", currencyIds);
        List memberScope = currencyTemplateDim.getMemberScope();
        currencyIds.addAll(memberScope);
        currencyTemplateDim.setMemberScope(new ArrayList(currencyIds));
    }

    private void queryRelationReportData(Map<Long, Set<EvalDimensionCombination>> reportDimensionCombinationMap, Map<Long, Set<Long>> systemWaitSearchDimMap) {
        Set<EvalDimensionCombination> evalDimensionCombinations = this.getFillEmptyDimValueIfNeed(reportDimensionCombinationMap, systemWaitSearchDimMap);
        Set combinations = reportDimensionCombinationMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        combinations.addAll(evalDimensionCombinations);
        logger.info("\u51c6\u5907\u6309\u7ef4\u5ea6\u7ec4\u5408\u67e5\u8be2\u6240\u6709\u5173\u8054\u7684\u516c\u5f0f\u9879\u548c\u6c47\u603b\u9879\u6570\u636e");
        List findRelationReportDataList = this.dimensionCombinationQueryService.queryReportDataByDimensionCombination(combinations, t -> t.setReportIdS(new ArrayList(reportDimensionCombinationMap.keySet())));
        if (EmptyUtil.isEmpty((Collection)findRelationReportDataList)) {
            this.relateReportDataList = Lists.newArrayListWithCapacity((int)0);
            return;
        }
        Map<Long, Set> reportDimMap = reportDimensionCombinationMap.entrySet().stream().filter(entry -> EmptyUtil.isNoEmpty(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((EvalDimensionCombination)((Set)entry.getValue()).iterator().next()).getEvalDimensionValList().stream().map(EvalDimensionVal::getDimensionId).collect(Collectors.toSet())));
        Predicate<ReportData> predicate = rd -> {
            Long reportId = rd.getReportId();
            Set evalDimensionCombinationSet = (Set)reportDimensionCombinationMap.get(reportId);
            if (EmptyUtil.isEmpty((Collection)evalDimensionCombinationSet)) {
                return false;
            }
            if (this.sourceReportDataIds.contains(rd.getId())) {
                return false;
            }
            EvalDimensionCombination combinationByReportData = EvalDimensionCombination.getEvalDimensionCombinationByReportData((ReportData)rd, t -> reportDimMap.getOrDefault(reportId, Collections.emptySet()).contains(t.getDimensionId()));
            return evalDimensionCombinationSet.contains(combinationByReportData);
        };
        this.relateReportDataList = findRelationReportDataList.stream().filter(predicate).collect(Collectors.toList());
        this.relateReportDataList.addAll(this.sourceReportDataList);
    }

    private void fillDimensionValueInfo(List<DimensionInfoBean> dimensionInfoBeanList, Set<EvalDimensionCombination> combinations, FundPlanSystem system) {
        List mainDimList = system.getMainDimList();
        Map dimensionMap = mainDimList.stream().collect(Collectors.toMap(Dimension::getId, Function.identity()));
        for (DimensionInfoBean dimensionInfoBean : dimensionInfoBeanList) {
            if (Objects.isNull(dimensionInfoBean)) continue;
            EvalDimensionCombination combination = new EvalDimensionCombination(system.getId());
            List dimensionIdList = dimensionInfoBean.getDimensionIdList();
            List memberIdList = dimensionInfoBean.getMemberIdList();
            if (EmptyUtil.isEmpty((Collection)dimensionIdList)) continue;
            for (int i = 0; i < dimensionIdList.size(); ++i) {
                Dimension dimension;
                Long dimensionId = (Long)dimensionIdList.get(i);
                if (!dimensionMap.containsKey(dimensionId) || Objects.isNull(dimension = (Dimension)dimensionMap.get(dimensionId))) continue;
                combination.addEvalDimensionVal(new EvalDimensionVal(dimensionId, dimension.getDimType(), memberIdList.get(i)));
            }
            combinations.add(combination);
        }
    }

    private TreeNode getTreeNode(ReportData reportData) {
        Long reportId = reportData.getReportId();
        Report report = this.reportMap.get(reportId);
        DimensionIndexTree indexTree = report.getIndexTree(this.controlContext.getSystem(report.getSystemId()));
        DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(reportData, report.getTemplate());
        return indexTree.find(dimensionInfoBean);
    }

    private ControlContext createControlContext() {
        this.controlContext = new ControlContext();
        List systemIdList = this.reportMap.values().stream().map(Report::getSystemId).distinct().collect(Collectors.toList());
        for (Long systemId : systemIdList) {
            FundPlanSystem system = this.controlContext.getSystem(systemId);
            if (Objects.nonNull(system)) continue;
            this.controlContext.addSystem(this.dimensionRepository.loadSystem(systemId));
        }
        return this.controlContext;
    }

    public Set<Long> getAllReportDataIds() {
        HashSet<Long> reportDataIds = new HashSet<Long>(this.sourceReportDataIds);
        reportDataIds.addAll(this.relateReportDataList.stream().map(ReportData::getId).collect(Collectors.toSet()));
        return reportDataIds;
    }

    public List<ReportData> reCalculateRelateDataByDAG() {
        ArrayList<ReportData> reportDataList = new ArrayList<ReportData>(this.sourceReportDataList);
        reportDataList.addAll(this.relateReportDataList.stream().filter(rd -> !this.sourceReportDataIds.contains(rd.getId())).collect(Collectors.toList()));
        return this.reCalculateRelateDataByDAGAndCompletionIndex(reportDataList);
    }

    public List<ReportData> reCalculateRelateDataByDAG(List<ReportData> reportDataList) {
        Map<Long, List<ReportData>> reportDataMap = reportDataList.stream().collect(Collectors.groupingBy(ReportData::getReportId));
        Set reportDataIds = this.relateReportDataList.stream().map(ReportData::getId).collect(Collectors.toSet());
        ArrayList<ReportData> updatedRelateReportDataList = new ArrayList<ReportData>(this.relateReportDataList.size());
        for (Map.Entry<Long, List<ReportData>> entry : reportDataMap.entrySet()) {
            Long reportId = entry.getKey();
            List<ReportData> dataList = entry.getValue();
            Report report = this.reportMap.get(reportId);
            if (report.getTemplate().getTemplateType() == TemplateType.DETAIL) continue;
            report.getIndexTree(this.controlContext.getSystem(report.getSystemId()));
            report.clearTreeNodeData(dataList);
            report.mountReportData(dataList);
            List treeNodeList = dataList.stream().filter(rd -> this.sourceReportDataIds.contains(rd.getId())).map(this::getTreeNode).collect(Collectors.toList());
            ReportTreeNodeFormulaManager formulaManager = report.getFormulaManager(this.controlContext.getSystem(report.getSystemId()));
            List treeNodes = formulaManager.updateData(treeNodeList);
            Set updatedReportDataIds = treeNodes.stream().map(TreeNode::getDataList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(ReportData.class::cast).map(ReportData::getId).collect(Collectors.toSet());
            updatedRelateReportDataList.addAll(dataList.stream().filter(rd -> updatedReportDataIds.contains(rd.getId())).filter(rd -> reportDataIds.contains(rd.getId())).collect(Collectors.toList()));
        }
        return updatedRelateReportDataList;
    }

    public List<ReportData> reCalculateRelateDataByDAGAndCompletionIndex(List<ReportData> reportDataList) {
        Map<Long, List<ReportData>> reportDataMap = reportDataList.stream().collect(Collectors.groupingBy(ReportData::getReportId));
        Map<Long, List<ReportData>> relateReportDataMap = reportDataList.stream().collect(Collectors.groupingBy(ReportData::getReportId));
        Set reportDataIds = reportDataList.stream().map(ReportData::getId).collect(Collectors.toSet());
        ArrayList<ReportData> updatedRelateReportDataList = new ArrayList<ReportData>(reportDataList.size());
        for (Map.Entry<Long, List<ReportData>> entry : reportDataMap.entrySet()) {
            Long reportId = entry.getKey();
            List<ReportData> dataList = entry.getValue();
            Report report = this.reportMap.get(reportId);
            if (report.getTemplate().getTemplateType() == TemplateType.DETAIL) continue;
            List<ReportData> relateReportDataList = relateReportDataMap.get(reportId);
            FundPlanSystem system = this.controlContext.getSystem(report.getSystemId());
            IndexTreeGenerateStrategy strategy = IndexTreeGenerateStrategyFactory.createCompleteSubjectStrategy((ReportDataSource)report, (FundPlanSystem)system);
            DimensionIndexTreeGenerator generator = new DimensionIndexTreeGenerator(strategy);
            DimensionIndexTree indexTree = generator.build();
            ReportHelper.mountReportData((DimensionIndexTree)indexTree, relateReportDataList);
            List filterData = dataList.stream().filter(rd -> this.sourceReportDataIds.contains(rd.getId())).collect(Collectors.toList());
            ReportCalculateDTO reportCalculateDTO = new ReportCalculateDTO();
            reportCalculateDTO.setReport((ReportDataSource)report);
            reportCalculateDTO.setSystem(system);
            reportCalculateDTO.setScopeData(filterData);
            reportCalculateDTO.setCustomIndexTree(indexTree);
            List updateResult = this.treeNodeScopeService.calculateReport(reportCalculateDTO);
            Set updatedReportDataIds = updateResult.stream().map(ReportData::getId).collect(Collectors.toSet());
            updatedRelateReportDataList.addAll(dataList.stream().filter(rd -> updatedReportDataIds.contains(rd.getId())).filter(rd -> reportDataIds.contains(rd.getId())).collect(Collectors.toList()));
        }
        return updatedRelateReportDataList;
    }

    public List<ReportData> getRelateReportDataList() {
        return this.relateReportDataList.stream().filter(rd -> !this.sourceReportDataIds.contains(rd.getId())).collect(Collectors.toList());
    }

    public List<ReportData> getRelateReportDataListBySource(List<ReportData> reportDataList) {
        if (!this.checkSourceReportDataList(reportDataList)) {
            return Collections.emptyList();
        }
        Long reportId = reportDataList.get(0).getReportId();
        Report report = this.reportMap.get(reportId);
        Set<Long> subjectIds = reportDataList.stream().map(item -> item.getDimValByDimType(DimensionType.SUBJECTS)).filter(Objects::nonNull).map(item -> (Long)item).collect(Collectors.toSet());
        FundPlanSystem system = this.controlContext.getSystem(report.getSystemId());
        SubjectFindReportTreeNodeFormulaManager subjectManager = new SubjectFindReportTreeNodeFormulaManager(report, system);
        List<Long> effectSubjects = subjectManager.findEffectData(subjectIds);
        return this.findRelateReportData(effectSubjects, reportDataList, report);
    }

    public List<ReportData> getRelateReportDataListBySourceIfExclude(List<ReportData> reportDataList, List<Long> excludeSubjectIdList) {
        if (!this.checkSourceReportDataList(reportDataList)) {
            return new ArrayList<ReportData>(1);
        }
        Long reportId = reportDataList.get(0).getReportId();
        Report report = this.reportMap.get(reportId);
        Set<Long> subjectIds = reportDataList.stream().map(item -> item.getDimValByDimType(DimensionType.SUBJECTS)).filter(Objects::nonNull).map(item -> (Long)item).collect(Collectors.toSet());
        FundPlanSystem system = this.controlContext.getSystem(report.getSystemId());
        SubjectFindReportTreeNodeFormulaManager subjectManager = new SubjectFindReportTreeNodeFormulaManager(report, system);
        List<Long> effectSubjects = subjectManager.findEffectData(subjectIds);
        effectSubjects.removeIf(excludeSubjectIdList::contains);
        if (EmptyUtil.isEmpty(effectSubjects)) {
            return new ArrayList<ReportData>(1);
        }
        return this.findRelateReportData(effectSubjects, reportDataList, report);
    }

    private boolean checkSourceReportDataList(List<ReportData> reportDataList) {
        if (EmptyUtil.isEmpty(reportDataList)) {
            return false;
        }
        Map<Long, List<ReportData>> reportReportDataMap = reportDataList.stream().collect(Collectors.groupingBy(ReportData::getReportId));
        FpmAssertUtil.isTrue((reportReportDataMap.size() == 1 ? 1 : 0) != 0, (String)"input ReportDataList should in the same report");
        Long reportId = reportDataList.get(0).getReportId();
        Report report = this.reportMap.get(reportId);
        FpmAssertUtil.isNotNull((Object)report, (String)String.format("input reportDataList of Report:%s is not init", reportId));
        return report.getTemplate().getTemplateType() != TemplateType.DETAIL;
    }

    private List<ReportData> findRelateReportData(List<Long> effectSubjects, List<ReportData> reportDataList, Report report) {
        Long reportId = report.getId();
        FundPlanSystem system = this.controlContext.getSystem(report.getSystemId());
        Set reportDatIds = reportDataList.stream().map(ReportData::getId).collect(Collectors.toSet());
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        IndexTreeGenerateStrategy strategy = IndexTreeGenerateStrategyFactory.createReportDataStrategy((ReportDataSource)report, (FundPlanSystem)system);
        DimensionIndexTreeGenerator generator = new DimensionIndexTreeGenerator(strategy);
        DimensionIndexTree indexTree = generator.build();
        List<ReportData> currentData = this.relateReportDataList.stream().filter(rd -> Objects.equals(rd.getReportId(), reportId)).collect(Collectors.toList());
        this.mountData(indexTree, currentData);
        ArrayList<ReportData> relateReportDataListFormSource = new ArrayList<ReportData>(reportDataList.size());
        for (TreeNode treeNode : indexTree.getLeafList()) {
            List dataList;
            DimensionInfoBean dimInfoBean = treeNode.getDimInfoBean();
            Object memberByDimensionId = dimInfoBean.getMemberByDimensionId(subjectDim.getId());
            if (Objects.isNull(memberByDimensionId) || !effectSubjects.contains((Long)memberByDimensionId) || EmptyUtil.isEmpty((Collection)(dataList = treeNode.getDataList()))) continue;
            List reportData = dataList.stream().map(ReportData.class::cast).filter(rd -> !reportDatIds.contains(rd.getId())).filter(item -> item.getReportId().equals(reportId)).collect(Collectors.toList());
            relateReportDataListFormSource.addAll(reportData);
        }
        return relateReportDataListFormSource;
    }

    public List<ReportData> getRelateReportDataListBySourceCanDiff(List<ReportData> reportDataList) {
        Map<Long, List<ReportData>> reportDataMap = reportDataList.stream().collect(Collectors.groupingBy(ReportData::getReportId));
        ArrayList<ReportData> relateReportDataList = new ArrayList<ReportData>(128);
        for (Map.Entry<Long, List<ReportData>> entry : reportDataMap.entrySet()) {
            List<ReportData> sourceReportDateList = entry.getValue();
            relateReportDataList.addAll(this.getRelateReportDataListBySource(sourceReportDateList));
        }
        return new ArrayList<ReportData>(relateReportDataList.stream().collect(Collectors.toMap(ReportData::getId, Function.identity(), (a, b) -> a)).values());
    }

    public List<Report> getRelateReports(List<ReportData> reportDataList) {
        List<ReportData> relateReportData = this.getRelateReportDataListBySourceCanDiff(reportDataList);
        reportDataList.addAll(relateReportData);
        Map<Long, List<ReportData>> relateReportDataMap = reportDataList.stream().collect(Collectors.groupingBy(ReportData::getReportId));
        ArrayList<Report> result = new ArrayList<Report>(this.reportMap.size());
        this.reportMap.forEach((reportId, report) -> {
            report.setReportDataList((List)relateReportDataMap.getOrDefault(reportId, Lists.newArrayList()));
            result.add((Report)report);
        });
        return result;
    }

    public List<Report> getRelateReports() {
        return new ArrayList<Report>(this.reportMap.values());
    }

    public List<ReportData> getAllReportData() {
        ArrayList<ReportData> reportData = new ArrayList<ReportData>(this.relateReportDataList);
        reportData.addAll(this.sourceReportDataList);
        return CommonUtils.getDistinctList(reportData, ReportData::getId);
    }

    public List<ReportData> getSourceReportData() {
        return Collections.unmodifiableList(this.sourceReportDataList);
    }

    public Set<Long> getSourceReportDataIds() {
        return Collections.unmodifiableSet(this.sourceReportDataIds);
    }

    private void mountData(DimensionIndexTree indexTree, List<ReportData> reportDataList) {
        for (ReportData reportData : reportDataList) {
            ArrayList<Long> dimIdList = new ArrayList<Long>(reportData.getDimList().size());
            ArrayList dimMemIdList = new ArrayList(reportData.getDimList().size());
            List prepareDatas = reportData.getDimValList();
            for (int inx = 0; inx < reportData.getDimList().size(); ++inx) {
                TemplateDim templateDim = (TemplateDim)reportData.getDimList().get(inx);
                if (templateDim.getDimType() == DimensionType.DETAILDIM) continue;
                dimIdList.add(templateDim.getDimensionId());
                dimMemIdList.add(prepareDatas.get(inx));
            }
            DimensionInfoBean dimensionInfoBean = new DimensionInfoBean();
            dimensionInfoBean.setDimensionIdList(dimIdList);
            dimensionInfoBean.setMemberIdList(dimMemIdList);
            TreeNode node = indexTree.find(dimensionInfoBean);
            if (node == null) continue;
            node.addData((Object)reportData);
        }
    }

    public ControlContext getControlContext() {
        return this.controlContext;
    }

    public void setCalculateRollData(Boolean calculateRollData) {
        this.calculateRollData = calculateRollData;
    }
}

