/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.service.IReportBizService;
import kd.tmc.fpm.business.mvc.service.impl.ReportBizService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;

public class ReportPlanSmartGelValService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ReportPlanSmartGelValService.class);
    private IDimensionRepository iDimensionRepository = (IDimensionRepository)FpmServiceFactory.getBizService(IDimensionRepository.class);
    private IControlRepository iControlRepository = (IControlRepository)FpmServiceFactory.getBizService(IControlRepository.class);
    private IReportRepository iReportRepository = (IReportRepository)FpmServiceFactory.getBizService(IReportRepository.class);
    private IReportBizService iReportBizService = new ReportBizService();
    private static final int SYSTEM_BATCH_SIZE = 2;

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bodysys.id");
        selector.add("billno");
        selector.add("id");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        Map systemReportGroupMap = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> dy.getLong("bodysys.id"), HashMap::new, Collectors.toList()));
        ArrayList systemIds = new ArrayList(systemReportGroupMap.keySet());
        List systemIdGroup = Lists.partition(systemIds, (int)2);
        for (List currDealSystemIds : systemIdGroup) {
            HashSet<Long> currDealSystemIdSet = new HashSet<Long>(currDealSystemIds);
            List billMatchRules = this.iControlRepository.loadPlanMatchRules("fpm_inoutcollect", (Collection)currDealSystemIds);
            Map systemRuleMap = billMatchRules.stream().collect(Collectors.toMap(BillMatchRule::getSystemId, Function.identity(), (a, b) -> b));
            List<FundPlanSystem> fundPlanSystems = this.iDimensionRepository.loadSystems(currDealSystemIdSet);
            for (FundPlanSystem fundPlanSystem : fundPlanSystems) {
                this.systemSmartGetVal(fundPlanSystem, (BillMatchRule)systemRuleMap.get(fundPlanSystem.getId()), (List)systemReportGroupMap.get(fundPlanSystem.getId()));
            }
        }
    }

    private void systemSmartGetVal(FundPlanSystem fundPlanSystem, BillMatchRule billMatchRule, List<DynamicObject> reportDyList) {
        if (Objects.isNull(fundPlanSystem) || Objects.isNull(billMatchRule) || EmptyUtil.isEmpty(reportDyList)) {
            return;
        }
        List reportIds = reportDyList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        for (Long reportId : reportIds) {
            Supplier<Report> reportSupplier;
            String dLockName = String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), "listsmartplangetval", reportId);
            FpmOperateResult smartGetValResult = CommonUtils.processInDLock((String)dLockName, () -> this.lambda$systemSmartGetVal$4((Supplier<Report>)(reportSupplier = () -> this.iReportRepository.loadReport(reportId)), billMatchRule, fundPlanSystem));
            if (smartGetValResult.isSuccess()) continue;
            logger.info("list smart plan get val failed, reportId-{}, errMsg-{}", (Object)reportId, (Object)smartGetValResult.getMessageList());
        }
    }

    private /* synthetic */ FpmOperateResult lambda$systemSmartGetVal$4(Supplier reportSupplier, BillMatchRule billMatchRule, FundPlanSystem fundPlanSystem) {
        Report report = (Report)reportSupplier.get();
        ReportTemplate reportTemplate = report.getTemplate();
        List<TemplateDim> templateDimList = reportTemplate.getAllTemplateDim();
        return this.iReportBizService.smartGetVal(billMatchRule, report, fundPlanSystem, templateDimList, true);
    }
}

