/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.taskrecord;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fpm.business.dataproc.exception.UpdateException;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.impl.DataSaveServiceImpl;
import kd.tmc.fpm.business.domain.enums.TaskStatus;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.helper.ExceptionMessageHelper;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskHandleService;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskProcessService;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskProcessServiceLifeCycleListener;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskRecordQueryService;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskSequentFactory;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.TaskHandleServiceImpl;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.TaskRecordQueryServiceImpl;
import kd.tmc.fpm.business.opservice.report.mutex.ILockStrategy;
import kd.tmc.fpm.business.opservice.report.mutex.ILockStrategyFactory;
import kd.tmc.fpm.business.opservice.report.mutex.LockStrategyFactoryFactory;
import kd.tmc.fpm.business.opservice.report.mutex.NoLockStrategy;

public class TaskRecordExecuteService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(TaskRecordExecuteService.class);
    private static final IDataSaveService dataSaveService = new DataSaveServiceImpl();
    private static final TaskRecordQueryService taskRecordQueryService = new TaskRecordQueryServiceImpl();
    private static final TaskHandleService handleService = new TaskHandleServiceImpl();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("tasktype");
        return selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(DynamicObject[] dataEntities) throws KDException {
        List taskRecordIds = Arrays.stream(dataEntities).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        List taskRecordList = taskRecordQueryService.load(taskRecordIds);
        for (TaskRecord taskRecord : taskRecordList) {
            taskRecord.setTaskNum(Integer.valueOf(taskRecord.getTaskNum() + 1));
            try {
                if (this.executeIfNeedLock(taskRecord)) continue;
                TaskProcessService taskProcessService = TaskSequentFactory.getService((String)taskRecord.getTaskType());
                List taskProcessServiceListeners = taskProcessService.getTaskProcessServiceListeners();
                try {
                    taskProcessServiceListeners.forEach(taskProcessServiceLifeCycleListener -> taskProcessServiceLifeCycleListener.initialize(taskRecord));
                    TXHandle ignore = TX.requiresNew();
                    Throwable throwable = null;
                    try {
                        taskProcessService.doProcess(taskRecord);
                        taskRecord.setStatus(TaskStatus.DONE.name());
                        this.updateTaskRecordStatus(Collections.singletonList(taskRecord), TaskStatus.DONE);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ignore == null) continue;
                        if (throwable != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ignore.close();
                    }
                }
                finally {
                    taskProcessServiceListeners.forEach(TaskProcessServiceLifeCycleListener::done);
                }
            }
            catch (Exception e) {
                taskRecord.setStatus(TaskStatus.FAILED.name());
                taskRecord.setErrorMsg(ExceptionMessageHelper.getStackTraceMessage((Throwable)e));
                TXHandle ignore = TX.requiresNew();
                Throwable throwable = null;
                try {
                    handleService.updateTask(taskRecord);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (ignore == null) continue;
                    if (throwable != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    ignore.close();
                }
            }
        }
    }

    private void updateTaskRecordStatus(List<TaskRecord> taskRecords, TaskStatus status) {
        dataSaveService.updateAndCheckResult(() -> "update t_fpm_task_record set fstatus=?,ftasknum=?,fmodifytime=? where fid=?", taskRecords, (t, d) -> {
            d.add(status.name());
            d.add(t.getTaskNum());
            d.add(new Date());
            d.add(t.getId());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeIfNeedLock(TaskRecord taskRecord) {
        block49: {
            ILockStrategyFactory lockStrategyFactory = LockStrategyFactoryFactory.getLockStrategyFactory((TaskRecord)taskRecord);
            ILockStrategy lockStrategy = lockStrategyFactory.getLockStrategy(taskRecord);
            if (lockStrategy instanceof NoLockStrategy) {
                return false;
            }
            try {
                if (lockStrategy.tryLock()) {
                    this.updateTaskRecordRunning(taskRecord);
                    TaskProcessService taskProcessService = TaskSequentFactory.getService((String)taskRecord.getTaskType());
                    List taskProcessServiceLifeCycleListeners = taskProcessService.getTaskProcessServiceListeners();
                    try {
                        taskProcessServiceLifeCycleListeners.forEach(taskProcessServiceLifeCycleListener -> taskProcessServiceLifeCycleListener.initialize(taskRecord));
                        try (TXHandle ignored = TX.requiresNew();){
                            logger.info("\u5f53\u524d\u6b63\u5728\u6267\u884c\u4efb\u52a1ID\uff1a{}, \u4efb\u52a1\u7c7b\u578b:{}", (Object)taskRecord.getId(), (Object)taskRecord.getTaskType());
                            if (!taskRecord.isIgnore()) {
                                taskProcessService.doProcess(taskRecord);
                            }
                            this.updateTaskRecordStatus(Collections.singletonList(taskRecord), TaskStatus.DONE);
                            logger.info("\u5f53\u524d\u4efb\u52a1ID\uff1a{}\uff0c\u5df2\u6267\u884c\u6210\u529f", (Object)taskRecord.getId());
                            break block49;
                        }
                        catch (Exception e) {
                            logger.error("\u5f53\u524d\u4efb\u52a1ID\uff1a{}\uff0c\u6267\u884c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{taskRecord.getId(), e.getMessage(), e});
                            taskRecord.setStatus(TaskStatus.FAILED.name());
                            taskRecord.setErrorMsg(ExceptionMessageHelper.getStackTraceMessage((Throwable)e));
                            try (TXHandle ignored2 = TX.requiresNew();){
                                handleService.updateTask(taskRecord);
                                break block49;
                            }
                        }
                    }
                    finally {
                        taskProcessServiceLifeCycleListeners.forEach(TaskProcessServiceLifeCycleListener::done);
                    }
                }
                taskRecord.setStatus(TaskStatus.FAILED.name());
                taskRecord.setStatus(TaskStatus.FAILED.name());
                String message = ResManager.loadKDString((String)"\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TaskRecordExecuteService_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
                taskRecord.setErrorMsg(message);
                try (TXHandle ignored = TX.requiresNew();){
                    handleService.updateTask(taskRecord);
                }
            }
            catch (UpdateException ue) {
                logger.error(ue.getMessage(), (Throwable)ue);
            }
            finally {
                lockStrategy.unLock();
            }
        }
        return true;
    }

    private void updateTaskRecordRunning(TaskRecord taskRecord) {
        try (TXHandle ignore = TX.requiresNew();){
            String traceId = RequestContext.get().getTraceId();
            dataSaveService.updateAndCheckResult(() -> "update t_fpm_task_record set fstatus=?,factexecutetraceid=?,fexecutetaskid=?,fmodifytime=? where fid=? and fstatus=?", Collections.singletonList(taskRecord), (t, d) -> {
                d.add(TaskStatus.HANDLING.name());
                d.add(traceId);
                d.add(t.getId());
                d.add(new Date());
                d.add(t.getId());
                d.add(t.getStatus());
            });
        }
    }
}

