/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.contract;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.GuaranteeTypeEnum;
import kd.tmc.gm.formplugin.common.AbstractGuaranteeEdit;

public class GuaranteeContractEdit
extends AbstractGuaranteeEdit
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"applybillno"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleApplyBillNo();
    }

    private void handleApplyBillNo() {
        DynamicObject applyBill = (DynamicObject)this.getModel().getValue("applybill");
        if (EmptyUtil.isNoEmpty((DynamicObject)applyBill)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"applybillno", (Object)applyBill.getString("billno"));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"iscrossguarantee", "gadvconap", "gdadvconap"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"iscrossguarantee", "gadvconap", "gdadvconap"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("applybillno".equals(key)) {
            this.getView().invokeOperation("drawapply");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "applybillno": {
                Object applyBillNo = this.getModel().getValue("applybillno");
                this.getView().setEnable(Boolean.valueOf(EmptyUtil.isEmpty((Object)applyBillNo)), new String[]{"iscrossguarantee", "gadvconap"});
                break;
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        this.setEntryGuaranteeOrgId("entry_guaranteeorg", "a_guaranteetype", "a_guaranteeorgtext", "a_guaranteeorg");
        this.setEntryGuaranteeOrgId("entry_guaranteedorg", "b_reguaranteetype", "b_guaranteedorgtext", "b_guaranteedorg");
    }

    private void setEntryGuaranteeOrgId(String entryProp, String type, String orgText, String orgId) {
        DynamicObjectCollection gEntry = this.getModel().getEntryEntity(entryProp);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)gEntry)) {
            return;
        }
        for (DynamicObject row : gEntry) {
            String formId;
            String gType = row.getString(type);
            if (EmptyUtil.isEmpty((String)gType) || EmptyUtil.isEmpty((String)(formId = GuaranteeTypeEnum.getFormId((String)gType)))) continue;
            QFilter qFilter = new QFilter("name", "=", (Object)row.getString(orgText));
            qFilter.and(new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue()));
            List idList = QueryServiceHelper.queryPrimaryKeys((String)formId, (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
            if (EmptyUtil.isEmpty((Collection)idList)) continue;
            row.set(orgId, idList.get(0));
        }
    }
}

