/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.lettercredit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackOperateEnum;
import kd.tmc.lc.business.opservice.helper.LetterCreditOpenHelper;
import kd.tmc.lc.common.helper.LetterCreditHelper;
import kd.tmc.lc.common.property.LetterCreditHistoryProp;

public class LetterCreditSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billno");
        sic.add("creditlimit");
        sic.add("bank");
        sic.add("currency");
        sic.add("credittype");
        sic.add("amount");
        sic.add("org");
        sic.add("amountscaleupper");
        sic.add("creditapplyno");
        sic.add("entrys");
        sic.add(LetterCreditHistoryProp.SOURCEENTRYID);
        sic.add("applyreason");
        sic.add("bizdate");
        sic.add("notarramount");
        sic.add("totalarramount");
        sic.add("issurety");
        sic.add("entry_surety");
        sic.add("isbackcredit");
        sic.add("backcredittype");
        sic.add("entry_backcredit");
        sic.add("entry_backcredit.b_mothercredit");
        sic.add("entry_backcredit.b_childcredit");
        sic.add("creditamount");
        sic.add("sourcebilltype");
        sic.add("srcbillid");
        sic.add("creditno");
        sic.add("benefitertype");
        sic.add("benefiterother");
        sic.add("e_createtime");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject letterCredit : dataEntities) {
            DynamicObject dataBase;
            if (EmptyUtil.isEmpty((Object)letterCredit.get("id"))) {
                Long id = DBServiceHelper.genGlobalLongId();
                letterCredit.set("id", (Object)id);
            }
            BigDecimal totalArrAmount = letterCredit.getBigDecimal("totalarramount");
            BigDecimal amount = LetterCreditHelper.getAmount((DynamicObject)letterCredit);
            DynamicObject currency = letterCredit.getDynamicObject("currency");
            amount = amount.setScale(LetterCreditHelper.getAmtprecision((DynamicObject)currency), RoundingMode.HALF_UP);
            letterCredit.set("notarramount", (Object)amount.subtract(totalArrAmount));
            QFilter filter = new QFilter("id", "=", (Object)letterCredit.getLong("id"));
            DynamicObject oldCreditLimit = dataBase = TmcDataServiceHelper.loadSingle((String)"lc_lettercredit", (String)"billno,creditlimit", (QFilter[])filter.toArray());
            boolean fistSubmit = false;
            if (EmptyUtil.isNoEmpty((DynamicObject)dataBase)) {
                oldCreditLimit = dataBase.getDynamicObject("creditlimit");
            } else {
                fistSubmit = true;
            }
            DynamicObject newCreditLimit = letterCredit.getDynamicObject("creditlimit");
            if (EmptyUtil.isNoEmpty((DynamicObject)oldCreditLimit)) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)letterCredit, null, (boolean)true);
            }
            BigDecimal creditRatio = null;
            QFilter qfilter = new QFilter("billno", "=", (Object)letterCredit.getString("creditapplyno"));
            DynamicObject applyBill = TmcDataServiceHelper.loadSingle((String)"lc_bizapply", (String)"billno,currency,creditlimit,amount,amountscaleupper,creditgratio", (QFilter[])qfilter.toArray());
            if (fistSubmit && EmptyUtil.isNoEmpty((DynamicObject)applyBill) && EmptyUtil.isNoEmpty((DynamicObject)applyBill.getDynamicObject("creditlimit"))) {
                BigDecimal amt = LetterCreditHelper.getAmount((DynamicObject)applyBill);
                CreditLimitServiceHelper.returnCreditLimit((DynamicObject)letterCredit, (DynamicObject)applyBill, (boolean)true, (BigDecimal)amt, null, (boolean)true, (Date)letterCredit.getDate("bizdate"));
                creditRatio = applyBill.getBigDecimal("creditgratio");
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)newCreditLimit)) {
                LetterCreditHelper.autoUseCreditLimit((DynamicObject)letterCredit, (boolean)false, (boolean)false, creditRatio);
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)letterCredit, null, (boolean)false, (Date)letterCredit.getDate("bizdate"));
            }
            for (DynamicObject entry : letterCredit.getDynamicObjectCollection("entrys")) {
                if (!EmptyUtil.isEmpty((Long)entry.getLong(LetterCreditHistoryProp.SOURCEENTRYID))) continue;
                entry.set(LetterCreditHistoryProp.SOURCEENTRYID, (Object)entry.getLong("id"));
            }
            LetterCreditHelper.writeBackMotherChildCredit((DynamicObject)letterCredit);
            LetterCreditHelper.setIsSurety((DynamicObject)letterCredit);
        }
        LetterCreditOpenHelper.letterCreditWriteBackPay(Arrays.stream(dataEntities).collect(Collectors.toList()), (String)PayBillWriteBackOperateEnum.SUBMIT.getValue());
    }
}

