/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FeeSourceEnum;
import kd.tmc.fbp.common.enums.GuaranteeWayEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.LetterBizTypeEnum;
import kd.tmc.lc.common.helper.LcParameterHelper;
import kd.tmc.lc.common.helper.LetterCreditHelper;
import kd.tmc.lc.common.property.LetterCreditProp;
import kd.tmc.lc.formplugin.apply.BizApplyGuaUseEntryPlugin;
import kd.tmc.lc.formplugin.helper.DebtRelateSuretyHelper;
import kd.tmc.lc.formplugin.resource.LcFormResourceEnum;

public class BizApplyEdit
extends BizApplyGuaUseEntryPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(BizApplyGuaUseEntryPlugin.class);
    protected static final String CREDITCHOOSE = "CREDITCHOOSE";
    protected static final List<String> NO_COPYP_ROPERTYS = Arrays.asList("entrys", "id", "seq", "creditno", "billno", "billstatus", "billhead_lk", "creator", "creator_id", "createtime", "modifier", "modifytime", "auditor", "auditdate", "multilanguagetext", "applydate", "applyreason", "feedetail", "entry_gcontract");
    protected static final List<String> NO_PROPCHG_ROPERTYS = Arrays.asList("guarantee", "credittype", "bank", "amount", "amountscaleupper", "promisrate", "suretymoney", "creditamount");
    private static final String FEEBILL_FIELDS = "id,billno,billstatus,org,feescheme,feetype,paydate,currency,amountrate,payamt,feeacctbank,settlementtype,oppunittype,oppunit,oppunittext,oppacctbank,oppbebank,issettle,feesource,description,entry.id,entry.producttype,entry.srcbillno,entry.srcbillid,entry.feedetailamt,entry.remark,entry.srcstatus,entry.excrate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit letterCredit = (BasedataEdit)this.getControl("lettercredit");
        letterCredit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit suretyBill = (BasedataEdit)this.getControl("suretybill");
        suretyBill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entry = (EntryGrid)this.getControl("entry_surety");
        if (entry != null) {
            entry.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initSetCreditAndReason();
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("lettercredit")) {
            Object id = this.getView().getFormShowParameter().getCustomParams().get("lettercredit");
            this.getModel().setValue("lettercredit", id);
            String bizType = (String)this.getView().getFormShowParameter().getCustomParams().get("biztype");
            this.getModel().setValue("biztype", (Object)bizType);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setCreditAndReason();
        String bizType = (String)this.getModel().getValue("biztype");
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("lettercredit")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"lettercredit", "biztype"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_submit"});
            this.LetterCreditChgEvt();
            this.getView().setVisible(Boolean.valueOf(!LetterBizTypeEnum.CLOSE_CARD.getValue().equals(bizType) && !LetterBizTypeEnum.REPEAL_CARD.getValue().equals(bizType)), new String[]{LetterCreditProp.TABPAGE_GUARANTEE});
            this.getView().getFormShowParameter().getCustomParams().remove("lettercredit");
        } else if (!LetterBizTypeEnum.EDIT_CARD.getValue().equals(bizType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LetterCreditProp.TABPAGE_GUARANTEE});
        }
        if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus() && (LetterBizTypeEnum.EDIT_CARD.getValue().equals(bizType) || LetterBizTypeEnum.REPEAL_CARD.getValue().equals(bizType) || LetterBizTypeEnum.CLOSE_CARD.getValue().equals(bizType))) {
            this.getModel().setValue("applyreason", null);
        }
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("TrackUp")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_audit"});
        }
        this.initBenefitType();
        this.setBizTypeEnable();
        if (OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus()) {
            if (!LetterBizTypeEnum.OPEN_CARD.getValue().equals(bizType)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"biztype"});
            }
            if (LetterBizTypeEnum.EDIT_CARD.getValue().equals(bizType)) {
                this.setInfoEnable(false);
                if (this.showGContract()) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{LetterCreditProp.TABPAGE_GUARANTEE});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{LetterCreditProp.TABPAGE_GUARANTEE});
                }
            }
        }
        DebtRelateSuretyHelper.initSuretyColumn(this.getView(), this.getModel());
        DebtRelateSuretyHelper.fillSuretyEntry(this.getModel());
        this.getModel().setValue("lowstr", (Object)LcFormResourceEnum.LetterCreditBaseEdit_0.loadKDString());
        this.getModel().setValue("upperstr", (Object)LcFormResourceEnum.LetterCreditBaseEdit_1.loadKDString());
        this.getModel().setDataChanged(false);
    }

    private void initBenefitType() {
        String benefitType = (String)this.getModel().getValue("benefitertype");
        if ("bos_org".equals(benefitType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"basenoticebank"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"basenoticebank"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Tab tab;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("audit".equals(operateKey) && args.getOperationResult().isSuccess() && (tab = (Tab)this.getControl(LetterCreditProp.TABAP)) != null && LetterCreditProp.TABPAGE_MODIFYINFO.equals(tab.getCurrentTab())) {
            tab.activeTab(LetterCreditProp.BASE_TABPAGEAP);
        }
    }

    private void setBizTypeEnable() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isNoEmpty((DynamicObject)org) && !this.getView().getFormShowParameter().getCustomParams().containsKey("lettercredit")) {
            boolean isApplyRepeal = LcParameterHelper.getAppBoolParameter((long)org.getLong("id"), (String)LetterCreditProp.IS_APPLY_REPEAL);
            boolean isApplyClose = LcParameterHelper.getAppBoolParameter((long)org.getLong("id"), (String)LetterCreditProp.IS_APPLY_CLOSE);
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"biztype"});
            items.add(new ComboItem(new LocaleString(LetterBizTypeEnum.OPEN_CARD.getName()), LetterBizTypeEnum.OPEN_CARD.getValue()));
            items.add(new ComboItem(new LocaleString(LetterBizTypeEnum.EDIT_CARD.getName()), LetterBizTypeEnum.EDIT_CARD.getValue()));
            this.setBizTypeItems(items, isApplyRepeal, LetterBizTypeEnum.REPEAL_CARD);
            this.setBizTypeItems(items, isApplyClose, LetterBizTypeEnum.CLOSE_CARD);
            ComboEdit property = (ComboEdit)this.getControl("biztype");
            property.setComboItems(items);
            Set bizTypes = items.stream().map(o -> o.getValue()).collect(Collectors.toSet());
            String bizType = (String)this.getModel().getValue("biztype");
            if (!bizTypes.contains(bizType)) {
                this.getModel().setValue("biztype", (Object)LetterBizTypeEnum.OPEN_CARD.getValue());
            }
        }
    }

    private void setBizTypeItems(List<ComboItem> items, boolean isApply, LetterBizTypeEnum bizTypeEnum) {
        if (isApply) {
            items.add(new ComboItem(new LocaleString(bizTypeEnum.getName()), bizTypeEnum.getValue()));
        }
    }

    private void initSetCreditAndReason() {
        String bizType = (String)this.getModel().getValue("biztype");
        if (LetterBizTypeEnum.OPEN_CARD.getValue().equals(bizType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"lettercredit"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"applyreason", "lettercredit"});
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"applyreason", (Object)LetterBizTypeEnum.OPEN_CARD.getName());
            DynamicObject letterCredit = (DynamicObject)this.getModel().getValue("lettercredit");
            if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit)) {
                this.getView().invokeOperation("refresh");
            }
        } else {
            this.getPageCache().put("biztype", bizType);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"lettercredit"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"applyreason", "lettercredit"});
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"applyreason", (Object)"");
            this.getModel().setValue("lettercredit", null);
        }
    }

    private void setCreditAndReason() {
        String bizType = (String)this.getModel().getValue("biztype");
        if (LetterBizTypeEnum.OPEN_CARD.getValue().equals(bizType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"lettercredit"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"applyreason", "lettercredit"});
        } else {
            boolean haveArrival;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"lettercredit"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"applyreason", "lettercredit"});
            DynamicObject letterCredit = (DynamicObject)this.getModel().getValue("lettercredit");
            if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit) && (haveArrival = LetterCreditHelper.isHaveArrival((DynamicObject)letterCredit))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"creditlimit", "currency"});
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        String property = evt.getProperty().getName();
        if ("lettercredit".equals(property)) {
            QFilter arrFilter;
            DynamicObjectCollection arrival;
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParam = showParameter.getListFilterParameter();
            List qFilters = filterParam.getQFilters();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            Long orgId = org.getLong("id");
            QFilter qFilter = new QFilter("org", "=", (Object)orgId);
            String bizType = (String)this.getModel().getValue("biztype");
            if (LetterBizTypeEnum.REPEAL_CARD.getValue().equals(bizType)) {
                QFilter arrFilter2 = new QFilter("lettercredit", "!=", null);
                arrFilter2.and(new QFilter("arrivalstatus", "=", (Object)ArrivalStatusEnum.ARRIVAL_REGISTER.getValue()));
                DynamicObjectCollection arrival2 = QueryServiceHelper.query((String)"lc_arrival", (String)"lettercredit", (QFilter[])arrFilter2.toArray());
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)arrival2)) {
                    Set collect = arrival2.stream().map(s -> s.getLong("lettercredit")).collect(Collectors.toSet());
                    qFilter.and("id", "not in", collect);
                }
            } else if (LetterBizTypeEnum.CLOSE_CARD.getValue().equals(bizType) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(arrival = QueryServiceHelper.query((String)"lc_arrival", (String)"lettercredit,todoamount", (QFilter[])(arrFilter = new QFilter("lettercredit", "!=", null)).toArray())))) {
                Map<Long, List<DynamicObject>> collectMap = arrival.stream().collect(Collectors.groupingBy(s -> s.getLong("lettercredit")));
                ArrayList<Long> collect = new ArrayList<Long>(16);
                for (Map.Entry<Long, List<DynamicObject>> entrySet : collectMap.entrySet()) {
                    BigDecimal todoAmount = entrySet.getValue().stream().map(s -> s.getBigDecimal("todoamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (todoAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                    collect.add(entrySet.getKey());
                }
                if (!collect.isEmpty()) {
                    qFilter.and("id", "not in", collect);
                }
            }
            qFilters.add(qFilter);
        } else if ("suretybill".equals(property)) {
            BigDecimal suretyMoney;
            DynamicObject suretyCur;
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
                filters.add(new QFilter("org", "=", org.getPkValue()));
            }
            String guaWay = (String)this.getModel().getValue("guarantee");
            List guaWayList = Arrays.stream(guaWay.split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toList());
            BigDecimal proMisRate = (BigDecimal)this.getModel().getValue("promisrate");
            if (!guaWayList.contains(GuaranteeWayEnum.ENSUAMT.getNumberValue()) || EmptyUtil.isEmpty((BigDecimal)proMisRate) || proMisRate.compareTo(Constants.ZERO) == 0) {
                filters.add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(suretyCur = (DynamicObject)this.getModel().getValue("suretycur")))) {
                filters.add(new QFilter("currency", "=", suretyCur.getPkValue()));
            }
            if (EmptyUtil.isNoEmpty((BigDecimal)(suretyMoney = (BigDecimal)this.getModel().getValue("suretymoney")))) {
                filters.add(new QFilter("surplusamount", ">=", (Object)suretyMoney));
            }
            QFilter suretyFilter = new QFilter("investvarieties.islimitsurety", "=", (Object)false);
            DynamicObjectCollection suretyIds = QueryServiceHelper.query((String)"fbd_suretybill", (String)"id", (QFilter[])new QFilter[]{suretyFilter});
            filters.add(new QFilter("id", "in", suretyIds.stream().map(d -> d.getLong("id")).collect(Collectors.toList())));
            logger.info("BizApply suretyBill filters:" + ((Object)filters).toString());
            showParameter.setMultiSelect(false);
            showParameter.getListFilterParameter().getQFilters().addAll(filters);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (property) {
            case "lettercredit": {
                this.LetterCreditChgEvt();
                break;
            }
            case "biztype": {
                this.initSetCreditAndReason();
                this.setInfoEnable(true);
                break;
            }
            case "org": {
                this.setBizTypeEnable();
                break;
            }
            case "currency": {
                DebtRelateSuretyHelper.initSuretyColumn(this.getView(), this.getModel());
                DebtRelateSuretyHelper.suretyMoneyChgEvt(this.getView(), this.getModel());
                break;
            }
            case "credittype": 
            case "bank": 
            case "creditamount": {
                String bizType = (String)this.getModel().getValue("biztype");
                if (!LetterBizTypeEnum.OPEN_CARD.getValue().equals(bizType)) break;
                this.clearCreditLimit();
                break;
            }
            case "amountscaleupper": 
            case "amount": {
                String bizType = (String)this.getModel().getValue("biztype");
                if (LetterBizTypeEnum.OPEN_CARD.getValue().equals(bizType)) {
                    DebtRelateSuretyHelper.suretyMoneyChgEvt(this.getView(), this.getModel());
                    break;
                }
                this.getPageCache().put(CREDITCHOOSE, CREDITCHOOSE);
                DebtRelateSuretyHelper.editCardSuretyMoneyChgEvt(this.getView(), this.getModel());
                break;
            }
            case "benefitertype": {
                this.initBenefitType();
                break;
            }
            case "basenoticebank": {
                DynamicObject baseNoticeBank = (DynamicObject)this.getModel().getValue("basenoticebank");
                if (!EmptyUtil.isNoEmpty((DynamicObject)baseNoticeBank)) break;
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"noticebank", (Object)baseNoticeBank.get("name"));
                break;
            }
            case "suretybill": {
                this.entrySuretyChgEvt(rowIndex, newValue);
                break;
            }
            case "guarantee": {
                DebtRelateSuretyHelper.initSuretyColumn(this.getView(), this.getModel());
                break;
            }
            case "promisrate": 
            case "suretycur": {
                if (LetterBizTypeEnum.EDIT_CARD.getValue().equals(this.getModel().getValue("biztype"))) break;
                DebtRelateSuretyHelper.suretyMoneyChgEvt(this.getView(), this.getModel());
                break;
            }
            case "suretymoney": {
                DebtRelateSuretyHelper.actualCreditMoneyChgEvt(this.getView(), this.getModel(), (BigDecimal)newValue);
                break;
            }
        }
    }

    private void entrySuretyChgEvt(int rowIndex, Object newValue) {
        if (EmptyUtil.isNoEmpty((Object)newValue)) {
            DynamicObject suretyEntry = (DynamicObject)this.getModel().getValue("suretybill", rowIndex);
            DynamicObject surety = QueryServiceHelper.queryOne((String)"fbd_suretybill", (String)String.join((CharSequence)",", "id", "amount", "currency", "surplusamount"), (QFilter[])new QFilter[]{new QFilter("id", "=", suretyEntry.getPkValue())});
            DebtRelateSuretyHelper.fillSuretyEntry(this.getModel(), surety);
        } else {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)rowIndex, (String[])new String[]{"suretycurrency", "suretyamount", "suretysurplusamount"});
        }
    }

    private void clearCreditLimit() {
        DynamicObject creditLimit = (DynamicObject)this.getModel().getValue("creditlimit");
        if (EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) {
            this.getModel().setValue("creditlimit", null);
        }
    }

    private void LetterCreditChgEvt() {
        DynamicObject letterCredit_f7 = (DynamicObject)this.getModel().getValue("lettercredit");
        if (EmptyUtil.isEmpty((DynamicObject)letterCredit_f7)) {
            this.getView().invokeOperation("refresh");
            String bizType = this.getPageCache().get("biztype");
            this.getModel().setValue("biztype", (Object)bizType);
            if (LetterBizTypeEnum.EDIT_CARD.getValue().equals(bizType)) {
                this.setInfoEnable(true);
            }
            return;
        }
        this.getModel().deleteEntryData("entrys");
        DynamicObject letterCredit = TmcDataServiceHelper.loadSingle((Object)letterCredit_f7.getLong("id"), (String)"lc_lettercredit");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"guarantee", (Object)letterCredit.get("guarantee"));
        DataEntityPropertyCollection propertyCol = letterCredit.getDataEntityType().getProperties();
        DataEntityPropertyCollection props = this.getModel().getDataEntityType().getProperties();
        for (Object prop : propertyCol) {
            String propName;
            if (prop instanceof EntryProp || NO_COPYP_ROPERTYS.contains(propName = prop.getName()) || !props.containsKey((Object)propName)) continue;
            if (NO_PROPCHG_ROPERTYS.contains(propName) || propName.equals(GuaranteeUseHelper.getBizPropName((String)this.getModel().getDataEntityType().getName(), (String)"head_creditlimit"))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, (Object)letterCredit.get(propName));
                continue;
            }
            this.getModel().setValue(propName, letterCredit.get(propName));
        }
        DynamicObjectCollection entryCol = letterCredit.getDynamicObjectCollection("entrys");
        propertyCol = this.getModel().getEntryEntity("entrys").getDynamicObjectType().getProperties();
        for (DynamicObject entry : entryCol) {
            int index = this.getModel().createNewEntryRow("entrys");
            for (IDataEntityProperty prop : propertyCol) {
                if (NO_COPYP_ROPERTYS.contains(prop.getName()) || !entry.getDataEntityType().getProperties().containsKey((Object)prop.getName())) continue;
                this.getModel().setValue(prop.getName(), entry.get(prop.getName()), index);
            }
            this.getModel().setValue("entrys.id", null, index);
        }
        List attachments = AttachmentServiceHelper.getAttachments((String)"lc_lettercredit", (Object)letterCredit_f7.getLong("id"), (String)"attachmentpanel");
        if (attachments.size() > 0) {
            List attaList = TmcAttachmentHelper.copyAttachment((List)attachments, (String)"lc_bizapply");
            HashMap<String, List> attacheMentInfo = new HashMap<String, List>(16);
            attacheMentInfo.put("attachmentpanel", attaList);
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put("TampAttCache" + this.getView().getPageId(), SerializationUtils.toJsonString(attacheMentInfo));
            this.getView().updateView("attachmentpanel");
        }
        String bizType = (String)this.getModel().getValue("biztype");
        if (LetterBizTypeEnum.EDIT_CARD.getValue().equals(bizType)) {
            this.setInfoEnable(false);
            this.fillbackLetterOfGuaranteeData();
        } else if (LetterBizTypeEnum.REPEAL_CARD.getValue().equals(bizType) || LetterBizTypeEnum.CLOSE_CARD.getValue().equals(bizType)) {
            this.loadFeeDetail(letterCredit.getLong("id"));
        }
    }

    private void setInfoEnable(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"bank", "credittype", "org", "benefitertype", "benefiter", "benefiterother"});
    }

    public void loadFeeDetail(Long pkId) {
        this.getModel().deleteEntryData("feedetail");
        QFilter feeIdFilter = new QFilter("entry.srcbillid", "=", (Object)pkId);
        QFilter dataIsoRateFilter = new QFilter("feesource", "=", (Object)FeeSourceEnum.LINKGEN.getValue()).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("feesource", "in", Arrays.asList(FeeSourceEnum.HAND.getValue(), FeeSourceEnum.BIZPATCH.getValue(), FeeSourceEnum.BATCHINPUT.getValue()))));
        DynamicObjectCollection feeBills = QueryServiceHelper.query((String)"cfm_feebill", (String)FEEBILL_FIELDS, (QFilter[])new QFilter[]{feeIdFilter, dataIsoRateFilter}, (String)"modifytime asc");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)feeBills)) {
            return;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("loanbillno", new Object[0]).addField("feeproducttype", new Object[0]).addField("feescheme", new Object[0]).addField("feetype", new Object[0]).addField("feepaydate", new Object[0]).addField("feecurrency", new Object[0]).addField("feeamt", new Object[0]).addField("feerate", new Object[0]).addField("feesettletype", new Object[0]).addField("feeacctbank", new Object[0]).addField("feeoppunittype", new Object[0]).addField("feeoppunit", new Object[0]).addField("feeoppunittext", new Object[0]).addField("feeoppacctbank", new Object[0]).addField("feeoppbebank", new Object[0]).addField("feeissettle", new Object[0]).addField("feesource", new Object[0]).addField("feeremark", new Object[0]).addField("feebillnum", new Object[0]).addField("feebillid", new Object[0]).addField("feebillentryid", new Object[0]).addField("feenumber", new Object[0]).addField("excrate", new Object[0]);
        for (DynamicObject feeBill : feeBills) {
            vs.addRow(new Object[]{null, this.getFeeProductTypeNum(feeBill), feeBill.get("feescheme"), feeBill.get("feetype"), feeBill.get("paydate"), feeBill.get("currency"), feeBill.get("entry.feedetailamt"), feeBill.get("amountrate"), feeBill.get("settlementtype"), feeBill.get("feeacctbank"), feeBill.get("oppunittype"), feeBill.get("oppunit"), feeBill.get("oppunittext"), feeBill.get("oppacctbank"), feeBill.get("oppbebank"), feeBill.get("issettle"), feeBill.get("feesource"), feeBill.get("entry.remark"), feeBill.get("billno"), feeBill.get("id"), feeBill.get("entry.id"), EmptyUtil.isNoEmpty((Object)feeBill.get("entry.srcstatus")) || BillStatusEnum.AUDIT.getValue().equals(feeBill.get("billstatus")) ? feeBill.get("billno") : null, feeBill.getBigDecimal("entry.excrate")});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        boolean isDataChange = model.isDataLoaded();
        model.batchCreateNewEntryRow("feedetail", vs);
        model.setDataChanged(isDataChange);
        model.endInit();
        this.getView().updateView("feedetail");
    }

    private String getFeeProductTypeNum(DynamicObject feeBill) {
        String productTypeId = String.valueOf(feeBill.get("entry.producttype"));
        for (ProductTypeEnum productType : ProductTypeEnum.values()) {
            if (!productTypeId.equals(productType.getId())) continue;
            return productType.getValue();
        }
        return "";
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        switch (fieldName = evt.getFieldName()) {
            case "suretybill": {
                int rowIndex = evt.getRowIndex();
                if (rowIndex <= -1) break;
                DynamicObject entry = this.getModel().getEntryRowEntity("entry_surety", rowIndex);
                DynamicObject suretyBill = entry.getDynamicObject("suretybill");
                if (EmptyUtil.isEmpty((DynamicObject)suretyBill)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BizApplyEdit_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                    break;
                }
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("fbd_suretybill");
                parameter.setPkId((Object)suretyBill.getLong("id"));
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "addsuretyentry": {
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("entry_surety"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u6dfb\u52a0\u4e00\u6761\u8bb0\u5f55\u3002", (String)"BizApplyEdit_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }
}

