/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class ArrivalPresentBaseList
extends AbstractTmcListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if ("org.name".equals(fieldName)) {
                commonFilter.setDefaultValue("");
                continue;
            }
            if (!"arrivaldate".equals(fieldName) || !customParams.containsKey("report")) continue;
            commonFilter.setDefaultValue("");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "submit": {
                List selectedIdList = super.getSelectedIdList();
                if (EmptyUtil.isEmpty((Collection)selectedIdList)) {
                    args.setCancel(true);
                    break;
                }
                this.checkTotalArrAmount(args);
                break;
            }
            case "affirmbill": {
                this.getView().getPageCache().put("isconfirming", "1");
                break;
            }
            case "financing": {
                Long selectedId = super.getSelectedId();
                if (!EmptyUtil.isEmpty((Long)selectedId)) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (args.getOperationResult() != null && !args.getOperationResult().isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "financing": {
                this.showFinancConfigPage();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (EmptyUtil.isEmpty((Object)evt.getReturnData())) {
            return;
        }
        switch (actionId) {
            case "finconfirm_back": {
                Map returnVal = (Map)evt.getReturnData();
                TmcBotpHelper.doPush((IFormView)this.getView(), (Long)((Long)returnVal.get("id")), (String)((String)returnVal.get("entityname")), (String)"cfm_loan_apply", (String)((String)returnVal.get("entityname")), (String)"cfm_loan_apply");
                break;
            }
            case "sumbitConfig": {
                Map returnData = (Map)evt.getReturnData();
                List billNoList = (List)returnData.get("billNoList");
                OrmLocaleValue exceedReason = (OrmLocaleValue)returnData.get("exceedReason");
                OperateOption option = OperateOption.create();
                option.setVariableValue("billno", String.join((CharSequence)",", billNoList));
                option.setVariableValue("exceedresonlc", exceedReason.getLocaleValue());
                option.setVariableValue("exceedreson", exceedReason.getLocaleValue_zh_CN());
                option.setVariableValue("exceedresontw", exceedReason.getLocaleValue_zh_TW());
                option.setVariableValue("exceedresonen", exceedReason.getLocaleValue_en());
                this.getPageCache().put("passSubmit", "true");
                this.getView().invokeOperation("submit", option);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (StringUtils.equals((CharSequence)"sumbitConfig", (CharSequence)evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("passSubmit", "true");
            this.getView().invokeOperation("submit");
        }
    }

    private void showFinancConfigPage() {
        Long selectedId = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)selectedId)) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("lc_financ_config");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("id", selectedId);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        String entityName = billList.getEntityId();
        showParameter.getCustomParams().put("entityname", entityName);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "finconfirm_back"));
        this.getView().showForm(showParameter);
    }

    private void checkTotalArrAmount(BeforeDoOperationEventArgs args) {
        DynamicObject[] selBillList;
        if (this.getPageCache().getAll().containsKey("passSubmit")) {
            this.getPageCache().remove("passSubmit");
            return;
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        String entityName = billList.getEntityId();
        List selectedIdList = super.getSelectedIdList();
        ArrayList<String> billNoList = new ArrayList<String>(selectedIdList.size());
        for (DynamicObject selBill : selBillList = TmcDataServiceHelper.load((String)entityName, (String)"billno,billstatus,lettercredit,id,arrivalamount", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedIdList)})) {
            String billStatus = selBill.getString("billstatus");
            if (!BillStatusEnum.SAVE.getValue().equals(billStatus)) continue;
            selBill.getString("billstatus");
            DynamicObject credit = selBill.getDynamicObject("lettercredit");
            if (EmptyUtil.isEmpty((DynamicObject)credit)) continue;
            QFilter qFilter = new QFilter("lettercredit", "=", credit.getPkValue());
            qFilter.and("id", "!=", (Object)selBill.getLong("id"));
            DynamicObjectCollection arrivalBills = QueryServiceHelper.query((String)entityName, (String)"arrivalamount,doneamount", (QFilter[])qFilter.toArray());
            BigDecimal arrivalAmount = selBill.getBigDecimal("arrivalamount");
            for (DynamicObject arrivalBill : arrivalBills) {
                arrivalAmount = arrivalAmount.add(arrivalBill.getBigDecimal("arrivalamount"));
            }
            String queryEntity = "lc_lettercredit";
            if ("lc_present".equals(entityName)) {
                queryEntity = "lc_receipt";
            }
            DynamicObject letterCredit = TmcDataServiceHelper.loadSingle((Object)credit.getPkValue(), (String)queryEntity);
            BigDecimal amt = LetterCreditHelper.getAmount((DynamicObject)letterCredit);
            if (arrivalAmount.compareTo(amt = amt.setScale(LetterCreditHelper.getAmtprecision((DynamicObject)letterCredit.getDynamicObject("currency")), RoundingMode.HALF_UP)) <= 0) continue;
            if ("lc_arrival".equals(entityName)) {
                billNoList.add(selBill.getString("billno"));
            }
            if ("lc_present".equals(entityName)) {
                billNoList.add(selBill.getString("billno"));
            }
            args.setCancel(true);
        }
        if (!billNoList.isEmpty()) {
            this.showArrivalReason(billNoList);
        }
    }

    private void showArrivalReason(List<String> billNoList) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("lc_arrivalreson");
        param.getOpenStyle().setShowType(ShowType.Modal);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        String entityName = billList.getEntityId();
        param.getCustomParams().put("billNoList", billNoList);
        param.getCustomParams().put("formid", entityName);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sumbitConfig"));
        this.getView().showForm(param);
    }
}

