/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.forfaiting;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.common.helper.BaseDataHelper;

public class ForfaitingBillEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        TextEdit recBillNo = (TextEdit)this.getControl("recbillno");
        if (recBillNo != null) {
            recBillNo.addButtonClickListener((ClickListener)this);
        }
        BasedataEdit letterCredit = (BasedataEdit)this.getControl("lettercredit");
        letterCredit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit arrivalNo = (BasedataEdit)this.getControl("arrivalno");
        arrivalNo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultBankAccount();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject arrivalNo = (DynamicObject)this.getModel().getValue("arrivalno");
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (BillStatusEnum.SAVE.getValue().equals(billStatus) && EmptyUtil.isNoEmpty((DynamicObject)arrivalNo)) {
            this.setInfoEnable(false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"arrivalno"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setArrivalWay();
        this.initBenefiterType();
        this.setRecAccountEnable(false);
        this.setEndDateMin();
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object propertyValue = this.getModel().getValue(propertyName);
        switch (propertyName) {
            case "arrivalno": {
                this.arrivalNoChgEvt();
                break;
            }
            case "isforward": {
                this.setArrivalWay();
                break;
            }
            case "arrivalcurrency": {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"buyoutcurrency", (Object)((DynamicObject)propertyValue).getPkValue());
                break;
            }
            case "arrivalamount": {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"buyoutamount", (Object)propertyValue);
                break;
            }
            case "term": {
                this.termChgEvt();
                this.calWithHoldInterestAmount();
                break;
            }
            case "validdate": {
                this.validDateChgEvt();
                this.calWithHoldInterestAmount();
                this.setEndDateMin();
                break;
            }
            case "enddate": {
                this.endDateChgEvt();
                this.calWithHoldInterestAmount();
                break;
            }
            case "org": {
                this.setDefaultBankAccount();
                break;
            }
            case "benefitertype": {
                this.initBenefiterType();
                this.setIsRelatedTrd();
                break;
            }
            case "benefiter": {
                this.setBenefiterOther();
                break;
            }
            case "presendbank": {
                this.setAcceptanceBank();
                break;
            }
            case "buyoutamount": {
                this.calWithHoldInterestAmount();
                this.calRecnetAmount();
                break;
            }
            case "interestdeferreddays": 
            case "rate": 
            case "ratedays": {
                this.calWithHoldInterestAmount();
                break;
            }
            case "totalfeeamount": 
            case "withholdinterestamount": {
                this.calRecnetAmount();
                break;
            }
            case "recbillno": {
                this.setRecAccountEnable(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (("save".equals(operateKey) || "submit".equals(operateKey)) && operationResult.isSuccess()) {
            this.setInfoEnable(false);
            if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("arrivalno"))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"arrivalno"});
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property = evt.getProperty().getName();
        if ("lettercredit".equals(property) || "arrivalno".equals(property)) {
            ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            String appId = this.getView().getFormShowParameter().getAppId();
            List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"lc_forfaiting", (String)"47150e89000000ac");
            QFilter qFilter = new QFilter("org", "in", (Object)orgIdList);
            qFilters.add(qFilter);
        }
    }

    private void arrivalNoChgEvt() {
        DynamicObject arrivalF7 = (DynamicObject)this.getModel().getValue("arrivalno");
        if (EmptyUtil.isNoEmpty((DynamicObject)arrivalF7)) {
            DynamicObject present = TmcDataServiceHelper.loadSingle((Object)arrivalF7.getLong("id"), (String)"lc_present");
            DataEntityPropertyCollection propertys = present.getDataEntityType().getProperties();
            DataEntityPropertyCollection props = this.getModel().getDataEntityType().getProperties();
            for (IDataEntityProperty prop : propertys) {
                if (!this.copyPropertys().contains(prop.getName()) || !props.containsKey((Object)prop.getName())) continue;
                this.getModel().setValue(prop.getName(), present.get(prop.getName()));
                if ("arrivalcurrency".equals(prop.getName())) {
                    this.getModel().setValue("buyoutcurrency", present.getDynamicObject(prop.getName()).getPkValue());
                    continue;
                }
                if ("arrivalamount".equals(prop.getName())) {
                    this.getModel().setValue("buyoutamount", present.get(prop.getName()));
                    continue;
                }
                if (!"benefitertype".equals(prop.getName())) continue;
                this.getModel().setValue("isrelatedtrd", (Object)StringUtils.equals((CharSequence)"bos_org", (CharSequence)present.getString(prop.getName())));
            }
            this.setInfoEnable(false);
        } else {
            this.getView().invokeOperation("refresh");
            this.setInfoEnable(true);
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control) {
            String key;
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "recbillno": {
                    this.showF7Bank(key);
                }
            }
        }
    }

    private void termChgEvt() {
        String term = (String)this.getModel().getValue("term");
        if (!TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)term)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", null);
        } else {
            Date validDate = (Date)this.getModel().getValue("validdate");
            if (term != null && validDate != null) {
                Date endDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)validDate);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", (Object)endDate);
            }
        }
    }

    private void validDateChgEvt() {
        Date validDate = (Date)this.getModel().getValue("validdate");
        if (validDate == null) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", null);
        } else {
            String term = (String)this.getModel().getValue("term");
            if (!"".equals(term)) {
                Date endDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)validDate);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", (Object)endDate);
            }
        }
    }

    private void setEndDateMin() {
        Date validDate = (Date)this.getModel().getValue("validdate");
        if (validDate != null) {
            DateEdit dateEdit = (DateEdit)this.getControl("enddate");
            dateEdit.setMinDate(DateUtils.getNextDay((Date)validDate, (int)1));
        }
    }

    private void endDateChgEvt() {
        Date validDate = (Date)this.getModel().getValue("validdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (validDate != null && endDate != null) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)DateUtils.getDiff_ymd((Date)validDate, (Date)endDate));
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", null);
        }
    }

    private void setIsRelatedTrd() {
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"isrelatedtrd", (Object)false);
        String benefiterType = (String)this.getModel().getValue("benefitertype");
        if ("bos_org".equals(benefiterType)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"isrelatedtrd", (Object)true);
        }
    }

    private void initBenefiterType() {
        String benefiterType = (String)this.getModel().getValue("benefitertype");
        if ("fbd_other".equals(benefiterType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"benefiterother"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"benefiter"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"benefiter"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"benefiterother"});
        }
    }

    private void setBenefiterOther() {
        DynamicObject benefiter = (DynamicObject)this.getModel().getValue("benefiter");
        if (EmptyUtil.isNoEmpty((DynamicObject)benefiter)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"benefiterother", (Object)benefiter.getString("name"));
        }
    }

    private void setAcceptanceBank() {
        DynamicObject presendBank = (DynamicObject)this.getModel().getValue("presendbank");
        if (EmptyUtil.isNoEmpty((DynamicObject)presendBank)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"acceptancebank", (Object)presendBank.getPkValue());
        }
    }

    private void setDefaultBankAccount() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String recBillno = (String)this.getModel().getValue("recbillno");
        if (EmptyUtil.isNoEmpty((DynamicObject)org) && "".equals(recBillno)) {
            DynamicObject account = BaseDataHelper.getDefaultRecAccount((Long)((Long)org.getPkValue()));
            if (EmptyUtil.isNoEmpty((DynamicObject)account)) {
                this.getModel().setValue("recaccount", (Object)account);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"recaccount", (Object)account.getPkValue());
            }
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"subject", (Object)org.getPkValue());
        }
    }

    private void calWithHoldInterestAmount() {
        BigDecimal buyoutAmount = (BigDecimal)this.getModel().getValue("buyoutamount");
        Date valiDdate = (Date)this.getModel().getValue("validdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        int diffDays = 0;
        if (valiDdate != null && endDate != null) {
            diffDays = DateUtils.getDiffDays((Date)valiDdate, (Date)endDate) - 1;
        }
        int daferDays = (Integer)this.getModel().getValue("interestdeferreddays");
        BigDecimal rate = (BigDecimal)this.getModel().getValue("rate");
        String rateDays = (String)this.getModel().getValue("ratedays");
        BigDecimal withAmount = (BigDecimal)this.getModel().getValue("withholdinterestamount");
        if (!(EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyoutAmount, rateDays}) || diffDays <= 0 && daferDays <= 0)) {
            withAmount = buyoutAmount.multiply(new BigDecimal(diffDays + daferDays)).multiply(rate.divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP)).divide(new BigDecimal(rateDays), 6, RoundingMode.HALF_UP);
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"withholdinterestamount", (Object)withAmount);
    }

    private void calRecnetAmount() {
        BigDecimal buyoutAmount = (BigDecimal)this.getModel().getValue("buyoutamount");
        if (BigDecimal.ZERO.compareTo(buyoutAmount) < 0) {
            int diffDays;
            BigDecimal totalFeeAmount = (BigDecimal)this.getModel().getValue("totalfeeamount");
            BigDecimal withAmount = (BigDecimal)this.getModel().getValue("withholdinterestamount");
            BigDecimal recnetAmount = buyoutAmount.subtract(totalFeeAmount).subtract(withAmount);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"recnetamount", (Object)recnetAmount);
            BigDecimal comprehenSiveCost = buyoutAmount.subtract(recnetAmount);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"comprehensivecost", (Object)comprehenSiveCost);
            Date valiDdate = (Date)this.getModel().getValue("validdate");
            Date endDate = (Date)this.getModel().getValue("enddate");
            BigDecimal costRate = BigDecimal.ZERO;
            if (valiDdate != null && endDate != null && (diffDays = DateUtils.getDiffDays((Date)valiDdate, (Date)endDate) - 1) > 0) {
                costRate = comprehenSiveCost.divide(buyoutAmount, 10, RoundingMode.HALF_UP).divide(new BigDecimal(diffDays), 10, RoundingMode.HALF_UP).multiply(new BigDecimal(36000));
            }
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"comprehensivecostrate", (Object)costRate);
        } else {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"recnetamount", (Object)BigDecimal.ZERO);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"comprehensivecost", (Object)BigDecimal.ZERO);
        }
    }

    private void setArrivalWay() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(2);
        boolean isForward = (Boolean)this.getModel().getValue("isforward");
        if (isForward) {
            items.add(new ComboItem(new LocaleString(ArrivalWayEnum.ACCEPT.getName()), ArrivalWayEnum.ACCEPT.getValue()));
            if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"arrivalway", (Object)ArrivalWayEnum.ACCEPT.getValue());
            }
        } else {
            items.add(new ComboItem(new LocaleString(ArrivalWayEnum.PAYMENT.getName()), ArrivalWayEnum.PAYMENT.getValue()));
            if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"arrivalway", (Object)ArrivalWayEnum.PAYMENT.getValue());
            }
        }
        items.add(new ComboItem(new LocaleString(ArrivalWayEnum.PROTEST.getName()), ArrivalWayEnum.PROTEST.getValue()));
        ComboEdit property = (ComboEdit)this.getControl("arrivalway");
        property.setComboItems(items);
    }

    private void showF7Bank(String key) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (Objects.isNull(org)) {
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"cas_recbill", (boolean)Boolean.FALSE);
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("org", "=", org.getPkValue());
        showParameter.getListFilterParameter().setFilter(qFilter);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection rows;
        super.closedCallBack(e);
        if (StringUtils.equals((CharSequence)"recbillno", (CharSequence)e.getActionId()) && EmptyUtil.isNoEmpty((Object)(rows = (ListSelectedRowCollection)e.getReturnData()))) {
            ListSelectedRow selectedRow = rows.get(0);
            Long recbillPK = (Long)selectedRow.getPrimaryKeyValue();
            DynamicObject recbill = TmcDataServiceHelper.loadSingle((Object)recbillPK, (String)"cas_recbill");
            IDataModel dataModel = this.getModel();
            dataModel.setValue("recbillno", (Object)recbill.getString("billno"));
            dataModel.setValue("recaccount", (Object)recbill.getDynamicObject("accountbank"));
        }
    }

    private void setRecAccountEnable(boolean clearAccount) {
        String recBillno = (String)this.getModel().getValue("recbillno");
        if (!"".equals(recBillno)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"recaccount"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"recaccount"});
            if (clearAccount) {
                this.getModel().setValue("recaccount", null);
            }
        }
    }

    private void setInfoEnable(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"lettercredit", "arrivaltype", "benefitertype", "benefiter", "benefiterother", "org", "arrivaldate", "invoiceno", "arrivalcurrency", "arrivalamount", "presendbank", "arrivalway", "endacceptdate", "endpaydate"});
    }

    protected List copyPropertys() {
        return Arrays.asList("lettercredit", "arrivaltype", "benefitertype", "benefiter", "benefiterother", "org", "arrivaldate", "invoiceno", "arrivalcurrency", "arrivalamount", "presendbank", "arrivalway", "endacceptdate", "endpaydate", "isforward");
    }
}

