/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.GuaranteeWayEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.LetterBizTypeEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class DebtRelateSuretyHelper {
    public static void initSuretyColumn(IFormView iFormView, IDataModel iDataModel) {
        String guarantee = (String)iDataModel.getValue("guarantee");
        boolean isConEnsAmt = EmptyUtil.isNoEmpty((String)guarantee) && guarantee.contains(GuaranteeWayEnum.ENSUAMT.getNumberValue());
        TmcViewInputHelper.registerMustInput((IFormView)iFormView, (boolean)isConEnsAmt, (String[])new String[]{"promisrate", "suretycur", "suretymoney", "totalsuretymoney", "creditamount"});
        TmcViewInputHelper.registerVisibleStatus((IFormView)iFormView, (String[])new String[]{"promisrate", "suretycur", "suretymoney", "totalsuretymoney"}, (boolean)isConEnsAmt);
        if (isConEnsAmt) {
            DynamicObject suretyBillObj = (DynamicObject)iDataModel.getValue("suretybill");
            if (EmptyUtil.isNoEmpty((DynamicObject)suretyBillObj) && EmptyUtil.isNoEmpty((Object)suretyBillObj.get("currency"))) {
                iDataModel.setValue("suretycur", suretyBillObj.get("currency"));
            } else if (EmptyUtil.isEmpty((Object)iDataModel.getValue("suretycur"))) {
                iDataModel.setValue("suretycur", iDataModel.getValue("currency"));
            }
        } else {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)iFormView, (IDataModel)iDataModel, (String[])new String[]{"promisrate", "suretycur", "suretymoney", "totalsuretymoney"});
        }
    }

    public static void fillSuretyEntry(IDataModel iDataModel) {
        int entryRowCount = iDataModel.getEntryRowCount("entry_surety");
        Object suretyBillObj = iDataModel.getValue("suretybill");
        if (entryRowCount > 0 && EmptyUtil.isNoEmpty((Object)suretyBillObj)) {
            DebtRelateSuretyHelper.fillSuretyEntry(iDataModel, (DynamicObject)suretyBillObj);
        }
    }

    public static void fillSuretyEntry(IDataModel iDataModel, DynamicObject suretyBill) {
        iDataModel.setValue("suretycurrency", suretyBill.get("currency"));
        iDataModel.setValue("suretyamount", (Object)suretyBill.getBigDecimal("amount"));
        iDataModel.setValue("suretysurplusamount", (Object)suretyBill.getBigDecimal("surplusamount"));
        iDataModel.setValue("suretycur", suretyBill.get("currency"));
    }

    public static void suretyMoneyChgEvt(IFormView iFormView, IDataModel iDataModel) {
        BigDecimal creditAmount;
        BigDecimal rate = DebtRelateSuretyHelper.getRate(iFormView, iDataModel);
        rate = rate == null ? BigDecimal.ONE : rate;
        BigDecimal amount = LetterCreditHelper.getAmount((DynamicObject)iDataModel.getDataEntity());
        BigDecimal proMisRate = (BigDecimal)iDataModel.getValue("promisrate");
        DynamicObject suretyCurrency = (DynamicObject)iDataModel.getValue("suretycur");
        BigDecimal suretyAmount = amount.multiply(proMisRate).divide(Constants.ONE_HUNDRED.multiply(rate), EmptyUtil.isEmpty((DynamicObject)suretyCurrency) ? 6 : suretyCurrency.getInt("amtprecision"), RoundingMode.HALF_UP);
        suretyAmount = EmptyUtil.isEmpty((BigDecimal)suretyAmount) ? BigDecimal.ZERO : suretyAmount;
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)iFormView, (IDataModel)iDataModel, (String)"suretymoney", (Object)suretyAmount);
        if (!"lc_lettercredit_init".equals(iDataModel.getDataEntityType().getName())) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)iFormView, (IDataModel)iDataModel, (String)"totalsuretymoney", (Object)suretyAmount);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)iFormView, (IDataModel)iDataModel, (String)"creditamount", (Object)(Constants.ZERO.compareTo(creditAmount = amount.subtract(suretyAmount.multiply(rate))) > 0 ? Constants.ZERO : creditAmount));
        if (!"lc_bizapply".equals(iDataModel.getDataEntityType().getName()) || LetterBizTypeEnum.OPEN_CARD.getValue().equals(iDataModel.getValue("biztype"))) {
            iDataModel.setValue("creditlimit", null);
        }
    }

    public static void editCardSuretyMoneyChgEvt(IFormView iFormView, IDataModel iDataModel) {
        BigDecimal amount = LetterCreditHelper.getAmount((DynamicObject)iDataModel.getDataEntity());
        BigDecimal rate = DebtRelateSuretyHelper.getRate(iFormView, iDataModel);
        rate = rate == null ? BigDecimal.ONE : rate;
        BigDecimal suretyAmount = (BigDecimal)iDataModel.getValue("suretymoney");
        BigDecimal creditAmount = amount.subtract(suretyAmount.multiply(rate));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)iFormView, (IDataModel)iDataModel, (String)"creditamount", (Object)(Constants.ZERO.compareTo(creditAmount) > 0 ? Constants.ZERO : creditAmount));
        if (EmptyUtil.isNoEmpty((BigDecimal)amount)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)iFormView, (IDataModel)iDataModel, (String)"promisrate", (Object)Constants.ONE_HUNDRED.multiply(suretyAmount).multiply(rate).divide(amount, 10, RoundingMode.HALF_UP));
        }
    }

    private static BigDecimal getRate(IFormView iFormView, IDataModel iDataModel) {
        DynamicObject suretyCurrency = (DynamicObject)iDataModel.getValue("suretycur");
        if (EmptyUtil.isEmpty((DynamicObject)suretyCurrency)) {
            if (!"lc_bizapply".equals(iDataModel.getDataEntityType().getName()) || LetterBizTypeEnum.OPEN_CARD.getValue().equals(iDataModel.getValue("biztype"))) {
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)iFormView, (IDataModel)iDataModel, (String[])new String[]{"suretymoney", "totalsuretymoney", "creditamount"});
                iDataModel.setValue("creditlimit", null);
            }
            return BigDecimal.ONE;
        }
        DynamicObject org = (DynamicObject)iDataModel.getValue("org");
        DynamicObject currency = (DynamicObject)iDataModel.getValue("currency");
        if (EmptyUtil.isEmpty((DynamicObject)org) || EmptyUtil.isEmpty((DynamicObject)currency)) {
            return BigDecimal.ONE;
        }
        Date applyDate = (Date)iDataModel.getValue("applydate");
        Long suretyCurrencyId = suretyCurrency.getLong("id");
        if (!suretyCurrencyId.equals(currency.getLong("id"))) {
            return TmcBusinessBaseHelper.getExchangeRate((long)suretyCurrencyId, (long)currency.getLong("id"), (long)org.getLong("id"), (Date)applyDate);
        }
        return BigDecimal.ONE;
    }

    public static void actualCreditMoneyChgEvt(IFormView iFormView, IDataModel iDataModel, BigDecimal suretyAmount) {
        BigDecimal creditAmount;
        BigDecimal amount = LetterCreditHelper.getAmount((DynamicObject)iDataModel.getDataEntity());
        BigDecimal rate = DebtRelateSuretyHelper.getRate(iFormView, iDataModel);
        rate = rate == null ? BigDecimal.ONE : rate;
        BigDecimal bigDecimal = suretyAmount = EmptyUtil.isEmpty((BigDecimal)suretyAmount) ? BigDecimal.ZERO : suretyAmount;
        if (!"lc_lettercredit_init".equals(iDataModel.getDataEntityType().getName())) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)iFormView, (IDataModel)iDataModel, (String)"totalsuretymoney", (Object)suretyAmount);
            if (EmptyUtil.isNoEmpty((BigDecimal)amount)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)iFormView, (IDataModel)iDataModel, (String)"promisrate", (Object)Constants.ONE_HUNDRED.multiply(suretyAmount).multiply(rate).divide(amount, 10, RoundingMode.HALF_UP));
            }
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)iFormView, (IDataModel)iDataModel, (String)"creditamount", (Object)(Constants.ZERO.compareTo(creditAmount = amount.subtract(suretyAmount.multiply(rate))) > 0 ? Constants.ZERO : creditAmount));
        if (!"lc_bizapply".equals(iDataModel.getDataEntityType().getName()) || LetterBizTypeEnum.OPEN_CARD.getValue().equals(iDataModel.getValue("biztype"))) {
            iDataModel.setValue("creditlimit", null);
        }
    }
}

