/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.home;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.Series;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.fbp.formplugin.chart.AbstractLineChartEdit;

public class AppHomeStatisticsPlugin
extends AbstractLineChartEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"total"});
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("total".equals(key)) {
            Date endDate;
            Date startDate;
            Date now = DateUtils.getDataFormat((Date)DateUtils.getCurrentDate(), (boolean)true);
            String period = (String)this.getModel().getValue("period");
            if (StringUtils.equals((CharSequence)"define", (CharSequence)period)) {
                startDate = (Date)this.getModel().getValue("daterange_startdate");
                endDate = (Date)this.getModel().getValue("daterange_enddate");
                if (startDate == null || endDate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"AppHomeStatisticsPlugin_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                    return;
                }
                endDate = DateUtils.getDataFormat((Date)endDate, (boolean)false);
            } else if (StringUtils.equals((CharSequence)"month", (CharSequence)period)) {
                startDate = DateUtils.getFirstDayOfCurMonth();
                endDate = DateUtils.getLastDayOfCurMonth();
            } else {
                startDate = TermUtils.getLastDateByBaseDate4ymd((String)period, (Date)now);
                endDate = DateUtils.getCurrentTime();
            }
            String entityName = (String)this.getModel().getValue("direction");
            QFilter qFilter = new QFilter("createtime", ">=", (Object)startDate);
            qFilter.and("createtime", "<=", (Object)endDate);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
                qFilter.and("org", "=", org.getPkValue());
            }
            ListShowParameter fsp = new ListShowParameter();
            fsp.setBillFormId(entityName);
            fsp.setCustomParam("isquerydefault", (Object)"no");
            fsp.getListFilterParameter().getQFilters().add(qFilter);
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long orgId = RequestContext.get().getOrgId();
        if (!this.getPageCache().getAll().containsKey("orgchange")) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"org", (Object)orgId);
        }
        super.drawChart();
    }

    protected String getXTitleName() {
        return "";
    }

    protected String getYTitleName() {
        return "";
    }

    protected String getChartCtlName() {
        return "barchartap";
    }

    protected boolean isSwitchXY() {
        return true;
    }

    protected void initSeriesStyle(int index, Chart chart, Series series, String color) {
        super.initSeriesStyle(index, chart, series, color);
        BarSeries barSeries = (BarSeries)series;
        kd.bos.form.chart.Label label = barSeries.getLabel();
        label.setShow(Boolean.TRUE.booleanValue());
        label.setPosition(Position.right);
        barSeries.setLabel(label);
        barSeries.setItemColor("#40A9FF");
        barSeries.setBarWidth("15px");
    }

    protected String[] getXValue() {
        ArrayList<String> dem = new ArrayList<String>();
        List<Map<String, BigDecimal>> amountAndCount = this.getAmountAndCount();
        for (int i = amountAndCount.size() - 1; i >= 0; --i) {
            Map<String, BigDecimal> map = amountAndCount.get(i);
            for (String key : map.keySet()) {
                QFilter[] filter;
                DynamicObject currency;
                if (StringUtils.equals((CharSequence)ResManager.loadKDString((String)"\u5176\u4ed6", (String)"AppHomeStatisticsPlugin_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]), (CharSequence)key)) {
                    dem.add(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"AppHomeStatisticsPlugin_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"total", (CharSequence)key) || StringUtils.equals((CharSequence)"0", (CharSequence)key) || (currency = TmcDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id,name", (QFilter[])(filter = new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(key))}))) == null) continue;
                dem.add(currency.getString("name"));
            }
        }
        return dem.toArray(new String[dem.size()]);
    }

    protected List<Object> getSeriesValue() {
        ArrayList<Object> turnover = new ArrayList<Object>();
        ArrayList<BigDecimal> v = new ArrayList<BigDecimal>();
        List<Map<String, BigDecimal>> amountAndCount = this.getAmountAndCount();
        for (int i = amountAndCount.size() - 1; i >= 0; --i) {
            Map<String, BigDecimal> map = amountAndCount.get(i);
            for (Map.Entry<String, BigDecimal> entry : map.entrySet()) {
                String mapKey = entry.getKey();
                BigDecimal mapValue = entry.getValue();
                if (!StringUtils.equals((CharSequence)"total", (CharSequence)mapKey) && !StringUtils.equals((CharSequence)"0", (CharSequence)mapKey)) {
                    v.add(mapValue);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"total", (CharSequence)mapKey)) continue;
                Label labelName = (Label)this.getView().getControl("total");
                labelName.setText(mapValue.toString());
            }
        }
        turnover.add(v.toArray(new Number[v.size()]));
        return turnover;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key;
        super.propertyChanged(args);
        super.drawChart();
        switch (key = args.getProperty().getName()) {
            case "org": {
                this.getPageCache().put("orgchange", "true");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String property = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)property, (CharSequence)"org")) {
            String entityName = (String)this.getModel().getValue("direction");
            if (EmptyUtil.isEmpty((String)entityName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201d\u7edf\u8ba1\u65b9\u5411\u201c\u3002", (String)"AppHomeExpireWarnPlugin_34", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            String appId = this.getView().getFormShowParameter().getAppId();
            List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)entityName, (String)"47150e89000000ac");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            if (orgIds != null) {
                qFilters.add(new QFilter("id", "in", (Object)orgIds));
            }
        }
    }

    private List<Map<String, BigDecimal>> getAmountAndCount() {
        Date endDate;
        Date startDate;
        Date now = DateUtils.getDataFormat((Date)DateUtils.getCurrentDate(), (boolean)true);
        String period = (String)this.getModel().getValue("period");
        if (StringUtils.equals((CharSequence)"define", (CharSequence)period)) {
            startDate = (Date)this.getModel().getValue("daterange_startdate");
            endDate = (Date)this.getModel().getValue("daterange_enddate");
            if (startDate == null || endDate == null) {
                Label labelName = (Label)this.getView().getControl("total");
                labelName.setText("0");
                return new ArrayList<Map<String, BigDecimal>>();
            }
            endDate = DateUtils.getDataFormat((Date)endDate, (boolean)false);
        } else if (StringUtils.equals((CharSequence)"month", (CharSequence)period)) {
            startDate = DateUtils.getFirstDayOfCurMonth();
            endDate = DateUtils.getLastDayOfCurMonth();
        } else {
            startDate = TermUtils.getLastDateByBaseDate4ymd((String)period, (Date)now);
            endDate = DateUtils.getCurrentTime();
        }
        String entityName = (String)this.getModel().getValue("direction");
        QFilter qFilter = new QFilter("createtime", ">=", (Object)startDate);
        qFilter.and("createtime", "<=", (Object)endDate);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
            qFilter.and("org", "=", org.getPkValue());
        }
        int total = 0;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        String queryProp = "currency.id as currencyid,amount as amount";
        if ("lc_arrival".equals(entityName) || "lc_present".equals(entityName)) {
            queryProp = "arrivalcurrency.id as currencyid,arrivalamount as amount";
        }
        DataSet statisData = QueryServiceHelper.queryDataSet((String)"apphomequery", (String)entityName, (String)queryProp, (QFilter[])qFilter.toArray(), null);
        Iterator iterator = statisData.iterator();
        while (iterator.hasNext()) {
            ++total;
            Row row = (Row)iterator.next();
            Long currencyId = row.getLong("currencyid");
            BigDecimal amount = row.getBigDecimal("amount");
            this.recordMap(map, currencyId, amount);
        }
        List<Map<String, BigDecimal>> returnList = this.sortMapValue(map);
        HashMap<String, BigDecimal> totalMap = new HashMap<String, BigDecimal>();
        totalMap.put("total", new BigDecimal(total));
        returnList.add(totalMap);
        return returnList;
    }

    private List<Map<String, BigDecimal>> sortMapValue(Map<String, BigDecimal> map) {
        ArrayList<Map.Entry<String, BigDecimal>> list = new ArrayList<Map.Entry<String, BigDecimal>>(map.entrySet());
        Collections.sort(list, (o1, o2) -> ((BigDecimal)o2.getValue()).compareTo((BigDecimal)o1.getValue()));
        BigDecimal other = BigDecimal.ZERO;
        ArrayList<Map<String, BigDecimal>> returnList = new ArrayList<Map<String, BigDecimal>>();
        for (int i = 0; i < list.size(); ++i) {
            Map.Entry e = (Map.Entry)list.get(i);
            HashMap<String, BigDecimal> newMap = new HashMap<String, BigDecimal>();
            if (i > 4) {
                other = other.add((BigDecimal)e.getValue());
                if (i != list.size() - 1) continue;
                newMap.put(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"AppHomeStatisticsPlugin_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]), other.divide(Constants.TEN_THOUSAND, 2, 4));
                returnList.add(newMap);
                continue;
            }
            newMap.put((String)e.getKey(), ((BigDecimal)e.getValue()).divide(Constants.TEN_THOUSAND, 2, 4));
            returnList.add(newMap);
        }
        return returnList;
    }

    private void recordMap(Map<String, BigDecimal> map, Long currency, BigDecimal amount) {
        if (currency == null) {
            return;
        }
        String currencyId = currency.toString();
        if (map.isEmpty()) {
            map.put(currencyId, amount);
        } else {
            HashMap<String, BigDecimal> tempMap = new HashMap<String, BigDecimal>();
            tempMap.putAll(map);
            for (Map.Entry entry : tempMap.entrySet()) {
                String mapKey = (String)entry.getKey();
                BigDecimal mapValue = (BigDecimal)entry.getValue();
                if (tempMap.containsKey(currencyId)) {
                    if (!StringUtils.equals((CharSequence)currencyId, (CharSequence)mapKey) || BigDecimal.ZERO.compareTo(amount) == 0) continue;
                    map.put(mapKey, mapValue.add(amount));
                    continue;
                }
                map.put(currencyId, amount);
            }
        }
    }
}

