/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.lettercredit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.AbstractCreditLimitEditPlugin;
import kd.tmc.lc.common.property.LetterCreditProp;

public class LetterCreditLimitPlugin
extends AbstractCreditLimitEditPlugin {
    private boolean creditLimitValidator() {
        BigDecimal creditAmount = (BigDecimal)this.getModel().getValue("creditamount");
        if (EmptyUtil.isEmpty((BigDecimal)creditAmount) || creditAmount.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b9e\u9645\u6388\u4fe1\u5360\u7528\u91d1\u989d\u3002", (String)"LetterCreditLimitPlugin_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        BigDecimal amount = this.getAmount();
        if (EmptyUtil.isNoEmpty((BigDecimal)creditAmount) && creditAmount.compareTo(amount) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u5360\u7528\u6388\u4fe1\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6ea2\u77ed\u88c5\u91d1\u989d\u6d6e\u52a8\u4e0a\u9650\u3002", (String)"LetterCreditLimitPlugin_2", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected Map<String, String> getBizPropertys() {
        HashMap<String, String> propertys = new HashMap<String, String>();
        propertys.put("org", "org");
        propertys.put("finorg", "bank");
        propertys.put("currency", "currency");
        propertys.put("amount", "amount");
        return propertys;
    }

    protected Long getCreditTypeId() {
        DynamicObject creditType = (DynamicObject)this.getModel().getValue("credittype");
        DynamicObject creditLimitType = creditType.getDynamicObject("creditlimittype");
        if (EmptyUtil.isEmpty((DynamicObject)creditLimitType)) {
            return null;
        }
        return (Long)creditLimitType.getPkValue();
    }

    protected BigDecimal setCreditRatio() {
        BigDecimal amount = this.getAmount();
        return ((BigDecimal)this.getModel().getValue("creditamount")).multiply(Constants.ONE_HUNDRED).divide(amount, 10, RoundingMode.HALF_UP);
    }

    protected BigDecimal getAmount() {
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        BigDecimal amountUpper = (BigDecimal)this.getModel().getValue("amountscaleupper");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        BigDecimal totalAmount = amount.multiply(BigDecimal.ONE.add(amountUpper.divide(Constants.ONE_HUNDRED, 6, 4)));
        return totalAmount.setScale(EmptyUtil.isNoEmpty((DynamicObject)currency) ? currency.getInt("amtprecision") : 6, RoundingMode.HALF_UP);
    }

    public boolean checkCreditlimitParams() {
        boolean isChecked = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"credittype");
        return isChecked && this.creditLimitValidator() && super.checkCreditlimitParams();
    }

    public boolean isSubmitReCreate() {
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if ("creditlimit".equals(actionId) && returnData instanceof String) {
            CreditLimitF7ResBean res = (CreditLimitF7ResBean)SerializationUtils.fromJsonString((String)((String)returnData), CreditLimitF7ResBean.class);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"creditamount", (Object)res.getRealBizAmt());
        }
    }

    public boolean isPreOccupy() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        boolean isPreOccupy = Boolean.FALSE;
        if (BillStatusEnum.SAVE.getValue().equals(billStatus)) {
            isPreOccupy = Boolean.TRUE;
        }
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(LetterCreditProp.OP_HISTORY_KEY)) {
            isPreOccupy = Boolean.FALSE;
        }
        return isPreOccupy;
    }

    protected Long getSourceBillId() {
        String creditNo;
        if ("lc_lettercredit".equals(((FormView)this.getView()).getFormId()) && EmptyUtil.isNoEmpty((String)(creditNo = (String)this.getModel().getValue("creditapplyno")))) {
            QFilter qfilter = new QFilter("billno", "=", (Object)creditNo);
            DynamicObject applyBill = TmcDataServiceHelper.loadSingle((String)"lc_bizapply", (String)"billno,currency,creditlimit,amount,amountscaleupper,creditgratio", (QFilter[])qfilter.toArray());
            return applyBill.getLong("id");
        }
        return super.getSourceBillId();
    }

    protected String getSourceType() {
        return "lc_bizapply";
    }

    protected String getCreditUseAmtField() {
        return "creditamt";
    }

    protected String getCreditUseCurrencyField() {
        return "creditcurrency";
    }
}

