/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.payscheprocessor;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;

public class SelectDraftListPlugin
extends AbstractListPlugin {
    public static final String CONFIRM_DRAFTAMT_CALLBACK = "CONFIRM_DRAFTAMT_CALLBACK";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btn = (Button)this.getControl("btnok");
        btn.addClickListener(new ClickListener(){

            public void beforeClick(BeforeClickEvent evt) {
                List selectDraftList;
                DynamicObject[] drafts;
                Set sources;
                FormShowParameter fsp = SelectDraftListPlugin.this.getView().getFormShowParameter();
                BigDecimal chooseDraftAmt = (BigDecimal)fsp.getCustomParam("chooseDraftAmt");
                BigDecimal choosebalanceAmt = (BigDecimal)fsp.getCustomParam("choosebalanceAmt");
                Boolean isBillBids = (Boolean)fsp.getCustomParam("isBillBids");
                BigDecimal limitChooseDraftAmt = chooseDraftAmt.add(choosebalanceAmt);
                BillList billlist = (BillList)SelectDraftListPlugin.this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
                Object[] selectedPks = selectedRows.getPrimaryKeyValues();
                if (EmptyUtil.isEmpty((Object[])selectedPks) || selectedPks.length == 0) {
                    SelectDraftListPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u884c\u6570\u636e\u3002", (String)"SelectDraftListPlugin_01", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
                if ((sources = Arrays.stream(drafts = TmcDataServiceHelper.load((Object[])(selectDraftList = Stream.of(selectedPks).map(v -> (Long)v).collect(Collectors.toList())).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"))).map(o -> o.getString("source")).collect(Collectors.toSet())) != null && sources.size() >= 2 && sources.contains("bei")) {
                    SelectDraftListPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u540c\u65f6\u9009\u4e2d\u201c\u6765\u6e90\u7cfb\u7edf\u201d\u4e3a\u94f6\u4f01\u4e92\u8054\u4e0e\u975e\u94f6\u4f01\u4e92\u8054\u7684\u7968\u636e\u3002", (String)"SelectDraftListPlugin_06", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                BigDecimal calDraftsAmts = PayScheHelper.getDraftsAmts(selectDraftList);
                boolean paymentFlag = (Boolean)fsp.getCustomParam("paymentFlag");
                if (paymentFlag && calDraftsAmts.compareTo(chooseDraftAmt) != 0) {
                    SelectDraftListPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u4ed8\u6b3e\u4e0d\u5141\u8bb8\u5b58\u5728\u5dee\u989d\uff0c\u8bf7\u8c03\u6574\u6392\u7968\u91d1\u989d\u6216\u91cd\u65b0\u9009\u62e9\u7968\u636e\uff0c\u786e\u4fdd\u6240\u9009\u5b50\u7968\u636e\u7684\u91d1\u989d\u603b\u548c\u4e0e\u6392\u7968\u91d1\u989d\u76f8\u7b49\u3002", (String)"SelectDraftListPlugin_04", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (isBillBids.booleanValue() && calDraftsAmts.compareTo(limitChooseDraftAmt) <= 0) {
                    SelectDraftListPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u7968\u636e\u627e\u96f6\u4e1a\u52a1\u4e0b\uff0c\u6240\u9009\u7968\u636e\u7968\u9762\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u9009\u7968\u3002", (String)"SelectDraftListPlugin_05", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                String needPreRecButNotRecMsg = PayScheHelper.getNeedPreRecButNotRec((DynamicObject[])drafts);
                if (EmptyUtil.isNoEmpty((String)needPreRecButNotRecMsg)) {
                    SelectDraftListPlugin.this.getView().showTipNotification(needPreRecButNotRecMsg);
                    evt.setCancel(true);
                    return;
                }
            }
        });
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)id, (CharSequence)CONFIRM_DRAFTAMT_CALLBACK) && MessageBoxResult.Yes.equals((Object)res)) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
            this.getView().returnDataToParent((Object)selectedRows);
            this.getView().close();
        }
    }
}

