/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.autosche.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.tmc.psd.extpoint.IPayScheduleSelectBill;
import kd.sdk.tmc.psd.extpoint.param.PayScheduleInfo;
import kd.sdk.tmc.psd.extpoint.param.PaySchedulePropVal;
import kd.sdk.tmc.psd.extpoint.param.SelectBillParam;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.autosche.IAutoPayScheExecutor;
import kd.tmc.psd.business.service.paysche.autosche.bill.DraftBillLockCache;
import kd.tmc.psd.business.service.paysche.autosche.bill.DraftBillProvider;
import kd.tmc.psd.business.service.paysche.autosche.bill.IPayScheBill;
import kd.tmc.psd.business.service.paysche.autosche.data.DraftBillCoreData;
import kd.tmc.psd.business.service.paysche.autosche.data.WaitScheData;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.common.enums.BillRuleBalanceEnum;
import kd.tmc.psd.common.enums.BillRulePrimeEnum;
import kd.tmc.psd.common.enums.DefaultAccountTypeEnum;
import kd.tmc.psd.common.enums.DraftAccountTypeEnum;
import kd.tmc.psd.common.enums.DraftPayTypeEnum;
import kd.tmc.psd.common.enums.SelectSettleTypeEnum;
import kd.tmc.psd.common.enums.SettleMentTypeEnum;
import kd.tmc.psd.common.untils.StringUtils;

public class AutoPayScheBillExecutor
implements IAutoPayScheExecutor {
    private static Log logger = LogFactory.getLog(AutoPayScheBillExecutor.class);
    private Set<Long> selectedBillIdSet;
    private Set<DraftBillCoreData> bankBills;
    private Set<DraftBillCoreData> bankPayBills;
    private Set<DraftBillCoreData> bizBills;
    private Set<DraftBillCoreData> bizPayBills;
    private DraftBillLockCache billLockCache;
    private BigDecimal totalAmt;
    private Set<Long> curScheIdSet;
    private Set<Long> selectLinkSettypementIds;
    private Long orgId;
    private boolean oneKeySche = false;
    private static final String BASE_DATA_ID = "fbasedataid.id";
    private static final String BASE_DATA_NAME = "fbasedataid.name";

    public AutoPayScheBillExecutor(Long orgId, String pageId, boolean oneKeySche) {
        DraftBillProvider billProvider = DraftBillProvider.getInstance();
        this.selectedBillIdSet = new HashSet<Long>();
        this.selectLinkSettypementIds = new HashSet<Long>();
        this.bankBills = billProvider.getAllBankBills(orgId.longValue());
        this.bankPayBills = billProvider.getAllBankPayBills(orgId.longValue());
        this.bizBills = billProvider.getAllBizBills(orgId.longValue());
        this.bizPayBills = billProvider.getAllBizPayBills(orgId.longValue());
        this.billLockCache = new DraftBillLockCache(pageId);
        this.orgId = orgId;
        this.oneKeySche = oneKeySche;
    }

    public void execute(List<WaitScheData> waitScheDataList, BigDecimal totalAmt) {
        this.totalAmt = totalAmt;
        this.curScheIdSet = waitScheDataList.stream().map(o -> o.getPayScheData().getScheId()).collect(Collectors.toSet());
        HashSet<Long> prevSelectedBillIdSet = new HashSet<Long>();
        for (WaitScheData waitScheData : waitScheDataList) {
            this.fillBillRuleData(waitScheData);
            List<Long> selectedIdList = waitScheData.getPayScheData().getDraftBillIds();
            if (CollectionUtils.isEmpty(selectedIdList)) continue;
            prevSelectedBillIdSet.addAll(selectedIdList);
            waitScheData.getPayScheData().setDraftBillIds(null);
        }
        this.billLockCache.release(prevSelectedBillIdSet);
        Set lockedBillSet = this.billLockCache.getLockedBillIdSet().stream().map(DraftBillCoreData::new).collect(Collectors.toSet());
        this.bankBills.removeAll(lockedBillSet);
        this.bizBills.removeAll(lockedBillSet);
        this.bankPayBills.removeAll(lockedBillSet);
        this.bizPayBills.removeAll(lockedBillSet);
        logger.info("\u9009\u7968\u6570\u636e\uff1a" + waitScheDataList.stream().map(o -> o.toString()).reduce((a, b) -> "{" + a + "}" + b).orElse(""));
        if (this.isExtendDevelop()) {
            logger.info("\u7ec4\u7ec7 {} \u7684\u3010\u662f\u5426\u4e8c\u5f00\u9009\u7968\u3011\u5f00\u5173\u4e3a\u3010\u5f00\u542f\u3011\uff0c\u5f53\u524d\u6267\u884c\u4e8c\u5f00\u6269\u5c55\u9009\u7968\u903b\u8f91\u3002", (Object)this.orgId);
            IPayScheBill paySelectBill = this.getSecDevImplClass();
            Set draftBillIds = paySelectBill.selectBill(waitScheDataList, this.bizPayBills, this.bankBills, this.bizBills, totalAmt);
            waitScheDataList.forEach(w -> this.subtractAmt(w.getPayScheData().getDraftBillAmt()));
            this.selectedBillIdSet.addAll(draftBillIds);
            this.billLockCache.lock(this.selectedBillIdSet);
        } else {
            logger.info("\u7ec4\u7ec7 {} \u7684\u3010\u662f\u5426\u4e8c\u5f00\u9009\u7968\u3011\u5f00\u5173\u4e3a\u3010\u5173\u95ed\u3011\uff0c\u5f53\u524d\u6267\u884c\u6807\u51c6\u9009\u7968\u903b\u8f91\u3002", (Object)this.orgId);
            this.selectBill(waitScheDataList);
        }
        logger.info("\u9501\u7968ID\uff1a" + this.selectedBillIdSet.stream().map(o -> o.toString()).reduce((a, b) -> "{" + a + "}" + b).orElse(""));
    }

    private boolean isExtendDevelop() {
        String appId = AppMetadataCache.getAppInfo((String)"psd").getId();
        return (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)this.orgId, (String)"secdev");
    }

    private IPayScheBill getSecDevImplClass() {
        IPayScheBill implClass;
        String appId = AppMetadataCache.getAppInfo((String)"psd").getId();
        String implClassStr = (String)TmcParameterHelper.getAppParameter((String)appId, (Long)this.orgId, (String)"implclass");
        if (StringUtils.isEmpty((String)implClassStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e8c\u5f00\u9009\u7968\u5b9e\u73b0\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5230\u4ed8\u6b3e\u6392\u7a0b\u7cfb\u7edf\u53c2\u6570\u4e2d\u914d\u7f6e\u3002", (String)"AutoPayScheBillExecutor_4", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        try {
            Class<?> aClass = Class.forName(implClassStr);
            implClass = (IPayScheBill)aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u68c0\u67e5\u4e8c\u5f00\u9009\u7968\u5b9e\u73b0\u5168\u7c7b\u540d\u662f\u5426\u6b63\u786e\uff0c\u83b7\u53d6\u4e8c\u5f00\u9009\u7968\u5b9e\u73b0\u7c7b\u5f02\u5e38\u3002", (String)"AutoPayScheBillExecutor_5", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        return implClass;
    }

    private void fillBillRuleData(WaitScheData waitScheData) {
        List<Long> bankIdList;
        String paymentChannel;
        DynamicObject settlementType;
        PayScheCalcModel scheData = waitScheData.getPayScheData();
        DynamicObject billRule = waitScheData.getScheRule();
        String selType = billRule.getString("selectsettletype");
        if (SelectSettleTypeEnum.REDEFINESETTLE.getValue().equals(selType) && (settlementType = billRule.getDynamicObject("defaultsettletype")) != null) {
            scheData.setDraftSettleTypeId((Long)settlementType.getPkValue());
        }
        String draftPayMethod = billRule.getString("billpaytype");
        if (!DraftPayTypeEnum.DRAFTPAYPLAN.getValue().equals(draftPayMethod)) {
            scheData.setDraftPayMethod(draftPayMethod);
        }
        if (!"paymentplan".equals(paymentChannel = billRule.getString("paymentchannel"))) {
            scheData.setDraftpaychannel(paymentChannel);
        }
        if (EmptyUtil.isNoEmpty(bankIdList = billRule.getDynamicObjectCollection("selectbank").stream().map(o -> (Long)o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()))) {
            scheData.setLimitbankIds(bankIdList);
        } else if (EmptyUtil.isEmpty(scheData.getLimitbankIdsNoError())) {
            scheData.setLimitbankIds(new ArrayList<Long>(0));
        }
        String draftAccountType = billRule.getString("draftaccounttype");
        if (DraftAccountTypeEnum.REDEFINE.getValue().equals(draftAccountType)) {
            DynamicObject defaultAccount = billRule.getDynamicObject("defaultaccount");
            if (EmptyUtil.isNoEmpty((DynamicObject)defaultAccount)) {
                DynamicObject acctBank;
                DynamicObject targetMappingInfo;
                defaultAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)defaultAccount.getPkValue(), (String)"psd_defaultaccount");
                if (DefaultAccountTypeEnum.BANK.getValue().equals(defaultAccount.get("accounttype")) && EmptyUtil.isNoEmpty((DynamicObject)(targetMappingInfo = PayScheHelper.getDefaultAccount(defaultAccount, scheData))) && EmptyUtil.isNoEmpty((DynamicObject)(acctBank = targetMappingInfo.getDynamicObject("account")))) {
                    scheData.setDraftAcctBankId((Long)acctBank.getPkValue());
                }
            }
        } else if (DraftAccountTypeEnum.PAYMENT.getValue().equals(draftAccountType)) {
            scheData.setDraftAcctBankId(scheData.getApplyAcct());
        }
    }

    private void selectBill(List<WaitScheData> waitSelectBillList) {
        Object[] draftSettleTypeIdArr = (Long[])waitSelectBillList.stream().map(o -> o.getPayScheData().getDraftSettleTypeId()).distinct().toArray(Long[]::new);
        DynamicObject[] settlementTypeArr = TmcDataServiceHelper.load((Object[])draftSettleTypeIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_settlementtype"));
        Map<Long, String> settlementTypeMap = Arrays.stream(settlementTypeArr).collect(Collectors.toMap(o -> (Long)o.getPkValue(), o -> o.getString("settlementtype")));
        Object[] bankIdArr = waitSelectBillList.stream().map(WaitScheData::getPayScheData).flatMap(ps -> ps.getLimitbankIdsNoError().stream()).distinct().toArray();
        DynamicObject[] bankArr = TmcDataServiceHelper.load((Object[])bankIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_bankcgsetting"));
        Map<Long, String> bankCodeMap = Arrays.stream(bankArr).collect(Collectors.toMap(o -> (Long)o.getPkValue(), o -> o.getString("type_code")));
        for (WaitScheData waitScheData : waitSelectBillList) {
            if (!this.canContinueSelectBill()) break;
            String draftPayMethod = waitScheData.getPayScheData().getDraftPayMethod();
            if (DraftPayTypeEnum.DRAFTBOOK.getValue().equals(draftPayMethod)) {
                List<Long> limitBankIds = waitScheData.getPayScheData().getLimitbankIdsNoError();
                ArrayList<String> bankCodeList = new ArrayList<String>();
                if (limitBankIds != null) {
                    bankCodeList.addAll(limitBankIds.stream().map(bankCodeMap::get).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
                }
                this.selectBill(waitScheData, settlementTypeMap.get(waitScheData.getPayScheData().getDraftSettleTypeId()), bankCodeList);
                continue;
            }
            if (!DraftPayTypeEnum.DRAFTPAY.getValue().equals(draftPayMethod)) continue;
            this.selectPayBill(waitScheData, settlementTypeMap.get(waitScheData.getPayScheData().getDraftSettleTypeId()));
        }
        this.billLockCache.lock(this.selectedBillIdSet);
    }

    private void selectBill(WaitScheData waitScheData, String settlementType, List<String> bankCodeList) {
        BigDecimal maxamount;
        ArrayList<Object> sortedBillList;
        Set<Object> billDataSet;
        Long settleTypeId;
        PayScheCalcModel payScheCalcModel = waitScheData.getPayScheData();
        BigDecimal amt = this.getCanSelectAmt(waitScheData.getAmount());
        DynamicObject rule = waitScheData.getScheRule();
        String primeRule = rule.getString("primerule");
        String balanceRule = rule.getString("balancerule");
        BigDecimal limitAmountFloor = rule.getBigDecimal("limitamountfloor");
        BigDecimal limitAmount = rule.getBigDecimal("limitamount");
        String beginDateStr = rule.getString("bookbegin");
        boolean haveBegin = StringUtils.isNotEmpty((String)beginDateStr);
        Date beginDate = DateUtils.truncateDate((Date)DateUtils.getNextMonth((Date)new Date(), (int)(haveBegin ? Integer.parseInt(beginDateStr) : 0)));
        String endDateStr = rule.getString("bookend");
        boolean haveEnd = StringUtils.isNotEmpty((String)endDateStr);
        Date endDate = DateUtils.truncateDate((Date)DateUtils.getNextMonth((Date)new Date(), (int)(haveEnd ? Integer.parseInt(endDateStr) : 0)));
        DynamicObject settleType = rule.getDynamicObject("defaultsettletype");
        Long l = settleTypeId = settleType != null && EmptyUtil.isNoEmpty((DynamicObject)settleType) ? Long.valueOf(settleType.getLong("id")) : null;
        if (SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
            billDataSet = this.bankBills.stream().filter(o -> {
                boolean limitMatch = limitAmount == null || BigDecimal.ZERO.compareTo(limitAmount) == 0 || o.getAvaliableAmount().compareTo(limitAmount) <= 0;
                boolean limitMatchFloor = limitAmountFloor == null || BigDecimal.ZERO.compareTo(limitAmountFloor) == 0 || o.getAvaliableAmount().compareTo(limitAmountFloor) > 0;
                Date date = o.getDate();
                if (date == null) {
                    date = new Date();
                }
                date = DateUtils.truncateDate((Date)date);
                boolean beginDateMatch = !haveBegin || date.compareTo(beginDate) >= 0;
                boolean endDateMatch = !haveEnd || date.compareTo(endDate) <= 0;
                boolean amtMatched = o.getAvaliableAmount().compareTo(amt) <= 0 && BigDecimal.ZERO.compareTo(o.getAvaliableAmount()) < 0;
                boolean bankMatch = CollectionUtils.isEmpty((Collection)bankCodeList) || StringUtils.isEmpty((String)o.getBankCode()) || bankCodeList.stream().anyMatch(t -> o.getBankCode().startsWith((String)t));
                Long currencyId = o.getCurrencyId();
                boolean currencyMatch = currencyId.equals(waitScheData.getPayScheData().getCurrencyId());
                boolean unLockOrCurrLock = !o.isLocked() || this.curScheIdSet.contains(o.getLockSourceId());
                HashSet settleTypeIds = o.getSettleTypeIdLst();
                if (settleTypeIds == null) {
                    settleTypeIds = new HashSet(2);
                }
                if (settleTypeId != null) {
                    boolean isSameSettleType = settleTypeIds.contains(settleTypeId);
                    return limitMatch && limitMatchFloor && beginDateMatch && endDateMatch && amtMatched && bankMatch && currencyMatch && unLockOrCurrLock && isSameSettleType;
                }
                return limitMatch && limitMatchFloor && beginDateMatch && endDateMatch && amtMatched && bankMatch && currencyMatch && unLockOrCurrLock;
            }).collect(Collectors.toSet());
            this.dealLinkSettylementData(billDataSet, payScheCalcModel);
        } else if (SettleMentTypeEnum.BUSINESS.getValue().equals(settlementType)) {
            billDataSet = this.bizBills.stream().filter(o -> {
                boolean limitMatch = limitAmount == null || BigDecimal.ZERO.compareTo(limitAmount) == 0 || o.getAvaliableAmount().compareTo(limitAmount) <= 0;
                boolean limitMatchFloor = limitAmountFloor == null || BigDecimal.ZERO.compareTo(limitAmountFloor) == 0 || o.getAvaliableAmount().compareTo(limitAmountFloor) > 0;
                Date date = o.getDate();
                if (date == null) {
                    date = new Date();
                }
                date = DateUtils.truncateDate((Date)date);
                boolean beginDateMatch = !haveBegin || date.compareTo(beginDate) >= 0;
                boolean endDateMatch = !haveEnd || date.compareTo(endDate) <= 0;
                boolean amtMatched = o.getAvaliableAmount().compareTo(amt) <= 0 && BigDecimal.ZERO.compareTo(o.getAvaliableAmount()) < 0;
                Long currencyId = o.getCurrencyId();
                if (currencyId == null) {
                    return false;
                }
                boolean currencyMatch = currencyId.equals(waitScheData.getPayScheData().getCurrencyId());
                boolean unLockOrCurrLock = !o.isLocked() || this.curScheIdSet.contains(o.getLockSourceId());
                HashSet settleTypeIds = o.getSettleTypeIdLst();
                if (settleTypeIds == null) {
                    settleTypeIds = new HashSet(2);
                }
                if (settleTypeId != null) {
                    boolean isSameSettleType = settleTypeIds.contains(settleTypeId);
                    return limitMatch && limitMatchFloor && beginDateMatch && endDateMatch && amtMatched && currencyMatch && unLockOrCurrLock && isSameSettleType;
                }
                return limitMatch && limitMatchFloor && beginDateMatch && endDateMatch && amtMatched && currencyMatch && unLockOrCurrLock;
            }).collect(Collectors.toSet());
            this.dealLinkSettylementData(billDataSet, payScheCalcModel);
        } else {
            return;
        }
        if (billDataSet.isEmpty()) {
            return;
        }
        PluginProxy pluginProxy = PluginProxy.create(IPayScheduleSelectBill.class, (String)"kd.sdk.tmc.psd.extpoint.IPayScheduleSelectBill.selectBills");
        Set<Object> finalBillDataSet = billDataSet;
        List result = pluginProxy.callReplace(proxy -> proxy.selectBills(this.createSelectBillParam(payScheCalcModel, finalBillDataSet)));
        logger.info("[\u4ed8\u6b3e\u6392\u7a0b\u9009\u7968\u89c4\u5219\u9009\u7968\u4e8c\u5f00\u6269\u5c55]\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)result);
        if (EmptyUtil.isNoEmpty((Object)result) && result.get(0) != null) {
            Set filterBillIds = (Set)result.get(0);
            billDataSet = filterBillIds.size() > 0 ? DraftBillProvider.getInstance().getDraftBills(Collections.singletonList(new QFilter("id", "in", (Object)filterBillIds))) : new HashSet(8);
        }
        if (billDataSet == null || billDataSet.isEmpty()) {
            return;
        }
        boolean isSelectLinkBills = rule.getBoolean("issellinkedbills");
        if (isSelectLinkBills) {
            List linkedBills = billDataSet.stream().filter(o -> "bei".equals(o.getSourceSys())).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(linkedBills)) {
                billDataSet.clear();
                billDataSet.addAll(linkedBills);
            }
        } else {
            List nonLinkedBills = billDataSet.stream().filter(o -> !"bei".equals(o.getSourceSys())).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(nonLinkedBills)) {
                billDataSet.clear();
                billDataSet.addAll(nonLinkedBills);
            }
        }
        if (billDataSet.isEmpty()) {
            return;
        }
        if (BillRulePrimeEnum.AMOUNT.getValue().equals(primeRule)) {
            sortedBillList = new ArrayList<Object>(billDataSet);
            boolean isDatePriority = rule.getBoolean("isdatepriority");
            if (isDatePriority) {
                sortedBillList.sort(Comparator.comparing(DraftBillCoreData::getAvaliableAmount, Comparator.reverseOrder()).thenComparing(DraftBillCoreData::getDate, Comparator.reverseOrder()));
            } else {
                sortedBillList.sort(Comparator.comparing(DraftBillCoreData::getAvaliableAmount, Comparator.reverseOrder()).thenComparing(DraftBillCoreData::getDate));
            }
        } else if (BillRulePrimeEnum.DATE.getValue().equals(primeRule)) {
            sortedBillList = new ArrayList<Object>(billDataSet);
            boolean isAmtPriority = rule.getBoolean("isamtpriority");
            if (isAmtPriority) {
                sortedBillList.sort(Comparator.comparing(DraftBillCoreData::getDate, Comparator.reverseOrder()).thenComparing(DraftBillCoreData::getAvaliableAmount, Comparator.reverseOrder()));
            } else {
                sortedBillList.sort(Comparator.comparing(DraftBillCoreData::getDate, Comparator.reverseOrder()).thenComparing(DraftBillCoreData::getAvaliableAmount));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u52a8\u9009\u7968\u89c4\u5219\u4e0d\u652f\u6301\u3002", (String)"AutoPayScheBillExecutor_2", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        BigDecimal balance = amt;
        BigDecimal minAmt = sortedBillList.stream().map(DraftBillCoreData::getAvaliableAmount).min(BigDecimal::compareTo).orElseGet(() -> BigDecimal.ZERO);
        HashSet<DraftBillCoreData> currSelectBillSet = new HashSet<DraftBillCoreData>();
        for (DraftBillCoreData draftBillCoreData : sortedBillList) {
            BigDecimal billAmt = draftBillCoreData.getAvaliableAmount();
            if (billAmt.compareTo(balance) <= 0) {
                currSelectBillSet.add(draftBillCoreData);
                balance = balance.subtract(billAmt);
            }
            if (BigDecimal.ZERO.compareTo(balance) != 0 && minAmt.compareTo(balance) <= 0) continue;
            break;
        }
        if ((maxamount = rule.getBigDecimal("maxamount")) != null && maxamount.compareTo(BigDecimal.ZERO) != 0 && balance.compareTo(maxamount) > 0) {
            return;
        }
        payScheCalcModel.setDraftBillIds(currSelectBillSet.stream().map(DraftBillCoreData::getId).collect(Collectors.toList()));
        payScheCalcModel.setDraftBillAmt(amt.subtract(balance));
        this.subtractAmt(payScheCalcModel.getDraftBillAmt());
        if (SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
            this.bankBills.removeAll(currSelectBillSet);
        } else if (SettleMentTypeEnum.BUSINESS.getValue().equals(settlementType)) {
            this.bizBills.removeAll(currSelectBillSet);
        }
        this.selectedBillIdSet.addAll(currSelectBillSet.stream().map(DraftBillCoreData::getId).collect(Collectors.toSet()));
        currSelectBillSet.stream().filter(Objects::nonNull).forEach(o -> {
            Set settleTypeIdLst = o.getSettleTypeIdLst();
            if (settleTypeIdLst.contains(payScheCalcModel.getDraftSettleTypeId())) {
                this.selectLinkSettypementIds.add(payScheCalcModel.getDraftSettleTypeId());
            }
        });
        if (balance.compareTo(BigDecimal.ZERO) > 0) {
            if (BillRuleBalanceEnum.NEW_BILL.getValue().equals(balanceRule)) {
                DynamicObject dynamicObject = rule.getDynamicObject("scheticketrule");
                if (EmptyUtil.isNoEmpty((DynamicObject)dynamicObject)) {
                    waitScheData.setNeedDoBillSche(true);
                    waitScheData.setBalance(balance);
                    waitScheData.setScheRule(TmcDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_queueticket_rule")));
                }
            } else if (BillRuleBalanceEnum.TRANS_FUND.getValue().equals(balanceRule)) {
                DynamicObject dynamicObject = rule.getDynamicObject("schepayrule");
                if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) {
                    payScheCalcModel.setScheAmt(payScheCalcModel.getScheAmt().add(balance));
                    this.subtractAmt(balance);
                } else {
                    waitScheData.setNeedDoFundSche(true);
                    waitScheData.setBalance(balance);
                    waitScheData.setScheRule(TmcDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_payment_rule")));
                }
            } else if (!BillRuleBalanceEnum.IGNORE.getValue().equals(balanceRule)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6392\u7968\u5dee\u989d\u5904\u7406\u4e0d\u652f\u6301\u3002", (String)"AutoPayScheBillExecutor_3", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
        }
    }

    private SelectBillParam createSelectBillParam(PayScheCalcModel payScheCalcModel, Set<DraftBillCoreData> billDataSet) {
        PayScheduleInfo payScheduleInfo = this.transCalcModelToPayScheduleInfo(payScheCalcModel);
        SelectBillParam param = new SelectBillParam(payScheduleInfo);
        List<PayScheCalcModel> mergeScheduleList = payScheCalcModel.getMergeScheduleList();
        if (EmptyUtil.isNoEmpty(mergeScheduleList)) {
            param.setMergeScheduleList(mergeScheduleList.stream().map(this::transCalcModelToPayScheduleInfo).collect(Collectors.toList()));
        }
        param.setSelectBillIds(billDataSet.stream().map(DraftBillCoreData::getId).collect(Collectors.toSet()));
        return param;
    }

    public PayScheduleInfo transCalcModelToPayScheduleInfo(PayScheCalcModel payScheCalcModel) {
        HashMap dataMap = new HashMap(10);
        PayScheduleInfo payScheduleInfo = new PayScheduleInfo(dataMap);
        payScheCalcModel.getDataMap().forEach((k, v) -> {
            PaySchedulePropVal propVal = new PaySchedulePropVal();
            propVal.setScheCalcProp(v.getScheCalcProp());
            propVal.setScheProp(v.getScheProp());
            propVal.setData(v.getData());
            dataMap.put(k, propVal);
        });
        return payScheduleInfo;
    }

    private void selectPayBill(WaitScheData waitScheData, String settlementType) {
        Set<Object> billDataSet;
        PayScheCalcModel payScheCalcModel = waitScheData.getPayScheData();
        BigDecimal amt = this.getCanSelectAmt(waitScheData.getAmount());
        DynamicObject rule = waitScheData.getScheRule();
        if (!rule.getBoolean("ispayselectbook") || rule.getBoolean("ispayselectbook") && this.oneKeySche) {
            logger.info("\u5f00\u7968\u4ed8\u6b3e\u9009\u7968\u672a\u5f00\u542f");
            waitScheData.getPayScheData().setDraftBillAmt(amt);
            this.subtractAmt(amt);
            return;
        }
        if (SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
            billDataSet = this.bankPayBills.stream().filter(o -> {
                String recName = o.getRecName();
                boolean recNameMatch = recName.equals(waitScheData.getPayScheData().getPayeeName());
                Long currencyId = o.getCurrencyId();
                boolean currencyMatch = currencyId.equals(waitScheData.getPayScheData().getCurrencyId());
                boolean unLockOrCurrLock = !o.isLocked() || this.curScheIdSet.contains(o.getLockSourceId());
                return recNameMatch && currencyMatch && unLockOrCurrLock;
            }).collect(Collectors.toSet());
            this.dealLinkSettylementData(billDataSet, payScheCalcModel);
        } else if (SettleMentTypeEnum.BUSINESS.getValue().equals(settlementType)) {
            billDataSet = this.bizPayBills.stream().filter(o -> {
                String recName = o.getRecName();
                boolean recNameMatch = recName.equals(waitScheData.getPayScheData().getPayeeName());
                Long currencyId = o.getCurrencyId();
                boolean currencyMatch = currencyId.equals(waitScheData.getPayScheData().getCurrencyId());
                boolean unLockOrCurrLock = !o.isLocked() || this.curScheIdSet.contains(o.getLockSourceId());
                return recNameMatch && currencyMatch && unLockOrCurrLock;
            }).collect(Collectors.toSet());
            this.dealLinkSettylementData(billDataSet, payScheCalcModel);
        } else {
            return;
        }
        if (billDataSet.isEmpty()) {
            return;
        }
        ArrayList<Object> sortedBillList = new ArrayList<Object>(billDataSet);
        sortedBillList.sort(Comparator.comparing(DraftBillCoreData::getAvaliableAmount).reversed());
        BigDecimal balance = amt;
        BigDecimal minAmt = sortedBillList.stream().map(DraftBillCoreData::getAvaliableAmount).min(BigDecimal::compareTo).orElseGet(() -> BigDecimal.ZERO);
        HashSet<DraftBillCoreData> currSelectBillSet = new HashSet<DraftBillCoreData>();
        for (DraftBillCoreData draftBillCoreData : sortedBillList) {
            BigDecimal billAmt = draftBillCoreData.getAvaliableAmount();
            if (billAmt.compareTo(balance) <= 0) {
                currSelectBillSet.add(draftBillCoreData);
                balance = balance.subtract(billAmt);
            }
            if (BigDecimal.ZERO.compareTo(balance) != 0 && minAmt.compareTo(balance) <= 0) continue;
            break;
        }
        if (balance.compareTo(BigDecimal.ZERO) != 0) {
            return;
        }
        payScheCalcModel.setDraftBillIds(currSelectBillSet.stream().map(DraftBillCoreData::getId).collect(Collectors.toList()));
        payScheCalcModel.setDraftBillAmt(amt.subtract(balance));
        this.subtractAmt(payScheCalcModel.getDraftBillAmt());
        if (SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
            this.bankPayBills.removeAll(currSelectBillSet);
        } else if (SettleMentTypeEnum.BUSINESS.getValue().equals(settlementType)) {
            this.bizPayBills.removeAll(currSelectBillSet);
        }
        this.selectedBillIdSet.addAll(currSelectBillSet.stream().map(DraftBillCoreData::getId).collect(Collectors.toSet()));
        currSelectBillSet.stream().filter(Objects::nonNull).forEach(o -> {
            Set settleTypeIdLst = o.getSettleTypeIdLst();
            if (settleTypeIdLst.contains(payScheCalcModel.getDraftSettleTypeId())) {
                this.selectLinkSettypementIds.add(payScheCalcModel.getDraftSettleTypeId());
            }
        });
    }

    private void subtractAmt(BigDecimal amt) {
        if (this.totalAmt != null) {
            this.totalAmt = this.totalAmt.subtract(amt);
        }
    }

    private boolean canContinueSelectBill() {
        return this.totalAmt == null || this.totalAmt.compareTo(BigDecimal.ZERO) > 0;
    }

    private BigDecimal getCanSelectAmt(BigDecimal amt) {
        return this.totalAmt == null ? amt : amt.min(this.totalAmt);
    }

    private void dealLinkSettylementData(Set<DraftBillCoreData> billDataSet, PayScheCalcModel payScheCalcModel) {
        if (null == billDataSet || 0 == billDataSet.size()) {
            return;
        }
        Set temp = billDataSet.stream().filter(Objects::nonNull).filter(o -> {
            Set settleTypeList = o.getSettleTypeIdLst();
            if (null == settleTypeList || settleTypeList.size() == 0) {
                return false;
            }
            return settleTypeList.contains(payScheCalcModel.getDraftSettleTypeId());
        }).collect(Collectors.toSet());
        if (null != temp && temp.size() > 0) {
            billDataSet.clear();
            billDataSet.addAll(temp);
            return;
        }
        if (this.selectLinkSettypementIds.contains(payScheCalcModel.getDraftSettleTypeId())) {
            billDataSet.clear();
        }
    }
}

