/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.controller;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.helper.TmcAmountHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.IPayScheProcessorView;
import kd.tmc.psd.business.service.paysche.IPayScheService;
import kd.tmc.psd.business.service.paysche.ISumScheService;
import kd.tmc.psd.business.service.paysche.autosche.bill.DraftBillLockCache;
import kd.tmc.psd.business.service.paysche.controller.PayScheFormOperate;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessResult;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheDraftInfo;
import kd.tmc.psd.business.service.paysche.data.sum.SumScheData;
import kd.tmc.psd.business.service.paysche.repo.PayScheDataRepository;
import kd.tmc.psd.business.service.paysche.service.PayScheServiceFactory;
import kd.tmc.psd.business.service.paysche.sumsche.data.SumScheInfo;
import kd.tmc.psd.common.enums.MergeTypeEnum;
import kd.tmc.psd.common.untils.StringUtils;

public abstract class PayScheCalcBaseHandler<T extends SumScheData> {
    protected PayScheDataRepository<T> dataRepository;
    protected IPayScheService payScheService;

    public PayScheCalcBaseHandler(String pageId) {
        Type superClass = this.getClass().getGenericSuperclass();
        Type type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        this.dataRepository = new PayScheDataRepository(pageId, type);
        this.payScheService = PayScheServiceFactory.getPayScheService();
    }

    protected void initData(List<PayScheCalcModel> dataList) {
        this.dataRepository.clearCurrSumId();
        this.reloadData(dataList);
        new DraftBillLockCache(this.getView().getPageId()).releaseAll();
    }

    protected void reloadData(List<PayScheCalcModel> dataList) {
        Map scaleMap = TmcAmountHelper.getScaleMap(dataList.stream().map(PayScheCalcModel::getCurrencyId).collect(Collectors.toSet()));
        HashMap<String, BigDecimal> batchScheAmount = new HashMap<String, BigDecimal>(16);
        for (PayScheCalcModel payScheCalcModel : dataList) {
            payScheCalcModel.reCalcBalance((Integer)scaleMap.get(payScheCalcModel.getCurrencyId()));
            this.calSingleAmount(batchScheAmount, payScheCalcModel);
        }
        this.changeMergeAmount(dataList, batchScheAmount);
        List sumDataList = this.getSumScheService().loadSummaryData(dataList);
        this.dataRepository.saveAll(sumDataList, dataList);
        this.getView().updateSummaryInfo(sumDataList, true);
    }

    public void directUpdateDataList(List<PayScheCalcModel> needUpdateDataList) {
        List allScheDataList = this.dataRepository.getAllScheDataList();
        Map<Long, PayScheCalcModel> scheDataMap = allScheDataList.stream().collect(Collectors.toMap(o -> o.getScheId(), o -> o, (a, b) -> a));
        ArrayList<PayScheCalcModel> newDataList = new ArrayList<PayScheCalcModel>();
        for (PayScheCalcModel needUpdateData : needUpdateDataList) {
            PayScheCalcModel oldScheData = scheDataMap.get(needUpdateData.getScheId());
            if (oldScheData != null) {
                oldScheData.replaceData(needUpdateData);
                continue;
            }
            newDataList.add(needUpdateData);
        }
        allScheDataList.addAll(newDataList);
        this.reloadData(allScheDataList);
    }

    public void directUpdateData(List<PayScheCalcModel> needDeleteDataList) {
        if (EmptyUtil.isNoEmpty(needDeleteDataList)) {
            List<PayScheCalcModel> allScheDataList = this.dataRepository.getAllScheDataList();
            allScheDataList = allScheDataList.stream().filter(Objects::nonNull).filter(o -> !o.isArchiveMerger()).collect(Collectors.toList());
            Set deleteScheBillNoSet = needDeleteDataList.stream().map(s -> s.getCalcPropVal("e_billno").toString()).collect(Collectors.toSet());
            allScheDataList.removeIf(scheData -> deleteScheBillNoSet.contains(scheData.getCalcPropVal("e_billno").toString()));
            this.reloadData(allScheDataList);
        }
    }

    public void loadScheDataList(Long sumId) {
        this.dataRepository.setCurrSumId(sumId);
        List scheDataList = this.dataRepository.getScheDataList(sumId);
        this.getView().updateScheDataList(scheDataList, true);
    }

    public void autoSchedule() {
        this.doScheFormOperate((PayScheFormOperate)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void sumSchedule(Long sumId, SumScheInfo sumScheInfo) {
        this.doScheFormOperate((PayScheFormOperate)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<Long> updateScheInfo(Long sumId, List<PayScheCalcModel> payScheDataList, String pageId, String changeProp, boolean isMergerArchive, BigDecimal draftTransAmounts) {
        List scheIdList = payScheDataList.stream().map(PayScheCalcModel::getScheId).collect(Collectors.toList());
        PayScheProcessResult result = this.doScheFormOperate((PayScheFormOperate)new /* Unavailable Anonymous Inner Class!! */);
        return (List)result.getResult();
    }

    private void dealMergeDraftChg(List<PayScheCalcModel> needUpdateScheDataLst, String changeProp, List<PayScheCalcModel> payScheDataList) {
        if (StringUtils.isEmpty((String)changeProp) || !"mergeDraftChg".equals(changeProp)) {
            return;
        }
        Map scheIdToMap = needUpdateScheDataLst.stream().collect(Collectors.toMap(PayScheCalcModel::getScheId, Function.identity(), (a, b) -> a));
        for (Map.Entry sche : scheIdToMap.entrySet()) {
            Long scheId = sche.getKey();
            PayScheCalcModel payScheCalcModel = (PayScheCalcModel)sche.getValue();
            for (PayScheCalcModel psc : payScheDataList) {
                List<PayScheDraftInfo> draftInfos;
                Long pscId = psc.getScheId();
                if (pscId.compareTo(scheId) != 0 || (draftInfos = payScheCalcModel.getPayScheDraftInfos()) == null || draftInfos.size() == 0) continue;
                List<PayScheDraftInfo> payScheDraftInfos = psc.getPayScheDraftInfos();
                if (payScheDraftInfos != null && payScheDraftInfos.size() > 0) {
                    payScheDraftInfos.clear();
                } else {
                    payScheDraftInfos = new ArrayList<PayScheDraftInfo>(16);
                }
                payScheDraftInfos.addAll(draftInfos);
                psc.setPayScheDraftInfos(payScheDraftInfos);
                List<Long> draftBillIds = payScheDraftInfos.stream().map(o -> o.getDraftId()).collect(Collectors.toList());
                if (psc.getDraftBillIds() != null) {
                    psc.getDraftBillIds().clear();
                }
                psc.setDraftBillIds(draftBillIds);
            }
        }
    }

    public void autoFillPayInfo(Long fillId, Long sumId, List<Long> scheIdList) {
        this.doScheFormOperate((PayScheFormOperate)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void autoFillTradeBillInfo(Long fillId, Long sumId, List<Long> scheIdList) {
        this.doScheFormOperate((PayScheFormOperate)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void transToNextPeriod(Long sumId, List<Long> scheIdList) {
        this.doScheFormOperate((PayScheFormOperate)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void cancelTrans(Long sumId, List<Long> scheIdList) {
        this.doScheFormOperate((PayScheFormOperate)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void refusePay(Long sumId, List<Long> scheIdList) {
        this.doScheFormOperate((PayScheFormOperate)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void cancelRefusePay(Long sumId, List<Long> scheIdList) {
        this.doScheFormOperate((PayScheFormOperate)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<PayScheCalcModel> getAllScheDataList() {
        return this.dataRepository.getAllScheDataList();
    }

    public List<PayScheCalcModel> getAllCombineDataList(String combineNum) {
        List allScheDataList = this.dataRepository.getAllScheDataList();
        return allScheDataList.stream().filter(o -> Objects.equals(o.getBatchnum(), combineNum)).collect(Collectors.toList());
    }

    public List<PayScheCalcModel> getAllCombineDataList() {
        List allScheDataList = this.dataRepository.getAllScheDataList();
        return allScheDataList.stream().filter(o -> EmptyUtil.isNotEmpty((CharSequence)o.getBatchnum())).collect(Collectors.toList());
    }

    public void release() {
        this.dataRepository.clearCache();
        DraftBillLockCache cache = new DraftBillLockCache(this.getView().getPageId());
        cache.releaseAll();
    }

    public void clearDraftBillCache() {
        new DraftBillLockCache(this.getView().getPageId()).releaseAll();
    }

    /*
     * WARNING - void declaration
     */
    protected <R> PayScheProcessResult<R> doScheFormOperate(PayScheFormOperate<T, R> operate) {
        List scheOldDataList = new ArrayList(10);
        List<SumScheData> scheSumInfoList = new ArrayList<SumScheData>();
        if (operate.isEntireOperate()) {
            Long sumId = operate.getSumId();
            if (sumId != null) {
                scheOldDataList = this.dataRepository.getScheDataList(operate.getSumId());
                scheSumInfoList.add(this.dataRepository.getScheSumInfo(operate.getSumId()));
            } else {
                scheOldDataList = this.dataRepository.getAllScheDataList();
                scheSumInfoList = this.dataRepository.getAllScheSumInfoList();
            }
        } else {
            scheOldDataList = this.dataRepository.getScheDataList(operate.getSumId(), operate.getScheIdList());
            if (Long.valueOf(-1L).compareTo(operate.getSumId()) != 0) {
                scheSumInfoList.add(this.dataRepository.getScheSumInfo(operate.getSumId()));
            }
        }
        operate.beforeDoOpreation(scheOldDataList);
        List scheIdList = operate.getScheIdList();
        if (operate.isMergerArchive()) {
            List batchNums = scheOldDataList.stream().filter(Objects::nonNull).filter(o -> scheIdList.contains(o.getScheId())).map(PayScheCalcModel::getBatchnum).collect(Collectors.toList());
            for (String batchNum : batchNums) {
                List payScheDataByBatchNum = this.dataRepository.getPayScheDataByBatchNum(batchNum);
                scheOldDataList.addAll(payScheDataByBatchNum);
            }
        }
        operate.filterScheData(scheOldDataList);
        List<PayScheCalcModel> needUpdateNewData = scheOldDataList.stream().map(PayScheCalcModel::serialize).map(PayScheCalcModel::deserialize).collect(Collectors.toList());
        PayScheProcessResult result = operate.doOperate(scheSumInfoList, needUpdateNewData);
        operate.afterDoOpreation(needUpdateNewData);
        ArrayList<PayScheCalcModel> needDeleteDataList = result.getNeedDeleteDataList();
        if (needDeleteDataList == null) {
            needDeleteDataList = new ArrayList<PayScheCalcModel>();
        }
        needUpdateNewData.removeAll(needDeleteDataList);
        if (result.isSuccess() || result.isStrictValidate()) {
            // empty if block
        }
        if (result.isNeedConfirm()) {
            return result;
        }
        HashMap<String, List<PayScheCalcModel>> mergePaySches = new HashMap<String, List<PayScheCalcModel>>(16);
        HashMap<String, List<PayScheCalcModel>> cancleMergePaySches = new HashMap<String, List<PayScheCalcModel>>(16);
        Map<Long, List<PayScheCalcModel>> updatePayScheMap = needUpdateNewData.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getScheId()));
        for (PayScheCalcModel bakPaySche : scheOldDataList) {
            void var18_29;
            boolean exist;
            Object upBatchNum;
            List<PayScheCalcModel> updatePaySches = updatePayScheMap.get(bakPaySche.getScheId());
            if (updatePaySches == null || updatePaySches.size() <= 0) continue;
            PayScheCalcModel updatePaySche = updatePaySches.get(0);
            String bakBatchNum = Optional.ofNullable(bakPaySche.getBatchnum()).map(o -> o.trim()).orElseGet(() -> "");
            if (bakBatchNum.equals(upBatchNum = Optional.ofNullable(updatePaySche.getBatchnum()).map(o -> o.trim()).orElseGet(() -> ""))) continue;
            if (EmptyUtil.isNoEmpty((String)upBatchNum)) {
                void var18_25;
                exist = mergePaySches.containsKey(upBatchNum);
                Object var18_22 = null;
                if (exist) {
                    List list = (List)mergePaySches.get(upBatchNum);
                } else {
                    ArrayList arrayList = new ArrayList(10);
                }
                var18_25.add(updatePaySche);
                mergePaySches.put((String)upBatchNum, (List<PayScheCalcModel>)var18_25);
                continue;
            }
            exist = cancleMergePaySches.containsKey(bakBatchNum);
            Object var18_26 = null;
            if (exist) {
                List list = (List)cancleMergePaySches.get(bakBatchNum);
            } else {
                ArrayList arrayList = new ArrayList(10);
            }
            var18_29.add(updatePaySche);
            cancleMergePaySches.put(bakBatchNum, (List<PayScheCalcModel>)var18_29);
        }
        ArrayList<PayScheCalcModel> upPaySches = new ArrayList<PayScheCalcModel>(10);
        if (mergePaySches != null && mergePaySches.size() > 0) {
            this.updateVirtMergerPayScheModel(mergePaySches, upPaySches, needDeleteDataList, MergeTypeEnum.MERGE);
        }
        if (cancleMergePaySches != null && cancleMergePaySches.size() > 0) {
            this.updateVirtMergerPayScheModel(cancleMergePaySches, upPaySches, needDeleteDataList, MergeTypeEnum.CANCLE_MERGE);
        }
        if (upPaySches != null && upPaySches.size() > 0) {
            List changeIds = upPaySches.stream().filter(Objects::nonNull).map(PayScheCalcModel::getScheId).collect(Collectors.toList());
            needUpdateNewData = needUpdateNewData.stream().filter(Objects::nonNull).filter(o -> !changeIds.contains(o.getScheId())).collect(Collectors.toList());
            needUpdateNewData.addAll(upPaySches);
        }
        if (needDeleteDataList != null && needDeleteDataList.size() > 0) {
            Set delIds = needDeleteDataList.stream().filter(Objects::nonNull).map(PayScheCalcModel::getScheId).collect(Collectors.toSet());
            List tureUpPaySches = needUpdateNewData.stream().filter(Objects::nonNull).filter(o -> !delIds.contains(o.getScheId())).collect(Collectors.toList());
            needUpdateNewData.clear();
            needUpdateNewData.addAll(tureUpPaySches);
        }
        Map scaleMap = TmcAmountHelper.getScaleMap(needUpdateNewData.stream().map(PayScheCalcModel::getCurrencyId).collect(Collectors.toSet()));
        ArrayList<String> updateProps = new ArrayList<String>(10);
        updateProps.add("e_fundflowitem");
        updateProps.add("e_department");
        updateProps.add("e_project");
        ArrayList<PayScheCalcModel> waitUpVirPaySches = new ArrayList<PayScheCalcModel>(10);
        HashMap<String, BigDecimal> batchScheAmount = new HashMap<String, BigDecimal>(16);
        for (PayScheCalcModel scheData : needUpdateNewData) {
            scheData.reCalcBalance((Integer)scaleMap.get(scheData.getCurrencyId()));
            if (scheIdList != null && scheIdList.contains(scheData.getScheId()) && scheData.isMasterData()) {
                void var19_38;
                Optional<PayScheCalcModel> optional = needUpdateNewData.stream().filter(PayScheCalcModel::isArchiveMerger).filter(o -> scheData.getBatchnum().equals(o.getBatchnum())).findFirst();
                Object var19_39 = null;
                if (optional.isPresent()) {
                    PayScheCalcModel payScheCalcModel = optional.get();
                } else {
                    PayScheCalcModel payScheCalcModel = this.dataRepository.getVirtualPaySche(Long.valueOf(-1L), scheData.getBatchnum());
                }
                if (var19_38 != null) {
                    var19_38.updateData(scheData, updateProps);
                    waitUpVirPaySches.add((PayScheCalcModel)var19_38);
                }
            }
            this.calSingleAmount(batchScheAmount, scheData);
        }
        this.changeMergeAmount(needUpdateNewData, batchScheAmount);
        this.addNewPaySches(needUpdateNewData, waitUpVirPaySches);
        this.getSumScheService().calculateSumInfo(scheSumInfoList, scheOldDataList, needUpdateNewData, needDeleteDataList);
        operate.updateCacheBeforeOpreation(needUpdateNewData);
        Map<Long, List<PayScheCalcModel>> sumIdMap = needUpdateNewData.stream().collect(Collectors.groupingBy(PayScheCalcModel::getSummaryId));
        for (Map.Entry<Long, List<PayScheCalcModel>> entry : sumIdMap.entrySet()) {
            Long l = entry.getKey();
            ArrayList needUpdateScheDataList = new ArrayList(entry.getValue());
            List needInsertDataList = needUpdateScheDataList.stream().filter(PayScheCalcModel::isNewScheData).collect(Collectors.toList());
            if (needInsertDataList.size() > 0) {
                List realInsertDataList = this.dataRepository.isNewScheData(l, needInsertDataList);
                Set realInsertDataIdSet = realInsertDataList.stream().map(PayScheCalcModel::getScheId).collect(Collectors.toSet());
                for (PayScheCalcModel payScheCalcModel : needInsertDataList) {
                    if (!realInsertDataIdSet.contains(payScheCalcModel.getScheId())) continue;
                    needUpdateScheDataList.remove(payScheCalcModel);
                }
                if (realInsertDataList.size() > 0) {
                    this.dataRepository.insertScheDataList(l, realInsertDataList);
                }
            }
            if (needUpdateScheDataList.size() <= 0) continue;
            this.dataRepository.updateScheDataList(l, needUpdateScheDataList);
        }
        if (needDeleteDataList.size() > 0) {
            Map<Long, List<PayScheCalcModel>> needDeleteDataMap = needDeleteDataList.stream().collect(Collectors.groupingBy(PayScheCalcModel::getSummaryId));
            for (Map.Entry<Long, List<PayScheCalcModel>> entry : needDeleteDataMap.entrySet()) {
                this.dataRepository.removeScheDataList(entry.getKey(), entry.getValue().stream().map(PayScheCalcModel::getScheId).collect(Collectors.toList()));
            }
        }
        if (result.isReload()) {
            List reloadScheDataList = this.dataRepository.getAllScheDataList();
            List list = this.getSumScheService().rebuildSummaryData(reloadScheDataList);
            this.dataRepository.saveAll(list, reloadScheDataList);
            this.dataRepository.clearCurrSumId();
            this.getView().updateSummaryInfo(list, true);
            if (list.size() == 0) {
                this.getView().updateScheDataList(new ArrayList(), true);
            }
        } else {
            if (scheSumInfoList.size() > 0) {
                this.dataRepository.updateScheSumInfo(scheSumInfoList);
                this.getView().updateSummaryInfo(scheSumInfoList, false);
            }
            if (operate.isEntireOperate()) {
                Long sumId = operate.getSumId();
                if (sumId == null) {
                    sumId = this.dataRepository.getCurrSumId();
                }
                if (sumId != null) {
                    ArrayList<PayScheCalcModel> arrayList = new ArrayList<PayScheCalcModel>();
                    for (PayScheCalcModel needUpdateData : needUpdateNewData) {
                        if (!needUpdateData.getSummaryId().equals(sumId)) continue;
                        arrayList.add(needUpdateData);
                    }
                    if (arrayList.size() > 0) {
                        this.getView().updateScheDataList(arrayList, false);
                    }
                }
            } else if (needUpdateNewData.size() > 0) {
                this.getView().updateScheDataList(needUpdateNewData, false);
            }
            if (needDeleteDataList.size() > 0) {
                this.getView().deleteScheData(needDeleteDataList);
            }
        }
        if (!result.isSuccess()) {
            this.getView().showErrorMessage(result.getErrMsgList());
        } else if (operate.getOpName() != null) {
            this.getView().showSuccessMessage(String.format(ResManager.loadKDString((String)"%s\u64cd\u4f5c\u6210\u529f", (String)"PayScheProcessorHandler_08", (String)"tmc-psd-business", (Object[])new Object[0]), operate.getOpName()));
        }
        return result;
    }

    public void freeze(Long sumId, List<Long> scheIdList, boolean isRemove, boolean isMegerArchivePaySche) {
        scheIdList = scheIdList.stream().distinct().collect(Collectors.toList());
        this.doScheFormOperate((PayScheFormOperate)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void thaw(Long sumId, List<Long> scheIdList, Date userExpectDate, boolean isMegerArchivePaySche) {
        this.doScheFormOperate((PayScheFormOperate)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateVirtMergerPayScheModel(Map<String, List<PayScheCalcModel>> scheDataMap, List<PayScheCalcModel> upPaySches, List<PayScheCalcModel> deletePaySches, MergeTypeEnum mergeType) {
        for (Map.Entry<String, List<PayScheCalcModel>> combinePayScheEntry : scheDataMap.entrySet()) {
            String batchnum = combinePayScheEntry.getKey();
            List<PayScheCalcModel> paySches = combinePayScheEntry.getValue();
            PayScheCalcModel virPaySche = null;
            if (MergeTypeEnum.MERGE == mergeType) {
                virPaySche = this.dataRepository.getVirtualPaySche(Long.valueOf(-1L), batchnum);
                if (virPaySche == null) {
                    virPaySche = PayScheCalcModel.createVirtualPaySche(paySches, false);
                } else {
                    BigDecimal applyAmtTotal = paySches.stream().filter(Objects::nonNull).map(PayScheCalcModel::getApplyAmt).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.ZERO);
                    applyAmtTotal = applyAmtTotal.add(virPaySche.getApplyAmt());
                    virPaySche.setApplyAmt(applyAmtTotal);
                    int oldMergerCnt = virPaySche.getMergerCnt() != null ? virPaySche.getMergerCnt() : 0;
                    virPaySche.setMergerCnt(oldMergerCnt + paySches.size());
                }
                upPaySches.add(virPaySche);
                continue;
            }
            if (MergeTypeEnum.CANCLE_MERGE != mergeType) continue;
            Optional<PayScheCalcModel> existArchiveMegerData = paySches.stream().filter(Objects::nonNull).filter(PayScheCalcModel::isArchiveMerger).findAny();
            if (existArchiveMegerData.isPresent()) {
                virPaySche = existArchiveMegerData.get();
                List payScheByBatchNums = this.dataRepository.getPayScheDataByBatchNum(batchnum);
                for (PayScheCalcModel payScheByBatchNum : payScheByBatchNums) {
                    payScheByBatchNum.setBatchnum(null);
                    payScheByBatchNum.setMasterDataId(null);
                    payScheByBatchNum.setArchiveMerger(false);
                    payScheByBatchNum.setMasterData(false);
                }
                upPaySches.addAll(payScheByBatchNums);
                deletePaySches.add(virPaySche);
                continue;
            }
            virPaySche = this.dataRepository.getVirtualPaySche(Long.valueOf(-1L), batchnum);
            String tips = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5408\u5e76\u6279\u6b21\u53f7\u201c%s\u201d\u5bf9\u5e94\u7684\u865a\u62df\u5408\u5e76\u6392\u7a0b\u5355\u6570\u636e\u3002", (String)"PayScheCalcBaseHandler_01", (String)"tmc-psd-business", (Object[])new Object[0]);
            if (virPaySche == null) {
                throw new KDBizException(String.format(tips, batchnum));
            }
            Integer mergerCnt = virPaySche.getMergerCnt();
            Integer currCnt = mergerCnt - paySches.size();
            if (currCnt == 0 || currCnt == 1) {
                deletePaySches.add(virPaySche);
                List payScheDataByBatchNum = this.dataRepository.getPayScheDataByBatchNum(batchnum);
                for (PayScheCalcModel payScheCalcModel : payScheDataByBatchNum) {
                    payScheCalcModel.setMasterData(false);
                    payScheCalcModel.setArchiveMerger(false);
                    payScheCalcModel.setBatchnum(null);
                    payScheCalcModel.setMasterDataId(null);
                }
                upPaySches.addAll(payScheDataByBatchNum);
                continue;
            }
            BigDecimal applyAmtTotal = paySches.stream().filter(Objects::nonNull).map(PayScheCalcModel::getApplyAmt).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.ZERO);
            applyAmtTotal = virPaySche.getApplyAmt().subtract(applyAmtTotal);
            virPaySche.setApplyAmt(applyAmtTotal);
            virPaySche.setMergerCnt(currCnt);
            Optional<PayScheCalcModel> any = paySches.stream().filter(Objects::nonNull).filter(o -> o.isMasterData()).findAny();
            if (any.isPresent()) {
                PayScheCalcModel consumer = any.get();
                consumer.setMasterData(false);
                consumer.setMasterDataId(null);
                upPaySches.add(consumer);
                List payScheByBatchNums = this.dataRepository.getPayScheDataByBatchNum(batchnum);
                Set removePayScheIds = paySches.stream().filter(Objects::nonNull).map(PayScheCalcModel::getScheId).collect(Collectors.toSet());
                List remainPaySches = payScheByBatchNums.stream().filter(Objects::nonNull).filter(o -> !removePayScheIds.contains(o.getScheId())).collect(Collectors.toList());
                PayScheCalcModel masterPaySche = (PayScheCalcModel)remainPaySches.get(0);
                masterPaySche.setMasterData(true);
                masterPaySche.setMasterDataId(virPaySche.getMasterDataId());
                upPaySches.add(masterPaySche);
            }
            upPaySches.add(virPaySche);
        }
    }

    protected abstract IPayScheProcessorView<T> getView();

    protected abstract ISumScheService<T> getSumScheService();

    private void addNewPaySches(List<PayScheCalcModel> originPaySches, List<PayScheCalcModel> newPaySches) {
        List changeIds = newPaySches.stream().filter(Objects::nonNull).map(PayScheCalcModel::getScheId).collect(Collectors.toList());
        originPaySches = originPaySches.stream().filter(Objects::nonNull).filter(o -> !changeIds.contains(o.getScheId())).collect(Collectors.toList());
        originPaySches.addAll(newPaySches);
    }

    private void calSingleAmount(Map<String, BigDecimal> batchScheAmount, PayScheCalcModel payScheCalcModel) {
        if (!this.isDiffCurrency(payScheCalcModel)) {
            return;
        }
        String batchNum = payScheCalcModel.getBatchnum();
        if (!payScheCalcModel.isArchiveMerger() && StringUtils.isNotEmpty((String)batchNum)) {
            BigDecimal amount = batchScheAmount.get(batchNum);
            if (amount == null) {
                amount = BigDecimal.ZERO;
            }
            amount = amount.add(payScheCalcModel.getScheBalance());
            batchScheAmount.put(batchNum, amount);
        }
    }

    private boolean isDiffCurrency(PayScheCalcModel payScheCalcModel) {
        return payScheCalcModel.getApplyCurrencyId().compareTo(payScheCalcModel.getCurrencyId()) != 0;
    }

    private void changeMergeAmount(List<PayScheCalcModel> needUpdateNewData, Map<String, BigDecimal> batchScheAmount) {
        if (batchScheAmount == null || batchScheAmount.size() == 0) {
            return;
        }
        for (PayScheCalcModel scheData : needUpdateNewData) {
            String batchNum;
            BigDecimal amount;
            if (!scheData.isArchiveMerger() || (amount = batchScheAmount.get(batchNum = scheData.getBatchnum())) == null) continue;
            scheData.setScheBalance(amount);
        }
    }

    static /* synthetic */ void access$000(PayScheCalcBaseHandler x0, List x1, String x2, List x3) {
        x0.dealMergeDraftChg(x1, x2, x3);
    }
}

