/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.data.calc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.login.utils.StringUtils;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheDraftInfo;
import kd.tmc.psd.business.service.paysche.data.calc.PaySchePropVal;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class PayScheCalcModel
implements Serializable {
    private Map<String, PaySchePropVal> dataMap;
    List<PayScheDraftInfo> payScheDraftInfos;
    private boolean notMatchAutoScheRule;
    private List<PayScheCalcModel> mergeScheduleList;
    private long payBillId;

    public PayScheCalcModel(Map<String, PaySchePropVal> dataMap) {
        this.dataMap = dataMap;
    }

    public Map<String, PaySchePropVal> getDataMap() {
        return this.dataMap;
    }

    public static PayScheCalcModel createVirtualPaySche(List<PayScheCalcModel> originPaySches, boolean isFormDB) {
        String masterId = StringUtils.randomWord((int)32);
        Optional<PayScheCalcModel> first = originPaySches.stream().filter(Objects::nonNull).filter(PayScheCalcModel::isMasterData).findFirst();
        PayScheCalcModel mainPaySche = null;
        if (!first.isPresent()) {
            mainPaySche = originPaySches.get(0);
            mainPaySche.setMasterData(true);
        } else {
            mainPaySche = first.get();
        }
        mainPaySche.setMasterDataId(masterId);
        PayScheCalcModel virtualPaySche = PayScheCalcModel.clone(mainPaySche);
        virtualPaySche.setScheNumber(String.format("%s-VIRTUAL", virtualPaySche.getScheNumber()));
        virtualPaySche.setSummaryId(-1L);
        virtualPaySche.setMasterDataId(masterId);
        virtualPaySche.setMergerCnt(originPaySches.size());
        virtualPaySche.setMergeScheduleList(originPaySches);
        virtualPaySche.setArchiveMerger(true);
        virtualPaySche.setScheId(DB.genLongId((String)"t_psd_schedulebill"));
        virtualPaySche.setNewScheData(true);
        virtualPaySche.setMasterData(false);
        virtualPaySche.setScheNumber(null);
        BigDecimal applyAmt = BigDecimal.ZERO;
        BigDecimal balanceAmt = BigDecimal.ZERO;
        BigDecimal draftAmt = BigDecimal.ZERO;
        BigDecimal scheAmt = BigDecimal.ZERO;
        ArrayList<Long> billDraftIds = new ArrayList<Long>(originPaySches.size());
        for (PayScheCalcModel originPaySch : originPaySches) {
            applyAmt = applyAmt.add(originPaySch.getApplyAmt());
            balanceAmt = balanceAmt.add(originPaySch.getActualBalanceAmt());
            draftAmt = draftAmt.add(originPaySch.getDraftBillAmt());
            scheAmt = scheAmt.add(originPaySch.getScheAmt());
            List<Long> draftBills = originPaySch.getDraftBillIds();
            if (draftBills == null || draftBills.size() <= 0) continue;
            billDraftIds.addAll(draftBills);
        }
        virtualPaySche.setApplyAmt(applyAmt);
        virtualPaySche.setScheBalance(balanceAmt);
        virtualPaySche.setDraftBillAmt(draftAmt);
        virtualPaySche.setScheAmt(scheAmt);
        if (billDraftIds.size() > 0) {
            BigDecimal balance;
            BigDecimal draftAmount = PayScheHelper.getDraftsAmts(billDraftIds.stream().distinct().collect(Collectors.toList()));
            BigDecimal bigDecimal = balance = draftAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : draftAmount.subtract(applyAmt);
            if (virtualPaySche.isBillDibs().booleanValue()) {
                virtualPaySche.setBalance(balance);
            }
        }
        if (EmptyUtil.isNoEmpty(virtualPaySche.getPayScheDraftInfos()) && isFormDB) {
            virtualPaySche.getPayScheDraftInfos().stream().forEach(o -> {
                o.setPayScheId(virtualPaySche.getScheId());
                o.setArchiveMerger(true);
            });
        }
        return virtualPaySche;
    }

    public boolean isNotMatchAutoScheRule() {
        return this.notMatchAutoScheRule;
    }

    public void setNotMatchAutoScheRule(boolean notMatchAutoScheRule) {
        this.notMatchAutoScheRule = notMatchAutoScheRule;
    }

    public BigDecimal getActualApplyAmt(int scale) {
        String scheStatus = this.getScheStatus();
        if (ScheStatusEnum.TONEXT.getValue().equals(scheStatus) || ScheStatusEnum.YETCHARGEBACK.getValue().equals(scheStatus)) {
            return BigDecimal.ZERO;
        }
        return this.getApplyAmt().multiply(this.getExchangerate()).setScale(scale, 4);
    }

    public BigDecimal getActualBalanceAmt() {
        if (ScheStatusEnum.TONEXT.getValue().equals(this.getScheStatus()) || ScheStatusEnum.YETCHARGEBACK.getValue().equals(this.getScheStatus())) {
            return BigDecimal.ZERO;
        }
        return this.getScheBalance();
    }

    public boolean reCalcBalance(int scale) {
        BigDecimal totalAmt = this.getScheAmt().add(this.getDraftBillAmt()).setScale(scale, 4);
        BigDecimal applyAmt = this.getApplyAmt().multiply(this.getExchangerate()).setScale(scale, 4);
        BigDecimal balance = applyAmt.subtract(totalAmt).setScale(scale, 4);
        boolean isMoreThanApplyAmount = false;
        if (BigDecimal.ZERO.compareTo(balance) > 0) {
            balance = totalAmt.add(balance);
            totalAmt = BigDecimal.ZERO;
            this.setScheAmt(BigDecimal.ZERO);
            this.setDraftBillAmt(BigDecimal.ZERO);
            isMoreThanApplyAmount = true;
        }
        this.setScheBalance(balance);
        this.setTotalAmt(totalAmt);
        return isMoreThanApplyAmount;
    }

    public boolean isNegativeBalance(int scale) {
        BigDecimal totalAmt = this.getScheAmt().add(this.getDraftBillAmt()).setScale(scale, 4);
        BigDecimal applyAmt = this.getApplyAmt().multiply(this.getExchangerate()).setScale(scale, 4);
        BigDecimal balance = applyAmt.subtract(totalAmt).setScale(scale, 4);
        boolean isMoreThanApplyAmount = false;
        if (applyAmt.compareTo(BigDecimal.ZERO) >= 0 && BigDecimal.ZERO.compareTo(balance) > 0) {
            this.setScheAmt(BigDecimal.ZERO);
            this.setDraftBillAmt(BigDecimal.ZERO);
            isMoreThanApplyAmount = true;
        }
        return isMoreThanApplyAmount;
    }

    public static Long getTopSplitId(PayScheCalcModel payScheCalcModel, List<PayScheCalcModel> payScheDataList) {
        Long prevId = PayScheCalcModel.getPrevSplitId(payScheCalcModel, payScheDataList);
        if (!payScheCalcModel.getScheId().equals(prevId)) {
            return prevId;
        }
        return null;
    }

    public <T> PaySchePropVal<T> getCalcProp(String scheCalcProp) {
        PaySchePropVal data = this.dataMap.get(scheCalcProp);
        if (data == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6392\u7a0b\u5904\u7406\u5355\u5206\u5f55\u5c5e\u6027\u672a\u627e\u5230\uff1a%s\u3002", (String)"PayScheCalcModel_0", (String)"tmc-psd-business", (Object[])new Object[0]), scheCalcProp));
        }
        return data;
    }

    public <T> T getCalcPropVal(String scheCalcProp) {
        PaySchePropVal<T> calc = this.getCalcProp(scheCalcProp);
        return (T)calc.getData();
    }

    public <T> void setCalcPropVal(String scheCalcProp, T val) {
        PaySchePropVal<T> data = this.getCalcProp(scheCalcProp);
        data.setData(val);
    }

    public void replaceData(PayScheCalcModel calcModel) {
        for (String prop : this.dataMap.keySet()) {
            this.setCalcPropVal(prop, calcModel.getCalcPropVal(prop));
        }
    }

    public void updateData(PayScheCalcModel calcModel, List<String> needProps) {
        for (String prop : needProps) {
            this.setCalcPropVal(prop, calcModel.getCalcPropVal(prop));
        }
    }

    private static Long getPrevSplitId(PayScheCalcModel payScheCalcModel, List<PayScheCalcModel> payScheDataList) {
        Long splitSourceId = payScheCalcModel.getSplitId();
        List payScheDataIds = payScheDataList.stream().map(PayScheCalcModel::getScheId).collect(Collectors.toList());
        if (splitSourceId == null || splitSourceId.equals(0L) || payScheDataIds.indexOf(splitSourceId) == -1) {
            return payScheCalcModel.getScheId();
        }
        for (PayScheCalcModel data : payScheDataList) {
            Long scheId = data.getScheId();
            if (!scheId.equals(splitSourceId)) continue;
            return PayScheCalcModel.getPrevSplitId(data, payScheDataList);
        }
        return null;
    }

    public String getGroupKey(List<String> groupCalcProps) {
        StringBuilder groupKey = new StringBuilder();
        for (String calcProp : groupCalcProps) {
            Object val = this.getGroupVal(calcProp);
            groupKey.append(val).append("___");
        }
        return groupKey.toString();
    }

    public Object getGroupVal(String groupCalcProp) {
        Object val = this.getCalcPropVal(groupCalcProp);
        if (val instanceof Date) {
            val = DateUtils.getDataFormat((Date)((Date)val), (boolean)true);
            val = ((Date)val).getTime();
        } else if (val instanceof BigDecimal) {
            val = ((BigDecimal)val).setScale(10, RoundingMode.HALF_UP);
        }
        return val;
    }

    public static DynamicObjectType getCalcEntryType() {
        return ((DynamicCollectionProperty)EntityMetadataCache.getDataEntityType((String)"psd_schebillcalc").getProperty("entryentity")).getDynamicCollectionItemPropertyType();
    }

    public String serialize() {
        HashMap<String, String> serializedDataMap = new HashMap<String, String>(10);
        for (Map.Entry<String, PaySchePropVal> entry : this.dataMap.entrySet()) {
            PaySchePropVal value = entry.getValue();
            String serializedVal = JSON.toJSONString((Object)value, (SerializerFeature[])PayScheCalcModel.getSerializeFeature());
            serializedDataMap.put(entry.getKey(), serializedVal);
        }
        String draftInfoJSON = JSON.toJSONString(this.getPayScheDraftInfos(), (SerializerFeature[])PayScheCalcModel.getSerializeFeature());
        serializedDataMap.put("draftInfo", draftInfoJSON);
        String mergeScheduleInfo = EmptyUtil.isNoEmpty(this.getMergeScheduleList()) ? JSON.toJSONString(this.getMergeScheduleList(), (SerializerFeature[])PayScheCalcModel.getSerializeFeature()) : null;
        serializedDataMap.put("mergeScheduleInfo", mergeScheduleInfo);
        return JSON.toJSONString(serializedDataMap);
    }

    public static PayScheCalcModel clone(PayScheCalcModel originPaySche) {
        String originPayScheJsonStr = originPaySche.serialize();
        return PayScheCalcModel.deserialize(originPayScheJsonStr);
    }

    public static String serializeList(List<PayScheCalcModel> calcModelList) {
        List serializedList = calcModelList.stream().map(PayScheCalcModel::serialize).collect(Collectors.toList());
        return JSON.toJSONString(serializedList);
    }

    public static PayScheCalcModel deserialize(String serializeString) {
        HashMap<String, PaySchePropVal> dataMap = new HashMap<String, PaySchePropVal>(10);
        Map serializedDataMap = (Map)JSON.parseObject((String)serializeString, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        List payScheDraftInfos = null;
        List mergeScheduleList = null;
        for (Map.Entry entry : serializedDataMap.entrySet()) {
            if ("draftInfo".equals(entry.getKey())) {
                payScheDraftInfos = JSON.parseArray((String)((String)entry.getValue()), PayScheDraftInfo.class);
                continue;
            }
            if ("mergeScheduleInfo".equals(entry.getKey())) {
                if (!EmptyUtil.isNoEmpty((String)((String)entry.getValue()))) continue;
                mergeScheduleList = JSON.parseArray((String)((String)entry.getValue()), PayScheCalcModel.class);
                continue;
            }
            String serializedVal = (String)entry.getValue();
            PaySchePropVal val = (PaySchePropVal)JSON.parseObject((String)serializedVal, PaySchePropVal.class);
            dataMap.put((String)entry.getKey(), val);
        }
        PayScheCalcModel payScheCalcModel = new PayScheCalcModel(dataMap);
        payScheCalcModel.setPayScheDraftInfos(payScheDraftInfos);
        payScheCalcModel.setMergeScheduleList(mergeScheduleList);
        return payScheCalcModel;
    }

    public static List<PayScheCalcModel> deserializeList(String serializeString) {
        List<PayScheCalcModel> dataList = new ArrayList<PayScheCalcModel>();
        List serializedList = JSON.parseArray((String)serializeString, String.class);
        if (null != serializedList) {
            dataList = serializedList.stream().filter(Objects::nonNull).map(PayScheCalcModel::deserialize).collect(Collectors.toList());
        }
        return dataList;
    }

    public PayScheCalcModel cloneBean() {
        return PayScheCalcModel.deserialize(this.serialize());
    }

    private static SerializerFeature[] getSerializeFeature() {
        return new SerializerFeature[]{SerializerFeature.IgnoreNonFieldGetter, SerializerFeature.WriteClassName, SerializerFeature.NotWriteRootClassName};
    }

    public String getSplitno() {
        return (String)this.getCalcPropVal("e_splitno");
    }

    public void setSplitno(String splitno) {
        this.setCalcPropVal("e_splitno", splitno);
    }

    public Long getApplySettlementTypeId() {
        return (Long)this.getCalcPropVal("e_applysettletype");
    }

    public void setApplySettlementTypeId(Long applySettlementTypeId) {
        this.setCalcPropVal("e_applysettletype", applySettlementTypeId);
    }

    public Date getApplyDate() {
        return (Date)this.getCalcPropVal("e_applydate");
    }

    public void setApplyDate(Date applyDate) {
        this.setCalcPropVal("e_applydate", applyDate);
    }

    public String getScheNumber() {
        return (String)this.getCalcPropVal("e_billno");
    }

    public void setScheNumber(String scheNumber) {
        this.setCalcPropVal("e_billno", scheNumber);
    }

    public Long getPaymenttypeId() {
        return (Long)this.getCalcPropVal("e_paymenttype");
    }

    public void setPaymenttypeId(Long paymenttypeId) {
        this.setCalcPropVal("e_paymenttype", paymenttypeId);
    }

    public String getAcctBankType() {
        return (String)this.getCalcPropVal("e_acctbanktype");
    }

    public void setAcctBankType(String acctBankType) {
        this.setCalcPropVal("e_acctbanktype", acctBankType);
    }

    public Long getScheId() {
        return (Long)this.getCalcPropVal("e_id");
    }

    public void setScheId(Long scheId) {
        this.setCalcPropVal("e_id", scheId);
    }

    public Long getSummaryId() {
        return (Long)this.getCalcPropVal("e_summaryid");
    }

    public void setSummaryId(Long summaryId) {
        this.setCalcPropVal("e_summaryid", summaryId);
    }

    public Date getExpectDate() {
        return (Date)this.getCalcPropVal("e_expectdate");
    }

    public void setExpectDate(Date expectDate) {
        this.setCalcPropVal("e_expectdate", expectDate);
    }

    public Long getCurrencyId() {
        return (Long)this.getCalcPropVal("e_paycurrency");
    }

    public void setCurrencyId(Long currencyId) {
        this.setCalcPropVal("e_paycurrency", currencyId);
    }

    public Long getFundUsageId() {
        return (Long)this.getCalcPropVal("e_fundflowitem");
    }

    public void setFundUsageId(Long fundUsageId) {
        this.setCalcPropVal("e_fundflowitem", fundUsageId);
    }

    public BigDecimal getScheAmt() {
        return (BigDecimal)this.getCalcPropVal("e_amount");
    }

    public Long getSettleTypeId() {
        return (Long)this.getCalcPropVal("e_settletype");
    }

    public void setScheAmt(BigDecimal scheAmt) {
        this.setCalcPropVal("e_amount", scheAmt);
    }

    public void setSettleTypeId(Long settleTypeId) {
        this.setCalcPropVal("e_settletype", settleTypeId);
    }

    public Long getAcctBankId() {
        return (Long)this.getCalcPropVal("e_acctbank");
    }

    public void setAcctBankId(Long acctBankId) {
        this.setCalcPropVal("e_acctbank", acctBankId);
    }

    public String getPayChannel() {
        return (String)this.getCalcPropVal("e_paymentchannel");
    }

    public void setPayChannel(String payChannel) {
        this.setCalcPropVal("e_paymentchannel", payChannel);
    }

    public BigDecimal getDraftBillAmt() {
        return (BigDecimal)this.getCalcPropVal("e_draftamt");
    }

    public void setDraftBillAmt(BigDecimal draftBillAmt) {
        this.setCalcPropVal("e_draftamt", draftBillAmt);
    }

    public String getDraftPayMethod() {
        return (String)this.getCalcPropVal("e_draftpaymethod");
    }

    public void setDraftPayMethod(String draftPayMethod) {
        this.setCalcPropVal("e_draftpaymethod", draftPayMethod);
    }

    public String getDraftpaychannel() {
        return (String)this.getCalcPropVal("e_draftpaychannel");
    }

    public void setDraftpaychannel(String draftpaychannel) {
        this.setCalcPropVal("e_draftpaychannel", draftpaychannel);
    }

    public Long getDraftSettleTypeId() {
        return (Long)this.getCalcPropVal("e_draftsettletype");
    }

    public void setDraftSettleTypeId(Long draftSettleTypeId) {
        this.setCalcPropVal("e_draftsettletype", draftSettleTypeId);
    }

    public List<Long> getDraftBillIds() {
        return (List)this.getCalcPropVal("e_draftno");
    }

    public List<Long> getLimitbankIdsNoError() {
        PaySchePropVal data = this.dataMap.get("e_limitbank");
        if (data == null) {
            return new ArrayList<Long>(0);
        }
        return (List)data.getData();
    }

    public List<Long> getLimitbankIds() {
        return (List)this.getCalcPropVal("e_limitbank");
    }

    public void setLimitbankIds(List<Long> limitbankIds) {
        this.setCalcPropVal("e_limitbank", limitbankIds);
    }

    public void setDraftBillIds(List<Long> draftBillIds) {
        this.setCalcPropVal("e_draftno", draftBillIds);
    }

    public BigDecimal getApplyAmt() {
        return (BigDecimal)this.getCalcPropVal("e_applyamt");
    }

    public void setApplyAmt(BigDecimal applyAmt) {
        this.setCalcPropVal("e_applyamt", applyAmt);
    }

    public BigDecimal getScheBalance() {
        return (BigDecimal)this.getCalcPropVal("e_balanceamt");
    }

    public void setScheBalance(BigDecimal scheBalance) {
        this.setCalcPropVal("e_balanceamt", scheBalance);
    }

    public String getScheStatus() {
        return (String)this.getCalcPropVal("e_schedulstatus");
    }

    public void setScheStatus(String scheStatus) {
        this.setCalcPropVal("e_schedulstatus", scheStatus);
    }

    public String getBatchnum() {
        return (String)this.getCalcPropVal("e_batchnum");
    }

    public void setBatchnum(String batchnum) {
        this.setCalcPropVal("e_batchnum", batchnum);
    }

    public String getBatchnumBak() {
        return (String)this.getCalcPropVal("e_batchnumbak");
    }

    public void setBatchnumBak(String batchnumBak) {
        this.setCalcPropVal("e_batchnumbak", batchnumBak);
    }

    public Long getSplitId() {
        Long splitId = Optional.ofNullable(this.getCalcPropVal("e_splitid")).map(o -> Long.valueOf(o.toString())).orElseGet(() -> 0L);
        return splitId;
    }

    public void setSplitId(Long splitId) {
        this.setCalcPropVal("e_splitid", splitId);
    }

    public Long getOrgId() {
        return (Long)this.getCalcPropVal("e_company");
    }

    public void setOrgId(Long orgId) {
        this.setCalcPropVal("e_company", orgId);
    }

    public boolean isNewScheData() {
        Boolean val = (Boolean)this.getCalcPropVal("e_newschedata");
        if (val == null) {
            return false;
        }
        return val;
    }

    public void setNewScheData(boolean newScheData) {
        this.setCalcPropVal("e_newschedata", newScheData);
    }

    public Long getProjectId() {
        return (Long)this.getCalcPropVal("e_project");
    }

    public void setProjectId(Long projectId) {
        this.setCalcPropVal("e_project", projectId);
    }

    public Long getRecId() {
        return (Long)this.getCalcPropVal("e_recid");
    }

    public void setRecId(Long recId) {
        this.setCalcPropVal("e_recid", recId);
    }

    public String getRecType() {
        return (String)this.getCalcPropVal("e_payeetype");
    }

    public void setRecType(String recType) {
        this.setCalcPropVal("e_payeetype", recType);
    }

    public Integer getPrimary() {
        return (Integer)this.getCalcPropVal("e_prime");
    }

    public void setPrimary(Integer primary) {
        this.setCalcPropVal("e_prime", primary);
    }

    public Long getApplyCurrencyId() {
        return (Long)this.getCalcPropVal("e_currency");
    }

    public void setApplyCurrencyId(Long applyCurrencyId) {
        this.setCalcPropVal("e_currency", applyCurrencyId);
    }

    public String getSourceBillNo() {
        return (String)this.getCalcPropVal("e_sourcebillnumber");
    }

    public String getSourceBillType() {
        return (String)this.getCalcPropVal("e_sourcebilltype");
    }

    public Boolean getIsNeedFin() {
        Boolean val = (Boolean)this.getCalcPropVal("e_isneedfin");
        if (val == null) {
            return false;
        }
        return val;
    }

    public void setIsNeedFin(Boolean isNeedFin) {
        this.setCalcPropVal("e_isneedfin", isNeedFin);
    }

    public Date getCreateTime() {
        return (Date)this.getCalcPropVal("e_createtime");
    }

    public void setCreateTime(Date createTime) {
        this.setCalcPropVal("e_createtime", createTime);
    }

    public Long getExratetable() {
        return (Long)this.getCalcPropVal("e_exratetable");
    }

    public void setExratetable(Long exratetable) {
        this.setCalcPropVal("e_exratetable", exratetable);
    }

    public BigDecimal getExchangerate() {
        return (BigDecimal)this.getCalcPropVal("e_exchangerate");
    }

    public void setExchangerate(BigDecimal exchangerate) {
        this.setCalcPropVal("e_exchangerate", exchangerate);
    }

    public String getPayeeName() {
        return (String)this.getCalcPropVal("e_payeename");
    }

    public void setPayeeName(String name) {
        this.setCalcPropVal("e_payeename", name);
    }

    public void setFreezeStatus(String freezeStatus) {
        this.setCalcPropVal("e_freezestatus", freezeStatus);
    }

    public String getFreezeStatus() {
        return (String)this.getCalcPropVal("e_freezestatus");
    }

    public void setTotalAmt(BigDecimal totalAmt) {
        this.setCalcPropVal("e_totalamt", totalAmt);
    }

    public BigDecimal getTotalAmt() {
        return (BigDecimal)this.getCalcPropVal("e_totalamt");
    }

    public void setPayeeAcct(Long acctId) {
        this.setCalcPropVal("e_payeeacct", acctId);
    }

    public Long getPayeeAcct() {
        return (Long)this.getCalcPropVal("e_payeeacct");
    }

    public void setPayeeBank(Long bankId) {
        this.setCalcPropVal("e_payeebank", bankId);
    }

    public Long getPayeeBank() {
        return (Long)this.getCalcPropVal("e_payeebank");
    }

    public void setApplyPayChannel(String applyPayChannel) {
        this.setCalcPropVal("e_applypaychannel", applyPayChannel);
    }

    public String getApplyPayChannel() {
        return (String)this.getCalcPropVal("e_applypaychannel");
    }

    public void setDiffSplit(boolean diffSplit) {
        this.setCalcPropVal("e_issplit", diffSplit);
    }

    public boolean isDiffSplit() {
        Boolean val = (Boolean)this.getCalcPropVal("e_issplit");
        if (val == null) {
            return false;
        }
        return val;
    }

    public void setTransferPost(String transferPost) {
        if (StringUtils.isEmpty((String)transferPost)) {
            return;
        }
        this.setCalcPropVal("e_transferpost", transferPost);
    }

    public String getTransferPost() {
        return (String)this.getCalcPropVal("e_transferpost");
    }

    public Date getExpectPayDate() {
        return (Date)this.getCalcPropVal("e_expectpaydate");
    }

    public void setExpectPayDate(Date expectPayDate) {
        this.setCalcPropVal("e_expectpaydate", expectPayDate);
    }

    public BigDecimal getWaitpayAmt() {
        return (BigDecimal)this.getCalcPropVal("e_waitpayamt");
    }

    public void setWaitpayAmt(BigDecimal waitpayamt) {
        this.setCalcPropVal("e_waitpayamt", waitpayamt);
    }

    public Long getApplyAcct() {
        return (Long)this.getCalcPropVal("e_applyacctbank");
    }

    public void setWaitpayAmt(Long applyAcct) {
        this.setCalcPropVal("e_applyacctbank", applyAcct);
    }

    public boolean isMasterData() {
        return (Boolean)this.getCalcPropVal("e_ismasterdata");
    }

    public void setMasterData(boolean masterData) {
        this.setCalcPropVal("e_ismasterdata", masterData);
    }

    public String getMasterDataId() {
        return (String)this.getCalcPropVal("e_masterdataid");
    }

    public void setMasterDataId(String masterDataId) {
        this.setCalcPropVal("e_masterdataid", masterDataId);
    }

    public Integer getMergerCnt() {
        return (Integer)this.getCalcPropVal("e_mergercnt");
    }

    public void setMergerCnt(Integer mergerCnt) {
        this.setCalcPropVal("e_mergercnt", mergerCnt);
    }

    public boolean isArchiveMerger() {
        Boolean result = (Boolean)this.getCalcPropVal("e_isarchivemerger");
        return result == null ? false : result;
    }

    public void setArchiveMerger(boolean archiveMerger) {
        this.setCalcPropVal("e_isarchivemerger", archiveMerger);
    }

    public Boolean isBillDibs() {
        return (Boolean)this.getCalcPropVal("e_isbilldibs");
    }

    public void setBillDibs(Boolean isBillDibs) {
        this.setCalcPropVal("e_isbilldibs", isBillDibs);
    }

    public BigDecimal getBalance() {
        return (BigDecimal)this.getCalcPropVal("e_balance");
    }

    public void setBalance(BigDecimal balance) {
        this.setCalcPropVal("e_balance", balance);
    }

    public Long getDibsBalance() {
        return (Long)this.getCalcPropVal("e_dibsbalance");
    }

    public void setDibsBalance(Long dibsBalance) {
        this.setCalcPropVal("e_dibsbalance", dibsBalance);
    }

    public Long getItemPayee() {
        return (Long)this.getCalcPropVal("e_itempayee");
    }

    public void setItemPayee(Long itemPayee) {
        this.setCalcPropVal("e_itempayee", itemPayee);
    }

    public String getItemPayeeType() {
        return (String)this.getCalcPropVal("e_itempayeetype");
    }

    public void setItemPayeeType(String type) {
        this.setCalcPropVal("e_itempayeetype", type);
    }

    public String getLcArrivalNo() {
        return (String)this.getCalcPropVal("e_lcarrival");
    }

    public Long getDraftAcctBankId() {
        return (Long)this.getCalcPropVal("e_draftpayacct");
    }

    public void setDraftAcctBankId(Long draftPayAcctId) {
        this.setCalcPropVal("e_draftpayacct", draftPayAcctId);
    }

    public List<PayScheDraftInfo> getPayScheDraftInfos() {
        return this.payScheDraftInfos;
    }

    public void setPayScheDraftInfos(List<PayScheDraftInfo> payScheDraftInfos) {
        this.payScheDraftInfos = payScheDraftInfos;
    }

    public void initPayScheDraftInfo(Map<Long, DynamicObject> draftMapRelation) {
        ArrayList<PayScheDraftInfo> payScheDraftInfos = new ArrayList<PayScheDraftInfo>(0);
        List<Long> draftBillIds = this.getDraftBillIds();
        List<PayScheDraftInfo> payScheDrafts = this.getPayScheDraftInfos();
        HashMap<Long, PayScheDraftInfo> draftInfoMap = new HashMap<Long, PayScheDraftInfo>(16);
        if (payScheDrafts != null) {
            for (PayScheDraftInfo payScheDraftInfo : payScheDrafts) {
                Long draftId = payScheDraftInfo.getDraftId();
                draftInfoMap.put(draftId, payScheDraftInfo);
            }
        }
        BigDecimal remainDraftAmount = this.getDraftBillAmt() == null ? BigDecimal.ZERO : this.getDraftBillAmt();
        BigDecimal scheBalance = this.getScheBalance();
        remainDraftAmount = remainDraftAmount.add(scheBalance);
        BigDecimal originDraftAmount = BigDecimal.ZERO;
        originDraftAmount = originDraftAmount.add(remainDraftAmount);
        if (!EmptyUtil.isEmpty(draftBillIds)) {
            Map oldTransferAmtMap = Optional.ofNullable(this.getPayScheDraftInfos()).map(draftInfos -> draftInfos.stream().collect(Collectors.toMap(o -> o.getDraftId(), o -> o.getTransferAmt()))).orElseGet(() -> new HashMap(0));
            boolean isMerge = EmptyUtil.isNoEmpty((String)this.getBatchnum());
            BigDecimal totalDraftAmount = BigDecimal.ZERO;
            HashSet<Long> removeIds = new HashSet<Long>(draftBillIds.size());
            for (Long draftBillId : draftBillIds) {
                DynamicObject draftDy = draftMapRelation.get(draftBillId);
                PayScheDraftInfo oldPayScheDraftInfo = (PayScheDraftInfo)draftInfoMap.get(draftBillId);
                PayScheDraftInfo payScheDraftInfo = new PayScheDraftInfo();
                payScheDraftInfo.setPayScheId(this.getScheId());
                payScheDraftInfo.setPayScheNumber(this.getScheNumber());
                payScheDraftInfo.setDraftId(draftBillId);
                BigDecimal oldTransferAmt = (BigDecimal)oldTransferAmtMap.get(draftBillId);
                BigDecimal draftAmt = BigDecimal.ZERO;
                boolean isOld = true;
                if (EmptyUtil.isNoEmpty((BigDecimal)oldTransferAmt)) {
                    draftAmt = oldTransferAmt;
                } else {
                    draftAmt = Optional.ofNullable(draftDy.getBigDecimal("availableamount")).map(o -> o).orElseGet(() -> BigDecimal.ZERO);
                    isOld = false;
                }
                boolean isSplit = draftDy.getBoolean("issplit");
                if (isOld) {
                    payScheDraftInfo.setTransferAmt(draftAmt);
                    totalDraftAmount = totalDraftAmount.add(draftAmt);
                    remainDraftAmount = remainDraftAmount.subtract(draftAmt);
                } else if (!isSplit) {
                    payScheDraftInfo.setTransferAmt(draftAmt);
                    totalDraftAmount = totalDraftAmount.add(draftAmt);
                    remainDraftAmount = remainDraftAmount.subtract(draftAmt);
                } else if (remainDraftAmount.compareTo(draftAmt) >= 0) {
                    payScheDraftInfo.setTransferAmt(draftAmt);
                    totalDraftAmount = totalDraftAmount.add(draftAmt);
                    remainDraftAmount = remainDraftAmount.subtract(draftAmt);
                } else {
                    if (BigDecimal.ZERO.compareTo(remainDraftAmount) >= 0 && (!isMerge || this.isArchiveMerger())) {
                        removeIds.add(draftBillId);
                        continue;
                    }
                    payScheDraftInfo.setTransferAmt(remainDraftAmount);
                    totalDraftAmount = totalDraftAmount.add(remainDraftAmount);
                    remainDraftAmount = remainDraftAmount.subtract(remainDraftAmount);
                }
                if (!(totalDraftAmount.compareTo(originDraftAmount) <= 0 || isSplit || this.isMasterData() || this.isBillDibs().booleanValue())) {
                    removeIds.add(draftBillId);
                    continue;
                }
                payScheDraftInfo.setCurrencyId(this.getApplyCurrencyId());
                payScheDraftInfo.setBillDibs(this.isBillDibs().booleanValue());
                payScheDraftInfo.setBatchnum(this.getBatchnum());
                payScheDraftInfo.setRptype(draftDy.getString("rptype"));
                payScheDraftInfo.setElcCirculateStatus(draftDy.getString("elccirculatestatus"));
                payScheDraftInfo.setSplit(draftDy.getBoolean("issplit"));
                payScheDraftInfo.setSonPakAmt(draftDy.getBigDecimal("amount"));
                payScheDraftInfo.setArchiveMerger(this.isArchiveMerger());
                if (oldPayScheDraftInfo != null) {
                    payScheDraftInfo.setDraftLogId(oldPayScheDraftInfo.getDraftLogId());
                } else {
                    payScheDraftInfo.setDraftLogId(Long.valueOf(0L));
                }
                payScheDraftInfos.add(payScheDraftInfo);
            }
            if (removeIds.size() > 0) {
                draftBillIds.removeAll(removeIds);
            }
        }
        this.setPayScheDraftInfos(payScheDraftInfos);
    }

    public void initPayScheDraftInfo(DynamicObjectCollection draftEntrys) {
        ArrayList<PayScheDraftInfo> payScheDraftInfos = new ArrayList<PayScheDraftInfo>(0);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftEntrys)) {
            for (DynamicObject draftEntry : draftEntrys) {
                DynamicObject draftObj = draftEntry.getDynamicObject("de_draftinfo");
                PayScheDraftInfo payScheDraftInfo = new PayScheDraftInfo();
                payScheDraftInfo.setPayScheId(this.getScheId());
                payScheDraftInfo.setPayScheNumber(this.getScheNumber());
                Long draftId = Optional.ofNullable(draftEntry.getDynamicObject("de_draftinfo")).map(o -> o.getLong("id")).orElseGet(() -> 0L);
                payScheDraftInfo.setDraftId(draftId);
                payScheDraftInfo.setTransferAmt(draftEntry.getBigDecimal("de_transferamt"));
                payScheDraftInfo.setCurrencyId(this.getApplyCurrencyId());
                payScheDraftInfo.setBillDibs(this.isBillDibs().booleanValue());
                payScheDraftInfo.setBatchnum(this.getBatchnum());
                payScheDraftInfo.setArchiveMerger(this.isArchiveMerger());
                payScheDraftInfo.setElcCirculateStatus(draftObj.getString("elccirculatestatus"));
                payScheDraftInfo.setRptype(draftObj.getString("rptype"));
                payScheDraftInfo.setSplit(draftObj.getBoolean("issplit"));
                payScheDraftInfo.setSonPakAmt(draftObj.getBigDecimal("amount"));
                payScheDraftInfo.setDraftLogId(Long.valueOf(draftEntry.getLong("de_draftlogid")));
                payScheDraftInfos.add(payScheDraftInfo);
            }
        }
        this.setPayScheDraftInfos(payScheDraftInfos);
    }

    public long getPayBillId() {
        return this.payBillId;
    }

    public void setPayBillId(long payBillId) {
        this.payBillId = payBillId;
    }

    public Long getEntrustPayId() {
        return (Long)this.getCalcPropVal("e_entrustpayid");
    }

    public void setEntrustPayId(Long entrustPayId) {
        this.setCalcPropVal("e_entrustpayid", entrustPayId);
    }

    public List<PayScheCalcModel> getMergeScheduleList() {
        return this.mergeScheduleList;
    }

    public void setMergeScheduleList(List<PayScheCalcModel> mergeScheduleList) {
        this.mergeScheduleList = mergeScheduleList;
    }
}

