/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.SerialNumberHelper;
import kd.tmc.fbp.common.helper.TmcAmountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.IPayScheService;
import kd.tmc.psd.business.service.paysche.autosche.AutoPayScheHandler;
import kd.tmc.psd.business.service.paysche.autosche.bill.DraftBillLockCache;
import kd.tmc.psd.business.service.paysche.data.PayScheDataTransfer;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessResult;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessorInfo;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheDraftInfo;
import kd.tmc.psd.business.service.paysche.data.config.PayScheConfigData;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleHelper;
import kd.tmc.psd.business.service.paysche.service.impl.PayScheProcessorByAfreshCreator;
import kd.tmc.psd.business.service.paysche.service.impl.PayScheProcessorByStartEndDateCreator;
import kd.tmc.psd.business.service.paysche.service.impl.PayScheProcessorCreator;
import kd.tmc.psd.business.service.paysche.service.impl.PayScheProcessorDirectByStartEndDateCreator;
import kd.tmc.psd.business.service.paysche.service.impl.PayScheProcessorDirectCreator;
import kd.tmc.psd.business.service.paysche.sumsche.data.SumScheInfo;
import kd.tmc.psd.business.utils.PayScheduleUtil;
import kd.tmc.psd.common.enums.DraftPayTypeEnum;
import kd.tmc.psd.common.enums.FreezeStatusEnum;
import kd.tmc.psd.common.enums.PayChannelEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.enums.SettleMentTypeEnum;
import kd.tmc.psd.common.helper.LoggerPrintHelper;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.ObjectUtils;

public class PayScheServiceImpl
implements IPayScheService {
    private static Log logger = LogFactory.getLog(PayScheServiceImpl.class);
    private Map<Long, DynamicObject> defaultRules;

    public PayScheServiceImpl() {
    }

    public PayScheServiceImpl(Map<Long, DynamicObject> defaultRules) {
        this.defaultRules = defaultRules;
    }

    public PayScheProcessResult<Long> createNewProcessor(Long orgId, Long schePeriodId, List<Long> currencyIds) {
        return new PayScheProcessorCreator(orgId, schePeriodId, currencyIds).createProcessor();
    }

    public PayScheProcessResult<Long> createNewProcessor(Long orgId, Date startDate, Date endDate, List<Long> currencyIds) {
        return new PayScheProcessorByStartEndDateCreator(orgId, startDate, endDate, currencyIds).createProcessor();
    }

    public PayScheProcessResult<Long> createNewProcessor(List<Long> scheBillIds) {
        return new PayScheProcessorDirectCreator(scheBillIds).createProcessor();
    }

    public PayScheProcessResult<Long> createNewProcessorByAfresh(List<Long> scheBillIds, Date startDate, Date endDate) {
        return new PayScheProcessorByAfreshCreator(scheBillIds, startDate, endDate).createProcessor();
    }

    public PayScheProcessResult<Long> createNewProcessorByStartEndDate(List<Long> scheBillIds) {
        return new PayScheProcessorDirectByStartEndDateCreator(scheBillIds).createProcessor();
    }

    public PayScheProcessResult<List<PayScheCalcModel>> loadProcessor(Long processorId) {
        List megerPayScheDataLst;
        ArrayList<PayScheCalcModel> scheDatas = new ArrayList<PayScheCalcModel>(10);
        QFilter scheDealIdF = new QFilter("schedealid", "=", (Object)processorId);
        DynamicObjectCollection scheduleBills = QueryServiceHelper.query((String)"psd_schedulebill", (String)"id", (QFilter[])new QFilter[]{scheDealIdF});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)scheduleBills)) {
            return new PayScheProcessResult(scheDatas);
        }
        DynamicObject preocessBill = BusinessDataServiceHelper.loadSingle((Object)processorId, (String)"psd_schedealbill", (String)"billstatus");
        String status = preocessBill.getString("billstatus");
        List scheduleBillIds = scheduleBills.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        DynamicObject[] scheduleBillsArr = BusinessDataServiceHelper.load((Object[])scheduleBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        scheDatas.addAll(new PayScheDataTransfer().transScheDataToCalcModelList(Arrays.asList(scheduleBillsArr)));
        if ("A".equals(status)) {
            PayScheduleUtil.processExpectDate(scheDatas);
        }
        if (EmptyUtil.isNoEmpty(megerPayScheDataLst = scheDatas.stream().filter(Objects::nonNull).filter(o -> EmptyUtil.isNoEmpty((String)o.getBatchnum())).collect(Collectors.toList()))) {
            Map<String, List<PayScheCalcModel>> megerPayScheDataMap = megerPayScheDataLst.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getBatchnum()));
            ArrayList<PayScheCalcModel> virtualPayScheLst = new ArrayList<PayScheCalcModel>(megerPayScheDataMap.size());
            for (Map.Entry<String, List<PayScheCalcModel>> mergePayScheEntry : megerPayScheDataMap.entrySet()) {
                List<PayScheCalcModel> originPaySches = mergePayScheEntry.getValue();
                PayScheCalcModel virtualPaySche = PayScheCalcModel.createVirtualPaySche(originPaySches, true);
                virtualPayScheLst.add(virtualPaySche);
            }
            scheDatas.addAll(virtualPayScheLst);
        }
        return new PayScheProcessResult(scheDatas);
    }

    public PayScheProcessResult<Void> autoSchedule(Long orgId, List<PayScheCalcModel> scheDataList, String pageId) {
        return this.autoSchedule(orgId, scheDataList, pageId, false);
    }

    public PayScheProcessResult<Void> autoSchedule(Long orgId, List<PayScheCalcModel> scheDataList, String pageId, boolean onKeySche) {
        PayScheProcessResult result = new PayScheProcessResult();
        this.validateFreeze(ResManager.loadKDString((String)"\u81ea\u52a8\u6392\u7a0b", (String)"PayScheProcessorHandler_01", (String)"tmc-psd-business", (Object[])new Object[0]), scheDataList, result);
        AutoPayScheHandler autoPayScheHandler = new AutoPayScheHandler(orgId, scheDataList, pageId, onKeySche);
        if (this.defaultRules != null) {
            autoPayScheHandler.setDefaultRules(this.defaultRules);
        }
        List newScheDataList = autoPayScheHandler.doAutoSche();
        this.fillNewScheDataIdInfo(newScheDataList);
        scheDataList.addAll(newScheDataList);
        this.initDraftInfo(scheDataList, pageId);
        return result;
    }

    public PayScheProcessResult<Void> sumSchedule(Long orgId, List<PayScheCalcModel> scheDataList, SumScheInfo sumScheInfo, String pageId) {
        PayScheProcessResult result = new PayScheProcessResult();
        this.validateFreeze(ResManager.loadKDString((String)"\u6c47\u603b\u6392\u7a0b", (String)"PayScheProcessorHandler_11", (String)"tmc-psd-business", (Object[])new Object[0]), scheDataList, result);
        AutoPayScheHandler autoPayScheHandler = new AutoPayScheHandler(orgId, scheDataList, pageId);
        List newScheDataList = autoPayScheHandler.doSumSche(sumScheInfo);
        this.fillNewScheDataIdInfo(newScheDataList);
        scheDataList.addAll(newScheDataList);
        this.initDraftInfo(scheDataList, pageId);
        return result;
    }

    public PayScheProcessResult<Void> autoFillPayInfo(Long orgId, Long fillId, List<PayScheCalcModel> scheDataList, String pageId) {
        PayScheProcessResult result = new PayScheProcessResult();
        this.validateStatus(scheDataList, ScheStatusEnum.SCHEDULING, result.getErrMsgList());
        String opName = ResManager.loadKDString((String)"\u6279\u91cf\u6392\u6b3e", (String)"PayScheProcessorHandler_15", (String)"tmc-psd-business", (Object[])new Object[0]);
        this.validateFreeze(opName, scheDataList, result);
        this.validatePayScheOrDraft(scheDataList, opName, result);
        if (scheDataList.size() > 0) {
            AutoPayScheHandler handler = new AutoPayScheHandler(orgId, scheDataList, pageId);
            DynamicObject fundRule = TmcDataServiceHelper.loadSingle((Object)fillId, (String)"psd_payment_rule");
            handler.doBatchFundSche(fundRule);
        }
        return result;
    }

    public PayScheProcessResult<Void> autoFillTradeBillInfo(Long orgId, Long fillId, List<PayScheCalcModel> scheDataList, String pageId) {
        PayScheProcessResult result = new PayScheProcessResult();
        AutoPayScheHandler handler = new AutoPayScheHandler(orgId, scheDataList, pageId);
        this.validateStatus(scheDataList, ScheStatusEnum.SCHEDULING, result.getErrMsgList());
        String opName = ResManager.loadKDString((String)"\u6279\u91cf\u6392\u7968", (String)"PayScheProcessorHandler_16", (String)"tmc-psd-business", (Object[])new Object[0]);
        this.validateFreeze(opName, scheDataList, result);
        this.validatePayScheOrDraft(scheDataList, opName, result);
        List nonMatchedList = scheDataList.stream().filter(scheData -> EmptyUtil.isEmpty((Long)scheData.getCurrencyId()) || EmptyUtil.isEmpty((Long)scheData.getApplyCurrencyId()) || scheData.getCurrencyId().compareTo(scheData.getApplyCurrencyId()) != 0).collect(Collectors.toList());
        scheDataList.removeAll(nonMatchedList);
        for (PayScheCalcModel payScheCalcModel : nonMatchedList) {
            String mark = payScheCalcModel.getScheNumber();
            if (EmptyUtil.isEmpty((String)mark)) {
                mark = payScheCalcModel.getBatchnum();
            }
            String errMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u7533\u8bf7\u5e01\u79cd\u4e0e\u4ed8\u6b3e\u5e01\u79cd\u4e0d\u4e00\u81f4\u65f6\uff0c\u4e0d\u652f\u6301\u5f00\u7968\u548c\u80cc\u4e66\u9009\u7968\u3002", (String)"PayScheServiceImpl_38", (String)"tmc-psd-business", (Object[])new Object[0]), mark);
            result.getErrMsgList().add(errMsg);
        }
        if (scheDataList.size() > 0) {
            DynamicObject billRule = TmcDataServiceHelper.loadSingle((Object)fillId, (String)"psd_queueticket_rule");
            List newScheDataList = handler.doBatchBillSche(billRule);
            this.fillNewScheDataIdInfo(newScheDataList);
            scheDataList.addAll(newScheDataList);
        }
        this.initDraftInfo(scheDataList, pageId);
        return result;
    }

    public PayScheProcessResult<Void> refusePay(List<PayScheCalcModel> scheDataList) {
        PayScheProcessResult result = new PayScheProcessResult();
        this.validateStatus(scheDataList, ScheStatusEnum.SCHEDULING, result.getErrMsgList());
        this.validateAmtIsZero(scheDataList, result.getErrMsgList());
        this.validateBatchnum(scheDataList, result.getErrMsgList());
        if (scheDataList.size() > 0) {
            scheDataList.forEach(v -> v.setScheStatus(ScheStatusEnum.YETCHARGEBACK.getValue()));
        }
        return result;
    }

    public PayScheProcessResult<Void> cancelRefusePay(List<PayScheCalcModel> scheDataList) {
        PayScheProcessResult result = new PayScheProcessResult();
        this.validateStatus(scheDataList, ScheStatusEnum.YETCHARGEBACK, result.getErrMsgList());
        this.validateAmtIsZero(scheDataList, result.getErrMsgList());
        if (scheDataList.size() > 0) {
            scheDataList.forEach(v -> v.setScheStatus(ScheStatusEnum.SCHEDULING.getValue()));
        }
        return result;
    }

    public PayScheProcessResult<Void> transToNextPeriod(List<PayScheCalcModel> scheDataList) {
        PayScheProcessResult result = new PayScheProcessResult();
        this.validateFreeze(ResManager.loadKDString((String)"\u8f6c\u4e0b\u671f", (String)"PayScheServiceImpl_14", (String)"tmc-psd-business", (Object[])new Object[0]), scheDataList, result);
        this.validateStatus(scheDataList, ScheStatusEnum.SCHEDULING, result.getErrMsgList());
        this.validateAmtIsZero(scheDataList, result.getErrMsgList());
        this.validateBatchnum(scheDataList, result.getErrMsgList());
        if (scheDataList.size() > 0) {
            scheDataList.forEach(v -> v.setScheStatus(ScheStatusEnum.TONEXT.getValue()));
        }
        return result;
    }

    public PayScheProcessResult<Void> cancelTrans(List<PayScheCalcModel> scheDataList) {
        PayScheProcessResult result = new PayScheProcessResult();
        this.validateStatus(scheDataList, ScheStatusEnum.TONEXT, result.getErrMsgList());
        if (scheDataList.size() > 0) {
            scheDataList.forEach(v -> v.setScheStatus(ScheStatusEnum.SCHEDULING.getValue()));
        }
        return result;
    }

    public PayScheProcessResult<List<PayScheCalcModel>> filterCombineData(List<String> combinePropList, List<PayScheCalcModel> scheDataList) {
        PayScheProcessResult result = new PayScheProcessResult();
        Map scheIdToScheMap = scheDataList.stream().collect(Collectors.toMap(PayScheCalcModel::getScheId, Function.identity(), (a, b) -> a));
        HashSet<PayScheCalcModel> errSet = new HashSet<PayScheCalcModel>(10);
        QFilter scheIdFilter = new QFilter("id", "in", scheIdToScheMap.keySet());
        DynamicObjectCollection scheEntryList = QueryServiceHelper.query((String)"psd_schedulebill", (String)"id, entrys.e_payid", (QFilter[])new QFilter[]{scheIdFilter});
        HashMap<Long, Set> payIdToScheIdMap = new HashMap<Long, Set>(scheEntryList.size());
        for (Object entry : scheEntryList) {
            long scheId = entry.getLong("id");
            long payId = entry.getLong("entrys.e_payid");
            Set idSet = payIdToScheIdMap.computeIfAbsent(payId, o -> new HashSet());
            idSet.add(scheId);
        }
        List<DynamicObject> headPushList = this.getHeadPushPayList(scheDataList, scheIdToScheMap.keySet(), payIdToScheIdMap.keySet());
        for (DynamicObject payBill : headPushList) {
            long payId = payBill.getLong("id");
            Set currScheIdSet = (Set)payIdToScheIdMap.get(payId);
            for (Long scheId : currScheIdSet) {
                PayScheCalcModel scheModel = (PayScheCalcModel)scheIdToScheMap.get(scheId);
                if (scheModel == null) continue;
                errSet.add(scheModel);
            }
        }
        if (errSet.containsAll(scheDataList)) {
            result.addErrorMessage(ResManager.loadKDString((String)"\u6682\u65e0\u7b26\u5408\u5408\u5e76\u6761\u4ef6\u7684\u6392\u7a0b\u5355\u3002", (String)"PayScheServiceImpl_15", (String)"tmc-psd-business", (Object[])new Object[0]));
            return result;
        }
        Map<String, List<PayScheCalcModel>> groupList = scheDataList.stream().filter(o -> o.getScheStatus().equals(ScheStatusEnum.SCHEDULING.getValue())).filter(o -> FreezeStatusEnum.UnFrozen.getValue().equals(o.getFreezeStatus())).collect(Collectors.groupingBy(o -> o.getGroupKey(combinePropList)));
        ArrayList<PayScheCalcModel> resultList = new ArrayList<PayScheCalcModel>();
        for (List<PayScheCalcModel> value : groupList.values()) {
            if (value.size() <= 1) continue;
            resultList.addAll(value);
        }
        result.setResult(resultList);
        if (resultList.size() == 0) {
            result.addErrorMessage(ResManager.loadKDString((String)"\u6682\u65e0\u7b26\u5408\u5408\u5e76\u6761\u4ef6\u7684\u6392\u7a0b\u5355\u3002", (String)"PayScheServiceImpl_15", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        return result;
    }

    public PayScheProcessResult<Void> autoCombine(List<PayScheCalcModel> scheDataList) {
        List combineUniqueProps = PayScheConfigData.getUniqueCalcProps((List)PayScheConfigData.load());
        ArrayList<List<PayScheCalcModel>> waitCombineList = new ArrayList<List<PayScheCalcModel>>(scheDataList.size());
        Map<Long, List<PayScheCalcModel>> groupedScheDataList = scheDataList.stream().filter(o -> o.getScheStatus().equals(ScheStatusEnum.SCHEDULING.getValue())).collect(Collectors.groupingBy(PayScheCalcModel::getSummaryId));
        for (List<PayScheCalcModel> groupedList : groupedScheDataList.values()) {
            Map<String, List<PayScheCalcModel>> groupedMap = groupedList.stream().collect(Collectors.groupingBy(o -> o.getGroupKey(combineUniqueProps)));
            for (List<PayScheCalcModel> scheList : groupedMap.values()) {
                if (scheList.size() <= 1) continue;
                waitCombineList.add(scheList);
            }
        }
        for (List<PayScheCalcModel> waitCombineDataList : waitCombineList) {
            String combineNumber = null;
            if (null == waitCombineDataList || waitCombineDataList.isEmpty()) continue;
            combineNumber = this.generateCombineNum(waitCombineDataList.get(0).getOrgId());
            for (PayScheCalcModel combineData : waitCombineDataList) {
                combineData.setBatchnum(combineNumber);
            }
        }
        return new PayScheProcessResult();
    }

    public PayScheProcessResult<Boolean> checkCombine(List<PayScheCalcModel> scheDataList, boolean isSubmit) {
        PayScheProcessResult result = new PayScheProcessResult();
        scheDataList = scheDataList.stream().filter(Objects::nonNull).filter(o -> !o.isArchiveMerger()).collect(Collectors.toList());
        this.validateFreeze(ResManager.loadKDString((String)"\u5408\u5e76", (String)"PayScheProcessorHandler_10", (String)"tmc-psd-business", (Object[])new Object[0]), scheDataList, result);
        this.validateCombineBotp(scheDataList, result);
        Map<String, List<PayScheCalcModel>> groupedListMap = scheDataList.stream().filter(o -> EmptyUtil.isNotEmpty((CharSequence)o.getBatchnum())).collect(Collectors.groupingBy(PayScheCalcModel::getBatchnum));
        List uniqueCalcProps = PayScheConfigData.getUniqueCalcProps((List)PayScheConfigData.load());
        boolean isLegal = true;
        for (Map.Entry<String, List<PayScheCalcModel>> entry : groupedListMap.entrySet()) {
            List<PayScheCalcModel> value = entry.getValue();
            Map<String, List<PayScheCalcModel>> map = value.stream().collect(Collectors.groupingBy(o -> o.getGroupKey(uniqueCalcProps)));
            if (map.size() > 1) {
                isLegal = false;
            }
            Set remainIdList = map.values().stream().filter(o -> o.size() > 1).max(Comparator.comparingInt(List::size)).orElseGet(ArrayList::new).stream().map(PayScheCalcModel::getScheId).collect(Collectors.toSet());
            for (PayScheCalcModel calcModel : entry.getValue()) {
                if (remainIdList.contains(calcModel.getScheId())) continue;
                calcModel.setBatchnum(null);
            }
        }
        result.setResult((Object)isLegal);
        if (!isLegal) {
            result.addErrorMessage(ResManager.loadKDString((String)"\u5408\u5e76\u6279\u6b21\u4e2d\u5b58\u5728\u4e0d\u7b26\u5408\u5408\u5e76\u4e00\u81f4\u6027\u5b57\u6bb5\u7684\u6392\u7a0b\u5355\uff0c\u8bf7\u5904\u7406\u3002", (String)"PayScheServiceImpl_16", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        if (isSubmit) {
            groupedListMap = scheDataList.stream().filter(o -> EmptyUtil.isNotEmpty((CharSequence)o.getBatchnum())).collect(Collectors.groupingBy(PayScheCalcModel::getBatchnum));
            DynamicObject[] settlementtypes = TmcDataServiceHelper.load((String)"bd_settlementtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("settlementtype", "=", (Object)"1")});
            List settlementtypeIdList = Arrays.stream(settlementtypes).map(v -> v.getLong("id")).collect(Collectors.toList());
            for (Map.Entry entry : groupedListMap.entrySet()) {
                List unAllScheData;
                String batchnum = (String)entry.getKey();
                List sameBatchnumModel = (List)entry.getValue();
                BigDecimal sumCombineAmt = sameBatchnumModel.stream().map(v -> v.getScheAmt().add(v.getDraftBillAmt())).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (sumCombineAmt.compareTo(BigDecimal.ZERO) == 0) {
                    long UnlegalCount = sameBatchnumModel.stream().filter(v -> v.getDraftBillAmt().compareTo(BigDecimal.ZERO) != 0 || settlementtypeIdList.contains(v.getSettleTypeId())).count();
                    if (UnlegalCount != 0L) {
                        result.setResult((Object)false);
                        result.addErrorMessage(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u6279\u6b21\u53f7\u201c%s\u201d\uff0c\u5408\u5e76\u6392\u7a0b\u91d1\u989d\u4e3a0\uff0c\u4e0d\u652f\u6301\u6392\u7968\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"PayScheServiceImpl_17", (String)"tmc-psd-business", (Object[])new Object[0]), batchnum));
                    }
                } else if (sumCombineAmt.compareTo(BigDecimal.ZERO) < 0) {
                    result.setResult((Object)false);
                    result.addErrorMessage(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u6279\u6b21\u53f7\u201c%s\u201d\u5408\u5e76\u6392\u7a0b\u91d1\u989d\u5c0f\u4e8e0\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"PayScheServiceImpl_18", (String)"tmc-psd-business", (Object[])new Object[0]), batchnum));
                }
                if (CollectionUtils.isEmpty(unAllScheData = sameBatchnumModel.stream().filter(v -> v.getScheBalance().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList()))) continue;
                result.setResult((Object)false);
                result.addErrorMessage(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u6279\u6b21\u53f7[%s]\u4e0b\u4ed8\u6b3e\u6392\u7a0b\u5355\u672a\u5168\u989d\u6392\u7a0b\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4", (String)"PayScheServiceImpl_19", (String)"tmc-psd-business", (Object[])new Object[0]), batchnum));
            }
            List<PayScheCalcModel> mergeDataList = scheDataList.parallelStream().filter(o -> Objects.nonNull(o) && o.isArchiveMerger() && o.isBillDibs() == false).collect(Collectors.toList());
            Map map = PayScheduleHelper.getBatchApplyAmount(scheDataList);
            if (EmptyUtil.isNoEmpty(mergeDataList)) {
                HashSet batchnumSet = new HashSet();
                mergeDataList.forEach(data -> {
                    String batchNum = data.getBatchnum();
                    BigDecimal applyAmt = data.getApplyAmt();
                    BigDecimal dealApplyAmt = (BigDecimal)batchScheAmount.get(batchNum);
                    if (dealApplyAmt != null) {
                        applyAmt = dealApplyAmt;
                    }
                    if (applyAmt.compareTo(data.getScheAmt().add(data.getDraftBillAmt())) != 0) {
                        batchnumSet.add(data.getBatchnum());
                    }
                });
                if (EmptyUtil.isNoEmpty(batchnumSet)) {
                    String numStr = batchnumSet.stream().collect(Collectors.joining(","));
                    logger.info("--- PayScheServiceImpl,fullAmountValidate: error numStr=", (Object)numStr);
                    String errormsg = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u5408\u5e76\u6279\u6b21\u53f7[%s]\u672a\u5168\u989d\u6392\u7a0b\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"PayScheBillFullAmountValidator_0", (String)"tmc-psd-business", (Object[])new Object[0]), numStr);
                    throw new KDBizException(errormsg);
                }
            }
        }
        return result;
    }

    private void validateCombineBotp(List<PayScheCalcModel> scheDataList, PayScheProcessResult result) {
        Map scheIdToScheMap = scheDataList.stream().collect(Collectors.toMap(PayScheCalcModel::getScheId, Function.identity(), (a, b) -> a));
        HashSet<PayScheCalcModel> errSet = new HashSet<PayScheCalcModel>(10);
        QFilter scheIdFilter = new QFilter("id", "in", scheIdToScheMap.keySet());
        DynamicObjectCollection scheEntryList = QueryServiceHelper.query((String)"psd_schedulebill", (String)"id, entrys.e_payid", (QFilter[])new QFilter[]{scheIdFilter});
        HashMap<Long, Set> payIdToScheIdMap = new HashMap<Long, Set>(scheEntryList.size());
        for (DynamicObject entry : scheEntryList) {
            long scheId = entry.getLong("id");
            long payId = entry.getLong("entrys.e_payid");
            Set idSet = payIdToScheIdMap.computeIfAbsent(payId, o -> new HashSet());
            idSet.add(scheId);
        }
        if (payIdToScheIdMap.size() == 0) {
            return;
        }
        List<DynamicObject> headPushList = this.getHeadPushPayList(scheDataList, scheIdToScheMap.keySet(), payIdToScheIdMap.keySet());
        for (DynamicObject payBill : headPushList) {
            Long sourceBillId = payBill.getLong("sourcebillid");
            String sourceBillType = payBill.getString("sourcebilltype");
            long payId = payBill.getLong("id");
            Set currScheIdSet = (Set)payIdToScheIdMap.get(payId);
            for (Long scheId : currScheIdSet) {
                PayScheCalcModel scheModel = (PayScheCalcModel)scheIdToScheMap.get(scheId);
                if (scheModel == null) continue;
                String errMsg = ResManager.loadKDString((String)"\u6392\u7a0b\u5355\u201c%1$s\u201d\u5bf9\u5e94\u7684\u4e1a\u52a1\u6e90\u5355\u201c\u7c7b\u578b\uff1a%2$s\uff0cID\uff1a%3$s\u201d\u975e\u5206\u5f55\u4e0b\u63a8\uff0c\u5408\u5e76\u5931\u8d25\u3002", (String)"PayScheServiceImpl_41", (String)"tmc-psd-business", (Object[])new Object[0]);
                result.addErrorMessage(String.format(errMsg, scheModel.getScheNumber(), sourceBillType, String.valueOf(sourceBillId)));
                errSet.add(scheModel);
            }
        }
        scheDataList.removeAll(errSet);
    }

    private List<DynamicObject> getHeadPushPayList(List<PayScheCalcModel> scheDataList, Set<Long> scheIdSet, Set<Long> payIdSet) {
        DynamicObject[] payBillList;
        ArrayList<DynamicObject> headPushList = new ArrayList<DynamicObject>();
        for (DynamicObject payBill : payBillList = TmcDataServiceHelper.load((Object[])payIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"))) {
            DynamicObjectCollection targetRows = payBill.getDynamicObjectCollection("billhead_lk");
            if (targetRows == null || targetRows.size() <= 0) continue;
            headPushList.add(payBill);
        }
        return headPushList;
    }

    public PayScheProcessResult<Tuple<Boolean, String>> manualCombine(List<PayScheCalcModel> scheDataList, String combineNum) {
        PayScheProcessResult result = new PayScheProcessResult();
        result.setResult((Object)Tuple.create((Object)false, null));
        this.validateFreeze(ResManager.loadKDString((String)"\u5408\u5e76", (String)"PayScheProcessorHandler_21", (String)"tmc-psd-business", (Object[])new Object[0]), scheDataList, result);
        this.validateCombineBotp(scheDataList, result);
        this.validateStatus(scheDataList, ScheStatusEnum.SCHEDULING, result.getErrMsgList());
        if (!result.isSuccess()) {
            return result;
        }
        if (scheDataList.size() <= 1) {
            result.addErrorMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u591a\u6761\u6392\u7a0b\u5355\u8fdb\u884c\u5408\u5e76\u3002", (String)"PayScheServiceImpl_20", (String)"tmc-psd-business", (Object[])new Object[0]));
            return result;
        }
        Set combineNumSet = scheDataList.stream().map(PayScheCalcModel::getBatchnum).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        List uniqueCalcProps = PayScheConfigData.getUniqueCalcProps((List)PayScheConfigData.load());
        List combineCtlCalcProps = PayScheConfigData.getCombineCtlCalcProps((List)PayScheConfigData.load());
        combineCtlCalcProps.add("e_sourcebilltype");
        if (combineNumSet.size() > 1) {
            result.addErrorMessage(ResManager.loadKDString((String)"\u5408\u5e76\u6279\u6b21\u53f7\u6570\u91cf\u5927\u4e8e1, \u8bf7\u91cd\u65b0\u9009\u62e9", (String)"PayScheServiceImpl_21", (String)"tmc-psd-business", (Object[])new Object[0]));
            return result;
        }
        DynamicObjectType calcEntryType = PayScheCalcModel.getCalcEntryType();
        Map<String, List<PayScheCalcModel>> combineCtlGroupMap = scheDataList.stream().collect(Collectors.groupingBy(o -> o.getGroupKey(combineCtlCalcProps)));
        if (combineCtlGroupMap.size() > 1) {
            HashMap<String, Set> combineCtlCntMap = new HashMap<String, Set>(combineCtlCalcProps.size());
            for (PayScheCalcModel scheData : scheDataList) {
                for (String combineCtlCalcProp : combineCtlCalcProps) {
                    Object val = scheData.getGroupVal(combineCtlCalcProp);
                    Set valSet = combineCtlCntMap.computeIfAbsent(combineCtlCalcProp, o -> new HashSet());
                    valSet.add(val);
                }
            }
            List illegalFields = combineCtlCntMap.entrySet().stream().filter(o -> ((Set)o.getValue()).size() > 1).map(Map.Entry::getKey).map(o -> calcEntryType.getProperty(o).getDisplayName().getLocaleValue()).collect(Collectors.toList());
            result.addErrorMessage(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u63a7\u5236\u6821\u9a8c\uff1a\u201c%s\u201d\u4e0d\u4e00\u81f4\u3002\u5408\u5e76\u64cd\u4f5c\u4e0d\u5141\u8bb8\u3002", (String)"PayScheServiceImpl_46", (String)"tmc-psd-business", (Object[])new Object[0]), String.join((CharSequence)",", illegalFields)));
            return result;
        }
        Map<String, List<PayScheCalcModel>> groupedMap = scheDataList.stream().collect(Collectors.groupingBy(o -> o.getGroupKey(uniqueCalcProps)));
        if (groupedMap.size() > 1) {
            HashMap<String, Set> fieldValCntMap = new HashMap<String, Set>(uniqueCalcProps.size());
            for (PayScheCalcModel scheData : scheDataList) {
                for (String uniqueCalcProp : uniqueCalcProps) {
                    Object val = scheData.getGroupVal(uniqueCalcProp);
                    Set valSet = fieldValCntMap.computeIfAbsent(uniqueCalcProp, o -> new HashSet());
                    valSet.add(val);
                }
            }
            List illegalFields = fieldValCntMap.entrySet().stream().filter(o -> ((Set)o.getValue()).size() > 1).map(Map.Entry::getKey).map(o -> calcEntryType.getProperty(o).getDisplayName().getLocaleValue()).collect(Collectors.toList());
            result.setResult((Object)Tuple.create((Object)true, (Object)String.format(ResManager.loadKDString((String)"\u5408\u5e76\u4e00\u81f4\u6027\u5b57\u6bb5\u201c%s\u201d\u4e0d\u540c\uff0c\u662f\u5426\u7edf\u4e00\u5408\u5e76\uff1f", (String)"PayScheServiceImpl_22", (String)"tmc-psd-business", (Object[])new Object[0]), String.join((CharSequence)",", illegalFields))));
            result.setNeedConfirm(true);
        } else {
            if (combineNum == null) {
                if (combineNumSet.size() > 0) {
                    combineNum = (String)combineNumSet.iterator().next();
                } else if (null != scheDataList && !scheDataList.isEmpty()) {
                    combineNum = this.generateCombineNum(scheDataList.get(0).getOrgId());
                }
            }
            for (PayScheCalcModel scheData : scheDataList) {
                scheData.setBatchnum(combineNum);
            }
        }
        return result;
    }

    public PayScheProcessResult<Void> manualUniqueCombine(List<PayScheCalcModel> scheDataList, String combineNum) {
        if (scheDataList.size() == 0) {
            PayScheProcessResult result = new PayScheProcessResult();
            result.addErrorMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6392\u7a0b\u5355\u6570\u636e\u3002", (String)"PayScheServiceImpl_23", (String)"tmc-psd-business", (Object[])new Object[0]));
            return result;
        }
        PayScheCalcModel combinedData = scheDataList.stream().filter(o -> EmptyUtil.isNotEmpty((CharSequence)o.getBatchnum())).findAny().orElseGet(() -> null);
        if (combinedData == null) {
            combinedData = scheDataList.get(0);
        }
        return this.uniqueCombine(combinedData, scheDataList, combineNum);
    }

    public PayScheProcessResult<Void> uniqueCombine(PayScheCalcModel uniqueData, List<PayScheCalcModel> scheDataList, String combineNum) {
        PayScheProcessResult result = new PayScheProcessResult();
        if (combineNum == null) {
            combineNum = uniqueData.getBatchnum();
        }
        this.validateCombineBotp(scheDataList, result);
        if (EmptyUtil.isEmpty((String)uniqueData.getBatchnum())) {
            combineNum = this.generateCombineNum(uniqueData.getOrgId());
        }
        List combineUniqueProps = PayScheConfigData.getUniqueCalcProps((List)PayScheConfigData.load());
        for (PayScheCalcModel scheData : scheDataList) {
            for (String uniqueProp : combineUniqueProps) {
                scheData.setCalcPropVal(uniqueProp, uniqueData.getCalcPropVal(uniqueProp));
                scheData.setBatchnum(combineNum);
            }
        }
        return new PayScheProcessResult();
    }

    public PayScheProcessResult<Void> cancelCombine(List<PayScheCalcModel> scheDataList, List<Long> scheIdList) {
        PayScheProcessResult result = new PayScheProcessResult();
        HashSet<Long> scheIdSet = new HashSet<Long>(scheIdList);
        this.validateFreeze(ResManager.loadKDString((String)"\u53d6\u6d88\u5408\u5e76", (String)"PayScheProcessorHandler_18", (String)"tmc-psd-business", (Object[])new Object[0]), scheDataList, result);
        for (PayScheCalcModel data : scheDataList) {
            if (!scheIdSet.contains(data.getScheId())) continue;
            data.setBatchnum(null);
        }
        Map<String, List<PayScheCalcModel>> combineGroupMap = scheDataList.stream().filter(o -> EmptyUtil.isNotEmpty((CharSequence)o.getBatchnum())).filter(o -> !o.isArchiveMerger()).collect(Collectors.groupingBy(PayScheCalcModel::getBatchnum));
        for (List<PayScheCalcModel> groupedList : combineGroupMap.values()) {
            if (groupedList.size() != 1) continue;
            groupedList.get(0).setBatchnum(null);
        }
        return result;
    }

    public PayScheProcessResult<Void> cleanField(List<PayScheCalcModel> scheduleDataList, PayScheProcessorInfo processorInfo) {
        for (PayScheCalcModel psc : scheduleDataList) {
            this.cleanFiledValues(psc, processorInfo);
        }
        return new PayScheProcessResult();
    }

    public PayScheProcessResult<Void> removeCombine(List<PayScheCalcModel> scheDataList, List<Long> scheIdList) {
        PayScheProcessResult result = new PayScheProcessResult();
        for (PayScheCalcModel scheData : scheDataList) {
            if (!scheIdList.contains(scheData.getScheId()) || !EmptyUtil.isNotEmpty((CharSequence)scheData.getBatchnum())) continue;
            result.addErrorMessage(String.format(ResManager.loadKDString((String)"\u5df2\u5408\u5e76\u6392\u7a0b\u5355\u201c%s\u201d\u65e0\u6cd5\u79fb\u9664\u3002", (String)"PayScheServiceImpl_24", (String)"tmc-psd-business", (Object[])new Object[0]), scheData.getScheNumber()));
        }
        List waitRemoveList = scheDataList.stream().filter(o -> EmptyUtil.isEmpty((String)o.getBatchnum()) && scheIdList.contains(o.getScheId())).collect(Collectors.toList());
        if (scheDataList.size() == waitRemoveList.size()) {
            result.setReload(true);
        }
        result.setNeedDeleteDataList(waitRemoveList);
        return result;
    }

    public PayScheProcessResult<PayScheCalcModel> createSplitOriginData(PayScheCalcModel originData) {
        PayScheCalcModel originSplitData = originData.cloneBean();
        originSplitData.setSummaryId(0L);
        originSplitData.setApplyAmt(BigDecimal.ZERO);
        originSplitData.setScheAmt(BigDecimal.ZERO);
        originSplitData.setDraftBillAmt(BigDecimal.ZERO);
        originSplitData.setScheBalance(BigDecimal.ZERO);
        originSplitData.setCreateTime(new Date());
        return new PayScheProcessResult((Object)originSplitData);
    }

    public PayScheProcessResult<Boolean> checkSplit(PayScheCalcModel originData) {
        PayScheProcessResult result = new PayScheProcessResult();
        ArrayList<PayScheCalcModel> needValidList = new ArrayList<PayScheCalcModel>(Collections.singletonList(originData));
        this.validateFreeze(ResManager.loadKDString((String)"\u62c6\u5206", (String)"PayScheProcessorHandler_09", (String)"tmc-psd-business", (Object[])new Object[0]), needValidList, result);
        this.validateAmtIsZero(needValidList, result.getErrMsgList());
        this.validateStatus(needValidList, ScheStatusEnum.SCHEDULING, result.getErrMsgList());
        result.setResult((Object)result.isSuccess());
        return result;
    }

    public PayScheProcessResult<PayScheCalcModel> split(PayScheCalcModel originData) {
        return this.split(originData, null);
    }

    public PayScheProcessResult<PayScheCalcModel> split(PayScheCalcModel originData, BigDecimal splitAmt) {
        PayScheCalcModel splitData = this.createSplitData(originData, splitAmt);
        this.fillNewScheDataIdInfo(Collections.singletonList(splitData));
        return new PayScheProcessResult((Object)splitData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PayScheProcessResult<Void> freeze(List<PayScheCalcModel> scheDataList, String pageId) {
        PayScheProcessResult result = new PayScheProcessResult();
        this.validateFreezeCheck(scheDataList, (PayScheProcessResult<Void>)result);
        ArrayList lockDraftInfoIds = new ArrayList(16);
        try {
            if (scheDataList.size() > 0) {
                scheDataList.stream().forEach(model -> {
                    List<Long> draftBillIds = model.getDraftBillIds();
                    if (draftBillIds != null && 0 < draftBillIds.size()) {
                        lockDraftInfoIds.addAll(model.getDraftBillIds());
                    }
                });
                if (lockDraftInfoIds.size() > 0) {
                    logger.info("\u5f53\u524d\u5df2\u9501\u5b9a\u7684\u7968\u636e\u4e3a\uff1a " + LoggerPrintHelper.printObjectLoggerByToString(lockDraftInfoIds));
                    PayScheHelper.changeDraftLockCache(lockDraftInfoIds, null, pageId);
                    logger.info("\u91ca\u653e\u7968\u636e\u6210\u529f");
                }
                scheDataList.stream().filter(Objects::nonNull).forEach(model -> {
                    model.setDraftBillIds(new ArrayList<Long>(0));
                    model.setFreezeStatus(FreezeStatusEnum.ManualFrozen.getValue());
                });
                logger.info("\u51bb\u7ed3\u6210\u529f");
            }
        }
        catch (Exception e) {
            try {
                if (lockDraftInfoIds.size() > 0) {
                    result.addErrorMessage(ResManager.loadKDString((String)"\u51bb\u7ed3\u64cd\u4f5c\u91ca\u653e\u7968\u636e\u5931\u8d25\u3002", (String)"PayScheServiceImpl_40", (String)"tmc-psd-business", (Object[])new Object[0]));
                    PayScheHelper.changeDraftLockCache(null, lockDraftInfoIds, pageId);
                }
                logger.error("\u975e\u7968\u636e\u91ca\u653e\u95ee\u9898 --> \u6392\u67e5\u3002");
            }
            catch (Exception e1) {
                logger.error("Freeze OPs rollback error: " + e1);
                result.addErrorMessage(ResManager.loadKDString((String)"\u51bb\u7ed3\u64cd\u4f5c\u56de\u6eda\u9501\u5b9a\u7968\u636e\u5931\u8d25\u3002", (String)"PayScheServiceImpl_39", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
            finally {
                lockDraftInfoIds.clear();
            }
            logger.info(String.format("Release DraftNos error\uff1a%s", LoggerPrintHelper.printObjectLoggerByJSON((Object[])new Exception[]{e})));
        }
        return result;
    }

    private void validateFreezeCheck(List<PayScheCalcModel> scheDataList, PayScheProcessResult<Void> result) {
        List nonMatchedList1 = scheDataList.stream().filter(model -> {
            String freezeStatus = model.getFreezeStatus();
            return null != freezeStatus && !freezeStatus.trim().equals("") && !FreezeStatusEnum.UnFrozen.getValue().equals(freezeStatus);
        }).collect(Collectors.toList());
        scheDataList.removeAll(nonMatchedList1);
        for (PayScheCalcModel payScheCalcModel : nonMatchedList1) {
            result.addErrorMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u6709\u672a\u51bb\u7ed3\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u624d\u80fd\u8fdb\u884c\u51bb\u7ed3\u3002", (String)"PayScheServiceImpl_25", (String)"tmc-psd-business", (Object[])new Object[0]), payScheCalcModel.getScheNumber()));
        }
        List nonMatchedList2 = scheDataList.stream().filter(model -> {
            String scheStatus = model.getScheStatus();
            return !ScheStatusEnum.SCHEDULING.getValue().equals(scheStatus);
        }).collect(Collectors.toList());
        scheDataList.removeAll(nonMatchedList2);
        for (PayScheCalcModel payScheCalcModel : nonMatchedList2) {
            result.addErrorMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u6709\u5904\u4e8e\u6392\u7a0b\u4e2d\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u624d\u80fd\u88ab\u51bb\u7ed3\u3002", (String)"PayScheServiceImpl_26", (String)"tmc-psd-business", (Object[])new Object[0]), payScheCalcModel.getScheNumber()));
        }
    }

    public PayScheProcessResult<Void> thaw(List<PayScheCalcModel> scheDataList) {
        PayScheProcessResult result = new PayScheProcessResult();
        for (PayScheCalcModel scheData : scheDataList) {
            String freezeStatus = scheData.getFreezeStatus();
            if (null != freezeStatus && !freezeStatus.trim().equals("") && !FreezeStatusEnum.ManualFrozen.getValue().equals(freezeStatus)) {
                result.addErrorMessage(String.format(ResManager.loadKDString((String)"%s: \u4ec5\u652f\u6301\u624b\u5de5\u51bb\u7ed3\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u89e3\u51bb\u3002", (String)"PayScheServiceImpl_27", (String)"tmc-psd-business", (Object[])new Object[0]), scheData.getScheNumber()));
                continue;
            }
            scheData.setFreezeStatus(FreezeStatusEnum.UnFrozen.getValue());
        }
        return result;
    }

    public PayScheProcessResult<Void> updateTransferAmt(List<PayScheDraftInfo> payScheDraftInfos, List<PayScheCalcModel> scheDataList, Map<Long, BigDecimal> schDraftAmounts) {
        PayScheProcessResult result = new PayScheProcessResult();
        for (PayScheDraftInfo payScheDraftInfo : payScheDraftInfos) {
            Long draftId = payScheDraftInfo.getDraftId();
            scheDataList.stream().map(o -> o.getPayScheDraftInfos()).flatMap(Collection::stream).filter(o -> o.getDraftId().compareTo(draftId) == 0).forEach(o -> o.setTransferAmt(payScheDraftInfo.getTransferAmt()));
        }
        this.setDraftAmounts(scheDataList, schDraftAmounts);
        return result;
    }

    public <T> void validateFreeze(String opName, List<PayScheCalcModel> scheDataList, PayScheProcessResult<T> result) {
        List freezeDataLst = scheDataList.stream().filter(o -> {
            boolean freeze = true;
            String freezeStatus = o.getFreezeStatus();
            if (FreezeStatusEnum.UnFrozen.getValue().equals(freezeStatus)) {
                freeze = false;
            }
            return freeze;
        }).collect(Collectors.toList());
        scheDataList.removeAll(freezeDataLst);
        for (PayScheCalcModel model : freezeDataLst) {
            String errorMsg = String.format("%s: %s", model.getScheNumber(), String.format(ResManager.loadKDString((String)"\u51bb\u7ed3\u6570\u636e\u4e0d\u5141\u8bb8\u8be5\u64cd\u4f5c\u3002", (String)"PayScheServiceImpl_28", (String)"tmc-psd-business", (Object[])new Object[0]), new Object[0]));
            result.getErrMsgList().add(errorMsg);
        }
    }

    private PayScheCalcModel createSplitData(PayScheCalcModel originData, BigDecimal splitAmt) {
        PayScheCalcModel splitData = originData.cloneBean();
        splitData.setSummaryId(0L);
        splitData.setSplitId(originData.getScheId());
        splitData.setSplitno(originData.getScheNumber());
        splitData.setApplyAmt((BigDecimal)ObjectUtils.defaultIfNull((Object)splitAmt, (Object)BigDecimal.ZERO));
        splitData.setScheAmt(BigDecimal.ZERO);
        splitData.setDraftBillAmt(BigDecimal.ZERO);
        splitData.setScheBalance(BigDecimal.ZERO);
        splitData.setCreateTime(new Date());
        MainEntityType scheBillEntityType = EntityMetadataCache.getDataEntityType((String)"psd_schedulebill");
        DynamicObject originDataDy = TmcDataServiceHelper.loadSingle((Object)originData.getScheId(), (DynamicObjectType)scheBillEntityType);
        String number = CodeRuleHelper.generateNumber((String)"psd_schedulebill", (DynamicObject)originDataDy, (String)originData.getOrgId().toString(), (String)"");
        splitData.setScheNumber(number);
        return splitData;
    }

    public PayScheProcessResult<List<Long>> batchUpdateScheData(List<PayScheCalcModel> oldScheDataList, List<PayScheCalcModel> newScheDataList, PayScheProcessorInfo processorInfo, String pageId, BigDecimal draftTransAmounts) {
        List<PayScheCalcModel> upVirtMegerLst = oldScheDataList.stream().filter(PayScheCalcModel::isArchiveMerger).collect(Collectors.toList());
        List<PayScheCalcModel> upTruePaySches = oldScheDataList.stream().filter(o -> !o.isArchiveMerger()).collect(Collectors.toList());
        PayScheProcessResult<List<Long>> virResult = this.updateScheData(upVirtMegerLst, newScheDataList, processorInfo, pageId, draftTransAmounts);
        List revertIds = (List)virResult.getResult();
        List upSucceedVirtPayScheLst = newScheDataList.stream().filter(o -> !revertIds.contains(o.getScheId())).collect(Collectors.toList());
        if (virResult.isSuccess()) {
            ArrayList<String> replaceProps = new ArrayList<String>(10);
            replaceProps.add("e_expectdate");
            replaceProps.add("e_acctbank");
            replaceProps.add("e_draftpaymethod");
            replaceProps.add("e_draftsettletype");
            replaceProps.add("e_draftpaychannel");
            replaceProps.add("e_limitbank");
            replaceProps.add("e_draftno");
            replaceProps.add("e_isbilldibs");
            replaceProps.add("e_dibsbalance");
            replaceProps.add("e_itempayee");
            replaceProps.add("e_itempayeetype");
            replaceProps.add("e_draftpayacct");
            replaceProps.add("e_exchangerate");
            replaceProps.add("e_businesstype");
            replaceProps.add("e_institutioncode");
            replaceProps.add("e_institutionname");
            replaceProps.add("e_lcarrival");
            for (PayScheCalcModel newScheData : upSucceedVirtPayScheLst) {
                List<PayScheCalcModel> needDealTurePaySches = upTruePaySches.stream().filter(o -> o.getBatchnum().equals(newScheData.getBatchnum())).collect(Collectors.toList());
                if (!EmptyUtil.isNoEmpty(needDealTurePaySches)) continue;
                for (PayScheCalcModel upTruePaySch : needDealTurePaySches) {
                    if (!newScheData.isArchiveMerger()) continue;
                    upTruePaySch.updateData(newScheData, replaceProps);
                }
                this.scheduleAmountDraft(newScheData, needDealTurePaySches);
            }
        }
        Map<Long, PayScheCalcModel> oldScheDataMapById = oldScheDataList.stream().collect(Collectors.toMap(PayScheCalcModel::getScheId, o -> o));
        this.cleanDibsInfo(processorInfo, upTruePaySches, oldScheDataMapById);
        this.initDraftInfo(upTruePaySches, pageId);
        return virResult;
    }

    public PayScheProcessResult<List<Long>> updateScheData(List<PayScheCalcModel> oldScheDataList, List<PayScheCalcModel> newScheDataList, PayScheProcessorInfo processorInfo, String pageId, BigDecimal draftTransAmounts) {
        PayScheProcessResult result = new PayScheProcessResult();
        Map<Long, PayScheCalcModel> oldScheDataMapById = oldScheDataList.stream().collect(Collectors.toMap(PayScheCalcModel::getScheId, o -> o));
        ArrayList<PayScheCalcModel> needRevertDataList = new ArrayList<PayScheCalcModel>();
        List settleTypeIdList = newScheDataList.stream().map(PayScheCalcModel::getSettleTypeId).distinct().collect(Collectors.toList());
        DynamicObject[] setTypes = TmcDataServiceHelper.load((Object[])settleTypeIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_settlementtype"));
        Map<Long, String> settypeMap = Arrays.stream(setTypes).collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getString("settlementtype")));
        Map scaleMap = TmcAmountHelper.getScaleMap(newScheDataList.stream().map(PayScheCalcModel::getCurrencyId).collect(Collectors.toSet()));
        boolean isCurrencyChanged = false;
        this.cleanDibsInfo(processorInfo, newScheDataList, oldScheDataMapById);
        for (PayScheCalcModel newScheData : newScheDataList) {
            boolean exchangeRateTableChanged;
            DynamicObjectCollection query;
            BigDecimal queryAmt;
            boolean amtErr;
            Integer scale = scaleMap.getOrDefault(newScheData.getCurrencyId(), 0);
            if (EmptyUtil.isEmpty((Long)newScheData.getScheId())) continue;
            PayScheCalcModel oldScheData = oldScheDataMapById.get(newScheData.getScheId());
            boolean bl = amtErr = newScheData.getScheAmt().add(newScheData.getDraftBillAmt()).abs().compareTo(newScheData.getActualApplyAmt(scale).abs()) > 0;
            if (amtErr) {
                if (kd.bos.util.StringUtils.isNotEmpty((String)newScheData.getScheNumber())) {
                    result.addErrorMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u6392\u6b3e\u91d1\u989d\u4e0e\u6392\u7968\u91d1\u989d\u4e4b\u548c\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d", (String)"PayScheServiceImpl_1", (String)"tmc-psd-business", (Object[])new Object[0]), newScheData.getScheNumber()));
                } else {
                    result.addErrorMessage(ResManager.loadKDString((String)"\u6392\u6b3e\u91d1\u989d\u4e0e\u6392\u7968\u91d1\u989d\u4e4b\u548c\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d", (String)"PayScheServiceImpl_45", (String)"tmc-psd-business", (Object[])new Object[0]));
                }
                needRevertDataList.add(newScheData);
                continue;
            }
            if (newScheData.getApplyAmt().multiply(newScheData.getScheAmt()).compareTo(BigDecimal.ZERO) < 0 || newScheData.getApplyAmt().multiply(newScheData.getDraftBillAmt()).compareTo(BigDecimal.ZERO) < 0) {
                result.addErrorMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u6392\u6b3e\u6216\u6392\u7968\u91d1\u989d\u4e0d\u80fd\u4e0e\u7533\u8bf7\u91d1\u989d\u7b26\u53f7\u76f8\u53cd", (String)"PayScheServiceImpl_29", (String)"tmc-psd-business", (Object[])new Object[0]), newScheData.getScheNumber()));
                needRevertDataList.add(newScheData);
                continue;
            }
            BigDecimal exchangerate = newScheData.getExchangerate();
            if (EmptyUtil.isEmpty((BigDecimal)exchangerate) || exchangerate.compareTo(BigDecimal.ZERO) == 0) {
                result.addErrorMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u5151\u6362\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheServiceImpl_11", (String)"tmc-psd-business", (Object[])new Object[0]), newScheData.getScheNumber()));
                needRevertDataList.add(newScheData);
                continue;
            }
            List<Long> draftBillIds = newScheData.getDraftBillIds();
            String draftPayMethod = newScheData.getDraftPayMethod();
            if (DraftPayTypeEnum.DRAFTPAY.getValue().equals(draftPayMethod) && !CollectionUtils.isEmpty(draftBillIds) && (queryAmt = (query = QueryServiceHelper.query((String)"cdm_payablebill", (String)"amount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillIds)})).stream().map(dy -> dy.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)).compareTo(newScheData.getDraftBillAmt()) != 0) {
                result.addErrorMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u5f00\u7968\u4ed8\u6b3e\u4e0d\u5141\u8bb8\u6709\u5dee\u989d\uff0c\u8bf7\u8c03\u6574\u6392\u7968\u91d1\u989d\u6216\u91cd\u65b0\u9009\u62e9\u7968\u636e\uff0c\u786e\u4fdd\u6240\u9009\u7968\u636e\u5b50\u7968\u5305\u91d1\u989d\u4e4b\u548c\u4e0e\u6392\u7968\u91d1\u989d\u76f8\u7b49\u3002", (String)"PayScheServiceImpl_36", (String)"tmc-psd-business", (Object[])new Object[0]), newScheData.getScheNumber()));
                needRevertDataList.add(newScheData);
                continue;
            }
            Long currencyId = newScheData.getCurrencyId();
            if (null == currencyId || currencyId == 0L) {
                result.addErrorMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u4ed8\u6b3e\u5e01\u79cd\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"PayScheServiceImpl_12", (String)"tmc-psd-business", (Object[])new Object[0]), newScheData.getScheNumber()));
                needRevertDataList.add(newScheData);
                continue;
            }
            boolean exchangeRateChanged = oldScheData.getExchangerate().compareTo(exchangerate) != 0;
            boolean currencyChanged = !oldScheData.getCurrencyId().equals(currencyId);
            boolean expectedDataChanged = newScheData.getExpectDate() == null && oldScheData.getExpectDate() != null || newScheData.getExpectDate() != null && oldScheData.getExpectDate() == null || oldScheData.getExpectDate().compareTo(newScheData.getExpectDate()) != 0;
            boolean isNeedCalcRate = !currencyId.equals(newScheData.getApplyCurrencyId()) || currencyChanged;
            Long exratetable = newScheData.getExratetable();
            if (EmptyUtil.isEmpty((Long)exratetable)) {
                result.addErrorMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u5151\u6362\u6c47\u7387\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String)"PayScheServiceImpl_10", (String)"tmc-psd-business", (Object[])new Object[0]), newScheData.getScheNumber()));
                needRevertDataList.add(newScheData);
                continue;
            }
            boolean bl2 = exchangeRateTableChanged = oldScheData.getExratetable().compareTo(exratetable) != 0;
            if (currencyChanged) {
                isCurrencyChanged = true;
                newScheData.setScheAmt(BigDecimal.ZERO);
                newScheData.setDraftBillAmt(BigDecimal.ZERO);
            }
            if (!exchangeRateChanged && isNeedCalcRate && (currencyChanged || expectedDataChanged || exchangeRateTableChanged)) {
                BigDecimal exchangeRate = newScheData.getApplyCurrencyId() != null && newScheData.getApplyCurrencyId().equals(currencyId) ? BigDecimal.ONE : BaseDataServiceHelper.getExchangeRate((Long)exratetable, (Long)newScheData.getApplyCurrencyId(), (Long)currencyId, (Date)newScheData.getExpectDate());
                if (null == exchangeRate || exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                    result.addErrorMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6c47\u7387\u3002\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\uff0c\u518d\u8fdb\u884c\u5f02\u5e01\u79cd\u6392\u6b3e\u3002", (String)"PayScheServiceImpl_6", (String)"tmc-psd-business", (Object[])new Object[0]), newScheData.getScheNumber()));
                    needRevertDataList.add(newScheData);
                    continue;
                }
                newScheData.setExchangerate(exchangeRate);
            }
            if (expectedDataChanged) {
                Date expectDate = newScheData.getExpectDate();
                if (expectDate == null) {
                    result.addErrorMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u6392\u7a0b\u4ed8\u6b3e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"PayScheServiceImpl_30", (String)"tmc-psd-business", (Object[])new Object[0]), newScheData.getScheNumber()));
                    needRevertDataList.add(newScheData);
                } else if (processorInfo.getPeriodTypeId() != null && (expectDate.compareTo(processorInfo.getStartDate()) < 0 || expectDate.compareTo(processorInfo.getEndDate()) > 0)) {
                    result.addErrorMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u6392\u7a0b\u4ed8\u6b3e\u65e5\u671f\u5e94\u5728\u6392\u7a0b\u5f00\u59cb\u4e0e\u7ed3\u675f\u65e5\u671f\u8303\u56f4\u5185\u3002", (String)"PayScheServiceImpl_31", (String)"tmc-psd-business", (Object[])new Object[0]), newScheData.getScheNumber()));
                    needRevertDataList.add(newScheData);
                }
            }
            if (oldScheData == null && null != newScheData || !Objects.equals(newScheData.getSettleTypeId(), oldScheData.getSettleTypeId())) {
                if (newScheData.getSettleTypeId() == null || newScheData.getSettleTypeId() == 0L) {
                    newScheData.setAcctBankType(null);
                    newScheData.setAcctBankId(null);
                } else if (settypeMap.containsKey(newScheData.getSettleTypeId())) {
                    String settlementTypeStr = settypeMap.get(newScheData.getSettleTypeId());
                    if (SettleMentTypeEnum.CASH.getValue().equals(settlementTypeStr)) {
                        newScheData.setAcctBankType("cas_accountcash");
                    } else {
                        newScheData.setAcctBankType("bd_accountbanks");
                    }
                    if (SettleMentTypeEnum.PROMISSORY.getValue().equals(settlementTypeStr)) {
                        newScheData.setPayChannel(PayChannelEnum.COUNTER.getValue());
                    }
                }
            }
            if (oldScheData == null && null != newScheData || EmptyUtil.isEmpty((Long)newScheData.getCurrencyId()) || EmptyUtil.isEmpty((Long)newScheData.getApplyCurrencyId()) || newScheData.getCurrencyId().compareTo(newScheData.getApplyCurrencyId()) != 0) {
                newScheData.setDraftBillIds(null);
            }
            if (oldScheData == null && null != newScheData || !Objects.equals(draftPayMethod, oldScheData.getDraftPayMethod())) {
                Long oldDraftSettleTypeId;
                newScheData.setDraftBillIds(null);
                if (DraftPayTypeEnum.DRAFTBOOK.getValue().equals(draftPayMethod) && oldScheData != null && null != (oldDraftSettleTypeId = oldScheData.getDraftSettleTypeId())) {
                    DynamicObject settlementTypeObj = TmcDataServiceHelper.loadSingle((Object)oldDraftSettleTypeId, (String)"bd_settlementtype");
                    String settlementType = Optional.ofNullable(settlementTypeObj).map(o -> o.getString("settlementtype")).orElseGet(() -> null);
                    ArrayList<String> draftSettleTypeLst = new ArrayList<String>(2){
                        {
                            this.add(SettleMentTypeEnum.PROMISSORY.getValue());
                            this.add(SettleMentTypeEnum.CHECK.getValue());
                        }
                    };
                    if (settlementType != null && draftSettleTypeLst.contains(settlementType)) {
                        newScheData.setDraftSettleTypeId(null);
                    }
                }
            }
            if (oldScheData == null && null != newScheData || !Objects.equals(newScheData.getDraftSettleTypeId(), oldScheData.getDraftSettleTypeId())) {
                newScheData.setDraftBillIds(null);
            }
            if (!CollectionUtils.isEmpty(draftBillIds)) {
                if (draftTransAmounts != null) {
                    newScheData.setDraftBillAmt(draftTransAmounts);
                } else {
                    BigDecimal draftAmt = this.getTransAmount(oldScheData);
                    BigDecimal balance = newScheData.getApplyAmt().subtract(newScheData.getScheAmt());
                    BigDecimal setDraftAmt = BigDecimal.ZERO;
                    setDraftAmt = draftAmt.compareTo(balance) > 0 ? balance : draftAmt;
                    newScheData.setDraftBillAmt(setDraftAmt);
                }
            }
            this.addDibsInfo(newScheData, draftBillIds);
            boolean isMoreThanApplyAmount = newScheData.isNegativeBalance(scale);
            if (isMoreThanApplyAmount) {
                result.addErrorMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u6392\u6b3e\u91d1\u989d\u4e0e\u6392\u7968\u91d1\u989d\u4e4b\u548c\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d", (String)"PayScheServiceImpl_1", (String)"tmc-psd-business", (Object[])new Object[0]), newScheData.getScheNumber()));
            }
            if (!Objects.nonNull(pageId)) continue;
            PayScheHelper.changeDraftLockCache(oldScheData.getDraftBillIds(), newScheData.getDraftBillIds(), pageId);
        }
        newScheDataList.removeAll(needRevertDataList);
        block1: for (PayScheCalcModel oldScheData : oldScheDataList) {
            for (PayScheCalcModel newScheData : newScheDataList) {
                if (!oldScheData.getScheId().equals(newScheData.getScheId())) continue;
                oldScheData.replaceData(newScheData);
                continue block1;
            }
        }
        List needRevertIdList = needRevertDataList.stream().map(PayScheCalcModel::getScheId).collect(Collectors.toList());
        result.setResult(needRevertIdList);
        result.setReload(isCurrencyChanged && needRevertIdList.size() != oldScheDataList.size() && !oldScheDataList.get(0).isArchiveMerger());
        this.initDraftInfo(oldScheDataList, pageId);
        this.doTransDraft(oldScheDataList);
        return result;
    }

    private void doTransDraft(List<PayScheCalcModel> oldScheDataList) {
        HashMap<Long, BigDecimal> draftAmounts = new HashMap<Long, BigDecimal>(oldScheDataList.size());
        for (PayScheCalcModel waitUpdateCalcModel : oldScheDataList) {
            List<PayScheDraftInfo> payScheDraftInfos = waitUpdateCalcModel.getPayScheDraftInfos();
            if (payScheDraftInfos == null || payScheDraftInfos.size() == 0) continue;
            Long schId = waitUpdateCalcModel.getScheId();
            BigDecimal draftAmount = (BigDecimal)draftAmounts.get(schId);
            if (draftAmount == null) {
                draftAmount = BigDecimal.ZERO;
            }
            for (PayScheDraftInfo payScheDraftInfo : payScheDraftInfos) {
                draftAmount = draftAmount.add(payScheDraftInfo.getTransferAmt());
            }
            draftAmounts.put(schId, draftAmount);
        }
        this.setDraftAmounts(oldScheDataList, draftAmounts);
    }

    private void setDraftAmounts(List<PayScheCalcModel> payScheCalcModels, Map<Long, BigDecimal> draftAmounts) {
        for (PayScheCalcModel oldScheDat : payScheCalcModels) {
            Long schId = oldScheDat.getScheId();
            BigDecimal draftAmount = draftAmounts.get(schId);
            if (draftAmount == null || BigDecimal.ZERO.compareTo(draftAmount) == 0) continue;
            BigDecimal balance = oldScheDat.getApplyAmt().subtract(oldScheDat.getScheAmt());
            BigDecimal setDraftAmt = BigDecimal.ZERO;
            setDraftAmt = draftAmount.compareTo(balance) > 0 ? balance : draftAmount;
            oldScheDat.setDraftBillAmt(setDraftAmt);
        }
    }

    public PayScheProcessResult<Void> initCombineData(List<PayScheCalcModel> scheDataList) {
        for (PayScheCalcModel scheData : scheDataList) {
            scheData.setBatchnumBak(scheData.getBatchnum());
        }
        return new PayScheProcessResult();
    }

    private void validateStatus(List<PayScheCalcModel> scheDataList, ScheStatusEnum status, List<String> errMsgList) {
        List nonMatchedList = scheDataList.stream().filter(o -> !status.getValue().equals(o.getScheStatus())).collect(Collectors.toList());
        scheDataList.removeAll(nonMatchedList);
        for (PayScheCalcModel payScheCalcModel : nonMatchedList) {
            String errMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u6392\u7a0b\u72b6\u6001\u4e0d\u7b49\u4e8e%2$s\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c", (String)"PayScheServiceImpl_7", (String)"tmc-psd-business", (Object[])new Object[0]), payScheCalcModel.getScheNumber(), status.getName());
            errMsgList.add(errMsg);
        }
    }

    private void validateBatchnum(List<PayScheCalcModel> scheDataList, List<String> errMsgList) {
        List combineData = scheDataList.stream().filter(o -> EmptyUtil.isNoEmpty((String)o.getBatchnum())).collect(Collectors.toList());
        scheDataList.removeAll(combineData);
        for (PayScheCalcModel payScheCalcModel : combineData) {
            String errMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u6392\u7a0b\u5355\u5df2\u5408\u5e76\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c", (String)"PayScheServiceImpl_9", (String)"tmc-psd-business", (Object[])new Object[0]), payScheCalcModel.getScheNumber());
            errMsgList.add(errMsg);
        }
    }

    private void validateAmtIsZero(List<PayScheCalcModel> scheDataList, List<String> errMsgList) {
        List nonMatchedList = scheDataList.stream().filter(o -> BigDecimal.ZERO.compareTo(o.getScheAmt()) != 0 || BigDecimal.ZERO.compareTo(o.getDraftBillAmt()) != 0).collect(Collectors.toList());
        scheDataList.removeAll(nonMatchedList);
        for (PayScheCalcModel payScheCalcModel : nonMatchedList) {
            String errMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u6392\u6b3e\u91d1\u989d\u548c\u6392\u7968\u91d1\u989d\u4e0d\u5168\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c", (String)"PayScheServiceImpl_8", (String)"tmc-psd-business", (Object[])new Object[0]), payScheCalcModel.getScheNumber());
            errMsgList.add(errMsg);
        }
    }

    private <T> void validatePayScheOrDraft(List<PayScheCalcModel> scheDataList, String opName, PayScheProcessResult<T> result) {
        List containBatchNoPaySches = scheDataList.stream().filter(Objects::nonNull).filter(o -> EmptyUtil.isNoEmpty((String)o.getBatchnum())).filter(o -> EmptyUtil.isNoEmpty((String)o.getBatchnum().trim())).filter(o -> !o.isArchiveMerger()).collect(Collectors.toList());
        scheDataList.removeAll(containBatchNoPaySches);
        for (PayScheCalcModel containBatchNoPaySch : containBatchNoPaySches) {
            String errorMsg = String.format("%s: %s", containBatchNoPaySch.getScheNumber(), ResManager.loadKDString((String)"\u5408\u5e76\u540e\u4e0d\u5141\u8bb8\u8be5\u64cd\u4f5c\uff0c\u8bf7\u4f7f\u7528\u5408\u5e76\u6392\u7a0b\u8fdb\u884c\u5904\u7406\u3002", (String)"PayScheServiceImpl_42", (String)"tmc-psd-business", (Object[])new Object[0]));
            result.getErrMsgList().add(errorMsg);
        }
    }

    private void fillNewScheDataIdInfo(List<PayScheCalcModel> newScheDataList) {
        if (CollectionUtils.isEmpty(newScheDataList)) {
            return;
        }
        long[] idArr = DB.genLongIds((String)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill").getAlias(), (int)newScheDataList.size());
        for (int i = 0; i < newScheDataList.size(); ++i) {
            PayScheCalcModel newScheData = newScheDataList.get(i);
            newScheData.setScheId(idArr[i]);
            newScheData.setNewScheData(true);
        }
    }

    private String generateCombineNum(Long orgId) {
        String orgIdStr = orgId == null ? "" : orgId.toString();
        StringBuilder numberStr = new StringBuilder(orgIdStr);
        numberStr.append("-").append(DateFormatUtils.format((long)System.currentTimeMillis(), (String)"yyyyMMdd"));
        Queue serialNumberQueue = SerialNumberHelper.getSerialNum((String)"psd_schebillcalc", (String)"e_batchnum", (String)"", (int)8, (int)1);
        numberStr.append("-").append((String)serialNumberQueue.remove());
        return numberStr.toString();
    }

    private void scheduleAmountDraft(PayScheCalcModel mergeData, List<PayScheCalcModel> entryDataList) {
        BigDecimal mergeScheAmt = mergeData.getScheAmt();
        BigDecimal mergeDraftAmt = mergeData.getDraftBillAmt();
        BigDecimal applySumAmt = entryDataList.parallelStream().map(PayScheCalcModel::getApplyAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.orderEntry(entryDataList);
        Long currencyId = mergeData.getCurrencyId();
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
        int scale = EmptyUtil.isEmpty((DynamicObject)currency) ? 0 : currency.getInt("amtprecision");
        BigDecimal cumScheAmt = BigDecimal.ZERO;
        BigDecimal scheduledAmt = BigDecimal.ZERO;
        BigDecimal cumDraftAmt = BigDecimal.ZERO;
        int size = entryDataList.size();
        for (int i = 0; i < size; ++i) {
            PayScheCalcModel entryData = entryDataList.get(i);
            entryData.setExpectPayDate(mergeData.getExpectPayDate());
            entryData.setCurrencyId(mergeData.getCurrencyId());
            entryData.setSettleTypeId(mergeData.getSettleTypeId());
            entryData.setPayChannel(mergeData.getPayChannel());
            entryData.setAcctBankType(mergeData.getAcctBankType());
            entryData.setPayeeAcct(mergeData.getPayeeAcct());
            entryData.setDraftpaychannel(mergeData.getDraftpaychannel());
            entryData.setDraftSettleTypeId(mergeData.getDraftSettleTypeId());
            entryData.setDraftPayMethod(mergeData.getDraftPayMethod());
            ArrayList<Long> mergeDraftBillIds = mergeData.getDraftBillIds() != null ? new ArrayList<Long>(mergeData.getDraftBillIds()) : new ArrayList(0);
            entryData.setDraftBillIds(mergeDraftBillIds);
            BigDecimal applyAmt = entryData.getApplyAmt();
            if (mergeData.getExchangerate().compareTo(BigDecimal.ONE) != 0) {
                applyAmt = applyAmt.multiply(entryData.getExchangerate()).setScale(scale, 4);
            }
            BigDecimal newScheAmt = BigDecimal.ZERO;
            BigDecimal newDraftAmt = BigDecimal.ZERO;
            if (mergeDraftAmt.compareTo(cumDraftAmt) > 0) {
                if (i == size - 1) {
                    newDraftAmt = mergeDraftAmt.subtract(cumDraftAmt);
                } else {
                    newDraftAmt = PayScheServiceImpl.calcEntryAmount(applyAmt, applySumAmt, mergeDraftAmt, scale);
                    cumDraftAmt = cumDraftAmt.add(newDraftAmt);
                }
            }
            if (mergeScheAmt.compareTo(cumScheAmt) > 0) {
                newScheAmt = applyAmt.subtract(newDraftAmt);
                if (i != size - 1) {
                    cumScheAmt = cumScheAmt.add(newScheAmt);
                }
                if (mergeScheAmt.compareTo(scheduledAmt = scheduledAmt.add(newScheAmt)) < 0) {
                    newScheAmt = scheduledAmt.subtract(mergeScheAmt);
                }
            }
            entryData.setScheAmt(newScheAmt);
            entryData.setDraftBillAmt(newDraftAmt);
        }
    }

    private void orderEntry(List<PayScheCalcModel> entryDataList) {
        Collections.sort(entryDataList, new Comparator<PayScheCalcModel>(){

            @Override
            public int compare(PayScheCalcModel b1, PayScheCalcModel b2) {
                try {
                    return b1.getApplyAmt().compareTo(b2.getApplyAmt());
                }
                catch (Exception e) {
                    logger.error("error:", (Throwable)e);
                    return 0;
                }
            }
        });
    }

    private static BigDecimal calcEntryAmount(BigDecimal entryApplyAmt, BigDecimal applySumAmt, BigDecimal mergeAmt, int scale) {
        if (BigDecimal.ZERO.compareTo(entryApplyAmt) == 0) {
            return BigDecimal.ZERO;
        }
        if (BigDecimal.ZERO.compareTo(applySumAmt) == 0) {
            return BigDecimal.ZERO;
        }
        if (BigDecimal.ZERO.compareTo(mergeAmt) == 0) {
            return BigDecimal.ZERO;
        }
        return mergeAmt.multiply(entryApplyAmt).divide(applySumAmt, scale, 4);
    }

    private void addDibsInfo(PayScheCalcModel newScheData, List<Long> draftBillIds) {
        if (newScheData.isBillDibs() != null && newScheData.isBillDibs().booleanValue()) {
            BigDecimal draftBillAmount = newScheData.getApplyAmt();
            BigDecimal draftAmount = PayScheHelper.getDraftsAmts(draftBillIds);
            newScheData.setDraftBillAmt(draftBillAmount);
            if ((EmptyUtil.isEmpty((String)newScheData.getBatchnum()) || newScheData.isArchiveMerger()) && newScheData.isBillDibs().booleanValue()) {
                BigDecimal balance = draftAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : draftAmount.subtract(draftBillAmount);
                newScheData.setBalance(balance);
            }
            newScheData.setDraftPayMethod("draftbook");
            newScheData.setScheAmt(BigDecimal.ZERO);
            newScheData.setSettleTypeId(null);
            newScheData.setPayChannel(null);
            newScheData.setAcctBankType(null);
        }
    }

    private void cleanDibsInfo(PayScheProcessorInfo processorInfo, List<PayScheCalcModel> newScheDataList, Map<Long, PayScheCalcModel> oldScheDataMapById) {
        for (PayScheCalcModel newScheData : newScheDataList) {
            PayScheCalcModel oldScheData = oldScheDataMapById.get(newScheData.getScheId());
            Boolean executeNext = null != oldScheData.isBillDibs() && oldScheData.isBillDibs() != false && null != newScheData.isBillDibs() && newScheData.isBillDibs() == false;
            if (!executeNext.booleanValue()) continue;
            this.cleanFiledValues(newScheData, processorInfo);
        }
    }

    private void cleanFiledValues(PayScheCalcModel newScheData, PayScheProcessorInfo processorInfo) {
        List<Long> draftInfoIds = newScheData.getDraftBillIds();
        String pageIdForDibs = processorInfo.getPageIdForBids();
        if (EmptyUtil.isNoEmpty((String)pageIdForDibs) && draftInfoIds != null && draftInfoIds.size() > 0) {
            logger.info("PayScheServiceImpl:: The locked of draft bills are {} ", (Object)LoggerPrintHelper.printObjectLoggerByToString(draftInfoIds));
            new DraftBillLockCache(pageIdForDibs).release(draftInfoIds);
            logger.info("PayScheServiceImpl:: release lock successfully");
        }
        newScheData.setBillDibs(false);
        newScheData.setDraftBillIds(new ArrayList<Long>(0));
        newScheData.setPayScheDraftInfos(new ArrayList<PayScheDraftInfo>(0));
        newScheData.setBalance(BigDecimal.ZERO);
        newScheData.setDibsBalance(null);
        newScheData.setDraftPayMethod("");
        newScheData.setDraftBillAmt(BigDecimal.ZERO);
    }

    private void initDraftInfo(List<PayScheCalcModel> waitUpdateCalcModels, String pageId) {
        Set draftIds = waitUpdateCalcModels.stream().map(o -> o.getDraftBillIds()).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        DynamicObject[] draftDBInfoArr = TmcDataServiceHelper.load((String)"cdm_payandrecdraft_f7", (String)"id,amount,rptype,draftbilltype.billmedium,issplit,elccirculatestatus,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftIds)});
        Map<Long, DynamicObject> draftMapRelation = Arrays.stream(draftDBInfoArr).collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        for (PayScheCalcModel calcModel : waitUpdateCalcModels) {
            if (EmptyUtil.isNoEmpty((String)calcModel.getBatchnum()) && !calcModel.isMasterData() && !calcModel.isArchiveMerger()) continue;
            int size = 0;
            Set<Object> oldIdSet = new HashSet(16);
            if (calcModel.getDraftBillIds() != null) {
                size = calcModel.getDraftBillIds().size();
                oldIdSet = calcModel.getDraftBillIds().stream().collect(Collectors.toSet());
            }
            calcModel.initPayScheDraftInfo(draftMapRelation);
            if (calcModel.getDraftBillIds() == null || calcModel.getDraftBillIds().size() >= size) continue;
            Set realIdSet = calcModel.getDraftBillIds().stream().collect(Collectors.toSet());
            Set releaseIds = oldIdSet.stream().filter(o -> !realIdSet.contains(o)).collect(Collectors.toSet());
            new DraftBillLockCache(pageId).release(releaseIds);
        }
    }

    private BigDecimal getTransAmount(PayScheCalcModel scheData) {
        BigDecimal transAmount = BigDecimal.ZERO;
        List<PayScheDraftInfo> payScheDraftInfos = scheData.getPayScheDraftInfos();
        if (EmptyUtil.isEmpty(payScheDraftInfos)) {
            return scheData.getDraftBillAmt();
        }
        for (int inx = 0; inx < payScheDraftInfos.size(); ++inx) {
            PayScheDraftInfo payScheDraftInfo = payScheDraftInfos.get(inx);
            transAmount = transAmount.add(payScheDraftInfo.getTransferAmt());
        }
        return transAmount;
    }
}

