/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.common.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.tmc.tda.extpoint.finance.IFinanceDataFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.FinanceDataHandle;
import kd.tmc.tda.common.helper.FinanceFieldLeaseConvert;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.common.helper.SysParamHelper;
import kd.tmc.tda.common.helper.TdaParameterHelper;

public class FinanceDataHelper {
    private static final Log logger = LogFactory.getLog(FinanceDataHelper.class);
    private static final String selectfields = "0 as sourcetype,case when loantype = 'entrust' or loantype = 'ec' then 2 else case when loantype = 'bond' then 1 else case when ( loantype = 'loan' or loantype = 'sl' ) and creditortype = 'bank' then 0 else 3 end end end as financetype,org,org as company,billno,contractno,contractname,finproduct.id as finproduct,finproduct.name as finproductname,finproduct.equitytool as isequity,creditortype,textcreditor,case when region = 'R1' then 1 else 0 end as region,region as realregion,currency.id as currency,currency.number as currencynumber,currency.name as currencyname,drawamount,startintdate,expiredate,bizdate,firstredeemdate,firstredeemterm,term,case when interesttype = 'fixed' or interesttype = 'agree' then 'fixed' else 'float' end as interesttype,basis,loanrate,0 as repayedamount,'' as residueterm,0 as repayamount,0 as repayamountsum,finproduct.perpetualbond as perpetualbond,creditor,0L as creditorinnerorg,loantype,cleardate,ratefloatpoint,rateadjustcycletype,rateadjustcycle,startloanrate,repaymentway,settleintmode,loancontractbill.guarantee as guarantee,drawway,renewalexpiredate,rateadjustdate,referencerate,0.0 as referenceratevalue,case when renewalexpiredate is null then 0 else 1 end as isrenewal,banksyndicate_entry.e_bank.bank_cate.id as ebankcate,banksyndicate_entry.e_bank.bank_cate.name as ebankcatename,banksyndicate_entry.e_bank.name as ebankname,banksyndicate_entry.e_shareamount as edrawamount,banksyndicate_entry.e_bank.org as ebankorg,banksyndicate_entry.e_bank.finorgtype.type as ebanktype,id";
    private static final String leaseselectfields = "3 as sourcetype,3 as financetype,org,org as company,billno,contractno,contractname,finproduct.id as finproduct,finproduct.name as finproductname,creditortype,textcreditor,case when region = 'R1' then 1 else 0 end as region,region as realregion,currency.id as currency,currency.number as currencynumber,currency.name as currencyname,amount as drawamount,startdate as startintdate,enddate as expiredate,bizdate,null as firstredeemdate,'' as firstredeemterm,term,case when interesttype = 'fixed' or interesttype = 'agree' then 'fixed' else 'float' end as interesttype,basis,0.0 as loanrate,0 as financemode,0 as repayedamount,'' as residueterm,0 as repayamount,0 as repayamountsum,creditor,0L as creditorinnerorg,'lease' as loantype,null as cleardate,ratefloatpoint,rateadjustcycletype,rateadjustcycle,startinterestrate as startloanrate,repaymentway,settleintmode,guarantee,'' as drawway,null as renewalexpiredate,null as rateadjustdate,referencerate,0.0 as referenceratevalue,0 as isrenewal,id";

    public static DataSet getFinanceDataSet(String algoKey, List<Long> allorgids, Date queryDate, Long baseCurrency, Long orgViewId, Long orgId) {
        DataSet result;
        long start = System.currentTimeMillis();
        String cacheKey = FinanceDataHelper.getCacheKey(orgViewId, queryDate);
        boolean isQueryDataCache = SysParamHelper.getQueryCacheFlag();
        boolean isNoCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        if (isQueryDataCache && !isNoCache) {
            List allViewOrgs = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
            result = CacheManager.getCacheOrElseGet((Long)orgViewId, (String)algoKey, (String)cacheKey, () -> FinanceDataHelper.getAllViewData(algoKey, queryDate, baseCurrency, orgViewId, allViewOrgs));
            result = result.filter("org in allorgids", Collections.singletonMap("allorgids", allorgids));
        } else {
            result = FinanceDataHelper.getAllViewData(algoKey, queryDate, baseCurrency, orgViewId, allorgids);
        }
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet[] splitMergeDataSet = result.splitByFilter(new String[]{"creditorinnerorg = 0"}, true);
        result = splitMergeDataSet[0];
        DataSet mergeDataSet = MergeOffsetHandler.addMergeOffsetField((DataSet)splitMergeDataSet[1], (DataSet)orgDateSet, (String)"repayamount", (Long)orgId);
        result = result.union(mergeDataSet.select(result.getRowMeta().getFieldNames()));
        result = FinanceDataHelper.filterData(result);
        logger.info("\u878d\u8d44\u53d6\u6570\u8017\u65f6" + algoKey + "cost : " + (System.currentTimeMillis() - start));
        return result;
    }

    public static DataSet getAllViewData(String algoKey, Date queryDate, Long baseCurrency, Long orgViewId, List<Long> allViewOrgs) {
        boolean containCompany = TdaParameterHelper.getFinCompanyFlag();
        boolean containSettleData = TdaParameterHelper.getFinSettleFinFlag();
        QFilter filter = FinanceDataHelper.getQFilter(allViewOrgs, queryDate, containCompany, containSettleData);
        DataSet result = QueryServiceHelper.queryDataSet((String)(algoKey + "getFinanceDataSet"), (String)"cfm_loanbill", (String)selectfields, (QFilter[])new QFilter[]{filter}, null);
        result = new FinanceDataHandle(result, queryDate).handleConvert();
        result = result.removeFields(new String[]{"edrawamount", "ebankcate", "ebankcatename", "ebankname", "ebankorg", "ebanktype"});
        QFilter leaseFilter = FinanceDataHelper.getLeaseQfilter(allViewOrgs, queryDate);
        String leaseFormId = FinanceDataHelper.getLeaseFormId();
        DataSet leaseDataSet = QueryServiceHelper.queryDataSet((String)(algoKey + "getFinanceDataSet"), (String)leaseFormId, (String)leaseselectfields, (QFilter[])new QFilter[]{leaseFilter}, null);
        leaseDataSet = new FinanceFieldLeaseConvert(leaseDataSet, queryDate).convertSource();
        String[] fieldNames = result.getRowMeta().getFieldNames();
        result = result.union(leaseDataSet.select(fieldNames));
        result = result.addFields(new String[]{"repayamount", "drawamount", "repayedamount"}, new String[]{"srcrepayamount", "srcdrawamount", "srcrepayedamount"});
        result = AmountTransHelper.tranDataSetRate((DataSet)result, (Long)orgViewId, (Long)baseCurrency, (String)"currency", Arrays.asList("repayamount", "drawamount", "repayedamount", "repayamountsum").stream().collect(Collectors.toSet()), (Date)queryDate);
        result = result.addFields(new String[]{"0.0", "0.0"}, new String[]{MergeOffsetHandler.ROW_OFFSETFILENAME, MergeOffsetHandler.COL_OFFSETFILENAME});
        List allViewOrgIds = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
        return FinanceDataHelper.handleGroup(result, allViewOrgIds);
    }

    private static DataSet handleGroup(DataSet result, List<Long> allViewOrgs) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>(4);
        paramMap.put("innerorg", allViewOrgs);
        QFilter isOutGroupFilter = new QFilter("creditorinnerorg", "in", (Object)"innerorg");
        String[] exprArr = new String[]{isOutGroupFilter.toString().replace("'", "")};
        DataSet[] dataSets = DataSetHelper.splitByFilter((DataSet)result, (String[])exprArr, paramMap, (boolean)true);
        dataSets[0] = dataSets[0].updateField("isoutgroup", "0");
        dataSets[1] = dataSets[1].updateField("isoutgroup", "1");
        return dataSets[0].union(dataSets[1]);
    }

    public static String getLeaseFormId() {
        return "fl_leasecontractbill";
    }

    public static QFilter getQFilter(List<Long> allorgids, Date queryDate, boolean containCompany, boolean containSettleData) {
        QFilter qFilter = new QFilter("org", "in", allorgids);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("startintdate", "<=", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)false));
        qFilter.and(new QFilter("cleardate", ">", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)false)).or(new QFilter("cleardate", "is null", null)));
        QFilter bankFilter = new QFilter("loantype", "in", Arrays.asList("loan", "sl"));
        if (!containSettleData) {
            bankFilter.and("creditortype", "!=", (Object)"settlecenter");
        }
        QFilter companyFilter = new QFilter("loantype", "in", Arrays.asList("entrust", "ec"));
        QFilter bonfFilter = new QFilter("loantype", "=", (Object)"bond");
        QFilter loadTypeFilter = containCompany ? bankFilter.or(companyFilter).or(bonfFilter) : bankFilter.or(bonfFilter);
        return qFilter.and(loadTypeFilter);
    }

    public static QFilter getLeaseQfilter(List<Long> allorgids, Date queryDate) {
        QFilter qFilter = new QFilter("org", "in", allorgids);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("contractstatus", "not in", Arrays.asList("A", "B"));
        qFilter.and("loantype", "=", (Object)"finlease");
        qFilter.and("startdate", "<=", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)false));
        qFilter.and("enddate", ">", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)false));
        return qFilter;
    }

    public static String getCacheKey(Long orgviewId, Date queryDate) {
        return "financeDataHelper-cachekey-" + orgviewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd");
    }

    private static DataSet filterData(DataSet result) {
        String filter = "";
        PluginProxy pluginProxy = PluginProxy.create(IFinanceDataFilter.class, (String)"kd.sdk.tmc.tda.extpoint.finance.IFinanceDataFilter");
        List resultList = pluginProxy.callReplace(p -> p.getFilter());
        if (EmptyUtil.isNoEmpty((Object)resultList)) {
            filter = (String)resultList.get(0);
        }
        if (!EmptyUtil.isEmpty((String)filter)) {
            return result.filter(filter);
        }
        return result;
    }
}

