/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.tmc.tda.extpoint.bankacct.IBankAcctInterface;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.enums.BankAcctDateRangeEnum;
import kd.tmc.tda.common.enums.TdaFinOrgTypeEnum;
import kd.tmc.tda.common.helper.BasicParamHelper;
import kd.tmc.tda.common.helper.BasicParamSetFormDataHelper;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.helper.SysParamHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class BankAcctHelper {
    private static final Log logger = LogFactory.getLog(BankAcctHelper.class);
    public static final String BANKCATE = "bankcate";
    public static final String PREFIX = "bankcate_";
    public static final String FINCOMP_ID = TdaFinOrgTypeEnum.FINCOMP.getValue();
    public static final String SETTLE_ID = TdaFinOrgTypeEnum.CLEARINGHOUSE.getValue();
    public static final String TRDPARTPAY_ID = TdaFinOrgTypeEnum.TRDPARTPAY.getValue();
    public static final String OTHERACCT_ID = TdaFinOrgTypeEnum.OTHERACCT.getValue();
    private static String QUERY_DATE = "querydate";
    public static final String ACCT_USAGE_ID = "acctusageid";
    public static final String USAGE_LONG_NUMBER = "usagelongnumber";
    public static final String ACCOUNT_ID = "accountid";
    public static final String HEAD_APPLYDATE = "applydate";
    public static final String MIN_DATE = "minDate";
    public static final String DATE_SUB = "dateSub";
    public static final String OP_DATE = "opDate";
    public static final String DATE_RANGE = "dateRange";
    public static final String DATE_RANGE_NAME = "dateRangeName";
    public static final String DATE_RANGE_SORT = "dateRangeSort";

    private static QFilter[] getFilter(List<Long> allOrgIds, Map<String, Object> reportQueryMap) {
        Date queryDate = DateUtils.getNextDay((Date)DecisionAnlsHelper.getQueryDate(reportQueryMap), (int)1);
        QFilter qFilter = new QFilter("openorg", "in", allOrgIds).and("opendate", "<", (Object)queryDate);
        QFilter qFilterExt = BankAcctHelper.getQFilterExt(qFilter);
        return qFilterExt.toArray();
    }

    public static Set<String> getFieldNameSet(String[] ... fields) {
        HashSet<String> fieldNames = new HashSet<String>(Arrays.asList(fields[0]));
        for (int i = 1; i < fields.length; ++i) {
            fieldNames.addAll(Arrays.asList(fields[i]));
        }
        return fieldNames;
    }

    public static DataSet query(String algoKey, Map<String, Object> paramMap) {
        Date queryDate = DateUtils.getNextDay((Date)DecisionAnlsHelper.getQueryDate(paramMap), (int)1);
        DataSet dataSet = BankAcctHelper.queryCacheOrElseGet(algoKey, paramMap);
        DataSet resultSet = dataSet.filter("closedate is null or closedate >= queryDate", Collections.singletonMap("queryDate", queryDate));
        return resultSet;
    }

    public static DataSet queryUncloseacct(String algoKey, Map<String, Object> paramMap) {
        return BankAcctHelper.queryCacheOrElseGet(algoKey, paramMap);
    }

    private static DataSet queryCacheOrElseGet(String algoKey, Map<String, Object> paramMap) {
        DataSet result;
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        List orgIds = (List)paramMap.get("allorgids");
        String cacheKey = BankAcctHelper.getCacheKey(paramMap);
        boolean isQueryDataCache = SysParamHelper.getQueryCacheFlag();
        boolean isNoCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        if (isQueryDataCache && !isNoCache) {
            List allOrgIds = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
            result = CacheManager.getCacheOrElseGet((Long)orgViewId, (String)algoKey, (String)cacheKey, () -> BankAcctHelper.queryAccountSet(paramMap, allOrgIds));
            result = result.filter("org in orgIds", Collections.singletonMap("orgIds", orgIds));
        } else {
            result = BankAcctHelper.queryAccountSet(paramMap, orgIds);
        }
        return result;
    }

    private static DataSet queryAccountSet(Map<String, Object> paramMap, List<Long> orgIds) {
        QFilter[] filter = BankAcctHelper.getFilter(orgIds, paramMap);
        return BankAcctHelper.queryAccountSet(filter);
    }

    public static DataSet queryAccountSet(QFilter[] filter) {
        String selectFields = "id, openorg org, openorg.number org_number, openorg.name as org_name, company.name companyname, acctname, name acctsimplename, acctstyle, acctproperty acctusageid, acctproperty.name acctusagename, accttype, case when issetbankinterface = '1' then 'bi_true'  else 'bi_false' end as bankinterface, case when bank.country.twocountrycode = 'CN' OR bank.country.threecountrycode = 'CHN' OR bank.country = 0 OR ((bank.country.twocountrycode = NULL OR TRIM(bank.country.twocountrycode) = '') AND (bank.country.threecountrycode = NULL OR TRIM(bank.country.threecountrycode) = '')) then 'domestic' else 'overseas' end as areas,bank.province.name province, bank.city.name city,case when finorgtype in ('0','1','3','4') then TO_CHAR(finorgtype) else '999' end as finorgtype,bankaccountnumber, bank.bank_cate as bankcate, bank.bank_cate.name as bankname, bank.name finorgname, '' as currencyname, defaultcurrency.name defaultcurrency,isopenbank, bebankfunc, opendate, closedate, acctstatus";
        String selectFieldsExt = BankAcctHelper.getSelectFieldsExt();
        if (StringUtils.isNotEmpty((String)selectFieldsExt)) {
            selectFields = selectFields + "," + selectFieldsExt;
        }
        DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"BankAcctSum", (String)BankAcctHelper.getMetadataSignExt(), (String)selectFields, (QFilter[])filter, null);
        Set acctUsageIds = DecisionCommonHelper.getFieldValues((DataSet)bankAcctSet.copy(), (String)ACCT_USAGE_ID, Long.class);
        DataSet acctUsageSet = BankAcctHelper.getAcctUsageSet(acctUsageIds);
        DataSet resultSet = bankAcctSet.leftJoin(acctUsageSet).on(ACCT_USAGE_ID, "id").select(bankAcctSet.getRowMeta().getFieldNames(), new String[]{USAGE_LONG_NUMBER}).finish();
        return resultSet;
    }

    public static DataSet getAcctChangeSet(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Date queryDate = DateUtils.getNextDay((Date)DecisionAnlsHelper.getQueryDate(paramMap), (int)1);
        Map<String, Object> dateRangeMap = BankAcctHelper.getDateRangeMap(DecisionAnlsHelper.getQueryDate(paramMap));
        Date mindate = (Date)dateRangeMap.get(MIN_DATE);
        QFilter filter = new QFilter(HEAD_APPLYDATE, "<", (Object)queryDate).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        return CacheManager.getCacheOrElseGet((Long)orgViewId, (String)"BankAcctSum-change", (String)("BankAcctSum-change_" + queryDate.getTime()), () -> QueryServiceHelper.queryDataSet((String)"BankAcctSum-change", (String)"am_changeapply", (String)"entryentity2.id id, entryentity2.e_accountbank accountid,auditdate,applydate", (QFilter[])filter.toArray(), null));
    }

    public static String getCacheKey(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        return "bankAcctHelper-cachekey-" + orgViewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd");
    }

    private static DataSet getAcctUsageSet(Set<Long> acctUsageIds) {
        DataSet usageSet = QueryServiceHelper.queryDataSet((String)"BankAcctSum-usage", (String)"bd_acctpurpose", (String)"id,longnumber usagelongnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", acctUsageIds)}, null);
        return usageSet.filter("usagelongnumber is not null and usagelongnumber != ''");
    }

    public static Map<String, ValueMapItem> getEnumItemsByProperty(String property) {
        MainEntityType bd_accountbanks = MetadataServiceHelper.getDataEntityType((String)BankAcctHelper.getMetadataSignExt());
        List propertyItems = ((ComboProp)bd_accountbanks.getProperty(property)).getComboItems();
        return propertyItems.stream().collect(Collectors.toMap(ValueMapItem::getValue, valueItem -> valueItem));
    }

    public static List<String> getZeroColNames(DataSet totalRow, List<String> countFields) {
        ArrayList<String> zeroColNames = new ArrayList<String>(countFields.size());
        Iterator iterator = totalRow.copy().iterator();
        if (iterator.hasNext()) {
            Row total = (Row)iterator.next();
            Iterator<String> fieldNameIterator = countFields.iterator();
            while (fieldNameIterator.hasNext()) {
                String fieldName = fieldNameIterator.next();
                Integer value = total.getInteger(fieldName);
                if (value != null && value != 0) continue;
                zeroColNames.add(fieldName);
                fieldNameIterator.remove();
            }
        }
        return zeroColNames;
    }

    public static Map<String, Object> getDateRangeMap(Date queryDate) {
        LinkedHashMap<String, Object> dateMap = new LinkedHashMap<String, Object>(8);
        Date currentMonth = DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)0);
        Date currentYear = DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)(-currentMonth.getMonth()));
        Date threeMonth = DateUtils.getLastMonth((Date)queryDate, (int)3);
        Date sixMonth = DateUtils.getLastMonth((Date)queryDate, (int)6);
        dateMap.put(BankAcctDateRangeEnum.CURRENT_MONTH.getValue(), currentMonth);
        dateMap.put(BankAcctDateRangeEnum.THREE_MONTH.getValue(), threeMonth);
        dateMap.put(BankAcctDateRangeEnum.SIX_MONTH.getValue(), sixMonth);
        dateMap.put(BankAcctDateRangeEnum.CURRENT_YEAR.getValue(), currentYear);
        dateMap.put(QUERY_DATE, DateUtils.getNextDay((Date)queryDate, (int)1));
        BankAcctHelper.getMinDate(dateMap);
        return dateMap;
    }

    private static void getMinDate(Map<String, Object> dateMap) {
        long asLong = dateMap.values().stream().mapToLong(value -> ((Date)value).getTime()).min().getAsLong();
        Date minDate = new Date(asLong);
        dateMap.put(MIN_DATE, minDate);
    }

    public static DataSet[] getDateRangeDataSets(DataSet dataSet, Map<String, Object> dateRangeMap) {
        dataSet = dataSet.addField("TO_CHAR(opDate,'yyyyMMdd')", DATE_SUB);
        DataSet[] dataSets = dataSet.splitByFilter(new String[]{"dateSub >= " + DateUtils.formatString((Date)((Date)dateRangeMap.get(BankAcctDateRangeEnum.CURRENT_MONTH.getValue())), (String)"yyyyMMdd"), "dateSub >= " + DateUtils.formatString((Date)((Date)dateRangeMap.get(BankAcctDateRangeEnum.THREE_MONTH.getValue())), (String)"yyyyMMdd"), "dateSub >= " + DateUtils.formatString((Date)((Date)dateRangeMap.get(BankAcctDateRangeEnum.SIX_MONTH.getValue())), (String)"yyyyMMdd"), "dateSub >= " + DateUtils.formatString((Date)((Date)dateRangeMap.get(BankAcctDateRangeEnum.CURRENT_YEAR.getValue())), (String)"yyyyMMdd")}, false);
        return dataSets;
    }

    public static Map<Object, DynamicObject> queryAccountCurrency(Map<String, Object> paramMap) {
        List quaryOrgIds = (List)paramMap.get("allorgids");
        QFilter[] filter = BankAcctHelper.getFilter(quaryOrgIds, paramMap);
        String selectFields = "id, currency";
        DynamicObject[] accountCurrencyCollection = BusinessDataServiceHelper.load((String)BankAcctHelper.getMetadataSignExt(), (String)selectFields, (QFilter[])filter);
        return Arrays.stream(accountCurrencyCollection).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
    }

    public static Set<String> getAmFinOrgTypeConfigs() {
        String acctRangeStr = BasicParamHelper.getBasicParamGenericConfigs((String)"tda_acct_queryparamset", (String)"acctrange");
        if (EmptyUtil.isEmpty((String)acctRangeStr)) {
            return new HashSet<String>(4);
        }
        return Stream.of(acctRangeStr.split(",")).filter(s -> EmptyUtil.isNotBlank((CharSequence)s)).collect(Collectors.toSet());
    }

    public static DataSet[] getAcctSetByFinOrgTypeConfigs(DataSet dataSet) {
        Set<String> amFinOrgTypeConfigs = BankAcctHelper.getAmFinOrgTypeConfigs();
        amFinOrgTypeConfigs.add(TdaFinOrgTypeEnum.BANK.getValue());
        amFinOrgTypeConfigs.add(TdaFinOrgTypeEnum.FINCOMP.getValue());
        dataSet = dataSet.filter("finorgtype in configs", Collections.singletonMap("configs", amFinOrgTypeConfigs));
        DataSet[] allAcctSets = dataSet.splitByFilter(new String[]{"finorgtype = '0'", "finorgtype = '1'", "finorgtype = '3'", "finorgtype = '4'", "finorgtype = '999'"}, false);
        return allAcctSets;
    }

    public static DataSet getUnBankAcctSet(DataSet[] allAcctSets) {
        DataSet settleSet = allAcctSets[1].updateField(BANKCATE, SETTLE_ID);
        DataSet finCompAcctSet = allAcctSets[2].updateField(BANKCATE, FINCOMP_ID);
        DataSet trdacctSet = allAcctSets[3].updateField(BANKCATE, TRDPARTPAY_ID);
        DataSet othacctSet = allAcctSets[4].updateField(BANKCATE, OTHERACCT_ID);
        DataSet unionSet = settleSet.union(new DataSet[]{finCompAcctSet, trdacctSet, othacctSet});
        return unionSet;
    }

    public static String getSelectFieldsExt() {
        PluginProxy pluginProxy = PluginProxy.create(IBankAcctInterface.class, (String)"kd.sdk.tmc.tda.extpoint.bankacct.IBankAcctInterface.selectFieldsExt");
        List resultList = pluginProxy.callReplace(p -> p.selectFieldsExt());
        if (EmptyUtil.isNoEmpty((Object)resultList) && EmptyUtil.isNoEmpty((String)((String)resultList.get(0)))) {
            logger.info("IBankAcctInterface.selectFieldsExt \u8fd4\u56de\u7ed3\u679c\uff1a" + (String)resultList.get(0));
            return (String)resultList.get(0);
        }
        logger.info("IBankAcctInterface.selectFieldsExt \u62d3\u5c55\u8fd4\u56de\u4e3a\u7a7a");
        return "";
    }

    public static QFilter getQFilterExt(QFilter qFilter) {
        PluginProxy pluginProxy = PluginProxy.create(IBankAcctInterface.class, (String)"kd.sdk.tmc.tda.extpoint.bankacct.IBankAcctInterface.qFilterExt");
        List resultList = pluginProxy.callReplace(p -> p.qFilterExt(qFilter));
        if (EmptyUtil.isNoEmpty((Object)resultList) && EmptyUtil.isNoEmpty(resultList.get(0))) {
            logger.info("IBankAcctInterface.qFilterExt \u4e0d\u4e3a\u7a7a");
            return (QFilter)resultList.get(0);
        }
        logger.info("IBankAcctInterface.qFilterExt \u62d3\u5c55\u8fd4\u56de\u4e3a\u7a7a");
        return qFilter;
    }

    public static String getMetadataSignExt() {
        PluginProxy pluginProxy = PluginProxy.create(IBankAcctInterface.class, (String)"kd.sdk.tmc.tda.extpoint.bankacct.IBankAcctInterface.metadataSignExt");
        List resultList = pluginProxy.callReplace(p -> p.metadataSignExt());
        if (EmptyUtil.isNoEmpty((Object)resultList) && EmptyUtil.isNoEmpty((String)((String)resultList.get(0)))) {
            logger.info("IBankAcctInterface.metadataSignExt \u8fd4\u56de\u7ed3\u679c:" + (String)resultList.get(0));
            return (String)resultList.get(0);
        }
        logger.info("IBankAcctInterface.metadataSignExt \u62d3\u5c55\u8fd4\u56de\u4e3a\u7a7a");
        return "bd_accountbanks";
    }

    public static String getDormantConfig() {
        QFilter qFilter = new QFilter("name", "=", (Object)"tda_acct_queryparamset");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tda_param_basic", (String)"id,nodeid,params_tag", (QFilter[])qFilter.toArray());
        String dormantRange = "transdetail";
        if (EmptyUtil.isNoEmpty((DynamicObject)dynamicObject)) {
            String dormantRangeConfig;
            DynamicObject dynamicObjectTag;
            String jsonString = (String)dynamicObject.get("params_tag");
            if (EmptyUtil.isEmpty((String)jsonString)) {
                return dormantRange;
            }
            MainEntityType subMainType = EntityMetadataCache.getDataEntityType((String)"tda_acct_queryparamset");
            DataEntityPropertyCollection dataEntityProperties = subMainType.getProperties();
            if (jsonString != null) {
                jsonString = BasicParamSetFormDataHelper.checkBuildJsonParamStr((String)jsonString, (DataEntityPropertyCollection)dataEntityProperties, (DynamicObject)dynamicObject, (Integer)0);
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(dynamicObjectTag = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)jsonString, (IDataEntityType)subMainType))) && EmptyUtil.isNoEmpty((String)(dormantRangeConfig = dynamicObjectTag.getString("dormantrange")))) {
                dormantRange = dormantRangeConfig;
            }
        }
        return dormantRange;
    }
}

