/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.qing;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DraftBillDataHelper;
import kd.tmc.tda.common.helper.DraftBillUpdateFieldFunction;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public abstract class AbstractDraftBillSecAccurdPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String ORGID = "orgid";
    private static final String AMOUNT = "amount";
    public static final String PERIODNAME = "periodname";
    private static final String CLICK = "click";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{"mixorgname", ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"AbstractDraftBillSecAccurdPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), Boolean.FALSE});
        fields.add(new Object[]{"customtype", ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b", (String)"AbstractDraftBillSecAccurdPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), Boolean.FALSE});
        fields.add(new Object[]{PERIODNAME, ResManager.loadKDString((String)"\u671f\u95f4", (String)"AbstractDraftBillSecAccurdPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), Boolean.FALSE});
        fields.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u53d1\u751f\u989d", (String)"AbstractDraftBillSecAccurdPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), Boolean.FALSE});
        fields.add(new Object[]{CLICK, ResManager.loadKDString((String)"\u7a7f\u900f\u5b57\u6bb5", (String)"AbstractDraftBillAmountDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), Boolean.FALSE});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List allorgids = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgViewId, Collections.singletonList(orgId), (boolean)true);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet billAccruedDataSet = DraftBillDataHelper.getBillAccruedDataSet((String)this.createAlgoKey(""), (List)allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (String)this.getRpType());
        DataSet[] billAccruedDataSets = DraftBillDataHelper.getDateRangeDataSet((DataSet)billAccruedDataSet, (Date)queryDate, null, (boolean)true);
        if (billAccruedDataSets.length == 0 || billAccruedDataSets[0].isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet((String[])new String[]{"mixorgname", "customtype", PERIODNAME, AMOUNT, CLICK}, (DataType[])new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.BigDecimalType, DataType.StringType});
        }
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        billAccruedDataSet = billAccruedDataSets[0];
        billAccruedDataSet = orgDateSet.copy().leftJoin(billAccruedDataSet).on(ORGID, ORGID).select(new String[]{"longnumber", "level", "customtype", "datetype", AMOUNT}).finish();
        billAccruedDataSet = billAccruedDataSet.filter("customtype is not null and datetype is not null");
        Integer level = orgDateSet.copy().filter("orgid = " + orgId).next().getInteger("level");
        billAccruedDataSet = billAccruedDataSet.filter("level > " + level).addField("''", PERIODNAME);
        billAccruedDataSet = DraftBillUpdateFieldFunction.updateFields((DataSet)billAccruedDataSet, (DraftBillUpdateFieldFunction[])new DraftBillUpdateFieldFunction[]{DraftBillUpdateFieldFunction.orgLongNumberUpdateFunction((Integer)(level + 1)), DraftBillUpdateFieldFunction.dateTypeUpdateFunction((Date)queryDate, (String)PERIODNAME)});
        billAccruedDataSet = billAccruedDataSet.groupBy(new String[]{"longnumber", "customtype", PERIODNAME}).sum(AMOUNT).finish();
        orgDateSet = orgDateSet.filter("level = " + (level + 1));
        billAccruedDataSet = billAccruedDataSet.leftJoin(orgDateSet).on("longnumber", "longnumber").select(new String[]{"mixorgname", "customtype", PERIODNAME, AMOUNT}).finish();
        billAccruedDataSet = billAccruedDataSet.addField("concat(customtype,'_',periodname)", CLICK);
        return billAccruedDataSet;
    }

    protected DataSet filterResultDataSet(DataSet ds, Map<String, Object> filterParam) {
        Pair typeLinkValue = TdaCommonHelper.getTypeLinkValue((IPageCache)this.getPageCache(), filterParam, (String)"termtype", (String)"term");
        String termType = (String)typeLinkValue.getValue0();
        String term = (String)typeLinkValue.getValue1();
        if (EmptyUtil.isNoEmpty((String)termType) && EmptyUtil.isNoEmpty((String)term)) {
            String filter = "customtype = '" + termType + "' and " + PERIODNAME + " = '" + term + "'";
            return ds.filter(filter);
        }
        return ds;
    }

    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.getCustomParams().put(CLICK, ids.get(0));
        parameter.setFormId(this.getLinkRptFormId());
        String caption = "paybill".equals(this.getRpType()) ? ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u53d1\u751f\u989d\u5355\u4f4d\u5206\u5e03\u8868", (String)"AbstractDraftBillSecAccurdPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u53d1\u751f\u989d\u5355\u4f4d\u5206\u5e03\u8868", (String)"AbstractDraftBillSecAccurdPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]);
        parameter.setCaption(caption);
        this.fireLinkageShowForm(view, parameter);
    }

    protected String getFormPrimaryKey(String reportId) {
        return CLICK;
    }

    protected List<String> getLinkReport() {
        return Collections.singletonList(this.getLinkRptFormId());
    }

    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        param.getCustomParams().put(CLICK, paramMap.get("termtype") + "_" + paramMap.get("term"));
    }

    protected abstract String getRpType();

    protected abstract String getLinkRptFormId();
}

